/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.Splitter;
import org.eclipse.swt.widgets.Composite;

public abstract class GraphicalEditorWithPalette
extends GraphicalEditor {
    private static final int PALETTE_SIZE = 125;
    private PaletteViewer paletteViewer;

    protected void configurePaletteViewer() {
    }

    protected void createPaletteViewer(Composite parent) {
        PaletteViewer viewer = new PaletteViewer();
        this.setPaletteViewer(viewer);
        viewer.createControl(parent);
        this.configurePaletteViewer();
        this.hookPaletteViewer();
        this.initializePaletteViewer();
    }

    @Override
    public void createPartControl(Composite parent) {
        Splitter splitter = new Splitter(parent, 256);
        this.createPaletteViewer(splitter);
        this.createGraphicalViewer(splitter);
        splitter.maintainSize(this.getPaletteViewer().getControl());
        splitter.setFixedSize(this.getInitialPaletteSize());
        splitter.addFixedSizeChangeListener(evt -> this.handlePaletteResized(((Splitter)((Object)((Object)evt.getSource()))).getFixedSize()));
    }

    protected abstract PaletteRoot getPaletteRoot();

    protected int getInitialPaletteSize() {
        return 125;
    }

    protected PaletteViewer getPaletteViewer() {
        return this.paletteViewer;
    }

    protected void handlePaletteResized(int newSize) {
    }

    protected void hookPaletteViewer() {
        this.getEditDomain().setPaletteViewer(this.paletteViewer);
    }

    protected void initializePaletteViewer() {
    }

    protected void setPaletteViewer(PaletteViewer paletteViewer) {
        this.paletteViewer = paletteViewer;
    }

    @Override
    protected void setEditDomain(DefaultEditDomain ed) {
        super.setEditDomain(ed);
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
    }
}

