#
# Float types
#

# $extra_col_opts is set by a calling test
# $extra_col_opts_ddl_err is set by a calling test
# $extra_col_opts_dml_err is set by a calling test

if ($extra_col_opts_ddl_err == 0)
{
  eval CREATE TABLE t1 (
    f FLOAT $extra_col_opts,
    f0 FLOAT(0) $extra_col_opts,
    r1_1 REAL(1,1) $extra_col_opts,
    f23_0 FLOAT(23) $extra_col_opts,
    f20_3 FLOAT(20,3) $extra_col_opts,
    d DOUBLE $extra_col_opts,
    d1_0 DOUBLE(1,0) $extra_col_opts,
    d10_10 DOUBLE PRECISION (10,10) $extra_col_opts,
    d53 DOUBLE(53,0) $extra_col_opts,
    d53_10 DOUBLE(53,10) $extra_col_opts,
    pk DOUBLE $extra_col_opts PRIMARY KEY
  ) ENGINE=rocksdb;
}
if ($extra_col_opts_ddl_err == 1)
{
  # 5.7 uses strict mode by default, so this will now return an error
  --error ER_PRIMARY_CANT_HAVE_NULL
  eval CREATE TABLE t1 (
    f FLOAT $extra_col_opts,
    f0 FLOAT(0) $extra_col_opts,
    r1_1 REAL(1,1) $extra_col_opts,
    f23_0 FLOAT(23) $extra_col_opts,
    f20_3 FLOAT(20,3) $extra_col_opts,
    d DOUBLE $extra_col_opts,
    d1_0 DOUBLE(1,0) $extra_col_opts,
    d10_10 DOUBLE PRECISION (10,10) $extra_col_opts,
    d53 DOUBLE(53,0) $extra_col_opts,
    d53_10 DOUBLE(53,10) $extra_col_opts,
    pk DOUBLE $extra_col_opts PRIMARY KEY
  ) ENGINE=rocksdb;

  # 5.7 _requires_ a not NULL PK and can't mimick 5.6 behavior, so we are
  # adding in a fake key to satisfy and allow the test to resume
  eval CREATE TABLE t1 (
    f FLOAT $extra_col_opts,
    f0 FLOAT(0) $extra_col_opts,
    r1_1 REAL(1,1) $extra_col_opts,
    f23_0 FLOAT(23) $extra_col_opts,
    f20_3 FLOAT(20,3) $extra_col_opts,
    d DOUBLE $extra_col_opts,
    d1_0 DOUBLE(1,0) $extra_col_opts,
    d10_10 DOUBLE PRECISION (10,10) $extra_col_opts,
    d53 DOUBLE(53,0) $extra_col_opts,
    d53_10 DOUBLE(53,10) $extra_col_opts,
    pk DOUBLE $extra_col_opts,
    fake_key INT NOT NULL AUTO_INCREMENT,
    PRIMARY KEY (fake_key)
  ) ENGINE=rocksdb;
}

SHOW COLUMNS IN t1;

# Always valid values

INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (12345.12345,12345.12345,0.9,123456789.123,56789.987,11111111.111,8.0,0.0123456789,1234566789123456789,99999999999999999.99999999,1);

--sorted_result
--query_vertical SELECT f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10 FROM t1

INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (0,0,0,0,0,0,0,0,0,0,2);

# 5.7 uses strict mode by default, so this will now return an error
--error ER_WARN_DATA_OUT_OF_RANGE
INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (
  99999999999999999999999999999999999999,
  99999999999999999999999999999999999999.9999999999999999,
  0.9,
  99999999999999999999999999999999999999.9,
  99999999999999999.999,
  999999999999999999999999999999999999999999999999999999999999999999999999999999999,
  9,
  0.9999999999,
  1999999999999999999999999999999999999999999999999999999,
  19999999999999999999999999999999999999999999.9999999999,
  3
);

# now test with the 5.6 behavior just to be sure
set @orig_sql_mode=@@session.sql_mode;
set session sql_mode="";
INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (
  99999999999999999999999999999999999999,
  99999999999999999999999999999999999999.9999999999999999,
  0.9,
  99999999999999999999999999999999999999.9,
  99999999999999999.999,
  999999999999999999999999999999999999999999999999999999999999999999999999999999999,
  9,
  0.9999999999,
  1999999999999999999999999999999999999999999999999999999,
  19999999999999999999999999999999999999999999.9999999999,
  3
);
set session sql_mode=@orig_sql_mode;

--sorted_result
--query_vertical SELECT f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10 FROM t1

# Values which can be valid or not,
# depending on whether columns are SIGNED or UNSIGNED
# (if not valid should produce warnings)

if ($extra_col_opts_dml_err == 0)
{
  INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (-999999999999999999999999,-99999999999.999999999999,-0.9,-999.99999999999999999999,-99999999999999999.999,-999999999999999999999999999999999999999999999999999999999999-0.999,-9,-.9999999999,-999999999999999999999999999999.99999999999999999999999,-9999999999999999999999999999999999999999999.9999999999,4);
}
if ($extra_col_opts_dml_err == 1)
{
  # 5.7 uses strict mode by default, so this will now return an error
  --error ER_WARN_DATA_OUT_OF_RANGE
  INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (-999999999999999999999999,-99999999999.999999999999,-0.9,-999.99999999999999999999,-99999999999999999.999,-999999999999999999999999999999999999999999999999999999999999-0.999,-9,-.9999999999,-999999999999999999999999999999.99999999999999999999999,-9999999999999999999999999999999999999999999.9999999999,4);

  # now test with the 5.6 behavior just to be sure
  set @orig_sql_mode=@@session.sql_mode;
  set session sql_mode="";
  INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (-999999999999999999999999,-99999999999.999999999999,-0.9,-999.99999999999999999999,-99999999999999999.999,-999999999999999999999999999999999999999999999999999999999999-0.999,-9,-.9999999999,-999999999999999999999999999999.99999999999999999999999,-9999999999999999999999999999999999999999999.9999999999,4);
  set session sql_mode=@orig_sql_mode;
}

--sorted_result
--query_vertical SELECT f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10 FROM t1

--sorted_result
query_vertical
SELECT
  CONCAT('', MAX(f)),
  CONCAT('', MAX(f0)),
  CONCAT('', MAX(r1_1)),
  CONCAT('', MAX(f23_0)),
  CONCAT('', MAX(f20_3)),
  CONCAT('', MAX(d)),
  CONCAT('', MAX(d1_0)),
  CONCAT('', MAX(d10_10)),
  CONCAT('', MAX(d53)),
  CONCAT('', MAX(d53_10)) FROM t1;

# Invalid values

# 5.7 uses strict mode by default, so this will now return an error
--error ER_WARN_DATA_OUT_OF_RANGE
INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  5
);

# now test with the 5.6 behavior just to be sure
set @orig_sql_mode=@@session.sql_mode;
set session sql_mode="";
INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  9999999999999999999999999999999999999999999999999999999999999.9999,
  5
);
set session sql_mode=@orig_sql_mode;

--sorted_result
--query_vertical SELECT f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10 FROM t1

# 5.7 uses strict mode by default, so this will now return an error
--error ER_WARN_DATA_OUT_OF_RANGE
INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (
  999999999999999999999999999999999999999,
  999999999999999999999999999999999999999.9999999999999999,
  1.9,
  999999999999999999999999999999999999999.9,
  999999999999999999.999,
  9999999999999999999999999999999999999999999999999999999999999999999999999999999999,
  99,
  1.9999999999,
  1999999999999999999999999999999999999999999999999999999,
  19999999999999999999999999999999999999999999.9999999999,
  6
);

# now test with the 5.6 behavior just to be sure
set @orig_sql_mode=@@session.sql_mode;
set session sql_mode="";
INSERT INTO t1 (f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10,pk) VALUES (
  999999999999999999999999999999999999999,
  999999999999999999999999999999999999999.9999999999999999,
  1.9,
  999999999999999999999999999999999999999.9,
  999999999999999999.999,
  9999999999999999999999999999999999999999999999999999999999999999999999999999999999,
  99,
  1.9999999999,
  1999999999999999999999999999999999999999999999999999999,
  19999999999999999999999999999999999999999999.9999999999,
  6
);
set session sql_mode=@orig_sql_mode;

--sorted_result
--query_vertical SELECT f,f0,r1_1,f23_0,f20_3,d,d1_0,d10_10,d53,d53_10 FROM t1

--error ER_TOO_BIG_DISPLAYWIDTH
eval ALTER TABLE t1 ADD COLUMN d0_0 DOUBLE(0,0) $extra_col_opts;

--error ER_TOO_BIG_PRECISION
eval ALTER TABLE t1 ADD COLUMN n66_6 DECIMAL(256,1) $extra_col_opts;

--error ER_TOO_BIG_SCALE
eval ALTER TABLE t1 ADD COLUMN n66_66 DECIMAL(40,35) $extra_col_opts;

DROP TABLE t1;
