// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by hack/docgen tool. DO NOT EDIT.

package runtime

import (
	"github.com/siderolabs/talos/pkg/machinery/config/encoder"
)

func (KmsgLogV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KmsgLogConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KmsgLogConfig is a event sink config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KmsgLogConfig is a event sink config document.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the config document.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "url",
				Type:        "URL",
				Note:        "",
				Description: "The URL encodes the log destination.\nThe scheme must be tcp:// or udp://.\nThe path must be empty.\nThe port is required.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The URL encodes the log destination." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleKmsgLogV1Alpha1())

	doc.Fields[2].AddExample("", "udp://10.3.7.3:2810")

	return doc
}

func (EventSinkV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EventSinkConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EventSinkConfig is a event sink config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EventSinkConfig is a event sink config document.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "endpoint",
				Type:        "string",
				Note:        "",
				Description: "The endpoint for the event sink as 'host:port'.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The endpoint for the event sink as 'host:port'." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleEventSinkV1Alpha1())

	doc.Fields[1].AddExample("", "10.3.7.3:2810")

	return doc
}

func (OOMV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "OOMConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "OOMConfig is a Out of Memory handler config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "OOMConfig is a Out of Memory handler config document.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "triggerExpression",
				Type:        "Expression",
				Note:        "",
				Description: "This expression defines when to trigger OOM action.\n\nThe expression must evaluate to a boolean value.\nIf the expression returns true, then OOM ranking and killing will be handled.\n\nThis expression receives the following parameters:\n- memory_{some,full}_{avg10,avg60,avg300,total} - double, representing PSI values\n- time_since_trigger - duration since the last OOM handler trigger event",
				Comments:    [3]string{"" /* encoder.HeadComment */, "This expression defines when to trigger OOM action." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "cgroupRankingExpression",
				Type:        "Expression",
				Note:        "",
				Description: "This expression defines how to rank cgroups for OOM handler.\n\nThe cgroup with the highest rank (score) will be evicted first.\nThe expression must evaluate to a double value.\n\nThis expression receives the following parameters:\n- memory_max - Optional<uint> - in bytes\n- memory_current - Optional<uint> - in bytes\n- memory_peak - Optional<uint> - in bytes\n- path - string, path to the cgroup\n- class - int. This represents cgroup QoS class, and matches one of the constants, which are also provided: Besteffort, Burstable, Guaranteed, Podruntime, System",
				Comments:    [3]string{"" /* encoder.HeadComment */, "This expression defines how to rank cgroups for OOM handler." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "sampleInterval",
				Type:        "Duration",
				Note:        "",
				Description: "How often should the trigger expression be evaluated.\n\nThis interval determines how often should the OOM controller\ncheck for the OOM condition using the provided expression.\nAdjusting it can help tune the reactivity of the OOM handler.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "How often should the trigger expression be evaluated." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleOOMV1Alpha1())

	return doc
}

func (WatchdogTimerV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "WatchdogTimerConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "WatchdogTimerConfig is a watchdog timer config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "WatchdogTimerConfig is a watchdog timer config document.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "device",
				Type:        "string",
				Note:        "",
				Description: "Path to the watchdog device.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Path to the watchdog device." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "timeout",
				Type:        "Duration",
				Note:        "",
				Description: "Timeout for the watchdog.\n\nIf Talos is unresponsive for this duration, the watchdog will reset the system.\n\nDefault value is 1 minute, minimum value is 10 seconds.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Timeout for the watchdog." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleWatchdogTimerV1Alpha1())

	doc.Fields[1].AddExample("", "/dev/watchdog0")

	return doc
}

// GetFileDoc returns documentation for the file runtime_doc.go.
func GetFileDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "runtime",
		Description: "Package runtime provides runtime machine configuration documents.\n",
		Structs: []*encoder.Doc{
			KmsgLogV1Alpha1{}.Doc(),
			EventSinkV1Alpha1{}.Doc(),
			OOMV1Alpha1{}.Doc(),
			WatchdogTimerV1Alpha1{}.Doc(),
		},
	}
}
