
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_initshutdown.h"
#include "bin/default/librpc/gen_ndr/ndr_initshutdown_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/lsa.h"
static PyTypeObject initshutdown_InterfaceType;
static PyTypeObject initshutdown_Init_Type;
static PyTypeObject initshutdown_Abort_Type;
static PyTypeObject initshutdown_InitEx_Type;

static PyTypeObject *lsa_StringLarge_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;


static PyObject *py_initshutdown_Init_in_get_hostname(PyObject *obj, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(obj);
	PyObject *py_hostname;
	if (object->in.hostname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.hostname == NULL) {
		py_hostname = Py_None;
		Py_INCREF(py_hostname);
	} else {
		py_hostname = PyLong_FromLong((uint16_t)(*object->in.hostname));
	}
	return py_hostname;
}

static int py_initshutdown_Init_in_set_hostname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.hostname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hostname");
		return -1;
	}
	if (value == Py_None) {
		object->in.hostname = NULL;
	} else {
		object->in.hostname = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.hostname);
		if (object->in.hostname == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.hostname));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.hostname = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_initshutdown_Init_in_get_message(PyObject *obj, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(obj);
	PyObject *py_message;
	if (object->in.message == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.message == NULL) {
		py_message = Py_None;
		Py_INCREF(py_message);
	} else {
		py_message = pytalloc_reference_ex(lsa_StringLarge_Type, object->in.message, object->in.message);
	}
	return py_message;
}

static int py_initshutdown_Init_in_set_message(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.message));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.message");
		return -1;
	}
	if (value == Py_None) {
		object->in.message = NULL;
	} else {
		object->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.message = (struct lsa_StringLarge *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_initshutdown_Init_in_get_timeout(PyObject *obj, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(obj);
	PyObject *py_timeout;
	py_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->in.timeout));
	return py_timeout;
}

static int py_initshutdown_Init_in_set_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_initshutdown_Init_in_get_force_apps(PyObject *obj, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(obj);
	PyObject *py_force_apps;
	py_force_apps = PyLong_FromLong((uint16_t)(object->in.force_apps));
	return py_force_apps;
}

static int py_initshutdown_Init_in_set_force_apps(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.force_apps");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.force_apps));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.force_apps = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_initshutdown_Init_in_get_do_reboot(PyObject *obj, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(obj);
	PyObject *py_do_reboot;
	py_do_reboot = PyLong_FromLong((uint16_t)(object->in.do_reboot));
	return py_do_reboot;
}

static int py_initshutdown_Init_in_set_do_reboot(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.do_reboot");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.do_reboot));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.do_reboot = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_initshutdown_Init_get_result(PyObject *obj, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_initshutdown_Init_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_Init *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_initshutdown_Init_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hostname"),
		.get = py_initshutdown_Init_in_get_hostname,
		.set = py_initshutdown_Init_in_set_hostname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_message"),
		.get = py_initshutdown_Init_in_get_message,
		.set = py_initshutdown_Init_in_set_message,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "in_timeout"),
		.get = py_initshutdown_Init_in_get_timeout,
		.set = py_initshutdown_Init_in_set_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_force_apps"),
		.get = py_initshutdown_Init_in_get_force_apps,
		.set = py_initshutdown_Init_in_set_force_apps,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_do_reboot"),
		.get = py_initshutdown_Init_in_get_do_reboot,
		.set = py_initshutdown_Init_in_set_do_reboot,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_initshutdown_Init_get_result,
		.set = py_initshutdown_Init_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_initshutdown_Init_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct initshutdown_Init, type);
	return self;
}

static PyObject *py_initshutdown_Init_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_initshutdown_Init_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct initshutdown_Init *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_initshutdown.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_initshutdown_Init_ndr_pack");
		return NULL;
	}
	call = &ndr_table_initshutdown.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_initshutdown_Init_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_initshutdown_Init_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_initshutdown_Init_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_initshutdown_Init_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_initshutdown_Init_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct initshutdown_Init *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_initshutdown.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_initshutdown_Init_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_initshutdown.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_initshutdown_Init_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_initshutdown_Init_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_initshutdown_Init_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_initshutdown_Init_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_initshutdown_Init_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct initshutdown_Init *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_initshutdown.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_initshutdown_Init_ndr_print");
		return NULL;
	}
	call = &ndr_table_initshutdown.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_initshutdown_Init_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_initshutdown_Init_ndr_print(py_obj, args, kwargs, "initshutdown_Init_in", NDR_IN);
}

static PyObject *py_initshutdown_Init_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_initshutdown_Init_ndr_print(py_obj, args, kwargs, "initshutdown_Init_out", NDR_OUT);
}

static PyMethodDef py_initshutdown_Init_methods[] = {
	{ "opnum", (PyCFunction)py_initshutdown_Init_ndr_opnum, METH_NOARGS|METH_CLASS,
		"initshutdown.Init.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Init_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Init_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Init_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Init_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Init_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Init_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject initshutdown_Init_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "initshutdown.Init",
	.tp_getset = py_initshutdown_Init_getsetters,
	.tp_methods = py_initshutdown_Init_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_initshutdown_Init_new,
};

static bool pack_py_initshutdown_Init_args_in(PyObject *args, PyObject *kwargs, struct initshutdown_Init *r)
{
	PyObject *py_hostname;
	PyObject *py_message;
	PyObject *py_timeout;
	PyObject *py_force_apps;
	PyObject *py_do_reboot;
	const char *kwnames[] = {
		"hostname", "message", "timeout", "force_apps", "do_reboot", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:initshutdown_Init", discard_const_p(char *, kwnames), &py_hostname, &py_message, &py_timeout, &py_force_apps, &py_do_reboot)) {
		return false;
	}

	if (py_hostname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hostname");
		return false;
	}
	if (py_hostname == Py_None) {
		r->in.hostname = NULL;
	} else {
		r->in.hostname = talloc_ptrtype(r, r->in.hostname);
		if (r->in.hostname == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.hostname));
			if (PyLong_Check(py_hostname)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_hostname);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.hostname = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_message == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.message");
		return false;
	}
	if (py_message == Py_None) {
		r->in.message = NULL;
	} else {
		r->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, py_message, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_message)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.message = (struct lsa_StringLarge *)pytalloc_get_ptr(py_message);
	}
	if (py_timeout == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.timeout");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.timeout));
		if (PyLong_Check(py_timeout)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_timeout);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_force_apps == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.force_apps");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.force_apps));
		if (PyLong_Check(py_force_apps)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_force_apps);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.force_apps = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_do_reboot == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.do_reboot");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.do_reboot));
		if (PyLong_Check(py_do_reboot)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_do_reboot);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.do_reboot = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_initshutdown_Init_args_out(struct initshutdown_Init *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_initshutdown_Abort_in_get_server(PyObject *obj, void *closure)
{
	struct initshutdown_Abort *object = pytalloc_get_ptr(obj);
	PyObject *py_server;
	if (object->in.server == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.server == NULL) {
		py_server = Py_None;
		Py_INCREF(py_server);
	} else {
		py_server = PyLong_FromLong((uint16_t)(*object->in.server));
	}
	return py_server;
}

static int py_initshutdown_Abort_in_set_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_Abort *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.server));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.server");
		return -1;
	}
	if (value == Py_None) {
		object->in.server = NULL;
	} else {
		object->in.server = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.server);
		if (object->in.server == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.server));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.server = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_initshutdown_Abort_get_result(PyObject *obj, void *closure)
{
	struct initshutdown_Abort *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_initshutdown_Abort_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_Abort *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_initshutdown_Abort_getsetters[] = {
	{
		.name = discard_const_p(char, "in_server"),
		.get = py_initshutdown_Abort_in_get_server,
		.set = py_initshutdown_Abort_in_set_server,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_initshutdown_Abort_get_result,
		.set = py_initshutdown_Abort_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_initshutdown_Abort_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct initshutdown_Abort, type);
	return self;
}

static PyObject *py_initshutdown_Abort_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_initshutdown_Abort_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct initshutdown_Abort *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_initshutdown.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_initshutdown_Abort_ndr_pack");
		return NULL;
	}
	call = &ndr_table_initshutdown.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_initshutdown_Abort_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_initshutdown_Abort_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_initshutdown_Abort_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_initshutdown_Abort_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_initshutdown_Abort_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct initshutdown_Abort *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_initshutdown.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_initshutdown_Abort_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_initshutdown.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_initshutdown_Abort_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_initshutdown_Abort_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_initshutdown_Abort_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_initshutdown_Abort_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_initshutdown_Abort_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct initshutdown_Abort *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_initshutdown.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_initshutdown_Abort_ndr_print");
		return NULL;
	}
	call = &ndr_table_initshutdown.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_initshutdown_Abort_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_initshutdown_Abort_ndr_print(py_obj, args, kwargs, "initshutdown_Abort_in", NDR_IN);
}

static PyObject *py_initshutdown_Abort_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_initshutdown_Abort_ndr_print(py_obj, args, kwargs, "initshutdown_Abort_out", NDR_OUT);
}

static PyMethodDef py_initshutdown_Abort_methods[] = {
	{ "opnum", (PyCFunction)py_initshutdown_Abort_ndr_opnum, METH_NOARGS|METH_CLASS,
		"initshutdown.Abort.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Abort_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Abort_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Abort_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Abort_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Abort_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_Abort_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject initshutdown_Abort_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "initshutdown.Abort",
	.tp_getset = py_initshutdown_Abort_getsetters,
	.tp_methods = py_initshutdown_Abort_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_initshutdown_Abort_new,
};

static bool pack_py_initshutdown_Abort_args_in(PyObject *args, PyObject *kwargs, struct initshutdown_Abort *r)
{
	PyObject *py_server;
	const char *kwnames[] = {
		"server", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:initshutdown_Abort", discard_const_p(char *, kwnames), &py_server)) {
		return false;
	}

	if (py_server == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.server");
		return false;
	}
	if (py_server == Py_None) {
		r->in.server = NULL;
	} else {
		r->in.server = talloc_ptrtype(r, r->in.server);
		if (r->in.server == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.server));
			if (PyLong_Check(py_server)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_server);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.server = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_initshutdown_Abort_args_out(struct initshutdown_Abort *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_initshutdown_InitEx_in_get_hostname(PyObject *obj, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(obj);
	PyObject *py_hostname;
	if (object->in.hostname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.hostname == NULL) {
		py_hostname = Py_None;
		Py_INCREF(py_hostname);
	} else {
		py_hostname = PyLong_FromLong((uint16_t)(*object->in.hostname));
	}
	return py_hostname;
}

static int py_initshutdown_InitEx_in_set_hostname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.hostname));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.hostname");
		return -1;
	}
	if (value == Py_None) {
		object->in.hostname = NULL;
	} else {
		object->in.hostname = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.hostname);
		if (object->in.hostname == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.hostname));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.hostname = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_initshutdown_InitEx_in_get_message(PyObject *obj, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(obj);
	PyObject *py_message;
	if (object->in.message == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.message == NULL) {
		py_message = Py_None;
		Py_INCREF(py_message);
	} else {
		py_message = pytalloc_reference_ex(lsa_StringLarge_Type, object->in.message, object->in.message);
	}
	return py_message;
}

static int py_initshutdown_InitEx_in_set_message(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.message));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.message");
		return -1;
	}
	if (value == Py_None) {
		object->in.message = NULL;
	} else {
		object->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.message = (struct lsa_StringLarge *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_initshutdown_InitEx_in_get_timeout(PyObject *obj, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(obj);
	PyObject *py_timeout;
	py_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->in.timeout));
	return py_timeout;
}

static int py_initshutdown_InitEx_in_set_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_initshutdown_InitEx_in_get_force_apps(PyObject *obj, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(obj);
	PyObject *py_force_apps;
	py_force_apps = PyLong_FromLong((uint16_t)(object->in.force_apps));
	return py_force_apps;
}

static int py_initshutdown_InitEx_in_set_force_apps(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.force_apps");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.force_apps));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.force_apps = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_initshutdown_InitEx_in_get_do_reboot(PyObject *obj, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(obj);
	PyObject *py_do_reboot;
	py_do_reboot = PyLong_FromLong((uint16_t)(object->in.do_reboot));
	return py_do_reboot;
}

static int py_initshutdown_InitEx_in_set_do_reboot(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.do_reboot");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.do_reboot));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.do_reboot = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_initshutdown_InitEx_in_get_reason(PyObject *obj, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(obj);
	PyObject *py_reason;
	py_reason = PyLong_FromUnsignedLongLong((uint32_t)(object->in.reason));
	return py_reason;
}

static int py_initshutdown_InitEx_in_set_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.reason");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.reason));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.reason = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_initshutdown_InitEx_get_result(PyObject *obj, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_initshutdown_InitEx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_initshutdown_InitEx_getsetters[] = {
	{
		.name = discard_const_p(char, "in_hostname"),
		.get = py_initshutdown_InitEx_in_get_hostname,
		.set = py_initshutdown_InitEx_in_set_hostname,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_message"),
		.get = py_initshutdown_InitEx_in_get_message,
		.set = py_initshutdown_InitEx_in_set_message,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "in_timeout"),
		.get = py_initshutdown_InitEx_in_get_timeout,
		.set = py_initshutdown_InitEx_in_set_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_force_apps"),
		.get = py_initshutdown_InitEx_in_get_force_apps,
		.set = py_initshutdown_InitEx_in_set_force_apps,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_do_reboot"),
		.get = py_initshutdown_InitEx_in_get_do_reboot,
		.set = py_initshutdown_InitEx_in_set_do_reboot,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "in_reason"),
		.get = py_initshutdown_InitEx_in_get_reason,
		.set = py_initshutdown_InitEx_in_set_reason,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_initshutdown_InitEx_get_result,
		.set = py_initshutdown_InitEx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_initshutdown_InitEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct initshutdown_InitEx, type);
	return self;
}

static PyObject *py_initshutdown_InitEx_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_initshutdown_InitEx_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_initshutdown.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_initshutdown_InitEx_ndr_pack");
		return NULL;
	}
	call = &ndr_table_initshutdown.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_initshutdown_InitEx_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_initshutdown_InitEx_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_initshutdown_InitEx_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_initshutdown_InitEx_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_initshutdown_InitEx_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_initshutdown.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_initshutdown_InitEx_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_initshutdown.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_initshutdown_InitEx_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_initshutdown_InitEx_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_initshutdown_InitEx_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_initshutdown_InitEx_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_initshutdown_InitEx_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct initshutdown_InitEx *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_initshutdown.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_initshutdown_InitEx_ndr_print");
		return NULL;
	}
	call = &ndr_table_initshutdown.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_initshutdown_InitEx_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_initshutdown_InitEx_ndr_print(py_obj, args, kwargs, "initshutdown_InitEx_in", NDR_IN);
}

static PyObject *py_initshutdown_InitEx_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_initshutdown_InitEx_ndr_print(py_obj, args, kwargs, "initshutdown_InitEx_out", NDR_OUT);
}

static PyMethodDef py_initshutdown_InitEx_methods[] = {
	{ "opnum", (PyCFunction)py_initshutdown_InitEx_ndr_opnum, METH_NOARGS|METH_CLASS,
		"initshutdown.InitEx.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_InitEx_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_InitEx_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_InitEx_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_InitEx_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_InitEx_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_initshutdown_InitEx_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject initshutdown_InitEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "initshutdown.InitEx",
	.tp_getset = py_initshutdown_InitEx_getsetters,
	.tp_methods = py_initshutdown_InitEx_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_initshutdown_InitEx_new,
};

static bool pack_py_initshutdown_InitEx_args_in(PyObject *args, PyObject *kwargs, struct initshutdown_InitEx *r)
{
	PyObject *py_hostname;
	PyObject *py_message;
	PyObject *py_timeout;
	PyObject *py_force_apps;
	PyObject *py_do_reboot;
	PyObject *py_reason;
	const char *kwnames[] = {
		"hostname", "message", "timeout", "force_apps", "do_reboot", "reason", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:initshutdown_InitEx", discard_const_p(char *, kwnames), &py_hostname, &py_message, &py_timeout, &py_force_apps, &py_do_reboot, &py_reason)) {
		return false;
	}

	if (py_hostname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.hostname");
		return false;
	}
	if (py_hostname == Py_None) {
		r->in.hostname = NULL;
	} else {
		r->in.hostname = talloc_ptrtype(r, r->in.hostname);
		if (r->in.hostname == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.hostname));
			if (PyLong_Check(py_hostname)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_hostname);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.hostname = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_message == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.message");
		return false;
	}
	if (py_message == Py_None) {
		r->in.message = NULL;
	} else {
		r->in.message = NULL;
		PY_CHECK_TYPE(lsa_StringLarge_Type, py_message, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_message)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.message = (struct lsa_StringLarge *)pytalloc_get_ptr(py_message);
	}
	if (py_timeout == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.timeout");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.timeout));
		if (PyLong_Check(py_timeout)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_timeout);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_force_apps == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.force_apps");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.force_apps));
		if (PyLong_Check(py_force_apps)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_force_apps);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.force_apps = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_do_reboot == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.do_reboot");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.do_reboot));
		if (PyLong_Check(py_do_reboot)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_do_reboot);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.do_reboot = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_reason == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.reason");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.reason));
		if (PyLong_Check(py_reason)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_reason);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.reason = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_initshutdown_InitEx_args_out(struct initshutdown_InitEx *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_initshutdown_methods[] = {
	{
		.name = "Init",
		.doc = "S.Init(hostname, message, timeout, force_apps, do_reboot) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_initshutdown_Init_r,
		.pack_in_data = (py_data_pack_fn)pack_py_initshutdown_Init_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_initshutdown_Init_args_out,
		.opnum = 0,
		.table = &ndr_table_initshutdown,
	},
	{
		.name = "Abort",
		.doc = "S.Abort(server) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_initshutdown_Abort_r,
		.pack_in_data = (py_data_pack_fn)pack_py_initshutdown_Abort_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_initshutdown_Abort_args_out,
		.opnum = 1,
		.table = &ndr_table_initshutdown,
	},
	{
		.name = "InitEx",
		.doc = "S.InitEx(hostname, message, timeout, force_apps, do_reboot, reason) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_initshutdown_InitEx_r,
		.pack_in_data = (py_data_pack_fn)pack_py_initshutdown_InitEx_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_initshutdown_InitEx_args_out,
		.opnum = 2,
		.table = &ndr_table_initshutdown,
	},
	{
		.name = NULL,
	},
};

static PyObject *interface_initshutdown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_initshutdown);
}

#define PY_DOC_INITSHUTDOWN "Init shutdown service"
static PyTypeObject initshutdown_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "initshutdown.initshutdown",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "initshutdown(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A initshutdown client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_INITSHUTDOWN,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_initshutdown_new,
};

static PyObject *syntax_initshutdown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_initshutdown.syntax_id);
}

#define PY_DOC_INITSHUTDOWN_SYNTAX "Init shutdown service"
static PyTypeObject initshutdown_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "initshutdown.initshutdown_abstract_syntax",
	.tp_doc = "initshutdown_abstract_syntax()\n"PY_DOC_INITSHUTDOWN_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_initshutdown_new,
};

static PyMethodDef initshutdown_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "initshutdown",
	.m_doc = "initshutdown DCE/RPC",
	.m_size = -1,
	.m_methods = initshutdown_methods,
};
MODULE_INIT_FUNC(initshutdown)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_lsa = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	lsa_StringLarge_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "StringLarge");
	if (lsa_StringLarge_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	initshutdown_Init_Type.tp_base = BaseObject_Type;
	initshutdown_Init_Type.tp_basicsize = pytalloc_BaseObject_size();

	initshutdown_Abort_Type.tp_base = BaseObject_Type;
	initshutdown_Abort_Type.tp_basicsize = pytalloc_BaseObject_size();

	initshutdown_InitEx_Type.tp_base = BaseObject_Type;
	initshutdown_InitEx_Type.tp_basicsize = pytalloc_BaseObject_size();

	initshutdown_InterfaceType.tp_base = ClientConnection_Type;

	initshutdown_SyntaxType.tp_base = ndr_syntax_id_Type;
	initshutdown_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&initshutdown_Init_Type) < 0)
		goto out;
	if (PyType_Ready(&initshutdown_Abort_Type) < 0)
		goto out;
	if (PyType_Ready(&initshutdown_InitEx_Type) < 0)
		goto out;
	if (PyType_Ready(&initshutdown_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&initshutdown_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&initshutdown_InterfaceType, py_ndr_initshutdown_methods))
		return NULL;

#ifdef PY_INIT_PATCH
	PY_INIT_PATCH(&initshutdown_Init_Type);
#endif
#ifdef PY_ABORT_PATCH
	PY_ABORT_PATCH(&initshutdown_Abort_Type);
#endif
#ifdef PY_INITEX_PATCH
	PY_INITEX_PATCH(&initshutdown_InitEx_Type);
#endif
#ifdef PY_INITSHUTDOWN_PATCH
	PY_INITSHUTDOWN_PATCH(&initshutdown_InterfaceType);
#endif
#ifdef PY_INITSHUTDOWN_ABSTRACT_SYNTAX_PATCH
	PY_INITSHUTDOWN_ABSTRACT_SYNTAX_PATCH(&initshutdown_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&initshutdown_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "SHTDN_REASON_MAJOR_OTHER", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MAJOR_OTHER)));
	PyModule_AddObject(m, "SHTDN_REASON_MAJOR_HARDWARE", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MAJOR_HARDWARE)));
	PyModule_AddObject(m, "SHTDN_REASON_MAJOR_OPERATINGSYSTEM", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MAJOR_OPERATINGSYSTEM)));
	PyModule_AddObject(m, "SHTDN_REASON_MAJOR_SOFTWARE", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MAJOR_SOFTWARE)));
	PyModule_AddObject(m, "SHTDN_REASON_MAJOR_APPLICATION", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MAJOR_APPLICATION)));
	PyModule_AddObject(m, "SHTDN_REASON_MAJOR_SYSTEM", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MAJOR_SYSTEM)));
	PyModule_AddObject(m, "SHTDN_REASON_MAJOR_POWER", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MAJOR_POWER)));
	PyModule_AddObject(m, "SHTDN_REASON_MAJOR_LEGACY_API", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MAJOR_LEGACY_API)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_OTHER", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_OTHER)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_MAINTENANCE", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_MAINTENANCE)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_INSTALLATION", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_INSTALLATION)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_UPGRADE", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_UPGRADE)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_RECONFIG", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_RECONFIG)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_HUNG", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_HUNG)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_UNSTABLE", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_UNSTABLE)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_DISK", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_DISK)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_PROCESSOR", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_PROCESSOR)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_NETWORKCARD", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_NETWORKCARD)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_POWER_SUPPLY", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_POWER_SUPPLY)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_CORDUNPLUGGED", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_CORDUNPLUGGED)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_ENVIRONMENT", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_ENVIRONMENT)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_HARDWARE_DRIVER", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_HARDWARE_DRIVER)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_OTHERDRIVER", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_OTHERDRIVER)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_BLUESCREEN", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_BLUESCREEN)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_SERVICEPACK", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_SERVICEPACK)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_HOTFIX", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_HOTFIX)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_SECURITYFIX", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_SECURITYFIX)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_SECURITY", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_SECURITY)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_NETWORK_CONNECTIVITY", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_NETWORK_CONNECTIVITY)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_WMI", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_WMI)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_SERVICEPACK_UNINSTALL", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_SERVICEPACK_UNINSTALL)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_HOTFIX_UNINSTALL", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_HOTFIX_UNINSTALL)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_SECURITYFIX_UNINSTALL", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_SECURITYFIX_UNINSTALL)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_MMC", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_MMC)));
	PyModule_AddObject(m, "SHTDN_REASON_MINOR_TERMSRV", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_MINOR_TERMSRV)));
	PyModule_AddObject(m, "SHTDN_REASON_FLAG_USER_DEFINED", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_FLAG_USER_DEFINED)));
	PyModule_AddObject(m, "SHTDN_REASON_FLAG_PLANNED", PyLong_FromUnsignedLongLong((uint32_t)(SHTDN_REASON_FLAG_PLANNED)));
	Py_INCREF((PyObject *)(void *)&initshutdown_Init_Type);
	PyModule_AddObject(m, "Init", (PyObject *)(void *)&initshutdown_Init_Type);
	Py_INCREF((PyObject *)(void *)&initshutdown_Abort_Type);
	PyModule_AddObject(m, "Abort", (PyObject *)(void *)&initshutdown_Abort_Type);
	Py_INCREF((PyObject *)(void *)&initshutdown_InitEx_Type);
	PyModule_AddObject(m, "InitEx", (PyObject *)(void *)&initshutdown_InitEx_Type);
	Py_INCREF((PyObject *)(void *)&initshutdown_InterfaceType);
	PyModule_AddObject(m, "initshutdown", (PyObject *)(void *)&initshutdown_InterfaceType);
	Py_INCREF((PyObject *)(void *)&initshutdown_SyntaxType);
	PyModule_AddObject(m, "initshutdown_abstract_syntax", (PyObject *)(void *)&initshutdown_SyntaxType);
	Py_INCREF((PyObject *)(void *)&initshutdown_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&initshutdown_SyntaxType);
#ifdef PY_MOD_INITSHUTDOWN_PATCH
	PY_MOD_INITSHUTDOWN_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_lsa);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	Py_XDECREF(dep_samba_dcerpc_misc);
	return m;

}
