/* rygel-item-destroyer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-item-destroyer.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include "rygel-server.h"
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_ITEM_DESTROYER_ERROR (rygel_item_destroyer_error_get_type ())

#define RYGEL_TYPE_ITEM_DESTROYER (rygel_item_destroyer_get_type ())
#define RYGEL_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer))
#define RYGEL_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))
#define RYGEL_IS_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_IS_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_ITEM_DESTROYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))

typedef struct _RygelItemDestroyer RygelItemDestroyer;
typedef struct _RygelItemDestroyerClass RygelItemDestroyerClass;
typedef struct _RygelItemDestroyerPrivate RygelItemDestroyerPrivate;
enum  {
	RYGEL_ITEM_DESTROYER_0_PROPERTY,
	RYGEL_ITEM_DESTROYER_CANCELLABLE_PROPERTY,
	RYGEL_ITEM_DESTROYER_NUM_PROPERTIES
};
static GParamSpec* rygel_item_destroyer_properties[RYGEL_ITEM_DESTROYER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY_ERROR (rygel_content_directory_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemDestroyerRunData RygelItemDestroyerRunData;

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
typedef struct _RygelItemDestroyerRemoveObjectData RygelItemDestroyerRemoveObjectData;
typedef struct _RygelItemDestroyerFetchObjectData RygelItemDestroyerFetchObjectData;

typedef enum  {
	RYGEL_ITEM_DESTROYER_ERROR_PARSE
} RygelItemDestroyerError;
#define RYGEL_ITEM_DESTROYER_ERROR rygel_item_destroyer_error_quark ()

struct _RygelItemDestroyer {
	GObject parent_instance;
	RygelItemDestroyerPrivate * priv;
};

struct _RygelItemDestroyerClass {
	GObjectClass parent_class;
};

struct _RygelItemDestroyerPrivate {
	gchar* object_id;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GCancellable* _cancellable;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()

struct _RygelItemDestroyerRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelItemDestroyer* self;
	GUPnPServiceAction* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	const gchar* _tmp5_;
	GError* _error_;
	GError* _tmp6_;
	GUPnPServiceAction* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GUPnPServiceAction* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _RygelItemDestroyerRemoveObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelItemDestroyer* self;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp0_;
	RygelWritableContainer* parent;
	RygelMediaObject* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaContainer* _tmp3_;
	RygelWritableContainer* _tmp4_;
	RygelMediaFileItem* item;
	RygelMediaObject* _tmp5_;
	RygelMediaFileItem* _tmp6_;
	RygelMediaFileItem* _tmp7_;
	RygelWritableContainer* _tmp8_;
	const gchar* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	RygelMediaFileItem* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GeeArrayList* writables;
	RygelMediaObject* _tmp15_;
	GCancellable* _tmp16_;
	GCancellable* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _file_list;
	GeeArrayList* _tmp19_;
	gint _file_size;
	GeeArrayList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _file_index;
	gint _tmp23_;
	gint _tmp24_;
	GFile* file;
	GeeArrayList* _tmp25_;
	gpointer _tmp26_;
	GFile* _tmp27_;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	GFile* _tmp30_;
	GCancellable* _tmp31_;
	GCancellable* _tmp32_;
	RygelWritableContainer* _tmp33_;
	const gchar* _tmp34_;
	GCancellable* _tmp35_;
	GCancellable* _tmp36_;
	RygelObjectRemovalQueue* _tmp37_;
	RygelObjectRemovalQueue* _tmp38_;
	RygelMediaObject* _tmp39_;
	GError* _inner_error0_;
};

struct _RygelItemDestroyerFetchObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelItemDestroyer* self;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelMediaObject* _tmp6_;
	GError* _tmp7_;
	RygelMediaObject* _tmp8_;
	GUPnPOCMFlags _tmp9_;
	GUPnPOCMFlags _tmp10_;
	RygelMediaObject* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	RygelMediaObject* _tmp15_;
	RygelMediaContainer* _tmp16_;
	RygelMediaContainer* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gchar* msg;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	RygelMediaObject* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	GError* _inner_error0_;
};

static gint RygelItemDestroyer_private_offset;
static gpointer rygel_item_destroyer_parent_class = NULL;
static RygelStateMachineIface * rygel_item_destroyer_rygel_state_machine_parent_iface = NULL;

VALA_EXTERN GQuark rygel_item_destroyer_error_quark (void);
VALA_EXTERN GType rygel_item_destroyer_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_item_destroyer_get_type (void) G_GNUC_CONST ;
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
VALA_EXTERN RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir,
                                              GUPnPServiceAction* action);
VALA_EXTERN RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type,
                                                    RygelContentDirectory* content_dir,
                                                    GUPnPServiceAction* action);
static void rygel_item_destroyer_real_run_data_free (gpointer _data);
static void rygel_item_destroyer_real_run (RygelStateMachine* base,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean rygel_item_destroyer_real_run_co (RygelItemDestroyerRunData* _data_);
VALA_EXTERN GQuark rygel_content_directory_error_quark (void);
VALA_EXTERN GType rygel_content_directory_error_get_type (void) G_GNUC_CONST ;
static void rygel_item_destroyer_remove_object (RygelItemDestroyer* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void rygel_item_destroyer_remove_object_finish (RygelItemDestroyer* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static void rygel_item_destroyer_run_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static void rygel_item_destroyer_remove_object_data_free (gpointer _data);
static gboolean rygel_item_destroyer_remove_object_co (RygelItemDestroyerRemoveObjectData* _data_);
static void rygel_item_destroyer_fetch_object (RygelItemDestroyer* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static RygelMediaObject* rygel_item_destroyer_fetch_object_finish (RygelItemDestroyer* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
static void rygel_item_destroyer_remove_object_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
VALA_EXTERN GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
VALA_EXTERN gboolean rygel_object_removal_queue_dequeue (RygelObjectRemovalQueue* self,
                                             RygelMediaObject* object);
static void rygel_item_destroyer_fetch_object_data_free (gpointer _data);
static gboolean rygel_item_destroyer_fetch_object_co (RygelItemDestroyerFetchObjectData* _data_);
static void rygel_item_destroyer_fetch_object_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_item_destroyer_finalize (GObject * obj);
static GType rygel_item_destroyer_get_type_once (void);
static void _vala_rygel_item_destroyer_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_rygel_item_destroyer_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
rygel_item_destroyer_error_quark (void)
{
	return g_quark_from_static_string ("rygel-item-destroyer-error-quark");
}

 G_GNUC_NO_INLINE static GType
rygel_item_destroyer_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_ITEM_DESTROYER_ERROR_PARSE, "RYGEL_ITEM_DESTROYER_ERROR_PARSE", "parse"}, {0, NULL, NULL}};
	GType rygel_item_destroyer_error_type_id;
	rygel_item_destroyer_error_type_id = g_enum_register_static ("RygelItemDestroyerError", values);
	return rygel_item_destroyer_error_type_id;
}

GType
rygel_item_destroyer_error_get_type (void)
{
	static volatile gsize rygel_item_destroyer_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_item_destroyer_error_type_id__once)) {
		GType rygel_item_destroyer_error_type_id;
		rygel_item_destroyer_error_type_id = rygel_item_destroyer_error_get_type_once ();
		g_once_init_leave (&rygel_item_destroyer_error_type_id__once, rygel_item_destroyer_error_type_id);
	}
	return rygel_item_destroyer_error_type_id__once;
}

static inline gpointer
rygel_item_destroyer_get_instance_private (RygelItemDestroyer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelItemDestroyer_private_offset);
}

static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelItemDestroyer*
rygel_item_destroyer_construct (GType object_type,
                                RygelContentDirectory* content_dir,
                                GUPnPServiceAction* action)
{
	RygelItemDestroyer * self = NULL;
	RygelContentDirectory* _tmp0_;
	GCancellable* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelItemDestroyer*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (content_dir);
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp0_;
	_tmp1_ = content_dir->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
	_tmp2_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	self->priv->action = _tmp2_;
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}

RygelItemDestroyer*
rygel_item_destroyer_new (RygelContentDirectory* content_dir,
                          GUPnPServiceAction* action)
{
	return rygel_item_destroyer_construct (RYGEL_TYPE_ITEM_DESTROYER, content_dir, action);
}

static void
rygel_item_destroyer_real_run_data_free (gpointer _data)
{
	RygelItemDestroyerRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemDestroyerRunData, _data_);
}

static void
rygel_item_destroyer_real_run (RygelStateMachine* base,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	RygelItemDestroyer * self;
	RygelItemDestroyerRunData* _data_;
	RygelItemDestroyer* _tmp0_;
	self = (RygelItemDestroyer*) base;
	_data_ = g_slice_new0 (RygelItemDestroyerRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_item_destroyer_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_destroyer_real_run_co (_data_);
}

static void
rygel_item_destroyer_run_finish (RygelStateMachine* base,
                                 GAsyncResult* _res_)
{
	RygelItemDestroyerRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_item_destroyer_run_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	RygelItemDestroyerRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_destroyer_real_run_co (_data_);
}

static gboolean
rygel_item_destroyer_real_run_co (RygelItemDestroyerRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->action;
		_data_->_tmp1_ = NULL;
		gupnp_service_action_get (_data_->_tmp0_, "ObjectID", G_TYPE_STRING, &_data_->_tmp1_, NULL);
		_g_free0 (_data_->self->priv->object_id);
		_data_->self->priv->object_id = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->self->priv->object_id;
		if (_data_->_tmp2_ == NULL) {
			_data_->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _ ("ContainerID missing"));
			_data_->_inner_error0_ = _data_->_tmp3_;
			goto __catch0_g_error;
		}
		_data_->_state_ = 1;
		rygel_item_destroyer_remove_object (_data_->self, rygel_item_destroyer_run_ready, _data_);
		return FALSE;
		_state_1:
		rygel_item_destroyer_remove_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->self->priv->action;
		gupnp_service_action_return_success (_data_->_tmp4_);
		_data_->_tmp5_ = _data_->self->priv->object_id;
		g_debug (_ ("Successfully destroyed object “%s”"), _data_->_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->_error_;
		if (_data_->_tmp6_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
			_data_->_tmp7_ = _data_->self->priv->action;
			_data_->_tmp8_ = _data_->_error_;
			_data_->_tmp9_ = _data_->_error_;
			_data_->_tmp10_ = _data_->_tmp9_->message;
			gupnp_service_action_return_error (_data_->_tmp7_, (guint) _data_->_tmp8_->code, _data_->_tmp10_);
		} else {
			_data_->_tmp11_ = _data_->self->priv->action;
			_data_->_tmp12_ = _data_->_error_;
			_data_->_tmp13_ = _data_->_tmp12_->message;
			gupnp_service_action_return_error (_data_->_tmp11_, (guint) 701, _data_->_tmp13_);
		}
		_data_->_tmp14_ = _data_->self->priv->object_id;
		_data_->_tmp15_ = _data_->_error_;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_warning (_ ("Failed to destroy object “%s”: %s"), _data_->_tmp14_, _data_->_tmp16_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_item_destroyer_remove_object_data_free (gpointer _data)
{
	RygelItemDestroyerRemoveObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemDestroyerRemoveObjectData, _data_);
}

static void
rygel_item_destroyer_remove_object (RygelItemDestroyer* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	RygelItemDestroyerRemoveObjectData* _data_;
	RygelItemDestroyer* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelItemDestroyerRemoveObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_item_destroyer_remove_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_destroyer_remove_object_co (_data_);
}

static void
rygel_item_destroyer_remove_object_finish (RygelItemDestroyer* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	RygelItemDestroyerRemoveObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_item_destroyer_remove_object_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	RygelItemDestroyerRemoveObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_destroyer_remove_object_co (_data_);
}

static gboolean
rygel_item_destroyer_remove_object_co (RygelItemDestroyerRemoveObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_item_destroyer_fetch_object (_data_->self, rygel_item_destroyer_remove_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = rygel_item_destroyer_fetch_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->media_object = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->media_object;
	_data_->_tmp2_ = rygel_media_object_get_parent (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _g_object_ref0 (RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp3_) ? ((RygelWritableContainer*) _data_->_tmp3_) : NULL);
	_data_->parent = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->media_object;
	_data_->_tmp6_ = _g_object_ref0 (RYGEL_IS_MEDIA_FILE_ITEM (_data_->_tmp5_) ? ((RygelMediaFileItem*) _data_->_tmp5_) : NULL);
	_data_->item = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->item;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp8_ = _data_->parent;
		_data_->_tmp9_ = _data_->self->priv->object_id;
		_data_->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_state_ = 2;
		rygel_writable_container_remove_item (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp11_, rygel_item_destroyer_remove_object_ready, _data_);
		return FALSE;
		_state_2:
		rygel_writable_container_remove_item_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->item);
			_g_object_unref0 (_data_->parent);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp12_ = _data_->item;
		_data_->_tmp13_ = rygel_media_file_item_get_place_holder (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		if (!_data_->_tmp14_) {
			_data_->_tmp15_ = _data_->media_object;
			_data_->_tmp16_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_state_ = 3;
			rygel_media_object_get_writables (_data_->_tmp15_, _data_->_tmp17_, rygel_item_destroyer_remove_object_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp18_ = rygel_media_object_get_writables_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
			_data_->writables = _data_->_tmp18_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->item);
				_g_object_unref0 (_data_->parent);
				_g_object_unref0 (_data_->media_object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			{
				_data_->_tmp19_ = _data_->writables;
				_data_->_file_list = _data_->_tmp19_;
				_data_->_tmp20_ = _data_->_file_list;
				_data_->_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp20_);
				_data_->_tmp22_ = _data_->_tmp21_;
				_data_->_file_size = _data_->_tmp22_;
				_data_->_file_index = -1;
				while (TRUE) {
					_data_->_file_index = _data_->_file_index + 1;
					_data_->_tmp23_ = _data_->_file_index;
					_data_->_tmp24_ = _data_->_file_size;
					if (!(_data_->_tmp23_ < _data_->_tmp24_)) {
						break;
					}
					_data_->_tmp25_ = _data_->_file_list;
					_data_->_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp25_, _data_->_file_index);
					_data_->file = (GFile*) _data_->_tmp26_;
					_data_->_tmp27_ = _data_->file;
					_data_->_tmp28_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
					_data_->_tmp29_ = _data_->_tmp28_;
					if (g_file_query_exists (_data_->_tmp27_, _data_->_tmp29_)) {
						_data_->_tmp30_ = _data_->file;
						_data_->_tmp31_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
						_data_->_tmp32_ = _data_->_tmp31_;
						g_file_delete (_data_->_tmp30_, _data_->_tmp32_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_object_unref0 (_data_->file);
							_g_object_unref0 (_data_->writables);
							_g_object_unref0 (_data_->item);
							_g_object_unref0 (_data_->parent);
							_g_object_unref0 (_data_->media_object);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
					}
					_g_object_unref0 (_data_->file);
				}
			}
			_g_object_unref0 (_data_->writables);
		}
	} else {
		_data_->_tmp33_ = _data_->parent;
		_data_->_tmp34_ = _data_->self->priv->object_id;
		_data_->_tmp35_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp36_ = _data_->_tmp35_;
		_data_->_state_ = 4;
		rygel_writable_container_remove_container (_data_->_tmp33_, _data_->_tmp34_, _data_->_tmp36_, rygel_item_destroyer_remove_object_ready, _data_);
		return FALSE;
		_state_4:
		rygel_writable_container_remove_container_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->item);
			_g_object_unref0 (_data_->parent);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp37_ = rygel_object_removal_queue_get_default ();
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp39_ = _data_->media_object;
	rygel_object_removal_queue_dequeue (_data_->_tmp38_, _data_->_tmp39_);
	_g_object_unref0 (_data_->_tmp38_);
	_g_object_unref0 (_data_->item);
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->media_object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_item_destroyer_fetch_object_data_free (gpointer _data)
{
	RygelItemDestroyerFetchObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemDestroyerFetchObjectData, _data_);
}

static void
rygel_item_destroyer_fetch_object (RygelItemDestroyer* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RygelItemDestroyerFetchObjectData* _data_;
	RygelItemDestroyer* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelItemDestroyerFetchObjectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_item_destroyer_fetch_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_destroyer_fetch_object_co (_data_);
}

static RygelMediaObject*
rygel_item_destroyer_fetch_object_finish (RygelItemDestroyer* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	RygelMediaObject* result;
	RygelItemDestroyerFetchObjectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_item_destroyer_fetch_object_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	RygelItemDestroyerFetchObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_destroyer_fetch_object_co (_data_);
}

static gboolean
rygel_item_destroyer_fetch_object_co (RygelItemDestroyerFetchObjectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->content_dir;
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
	_data_->_tmp2_ = _data_->self->priv->object_id;
	_data_->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	rygel_media_container_find_object (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp4_, rygel_item_destroyer_fetch_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = rygel_media_container_find_object_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	_data_->media_object = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->media_object;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _ ("No such object"));
		_data_->_inner_error0_ = _data_->_tmp7_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->media_object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp8_ = _data_->media_object;
		_data_->_tmp9_ = rygel_media_object_get_ocm_flags (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		if (!((_data_->_tmp10_ & GUPNP_OCM_FLAGS_DESTROYABLE) == GUPNP_OCM_FLAGS_DESTROYABLE)) {
			_data_->_tmp11_ = _data_->media_object;
			_data_->_tmp12_ = rygel_media_object_get_id (_data_->_tmp11_);
			_data_->_tmp13_ = _data_->_tmp12_;
			_data_->_tmp14_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT, _ ("Removal of object %s not allowed"), _data_->_tmp13_);
			_data_->_inner_error0_ = _data_->_tmp14_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->media_object);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp15_ = _data_->media_object;
			_data_->_tmp16_ = rygel_media_object_get_parent (_data_->_tmp15_);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_tmp18_ = rygel_media_object_get_restricted ((RygelMediaObject*) _data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			if (_data_->_tmp19_) {
				_data_->_tmp20_ = g_strdup (_ ("Object removal from %s not allowed"));
				_data_->msg = _data_->_tmp20_;
				_data_->_tmp21_ = _data_->msg;
				_data_->_tmp22_ = _data_->media_object;
				_data_->_tmp23_ = rygel_media_object_get_id (_data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_tmp25_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp21_, _data_->_tmp24_);
				_data_->_inner_error0_ = _data_->_tmp25_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->msg);
				_g_object_unref0 (_data_->media_object);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->result = _data_->media_object;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GCancellable*
rygel_item_destroyer_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelItemDestroyer* self;
	GCancellable* _tmp0_;
	self = (RygelItemDestroyer*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
rygel_item_destroyer_real_set_cancellable (RygelStateMachine* base,
                                           GCancellable* value)
{
	RygelItemDestroyer* self;
	GCancellable* old_value;
	self = (RygelItemDestroyer*) base;
	old_value = rygel_item_destroyer_real_get_cancellable (base);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_item_destroyer_properties[RYGEL_ITEM_DESTROYER_CANCELLABLE_PROPERTY]);
	}
}

static void
rygel_item_destroyer_class_init (RygelItemDestroyerClass * klass,
                                 gpointer klass_data)
{
	rygel_item_destroyer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelItemDestroyer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_destroyer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_destroyer_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_destroyer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_DESTROYER_CANCELLABLE_PROPERTY, rygel_item_destroyer_properties[RYGEL_ITEM_DESTROYER_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_item_destroyer_rygel_state_machine_interface_init (RygelStateMachineIface * iface,
                                                         gpointer iface_data)
{
	rygel_item_destroyer_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_item_destroyer_real_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_item_destroyer_run_finish;
	iface->get_cancellable = rygel_item_destroyer_real_get_cancellable;
	iface->set_cancellable = rygel_item_destroyer_real_set_cancellable;
}

static void
rygel_item_destroyer_instance_init (RygelItemDestroyer * self,
                                    gpointer klass)
{
	self->priv = rygel_item_destroyer_get_instance_private (self);
}

static void
rygel_item_destroyer_finalize (GObject * obj)
{
	RygelItemDestroyer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer);
	_g_free0 (self->priv->object_id);
	_g_object_unref0 (self->priv->content_dir);
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_destroyer_parent_class)->finalize (obj);
}

/**
 * DestroyObject action implementation.
 */
 G_GNUC_NO_INLINE static GType
rygel_item_destroyer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelItemDestroyerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_destroyer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemDestroyer), 0, (GInstanceInitFunc) rygel_item_destroyer_instance_init, NULL };
	static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_destroyer_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_item_destroyer_type_id;
	rygel_item_destroyer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemDestroyer", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_item_destroyer_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	RygelItemDestroyer_private_offset = g_type_add_instance_private (rygel_item_destroyer_type_id, sizeof (RygelItemDestroyerPrivate));
	return rygel_item_destroyer_type_id;
}

GType
rygel_item_destroyer_get_type (void)
{
	static volatile gsize rygel_item_destroyer_type_id__once = 0;
	if (g_once_init_enter (&rygel_item_destroyer_type_id__once)) {
		GType rygel_item_destroyer_type_id;
		rygel_item_destroyer_type_id = rygel_item_destroyer_get_type_once ();
		g_once_init_leave (&rygel_item_destroyer_type_id__once, rygel_item_destroyer_type_id);
	}
	return rygel_item_destroyer_type_id__once;
}

static void
_vala_rygel_item_destroyer_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	RygelItemDestroyer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer);
	switch (property_id) {
		case RYGEL_ITEM_DESTROYER_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_item_destroyer_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	RygelItemDestroyer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer);
	switch (property_id) {
		case RYGEL_ITEM_DESTROYER_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

