use rustc_abi::Endian;

use crate::spec::{Arch, Cc, LinkerFlavor, Target, TargetMetadata, TargetOptions, base};

pub(crate) fn target() -> Target {
    let mut base = TargetOptions {
        endian: Endian::Big,
        // llvm calls this "v9"
        cpu: "v9".into(),
        vendor: "sun".into(),
        max_atomic_width: Some(64),
        ..base::solaris::opts()
    };
    base.add_pre_link_args(LinkerFlavor::Unix(Cc::Yes), &["-m64"]);

    Target {
        llvm_target: "sparcv9-sun-solaris".into(),
        metadata: TargetMetadata {
            description: Some("SPARC Solaris 11.4".into()),
            tier: Some(2),
            host_tools: Some(true),
            std: Some(true),
        },
        pointer_width: 64,
        data_layout: "E-m:e-i64:64-i128:128-n32:64-S128".into(),
        // Use "sparc64" instead of "sparcv9" here, since the former is already
        // used widely in the source base. If we ever needed ABI
        // differentiation from the sparc64, we could, but that would probably
        // just be confusing.
        arch: Arch::Sparc64,
        options: base,
    }
}
