// third_party/blink/public/mojom/content_extraction/inner_text.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* NodeLocationTypeToStringHelper(NodeLocationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NodeLocationType::kStart:
      return "kStart";
    default:
      return nullptr;
  }
}

std::string NodeLocationTypeToString(NodeLocationType value) {
  const char *str = NodeLocationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NodeLocationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NodeLocationType value) {
  return os << NodeLocationTypeToString(value);
}

namespace internal {
// static
bool InnerTextSegment_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const InnerTextSegment_Data* object = static_cast<const InnerTextSegment_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case InnerTextSegment_Tag::kNodeLocation: {


      if (!::blink::mojom::internal::NodeLocationType_Data
            ::Validate(object->data.f_node_location, validation_context))
        return false;
      return true;
    }
    case InnerTextSegment_Tag::kText: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_text, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_text, validation_context,
                                             &text_validate_params)) {
        return false;
      }
      return true;
    }
    case InnerTextSegment_Tag::kFrame: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_frame, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_frame, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in InnerTextSegment");
      return false;
    }
  }
}


// static
bool InnerTextFrame_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InnerTextFrame_Data* object =
      static_cast<const InnerTextFrame_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->segments, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& segments_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->segments, validation_context,
                                         &segments_validate_params)) {
    return false;
  }

  return true;
}

InnerTextFrame_Data::InnerTextFrame_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InnerTextParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InnerTextParams_Data* object =
      static_cast<const InnerTextParams_Data*>(data);

  return true;
}

InnerTextParams_Data::InnerTextParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InnerTextAgent_GetInnerText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InnerTextAgent_GetInnerText_Params_Data* object =
      static_cast<const InnerTextAgent_GetInnerText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

InnerTextAgent_GetInnerText_Params_Data::InnerTextAgent_GetInnerText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InnerTextAgent_GetInnerText_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InnerTextAgent_GetInnerText_ResponseParams_Data* object =
      static_cast<const InnerTextAgent_GetInnerText_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  return true;
}

InnerTextAgent_GetInnerText_ResponseParams_Data::InnerTextAgent_GetInnerText_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::NodeLocationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::NodeLocationType value) {
  return std::move(context).WriteString(::blink::mojom::NodeLocationTypeToString(value));
}

} // namespace perfetto