// media/mojo/mojom/audio_stream_factory.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_STREAM_FACTORY_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_AUDIO_STREAM_FACTORY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_stream_factory.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_stream_factory.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_stream_factory.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_data_pipe.mojom-blink-forward.h"
#include "media/mojo/mojom/audio_input_stream.mojom-blink-forward.h"
#include "media/mojo/mojom/audio_logging.mojom-blink-forward.h"
#include "media/mojo/mojom/audio_output_stream.mojom-blink-forward.h"
#include "media/mojo/mojom/audio_parameters.mojom-blink.h"
#include "media/mojo/mojom/audio_processing.mojom-blink-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "sandbox/policy/mojom/context.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class LocalMuterProxy;

template <typename ImplRefTraits>
class LocalMuterStub;

class LocalMuterRequestValidator;


class BLINK_PLATFORM_EXPORT LocalMuter
    : public LocalMuterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalMuterInterfaceBase;
  using Proxy_ = LocalMuterProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalMuterStub<ImplRefTraits>;

  using RequestValidator_ = LocalMuterRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalMuter() = default;
};

class AudioStreamFactoryProxy;

template <typename ImplRefTraits>
class AudioStreamFactoryStub;

class AudioStreamFactoryRequestValidator;
class AudioStreamFactoryResponseValidator;


class BLINK_PLATFORM_EXPORT AudioStreamFactory
    : public AudioStreamFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioStreamFactoryInterfaceBase;
  using Proxy_ = AudioStreamFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioStreamFactoryStub<ImplRefTraits>;

  using RequestValidator_ = AudioStreamFactoryRequestValidator;
  using ResponseValidator_ = AudioStreamFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateInputStreamMinVersion = 0,
    kAssociateInputAndOutputForAecMinVersion = 0,
    kCreateOutputStreamMinVersion = 0,
    kCreateSwitchableOutputStreamMinVersion = 0,
    kBindMuterMinVersion = 0,
    kCreateLoopbackStreamMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateInputStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AssociateInputAndOutputForAec_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateOutputStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateSwitchableOutputStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindMuter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateLoopbackStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioStreamFactory() = default;


  using CreateInputStreamCallback = base::OnceCallback<void(::media::mojom::blink::ReadWriteAudioDataPipePtr, bool, const std::optional<::base::UnguessableToken>&)>;
  
  virtual void CreateInputStream(::mojo::PendingReceiver<::media::mojom::blink::AudioInputStream> stream, ::mojo::PendingRemote<::media::mojom::blink::AudioInputStreamClient> client, ::mojo::PendingRemote<::media::mojom::blink::AudioInputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::blink::AudioLog> log, const WTF::String& device_id, const ::media::AudioParameters& params, uint32_t shared_memory_count, bool enable_agc, ::media::mojom::blink::AudioProcessingConfigPtr processing_config, CreateInputStreamCallback callback) = 0;

  
  virtual void AssociateInputAndOutputForAec(const ::base::UnguessableToken& input_stream_id, const WTF::String& output_device_id) = 0;


  using CreateOutputStreamCallback = base::OnceCallback<void(::media::mojom::blink::ReadWriteAudioDataPipePtr)>;
  
  virtual void CreateOutputStream(::mojo::PendingReceiver<::media::mojom::blink::AudioOutputStream> stream, ::mojo::PendingAssociatedRemote<::media::mojom::blink::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::blink::AudioLog> log, const WTF::String& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, CreateOutputStreamCallback callback) = 0;


  using CreateSwitchableOutputStreamCallback = base::OnceCallback<void(::media::mojom::blink::ReadWriteAudioDataPipePtr)>;
  
  virtual void CreateSwitchableOutputStream(::mojo::PendingReceiver<::media::mojom::blink::AudioOutputStream> stream, ::mojo::PendingReceiver<::media::mojom::blink::DeviceSwitchInterface> device_switch_receiver, ::mojo::PendingAssociatedRemote<::media::mojom::blink::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::blink::AudioLog> log, const WTF::String& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, CreateSwitchableOutputStreamCallback callback) = 0;

  
  virtual void BindMuter(::mojo::PendingAssociatedReceiver<LocalMuter> receiver, const ::base::UnguessableToken& group_id) = 0;


  using CreateLoopbackStreamCallback = base::OnceCallback<void(::media::mojom::blink::ReadWriteAudioDataPipePtr)>;
  
  virtual void CreateLoopbackStream(::mojo::PendingReceiver<::media::mojom::blink::AudioInputStream> receiver, ::mojo::PendingRemote<::media::mojom::blink::AudioInputStreamClient> client, ::mojo::PendingRemote<::media::mojom::blink::AudioInputStreamObserver> observer, const ::media::AudioParameters& params, uint32_t shared_memory_count, const ::base::UnguessableToken& group_id, CreateLoopbackStreamCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT LocalMuterProxy
    : public LocalMuter {
 public:
  using InterfaceType = LocalMuter;

  explicit LocalMuterProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT AudioStreamFactoryProxy
    : public AudioStreamFactory {
 public:
  using InterfaceType = AudioStreamFactory;

  explicit AudioStreamFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateInputStream(::mojo::PendingReceiver<::media::mojom::blink::AudioInputStream> stream, ::mojo::PendingRemote<::media::mojom::blink::AudioInputStreamClient> client, ::mojo::PendingRemote<::media::mojom::blink::AudioInputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::blink::AudioLog> log, const WTF::String& device_id, const ::media::AudioParameters& params, uint32_t shared_memory_count, bool enable_agc, ::media::mojom::blink::AudioProcessingConfigPtr processing_config, CreateInputStreamCallback callback) final;
  
  void AssociateInputAndOutputForAec(const ::base::UnguessableToken& input_stream_id, const WTF::String& output_device_id) final;
  
  void CreateOutputStream(::mojo::PendingReceiver<::media::mojom::blink::AudioOutputStream> stream, ::mojo::PendingAssociatedRemote<::media::mojom::blink::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::blink::AudioLog> log, const WTF::String& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, CreateOutputStreamCallback callback) final;
  
  void CreateSwitchableOutputStream(::mojo::PendingReceiver<::media::mojom::blink::AudioOutputStream> stream, ::mojo::PendingReceiver<::media::mojom::blink::DeviceSwitchInterface> device_switch_receiver, ::mojo::PendingAssociatedRemote<::media::mojom::blink::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::blink::AudioLog> log, const WTF::String& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, CreateSwitchableOutputStreamCallback callback) final;
  
  void BindMuter(::mojo::PendingAssociatedReceiver<LocalMuter> receiver, const ::base::UnguessableToken& group_id) final;
  
  void CreateLoopbackStream(::mojo::PendingReceiver<::media::mojom::blink::AudioInputStream> receiver, ::mojo::PendingRemote<::media::mojom::blink::AudioInputStreamClient> client, ::mojo::PendingRemote<::media::mojom::blink::AudioInputStreamObserver> observer, const ::media::AudioParameters& params, uint32_t shared_memory_count, const ::base::UnguessableToken& group_id, CreateLoopbackStreamCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT LocalMuterStubDispatch {
 public:
  static bool Accept(LocalMuter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalMuter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalMuter>>
class LocalMuterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalMuterStub() = default;
  ~LocalMuterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMuterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMuterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT AudioStreamFactoryStubDispatch {
 public:
  static bool Accept(AudioStreamFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioStreamFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioStreamFactory>>
class AudioStreamFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioStreamFactoryStub() = default;
  ~AudioStreamFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioStreamFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioStreamFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT LocalMuterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioStreamFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioStreamFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_AUDIO_STREAM_FACTORY_MOJOM_BLINK_H_