// media/midi/midi_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/midi/midi_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/midi/midi_service.mojom-params-data.h"
#include "media/midi/midi_service.mojom-shared-message-ids.h"

#include "media/midi/midi_service.mojom-blink-import-headers.h"
#include "media/midi/midi_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace midi::mojom::blink {
PortInfo::PortInfo()
    : id(),
      manufacturer(),
      name(),
      version(),
      state() {}

PortInfo::PortInfo(
    const WTF::String& id_in,
    const WTF::String& manufacturer_in,
    const WTF::String& name_in,
    const WTF::String& version_in,
    PortState state_in)
    : id(std::move(id_in)),
      manufacturer(std::move(manufacturer_in)),
      name(std::move(name_in)),
      version(std::move(version_in)),
      state(std::move(state_in)) {}

PortInfo::~PortInfo() = default;
size_t PortInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->id);
  seed = mojo::internal::WTFHash(seed, this->manufacturer);
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->version);
  seed = mojo::internal::WTFHash(seed, this->state);
  return seed;
}

void PortInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manufacturer"), this->manufacturer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PortState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PortInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char MidiSessionClient::Name_[] = "midi.mojom.MidiSessionClient";

MidiSessionClient::IPCStableHashFunction MidiSessionClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MidiSessionClient>(message.name())) {
    case messages::MidiSessionClient::kAddInputPort: {
      return &MidiSessionClient::AddInputPort_Sym::IPCStableHash;
    }
    case messages::MidiSessionClient::kAddOutputPort: {
      return &MidiSessionClient::AddOutputPort_Sym::IPCStableHash;
    }
    case messages::MidiSessionClient::kSetInputPortState: {
      return &MidiSessionClient::SetInputPortState_Sym::IPCStableHash;
    }
    case messages::MidiSessionClient::kSetOutputPortState: {
      return &MidiSessionClient::SetOutputPortState_Sym::IPCStableHash;
    }
    case messages::MidiSessionClient::kSessionStarted: {
      return &MidiSessionClient::SessionStarted_Sym::IPCStableHash;
    }
    case messages::MidiSessionClient::kAcknowledgeSentData: {
      return &MidiSessionClient::AcknowledgeSentData_Sym::IPCStableHash;
    }
    case messages::MidiSessionClient::kDataReceived: {
      return &MidiSessionClient::DataReceived_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MidiSessionClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MidiSessionClient>(message.name())) {
      case messages::MidiSessionClient::kAddInputPort:
            return "Receive midi::mojom::MidiSessionClient::AddInputPort";
      case messages::MidiSessionClient::kAddOutputPort:
            return "Receive midi::mojom::MidiSessionClient::AddOutputPort";
      case messages::MidiSessionClient::kSetInputPortState:
            return "Receive midi::mojom::MidiSessionClient::SetInputPortState";
      case messages::MidiSessionClient::kSetOutputPortState:
            return "Receive midi::mojom::MidiSessionClient::SetOutputPortState";
      case messages::MidiSessionClient::kSessionStarted:
            return "Receive midi::mojom::MidiSessionClient::SessionStarted";
      case messages::MidiSessionClient::kAcknowledgeSentData:
            return "Receive midi::mojom::MidiSessionClient::AcknowledgeSentData";
      case messages::MidiSessionClient::kDataReceived:
            return "Receive midi::mojom::MidiSessionClient::DataReceived";
    }
  } else {
    switch (static_cast<messages::MidiSessionClient>(message.name())) {
      case messages::MidiSessionClient::kAddInputPort:
            return "Receive reply midi::mojom::MidiSessionClient::AddInputPort";
      case messages::MidiSessionClient::kAddOutputPort:
            return "Receive reply midi::mojom::MidiSessionClient::AddOutputPort";
      case messages::MidiSessionClient::kSetInputPortState:
            return "Receive reply midi::mojom::MidiSessionClient::SetInputPortState";
      case messages::MidiSessionClient::kSetOutputPortState:
            return "Receive reply midi::mojom::MidiSessionClient::SetOutputPortState";
      case messages::MidiSessionClient::kSessionStarted:
            return "Receive reply midi::mojom::MidiSessionClient::SessionStarted";
      case messages::MidiSessionClient::kAcknowledgeSentData:
            return "Receive reply midi::mojom::MidiSessionClient::AcknowledgeSentData";
      case messages::MidiSessionClient::kDataReceived:
            return "Receive reply midi::mojom::MidiSessionClient::DataReceived";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MidiSessionClient::AddInputPort_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)midi::mojom::MidiSessionClient::AddInputPort");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MidiSessionClient::AddOutputPort_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)midi::mojom::MidiSessionClient::AddOutputPort");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MidiSessionClient::SetInputPortState_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)midi::mojom::MidiSessionClient::SetInputPortState");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MidiSessionClient::SetOutputPortState_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)midi::mojom::MidiSessionClient::SetOutputPortState");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MidiSessionClient::SessionStarted_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)midi::mojom::MidiSessionClient::SessionStarted");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MidiSessionClient::AcknowledgeSentData_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)midi::mojom::MidiSessionClient::AcknowledgeSentData");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MidiSessionClient::DataReceived_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)midi::mojom::MidiSessionClient::DataReceived");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MidiSessionClientProxy::MidiSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MidiSessionClientProxy::AddInputPort(
    PortInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send midi::mojom::MidiSessionClient::AddInputPort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type PortInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MidiSessionClient::kAddInputPort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::midi::mojom::internal::MidiSessionClient_AddInputPort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::midi::mojom::PortInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in MidiSessionClient.AddInputPort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MidiSessionClient::Name_);
  message.set_method_name("AddInputPort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MidiSessionClientProxy::AddOutputPort(
    PortInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send midi::mojom::MidiSessionClient::AddOutputPort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type PortInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MidiSessionClient::kAddOutputPort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::midi::mojom::internal::MidiSessionClient_AddOutputPort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::midi::mojom::PortInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in MidiSessionClient.AddOutputPort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MidiSessionClient::Name_);
  message.set_method_name("AddOutputPort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MidiSessionClientProxy::SetInputPortState(
    uint32_t in_port, PortState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send midi::mojom::MidiSessionClient::SetInputPortState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type PortState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MidiSessionClient::kSetInputPortState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::midi::mojom::internal::MidiSessionClient_SetInputPortState_Params_Data> params(
          message);
  params.Allocate();
  params->port = in_port;
  mojo::internal::Serialize<::midi::mojom::PortState>(
      in_state, &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MidiSessionClient::Name_);
  message.set_method_name("SetInputPortState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MidiSessionClientProxy::SetOutputPortState(
    uint32_t in_port, PortState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send midi::mojom::MidiSessionClient::SetOutputPortState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type PortState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MidiSessionClient::kSetOutputPortState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::midi::mojom::internal::MidiSessionClient_SetOutputPortState_Params_Data> params(
          message);
  params.Allocate();
  params->port = in_port;
  mojo::internal::Serialize<::midi::mojom::PortState>(
      in_state, &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MidiSessionClient::Name_);
  message.set_method_name("SetOutputPortState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MidiSessionClientProxy::SessionStarted(
    Result in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send midi::mojom::MidiSessionClient::SessionStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type Result>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MidiSessionClient::kSessionStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::midi::mojom::internal::MidiSessionClient_SessionStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::midi::mojom::Result>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MidiSessionClient::Name_);
  message.set_method_name("SessionStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MidiSessionClientProxy::AcknowledgeSentData(
    uint32_t in_bytes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send midi::mojom::MidiSessionClient::AcknowledgeSentData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes"), in_bytes,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MidiSessionClient::kAcknowledgeSentData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::midi::mojom::internal::MidiSessionClient_AcknowledgeSentData_Params_Data> params(
          message);
  params.Allocate();
  params->bytes = in_bytes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MidiSessionClient::Name_);
  message.set_method_name("AcknowledgeSentData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MidiSessionClientProxy::DataReceived(
    uint32_t in_port, const WTF::Vector<uint8_t>& in_data, ::base::TimeTicks in_timestamp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send midi::mojom::MidiSessionClient::DataReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timestamp"), in_timestamp,
                        "<value of type ::base::TimeTicks>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MidiSessionClient::kDataReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::midi::mojom::internal::MidiSessionClient_DataReceived_Params_Data> params(
          message);
  params.Allocate();
  params->port = in_port;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in MidiSessionClient.DataReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->timestamp)::BaseType> timestamp_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timestamp, timestamp_fragment);
  params->timestamp.Set(
      timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timestamp.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in MidiSessionClient.DataReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MidiSessionClient::Name_);
  message.set_method_name("DataReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MidiSessionClientStubDispatch::Accept(
    MidiSessionClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MidiSessionClient>(message->header()->name)) {
    case messages::MidiSessionClient::kAddInputPort: {
      DCHECK(message->is_serialized());
      internal::MidiSessionClient_AddInputPort_Params_Data* params =
          reinterpret_cast<internal::MidiSessionClient_AddInputPort_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MidiSessionClient.0
      bool success = true;
      PortInfoPtr p_info{};
      MidiSessionClient_AddInputPort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MidiSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddInputPort(        
        std::move(p_info));
      return true;
    }
    case messages::MidiSessionClient::kAddOutputPort: {
      DCHECK(message->is_serialized());
      internal::MidiSessionClient_AddOutputPort_Params_Data* params =
          reinterpret_cast<internal::MidiSessionClient_AddOutputPort_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MidiSessionClient.1
      bool success = true;
      PortInfoPtr p_info{};
      MidiSessionClient_AddOutputPort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MidiSessionClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddOutputPort(        
        std::move(p_info));
      return true;
    }
    case messages::MidiSessionClient::kSetInputPortState: {
      DCHECK(message->is_serialized());
      internal::MidiSessionClient_SetInputPortState_Params_Data* params =
          reinterpret_cast<internal::MidiSessionClient_SetInputPortState_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MidiSessionClient.2
      bool success = true;
      uint32_t p_port{};
      PortState p_state{};
      MidiSessionClient_SetInputPortState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_port = input_data_view.port();
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MidiSessionClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInputPortState(        
        std::move(p_port), 
        std::move(p_state));
      return true;
    }
    case messages::MidiSessionClient::kSetOutputPortState: {
      DCHECK(message->is_serialized());
      internal::MidiSessionClient_SetOutputPortState_Params_Data* params =
          reinterpret_cast<internal::MidiSessionClient_SetOutputPortState_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MidiSessionClient.3
      bool success = true;
      uint32_t p_port{};
      PortState p_state{};
      MidiSessionClient_SetOutputPortState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_port = input_data_view.port();
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MidiSessionClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOutputPortState(        
        std::move(p_port), 
        std::move(p_state));
      return true;
    }
    case messages::MidiSessionClient::kSessionStarted: {
      DCHECK(message->is_serialized());
      internal::MidiSessionClient_SessionStarted_Params_Data* params =
          reinterpret_cast<internal::MidiSessionClient_SessionStarted_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MidiSessionClient.4
      bool success = true;
      Result p_result{};
      MidiSessionClient_SessionStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MidiSessionClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SessionStarted(        
        std::move(p_result));
      return true;
    }
    case messages::MidiSessionClient::kAcknowledgeSentData: {
      DCHECK(message->is_serialized());
      internal::MidiSessionClient_AcknowledgeSentData_Params_Data* params =
          reinterpret_cast<internal::MidiSessionClient_AcknowledgeSentData_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MidiSessionClient.5
      bool success = true;
      uint32_t p_bytes{};
      MidiSessionClient_AcknowledgeSentData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_bytes = input_data_view.bytes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MidiSessionClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcknowledgeSentData(        
        std::move(p_bytes));
      return true;
    }
    case messages::MidiSessionClient::kDataReceived: {
      DCHECK(message->is_serialized());
      internal::MidiSessionClient_DataReceived_Params_Data* params =
          reinterpret_cast<internal::MidiSessionClient_DataReceived_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MidiSessionClient.6
      bool success = true;
      uint32_t p_port{};
      WTF::Vector<uint8_t> p_data{};
      ::base::TimeTicks p_timestamp{};
      MidiSessionClient_DataReceived_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_port = input_data_view.port();
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadTimestamp(&p_timestamp))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MidiSessionClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DataReceived(        
        std::move(p_port), 
        std::move(p_data), 
        std::move(p_timestamp));
      return true;
    }
  }
  return false;
}

// static
bool MidiSessionClientStubDispatch::AcceptWithResponder(
    MidiSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MidiSessionClient>(message->header()->name)) {
    case messages::MidiSessionClient::kAddInputPort: {
      break;
    }
    case messages::MidiSessionClient::kAddOutputPort: {
      break;
    }
    case messages::MidiSessionClient::kSetInputPortState: {
      break;
    }
    case messages::MidiSessionClient::kSetOutputPortState: {
      break;
    }
    case messages::MidiSessionClient::kSessionStarted: {
      break;
    }
    case messages::MidiSessionClient::kAcknowledgeSentData: {
      break;
    }
    case messages::MidiSessionClient::kDataReceived: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMidiSessionClientValidationInfo[] = {
    {base::to_underlying(messages::MidiSessionClient::kAddInputPort),
     { &internal::MidiSessionClient_AddInputPort_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::MidiSessionClient::kAddOutputPort),
     { &internal::MidiSessionClient_AddOutputPort_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::MidiSessionClient::kSetInputPortState),
     { &internal::MidiSessionClient_SetInputPortState_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::MidiSessionClient::kSetOutputPortState),
     { &internal::MidiSessionClient_SetOutputPortState_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::MidiSessionClient::kSessionStarted),
     { &internal::MidiSessionClient_SessionStarted_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::MidiSessionClient::kAcknowledgeSentData),
     { &internal::MidiSessionClient_AcknowledgeSentData_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::MidiSessionClient::kDataReceived),
     { &internal::MidiSessionClient_DataReceived_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MidiSessionClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::midi::mojom::blink::MidiSessionClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMidiSessionClientValidationInfo);
}

const char MidiSessionProvider::Name_[] = "midi.mojom.MidiSessionProvider";

MidiSessionProvider::IPCStableHashFunction MidiSessionProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MidiSessionProvider>(message.name())) {
    case messages::MidiSessionProvider::kStartSession: {
      return &MidiSessionProvider::StartSession_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MidiSessionProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MidiSessionProvider>(message.name())) {
      case messages::MidiSessionProvider::kStartSession:
            return "Receive midi::mojom::MidiSessionProvider::StartSession";
    }
  } else {
    switch (static_cast<messages::MidiSessionProvider>(message.name())) {
      case messages::MidiSessionProvider::kStartSession:
            return "Receive reply midi::mojom::MidiSessionProvider::StartSession";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MidiSessionProvider::StartSession_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)midi::mojom::MidiSessionProvider::StartSession");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MidiSessionProviderProxy::MidiSessionProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MidiSessionProviderProxy::StartSession(
    ::mojo::PendingReceiver<MidiSession> in_receiver, ::mojo::PendingRemote<MidiSessionClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send midi::mojom::MidiSessionProvider::StartSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<MidiSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<MidiSessionClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MidiSessionProvider::kStartSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::midi::mojom::internal::MidiSessionProvider_StartSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::midi::mojom::MidiSessionInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in MidiSessionProvider.StartSession request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::midi::mojom::MidiSessionClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in MidiSessionProvider.StartSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MidiSessionProvider::Name_);
  message.set_method_name("StartSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MidiSessionProviderStubDispatch::Accept(
    MidiSessionProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MidiSessionProvider>(message->header()->name)) {
    case messages::MidiSessionProvider::kStartSession: {
      DCHECK(message->is_serialized());
      internal::MidiSessionProvider_StartSession_Params_Data* params =
          reinterpret_cast<internal::MidiSessionProvider_StartSession_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MidiSessionProvider.0
      bool success = true;
      ::mojo::PendingReceiver<MidiSession> p_receiver{};
      ::mojo::PendingRemote<MidiSessionClient> p_client{};
      MidiSessionProvider_StartSession_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MidiSessionProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSession(        
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool MidiSessionProviderStubDispatch::AcceptWithResponder(
    MidiSessionProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MidiSessionProvider>(message->header()->name)) {
    case messages::MidiSessionProvider::kStartSession: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMidiSessionProviderValidationInfo[] = {
    {base::to_underlying(messages::MidiSessionProvider::kStartSession),
     { &internal::MidiSessionProvider_StartSession_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MidiSessionProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::midi::mojom::blink::MidiSessionProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMidiSessionProviderValidationInfo);
}

const char MidiSession::Name_[] = "midi.mojom.MidiSession";

MidiSession::IPCStableHashFunction MidiSession::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MidiSession>(message.name())) {
    case messages::MidiSession::kSendData: {
      return &MidiSession::SendData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MidiSession::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MidiSession>(message.name())) {
      case messages::MidiSession::kSendData:
            return "Receive midi::mojom::MidiSession::SendData";
    }
  } else {
    switch (static_cast<messages::MidiSession>(message.name())) {
      case messages::MidiSession::kSendData:
            return "Receive reply midi::mojom::MidiSession::SendData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MidiSession::SendData_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)midi::mojom::MidiSession::SendData");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MidiSessionProxy::MidiSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MidiSessionProxy::SendData(
    uint32_t in_port, const WTF::Vector<uint8_t>& in_data, ::base::TimeTicks in_timestamp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send midi::mojom::MidiSession::SendData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timestamp"), in_timestamp,
                        "<value of type ::base::TimeTicks>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MidiSession::kSendData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::midi::mojom::internal::MidiSession_SendData_Params_Data> params(
          message);
  params.Allocate();
  params->port = in_port;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in MidiSession.SendData request");
  mojo::internal::MessageFragment<
      typename decltype(params->timestamp)::BaseType> timestamp_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_timestamp, timestamp_fragment);
  params->timestamp.Set(
      timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timestamp.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in MidiSession.SendData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MidiSession::Name_);
  message.set_method_name("SendData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MidiSessionStubDispatch::Accept(
    MidiSession* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MidiSession>(message->header()->name)) {
    case messages::MidiSession::kSendData: {
      DCHECK(message->is_serialized());
      internal::MidiSession_SendData_Params_Data* params =
          reinterpret_cast<internal::MidiSession_SendData_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MidiSession.0
      bool success = true;
      uint32_t p_port{};
      WTF::Vector<uint8_t> p_data{};
      ::base::TimeTicks p_timestamp{};
      MidiSession_SendData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_port = input_data_view.port();
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadTimestamp(&p_timestamp))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MidiSession::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendData(        
        std::move(p_port), 
        std::move(p_data), 
        std::move(p_timestamp));
      return true;
    }
  }
  return false;
}

// static
bool MidiSessionStubDispatch::AcceptWithResponder(
    MidiSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MidiSession>(message->header()->name)) {
    case messages::MidiSession::kSendData: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMidiSessionValidationInfo[] = {
    {base::to_underlying(messages::MidiSession::kSendData),
     { &internal::MidiSession_SendData_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MidiSessionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::midi::mojom::blink::MidiSession::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMidiSessionValidationInfo);
}



}  // midi::mojom::blink


namespace mojo {


// static
bool StructTraits<::midi::mojom::blink::PortInfo::DataView, ::midi::mojom::blink::PortInfoPtr>::Read(
    ::midi::mojom::blink::PortInfo::DataView input,
    ::midi::mojom::blink::PortInfoPtr* output) {
  bool success = true;
  ::midi::mojom::blink::PortInfoPtr result(::midi::mojom::blink::PortInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadManufacturer(&result->manufacturer))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadState(&result->state))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace midi::mojom::blink {


void MidiSessionClientInterceptorForTesting::AddInputPort(PortInfoPtr info) {
  GetForwardingInterface()->AddInputPort(
    std::move(info)
    );
}
void MidiSessionClientInterceptorForTesting::AddOutputPort(PortInfoPtr info) {
  GetForwardingInterface()->AddOutputPort(
    std::move(info)
    );
}
void MidiSessionClientInterceptorForTesting::SetInputPortState(uint32_t port, PortState state) {
  GetForwardingInterface()->SetInputPortState(
    std::move(port)
    , 
    std::move(state)
    );
}
void MidiSessionClientInterceptorForTesting::SetOutputPortState(uint32_t port, PortState state) {
  GetForwardingInterface()->SetOutputPortState(
    std::move(port)
    , 
    std::move(state)
    );
}
void MidiSessionClientInterceptorForTesting::SessionStarted(Result result) {
  GetForwardingInterface()->SessionStarted(
    std::move(result)
    );
}
void MidiSessionClientInterceptorForTesting::AcknowledgeSentData(uint32_t bytes) {
  GetForwardingInterface()->AcknowledgeSentData(
    std::move(bytes)
    );
}
void MidiSessionClientInterceptorForTesting::DataReceived(uint32_t port, const WTF::Vector<uint8_t>& data, ::base::TimeTicks timestamp) {
  GetForwardingInterface()->DataReceived(
    std::move(port)
    , 
    std::move(data)
    , 
    std::move(timestamp)
    );
}
MidiSessionClientAsyncWaiter::MidiSessionClientAsyncWaiter(
    MidiSessionClient* proxy) : proxy_(proxy) {}

MidiSessionClientAsyncWaiter::~MidiSessionClientAsyncWaiter() = default;




void MidiSessionProviderInterceptorForTesting::StartSession(::mojo::PendingReceiver<MidiSession> receiver, ::mojo::PendingRemote<MidiSessionClient> client) {
  GetForwardingInterface()->StartSession(
    std::move(receiver)
    , 
    std::move(client)
    );
}
MidiSessionProviderAsyncWaiter::MidiSessionProviderAsyncWaiter(
    MidiSessionProvider* proxy) : proxy_(proxy) {}

MidiSessionProviderAsyncWaiter::~MidiSessionProviderAsyncWaiter() = default;




void MidiSessionInterceptorForTesting::SendData(uint32_t port, const WTF::Vector<uint8_t>& data, ::base::TimeTicks timestamp) {
  GetForwardingInterface()->SendData(
    std::move(port)
    , 
    std::move(data)
    , 
    std::move(timestamp)
    );
}
MidiSessionAsyncWaiter::MidiSessionAsyncWaiter(
    MidiSession* proxy) : proxy_(proxy) {}

MidiSessionAsyncWaiter::~MidiSessionAsyncWaiter() = default;






}  // midi::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif