// device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared-internal.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"



#include "base/component_export.h"




namespace device::mojom {
class XRHandJointDataDataView;

class XRHandTrackingDataDataView;



}  // device::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::XRHandJointDataDataView> {
  using Data = ::device::mojom::internal::XRHandJointData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHandTrackingDataDataView> {
  using Data = ::device::mojom::internal::XRHandTrackingData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class XRHandJoint : int32_t {
  
  kWrist = 0,
  
  kThumbMetacarpal = 1,
  
  kThumbPhalanxProximal = 2,
  
  kThumbPhalanxDistal = 3,
  
  kThumbTip = 4,
  
  kIndexFingerMetacarpal = 5,
  
  kIndexFingerPhalanxProximal = 6,
  
  kIndexFingerPhalanxIntermediate = 7,
  
  kIndexFingerPhalanxDistal = 8,
  
  kIndexFingerTip = 9,
  
  kMiddleFingerMetacarpal = 10,
  
  kMiddleFingerPhalanxProximal = 11,
  
  kMiddleFingerPhalanxIntermediate = 12,
  
  kMiddleFingerPhalanxDistal = 13,
  
  kMiddleFingerTip = 14,
  
  kRingFingerMetacarpal = 15,
  
  kRingFingerPhalanxProximal = 16,
  
  kRingFingerPhalanxIntermediate = 17,
  
  kRingFingerPhalanxDistal = 18,
  
  kRingFingerTip = 19,
  
  kPinkyFingerMetacarpal = 20,
  
  kPinkyFingerPhalanxProximal = 21,
  
  kPinkyFingerPhalanxIntermediate = 22,
  
  kPinkyFingerPhalanxDistal = 23,
  
  kPinkyFingerTip = 24,
  kMinValue = 0,
  kMaxValue = 24,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRHandJoint value);
inline bool IsKnownEnumValue(XRHandJoint value) {
  return internal::XRHandJoint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class XRHandJointDataDataView {
 public:
  XRHandJointDataDataView() = default;

  XRHandJointDataDataView(
      internal::XRHandJointData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadJoint(UserType* output) const {
    auto data_value = data_->joint;
    return mojo::internal::Deserialize<::device::mojom::XRHandJoint>(
        data_value, output);
  }
  XRHandJoint joint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRHandJoint>(data_->joint));
  }
  inline void GetMojoFromJointDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromJoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `mojo_from_joint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromJoint` instead "
    "of `ReadMojoFromJoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_joint.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  float radius() const {
    return data_->radius;
  }
 private:
  internal::XRHandJointData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHandTrackingDataDataView {
 public:
  XRHandTrackingDataDataView() = default;

  XRHandTrackingDataDataView(
      internal::XRHandTrackingData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHandJointDataDataView(
      mojo::ArrayDataView<XRHandJointDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHandJointData(UserType* output) {
    
    auto* pointer = data_->hand_joint_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHandJointDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRHandTrackingData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // device::mojom

namespace std {

template <>
struct hash<::device::mojom::XRHandJoint>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRHandJoint> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHandJoint, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRHandJoint, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRHandJoint>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHandJointDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHandJointDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHandJointData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::device::mojom::XRHandJoint>(
        Traits::joint(input), &fragment->joint);
    decltype(Traits::mojo_from_joint(input)) in_mojo_from_joint = Traits::mojo_from_joint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_joint)::BaseType> mojo_from_joint_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_mojo_from_joint, mojo_from_joint_fragment);
    fragment->mojo_from_joint.Set(
        mojo_from_joint_fragment.is_null() ? nullptr : mojo_from_joint_fragment.data());
    fragment->radius = Traits::radius(input);
  }

  static bool Deserialize(::device::mojom::internal::XRHandJointData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHandJointDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHandTrackingDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHandTrackingDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHandTrackingData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::hand_joint_data(input)) in_hand_joint_data = Traits::hand_joint_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hand_joint_data)::BaseType>
        hand_joint_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hand_joint_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHandJointDataDataView>>(
        in_hand_joint_data, hand_joint_data_fragment, &hand_joint_data_validate_params);
    fragment->hand_joint_data.Set(
        hand_joint_data_fragment.is_null() ? nullptr : hand_joint_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hand_joint_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hand_joint_data in XRHandTrackingData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRHandTrackingData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHandTrackingDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void XRHandJointDataDataView::GetMojoFromJointDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->mojo_from_joint.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}


inline void XRHandTrackingDataDataView::GetHandJointDataDataView(
    mojo::ArrayDataView<XRHandJointDataDataView>* output) {
  auto pointer = data_->hand_joint_data.Get();
  *output = mojo::ArrayDataView<XRHandJointDataDataView>(pointer, message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRHandJoint> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRHandJoint value);
};

} // namespace perfetto

#endif  // DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_SHARED_H_