// ui/accessibility/mojom/ax_node_data.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_BLINK_H_
#define UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_node_data.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_node_data.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_node_data.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/accessibility/ax_enums.mojom-blink.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace ax::mojom::blink {








class  AXNodeData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXNodeData, T>::value>;
  using DataView = AXNodeDataDataView;
  using Data_ = internal::AXNodeData_Data;

  template <typename... Args>
  static AXNodeDataPtr New(Args&&... args) {
    return AXNodeDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXNodeDataPtr From(const U& u) {
    return mojo::TypeConverter<AXNodeDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXNodeData>::Convert(*this);
  }


  AXNodeData();

  AXNodeData(
      int32_t id,
      ::ax::mojom::blink::Role role,
      uint32_t state,
      uint64_t actions,
      const WTF::HashMap<::ax::mojom::blink::StringAttribute, WTF::String>& string_attributes,
      const WTF::HashMap<::ax::mojom::blink::IntAttribute, int32_t>& int_attributes,
      const WTF::HashMap<::ax::mojom::blink::FloatAttribute, float>& float_attributes,
      const WTF::HashMap<::ax::mojom::blink::BoolAttribute, bool>& bool_attributes,
      const WTF::HashMap<::ax::mojom::blink::IntListAttribute, WTF::Vector<int32_t>>& intlist_attributes,
      const WTF::HashMap<::ax::mojom::blink::StringListAttribute, WTF::Vector<WTF::String>>& stringlist_attributes,
      const WTF::HashMap<WTF::String, WTF::String>& html_attributes,
      WTF::Vector<int32_t> child_ids,
      const ::ui::AXRelativeBounds& relative_bounds);


  ~AXNodeData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXNodeDataPtr>
  AXNodeDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXNodeData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXNodeData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXNodeData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXNodeData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXNodeData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXNodeData_UnserializedMessageContext<
            UserType, AXNodeData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXNodeData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXNodeData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXNodeData_UnserializedMessageContext<
            UserType, AXNodeData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXNodeData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  ::ax::mojom::blink::Role role;
  
  uint32_t state;
  
  uint64_t actions;
  
  WTF::HashMap<::ax::mojom::blink::StringAttribute, WTF::String> string_attributes;
  
  WTF::HashMap<::ax::mojom::blink::IntAttribute, int32_t> int_attributes;
  
  WTF::HashMap<::ax::mojom::blink::FloatAttribute, float> float_attributes;
  
  WTF::HashMap<::ax::mojom::blink::BoolAttribute, bool> bool_attributes;
  
  WTF::HashMap<::ax::mojom::blink::IntListAttribute, WTF::Vector<int32_t>> intlist_attributes;
  
  WTF::HashMap<::ax::mojom::blink::StringListAttribute, WTF::Vector<WTF::String>> stringlist_attributes;
  
  WTF::HashMap<WTF::String, WTF::String> html_attributes;
  
  WTF::Vector<int32_t> child_ids;
  
  ::ui::AXRelativeBounds relative_bounds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXNodeData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXNodeData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXNodeData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXNodeData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AXNodeDataPtr AXNodeData::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(role),
      mojo::Clone(state),
      mojo::Clone(actions),
      mojo::Clone(string_attributes),
      mojo::Clone(int_attributes),
      mojo::Clone(float_attributes),
      mojo::Clone(bool_attributes),
      mojo::Clone(intlist_attributes),
      mojo::Clone(stringlist_attributes),
      mojo::Clone(html_attributes),
      mojo::Clone(child_ids),
      mojo::Clone(relative_bounds)
  );
}

template <typename T, AXNodeData::EnableIfSame<T>*>
bool AXNodeData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->role, other_struct.role))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->actions, other_struct.actions))
    return false;
  if (!mojo::Equals(this->string_attributes, other_struct.string_attributes))
    return false;
  if (!mojo::Equals(this->int_attributes, other_struct.int_attributes))
    return false;
  if (!mojo::Equals(this->float_attributes, other_struct.float_attributes))
    return false;
  if (!mojo::Equals(this->bool_attributes, other_struct.bool_attributes))
    return false;
  if (!mojo::Equals(this->intlist_attributes, other_struct.intlist_attributes))
    return false;
  if (!mojo::Equals(this->stringlist_attributes, other_struct.stringlist_attributes))
    return false;
  if (!mojo::Equals(this->html_attributes, other_struct.html_attributes))
    return false;
  if (!mojo::Equals(this->child_ids, other_struct.child_ids))
    return false;
  if (!mojo::Equals(this->relative_bounds, other_struct.relative_bounds))
    return false;
  return true;
}

template <typename T, AXNodeData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.role < rhs.role)
    return true;
  if (rhs.role < lhs.role)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.actions < rhs.actions)
    return true;
  if (rhs.actions < lhs.actions)
    return false;
  if (lhs.string_attributes < rhs.string_attributes)
    return true;
  if (rhs.string_attributes < lhs.string_attributes)
    return false;
  if (lhs.int_attributes < rhs.int_attributes)
    return true;
  if (rhs.int_attributes < lhs.int_attributes)
    return false;
  if (lhs.float_attributes < rhs.float_attributes)
    return true;
  if (rhs.float_attributes < lhs.float_attributes)
    return false;
  if (lhs.bool_attributes < rhs.bool_attributes)
    return true;
  if (rhs.bool_attributes < lhs.bool_attributes)
    return false;
  if (lhs.intlist_attributes < rhs.intlist_attributes)
    return true;
  if (rhs.intlist_attributes < lhs.intlist_attributes)
    return false;
  if (lhs.stringlist_attributes < rhs.stringlist_attributes)
    return true;
  if (rhs.stringlist_attributes < lhs.stringlist_attributes)
    return false;
  if (lhs.html_attributes < rhs.html_attributes)
    return true;
  if (rhs.html_attributes < lhs.html_attributes)
    return false;
  if (lhs.child_ids < rhs.child_ids)
    return true;
  if (rhs.child_ids < lhs.child_ids)
    return false;
  if (lhs.relative_bounds < rhs.relative_bounds)
    return true;
  if (rhs.relative_bounds < lhs.relative_bounds)
    return false;
  return false;
}


}  // ax::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::blink::AXNodeData::DataView,
                                         ::ax::mojom::blink::AXNodeDataPtr> {
  static bool IsNull(const ::ax::mojom::blink::AXNodeDataPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::blink::AXNodeDataPtr* output) { output->reset(); }

  static decltype(::ax::mojom::blink::AXNodeData::id) id(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->id;
  }

  static decltype(::ax::mojom::blink::AXNodeData::role) role(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->role;
  }

  static decltype(::ax::mojom::blink::AXNodeData::state) state(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->state;
  }

  static decltype(::ax::mojom::blink::AXNodeData::actions) actions(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->actions;
  }

  static const decltype(::ax::mojom::blink::AXNodeData::string_attributes)& string_attributes(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->string_attributes;
  }

  static const decltype(::ax::mojom::blink::AXNodeData::int_attributes)& int_attributes(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->int_attributes;
  }

  static const decltype(::ax::mojom::blink::AXNodeData::float_attributes)& float_attributes(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->float_attributes;
  }

  static const decltype(::ax::mojom::blink::AXNodeData::bool_attributes)& bool_attributes(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->bool_attributes;
  }

  static const decltype(::ax::mojom::blink::AXNodeData::intlist_attributes)& intlist_attributes(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->intlist_attributes;
  }

  static const decltype(::ax::mojom::blink::AXNodeData::stringlist_attributes)& stringlist_attributes(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->stringlist_attributes;
  }

  static const decltype(::ax::mojom::blink::AXNodeData::html_attributes)& html_attributes(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->html_attributes;
  }

  static const decltype(::ax::mojom::blink::AXNodeData::child_ids)& child_ids(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->child_ids;
  }

  static const decltype(::ax::mojom::blink::AXNodeData::relative_bounds)& relative_bounds(
      const ::ax::mojom::blink::AXNodeDataPtr& input) {
    return input->relative_bounds;
  }

  static bool Read(::ax::mojom::blink::AXNodeData::DataView input, ::ax::mojom::blink::AXNodeDataPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_BLINK_H_