// services/network/public/mojom/transferable_directory.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_DIRECTORY_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_DIRECTORY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/transferable_directory.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/transferable_directory.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/transferable_directory.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {





class BLINK_PLATFORM_EXPORT TransferableDirectory {
 public:
  using DataView = TransferableDirectoryDataView;
  using Data_ = internal::TransferableDirectory_Data;
  using Tag = Data_::TransferableDirectory_Tag;

  template <typename... Args>
  static TransferableDirectoryPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |handle_for_ipc|.
  static TransferableDirectoryPtr
  NewHandleForIpc(
      ::mojo::PlatformHandle value) {
    auto result = TransferableDirectoryPtr(std::in_place);
    result->set_handle_for_ipc(std::move(value));
    return result;
  }
  // Construct an instance holding |path|.
  static TransferableDirectoryPtr
  NewPath(
      const ::base::FilePath& value) {
    auto result = TransferableDirectoryPtr(std::in_place);
    result->set_path(std::move(value));
    return result;
  }

  template <typename U>
  static TransferableDirectoryPtr From(const U& u) {
    return mojo::TypeConverter<TransferableDirectoryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransferableDirectory>::Convert(*this);
  }

  TransferableDirectory();
  ~TransferableDirectory();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TransferableDirectory(const TransferableDirectory& other) = delete;
  TransferableDirectory& operator=(const TransferableDirectory& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TransferableDirectoryPtr>
  TransferableDirectoryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TransferableDirectory>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TransferableDirectory>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_handle_for_ipc() const { return tag_ == Tag::kHandleForIpc; }

  
  ::mojo::PlatformHandle& get_handle_for_ipc() const {
    CHECK(tag_ == Tag::kHandleForIpc);
    return *(data_.handle_for_ipc);
  }

  
  void set_handle_for_ipc(
      ::mojo::PlatformHandle handle_for_ipc);
  
  bool is_path() const { return tag_ == Tag::kPath; }

  
  ::base::FilePath& get_path() const {
    CHECK(tag_ == Tag::kPath);
    return *(data_.path);
  }

  
  void set_path(
      const ::base::FilePath& path);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransferableDirectory::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TransferableDirectory::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    ::mojo::PlatformHandle* handle_for_ipc;
    ::base::FilePath* path;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
TransferableDirectoryPtr TransferableDirectory::Clone() const {
  switch (tag_) {
    case Tag::kHandleForIpc:
      return NewHandleForIpc(
          mojo::Clone(*data_.handle_for_ipc));
    case Tag::kPath:
      return NewPath(
          mojo::Clone(*data_.path));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TransferableDirectory>::value>::type*>
bool TransferableDirectory::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kHandleForIpc:
      return mojo::Equals(*(data_.handle_for_ipc), *(other.data_.handle_for_ipc));
    case Tag::kPath:
      return mojo::Equals(*(data_.path), *(other.data_.path));
  }

  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::network::mojom::blink::TransferableDirectory::DataView,
                                        ::network::mojom::blink::TransferableDirectoryPtr> {
  static bool IsNull(const ::network::mojom::blink::TransferableDirectoryPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::TransferableDirectoryPtr* output) { output->reset(); }

  static ::network::mojom::blink::TransferableDirectory::Tag GetTag(const ::network::mojom::blink::TransferableDirectoryPtr& input) {
    return input->which();
  }

  static  ::mojo::PlatformHandle& handle_for_ipc( ::network::mojom::blink::TransferableDirectoryPtr& input) {
    return input->get_handle_for_ipc();
  }

  static const ::base::FilePath& path(const ::network::mojom::blink::TransferableDirectoryPtr& input) {
    return input->get_path();
  }

  static bool Read(::network::mojom::blink::TransferableDirectory::DataView input, ::network::mojom::blink::TransferableDirectoryPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_DIRECTORY_MOJOM_BLINK_H_