/* PolkitDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PolkitDialog.vala, do not modify */

/*-
 * Copyright (c) 2015-2019 elementary, Inc. (https://elementary.io)
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */
/*
 * Code based on budgie-desktop:
 * https://github.com/solus-project/budgie-desktop
 */

#include <granite-7.h>
#include <pantheon-wayland.h>
#include <glib-object.h>
#include <glib.h>
#include <polkitagent/polkitagent.h>
#include <polkit/polkit.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <pwd.h>
#include <sys/types.h>
#include <grp.h>
#include <adwaita.h>
#include <gsk/gsk.h>
#include <graphene-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AG_TYPE_POLKIT_DIALOG (ag_polkit_dialog_get_type ())
#define AG_POLKIT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_POLKIT_DIALOG, AgPolkitDialog))
#define AG_POLKIT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AG_TYPE_POLKIT_DIALOG, AgPolkitDialogClass))
#define AG_IS_POLKIT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_POLKIT_DIALOG))
#define AG_IS_POLKIT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AG_TYPE_POLKIT_DIALOG))
#define AG_POLKIT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AG_TYPE_POLKIT_DIALOG, AgPolkitDialogClass))

typedef struct _AgPolkitDialog AgPolkitDialog;
typedef struct _AgPolkitDialogClass AgPolkitDialogClass;
typedef struct _AgPolkitDialogPrivate AgPolkitDialogPrivate;
enum  {
	AG_POLKIT_DIALOG_0_PROPERTY,
	AG_POLKIT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* ag_polkit_dialog_properties[AG_POLKIT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
enum  {
	AG_POLKIT_DIALOG_DONE_SIGNAL,
	AG_POLKIT_DIALOG_NUM_SIGNALS
};
static guint ag_polkit_dialog_signals[AG_POLKIT_DIALOG_NUM_SIGNALS] = {0};

struct _AgPolkitDialog {
	GraniteMessageDialog parent_instance;
	AgPolkitDialogPrivate * priv;
	gboolean was_canceled;
};

struct _AgPolkitDialogClass {
	GraniteMessageDialogClass parent_class;
};

struct _AgPolkitDialogPrivate {
	PolkitAgentSession* pk_session;
	PolkitIdentity* pk_identity;
	GCancellable* cancellable;
	gulong error_signal_id;
	gulong request_signal_id;
	gulong info_signal_id;
	gulong complete_signal_id;
	GList* idents;
	gchar* cookie;
	gboolean canceling;
	GtkRevealer* feedback_revealer;
	GtkLabel* password_label;
	GtkLabel* password_feedback;
	GtkPasswordEntry* password_entry;
	GtkComboBox* idents_combo;
};

struct _Block2Data {
	int _ref_count_;
	AgPolkitDialog* self;
	gint width;
	gint height;
	AdwTimedAnimation* shake;
	gint repeat_count;
	gulong iterate;
	gchar* text;
};

static gint AgPolkitDialog_private_offset;
static gpointer ag_polkit_dialog_parent_class = NULL;
static PantheonWaylandExtendedBehaviorIface * ag_polkit_dialog_pantheon_wayland_extended_behavior_parent_iface = NULL;

VALA_EXTERN GType ag_polkit_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgPolkitDialog, g_object_unref)
VALA_EXTERN AgPolkitDialog* ag_polkit_dialog_new (const gchar* message,
                                      const gchar* icon_name,
                                      const gchar* _cookie,
                                      GList* _idents,
                                      GCancellable* _cancellable);
VALA_EXTERN AgPolkitDialog* ag_polkit_dialog_construct (GType object_type,
                                            const gchar* message,
                                            const gchar* icon_name,
                                            const gchar* _cookie,
                                            GList* _idents,
                                            GCancellable* _cancellable);
static void ag_polkit_dialog_cancel (AgPolkitDialog* self);
static void _ag_polkit_dialog_cancel_g_cancellable_cancelled (GCancellable* _sender,
                                                       gpointer self);
static void ag_polkit_dialog_on_ident_changed (AgPolkitDialog* self);
static void _ag_polkit_dialog_on_ident_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                               gpointer self);
static void __lambda6_ (AgPolkitDialog* self);
static void ___lambda6__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void ag_polkit_dialog_authenticate (AgPolkitDialog* self);
static void _ag_polkit_dialog_authenticate_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void _ag_polkit_dialog_cancel_gtk_dialog_close (GtkDialog* _sender,
                                                gpointer self);
static void ag_polkit_dialog_update_idents (AgPolkitDialog* self);
static void ag_polkit_dialog_select_session (AgPolkitDialog* self);
static void __lambda7_ (AgPolkitDialog* self);
static void ___lambda7__gtk_widget_realize (GtkWidget* _sender,
                                     gpointer self);
static void ag_polkit_dialog_deselect_session (AgPolkitDialog* self);
static void ag_polkit_dialog_on_pk_show_error (AgPolkitDialog* self,
                                        const gchar* text);
static void _ag_polkit_dialog_on_pk_show_error_polkit_agent_session_show_error (PolkitAgentSession* _sender,
                                                                         const gchar* text,
                                                                         gpointer self);
static void ag_polkit_dialog_on_pk_session_completed (AgPolkitDialog* self,
                                               gboolean authorized);
static void _ag_polkit_dialog_on_pk_session_completed_polkit_agent_session_completed (PolkitAgentSession* _sender,
                                                                               gboolean gained_authorization,
                                                                               gpointer self);
static void ag_polkit_dialog_on_pk_request (AgPolkitDialog* self,
                                     const gchar* request,
                                     gboolean echo_on);
static void _ag_polkit_dialog_on_pk_request_polkit_agent_session_request (PolkitAgentSession* _sender,
                                                                   const gchar* request,
                                                                   gboolean echo_on,
                                                                   gpointer self);
static void ag_polkit_dialog_on_pk_show_info (AgPolkitDialog* self,
                                       const gchar* text);
static void _ag_polkit_dialog_on_pk_show_info_polkit_agent_session_show_info (PolkitAgentSession* _sender,
                                                                       const gchar* text,
                                                                       gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda4_ (Block2Data* _data2_,
                 gdouble val);
static void ___lambda4__adw_animation_target_func (gdouble value,
                                            gpointer self);
static void __lambda5_ (Block2Data* _data2_);
static void ___lambda5__adw_animation_done (AdwAnimation* _sender,
                                     gpointer self);
static void ag_polkit_dialog_finalize (GObject * obj);
static GType ag_polkit_dialog_get_type_once (void);

static inline gpointer
ag_polkit_dialog_get_instance_private (AgPolkitDialog* self)
{
	return G_STRUCT_MEMBER_P (self, AgPolkitDialog_private_offset);
}

static void
_ag_polkit_dialog_cancel_g_cancellable_cancelled (GCancellable* _sender,
                                                  gpointer self)
{
	ag_polkit_dialog_cancel ((AgPolkitDialog*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_ag_polkit_dialog_on_ident_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                          gpointer self)
{
	ag_polkit_dialog_on_ident_changed ((AgPolkitDialog*) self);
}

static void
__lambda6_ (AgPolkitDialog* self)
{
	ag_polkit_dialog_cancel (self);
}

static void
___lambda6__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda6_ ((AgPolkitDialog*) self);
}

static void
_ag_polkit_dialog_authenticate_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	ag_polkit_dialog_authenticate ((AgPolkitDialog*) self);
}

static void
_ag_polkit_dialog_cancel_gtk_dialog_close (GtkDialog* _sender,
                                           gpointer self)
{
	ag_polkit_dialog_cancel ((AgPolkitDialog*) self);
}

static void
__lambda7_ (AgPolkitDialog* self)
{
	GdkSurface* surface = NULL;
	GdkSurface* _tmp0_;
	GdkSurface* _tmp1_;
	GdkSurface* _tmp2_;
	pantheon_wayland_extended_behavior_connect_to_shell ((PantheonWaylandExtendedBehavior*) self);
	pantheon_wayland_extended_behavior_set_keep_above ((PantheonWaylandExtendedBehavior*) self);
	pantheon_wayland_extended_behavior_make_centered ((PantheonWaylandExtendedBehavior*) self);
	pantheon_wayland_extended_behavior_make_modal ((PantheonWaylandExtendedBehavior*) self, TRUE);
	_tmp0_ = gtk_native_get_surface ((GtkNative*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	surface = _tmp1_;
	_tmp2_ = surface;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_toplevel_get_type ())) {
		GdkSurface* _tmp3_;
		_tmp3_ = surface;
		gdk_toplevel_inhibit_system_shortcuts (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_toplevel_get_type (), GdkToplevel), NULL);
	}
	_g_object_unref0 (surface);
}

static void
___lambda7__gtk_widget_realize (GtkWidget* _sender,
                                gpointer self)
{
	__lambda7_ ((AgPolkitDialog*) self);
}

AgPolkitDialog*
ag_polkit_dialog_construct (GType object_type,
                            const gchar* message,
                            const gchar* icon_name,
                            const gchar* _cookie,
                            GList* _idents,
                            GCancellable* _cancellable)
{
	AgPolkitDialog * self = NULL;
	gchar* _tmp0_;
	GCancellable* _tmp1_;
	GtkPasswordEntry* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkWidget* _tmp6_;
	GtkRevealer* _tmp7_ = NULL;
	GtkComboBox* _tmp8_ = NULL;
	GtkComboBox* _tmp9_;
	GtkCellRenderer* renderer = NULL;
	GtkCellRendererPixbuf* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkCellRenderer* _tmp12_;
	GtkComboBox* _tmp13_;
	GtkCellRenderer* _tmp14_;
	GtkCellRendererText* _tmp15_;
	GtkCellRenderer* _tmp16_;
	GtkComboBox* _tmp17_;
	GtkCellRenderer* _tmp18_;
	GtkComboBox* _tmp19_;
	GtkCellRenderer* _tmp20_;
	GtkComboBox* _tmp21_;
	GtkBox* credentials_box = NULL;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkComboBox* _tmp24_;
	GtkBox* _tmp25_;
	GtkPasswordEntry* _tmp26_;
	GtkBox* _tmp27_;
	GtkRevealer* _tmp28_;
	GThemedIcon* _tmp29_;
	GThemedIcon* _tmp30_;
	gboolean _tmp31_ = FALSE;
	GtkBox* _tmp36_;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	GtkButton* cancel_button = NULL;
	GtkWidget* _tmp39_;
	GtkButton* _tmp40_;
	GtkButton* authenticate_button = NULL;
	GtkWidget* _tmp41_;
	GtkButton* _tmp42_;
	GtkPasswordEntry* _tmp43_;
	GtkWidget* _tmp44_;
	GtkWidget* _tmp45_;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (_cookie != NULL, NULL);
	g_return_val_if_fail (_cancellable != NULL, NULL);
	self = (AgPolkitDialog*) g_object_new (object_type, "title", _ ("Authentication Dialog"), NULL);
	self->priv->idents = _idents;
	_tmp0_ = g_strdup (_cookie);
	_g_free0 (self->priv->cookie);
	self->priv->cookie = _tmp0_;
	self->priv->cancellable = _cancellable;
	_tmp1_ = self->priv->cancellable;
	g_signal_connect_object (_tmp1_, "cancelled", (GCallback) _ag_polkit_dialog_cancel_g_cancellable_cancelled, self, 0);
	granite_message_dialog_set_primary_text ((GraniteMessageDialog*) self, _ ("Authentication Required"));
	granite_message_dialog_set_secondary_text ((GraniteMessageDialog*) self, message);
	_tmp2_ = (GtkPasswordEntry*) gtk_password_entry_new ();
	g_object_set (_tmp2_, "activates-default", TRUE, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_password_entry_set_show_peek_icon (_tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_justify (_tmp3_, GTK_JUSTIFY_RIGHT);
	gtk_label_set_max_width_chars (_tmp3_, 40);
	gtk_label_set_wrap (_tmp3_, TRUE);
	gtk_label_set_xalign (_tmp3_, (gfloat) 1);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->password_feedback);
	self->priv->password_feedback = _tmp3_;
	_tmp4_ = self->priv->password_feedback;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_CSS_CLASS_ERROR);
	_tmp5_ = self->priv->password_feedback;
	_tmp6_ = _g_object_ref0 ((GtkWidget*) _tmp5_);
	_tmp7_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp7_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->feedback_revealer);
	self->priv->feedback_revealer = _tmp7_;
	_tmp8_ = (GtkComboBox*) gtk_combo_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->idents_combo);
	self->priv->idents_combo = _tmp8_;
	_tmp9_ = self->priv->idents_combo;
	g_signal_connect_object (_tmp9_, "changed", (GCallback) _ag_polkit_dialog_on_ident_changed_gtk_combo_box_changed, self, 0);
	_tmp10_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp10_);
	renderer = (GtkCellRenderer*) _tmp10_;
	_tmp11_ = self->priv->idents_combo;
	_tmp12_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp11_, _tmp12_, FALSE);
	_tmp13_ = self->priv->idents_combo;
	_tmp14_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp13_, _tmp14_, "icon-name", 0);
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp15_;
	_tmp16_ = renderer;
	g_object_set (_tmp16_, "xpad", (guint) 6, NULL);
	_tmp17_ = self->priv->idents_combo;
	_tmp18_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp17_, _tmp18_, TRUE);
	_tmp19_ = self->priv->idents_combo;
	_tmp20_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp19_, _tmp20_, "text", 1);
	_tmp21_ = self->priv->idents_combo;
	gtk_combo_box_set_id_column (_tmp21_, 1);
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp22_);
	credentials_box = _tmp22_;
	_tmp23_ = credentials_box;
	_tmp24_ = self->priv->idents_combo;
	gtk_box_append (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = credentials_box;
	_tmp26_ = self->priv->password_entry;
	gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = credentials_box;
	_tmp28_ = self->priv->feedback_revealer;
	gtk_box_append (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = (GThemedIcon*) g_themed_icon_new ("dialog-password");
	_tmp30_ = _tmp29_;
	granite_message_dialog_set_image_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp30_);
	_g_object_unref0 (_tmp30_);
	if (g_strcmp0 (icon_name, "") != 0) {
		GdkDisplay* _tmp32_;
		GtkIconTheme* _tmp33_;
		_tmp32_ = gdk_display_get_default ();
		_tmp33_ = gtk_icon_theme_get_for_display (_tmp32_);
		_tmp31_ = gtk_icon_theme_has_icon (_tmp33_, icon_name);
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		GThemedIcon* _tmp34_;
		GThemedIcon* _tmp35_;
		_tmp34_ = (GThemedIcon*) g_themed_icon_new (icon_name);
		_tmp35_ = _tmp34_;
		granite_message_dialog_set_badge_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp35_);
		_g_object_unref0 (_tmp35_);
	}
	_tmp36_ = granite_message_dialog_get_custom_bin ((GraniteMessageDialog*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = credentials_box;
	gtk_box_append (_tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = granite_dialog_add_button ((GraniteDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_button_get_type (), GtkButton));
	cancel_button = _tmp40_;
	g_signal_connect_object (cancel_button, "clicked", (GCallback) ___lambda6__gtk_button_clicked, self, 0);
	_tmp41_ = granite_dialog_add_button ((GraniteDialog*) self, _ ("Authenticate"), (gint) GTK_RESPONSE_APPLY);
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_button_get_type (), GtkButton));
	authenticate_button = _tmp42_;
	gtk_widget_set_receives_default ((GtkWidget*) authenticate_button, TRUE);
	gtk_widget_add_css_class ((GtkWidget*) authenticate_button, GRANITE_CSS_CLASS_SUGGESTED);
	g_signal_connect_object (authenticate_button, "clicked", (GCallback) _ag_polkit_dialog_authenticate_gtk_button_clicked, self, 0);
	gtk_window_set_default_widget ((GtkWindow*) self, (GtkWidget*) authenticate_button);
	_tmp43_ = self->priv->password_entry;
	g_object_set ((GtkWindow*) self, "focus-widget", (GtkWidget*) _tmp43_, NULL);
	g_signal_connect_object ((GtkDialog*) self, "close", (GCallback) _ag_polkit_dialog_cancel_gtk_dialog_close, self, 0);
	ag_polkit_dialog_update_idents (self);
	ag_polkit_dialog_select_session (self);
	_tmp44_ = gtk_window_get_child ((GtkWindow*) self);
	_tmp45_ = _tmp44_;
	g_signal_connect_object (_tmp45_, "realize", (GCallback) ___lambda7__gtk_widget_realize, self, 0);
	_g_object_unref0 (authenticate_button);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (credentials_box);
	_g_object_unref0 (renderer);
	return self;
}

AgPolkitDialog*
ag_polkit_dialog_new (const gchar* message,
                      const gchar* icon_name,
                      const gchar* _cookie,
                      GList* _idents,
                      GCancellable* _cancellable)
{
	return ag_polkit_dialog_construct (AG_TYPE_POLKIT_DIALOG, message, icon_name, _cookie, _idents, _cancellable);
}

static void
ag_polkit_dialog_update_idents (AgPolkitDialog* self)
{
	GtkListStore* model = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter iter = {0};
	gint length = 0;
	gint active = 0;
	gchar* target_user = NULL;
	GList* _tmp1_;
	GtkComboBox* _tmp34_;
	GtkListStore* _tmp35_;
	GtkComboBox* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, polkit_identity_get_type (), -1);
	model = _tmp0_;
	length = 0;
	active = 0;
	target_user = NULL;
	_tmp1_ = self->priv->idents;
	{
		GList* ident_collection = NULL;
		GList* ident_it = NULL;
		ident_collection = _tmp1_;
		for (ident_it = ident_collection; ident_it != NULL; ident_it = ident_it->next) {
			PolkitIdentity* ident = NULL;
			ident = (PolkitIdentity*) ident_it->data;
			{
				PolkitIdentity* _tmp2_;
				gchar* name = NULL;
				PolkitIdentity* _tmp3_;
				gchar* _tmp4_;
				PolkitIdentity* _tmp5_;
				GtkListStore* _tmp25_;
				GtkTreeIter _tmp26_ = {0};
				GtkListStore* _tmp27_;
				GtkTreeIter _tmp28_;
				const gchar* _tmp29_;
				PolkitIdentity* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				gint _tmp33_;
				_tmp2_ = ident;
				if (_tmp2_ == NULL) {
					continue;
				}
				_tmp3_ = ident;
				_tmp4_ = polkit_identity_to_string (_tmp3_);
				name = _tmp4_;
				_tmp5_ = ident;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, polkit_unix_user_get_type ())) {
					struct passwd* pwd = NULL;
					PolkitIdentity* _tmp6_;
					struct passwd* _tmp7_;
					struct passwd* _tmp8_;
					_tmp6_ = ident;
					_tmp7_ = getpwuid ((uid_t) polkit_unix_user_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, polkit_unix_user_get_type (), PolkitUnixUser)));
					pwd = _tmp7_;
					_tmp8_ = pwd;
					if (_tmp8_ != NULL) {
						gchar* pw_name = NULL;
						struct passwd* _tmp9_;
						const gchar* _tmp10_;
						gchar* _tmp11_;
						gboolean _tmp12_ = FALSE;
						const gchar* _tmp13_;
						const gchar* _tmp16_;
						gchar* _tmp17_;
						_tmp9_ = pwd;
						_tmp10_ = _tmp9_->pw_name;
						_tmp11_ = g_strdup (_tmp10_);
						pw_name = _tmp11_;
						_tmp13_ = target_user;
						if (_tmp13_ == NULL) {
							_tmp12_ = length < 2;
						} else {
							_tmp12_ = FALSE;
						}
						if (_tmp12_) {
							const gchar* _tmp14_;
							gchar* _tmp15_;
							_tmp14_ = pw_name;
							_tmp15_ = g_strdup (_tmp14_);
							_g_free0 (target_user);
							target_user = _tmp15_;
						}
						_tmp16_ = pw_name;
						_tmp17_ = g_strdup (_tmp16_);
						_g_free0 (name);
						name = _tmp17_;
						_g_free0 (pw_name);
					}
				} else {
					PolkitIdentity* _tmp18_;
					_tmp18_ = ident;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, polkit_unix_group_get_type ())) {
						struct group* gwd = NULL;
						PolkitIdentity* _tmp19_;
						struct group* _tmp20_;
						struct group* _tmp21_;
						_tmp19_ = ident;
						_tmp20_ = getgrgid ((gid_t) polkit_unix_group_get_gid (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, polkit_unix_group_get_type (), PolkitUnixGroup)));
						gwd = _tmp20_;
						_tmp21_ = gwd;
						if (_tmp21_ != NULL) {
							struct group* _tmp22_;
							const gchar* _tmp23_;
							gchar* _tmp24_;
							_tmp22_ = gwd;
							_tmp23_ = _tmp22_->gr_name;
							_tmp24_ = g_strdup_printf (_ ("Group: %s"), _tmp23_);
							_g_free0 (name);
							name = _tmp24_;
						}
					}
				}
				_tmp25_ = model;
				gtk_list_store_append (_tmp25_, &_tmp26_);
				iter = _tmp26_;
				_tmp27_ = model;
				_tmp28_ = iter;
				_tmp29_ = name;
				_tmp30_ = ident;
				gtk_list_store_set (_tmp27_, &_tmp28_, 0, "avatar-default-symbolic", 1, _tmp29_, 2, _tmp30_, -1);
				_tmp31_ = name;
				_tmp32_ = g_get_user_name ();
				if (g_strcmp0 (_tmp31_, _tmp32_) == 0) {
					active = length;
				}
				_tmp33_ = length;
				length = _tmp33_ + 1;
				_g_free0 (name);
			}
		}
	}
	_tmp34_ = self->priv->idents_combo;
	_tmp35_ = model;
	gtk_combo_box_set_model (_tmp34_, (GtkTreeModel*) _tmp35_);
	_tmp36_ = self->priv->idents_combo;
	gtk_combo_box_set_active (_tmp36_, active);
	if (length < 2) {
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp37_ = target_user;
		_tmp38_ = g_get_user_name ();
		if (g_strcmp0 (_tmp37_, _tmp38_) == 0) {
			GtkComboBox* _tmp39_;
			_tmp39_ = self->priv->idents_combo;
			gtk_widget_set_visible ((GtkWidget*) _tmp39_, FALSE);
		} else {
			GtkComboBox* _tmp40_;
			_tmp40_ = self->priv->idents_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, FALSE);
		}
	}
	_g_free0 (target_user);
	_g_object_unref0 (model);
}

static void
_ag_polkit_dialog_on_pk_show_error_polkit_agent_session_show_error (PolkitAgentSession* _sender,
                                                                    const gchar* text,
                                                                    gpointer self)
{
	ag_polkit_dialog_on_pk_show_error ((AgPolkitDialog*) self, text);
}

static void
_ag_polkit_dialog_on_pk_session_completed_polkit_agent_session_completed (PolkitAgentSession* _sender,
                                                                          gboolean gained_authorization,
                                                                          gpointer self)
{
	ag_polkit_dialog_on_pk_session_completed ((AgPolkitDialog*) self, gained_authorization);
}

static void
_ag_polkit_dialog_on_pk_request_polkit_agent_session_request (PolkitAgentSession* _sender,
                                                              const gchar* request,
                                                              gboolean echo_on,
                                                              gpointer self)
{
	ag_polkit_dialog_on_pk_request ((AgPolkitDialog*) self, request, echo_on);
}

static void
_ag_polkit_dialog_on_pk_show_info_polkit_agent_session_show_info (PolkitAgentSession* _sender,
                                                                  const gchar* text,
                                                                  gpointer self)
{
	ag_polkit_dialog_on_pk_show_info ((AgPolkitDialog*) self, text);
}

static void
ag_polkit_dialog_select_session (AgPolkitDialog* self)
{
	PolkitAgentSession* _tmp0_;
	PolkitIdentity* _tmp1_;
	const gchar* _tmp2_;
	PolkitAgentSession* _tmp3_;
	PolkitAgentSession* _tmp4_;
	gulong _tmp5_;
	PolkitAgentSession* _tmp6_;
	gulong _tmp7_;
	PolkitAgentSession* _tmp8_;
	gulong _tmp9_;
	PolkitAgentSession* _tmp10_;
	gulong _tmp11_;
	PolkitAgentSession* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pk_session;
	if (_tmp0_ != NULL) {
		ag_polkit_dialog_deselect_session (self);
	}
	_tmp1_ = self->priv->pk_identity;
	_tmp2_ = self->priv->cookie;
	_tmp3_ = polkit_agent_session_new (_tmp1_, _tmp2_);
	_g_object_unref0 (self->priv->pk_session);
	self->priv->pk_session = _tmp3_;
	_tmp4_ = self->priv->pk_session;
	_tmp5_ = g_signal_connect_object (_tmp4_, "show-error", (GCallback) _ag_polkit_dialog_on_pk_show_error_polkit_agent_session_show_error, self, 0);
	self->priv->error_signal_id = _tmp5_;
	_tmp6_ = self->priv->pk_session;
	_tmp7_ = g_signal_connect_object (_tmp6_, "completed", (GCallback) _ag_polkit_dialog_on_pk_session_completed_polkit_agent_session_completed, self, 0);
	self->priv->complete_signal_id = _tmp7_;
	_tmp8_ = self->priv->pk_session;
	_tmp9_ = g_signal_connect_object (_tmp8_, "request", (GCallback) _ag_polkit_dialog_on_pk_request_polkit_agent_session_request, self, 0);
	self->priv->request_signal_id = _tmp9_;
	_tmp10_ = self->priv->pk_session;
	_tmp11_ = g_signal_connect_object (_tmp10_, "show-info", (GCallback) _ag_polkit_dialog_on_pk_show_info_polkit_agent_session_show_info, self, 0);
	self->priv->info_signal_id = _tmp11_;
	_tmp12_ = self->priv->pk_session;
	polkit_agent_session_initiate (_tmp12_);
}

static void
ag_polkit_dialog_deselect_session (AgPolkitDialog* self)
{
	PolkitAgentSession* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pk_session;
	if (_tmp0_ != NULL) {
		PolkitAgentSession* _tmp1_;
		PolkitAgentSession* _tmp2_;
		PolkitAgentSession* _tmp3_;
		PolkitAgentSession* _tmp4_;
		_tmp1_ = self->priv->pk_session;
		g_signal_handler_disconnect (_tmp1_, self->priv->error_signal_id);
		_tmp2_ = self->priv->pk_session;
		g_signal_handler_disconnect (_tmp2_, self->priv->complete_signal_id);
		_tmp3_ = self->priv->pk_session;
		g_signal_handler_disconnect (_tmp3_, self->priv->request_signal_id);
		_tmp4_ = self->priv->pk_session;
		g_signal_handler_disconnect (_tmp4_, self->priv->info_signal_id);
		_g_object_unref0 (self->priv->pk_session);
		self->priv->pk_session = NULL;
	}
}

static void
ag_polkit_dialog_authenticate (AgPolkitDialog* self)
{
	PolkitAgentSession* _tmp0_;
	GtkRevealer* _tmp1_;
	PolkitAgentSession* _tmp2_;
	GtkPasswordEntry* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pk_session;
	if (_tmp0_ == NULL) {
		ag_polkit_dialog_select_session (self);
	}
	_tmp1_ = self->priv->feedback_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
	_tmp2_ = self->priv->pk_session;
	_tmp3_ = self->priv->password_entry;
	_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
	polkit_agent_session_response (_tmp2_, _tmp4_);
}

static void
ag_polkit_dialog_cancel (AgPolkitDialog* self)
{
	PolkitAgentSession* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->canceling = TRUE;
	_tmp0_ = self->priv->pk_session;
	if (_tmp0_ != NULL) {
		PolkitAgentSession* _tmp1_;
		_tmp1_ = self->priv->pk_session;
		polkit_agent_session_cancel (_tmp1_);
	}
	g_debug ("PolkitDialog.vala:233: Authentication cancelled");
	self->was_canceled = TRUE;
	self->priv->canceling = FALSE;
	g_signal_emit (self, ag_polkit_dialog_signals[AG_POLKIT_DIALOG_DONE_SIGNAL], 0);
}

static void
ag_polkit_dialog_on_ident_changed (AgPolkitDialog* self)
{
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	PolkitIdentity* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->idents_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		ag_polkit_dialog_deselect_session (self);
		return;
	}
	_tmp3_ = self->priv->idents_combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	model = _tmp5_;
	_tmp6_ = model;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (model);
		return;
	}
	_tmp7_ = model;
	_tmp8_ = iter;
	gtk_tree_model_get (_tmp7_, &_tmp8_, 2, &_tmp9_, -1, -1);
	_g_object_unref0 (self->priv->pk_identity);
	self->priv->pk_identity = _tmp9_;
	ag_polkit_dialog_select_session (self);
	_g_object_unref0 (model);
}

static void
ag_polkit_dialog_on_pk_session_completed (AgPolkitDialog* self,
                                          gboolean authorized)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!authorized) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		_tmp0_ = g_cancellable_is_cancelled (_tmp1_);
	}
	if (_tmp0_) {
		GtkPasswordEntry* _tmp2_;
		GtkPasswordEntry* _tmp3_;
		if (!self->priv->canceling) {
			ag_polkit_dialog_on_pk_show_error (self, _ ("Authentication failed. Please try again."));
		}
		ag_polkit_dialog_deselect_session (self);
		_tmp2_ = self->priv->password_entry;
		gtk_editable_set_text ((GtkEditable*) _tmp2_, "");
		_tmp3_ = self->priv->password_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
		ag_polkit_dialog_select_session (self);
		return;
	} else {
		g_signal_emit (self, ag_polkit_dialog_signals[AG_POLKIT_DIALOG_DONE_SIGNAL], 0);
	}
	gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
}

static void
ag_polkit_dialog_on_pk_request (AgPolkitDialog* self,
                                const gchar* request,
                                gboolean echo_on)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (request != NULL);
	if (!g_str_has_prefix (request, "Password:")) {
		GtkLabel* _tmp0_;
		_tmp0_ = self->priv->password_label;
		gtk_label_set_label (_tmp0_, request);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		AgPolkitDialog* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->shake);
		_g_free0 (_data2_->text);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda4_ (Block2Data* _data2_,
            gdouble val)
{
	AgPolkitDialog* self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GskTransform* _tmp2_;
	graphene_point_t _tmp3_ = {0};
	GskTransform* _tmp4_;
	self = _data2_->self;
	_tmp0_ = gtk_window_get_child ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gsk_transform_new ();
	memset (&_tmp3_, 0, sizeof (graphene_point_t));
	_tmp3_.x = (gfloat) ((gint) val);
	_tmp4_ = gsk_transform_translate (_tmp2_, &_tmp3_);
	gtk_widget_allocate (_tmp1_, _data2_->width, _data2_->height, -1, _tmp4_);
}

static void
___lambda4__adw_animation_target_func (gdouble value,
                                       gpointer self)
{
	__lambda4_ (self, value);
}

static void
__lambda5_ (Block2Data* _data2_)
{
	AgPolkitDialog* self;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	self = _data2_->self;
	if (_data2_->repeat_count == 4) {
		GtkRevealer* _tmp0_;
		GtkLabel* _tmp1_;
		_tmp0_ = self->priv->feedback_revealer;
		gtk_revealer_set_reveal_child (_tmp0_, TRUE);
		_tmp1_ = self->priv->password_feedback;
		gtk_label_set_label (_tmp1_, _data2_->text);
		gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
		g_signal_handler_disconnect ((GObject*) self, _data2_->iterate);
		return;
	}
	_tmp2_ = adw_timed_animation_get_value_to (_data2_->shake);
	_tmp3_ = _tmp2_;
	adw_timed_animation_set_value_to (_data2_->shake, -1 * _tmp3_);
	adw_animation_play ((AdwAnimation*) _data2_->shake);
	_tmp4_ = _data2_->repeat_count;
	_data2_->repeat_count = _tmp4_ + 1;
}

static void
___lambda5__adw_animation_done (AdwAnimation* _sender,
                                gpointer self)
{
	__lambda5_ (self);
}

static void
ag_polkit_dialog_on_pk_show_error (AgPolkitDialog* self,
                                   const gchar* text)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	AdwCallbackAnimationTarget* _tmp3_;
	AdwTimedAnimation* _tmp4_ = NULL;
	gulong _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data2_->text);
	_data2_->text = _tmp0_;
	_data2_->width = gtk_widget_get_width ((GtkWidget*) self);
	_data2_->height = gtk_widget_get_height ((GtkWidget*) self);
	_tmp1_ = gtk_window_get_child ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (___lambda4__adw_animation_target_func, block2_data_ref (_data2_), block2_data_unref);
	_tmp4_ = (AdwTimedAnimation*) adw_timed_animation_new (_tmp2_, (gdouble) 0, (gdouble) -24, (guint) 70, (AdwAnimationTarget*) _tmp3_);
	adw_timed_animation_set_easing (_tmp4_, ADW_EASE_OUT_CIRC);
	adw_timed_animation_set_reverse (_tmp4_, TRUE);
	_data2_->shake = _tmp4_;
	adw_animation_play ((AdwAnimation*) _data2_->shake);
	_data2_->repeat_count = 0;
	_data2_->iterate = (gulong) 0;
	_tmp5_ = g_signal_connect_data ((AdwAnimation*) _data2_->shake, "done", (GCallback) ___lambda5__adw_animation_done, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->iterate = _tmp5_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
ag_polkit_dialog_on_pk_show_info (AgPolkitDialog* self,
                                  const gchar* text)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_info ("PolkitDialog.vala:316: %s", text);
}

static void
ag_polkit_dialog_class_init (AgPolkitDialogClass * klass,
                             gpointer klass_data)
{
	ag_polkit_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AgPolkitDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = ag_polkit_dialog_finalize;
	ag_polkit_dialog_signals[AG_POLKIT_DIALOG_DONE_SIGNAL] = g_signal_new ("done", AG_TYPE_POLKIT_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
ag_polkit_dialog_pantheon_wayland_extended_behavior_interface_init (PantheonWaylandExtendedBehaviorIface * iface,
                                                                    gpointer iface_data)
{
	ag_polkit_dialog_pantheon_wayland_extended_behavior_parent_iface = g_type_interface_peek_parent (iface);
}

static void
ag_polkit_dialog_instance_init (AgPolkitDialog * self,
                                gpointer klass)
{
	self->priv = ag_polkit_dialog_get_instance_private (self);
	self->was_canceled = FALSE;
	self->priv->pk_session = NULL;
	self->priv->pk_identity = NULL;
	self->priv->canceling = FALSE;
}

static void
ag_polkit_dialog_finalize (GObject * obj)
{
	AgPolkitDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AG_TYPE_POLKIT_DIALOG, AgPolkitDialog);
	_g_object_unref0 (self->priv->pk_session);
	_g_object_unref0 (self->priv->pk_identity);
	_g_free0 (self->priv->cookie);
	_g_object_unref0 (self->priv->feedback_revealer);
	_g_object_unref0 (self->priv->password_label);
	_g_object_unref0 (self->priv->password_feedback);
	_g_object_unref0 (self->priv->password_entry);
	_g_object_unref0 (self->priv->idents_combo);
	G_OBJECT_CLASS (ag_polkit_dialog_parent_class)->finalize (obj);
}

static GType
ag_polkit_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AgPolkitDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ag_polkit_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AgPolkitDialog), 0, (GInstanceInitFunc) ag_polkit_dialog_instance_init, NULL };
	static const GInterfaceInfo pantheon_wayland_extended_behavior_info = { (GInterfaceInitFunc) ag_polkit_dialog_pantheon_wayland_extended_behavior_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType ag_polkit_dialog_type_id;
	ag_polkit_dialog_type_id = g_type_register_static (GRANITE_TYPE_MESSAGE_DIALOG, "AgPolkitDialog", &g_define_type_info, 0);
	g_type_add_interface_static (ag_polkit_dialog_type_id, PANTHEON_WAYLAND_TYPE_EXTENDED_BEHAVIOR, &pantheon_wayland_extended_behavior_info);
	AgPolkitDialog_private_offset = g_type_add_instance_private (ag_polkit_dialog_type_id, sizeof (AgPolkitDialogPrivate));
	return ag_polkit_dialog_type_id;
}

GType
ag_polkit_dialog_get_type (void)
{
	static volatile gsize ag_polkit_dialog_type_id__once = 0;
	if (g_once_init_enter (&ag_polkit_dialog_type_id__once)) {
		GType ag_polkit_dialog_type_id;
		ag_polkit_dialog_type_id = ag_polkit_dialog_get_type_once ();
		g_once_init_leave (&ag_polkit_dialog_type_id__once, ag_polkit_dialog_type_id);
	}
	return ag_polkit_dialog_type_id__once;
}

