#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


    #include <stdlib.h>
    #include <time.h>
    #include <notmuch.h>

    #if LIBNOTMUCH_MAJOR_VERSION < 5
        #error libnotmuch version not supported by notmuch2 python bindings
    #endif
    #if LIBNOTMUCH_MINOR_VERSION < 1
        #ERROR libnotmuch  version < 5.1 not supported
    #endif
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_config_pairs_t *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 252), // notmuch_config_pairs_t *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_database_t *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 253), // notmuch_database_t *
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_filenames_t *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 255), // notmuch_filenames_t *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_message_properties_t *)
/* 10 */ _CFFI_OP(_CFFI_OP_POINTER, 257), // notmuch_message_properties_t *
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_message_t *)
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 258), // notmuch_message_t *
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_message_t *, char const *)
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 17 */ _CFFI_OP(_CFFI_OP_POINTER, 251), // char const *
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_query_t const *)
/* 20 */ _CFFI_OP(_CFFI_OP_POINTER, 260), // notmuch_query_t const *
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_status_t)
/* 23 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // notmuch_status_t
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_tags_t *)
/* 26 */ _CFFI_OP(_CFFI_OP_POINTER, 261), // notmuch_tags_t *
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // char const *()(notmuch_thread_t *)
/* 29 */ _CFFI_OP(_CFFI_OP_POINTER, 262), // notmuch_thread_t *
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // int()(notmuch_config_pairs_t *)
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // int()(notmuch_database_t *)
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // int()(notmuch_filenames_t *)
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // int()(notmuch_message_properties_t *)
/* 41 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // int()(notmuch_message_t *, notmuch_message_flag_t)
/* 44 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 45 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // notmuch_message_flag_t
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // int()(notmuch_messages_t *)
/* 48 */ _CFFI_OP(_CFFI_OP_POINTER, 259), // notmuch_messages_t *
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // int()(notmuch_tags_t *)
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // int()(notmuch_thread_t *)
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // int()(notmuch_threads_t *)
/* 57 */ _CFFI_OP(_CFFI_OP_POINTER, 263), // notmuch_threads_t *
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // notmuch_config_pairs_t *()(notmuch_database_t *, char const *)
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // notmuch_database_t *()(notmuch_query_t const *)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION, 141), // notmuch_decryption_policy_t()(notmuch_indexopts_t const *)
/* 67 */ _CFFI_OP(_CFFI_OP_POINTER, 256), // notmuch_indexopts_t const *
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // notmuch_filenames_t *()(notmuch_message_t *)
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 131), // notmuch_indexopts_t *()(notmuch_database_t *)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // notmuch_message_properties_t *()(notmuch_message_t *, char const *, int)
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 77 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 78 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // notmuch_message_t *()(notmuch_messages_t *)
/* 81 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION, 48), // notmuch_messages_t *()(notmuch_message_t *)
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION, 48), // notmuch_messages_t *()(notmuch_thread_t *)
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION, 161), // notmuch_query_t *()(notmuch_database_t *, char const *)
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION, 236), // notmuch_sort_t()(notmuch_query_t const *)
/* 94 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(char const *, char const *, char const *, notmuch_database_t * *, char * *)
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 100 */ _CFFI_OP(_CFFI_OP_POINTER, 4), // notmuch_database_t * *
/* 101 */ _CFFI_OP(_CFFI_OP_POINTER, 250), // char * *
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(char const *, notmuch_database_mode_t, char const *, char const *, notmuch_database_t * *, char * *)
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 105 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // notmuch_database_mode_t
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 100),
/* 109 */ _CFFI_OP(_CFFI_OP_NOOP, 101),
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_database_t *)
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_database_t *, char const *)
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_database_t *, char const *, char * *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 121 */ _CFFI_OP(_CFFI_OP_NOOP, 101),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_database_t *, char const *, char const *)
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 126 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_database_t *, char const *, notmuch_indexopts_t *, notmuch_message_t * *)
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 130 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 131 */ _CFFI_OP(_CFFI_OP_POINTER, 256), // notmuch_indexopts_t *
/* 132 */ _CFFI_OP(_CFFI_OP_POINTER, 13), // notmuch_message_t * *
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_database_t *, char const *, notmuch_message_t * *)
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 137 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_indexopts_t *, notmuch_decryption_policy_t)
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 131),
/* 141 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // notmuch_decryption_policy_t
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_message_t *)
/* 144 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 146 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_message_t *, char const *)
/* 147 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 148 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_message_t *, char const *, char const * *)
/* 151 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 153 */ _CFFI_OP(_CFFI_OP_POINTER, 17), // char const * *
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_message_t *, char const *, char const *)
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 158 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_query_t *, char const *)
/* 161 */ _CFFI_OP(_CFFI_OP_POINTER, 260), // notmuch_query_t *
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_query_t *, notmuch_messages_t * *)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 166 */ _CFFI_OP(_CFFI_OP_POINTER, 48), // notmuch_messages_t * *
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_query_t *, notmuch_threads_t * *)
/* 169 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 170 */ _CFFI_OP(_CFFI_OP_POINTER, 57), // notmuch_threads_t * *
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // notmuch_status_t()(notmuch_query_t *, unsigned int *)
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 174 */ _CFFI_OP(_CFFI_OP_POINTER, 265), // unsigned int *
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // notmuch_tags_t *()(notmuch_database_t *)
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // notmuch_tags_t *()(notmuch_message_t *)
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // notmuch_tags_t *()(notmuch_messages_t *)
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION, 26), // notmuch_tags_t *()(notmuch_thread_t *)
/* 186 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // notmuch_thread_t *()(notmuch_threads_t *)
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 190 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION, 264), // time_t()(notmuch_message_t *)
/* 192 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 264), // time_t()(notmuch_thread_t *)
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // unsigned int()(notmuch_database_t *)
/* 198 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION, 266), // unsigned long()(notmuch_database_t *, char const * *)
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_config_pairs_t *)
/* 205 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_filenames_t *)
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_indexopts_t *)
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 131),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 213 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_message_properties_t *)
/* 214 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_message_t *)
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_message_t *, notmuch_message_flag_t, int)
/* 220 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 221 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 222 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 223 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 224 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_messages_t *)
/* 225 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 227 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_query_t *)
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 229 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_query_t *, notmuch_exclude_t)
/* 231 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 232 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // notmuch_exclude_t
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_query_t *, notmuch_sort_t)
/* 235 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 236 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // notmuch_sort_t
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_tags_t *)
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_thread_t *)
/* 242 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(notmuch_threads_t *)
/* 245 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 246 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION, 267), // void()(void *)
/* 248 */ _CFFI_OP(_CFFI_OP_POINTER, 267), // void *
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 250 */ _CFFI_OP(_CFFI_OP_POINTER, 251), // char *
/* 251 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 252 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // notmuch_config_pairs_t
/* 253 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // notmuch_database_t
/* 254 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // notmuch_directory_t
/* 255 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // notmuch_filenames_t
/* 256 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // notmuch_indexopts_t
/* 257 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // notmuch_message_properties_t
/* 258 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // notmuch_message_t
/* 259 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // notmuch_messages_t
/* 260 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // notmuch_query_t
/* 261 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // notmuch_tags_t
/* 262 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // notmuch_thread_t
/* 263 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // notmuch_threads_t
/* 264 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(time_t), (
           ((time_t)-1) | 0 /* check that time_t is an integer type */
         ) <= 0)), // time_t
/* 265 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 266 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10), // unsigned long
/* 267 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_NOTMUCH_DATABASE_MODE_READ_ONLY(unsigned long long *o)
{
  int n = (NOTMUCH_DATABASE_MODE_READ_ONLY) <= 0;
  *o = (unsigned long long)((NOTMUCH_DATABASE_MODE_READ_ONLY) | 0);  /* check that NOTMUCH_DATABASE_MODE_READ_ONLY is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_DATABASE_MODE_READ_WRITE(unsigned long long *o)
{
  int n = (NOTMUCH_DATABASE_MODE_READ_WRITE) <= 0;
  *o = (unsigned long long)((NOTMUCH_DATABASE_MODE_READ_WRITE) | 0);  /* check that NOTMUCH_DATABASE_MODE_READ_WRITE is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_DECRYPT_FALSE(unsigned long long *o)
{
  int n = (NOTMUCH_DECRYPT_FALSE) <= 0;
  *o = (unsigned long long)((NOTMUCH_DECRYPT_FALSE) | 0);  /* check that NOTMUCH_DECRYPT_FALSE is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_DECRYPT_TRUE(unsigned long long *o)
{
  int n = (NOTMUCH_DECRYPT_TRUE) <= 0;
  *o = (unsigned long long)((NOTMUCH_DECRYPT_TRUE) | 0);  /* check that NOTMUCH_DECRYPT_TRUE is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_DECRYPT_AUTO(unsigned long long *o)
{
  int n = (NOTMUCH_DECRYPT_AUTO) <= 0;
  *o = (unsigned long long)((NOTMUCH_DECRYPT_AUTO) | 0);  /* check that NOTMUCH_DECRYPT_AUTO is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_DECRYPT_NOSTASH(unsigned long long *o)
{
  int n = (NOTMUCH_DECRYPT_NOSTASH) <= 0;
  *o = (unsigned long long)((NOTMUCH_DECRYPT_NOSTASH) | 0);  /* check that NOTMUCH_DECRYPT_NOSTASH is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_EXCLUDE_FLAG(unsigned long long *o)
{
  int n = (NOTMUCH_EXCLUDE_FLAG) <= 0;
  *o = (unsigned long long)((NOTMUCH_EXCLUDE_FLAG) | 0);  /* check that NOTMUCH_EXCLUDE_FLAG is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_EXCLUDE_TRUE(unsigned long long *o)
{
  int n = (NOTMUCH_EXCLUDE_TRUE) <= 0;
  *o = (unsigned long long)((NOTMUCH_EXCLUDE_TRUE) | 0);  /* check that NOTMUCH_EXCLUDE_TRUE is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_EXCLUDE_FALSE(unsigned long long *o)
{
  int n = (NOTMUCH_EXCLUDE_FALSE) <= 0;
  *o = (unsigned long long)((NOTMUCH_EXCLUDE_FALSE) | 0);  /* check that NOTMUCH_EXCLUDE_FALSE is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_EXCLUDE_ALL(unsigned long long *o)
{
  int n = (NOTMUCH_EXCLUDE_ALL) <= 0;
  *o = (unsigned long long)((NOTMUCH_EXCLUDE_ALL) | 0);  /* check that NOTMUCH_EXCLUDE_ALL is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_SORT_OLDEST_FIRST(unsigned long long *o)
{
  int n = (NOTMUCH_SORT_OLDEST_FIRST) <= 0;
  *o = (unsigned long long)((NOTMUCH_SORT_OLDEST_FIRST) | 0);  /* check that NOTMUCH_SORT_OLDEST_FIRST is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_SORT_NEWEST_FIRST(unsigned long long *o)
{
  int n = (NOTMUCH_SORT_NEWEST_FIRST) <= 0;
  *o = (unsigned long long)((NOTMUCH_SORT_NEWEST_FIRST) | 0);  /* check that NOTMUCH_SORT_NEWEST_FIRST is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_SORT_MESSAGE_ID(unsigned long long *o)
{
  int n = (NOTMUCH_SORT_MESSAGE_ID) <= 0;
  *o = (unsigned long long)((NOTMUCH_SORT_MESSAGE_ID) | 0);  /* check that NOTMUCH_SORT_MESSAGE_ID is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_SORT_UNSORTED(unsigned long long *o)
{
  int n = (NOTMUCH_SORT_UNSORTED) <= 0;
  *o = (unsigned long long)((NOTMUCH_SORT_UNSORTED) | 0);  /* check that NOTMUCH_SORT_UNSORTED is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_MESSAGE_FLAG_MATCH(unsigned long long *o)
{
  int n = (NOTMUCH_MESSAGE_FLAG_MATCH) <= 0;
  *o = (unsigned long long)((NOTMUCH_MESSAGE_FLAG_MATCH) | 0);  /* check that NOTMUCH_MESSAGE_FLAG_MATCH is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_MESSAGE_FLAG_EXCLUDED(unsigned long long *o)
{
  int n = (NOTMUCH_MESSAGE_FLAG_EXCLUDED) <= 0;
  *o = (unsigned long long)((NOTMUCH_MESSAGE_FLAG_EXCLUDED) | 0);  /* check that NOTMUCH_MESSAGE_FLAG_EXCLUDED is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_MESSAGE_FLAG_GHOST(unsigned long long *o)
{
  int n = (NOTMUCH_MESSAGE_FLAG_GHOST) <= 0;
  *o = (unsigned long long)((NOTMUCH_MESSAGE_FLAG_GHOST) | 0);  /* check that NOTMUCH_MESSAGE_FLAG_GHOST is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_SUCCESS(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_SUCCESS) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_SUCCESS) | 0);  /* check that NOTMUCH_STATUS_SUCCESS is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_OUT_OF_MEMORY(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_OUT_OF_MEMORY) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_OUT_OF_MEMORY) | 0);  /* check that NOTMUCH_STATUS_OUT_OF_MEMORY is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_READ_ONLY_DATABASE(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_READ_ONLY_DATABASE) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_READ_ONLY_DATABASE) | 0);  /* check that NOTMUCH_STATUS_READ_ONLY_DATABASE is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_XAPIAN_EXCEPTION(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_XAPIAN_EXCEPTION) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_XAPIAN_EXCEPTION) | 0);  /* check that NOTMUCH_STATUS_XAPIAN_EXCEPTION is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_FILE_ERROR(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_FILE_ERROR) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_FILE_ERROR) | 0);  /* check that NOTMUCH_STATUS_FILE_ERROR is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_FILE_NOT_EMAIL(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_FILE_NOT_EMAIL) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_FILE_NOT_EMAIL) | 0);  /* check that NOTMUCH_STATUS_FILE_NOT_EMAIL is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_DUPLICATE_MESSAGE_ID(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_DUPLICATE_MESSAGE_ID) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_DUPLICATE_MESSAGE_ID) | 0);  /* check that NOTMUCH_STATUS_DUPLICATE_MESSAGE_ID is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_NULL_POINTER(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_NULL_POINTER) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_NULL_POINTER) | 0);  /* check that NOTMUCH_STATUS_NULL_POINTER is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_TAG_TOO_LONG(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_TAG_TOO_LONG) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_TAG_TOO_LONG) | 0);  /* check that NOTMUCH_STATUS_TAG_TOO_LONG is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_UNBALANCED_FREEZE_THAW(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_UNBALANCED_FREEZE_THAW) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_UNBALANCED_FREEZE_THAW) | 0);  /* check that NOTMUCH_STATUS_UNBALANCED_FREEZE_THAW is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_UNBALANCED_ATOMIC(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_UNBALANCED_ATOMIC) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_UNBALANCED_ATOMIC) | 0);  /* check that NOTMUCH_STATUS_UNBALANCED_ATOMIC is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_UNSUPPORTED_OPERATION(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_UNSUPPORTED_OPERATION) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_UNSUPPORTED_OPERATION) | 0);  /* check that NOTMUCH_STATUS_UNSUPPORTED_OPERATION is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_UPGRADE_REQUIRED(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_UPGRADE_REQUIRED) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_UPGRADE_REQUIRED) | 0);  /* check that NOTMUCH_STATUS_UPGRADE_REQUIRED is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_PATH_ERROR(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_PATH_ERROR) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_PATH_ERROR) | 0);  /* check that NOTMUCH_STATUS_PATH_ERROR is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_ILLEGAL_ARGUMENT(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_ILLEGAL_ARGUMENT) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_ILLEGAL_ARGUMENT) | 0);  /* check that NOTMUCH_STATUS_ILLEGAL_ARGUMENT is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_MALFORMED_CRYPTO_PROTOCOL(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_MALFORMED_CRYPTO_PROTOCOL) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_MALFORMED_CRYPTO_PROTOCOL) | 0);  /* check that NOTMUCH_STATUS_MALFORMED_CRYPTO_PROTOCOL is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_FAILED_CRYPTO_CONTEXT_CREATION(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_FAILED_CRYPTO_CONTEXT_CREATION) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_FAILED_CRYPTO_CONTEXT_CREATION) | 0);  /* check that NOTMUCH_STATUS_FAILED_CRYPTO_CONTEXT_CREATION is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_UNKNOWN_CRYPTO_PROTOCOL(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_UNKNOWN_CRYPTO_PROTOCOL) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_UNKNOWN_CRYPTO_PROTOCOL) | 0);  /* check that NOTMUCH_STATUS_UNKNOWN_CRYPTO_PROTOCOL is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_NO_CONFIG(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_NO_CONFIG) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_NO_CONFIG) | 0);  /* check that NOTMUCH_STATUS_NO_CONFIG is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_NO_DATABASE(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_NO_DATABASE) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_NO_DATABASE) | 0);  /* check that NOTMUCH_STATUS_NO_DATABASE is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_DATABASE_EXISTS(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_DATABASE_EXISTS) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_DATABASE_EXISTS) | 0);  /* check that NOTMUCH_STATUS_DATABASE_EXISTS is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_BAD_QUERY_SYNTAX(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_BAD_QUERY_SYNTAX) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_BAD_QUERY_SYNTAX) | 0);  /* check that NOTMUCH_STATUS_BAD_QUERY_SYNTAX is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_NO_MAIL_ROOT(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_NO_MAIL_ROOT) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_NO_MAIL_ROOT) | 0);  /* check that NOTMUCH_STATUS_NO_MAIL_ROOT is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_CLOSED_DATABASE(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_CLOSED_DATABASE) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_CLOSED_DATABASE) | 0);  /* check that NOTMUCH_STATUS_CLOSED_DATABASE is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_STATUS_LAST_STATUS(unsigned long long *o)
{
  int n = (NOTMUCH_STATUS_LAST_STATUS) <= 0;
  *o = (unsigned long long)((NOTMUCH_STATUS_LAST_STATUS) | 0);  /* check that NOTMUCH_STATUS_LAST_STATUS is an integer */
  return n;
}

static void _cffi_d_free(void * x0)
{
  free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(248), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(248), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_free _cffi_d_free
#endif

static notmuch_config_pairs_t * _cffi_d_notmuch_config_get_pairs(notmuch_database_t * x0, char const * x1)
{
  return notmuch_config_get_pairs(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_config_get_pairs(PyObject *self, PyObject *args)
{
  notmuch_database_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_config_pairs_t * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_config_get_pairs", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_config_get_pairs(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_config_get_pairs _cffi_d_notmuch_config_get_pairs
#endif

static void _cffi_d_notmuch_config_pairs_destroy(notmuch_config_pairs_t * x0)
{
  notmuch_config_pairs_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_config_pairs_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_config_pairs_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_config_pairs_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_config_pairs_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_config_pairs_destroy _cffi_d_notmuch_config_pairs_destroy
#endif

static char const * _cffi_d_notmuch_config_pairs_key(notmuch_config_pairs_t * x0)
{
  return notmuch_config_pairs_key(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_config_pairs_key(PyObject *self, PyObject *arg0)
{
  notmuch_config_pairs_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_config_pairs_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_config_pairs_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_config_pairs_key _cffi_d_notmuch_config_pairs_key
#endif

static void _cffi_d_notmuch_config_pairs_move_to_next(notmuch_config_pairs_t * x0)
{
  notmuch_config_pairs_move_to_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_config_pairs_move_to_next(PyObject *self, PyObject *arg0)
{
  notmuch_config_pairs_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_config_pairs_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_config_pairs_move_to_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_config_pairs_move_to_next _cffi_d_notmuch_config_pairs_move_to_next
#endif

static int _cffi_d_notmuch_config_pairs_valid(notmuch_config_pairs_t * x0)
{
  return notmuch_config_pairs_valid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_config_pairs_valid(PyObject *self, PyObject *arg0)
{
  notmuch_config_pairs_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_config_pairs_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_config_pairs_valid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_config_pairs_valid _cffi_d_notmuch_config_pairs_valid
#endif

static char const * _cffi_d_notmuch_config_pairs_value(notmuch_config_pairs_t * x0)
{
  return notmuch_config_pairs_value(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_config_pairs_value(PyObject *self, PyObject *arg0)
{
  notmuch_config_pairs_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_config_pairs_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_config_pairs_value(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_config_pairs_value _cffi_d_notmuch_config_pairs_value
#endif

static notmuch_status_t _cffi_d_notmuch_database_begin_atomic(notmuch_database_t * x0)
{
  return notmuch_database_begin_atomic(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_begin_atomic(PyObject *self, PyObject *arg0)
{
  notmuch_database_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_begin_atomic(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_begin_atomic _cffi_d_notmuch_database_begin_atomic
#endif

static notmuch_status_t _cffi_d_notmuch_database_close(notmuch_database_t * x0)
{
  return notmuch_database_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_close(PyObject *self, PyObject *arg0)
{
  notmuch_database_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_close _cffi_d_notmuch_database_close
#endif

static notmuch_status_t _cffi_d_notmuch_database_create_with_config(char const * x0, char const * x1, char const * x2, notmuch_database_t * * x3, char * * x4)
{
  return notmuch_database_create_with_config(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_create_with_config(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  char const * x2;
  notmuch_database_t * * x3;
  char * * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "notmuch_database_create_with_config", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(100), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (notmuch_database_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(100), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(101), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(101), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_create_with_config(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_create_with_config _cffi_d_notmuch_database_create_with_config
#endif

static notmuch_status_t _cffi_d_notmuch_database_destroy(notmuch_database_t * x0)
{
  return notmuch_database_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_database_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_destroy _cffi_d_notmuch_database_destroy
#endif

static notmuch_status_t _cffi_d_notmuch_database_end_atomic(notmuch_database_t * x0)
{
  return notmuch_database_end_atomic(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_end_atomic(PyObject *self, PyObject *arg0)
{
  notmuch_database_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_end_atomic(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_end_atomic _cffi_d_notmuch_database_end_atomic
#endif

static notmuch_status_t _cffi_d_notmuch_database_find_message(notmuch_database_t * x0, char const * x1, notmuch_message_t * * x2)
{
  return notmuch_database_find_message(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_find_message(PyObject *self, PyObject *args)
{
  notmuch_database_t * x0;
  char const * x1;
  notmuch_message_t * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notmuch_database_find_message", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (notmuch_message_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_find_message(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_find_message _cffi_d_notmuch_database_find_message
#endif

static notmuch_status_t _cffi_d_notmuch_database_find_message_by_filename(notmuch_database_t * x0, char const * x1, notmuch_message_t * * x2)
{
  return notmuch_database_find_message_by_filename(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_find_message_by_filename(PyObject *self, PyObject *args)
{
  notmuch_database_t * x0;
  char const * x1;
  notmuch_message_t * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notmuch_database_find_message_by_filename", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (notmuch_message_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_find_message_by_filename(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_find_message_by_filename _cffi_d_notmuch_database_find_message_by_filename
#endif

static notmuch_tags_t * _cffi_d_notmuch_database_get_all_tags(notmuch_database_t * x0)
{
  return notmuch_database_get_all_tags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_get_all_tags(PyObject *self, PyObject *arg0)
{
  notmuch_database_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_tags_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_get_all_tags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(26));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_get_all_tags _cffi_d_notmuch_database_get_all_tags
#endif

static notmuch_status_t _cffi_d_notmuch_database_get_config(notmuch_database_t * x0, char const * x1, char * * x2)
{
  return notmuch_database_get_config(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_get_config(PyObject *self, PyObject *args)
{
  notmuch_database_t * x0;
  char const * x1;
  char * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notmuch_database_get_config", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(101), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(101), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_get_config(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_get_config _cffi_d_notmuch_database_get_config
#endif

static notmuch_indexopts_t * _cffi_d_notmuch_database_get_default_indexopts(notmuch_database_t * x0)
{
  return notmuch_database_get_default_indexopts(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_get_default_indexopts(PyObject *self, PyObject *arg0)
{
  notmuch_database_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_indexopts_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_get_default_indexopts(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(131));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_get_default_indexopts _cffi_d_notmuch_database_get_default_indexopts
#endif

static char const * _cffi_d_notmuch_database_get_path(notmuch_database_t * x0)
{
  return notmuch_database_get_path(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_get_path(PyObject *self, PyObject *arg0)
{
  notmuch_database_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_get_path(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_get_path _cffi_d_notmuch_database_get_path
#endif

static unsigned long _cffi_d_notmuch_database_get_revision(notmuch_database_t * x0, char const * * x1)
{
  return notmuch_database_get_revision(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_get_revision(PyObject *self, PyObject *args)
{
  notmuch_database_t * x0;
  char const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_database_get_revision", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_get_revision(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_get_revision _cffi_d_notmuch_database_get_revision
#endif

static unsigned int _cffi_d_notmuch_database_get_version(notmuch_database_t * x0)
{
  return notmuch_database_get_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_get_version(PyObject *self, PyObject *arg0)
{
  notmuch_database_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_get_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_get_version _cffi_d_notmuch_database_get_version
#endif

static notmuch_status_t _cffi_d_notmuch_database_index_file(notmuch_database_t * x0, char const * x1, notmuch_indexopts_t * x2, notmuch_message_t * * x3)
{
  return notmuch_database_index_file(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_index_file(PyObject *self, PyObject *args)
{
  notmuch_database_t * x0;
  char const * x1;
  notmuch_indexopts_t * x2;
  notmuch_message_t * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "notmuch_database_index_file", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (notmuch_indexopts_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (notmuch_message_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_index_file(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_index_file _cffi_d_notmuch_database_index_file
#endif

static int _cffi_d_notmuch_database_needs_upgrade(notmuch_database_t * x0)
{
  return notmuch_database_needs_upgrade(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_needs_upgrade(PyObject *self, PyObject *arg0)
{
  notmuch_database_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_needs_upgrade(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_needs_upgrade _cffi_d_notmuch_database_needs_upgrade
#endif

static notmuch_status_t _cffi_d_notmuch_database_open_with_config(char const * x0, notmuch_database_mode_t x1, char const * x2, char const * x3, notmuch_database_t * * x4, char * * x5)
{
  return notmuch_database_open_with_config(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_open_with_config(PyObject *self, PyObject *args)
{
  char const * x0;
  notmuch_database_mode_t x1;
  char const * x2;
  char const * x3;
  notmuch_database_t * * x4;
  char * * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "notmuch_database_open_with_config", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(105), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(100), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (notmuch_database_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(100), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(101), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(101), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_open_with_config(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_open_with_config _cffi_d_notmuch_database_open_with_config
#endif

static notmuch_status_t _cffi_d_notmuch_database_remove_message(notmuch_database_t * x0, char const * x1)
{
  return notmuch_database_remove_message(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_remove_message(PyObject *self, PyObject *args)
{
  notmuch_database_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_database_remove_message", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_remove_message(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_remove_message _cffi_d_notmuch_database_remove_message
#endif

static notmuch_status_t _cffi_d_notmuch_database_set_config(notmuch_database_t * x0, char const * x1, char const * x2)
{
  return notmuch_database_set_config(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_database_set_config(PyObject *self, PyObject *args)
{
  notmuch_database_t * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notmuch_database_set_config", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_database_set_config(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_database_set_config _cffi_d_notmuch_database_set_config
#endif

static void _cffi_d_notmuch_filenames_destroy(notmuch_filenames_t * x0)
{
  notmuch_filenames_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_filenames_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_filenames_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_filenames_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_filenames_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_filenames_destroy _cffi_d_notmuch_filenames_destroy
#endif

static char const * _cffi_d_notmuch_filenames_get(notmuch_filenames_t * x0)
{
  return notmuch_filenames_get(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_filenames_get(PyObject *self, PyObject *arg0)
{
  notmuch_filenames_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_filenames_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_filenames_get(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_filenames_get _cffi_d_notmuch_filenames_get
#endif

static void _cffi_d_notmuch_filenames_move_to_next(notmuch_filenames_t * x0)
{
  notmuch_filenames_move_to_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_filenames_move_to_next(PyObject *self, PyObject *arg0)
{
  notmuch_filenames_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_filenames_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_filenames_move_to_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_filenames_move_to_next _cffi_d_notmuch_filenames_move_to_next
#endif

static int _cffi_d_notmuch_filenames_valid(notmuch_filenames_t * x0)
{
  return notmuch_filenames_valid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_filenames_valid(PyObject *self, PyObject *arg0)
{
  notmuch_filenames_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_filenames_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_filenames_valid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_filenames_valid _cffi_d_notmuch_filenames_valid
#endif

static void _cffi_d_notmuch_indexopts_destroy(notmuch_indexopts_t * x0)
{
  notmuch_indexopts_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_indexopts_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_indexopts_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_indexopts_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_indexopts_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_indexopts_destroy _cffi_d_notmuch_indexopts_destroy
#endif

static notmuch_decryption_policy_t _cffi_d_notmuch_indexopts_get_decrypt_policy(notmuch_indexopts_t const * x0)
{
  return notmuch_indexopts_get_decrypt_policy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_indexopts_get_decrypt_policy(PyObject *self, PyObject *arg0)
{
  notmuch_indexopts_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_decryption_policy_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_indexopts_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(67), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_indexopts_get_decrypt_policy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(141));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_indexopts_get_decrypt_policy _cffi_d_notmuch_indexopts_get_decrypt_policy
#endif

static notmuch_status_t _cffi_d_notmuch_indexopts_set_decrypt_policy(notmuch_indexopts_t * x0, notmuch_decryption_policy_t x1)
{
  return notmuch_indexopts_set_decrypt_policy(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_indexopts_set_decrypt_policy(PyObject *self, PyObject *args)
{
  notmuch_indexopts_t * x0;
  notmuch_decryption_policy_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_indexopts_set_decrypt_policy", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_indexopts_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(141), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_indexopts_set_decrypt_policy(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_indexopts_set_decrypt_policy _cffi_d_notmuch_indexopts_set_decrypt_policy
#endif

static notmuch_status_t _cffi_d_notmuch_message_add_property(notmuch_message_t * x0, char const * x1, char const * x2)
{
  return notmuch_message_add_property(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_add_property(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notmuch_message_add_property", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_add_property(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_add_property _cffi_d_notmuch_message_add_property
#endif

static notmuch_status_t _cffi_d_notmuch_message_add_tag(notmuch_message_t * x0, char const * x1)
{
  return notmuch_message_add_tag(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_add_tag(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_message_add_tag", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_add_tag(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_add_tag _cffi_d_notmuch_message_add_tag
#endif

static void _cffi_d_notmuch_message_destroy(notmuch_message_t * x0)
{
  notmuch_message_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_message_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_message_destroy _cffi_d_notmuch_message_destroy
#endif

static notmuch_status_t _cffi_d_notmuch_message_freeze(notmuch_message_t * x0)
{
  return notmuch_message_freeze(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_freeze(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_freeze(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_freeze _cffi_d_notmuch_message_freeze
#endif

static time_t _cffi_d_notmuch_message_get_date(notmuch_message_t * x0)
{
  return notmuch_message_get_date(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_date(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  time_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_date(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, time_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_date _cffi_d_notmuch_message_get_date
#endif

static char const * _cffi_d_notmuch_message_get_filename(notmuch_message_t * x0)
{
  return notmuch_message_get_filename(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_filename(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_filename(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_filename _cffi_d_notmuch_message_get_filename
#endif

static notmuch_filenames_t * _cffi_d_notmuch_message_get_filenames(notmuch_message_t * x0)
{
  return notmuch_message_get_filenames(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_filenames(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_filenames_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_filenames(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(7));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_filenames _cffi_d_notmuch_message_get_filenames
#endif

static int _cffi_d_notmuch_message_get_flag(notmuch_message_t * x0, notmuch_message_flag_t x1)
{
  return notmuch_message_get_flag(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_flag(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  notmuch_message_flag_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_message_get_flag", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(45), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_flag(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_flag _cffi_d_notmuch_message_get_flag
#endif

static char const * _cffi_d_notmuch_message_get_header(notmuch_message_t * x0, char const * x1)
{
  return notmuch_message_get_header(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_header(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_message_get_header", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_header(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_header _cffi_d_notmuch_message_get_header
#endif

static char const * _cffi_d_notmuch_message_get_message_id(notmuch_message_t * x0)
{
  return notmuch_message_get_message_id(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_message_id(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_message_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_message_id _cffi_d_notmuch_message_get_message_id
#endif

static notmuch_message_properties_t * _cffi_d_notmuch_message_get_properties(notmuch_message_t * x0, char const * x1, int x2)
{
  return notmuch_message_get_properties(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_properties(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_message_properties_t * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notmuch_message_get_properties", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_properties(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_properties _cffi_d_notmuch_message_get_properties
#endif

static notmuch_status_t _cffi_d_notmuch_message_get_property(notmuch_message_t * x0, char const * x1, char const * * x2)
{
  return notmuch_message_get_property(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_property(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  char const * x1;
  char const * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notmuch_message_get_property", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_property(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_property _cffi_d_notmuch_message_get_property
#endif

static notmuch_messages_t * _cffi_d_notmuch_message_get_replies(notmuch_message_t * x0)
{
  return notmuch_message_get_replies(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_replies(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_messages_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_replies(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(48));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_replies _cffi_d_notmuch_message_get_replies
#endif

static notmuch_tags_t * _cffi_d_notmuch_message_get_tags(notmuch_message_t * x0)
{
  return notmuch_message_get_tags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_tags(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_tags_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_tags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(26));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_tags _cffi_d_notmuch_message_get_tags
#endif

static char const * _cffi_d_notmuch_message_get_thread_id(notmuch_message_t * x0)
{
  return notmuch_message_get_thread_id(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_get_thread_id(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_get_thread_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_get_thread_id _cffi_d_notmuch_message_get_thread_id
#endif

static notmuch_status_t _cffi_d_notmuch_message_maildir_flags_to_tags(notmuch_message_t * x0)
{
  return notmuch_message_maildir_flags_to_tags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_maildir_flags_to_tags(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_maildir_flags_to_tags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_maildir_flags_to_tags _cffi_d_notmuch_message_maildir_flags_to_tags
#endif

static void _cffi_d_notmuch_message_properties_destroy(notmuch_message_properties_t * x0)
{
  notmuch_message_properties_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_properties_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_message_properties_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_properties_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_message_properties_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_message_properties_destroy _cffi_d_notmuch_message_properties_destroy
#endif

static char const * _cffi_d_notmuch_message_properties_key(notmuch_message_properties_t * x0)
{
  return notmuch_message_properties_key(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_properties_key(PyObject *self, PyObject *arg0)
{
  notmuch_message_properties_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_properties_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_properties_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_properties_key _cffi_d_notmuch_message_properties_key
#endif

static void _cffi_d_notmuch_message_properties_move_to_next(notmuch_message_properties_t * x0)
{
  notmuch_message_properties_move_to_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_properties_move_to_next(PyObject *self, PyObject *arg0)
{
  notmuch_message_properties_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_properties_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_message_properties_move_to_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_message_properties_move_to_next _cffi_d_notmuch_message_properties_move_to_next
#endif

static int _cffi_d_notmuch_message_properties_valid(notmuch_message_properties_t * x0)
{
  return notmuch_message_properties_valid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_properties_valid(PyObject *self, PyObject *arg0)
{
  notmuch_message_properties_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_properties_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_properties_valid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_properties_valid _cffi_d_notmuch_message_properties_valid
#endif

static char const * _cffi_d_notmuch_message_properties_value(notmuch_message_properties_t * x0)
{
  return notmuch_message_properties_value(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_properties_value(PyObject *self, PyObject *arg0)
{
  notmuch_message_properties_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_properties_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_properties_value(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_properties_value _cffi_d_notmuch_message_properties_value
#endif

static notmuch_status_t _cffi_d_notmuch_message_remove_all_properties(notmuch_message_t * x0, char const * x1)
{
  return notmuch_message_remove_all_properties(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_remove_all_properties(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_message_remove_all_properties", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_remove_all_properties(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_remove_all_properties _cffi_d_notmuch_message_remove_all_properties
#endif

static notmuch_status_t _cffi_d_notmuch_message_remove_all_tags(notmuch_message_t * x0)
{
  return notmuch_message_remove_all_tags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_remove_all_tags(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_remove_all_tags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_remove_all_tags _cffi_d_notmuch_message_remove_all_tags
#endif

static notmuch_status_t _cffi_d_notmuch_message_remove_property(notmuch_message_t * x0, char const * x1, char const * x2)
{
  return notmuch_message_remove_property(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_remove_property(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notmuch_message_remove_property", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_remove_property(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_remove_property _cffi_d_notmuch_message_remove_property
#endif

static notmuch_status_t _cffi_d_notmuch_message_remove_tag(notmuch_message_t * x0, char const * x1)
{
  return notmuch_message_remove_tag(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_remove_tag(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_message_remove_tag", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_remove_tag(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_remove_tag _cffi_d_notmuch_message_remove_tag
#endif

static void _cffi_d_notmuch_message_set_flag(notmuch_message_t * x0, notmuch_message_flag_t x1, int x2)
{
  notmuch_message_set_flag(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_set_flag(PyObject *self, PyObject *args)
{
  notmuch_message_t * x0;
  notmuch_message_flag_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "notmuch_message_set_flag", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(45), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_message_set_flag(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_message_set_flag _cffi_d_notmuch_message_set_flag
#endif

static notmuch_status_t _cffi_d_notmuch_message_tags_to_maildir_flags(notmuch_message_t * x0)
{
  return notmuch_message_tags_to_maildir_flags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_tags_to_maildir_flags(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_tags_to_maildir_flags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_tags_to_maildir_flags _cffi_d_notmuch_message_tags_to_maildir_flags
#endif

static notmuch_status_t _cffi_d_notmuch_message_thaw(notmuch_message_t * x0)
{
  return notmuch_message_thaw(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_message_thaw(PyObject *self, PyObject *arg0)
{
  notmuch_message_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_message_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_message_thaw(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_message_thaw _cffi_d_notmuch_message_thaw
#endif

static notmuch_tags_t * _cffi_d_notmuch_messages_collect_tags(notmuch_messages_t * x0)
{
  return notmuch_messages_collect_tags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_messages_collect_tags(PyObject *self, PyObject *arg0)
{
  notmuch_messages_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_tags_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_messages_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_messages_collect_tags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(26));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_messages_collect_tags _cffi_d_notmuch_messages_collect_tags
#endif

static void _cffi_d_notmuch_messages_destroy(notmuch_messages_t * x0)
{
  notmuch_messages_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_messages_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_messages_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_messages_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_messages_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_messages_destroy _cffi_d_notmuch_messages_destroy
#endif

static notmuch_message_t * _cffi_d_notmuch_messages_get(notmuch_messages_t * x0)
{
  return notmuch_messages_get(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_messages_get(PyObject *self, PyObject *arg0)
{
  notmuch_messages_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_message_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_messages_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_messages_get(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_messages_get _cffi_d_notmuch_messages_get
#endif

static void _cffi_d_notmuch_messages_move_to_next(notmuch_messages_t * x0)
{
  notmuch_messages_move_to_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_messages_move_to_next(PyObject *self, PyObject *arg0)
{
  notmuch_messages_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_messages_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_messages_move_to_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_messages_move_to_next _cffi_d_notmuch_messages_move_to_next
#endif

static int _cffi_d_notmuch_messages_valid(notmuch_messages_t * x0)
{
  return notmuch_messages_valid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_messages_valid(PyObject *self, PyObject *arg0)
{
  notmuch_messages_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_messages_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_messages_valid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_messages_valid _cffi_d_notmuch_messages_valid
#endif

static notmuch_status_t _cffi_d_notmuch_query_add_tag_exclude(notmuch_query_t * x0, char const * x1)
{
  return notmuch_query_add_tag_exclude(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_add_tag_exclude(PyObject *self, PyObject *args)
{
  notmuch_query_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_query_add_tag_exclude", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_query_add_tag_exclude(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_query_add_tag_exclude _cffi_d_notmuch_query_add_tag_exclude
#endif

static notmuch_status_t _cffi_d_notmuch_query_count_messages(notmuch_query_t * x0, unsigned int * x1)
{
  return notmuch_query_count_messages(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_count_messages(PyObject *self, PyObject *args)
{
  notmuch_query_t * x0;
  unsigned int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_query_count_messages", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(174), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(174), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_query_count_messages(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_query_count_messages _cffi_d_notmuch_query_count_messages
#endif

static notmuch_status_t _cffi_d_notmuch_query_count_threads(notmuch_query_t * x0, unsigned int * x1)
{
  return notmuch_query_count_threads(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_count_threads(PyObject *self, PyObject *args)
{
  notmuch_query_t * x0;
  unsigned int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_query_count_threads", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(174), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(174), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_query_count_threads(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_query_count_threads _cffi_d_notmuch_query_count_threads
#endif

static notmuch_query_t * _cffi_d_notmuch_query_create(notmuch_database_t * x0, char const * x1)
{
  return notmuch_query_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_create(PyObject *self, PyObject *args)
{
  notmuch_database_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_query_t * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_query_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_database_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_query_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(161));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_query_create _cffi_d_notmuch_query_create
#endif

static void _cffi_d_notmuch_query_destroy(notmuch_query_t * x0)
{
  notmuch_query_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_query_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_query_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_query_destroy _cffi_d_notmuch_query_destroy
#endif

static notmuch_database_t * _cffi_d_notmuch_query_get_database(notmuch_query_t const * x0)
{
  return notmuch_query_get_database(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_get_database(PyObject *self, PyObject *arg0)
{
  notmuch_query_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_database_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_query_get_database(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_query_get_database _cffi_d_notmuch_query_get_database
#endif

static char const * _cffi_d_notmuch_query_get_query_string(notmuch_query_t const * x0)
{
  return notmuch_query_get_query_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_get_query_string(PyObject *self, PyObject *arg0)
{
  notmuch_query_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_query_get_query_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_query_get_query_string _cffi_d_notmuch_query_get_query_string
#endif

static notmuch_sort_t _cffi_d_notmuch_query_get_sort(notmuch_query_t const * x0)
{
  return notmuch_query_get_sort(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_get_sort(PyObject *self, PyObject *arg0)
{
  notmuch_query_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_sort_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_query_get_sort(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(236));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_query_get_sort _cffi_d_notmuch_query_get_sort
#endif

static notmuch_status_t _cffi_d_notmuch_query_search_messages(notmuch_query_t * x0, notmuch_messages_t * * x1)
{
  return notmuch_query_search_messages(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_search_messages(PyObject *self, PyObject *args)
{
  notmuch_query_t * x0;
  notmuch_messages_t * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_query_search_messages", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(166), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (notmuch_messages_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(166), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_query_search_messages(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_query_search_messages _cffi_d_notmuch_query_search_messages
#endif

static notmuch_status_t _cffi_d_notmuch_query_search_threads(notmuch_query_t * x0, notmuch_threads_t * * x1)
{
  return notmuch_query_search_threads(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_search_threads(PyObject *self, PyObject *args)
{
  notmuch_query_t * x0;
  notmuch_threads_t * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_query_search_threads", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(170), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (notmuch_threads_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(170), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_query_search_threads(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_query_search_threads _cffi_d_notmuch_query_search_threads
#endif

static void _cffi_d_notmuch_query_set_omit_excluded(notmuch_query_t * x0, notmuch_exclude_t x1)
{
  notmuch_query_set_omit_excluded(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_set_omit_excluded(PyObject *self, PyObject *args)
{
  notmuch_query_t * x0;
  notmuch_exclude_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_query_set_omit_excluded", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(232), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_query_set_omit_excluded(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_query_set_omit_excluded _cffi_d_notmuch_query_set_omit_excluded
#endif

static void _cffi_d_notmuch_query_set_sort(notmuch_query_t * x0, notmuch_sort_t x1)
{
  notmuch_query_set_sort(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_query_set_sort(PyObject *self, PyObject *args)
{
  notmuch_query_t * x0;
  notmuch_sort_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "notmuch_query_set_sort", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_query_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(236), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_query_set_sort(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_query_set_sort _cffi_d_notmuch_query_set_sort
#endif

static char const * _cffi_d_notmuch_status_to_string(notmuch_status_t x0)
{
  return notmuch_status_to_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_status_to_string(PyObject *self, PyObject *arg0)
{
  notmuch_status_t x0;
  char const * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(23), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_status_to_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  return pyresult;
}
#else
#  define _cffi_f_notmuch_status_to_string _cffi_d_notmuch_status_to_string
#endif

static void _cffi_d_notmuch_tags_destroy(notmuch_tags_t * x0)
{
  notmuch_tags_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_tags_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_tags_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_tags_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_tags_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_tags_destroy _cffi_d_notmuch_tags_destroy
#endif

static char const * _cffi_d_notmuch_tags_get(notmuch_tags_t * x0)
{
  return notmuch_tags_get(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_tags_get(PyObject *self, PyObject *arg0)
{
  notmuch_tags_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_tags_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_tags_get(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_tags_get _cffi_d_notmuch_tags_get
#endif

static void _cffi_d_notmuch_tags_move_to_next(notmuch_tags_t * x0)
{
  notmuch_tags_move_to_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_tags_move_to_next(PyObject *self, PyObject *arg0)
{
  notmuch_tags_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_tags_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_tags_move_to_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_tags_move_to_next _cffi_d_notmuch_tags_move_to_next
#endif

static int _cffi_d_notmuch_tags_valid(notmuch_tags_t * x0)
{
  return notmuch_tags_valid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_tags_valid(PyObject *self, PyObject *arg0)
{
  notmuch_tags_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_tags_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_tags_valid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_tags_valid _cffi_d_notmuch_tags_valid
#endif

static void _cffi_d_notmuch_thread_destroy(notmuch_thread_t * x0)
{
  notmuch_thread_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_thread_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_thread_destroy _cffi_d_notmuch_thread_destroy
#endif

static char const * _cffi_d_notmuch_thread_get_authors(notmuch_thread_t * x0)
{
  return notmuch_thread_get_authors(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_authors(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_authors(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_authors _cffi_d_notmuch_thread_get_authors
#endif

static int _cffi_d_notmuch_thread_get_matched_messages(notmuch_thread_t * x0)
{
  return notmuch_thread_get_matched_messages(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_matched_messages(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_matched_messages(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_matched_messages _cffi_d_notmuch_thread_get_matched_messages
#endif

static notmuch_messages_t * _cffi_d_notmuch_thread_get_messages(notmuch_thread_t * x0)
{
  return notmuch_thread_get_messages(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_messages(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_messages_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_messages(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(48));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_messages _cffi_d_notmuch_thread_get_messages
#endif

static time_t _cffi_d_notmuch_thread_get_newest_date(notmuch_thread_t * x0)
{
  return notmuch_thread_get_newest_date(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_newest_date(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  time_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_newest_date(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, time_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_newest_date _cffi_d_notmuch_thread_get_newest_date
#endif

static time_t _cffi_d_notmuch_thread_get_oldest_date(notmuch_thread_t * x0)
{
  return notmuch_thread_get_oldest_date(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_oldest_date(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  time_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_oldest_date(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, time_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_oldest_date _cffi_d_notmuch_thread_get_oldest_date
#endif

static char const * _cffi_d_notmuch_thread_get_subject(notmuch_thread_t * x0)
{
  return notmuch_thread_get_subject(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_subject(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_subject(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_subject _cffi_d_notmuch_thread_get_subject
#endif

static notmuch_tags_t * _cffi_d_notmuch_thread_get_tags(notmuch_thread_t * x0)
{
  return notmuch_thread_get_tags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_tags(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_tags_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_tags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(26));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_tags _cffi_d_notmuch_thread_get_tags
#endif

static char const * _cffi_d_notmuch_thread_get_thread_id(notmuch_thread_t * x0)
{
  return notmuch_thread_get_thread_id(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_thread_id(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_thread_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_thread_id _cffi_d_notmuch_thread_get_thread_id
#endif

static notmuch_messages_t * _cffi_d_notmuch_thread_get_toplevel_messages(notmuch_thread_t * x0)
{
  return notmuch_thread_get_toplevel_messages(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_toplevel_messages(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_messages_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_toplevel_messages(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(48));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_toplevel_messages _cffi_d_notmuch_thread_get_toplevel_messages
#endif

static int _cffi_d_notmuch_thread_get_total_messages(notmuch_thread_t * x0)
{
  return notmuch_thread_get_total_messages(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_thread_get_total_messages(PyObject *self, PyObject *arg0)
{
  notmuch_thread_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_thread_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_thread_get_total_messages(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_thread_get_total_messages _cffi_d_notmuch_thread_get_total_messages
#endif

static void _cffi_d_notmuch_threads_destroy(notmuch_threads_t * x0)
{
  notmuch_threads_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_threads_destroy(PyObject *self, PyObject *arg0)
{
  notmuch_threads_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_threads_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_threads_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_threads_destroy _cffi_d_notmuch_threads_destroy
#endif

static notmuch_thread_t * _cffi_d_notmuch_threads_get(notmuch_threads_t * x0)
{
  return notmuch_threads_get(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_threads_get(PyObject *self, PyObject *arg0)
{
  notmuch_threads_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  notmuch_thread_t * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_threads_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_threads_get(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_threads_get _cffi_d_notmuch_threads_get
#endif

static void _cffi_d_notmuch_threads_move_to_next(notmuch_threads_t * x0)
{
  notmuch_threads_move_to_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_threads_move_to_next(PyObject *self, PyObject *arg0)
{
  notmuch_threads_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_threads_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { notmuch_threads_move_to_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_notmuch_threads_move_to_next _cffi_d_notmuch_threads_move_to_next
#endif

static int _cffi_d_notmuch_threads_valid(notmuch_threads_t * x0)
{
  return notmuch_threads_valid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_notmuch_threads_valid(PyObject *self, PyObject *arg0)
{
  notmuch_threads_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (notmuch_threads_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = notmuch_threads_valid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_notmuch_threads_valid _cffi_d_notmuch_threads_valid
#endif

static int _cffi_const_LIBNOTMUCH_MAJOR_VERSION(unsigned long long *o)
{
  int n = (LIBNOTMUCH_MAJOR_VERSION) <= 0;
  *o = (unsigned long long)((LIBNOTMUCH_MAJOR_VERSION) | 0);  /* check that LIBNOTMUCH_MAJOR_VERSION is an integer */
  return n;
}

static int _cffi_const_LIBNOTMUCH_MICRO_VERSION(unsigned long long *o)
{
  int n = (LIBNOTMUCH_MICRO_VERSION) <= 0;
  *o = (unsigned long long)((LIBNOTMUCH_MICRO_VERSION) | 0);  /* check that LIBNOTMUCH_MICRO_VERSION is an integer */
  return n;
}

static int _cffi_const_LIBNOTMUCH_MINOR_VERSION(unsigned long long *o)
{
  int n = (LIBNOTMUCH_MINOR_VERSION) <= 0;
  *o = (unsigned long long)((LIBNOTMUCH_MINOR_VERSION) | 0);  /* check that LIBNOTMUCH_MINOR_VERSION is an integer */
  return n;
}

static int _cffi_const_NOTMUCH_TAG_MAX(unsigned long long *o)
{
  int n = (NOTMUCH_TAG_MAX) <= 0;
  *o = (unsigned long long)((NOTMUCH_TAG_MAX) | 0);  /* check that NOTMUCH_TAG_MAX is an integer */
  return n;
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "LIBNOTMUCH_MAJOR_VERSION", (void *)_cffi_const_LIBNOTMUCH_MAJOR_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LIBNOTMUCH_MICRO_VERSION", (void *)_cffi_const_LIBNOTMUCH_MICRO_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LIBNOTMUCH_MINOR_VERSION", (void *)_cffi_const_LIBNOTMUCH_MINOR_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "NOTMUCH_DATABASE_MODE_READ_ONLY", (void *)_cffi_const_NOTMUCH_DATABASE_MODE_READ_ONLY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_DATABASE_MODE_READ_WRITE", (void *)_cffi_const_NOTMUCH_DATABASE_MODE_READ_WRITE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_DECRYPT_AUTO", (void *)_cffi_const_NOTMUCH_DECRYPT_AUTO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_DECRYPT_FALSE", (void *)_cffi_const_NOTMUCH_DECRYPT_FALSE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_DECRYPT_NOSTASH", (void *)_cffi_const_NOTMUCH_DECRYPT_NOSTASH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_DECRYPT_TRUE", (void *)_cffi_const_NOTMUCH_DECRYPT_TRUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_EXCLUDE_ALL", (void *)_cffi_const_NOTMUCH_EXCLUDE_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_EXCLUDE_FALSE", (void *)_cffi_const_NOTMUCH_EXCLUDE_FALSE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_EXCLUDE_FLAG", (void *)_cffi_const_NOTMUCH_EXCLUDE_FLAG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_EXCLUDE_TRUE", (void *)_cffi_const_NOTMUCH_EXCLUDE_TRUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_MESSAGE_FLAG_EXCLUDED", (void *)_cffi_const_NOTMUCH_MESSAGE_FLAG_EXCLUDED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_MESSAGE_FLAG_GHOST", (void *)_cffi_const_NOTMUCH_MESSAGE_FLAG_GHOST, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_MESSAGE_FLAG_MATCH", (void *)_cffi_const_NOTMUCH_MESSAGE_FLAG_MATCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_SORT_MESSAGE_ID", (void *)_cffi_const_NOTMUCH_SORT_MESSAGE_ID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_SORT_NEWEST_FIRST", (void *)_cffi_const_NOTMUCH_SORT_NEWEST_FIRST, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_SORT_OLDEST_FIRST", (void *)_cffi_const_NOTMUCH_SORT_OLDEST_FIRST, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_SORT_UNSORTED", (void *)_cffi_const_NOTMUCH_SORT_UNSORTED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_BAD_QUERY_SYNTAX", (void *)_cffi_const_NOTMUCH_STATUS_BAD_QUERY_SYNTAX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_CLOSED_DATABASE", (void *)_cffi_const_NOTMUCH_STATUS_CLOSED_DATABASE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_DATABASE_EXISTS", (void *)_cffi_const_NOTMUCH_STATUS_DATABASE_EXISTS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_DUPLICATE_MESSAGE_ID", (void *)_cffi_const_NOTMUCH_STATUS_DUPLICATE_MESSAGE_ID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_FAILED_CRYPTO_CONTEXT_CREATION", (void *)_cffi_const_NOTMUCH_STATUS_FAILED_CRYPTO_CONTEXT_CREATION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_FILE_ERROR", (void *)_cffi_const_NOTMUCH_STATUS_FILE_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_FILE_NOT_EMAIL", (void *)_cffi_const_NOTMUCH_STATUS_FILE_NOT_EMAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_ILLEGAL_ARGUMENT", (void *)_cffi_const_NOTMUCH_STATUS_ILLEGAL_ARGUMENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_LAST_STATUS", (void *)_cffi_const_NOTMUCH_STATUS_LAST_STATUS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_MALFORMED_CRYPTO_PROTOCOL", (void *)_cffi_const_NOTMUCH_STATUS_MALFORMED_CRYPTO_PROTOCOL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_NO_CONFIG", (void *)_cffi_const_NOTMUCH_STATUS_NO_CONFIG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_NO_DATABASE", (void *)_cffi_const_NOTMUCH_STATUS_NO_DATABASE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_NO_MAIL_ROOT", (void *)_cffi_const_NOTMUCH_STATUS_NO_MAIL_ROOT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_NULL_POINTER", (void *)_cffi_const_NOTMUCH_STATUS_NULL_POINTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_OUT_OF_MEMORY", (void *)_cffi_const_NOTMUCH_STATUS_OUT_OF_MEMORY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_PATH_ERROR", (void *)_cffi_const_NOTMUCH_STATUS_PATH_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_READ_ONLY_DATABASE", (void *)_cffi_const_NOTMUCH_STATUS_READ_ONLY_DATABASE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_SUCCESS", (void *)_cffi_const_NOTMUCH_STATUS_SUCCESS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_TAG_TOO_LONG", (void *)_cffi_const_NOTMUCH_STATUS_TAG_TOO_LONG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_UNBALANCED_ATOMIC", (void *)_cffi_const_NOTMUCH_STATUS_UNBALANCED_ATOMIC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_UNBALANCED_FREEZE_THAW", (void *)_cffi_const_NOTMUCH_STATUS_UNBALANCED_FREEZE_THAW, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_UNKNOWN_CRYPTO_PROTOCOL", (void *)_cffi_const_NOTMUCH_STATUS_UNKNOWN_CRYPTO_PROTOCOL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_UNSUPPORTED_OPERATION", (void *)_cffi_const_NOTMUCH_STATUS_UNSUPPORTED_OPERATION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_UPGRADE_REQUIRED", (void *)_cffi_const_NOTMUCH_STATUS_UPGRADE_REQUIRED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_STATUS_XAPIAN_EXCEPTION", (void *)_cffi_const_NOTMUCH_STATUS_XAPIAN_EXCEPTION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOTMUCH_TAG_MAX", (void *)_cffi_const_NOTMUCH_TAG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "free", (void *)_cffi_f_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 247), (void *)_cffi_d_free },
  { "notmuch_config_get_pairs", (void *)_cffi_f_notmuch_config_get_pairs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 59), (void *)_cffi_d_notmuch_config_get_pairs },
  { "notmuch_config_pairs_destroy", (void *)_cffi_f_notmuch_config_pairs_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 204), (void *)_cffi_d_notmuch_config_pairs_destroy },
  { "notmuch_config_pairs_key", (void *)_cffi_f_notmuch_config_pairs_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_notmuch_config_pairs_key },
  { "notmuch_config_pairs_move_to_next", (void *)_cffi_f_notmuch_config_pairs_move_to_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 204), (void *)_cffi_d_notmuch_config_pairs_move_to_next },
  { "notmuch_config_pairs_valid", (void *)_cffi_f_notmuch_config_pairs_valid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 31), (void *)_cffi_d_notmuch_config_pairs_valid },
  { "notmuch_config_pairs_value", (void *)_cffi_f_notmuch_config_pairs_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_notmuch_config_pairs_value },
  { "notmuch_database_begin_atomic", (void *)_cffi_f_notmuch_database_begin_atomic, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 111), (void *)_cffi_d_notmuch_database_begin_atomic },
  { "notmuch_database_close", (void *)_cffi_f_notmuch_database_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 111), (void *)_cffi_d_notmuch_database_close },
  { "notmuch_database_create_with_config", (void *)_cffi_f_notmuch_database_create_with_config, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 96), (void *)_cffi_d_notmuch_database_create_with_config },
  { "notmuch_database_destroy", (void *)_cffi_f_notmuch_database_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 111), (void *)_cffi_d_notmuch_database_destroy },
  { "notmuch_database_end_atomic", (void *)_cffi_f_notmuch_database_end_atomic, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 111), (void *)_cffi_d_notmuch_database_end_atomic },
  { "notmuch_database_find_message", (void *)_cffi_f_notmuch_database_find_message, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 134), (void *)_cffi_d_notmuch_database_find_message },
  { "notmuch_database_find_message_by_filename", (void *)_cffi_f_notmuch_database_find_message_by_filename, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 134), (void *)_cffi_d_notmuch_database_find_message_by_filename },
  { "notmuch_database_get_all_tags", (void *)_cffi_f_notmuch_database_get_all_tags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 176), (void *)_cffi_d_notmuch_database_get_all_tags },
  { "notmuch_database_get_config", (void *)_cffi_f_notmuch_database_get_config, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_notmuch_database_get_config },
  { "notmuch_database_get_default_indexopts", (void *)_cffi_f_notmuch_database_get_default_indexopts, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 72), (void *)_cffi_d_notmuch_database_get_default_indexopts },
  { "notmuch_database_get_path", (void *)_cffi_f_notmuch_database_get_path, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_notmuch_database_get_path },
  { "notmuch_database_get_revision", (void *)_cffi_f_notmuch_database_get_revision, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 200), (void *)_cffi_d_notmuch_database_get_revision },
  { "notmuch_database_get_version", (void *)_cffi_f_notmuch_database_get_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 197), (void *)_cffi_d_notmuch_database_get_version },
  { "notmuch_database_index_file", (void *)_cffi_f_notmuch_database_index_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 128), (void *)_cffi_d_notmuch_database_index_file },
  { "notmuch_database_needs_upgrade", (void *)_cffi_f_notmuch_database_needs_upgrade, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 34), (void *)_cffi_d_notmuch_database_needs_upgrade },
  { "notmuch_database_open_with_config", (void *)_cffi_f_notmuch_database_open_with_config, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 103), (void *)_cffi_d_notmuch_database_open_with_config },
  { "notmuch_database_remove_message", (void *)_cffi_f_notmuch_database_remove_message, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_notmuch_database_remove_message },
  { "notmuch_database_set_config", (void *)_cffi_f_notmuch_database_set_config, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 123), (void *)_cffi_d_notmuch_database_set_config },
  { "notmuch_filenames_destroy", (void *)_cffi_f_notmuch_filenames_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 207), (void *)_cffi_d_notmuch_filenames_destroy },
  { "notmuch_filenames_get", (void *)_cffi_f_notmuch_filenames_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_notmuch_filenames_get },
  { "notmuch_filenames_move_to_next", (void *)_cffi_f_notmuch_filenames_move_to_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 207), (void *)_cffi_d_notmuch_filenames_move_to_next },
  { "notmuch_filenames_valid", (void *)_cffi_f_notmuch_filenames_valid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 37), (void *)_cffi_d_notmuch_filenames_valid },
  { "notmuch_indexopts_destroy", (void *)_cffi_f_notmuch_indexopts_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 210), (void *)_cffi_d_notmuch_indexopts_destroy },
  { "notmuch_indexopts_get_decrypt_policy", (void *)_cffi_f_notmuch_indexopts_get_decrypt_policy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 66), (void *)_cffi_d_notmuch_indexopts_get_decrypt_policy },
  { "notmuch_indexopts_set_decrypt_policy", (void *)_cffi_f_notmuch_indexopts_set_decrypt_policy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 139), (void *)_cffi_d_notmuch_indexopts_set_decrypt_policy },
  { "notmuch_message_add_property", (void *)_cffi_f_notmuch_message_add_property, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 155), (void *)_cffi_d_notmuch_message_add_property },
  { "notmuch_message_add_tag", (void *)_cffi_f_notmuch_message_add_tag, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 146), (void *)_cffi_d_notmuch_message_add_tag },
  { "notmuch_message_destroy", (void *)_cffi_f_notmuch_message_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 216), (void *)_cffi_d_notmuch_message_destroy },
  { "notmuch_message_freeze", (void *)_cffi_f_notmuch_message_freeze, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 143), (void *)_cffi_d_notmuch_message_freeze },
  { "notmuch_message_get_date", (void *)_cffi_f_notmuch_message_get_date, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 191), (void *)_cffi_d_notmuch_message_get_date },
  { "notmuch_message_get_filename", (void *)_cffi_f_notmuch_message_get_filename, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 12), (void *)_cffi_d_notmuch_message_get_filename },
  { "notmuch_message_get_filenames", (void *)_cffi_f_notmuch_message_get_filenames, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 69), (void *)_cffi_d_notmuch_message_get_filenames },
  { "notmuch_message_get_flag", (void *)_cffi_f_notmuch_message_get_flag, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 43), (void *)_cffi_d_notmuch_message_get_flag },
  { "notmuch_message_get_header", (void *)_cffi_f_notmuch_message_get_header, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 15), (void *)_cffi_d_notmuch_message_get_header },
  { "notmuch_message_get_message_id", (void *)_cffi_f_notmuch_message_get_message_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 12), (void *)_cffi_d_notmuch_message_get_message_id },
  { "notmuch_message_get_properties", (void *)_cffi_f_notmuch_message_get_properties, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 75), (void *)_cffi_d_notmuch_message_get_properties },
  { "notmuch_message_get_property", (void *)_cffi_f_notmuch_message_get_property, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 150), (void *)_cffi_d_notmuch_message_get_property },
  { "notmuch_message_get_replies", (void *)_cffi_f_notmuch_message_get_replies, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 83), (void *)_cffi_d_notmuch_message_get_replies },
  { "notmuch_message_get_tags", (void *)_cffi_f_notmuch_message_get_tags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 179), (void *)_cffi_d_notmuch_message_get_tags },
  { "notmuch_message_get_thread_id", (void *)_cffi_f_notmuch_message_get_thread_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 12), (void *)_cffi_d_notmuch_message_get_thread_id },
  { "notmuch_message_maildir_flags_to_tags", (void *)_cffi_f_notmuch_message_maildir_flags_to_tags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 143), (void *)_cffi_d_notmuch_message_maildir_flags_to_tags },
  { "notmuch_message_properties_destroy", (void *)_cffi_f_notmuch_message_properties_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_notmuch_message_properties_destroy },
  { "notmuch_message_properties_key", (void *)_cffi_f_notmuch_message_properties_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 9), (void *)_cffi_d_notmuch_message_properties_key },
  { "notmuch_message_properties_move_to_next", (void *)_cffi_f_notmuch_message_properties_move_to_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_notmuch_message_properties_move_to_next },
  { "notmuch_message_properties_valid", (void *)_cffi_f_notmuch_message_properties_valid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 40), (void *)_cffi_d_notmuch_message_properties_valid },
  { "notmuch_message_properties_value", (void *)_cffi_f_notmuch_message_properties_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 9), (void *)_cffi_d_notmuch_message_properties_value },
  { "notmuch_message_remove_all_properties", (void *)_cffi_f_notmuch_message_remove_all_properties, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 146), (void *)_cffi_d_notmuch_message_remove_all_properties },
  { "notmuch_message_remove_all_tags", (void *)_cffi_f_notmuch_message_remove_all_tags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 143), (void *)_cffi_d_notmuch_message_remove_all_tags },
  { "notmuch_message_remove_property", (void *)_cffi_f_notmuch_message_remove_property, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 155), (void *)_cffi_d_notmuch_message_remove_property },
  { "notmuch_message_remove_tag", (void *)_cffi_f_notmuch_message_remove_tag, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 146), (void *)_cffi_d_notmuch_message_remove_tag },
  { "notmuch_message_set_flag", (void *)_cffi_f_notmuch_message_set_flag, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 219), (void *)_cffi_d_notmuch_message_set_flag },
  { "notmuch_message_tags_to_maildir_flags", (void *)_cffi_f_notmuch_message_tags_to_maildir_flags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 143), (void *)_cffi_d_notmuch_message_tags_to_maildir_flags },
  { "notmuch_message_thaw", (void *)_cffi_f_notmuch_message_thaw, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 143), (void *)_cffi_d_notmuch_message_thaw },
  { "notmuch_messages_collect_tags", (void *)_cffi_f_notmuch_messages_collect_tags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 182), (void *)_cffi_d_notmuch_messages_collect_tags },
  { "notmuch_messages_destroy", (void *)_cffi_f_notmuch_messages_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 224), (void *)_cffi_d_notmuch_messages_destroy },
  { "notmuch_messages_get", (void *)_cffi_f_notmuch_messages_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 80), (void *)_cffi_d_notmuch_messages_get },
  { "notmuch_messages_move_to_next", (void *)_cffi_f_notmuch_messages_move_to_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 224), (void *)_cffi_d_notmuch_messages_move_to_next },
  { "notmuch_messages_valid", (void *)_cffi_f_notmuch_messages_valid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 47), (void *)_cffi_d_notmuch_messages_valid },
  { "notmuch_query_add_tag_exclude", (void *)_cffi_f_notmuch_query_add_tag_exclude, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 160), (void *)_cffi_d_notmuch_query_add_tag_exclude },
  { "notmuch_query_count_messages", (void *)_cffi_f_notmuch_query_count_messages, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 172), (void *)_cffi_d_notmuch_query_count_messages },
  { "notmuch_query_count_threads", (void *)_cffi_f_notmuch_query_count_threads, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 172), (void *)_cffi_d_notmuch_query_count_threads },
  { "notmuch_query_create", (void *)_cffi_f_notmuch_query_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 89), (void *)_cffi_d_notmuch_query_create },
  { "notmuch_query_destroy", (void *)_cffi_f_notmuch_query_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 227), (void *)_cffi_d_notmuch_query_destroy },
  { "notmuch_query_get_database", (void *)_cffi_f_notmuch_query_get_database, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 63), (void *)_cffi_d_notmuch_query_get_database },
  { "notmuch_query_get_query_string", (void *)_cffi_f_notmuch_query_get_query_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 19), (void *)_cffi_d_notmuch_query_get_query_string },
  { "notmuch_query_get_sort", (void *)_cffi_f_notmuch_query_get_sort, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 93), (void *)_cffi_d_notmuch_query_get_sort },
  { "notmuch_query_search_messages", (void *)_cffi_f_notmuch_query_search_messages, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 164), (void *)_cffi_d_notmuch_query_search_messages },
  { "notmuch_query_search_threads", (void *)_cffi_f_notmuch_query_search_threads, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 168), (void *)_cffi_d_notmuch_query_search_threads },
  { "notmuch_query_set_omit_excluded", (void *)_cffi_f_notmuch_query_set_omit_excluded, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 230), (void *)_cffi_d_notmuch_query_set_omit_excluded },
  { "notmuch_query_set_sort", (void *)_cffi_f_notmuch_query_set_sort, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 234), (void *)_cffi_d_notmuch_query_set_sort },
  { "notmuch_status_to_string", (void *)_cffi_f_notmuch_status_to_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 22), (void *)_cffi_d_notmuch_status_to_string },
  { "notmuch_tags_destroy", (void *)_cffi_f_notmuch_tags_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 238), (void *)_cffi_d_notmuch_tags_destroy },
  { "notmuch_tags_get", (void *)_cffi_f_notmuch_tags_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 25), (void *)_cffi_d_notmuch_tags_get },
  { "notmuch_tags_move_to_next", (void *)_cffi_f_notmuch_tags_move_to_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 238), (void *)_cffi_d_notmuch_tags_move_to_next },
  { "notmuch_tags_valid", (void *)_cffi_f_notmuch_tags_valid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 50), (void *)_cffi_d_notmuch_tags_valid },
  { "notmuch_thread_destroy", (void *)_cffi_f_notmuch_thread_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 241), (void *)_cffi_d_notmuch_thread_destroy },
  { "notmuch_thread_get_authors", (void *)_cffi_f_notmuch_thread_get_authors, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 28), (void *)_cffi_d_notmuch_thread_get_authors },
  { "notmuch_thread_get_matched_messages", (void *)_cffi_f_notmuch_thread_get_matched_messages, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 53), (void *)_cffi_d_notmuch_thread_get_matched_messages },
  { "notmuch_thread_get_messages", (void *)_cffi_f_notmuch_thread_get_messages, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 86), (void *)_cffi_d_notmuch_thread_get_messages },
  { "notmuch_thread_get_newest_date", (void *)_cffi_f_notmuch_thread_get_newest_date, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 194), (void *)_cffi_d_notmuch_thread_get_newest_date },
  { "notmuch_thread_get_oldest_date", (void *)_cffi_f_notmuch_thread_get_oldest_date, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 194), (void *)_cffi_d_notmuch_thread_get_oldest_date },
  { "notmuch_thread_get_subject", (void *)_cffi_f_notmuch_thread_get_subject, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 28), (void *)_cffi_d_notmuch_thread_get_subject },
  { "notmuch_thread_get_tags", (void *)_cffi_f_notmuch_thread_get_tags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 185), (void *)_cffi_d_notmuch_thread_get_tags },
  { "notmuch_thread_get_thread_id", (void *)_cffi_f_notmuch_thread_get_thread_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 28), (void *)_cffi_d_notmuch_thread_get_thread_id },
  { "notmuch_thread_get_toplevel_messages", (void *)_cffi_f_notmuch_thread_get_toplevel_messages, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 86), (void *)_cffi_d_notmuch_thread_get_toplevel_messages },
  { "notmuch_thread_get_total_messages", (void *)_cffi_f_notmuch_thread_get_total_messages, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 53), (void *)_cffi_d_notmuch_thread_get_total_messages },
  { "notmuch_threads_destroy", (void *)_cffi_f_notmuch_threads_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 244), (void *)_cffi_d_notmuch_threads_destroy },
  { "notmuch_threads_get", (void *)_cffi_f_notmuch_threads_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 188), (void *)_cffi_d_notmuch_threads_get },
  { "notmuch_threads_move_to_next", (void *)_cffi_f_notmuch_threads_move_to_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 244), (void *)_cffi_d_notmuch_threads_move_to_next },
  { "notmuch_threads_valid", (void *)_cffi_f_notmuch_threads_valid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 56), (void *)_cffi_d_notmuch_threads_valid },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "_notmuch_config_pairs", 252, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_database", 253, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_directory", 254, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_filenames", 255, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_indexopts", 256, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_message", 258, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_messages", 259, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_query", 260, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_string_map_iterator", 257, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_tags", 261, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_thread", 262, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_notmuch_threads", 263, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$notmuch_database_mode_t", 105, _cffi_prim_int(sizeof(notmuch_database_mode_t), ((notmuch_database_mode_t)-1) <= 0),
    "NOTMUCH_DATABASE_MODE_READ_ONLY,NOTMUCH_DATABASE_MODE_READ_WRITE" },
  { "$notmuch_decryption_policy_t", 141, _cffi_prim_int(sizeof(notmuch_decryption_policy_t), ((notmuch_decryption_policy_t)-1) <= 0),
    "NOTMUCH_DECRYPT_FALSE,NOTMUCH_DECRYPT_TRUE,NOTMUCH_DECRYPT_AUTO,NOTMUCH_DECRYPT_NOSTASH" },
  { "$notmuch_exclude_t", 232, _cffi_prim_int(sizeof(notmuch_exclude_t), ((notmuch_exclude_t)-1) <= 0),
    "NOTMUCH_EXCLUDE_FLAG,NOTMUCH_EXCLUDE_TRUE,NOTMUCH_EXCLUDE_FALSE,NOTMUCH_EXCLUDE_ALL" },
  { "$notmuch_sort_t", 236, _cffi_prim_int(sizeof(notmuch_sort_t), ((notmuch_sort_t)-1) <= 0),
    "NOTMUCH_SORT_OLDEST_FIRST,NOTMUCH_SORT_NEWEST_FIRST,NOTMUCH_SORT_MESSAGE_ID,NOTMUCH_SORT_UNSORTED" },
  { "_notmuch_message_flag", 45, _cffi_prim_int(sizeof(notmuch_message_flag_t), ((notmuch_message_flag_t)-1) <= 0),
    "NOTMUCH_MESSAGE_FLAG_MATCH,NOTMUCH_MESSAGE_FLAG_EXCLUDED,NOTMUCH_MESSAGE_FLAG_GHOST" },
  { "_notmuch_status", 23, _cffi_prim_int(sizeof(notmuch_status_t), ((notmuch_status_t)-1) <= 0),
    "NOTMUCH_STATUS_SUCCESS,NOTMUCH_STATUS_OUT_OF_MEMORY,NOTMUCH_STATUS_READ_ONLY_DATABASE,NOTMUCH_STATUS_XAPIAN_EXCEPTION,NOTMUCH_STATUS_FILE_ERROR,NOTMUCH_STATUS_FILE_NOT_EMAIL,NOTMUCH_STATUS_DUPLICATE_MESSAGE_ID,NOTMUCH_STATUS_NULL_POINTER,NOTMUCH_STATUS_TAG_TOO_LONG,NOTMUCH_STATUS_UNBALANCED_FREEZE_THAW,NOTMUCH_STATUS_UNBALANCED_ATOMIC,NOTMUCH_STATUS_UNSUPPORTED_OPERATION,NOTMUCH_STATUS_UPGRADE_REQUIRED,NOTMUCH_STATUS_PATH_ERROR,NOTMUCH_STATUS_ILLEGAL_ARGUMENT,NOTMUCH_STATUS_MALFORMED_CRYPTO_PROTOCOL,NOTMUCH_STATUS_FAILED_CRYPTO_CONTEXT_CREATION,NOTMUCH_STATUS_UNKNOWN_CRYPTO_PROTOCOL,NOTMUCH_STATUS_NO_CONFIG,NOTMUCH_STATUS_NO_DATABASE,NOTMUCH_STATUS_DATABASE_EXISTS,NOTMUCH_STATUS_BAD_QUERY_SYNTAX,NOTMUCH_STATUS_NO_MAIL_ROOT,NOTMUCH_STATUS_CLOSED_DATABASE,NOTMUCH_STATUS_LAST_STATUS" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "notmuch_bool_t", 78 },
  { "notmuch_config_pairs_t", 252 },
  { "notmuch_database_mode_t", 105 },
  { "notmuch_database_t", 253 },
  { "notmuch_decryption_policy_t", 141 },
  { "notmuch_directory_t", 254 },
  { "notmuch_exclude_t", 232 },
  { "notmuch_filenames_t", 255 },
  { "notmuch_indexopts_t", 256 },
  { "notmuch_message_flag_t", 45 },
  { "notmuch_message_properties_t", 257 },
  { "notmuch_message_t", 258 },
  { "notmuch_messages_t", 259 },
  { "notmuch_query_t", 260 },
  { "notmuch_sort_t", 236 },
  { "notmuch_status_t", 23 },
  { "notmuch_tags_t", 261 },
  { "notmuch_thread_t", 262 },
  { "notmuch_threads_t", 263 },
  { "time_t", 264 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  143,  /* num_globals */
  12,  /* num_struct_unions */
  6,  /* num_enums */
  20,  /* num_typenames */
  NULL,  /* no includes */
  268,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__capi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__capi(void) { return NULL; }
#  else
     init_capi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__capi(void)
{
  return _cffi_init("notmuch2._capi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_capi(void)
{
  _cffi_init("notmuch2._capi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
