
#include "ooxml/resourceids.hxx"
#include "OOXMLFactory_dml-shapeGeometry.hxx"
#include "ooxml/OOXMLFastHelper.hxx"
#include "oox/token/tokens.hxx"

#ifdef _MSC_VER
#pragma warning(disable:4060) // switch statement contains no 'case' or 'default' labels
#pragma warning(disable:4065) // switch statement contains 'default' but no 'case' labels
#pragma warning(disable:4702) // unreachable code
#endif

namespace writerfilter {
namespace ooxml {

using namespace com::sun::star;

/// @cond GENERATED

OOXMLFactory_dml_shapeGeometry::OOXMLFactory_dml_shapeGeometry()
{
}

OOXMLFactory_dml_shapeGeometry::~OOXMLFactory_dml_shapeGeometry()
{
}

OOXMLFactory_ns::Pointer_t OOXMLFactory_dml_shapeGeometry::m_pInstance;

OOXMLFactory_ns::Pointer_t OOXMLFactory_dml_shapeGeometry::getInstance()
{
    if (!m_pInstance)
        m_pInstance = new OOXMLFactory_dml_shapeGeometry();

    return m_pInstance;
}

const AttributeInfo* OOXMLFactory_dml_shapeGeometry::getAttributeInfoArray(Id nId)
{
    switch (nId)
    {
    case NN_dml_shapeGeometry|DEFINE_CT_GeomGuide:
        {
            const static AttributeInfo info[] = {
                { oox::XML_name, ResourceType::String, NN_dml_shapeGeometry|DEFINE_ST_GeomGuideName },
                { oox::XML_fmla, ResourceType::String, NN_dml_shapeGeometry|DEFINE_ST_GeomGuideFormula },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_shapeGeometry|DEFINE_CT_XYAdjustHandle:
        {
            const static AttributeInfo info[] = {
                { oox::XML_gdRefX, ResourceType::String, NN_dml_shapeGeometry|DEFINE_ST_GeomGuideName },
                { oox::XML_gdRefY, ResourceType::String, NN_dml_shapeGeometry|DEFINE_ST_GeomGuideName },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_shapeGeometry|DEFINE_CT_PolarAdjustHandle:
        {
            const static AttributeInfo info[] = {
                { oox::XML_gdRefR, ResourceType::String, NN_dml_shapeGeometry|DEFINE_ST_GeomGuideName },
                { oox::XML_gdRefAng, ResourceType::String, NN_dml_shapeGeometry|DEFINE_ST_GeomGuideName },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_shapeGeometry|DEFINE_CT_Connection:
        {
            const static AttributeInfo info[] = {
                { oox::XML_idx, ResourceType::Integer, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_shapeGeometry|DEFINE_CT_Path2D:
        {
            const static AttributeInfo info[] = {
                { oox::XML_fill, ResourceType::List, NN_dml_shapeGeometry|DEFINE_ST_PathFillMode },
                { oox::XML_stroke, ResourceType::Boolean, 0 },
                { oox::XML_extrusionOk, ResourceType::Boolean, 0 },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_shapeGeometry|DEFINE_CT_PresetGeometry2D:
        {
            const static AttributeInfo info[] = {
                { oox::XML_prst, ResourceType::List, NN_dml_shapeGeometry|DEFINE_ST_ShapeType },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_dml_shapeGeometry|DEFINE_CT_PresetTextShape:
        {
            const static AttributeInfo info[] = {
                { oox::XML_prst, ResourceType::List, NN_dml_shapeGeometry|DEFINE_ST_TextShapeType },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    default:
        break;
    }

    return NULL;
}

bool OOXMLFactory_dml_shapeGeometry::getListValue(Id nId, std::string_view aValue, sal_uInt32& rOutValue)
{
    (void) aValue;
    (void) rOutValue;

    switch (nId)
    {
    case NN_dml_shapeGeometry|DEFINE_ST_ShapeType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'a':
            if (aValue == "arc") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_arc; }
            else if (aValue == "accentCallout1") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_accentCallout1; }
            else if (aValue == "accentCallout2") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_accentCallout2; }
            else if (aValue == "accentCallout3") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_accentCallout3; }
            else if (aValue == "accentBorderCallout1") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_accentBorderCallout1; }
            else if (aValue == "accentBorderCallout2") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_accentBorderCallout2; }
            else if (aValue == "accentBorderCallout3") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_accentBorderCallout3; }
            else if (aValue == "actionButtonBlank") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonBlank; }
            else if (aValue == "actionButtonHome") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonHome; }
            else if (aValue == "actionButtonHelp") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonHelp; }
            else if (aValue == "actionButtonInformation") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonInformation; }
            else if (aValue == "actionButtonForwardNext") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonForwardNext; }
            else if (aValue == "actionButtonBackPrevious") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonBackPrevious; }
            else if (aValue == "actionButtonEnd") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonEnd; }
            else if (aValue == "actionButtonBeginning") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonBeginning; }
            else if (aValue == "actionButtonReturn") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonReturn; }
            else if (aValue == "actionButtonDocument") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonDocument; }
            else if (aValue == "actionButtonSound") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonSound; }
            else if (aValue == "actionButtonMovie") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_actionButtonMovie; }
            else { return false; }
            return true;
        case 'b':
            if (aValue == "blockArc") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_blockArc; }
            else if (aValue == "bentUpArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_bentUpArrow; }
            else if (aValue == "bentArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_bentArrow; }
            else if (aValue == "bevel") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_bevel; }
            else if (aValue == "bracketPair") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_bracketPair; }
            else if (aValue == "bracePair") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_bracePair; }
            else if (aValue == "bentConnector2") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_bentConnector2; }
            else if (aValue == "bentConnector3") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_bentConnector3; }
            else if (aValue == "bentConnector4") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_bentConnector4; }
            else if (aValue == "bentConnector5") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_bentConnector5; }
            else if (aValue == "borderCallout1") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_borderCallout1; }
            else if (aValue == "borderCallout2") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_borderCallout2; }
            else if (aValue == "borderCallout3") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_borderCallout3; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "chevron") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_chevron; }
            else if (aValue == "circularArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_circularArrow; }
            else if (aValue == "curvedRightArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_curvedRightArrow; }
            else if (aValue == "curvedLeftArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_curvedLeftArrow; }
            else if (aValue == "curvedUpArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_curvedUpArrow; }
            else if (aValue == "curvedDownArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_curvedDownArrow; }
            else if (aValue == "cube") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_cube; }
            else if (aValue == "can") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_can; }
            else if (aValue == "corner") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_corner; }
            else if (aValue == "chord") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_chord; }
            else if (aValue == "curvedConnector2") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_curvedConnector2; }
            else if (aValue == "curvedConnector3") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_curvedConnector3; }
            else if (aValue == "curvedConnector4") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_curvedConnector4; }
            else if (aValue == "curvedConnector5") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_curvedConnector5; }
            else if (aValue == "callout1") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_callout1; }
            else if (aValue == "callout2") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_callout2; }
            else if (aValue == "callout3") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_callout3; }
            else if (aValue == "cloudCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_cloudCallout; }
            else if (aValue == "cloud") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_cloud; }
            else if (aValue == "cornerTabs") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_cornerTabs; }
            else if (aValue == "chartX") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_chartX; }
            else if (aValue == "chartStar") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_chartStar; }
            else if (aValue == "chartPlus") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_chartPlus; }
            else { return false; }
            return true;
        case 'd':
            if (aValue == "diamond") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_diamond; }
            else if (aValue == "decagon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_decagon; }
            else if (aValue == "dodecagon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_dodecagon; }
            else if (aValue == "donut") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_donut; }
            else if (aValue == "downArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_downArrow; }
            else if (aValue == "downArrowCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_downArrowCallout; }
            else if (aValue == "diagStripe") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_diagStripe; }
            else if (aValue == "doubleWave") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_doubleWave; }
            else { return false; }
            return true;
        case 'e':
            if (aValue == "ellipse") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_ellipse; }
            else if (aValue == "ellipseRibbon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_ellipseRibbon; }
            else if (aValue == "ellipseRibbon2") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_ellipseRibbon2; }
            else { return false; }
            return true;
        case 'f':
            if (aValue == "foldedCorner") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_foldedCorner; }
            else if (aValue == "frame") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_frame; }
            else if (aValue == "flowChartProcess") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartProcess; }
            else if (aValue == "flowChartDecision") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartDecision; }
            else if (aValue == "flowChartInputOutput") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartInputOutput; }
            else if (aValue == "flowChartPredefinedProcess") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartPredefinedProcess; }
            else if (aValue == "flowChartInternalStorage") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartInternalStorage; }
            else if (aValue == "flowChartDocument") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartDocument; }
            else if (aValue == "flowChartMultidocument") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartMultidocument; }
            else if (aValue == "flowChartTerminator") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartTerminator; }
            else if (aValue == "flowChartPreparation") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartPreparation; }
            else if (aValue == "flowChartManualInput") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartManualInput; }
            else if (aValue == "flowChartManualOperation") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartManualOperation; }
            else if (aValue == "flowChartConnector") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartConnector; }
            else if (aValue == "flowChartPunchedCard") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartPunchedCard; }
            else if (aValue == "flowChartPunchedTape") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartPunchedTape; }
            else if (aValue == "flowChartSummingJunction") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartSummingJunction; }
            else if (aValue == "flowChartOr") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartOr; }
            else if (aValue == "flowChartCollate") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartCollate; }
            else if (aValue == "flowChartSort") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartSort; }
            else if (aValue == "flowChartExtract") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartExtract; }
            else if (aValue == "flowChartMerge") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartMerge; }
            else if (aValue == "flowChartOfflineStorage") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartOfflineStorage; }
            else if (aValue == "flowChartOnlineStorage") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartOnlineStorage; }
            else if (aValue == "flowChartMagneticTape") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartMagneticTape; }
            else if (aValue == "flowChartMagneticDisk") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartMagneticDisk; }
            else if (aValue == "flowChartMagneticDrum") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartMagneticDrum; }
            else if (aValue == "flowChartDisplay") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartDisplay; }
            else if (aValue == "flowChartDelay") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartDelay; }
            else if (aValue == "flowChartAlternateProcess") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartAlternateProcess; }
            else if (aValue == "flowChartOffpageConnector") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_flowChartOffpageConnector; }
            else if (aValue == "funnel") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_funnel; }
            else { return false; }
            return true;
        case 'g':
            if (aValue == "gear6") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_gear6; }
            else if (aValue == "gear9") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_gear9; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "hexagon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_hexagon; }
            else if (aValue == "heptagon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_heptagon; }
            else if (aValue == "homePlate") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_homePlate; }
            else if (aValue == "heart") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_heart; }
            else if (aValue == "halfFrame") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_halfFrame; }
            else if (aValue == "horizontalScroll") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_horizontalScroll; }
            else { return false; }
            return true;
        case 'i':
            if (aValue == "irregularSeal1") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_irregularSeal1; }
            else if (aValue == "irregularSeal2") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_irregularSeal2; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "line") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_line; }
            else if (aValue == "lineInv") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_lineInv; }
            else if (aValue == "leftArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftArrow; }
            else if (aValue == "leftRightArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftRightArrow; }
            else if (aValue == "leftUpArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftUpArrow; }
            else if (aValue == "leftRightUpArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftRightUpArrow; }
            else if (aValue == "leftArrowCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftArrowCallout; }
            else if (aValue == "leftRightArrowCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftRightArrowCallout; }
            else if (aValue == "leftCircularArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftCircularArrow; }
            else if (aValue == "leftRightCircularArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftRightCircularArrow; }
            else if (aValue == "lightningBolt") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_lightningBolt; }
            else if (aValue == "leftBracket") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftBracket; }
            else if (aValue == "leftBrace") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftBrace; }
            else if (aValue == "leftRightRibbon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_leftRightRibbon; }
            else { return false; }
            return true;
        case 'm':
            if (aValue == "moon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_moon; }
            else if (aValue == "mathPlus") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_mathPlus; }
            else if (aValue == "mathMinus") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_mathMinus; }
            else if (aValue == "mathMultiply") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_mathMultiply; }
            else if (aValue == "mathDivide") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_mathDivide; }
            else if (aValue == "mathEqual") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_mathEqual; }
            else if (aValue == "mathNotEqual") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_mathNotEqual; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "nonIsoscelesTrapezoid") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_nonIsoscelesTrapezoid; }
            else if (aValue == "noSmoking") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_noSmoking; }
            else if (aValue == "notchedRightArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_notchedRightArrow; }
            else { return false; }
            return true;
        case 'o':
            if (aValue == "octagon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_octagon; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "parallelogram") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_parallelogram; }
            else if (aValue == "pentagon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_pentagon; }
            else if (aValue == "plaque") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_plaque; }
            else if (aValue == "pieWedge") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_pieWedge; }
            else if (aValue == "pie") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_pie; }
            else if (aValue == "plus") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_plus; }
            else if (aValue == "plaqueTabs") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_plaqueTabs; }
            else { return false; }
            return true;
        case 'q':
            if (aValue == "quadArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_quadArrow; }
            else if (aValue == "quadArrowCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_quadArrowCallout; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "rtTriangle") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_rtTriangle; }
            else if (aValue == "rect") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_rect; }
            else if (aValue == "roundRect") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_roundRect; }
            else if (aValue == "round1Rect") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_round1Rect; }
            else if (aValue == "round2SameRect") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_round2SameRect; }
            else if (aValue == "round2DiagRect") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_round2DiagRect; }
            else if (aValue == "rightArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_rightArrow; }
            else if (aValue == "rightArrowCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_rightArrowCallout; }
            else if (aValue == "rightBracket") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_rightBracket; }
            else if (aValue == "rightBrace") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_rightBrace; }
            else if (aValue == "ribbon") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_ribbon; }
            else if (aValue == "ribbon2") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_ribbon2; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "star4") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star4; }
            else if (aValue == "star5") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star5; }
            else if (aValue == "star6") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star6; }
            else if (aValue == "star7") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star7; }
            else if (aValue == "star8") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star8; }
            else if (aValue == "star10") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star10; }
            else if (aValue == "star12") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star12; }
            else if (aValue == "star16") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star16; }
            else if (aValue == "star24") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star24; }
            else if (aValue == "star32") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_star32; }
            else if (aValue == "snipRoundRect") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_snipRoundRect; }
            else if (aValue == "snip1Rect") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_snip1Rect; }
            else if (aValue == "snip2SameRect") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_snip2SameRect; }
            else if (aValue == "snip2DiagRect") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_snip2DiagRect; }
            else if (aValue == "stripedRightArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_stripedRightArrow; }
            else if (aValue == "swooshArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_swooshArrow; }
            else if (aValue == "sun") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_sun; }
            else if (aValue == "smileyFace") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_smileyFace; }
            else if (aValue == "straightConnector1") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_straightConnector1; }
            else if (aValue == "squareTabs") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_squareTabs; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "triangle") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_triangle; }
            else if (aValue == "trapezoid") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_trapezoid; }
            else if (aValue == "teardrop") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_teardrop; }
            else { return false; }
            return true;
        case 'u':
            if (aValue == "upArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_upArrow; }
            else if (aValue == "upDownArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_upDownArrow; }
            else if (aValue == "upArrowCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_upArrowCallout; }
            else if (aValue == "upDownArrowCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_upDownArrowCallout; }
            else if (aValue == "uturnArrow") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_uturnArrow; }
            else { return false; }
            return true;
        case 'v':
            if (aValue == "verticalScroll") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_verticalScroll; }
            else { return false; }
            return true;
        case 'w':
            if (aValue == "wedgeRectCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_wedgeRectCallout; }
            else if (aValue == "wedgeRoundRectCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_wedgeRoundRectCallout; }
            else if (aValue == "wedgeEllipseCallout") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_wedgeEllipseCallout; }
            else if (aValue == "wave") { rOutValue = NS_ooxml::LN_Value_ST_ShapeType_wave; }
            else { return false; }
            return true;
        }
        return false;
    case NN_dml_shapeGeometry|DEFINE_ST_TextShapeType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 't':
            if (aValue == "textNoShape") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textNoShape; }
            else if (aValue == "textPlain") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textPlain; }
            else if (aValue == "textStop") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textStop; }
            else if (aValue == "textTriangle") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textTriangle; }
            else if (aValue == "textTriangleInverted") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textTriangleInverted; }
            else if (aValue == "textChevron") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textChevron; }
            else if (aValue == "textChevronInverted") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textChevronInverted; }
            else if (aValue == "textRingInside") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textRingInside; }
            else if (aValue == "textRingOutside") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textRingOutside; }
            else if (aValue == "textArchUp") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textArchUp; }
            else if (aValue == "textArchDown") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textArchDown; }
            else if (aValue == "textCircle") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCircle; }
            else if (aValue == "textButton") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textButton; }
            else if (aValue == "textArchUpPour") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textArchUpPour; }
            else if (aValue == "textArchDownPour") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textArchDownPour; }
            else if (aValue == "textCirclePour") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCirclePour; }
            else if (aValue == "textButtonPour") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textButtonPour; }
            else if (aValue == "textCurveUp") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCurveUp; }
            else if (aValue == "textCurveDown") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCurveDown; }
            else if (aValue == "textCanUp") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCanUp; }
            else if (aValue == "textCanDown") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCanDown; }
            else if (aValue == "textWave1") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textWave1; }
            else if (aValue == "textWave2") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textWave2; }
            else if (aValue == "textDoubleWave1") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDoubleWave1; }
            else if (aValue == "textWave4") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textWave4; }
            else if (aValue == "textInflate") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textInflate; }
            else if (aValue == "textDeflate") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflate; }
            else if (aValue == "textInflateBottom") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textInflateBottom; }
            else if (aValue == "textDeflateBottom") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflateBottom; }
            else if (aValue == "textInflateTop") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textInflateTop; }
            else if (aValue == "textDeflateTop") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflateTop; }
            else if (aValue == "textDeflateInflate") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflateInflate; }
            else if (aValue == "textDeflateInflateDeflate") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflateInflateDeflate; }
            else if (aValue == "textFadeRight") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textFadeRight; }
            else if (aValue == "textFadeLeft") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textFadeLeft; }
            else if (aValue == "textFadeUp") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textFadeUp; }
            else if (aValue == "textFadeDown") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textFadeDown; }
            else if (aValue == "textSlantUp") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textSlantUp; }
            else if (aValue == "textSlantDown") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textSlantDown; }
            else if (aValue == "textCascadeUp") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCascadeUp; }
            else if (aValue == "textCascadeDown") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCascadeDown; }
            else { return false; }
            return true;
        }
        return false;
    case NN_dml_shapeGeometry|DEFINE_ST_PathFillMode:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'd':
            if (aValue == "darken") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_PathFillMode_darken; }
            else if (aValue == "darkenLess") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_PathFillMode_darkenLess; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "lighten") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_PathFillMode_lighten; }
            else if (aValue == "lightenLess") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_PathFillMode_lightenLess; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "none") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_PathFillMode_none; }
            else if (aValue == "norm") { rOutValue = NS_ooxml::LN_Value_drawingml_ST_PathFillMode_norm; }
            else { return false; }
            return true;
        }
        return false;
    default:
        break;
    }

    return false;
}

bool OOXMLFactory_dml_shapeGeometry::getElementId(Id nDefine, Id nId, ResourceType& rOutResource, Id& rOutElement)
{
    (void) rOutResource;
    (void) rOutElement;

    switch (nDefine)
    {
    case NN_dml_shapeGeometry|DEFINE_CT_PresetGeometry2D:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_avLst: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeGeometry|DEFINE_CT_GeomGuideList; break;
        default: return false;
        }
        return true;
    case NN_dml_shapeGeometry|DEFINE_CT_PresetTextShape:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_avLst: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeGeometry|DEFINE_CT_GeomGuideList; break;
        default: return false;
        }
        return true;
    case NN_dml_shapeGeometry|DEFINE_CT_CustomGeometry2D:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_avLst: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeGeometry|DEFINE_CT_GeomGuideList; break;
        case oox::NMSP_dml|oox::XML_gdLst: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeGeometry|DEFINE_CT_GeomGuideList; break;
        default: return false;
        }
        return true;
    case NN_dml_shapeGeometry|DEFINE_EG_Geometry:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_custGeom: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeGeometry|DEFINE_CT_CustomGeometry2D; break;
        case oox::NMSP_dml|oox::XML_prstGeom: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeGeometry|DEFINE_CT_PresetGeometry2D; break;
        default: return false;
        }
        return true;
    case NN_dml_shapeGeometry|DEFINE_EG_TextGeometry:
        switch (nId)
        {
        case oox::NMSP_dml|oox::XML_custGeom: rOutResource = ResourceType::Properties; rOutElement = NN_dml_shapeGeometry|DEFINE_CT_CustomGeometry2D; break;
        default: return false;
        }
        return true;
    default:
        switch (nId)
        {
        default: return false;
        }
        return true;
    }
}

void OOXMLFactory_dml_shapeGeometry::charactersAction(OOXMLFastContextHandler*, const OUString&)
{
}

Id OOXMLFactory_dml_shapeGeometry::getResourceId(Id nDefine, sal_Int32 nToken)
{
    (void) nDefine;
    (void) nToken;

    switch (nDefine)
    {
    case NN_dml_shapeGeometry|DEFINE_CT_GeomGuideList:
        switch (nToken)
        {
        case oox::NMSP_dml|oox::XML_gd: return NS_ooxml::LN_CT_GeomGuideList_gd;
        }
        break;
    case NN_dml_shapeGeometry|DEFINE_CT_PresetGeometry2D:
        switch (nToken)
        {
        case oox::NMSP_dml|oox::XML_avLst: return NS_ooxml::LN_CT_PresetGeometry2D_avLst;
        case oox::XML_prst: return NS_ooxml::LN_CT_PresetGeometry2D_prst;
        }
        break;
    case NN_dml_shapeGeometry|DEFINE_CT_CustomGeometry2D:
        switch (nToken)
        {
        case oox::NMSP_dml|oox::XML_ahLst: return NS_ooxml::LN_CT_CustomGeometry2D_ahLst;
        case oox::NMSP_dml|oox::XML_avLst: return NS_ooxml::LN_CT_CustomGeometry2D_avLst;
        case oox::NMSP_dml|oox::XML_cxnLst: return NS_ooxml::LN_CT_CustomGeometry2D_cxnLst;
        case oox::NMSP_dml|oox::XML_gdLst: return NS_ooxml::LN_CT_CustomGeometry2D_gdLst;
        case oox::NMSP_dml|oox::XML_pathLst: return NS_ooxml::LN_CT_CustomGeometry2D_pathLst;
        case oox::NMSP_dml|oox::XML_rect: return NS_ooxml::LN_CT_CustomGeometry2D_rect;
        }
        break;
    case NN_dml_shapeGeometry|DEFINE_EG_Geometry:
        switch (nToken)
        {
        case oox::NMSP_dml|oox::XML_custGeom: return NS_ooxml::LN_EG_Geometry_custGeom;
        case oox::NMSP_dml|oox::XML_prstGeom: return NS_ooxml::LN_EG_Geometry_prstGeom;
        }
        break;
    default:
        switch (nToken)
        {
        }
        break;
    }
    return 0;
}

void OOXMLFactory_dml_shapeGeometry::attributeAction(OOXMLFastContextHandler*, Token_t, const OOXMLValue&)
{
}

/// @endcond
}}
