/* collection-source.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from collection-source.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include "common.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BOXES_COLLECTION_SOURCE_0_PROPERTY,
	BOXES_COLLECTION_SOURCE_NAME_PROPERTY,
	BOXES_COLLECTION_SOURCE_SOURCE_TYPE_PROPERTY,
	BOXES_COLLECTION_SOURCE_URI_PROPERTY,
	BOXES_COLLECTION_SOURCE_ENABLED_PROPERTY,
	BOXES_COLLECTION_SOURCE_NUM_PROPERTIES
};
static GParamSpec* boxes_collection_source_properties[BOXES_COLLECTION_SOURCE_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BoxesCollectionSourcePrivate {
	GKeyFile* _keyfile;
	gboolean _has_file;
	gchar* _filename;
};

static gint BoxesCollectionSource_private_offset;
static gpointer boxes_collection_source_parent_class = NULL;
static BoxesIConfigIface * boxes_collection_source_boxes_iconfig_parent_iface = NULL;

static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GType boxes_iconfig_get_type_once (void);
static GObject * boxes_collection_source_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void boxes_collection_source_finalize (GObject * obj);
static GType boxes_collection_source_get_type_once (void);
static void _vala_boxes_collection_source_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_boxes_collection_source_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
boxes_iconfig_save (BoxesIConfig* self)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	_tmp0_ = boxes_iconfig_get_keyfile (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = boxes_iconfig_get_filename (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = boxes_get_user_pkgconfig_source (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = boxes_iconfig_get_has_file (self);
	_tmp7_ = _tmp6_;
	boxes_keyfile_save (_tmp1_, _tmp5_, _tmp7_);
	_g_free0 (_tmp5_);
	boxes_iconfig_set_has_file (self, TRUE);
}

gboolean
boxes_iconfig_get_boolean (BoxesIConfig* self,
                           const gchar* group,
                           const gchar* key,
                           gboolean default_value)
{
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		GKeyFile* _tmp2_;
		_tmp1_ = boxes_iconfig_get_keyfile (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = g_key_file_get_boolean (_tmp2_, group, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
		result = default_value;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp4_;
}

void
boxes_iconfig_set_boolean (BoxesIConfig* self,
                           const gchar* group,
                           const gchar* key,
                           gboolean value)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = boxes_iconfig_get_keyfile (self);
	_tmp1_ = _tmp0_;
	g_key_file_set_boolean (_tmp1_, group, key, value);
}

void
boxes_iconfig_load (BoxesIConfig* self,
                    GError** error)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GKeyFile* _tmp3_;
	GKeyFile* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = boxes_iconfig_get_has_file (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (BOXES_ERROR, BOXES_ERROR_INVALID, "has_file is false");
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = boxes_iconfig_get_keyfile (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = boxes_iconfig_get_filename (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = boxes_get_user_pkgconfig_source (_tmp6_);
	_tmp8_ = _tmp7_;
	g_key_file_load_from_file (_tmp4_, _tmp8_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
	_g_free0 (_tmp8_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

gchar*
boxes_iconfig_get_string (BoxesIConfig* self,
                          const gchar* group,
                          const gchar* key)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		GKeyFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = boxes_iconfig_get_keyfile (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_key_file_get_string (_tmp2_, group, key, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp4_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar**
boxes_iconfig_get_string_list (BoxesIConfig* self,
                               const gchar* group,
                               const gchar* key,
                               gint* result_length1)
{
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar** _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		GKeyFile* _tmp2_;
		gsize _tmp3_ = 0;
		gchar** _tmp4_;
		gint _tmp0__length1;
		gint __tmp0__size_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp1_ = boxes_iconfig_get_keyfile (self);
		_tmp2_ = _tmp1_;
		_tmp4_ = g_key_file_get_string_list (_tmp2_, group, key, &_tmp3_, &_inner_error0_);
		_tmp0_ = _tmp4_;
		_tmp0__length1 = _tmp3_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp5__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp5__length1;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		gchar** _tmp7_;
		gint _tmp7__length1;
		g_clear_error (&_inner_error0_);
		_tmp7_ = NULL;
		_tmp7__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp7__length1;
		}
		result = _tmp7_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
boxes_iconfig_get_groups (BoxesIConfig* self,
                          const gchar* with_prefix,
                          gint* result_length1)
{
	gchar** groups = NULL;
	gchar** _tmp0_;
	gint groups_length1;
	gint _groups_size_;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp2_;
	gsize _tmp3_ = 0;
	gchar** _tmp4_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** result;
	g_return_val_if_fail (with_prefix != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	groups = _tmp0_;
	groups_length1 = 0;
	_groups_size_ = groups_length1;
	_tmp1_ = boxes_iconfig_get_keyfile (self);
	_tmp2_ = _tmp1_;
	_tmp4_ = g_key_file_get_groups (_tmp2_, &_tmp3_);
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp4_;
		group_collection_length1 = _tmp3_;
		for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
			gchar* _tmp5_;
			gchar* group = NULL;
			_tmp5_ = g_strdup (group_collection[group_it]);
			group = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = group;
				if (!g_str_has_prefix (_tmp6_, with_prefix)) {
					_g_free0 (group);
					continue;
				}
				_tmp7_ = group;
				_tmp8_ = g_strdup (_tmp7_);
				_vala_array_add1 (&groups, &groups_length1, &_groups_size_, _tmp8_);
				_g_free0 (group);
			}
		}
		group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp9_ = groups;
	_tmp9__length1 = groups_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

GKeyFile*
boxes_iconfig_get_keyfile (BoxesIConfig* self)
{
	BoxesIConfigIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BOXES_ICONFIG_GET_INTERFACE (self);
	if (_iface_->get_keyfile) {
		return _iface_->get_keyfile (self);
	}
	return NULL;
}

const gchar*
boxes_iconfig_get_filename (BoxesIConfig* self)
{
	BoxesIConfigIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BOXES_ICONFIG_GET_INTERFACE (self);
	if (_iface_->get_filename) {
		return _iface_->get_filename (self);
	}
	return NULL;
}

void
boxes_iconfig_set_filename (BoxesIConfig* self,
                            const gchar* value)
{
	BoxesIConfigIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BOXES_ICONFIG_GET_INTERFACE (self);
	if (_iface_->set_filename) {
		_iface_->set_filename (self, value);
	}
}

gboolean
boxes_iconfig_get_has_file (BoxesIConfig* self)
{
	BoxesIConfigIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BOXES_ICONFIG_GET_INTERFACE (self);
	if (_iface_->get_has_file) {
		return _iface_->get_has_file (self);
	}
	return FALSE;
}

void
boxes_iconfig_set_has_file (BoxesIConfig* self,
                            gboolean value)
{
	BoxesIConfigIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BOXES_ICONFIG_GET_INTERFACE (self);
	if (_iface_->set_has_file) {
		_iface_->set_has_file (self, value);
	}
}

static void
boxes_iconfig_default_init (BoxesIConfigIface * iface,
                            gpointer iface_data)
{
}

static GType
boxes_iconfig_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesIConfigIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_iconfig_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType boxes_iconfig_type_id;
	boxes_iconfig_type_id = g_type_register_static (G_TYPE_INTERFACE, "BoxesIConfig", &g_define_type_info, 0);
	return boxes_iconfig_type_id;
}

GType
boxes_iconfig_get_type (void)
{
	static volatile gsize boxes_iconfig_type_id__once = 0;
	if (g_once_init_enter (&boxes_iconfig_type_id__once)) {
		GType boxes_iconfig_type_id;
		boxes_iconfig_type_id = boxes_iconfig_get_type_once ();
		g_once_init_leave (&boxes_iconfig_type_id__once, boxes_iconfig_type_id);
	}
	return boxes_iconfig_type_id__once;
}

static inline gpointer
boxes_collection_source_get_instance_private (BoxesCollectionSource* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesCollectionSource_private_offset);
}

BoxesCollectionSource*
boxes_collection_source_construct (GType object_type,
                                   const gchar* name,
                                   const gchar* source_type,
                                   const gchar* uri)
{
	BoxesCollectionSource * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (source_type != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (BoxesCollectionSource*) g_object_new (object_type, NULL);
	boxes_collection_source_set_name (self, name);
	boxes_collection_source_set_source_type (self, source_type);
	boxes_collection_source_set_uri (self, uri);
	return self;
}

BoxesCollectionSource*
boxes_collection_source_new (const gchar* name,
                             const gchar* source_type,
                             const gchar* uri)
{
	return boxes_collection_source_construct (BOXES_TYPE_COLLECTION_SOURCE, name, source_type, uri);
}

BoxesCollectionSource*
boxes_collection_source_construct_with_file (GType object_type,
                                             const gchar* filename,
                                             GError** error)
{
	BoxesCollectionSource * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (BoxesCollectionSource*) g_object_new (object_type, NULL);
	boxes_iconfig_set_filename ((BoxesIConfig*) self, filename);
	boxes_iconfig_set_has_file ((BoxesIConfig*) self, TRUE);
	boxes_iconfig_load ((BoxesIConfig*) self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

BoxesCollectionSource*
boxes_collection_source_new_with_file (const gchar* filename,
                                       GError** error)
{
	return boxes_collection_source_construct_with_file (BOXES_TYPE_COLLECTION_SOURCE, filename, error);
}

void
boxes_collection_source_delete (BoxesCollectionSource* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_iconfig_get_has_file ((BoxesIConfig*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = boxes_iconfig_get_filename ((BoxesIConfig*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = boxes_get_user_pkgconfig_source (_tmp3_);
	_tmp5_ = _tmp4_;
	g_unlink (_tmp5_);
	_g_free0 (_tmp5_);
	boxes_iconfig_set_has_file ((BoxesIConfig*) self, FALSE);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
boxes_collection_source_purge_stale_box_configs (BoxesCollectionSource* self,
                                                 GList* used_configs)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	gsize _tmp2_ = 0;
	gchar** _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_iconfig_get_keyfile ((BoxesIConfig*) self);
	_tmp1_ = _tmp0_;
	_tmp3_ = g_key_file_get_groups (_tmp1_, &_tmp2_);
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp3_;
		group_collection_length1 = _tmp2_;
		for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
			gchar* _tmp4_;
			gchar* group = NULL;
			_tmp4_ = g_strdup (group_collection[group_it]);
			group = _tmp4_;
			{
				const gchar* _tmp5_;
				gboolean stale = FALSE;
				_tmp5_ = group;
				if (g_strcmp0 (_tmp5_, "source") == 0) {
					_g_free0 (group);
					continue;
				}
				stale = TRUE;
				{
					GList* config_collection = NULL;
					GList* config_it = NULL;
					config_collection = used_configs;
					for (config_it = config_collection; config_it != NULL; config_it = config_it->next) {
						BoxesBoxConfig* _tmp6_;
						BoxesBoxConfig* config = NULL;
						_tmp6_ = _g_object_ref0 ((BoxesBoxConfig*) config_it->data);
						config = _tmp6_;
						{
							BoxesBoxConfig* _tmp7_;
							const gchar* _tmp8_;
							const gchar* _tmp9_;
							const gchar* _tmp10_;
							_tmp7_ = config;
							_tmp8_ = boxes_box_config_get_group (_tmp7_);
							_tmp9_ = _tmp8_;
							_tmp10_ = group;
							if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
								stale = FALSE;
								_g_object_unref0 (config);
								break;
							}
							_g_object_unref0 (config);
						}
					}
				}
				if (stale) {
					{
						GKeyFile* _tmp11_;
						GKeyFile* _tmp12_;
						const gchar* _tmp13_;
						const gchar* _tmp14_;
						_tmp11_ = boxes_iconfig_get_keyfile ((BoxesIConfig*) self);
						_tmp12_ = _tmp11_;
						_tmp13_ = group;
						g_key_file_remove_group (_tmp12_, _tmp13_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp14_ = group;
						g_debug ("collection-source.vala:147: Removed stale box config '%s'", _tmp14_);
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp15_;
						GError* _tmp16_;
						const gchar* _tmp17_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp15_ = group;
						_tmp16_ = e;
						_tmp17_ = _tmp16_->message;
						g_debug ("collection-source.vala:149: Error removing stale stale box config '%s'" \
": %s", _tmp15_, _tmp17_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (group);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_g_free0 (group);
			}
		}
		group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	boxes_iconfig_save ((BoxesIConfig*) self);
}

static GKeyFile*
boxes_collection_source_real_get_keyfile (BoxesIConfig* base)
{
	GKeyFile* result;
	BoxesCollectionSource* self;
	GKeyFile* _tmp0_;
	self = (BoxesCollectionSource*) base;
	_tmp0_ = self->priv->_keyfile;
	result = _tmp0_;
	return result;
}

static gboolean
boxes_collection_source_real_get_has_file (BoxesIConfig* base)
{
	gboolean result;
	BoxesCollectionSource* self;
	self = (BoxesCollectionSource*) base;
	result = self->priv->_has_file;
	return result;
}

static void
boxes_collection_source_real_set_has_file (BoxesIConfig* base,
                                           gboolean value)
{
	BoxesCollectionSource* self;
	self = (BoxesCollectionSource*) base;
	self->priv->_has_file = value;
}

static const gchar*
boxes_collection_source_real_get_filename (BoxesIConfig* base)
{
	const gchar* result;
	BoxesCollectionSource* self;
	const gchar* _tmp0_;
	const gchar* _tmp5_;
	self = (BoxesCollectionSource*) base;
	_tmp0_ = self->priv->_filename;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = boxes_collection_source_get_name (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = boxes_make_filename (_tmp3_);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp4_;
		_g_free0 (_tmp3_);
	}
	_tmp5_ = self->priv->_filename;
	result = _tmp5_;
	return result;
}

static void
boxes_collection_source_real_set_filename (BoxesIConfig* base,
                                           const gchar* value)
{
	BoxesCollectionSource* self;
	gchar* _tmp0_;
	self = (BoxesCollectionSource*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
}

gchar*
boxes_collection_source_get_name (BoxesCollectionSource* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = boxes_iconfig_get_string ((BoxesIConfig*) self, "source", "name");
	result = _tmp0_;
	return result;
}

void
boxes_collection_source_set_name (BoxesCollectionSource* self,
                                  const gchar* value)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	gboolean had_file = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_iconfig_get_keyfile ((BoxesIConfig*) self);
	_tmp1_ = _tmp0_;
	g_key_file_set_string (_tmp1_, "source", "name", value);
	_tmp2_ = boxes_iconfig_get_has_file ((BoxesIConfig*) self);
	_tmp3_ = _tmp2_;
	had_file = _tmp3_;
	boxes_collection_source_delete (self);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = NULL;
	if (had_file) {
		boxes_iconfig_save ((BoxesIConfig*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, boxes_collection_source_properties[BOXES_COLLECTION_SOURCE_NAME_PROPERTY]);
}

gchar*
boxes_collection_source_get_source_type (BoxesCollectionSource* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = boxes_iconfig_get_string ((BoxesIConfig*) self, "source", "type");
	result = _tmp0_;
	return result;
}

void
boxes_collection_source_set_source_type (BoxesCollectionSource* self,
                                         const gchar* value)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_iconfig_get_keyfile ((BoxesIConfig*) self);
	_tmp1_ = _tmp0_;
	g_key_file_set_string (_tmp1_, "source", "type", value);
	g_object_notify_by_pspec ((GObject *) self, boxes_collection_source_properties[BOXES_COLLECTION_SOURCE_SOURCE_TYPE_PROPERTY]);
}

gchar*
boxes_collection_source_get_uri (BoxesCollectionSource* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = boxes_iconfig_get_string ((BoxesIConfig*) self, "source", "uri");
	result = _tmp0_;
	return result;
}

void
boxes_collection_source_set_uri (BoxesCollectionSource* self,
                                 const gchar* value)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_iconfig_get_keyfile ((BoxesIConfig*) self);
	_tmp1_ = _tmp0_;
	g_key_file_set_string (_tmp1_, "source", "uri", value);
	g_object_notify_by_pspec ((GObject *) self, boxes_collection_source_properties[BOXES_COLLECTION_SOURCE_URI_PROPERTY]);
}

gboolean
boxes_collection_source_get_enabled (BoxesCollectionSource* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = boxes_iconfig_get_boolean ((BoxesIConfig*) self, "source", "enabled", TRUE);
	return result;
}

void
boxes_collection_source_set_enabled (BoxesCollectionSource* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	boxes_iconfig_set_boolean ((BoxesIConfig*) self, "source", "enabled", value);
	g_object_notify_by_pspec ((GObject *) self, boxes_collection_source_properties[BOXES_COLLECTION_SOURCE_ENABLED_PROPERTY]);
}

static GObject *
boxes_collection_source_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesCollectionSource * self;
	GKeyFile* _tmp0_;
	parent_class = G_OBJECT_CLASS (boxes_collection_source_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_COLLECTION_SOURCE, BoxesCollectionSource);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->_keyfile);
	self->priv->_keyfile = _tmp0_;
	return obj;
}

static void
boxes_collection_source_class_init (BoxesCollectionSourceClass * klass,
                                    gpointer klass_data)
{
	boxes_collection_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesCollectionSource_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_collection_source_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_collection_source_set_property;
	G_OBJECT_CLASS (klass)->constructor = boxes_collection_source_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_collection_source_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_COLLECTION_SOURCE_NAME_PROPERTY, boxes_collection_source_properties[BOXES_COLLECTION_SOURCE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_COLLECTION_SOURCE_SOURCE_TYPE_PROPERTY, boxes_collection_source_properties[BOXES_COLLECTION_SOURCE_SOURCE_TYPE_PROPERTY] = g_param_spec_string ("source-type", "source-type", "source-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_COLLECTION_SOURCE_URI_PROPERTY, boxes_collection_source_properties[BOXES_COLLECTION_SOURCE_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_COLLECTION_SOURCE_ENABLED_PROPERTY, boxes_collection_source_properties[BOXES_COLLECTION_SOURCE_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
boxes_collection_source_boxes_iconfig_interface_init (BoxesIConfigIface * iface,
                                                      gpointer iface_data)
{
	boxes_collection_source_boxes_iconfig_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_keyfile = boxes_collection_source_real_get_keyfile;
	iface->get_has_file = boxes_collection_source_real_get_has_file;
	iface->set_has_file = boxes_collection_source_real_set_has_file;
	iface->get_filename = boxes_collection_source_real_get_filename;
	iface->set_filename = boxes_collection_source_real_set_filename;
}

static void
boxes_collection_source_instance_init (BoxesCollectionSource * self,
                                       gpointer klass)
{
	self->priv = boxes_collection_source_get_instance_private (self);
}

static void
boxes_collection_source_finalize (GObject * obj)
{
	BoxesCollectionSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_COLLECTION_SOURCE, BoxesCollectionSource);
	_g_key_file_unref0 (self->priv->_keyfile);
	_g_free0 (self->priv->_filename);
	G_OBJECT_CLASS (boxes_collection_source_parent_class)->finalize (obj);
}

static GType
boxes_collection_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesCollectionSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_collection_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesCollectionSource), 0, (GInstanceInitFunc) boxes_collection_source_instance_init, NULL };
	static const GInterfaceInfo boxes_iconfig_info = { (GInterfaceInitFunc) boxes_collection_source_boxes_iconfig_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType boxes_collection_source_type_id;
	boxes_collection_source_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesCollectionSource", &g_define_type_info, 0);
	g_type_add_interface_static (boxes_collection_source_type_id, BOXES_TYPE_ICONFIG, &boxes_iconfig_info);
	BoxesCollectionSource_private_offset = g_type_add_instance_private (boxes_collection_source_type_id, sizeof (BoxesCollectionSourcePrivate));
	return boxes_collection_source_type_id;
}

GType
boxes_collection_source_get_type (void)
{
	static volatile gsize boxes_collection_source_type_id__once = 0;
	if (g_once_init_enter (&boxes_collection_source_type_id__once)) {
		GType boxes_collection_source_type_id;
		boxes_collection_source_type_id = boxes_collection_source_get_type_once ();
		g_once_init_leave (&boxes_collection_source_type_id__once, boxes_collection_source_type_id);
	}
	return boxes_collection_source_type_id__once;
}

static void
_vala_boxes_collection_source_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	BoxesCollectionSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_COLLECTION_SOURCE, BoxesCollectionSource);
	switch (property_id) {
		case BOXES_COLLECTION_SOURCE_NAME_PROPERTY:
		g_value_take_string (value, boxes_collection_source_get_name (self));
		break;
		case BOXES_COLLECTION_SOURCE_SOURCE_TYPE_PROPERTY:
		g_value_take_string (value, boxes_collection_source_get_source_type (self));
		break;
		case BOXES_COLLECTION_SOURCE_URI_PROPERTY:
		g_value_take_string (value, boxes_collection_source_get_uri (self));
		break;
		case BOXES_COLLECTION_SOURCE_ENABLED_PROPERTY:
		g_value_set_boolean (value, boxes_collection_source_get_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_collection_source_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	BoxesCollectionSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_COLLECTION_SOURCE, BoxesCollectionSource);
	switch (property_id) {
		case BOXES_COLLECTION_SOURCE_NAME_PROPERTY:
		boxes_collection_source_set_name (self, g_value_get_string (value));
		break;
		case BOXES_COLLECTION_SOURCE_SOURCE_TYPE_PROPERTY:
		boxes_collection_source_set_source_type (self, g_value_get_string (value));
		break;
		case BOXES_COLLECTION_SOURCE_URI_PROPERTY:
		boxes_collection_source_set_uri (self, g_value_get_string (value));
		break;
		case BOXES_COLLECTION_SOURCE_ENABLED_PROPERTY:
		boxes_collection_source_set_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

