/* WorkspaceManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WorkspaceManager.vala, do not modify */

/*
 * Copyright 2014 Tom Beckmann, Rico Tzschichholz
 * Copyright 2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>
#include <meta/window.h>
#include <meta/display.h>
#include <meta/prefs.h>
#include <meta/types.h>
#include <meta/meta-plugin.h>
#include <meta/compositor.h>
#include <meta/util.h>
#include <meta/meta-startup-notification.h>
#include <meta/meta-window-actor.h>
#include <meta/compositor-mutter.h>
#include <meta/common.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WORKSPACE_MANAGER (gala_workspace_manager_get_type ())
#define GALA_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager))
#define GALA_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))
#define GALA_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))

typedef struct _GalaWorkspaceManager GalaWorkspaceManager;
typedef struct _GalaWorkspaceManagerClass GalaWorkspaceManagerClass;
typedef struct _GalaWorkspaceManagerPrivate GalaWorkspaceManagerPrivate;
enum  {
	GALA_WORKSPACE_MANAGER_0_PROPERTY,
	GALA_WORKSPACE_MANAGER_WM_PROPERTY,
	GALA_WORKSPACE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_workspace_manager_properties[GALA_WORKSPACE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaWorkspaceManager {
	GObject parent_instance;
	GalaWorkspaceManagerPrivate * priv;
};

struct _GalaWorkspaceManagerClass {
	GObjectClass parent_class;
};

struct _GalaWorkspaceManagerPrivate {
	GalaWindowManager* _wm;
	gint remove_freeze_count;
	guint check_workspaces_id;
};

static gint GalaWorkspaceManager_private_offset;
static gpointer gala_workspace_manager_parent_class = NULL;
static GalaWorkspaceManager* gala_workspace_manager_instance;
static GalaWorkspaceManager* gala_workspace_manager_instance = NULL;

VALA_EXTERN GType gala_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceManager, g_object_unref)
VALA_EXTERN void gala_workspace_manager_init (GalaWindowManager* wm);
static GalaWorkspaceManager* gala_workspace_manager_new (GalaWindowManager* wm);
static GalaWorkspaceManager* gala_workspace_manager_construct (GType object_type,
                                                        GalaWindowManager* wm);
VALA_EXTERN GalaWorkspaceManager* gala_workspace_manager_get_default (void);
static void gala_workspace_manager_workspace_added (GalaWorkspaceManager* self,
                                             MetaWorkspaceManager* manager,
                                             gint index);
static void gala_workspace_manager_queue_check_workspaces (GalaWorkspaceManager* self);
static void _gala_workspace_manager_queue_check_workspaces_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                                 MetaWindow* object,
                                                                                 gpointer self);
static void _gala_workspace_manager_queue_check_workspaces_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                                   MetaWindow* object,
                                                                                   gpointer self);
static void gala_workspace_manager_window_entered_monitor (GalaWorkspaceManager* self,
                                                    MetaDisplay* display,
                                                    gint monitor,
                                                    MetaWindow* window);
static void gala_workspace_manager_window_left_monitor (GalaWorkspaceManager* self,
                                                 MetaDisplay* display,
                                                 gint monitor,
                                                 MetaWindow* window);
VALA_EXTERN void gala_workspace_manager_freeze_remove (GalaWorkspaceManager* self);
VALA_EXTERN void gala_workspace_manager_thaw_remove (GalaWorkspaceManager* self);
VALA_EXTERN GalaWindowManager* gala_workspace_manager_get_wm (GalaWorkspaceManager* self);
static gboolean gala_workspace_manager_check_workspaces (GalaWorkspaceManager* self);
static gboolean _gala_workspace_manager_check_workspaces_gsource_func (gpointer self);
static void _vala_array_add10 (gboolean* * array,
                        gint* length,
                        gint* size,
                        gboolean value);
static void gala_workspace_manager_set_wm (GalaWorkspaceManager* self,
                                    GalaWindowManager* value);
static GObject * gala_workspace_manager_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _gala_workspace_manager_queue_check_workspaces_meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                                               gint object,
                                                                                               gint p0,
                                                                                               MetaMotionDirection p1,
                                                                                               gpointer self);
static void _gala_workspace_manager_workspace_added_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                     gint object,
                                                                                     gpointer self);
static void _gala_workspace_manager_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                         gint object,
                                                                                         MetaWindow* p0,
                                                                                         gpointer self);
static void _gala_workspace_manager_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                                   gint object,
                                                                                   MetaWindow* p0,
                                                                                   gpointer self);
static void gala_workspace_manager_finalize (GObject * obj);
static GType gala_workspace_manager_get_type_once (void);
static void _vala_gala_workspace_manager_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_workspace_manager_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
gala_workspace_manager_get_instance_private (GalaWorkspaceManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWorkspaceManager_private_offset);
}

void
gala_workspace_manager_init (GalaWindowManager* wm)
{
	GalaWorkspaceManager* _tmp0_;
	GalaWorkspaceManager* _tmp1_;
	g_return_if_fail (wm != NULL);
	_tmp0_ = gala_workspace_manager_instance;
	_vala_return_if_fail (_tmp0_ == NULL, "instance == null");
	_tmp1_ = gala_workspace_manager_new (wm);
	_g_object_unref0 (gala_workspace_manager_instance);
	gala_workspace_manager_instance = _tmp1_;
}

GalaWorkspaceManager*
gala_workspace_manager_get_default (void)
{
	GalaWorkspaceManager* _tmp0_;
	GalaWorkspaceManager* _tmp1_;
	GalaWorkspaceManager* result;
	_tmp0_ = gala_workspace_manager_instance;
	_vala_return_val_if_fail (_tmp0_ != NULL, "instance != null", NULL);
	_tmp1_ = gala_workspace_manager_instance;
	result = _tmp1_;
	return result;
}

static GalaWorkspaceManager*
gala_workspace_manager_construct (GType object_type,
                                  GalaWindowManager* wm)
{
	GalaWorkspaceManager * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWorkspaceManager*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

static GalaWorkspaceManager*
gala_workspace_manager_new (GalaWindowManager* wm)
{
	return gala_workspace_manager_construct (GALA_TYPE_WORKSPACE_MANAGER, wm);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gala_workspace_manager_queue_check_workspaces_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                            MetaWindow* object,
                                                                            gpointer self)
{
	gala_workspace_manager_queue_check_workspaces ((GalaWorkspaceManager*) self);
}

static void
_gala_workspace_manager_queue_check_workspaces_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                              MetaWindow* object,
                                                                              gpointer self)
{
	gala_workspace_manager_queue_check_workspaces ((GalaWorkspaceManager*) self);
}

static void
gala_workspace_manager_workspace_added (GalaWorkspaceManager* self,
                                        MetaWorkspaceManager* manager,
                                        gint index)
{
	MetaWorkspace* workspace = NULL;
	MetaWorkspace* _tmp0_;
	MetaWorkspace* _tmp1_;
	MetaWorkspace* _tmp2_;
	MetaWorkspace* _tmp3_;
	MetaWorkspace* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	_tmp0_ = meta_workspace_manager_get_workspace_by_index (manager, index);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	workspace = _tmp1_;
	_tmp2_ = workspace;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (workspace);
		return;
	}
	_tmp3_ = workspace;
	g_signal_connect_object (_tmp3_, "window-added", (GCallback) _gala_workspace_manager_queue_check_workspaces_meta_workspace_window_added, self, 0);
	_tmp4_ = workspace;
	g_signal_connect_object (_tmp4_, "window-removed", (GCallback) _gala_workspace_manager_queue_check_workspaces_meta_workspace_window_removed, self, 0);
	_g_object_unref0 (workspace);
}

static void
gala_workspace_manager_window_entered_monitor (GalaWorkspaceManager* self,
                                               MetaDisplay* display,
                                               gint monitor,
                                               MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	if (meta_prefs_get_workspaces_only_on_primary ()) {
		_tmp0_ = monitor == meta_display_get_primary_monitor (display);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_workspace_manager_queue_check_workspaces (self);
	}
}

static void
gala_workspace_manager_window_left_monitor (GalaWorkspaceManager* self,
                                            MetaDisplay* display,
                                            gint monitor,
                                            MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	if (meta_prefs_get_workspaces_only_on_primary ()) {
		_tmp0_ = monitor == meta_display_get_primary_monitor (display);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_workspace_manager_queue_check_workspaces (self);
	}
}

/**
     * Temporarily disables removing workspaces when they are empty
     */
void
gala_workspace_manager_freeze_remove (GalaWorkspaceManager* self)
{
	g_return_if_fail (self != NULL);
	g_atomic_int_inc (&self->priv->remove_freeze_count);
}

/**
     * Undo the effect of freeze_remove()
     */
void
gala_workspace_manager_thaw_remove (GalaWorkspaceManager* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_atomic_int_dec_and_test (&self->priv->remove_freeze_count);
	if (_tmp0_) {
		gala_workspace_manager_queue_check_workspaces (self);
	}
	_vala_assert (self->priv->remove_freeze_count >= 0, "remove_freeze_count >= 0");
}

static gboolean
_gala_workspace_manager_check_workspaces_gsource_func (gpointer self)
{
	gboolean result;
	result = gala_workspace_manager_check_workspaces ((GalaWorkspaceManager*) self);
	return result;
}

static void
gala_workspace_manager_queue_check_workspaces (GalaWorkspaceManager* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->check_workspaces_id == ((guint) 0)) {
		MetaLaters* laters = NULL;
		GalaWindowManager* _tmp0_;
		MetaDisplay* _tmp1_;
		MetaCompositor* _tmp2_;
		MetaLaters* _tmp3_;
		MetaLaters* _tmp4_;
		MetaLaters* _tmp5_;
		_tmp0_ = self->priv->_wm;
		_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
		_tmp2_ = meta_display_get_compositor (_tmp1_);
		_tmp3_ = meta_compositor_get_laters (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		laters = _tmp4_;
		_tmp5_ = laters;
		self->priv->check_workspaces_id = meta_laters_add (_tmp5_, META_LATER_BEFORE_REDRAW, _gala_workspace_manager_check_workspaces_gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (laters);
	}
}

static void
_vala_array_add10 (gboolean* * array,
                   gint* length,
                   gint* size,
                   gboolean value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gboolean, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static gboolean
gala_workspace_manager_check_workspaces (GalaWorkspaceManager* self)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	gboolean* empty_workspaces = NULL;
	MetaWorkspaceManager* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean* _tmp7_;
	gint empty_workspaces_length1;
	gint _empty_workspaces_size_;
	GSList* active_startup_sequences = NULL;
	MetaDisplay* _tmp12_;
	MetaStartupNotification* _tmp13_;
	GSList* _tmp14_;
	GSList* _tmp15_;
	GList* window_actors = NULL;
	MetaDisplay* _tmp21_;
	GList* _tmp22_;
	GList* _tmp23_;
	gboolean* _tmp40_;
	gint _tmp40__length1;
	gboolean* _tmp41_;
	gint _tmp41__length1;
	gboolean _tmp42_;
	gint last_index = 0;
	gboolean* _tmp45_;
	gint _tmp45__length1;
	gint last_empty_index = 0;
	GalaWindowManager* _tmp50_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
	manager = _tmp3_;
	if (self->priv->remove_freeze_count > 0) {
		result = G_SOURCE_CONTINUE;
		return result;
	}
	_tmp4_ = manager;
	_tmp5_ = meta_workspace_manager_get_n_workspaces (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gboolean, _tmp6_);
	empty_workspaces = _tmp7_;
	empty_workspaces_length1 = _tmp6_;
	_empty_workspaces_size_ = empty_workspaces_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean* _tmp10_;
				gint _tmp10__length1;
				gboolean* _tmp11_;
				gint _tmp11__length1;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = empty_workspaces;
				_tmp10__length1 = empty_workspaces_length1;
				if (!(i < _tmp10__length1)) {
					break;
				}
				_tmp11_ = empty_workspaces;
				_tmp11__length1 = empty_workspaces_length1;
				_tmp11_[i] = TRUE;
			}
		}
	}
	_tmp12_ = display;
	_tmp13_ = meta_display_get_startup_notification (_tmp12_);
	_tmp14_ = meta_startup_notification_get_sequences (_tmp13_);
	active_startup_sequences = _tmp14_;
	_tmp15_ = active_startup_sequences;
	{
		GSList* startup_sequence_collection = NULL;
		GSList* startup_sequence_it = NULL;
		startup_sequence_collection = _tmp15_;
		for (startup_sequence_it = startup_sequence_collection; startup_sequence_it != NULL; startup_sequence_it = startup_sequence_it->next) {
			MetaStartupSequence* _tmp16_;
			MetaStartupSequence* startup_sequence = NULL;
			_tmp16_ = _g_object_ref0 ((MetaStartupSequence*) startup_sequence_it->data);
			startup_sequence = _tmp16_;
			{
				gint index = 0;
				MetaStartupSequence* _tmp17_;
				gboolean _tmp18_ = FALSE;
				_tmp17_ = startup_sequence;
				index = meta_startup_sequence_get_workspace (_tmp17_);
				if (index >= 0) {
					gboolean* _tmp19_;
					gint _tmp19__length1;
					_tmp19_ = empty_workspaces;
					_tmp19__length1 = empty_workspaces_length1;
					_tmp18_ = index < _tmp19__length1;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					gboolean* _tmp20_;
					gint _tmp20__length1;
					_tmp20_ = empty_workspaces;
					_tmp20__length1 = empty_workspaces_length1;
					_tmp20_[index] = FALSE;
				}
				_g_object_unref0 (startup_sequence);
			}
		}
	}
	_tmp21_ = display;
	_tmp22_ = meta_get_window_actors (_tmp21_);
	window_actors = _tmp22_;
	_tmp23_ = window_actors;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp23_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			MetaWindowActor* _tmp24_;
			MetaWindowActor* actor = NULL;
			_tmp24_ = _g_object_ref0 ((MetaWindowActor*) actor_it->data);
			actor = _tmp24_;
			{
				MetaWindow* win = NULL;
				MetaWindowActor* _tmp25_;
				MetaWindow* _tmp26_;
				MetaWindow* _tmp27_;
				MetaWindow* _tmp28_;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp30_ = FALSE;
				MetaWindow* _tmp31_;
				gboolean* _tmp37_;
				gint _tmp37__length1;
				MetaWindow* _tmp38_;
				MetaWorkspace* _tmp39_;
				_tmp25_ = actor;
				_tmp26_ = meta_window_actor_get_meta_window (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _g_object_ref0 (_tmp27_);
				win = _tmp28_;
				_tmp31_ = win;
				if (_tmp31_ == NULL) {
					_tmp30_ = TRUE;
				} else {
					MetaWindow* _tmp32_;
					gboolean _tmp33_;
					gboolean _tmp34_;
					_tmp32_ = win;
					g_object_get (_tmp32_, "on-all-workspaces", &_tmp33_, NULL);
					_tmp34_ = _tmp33_;
					_tmp30_ = _tmp34_;
				}
				if (_tmp30_) {
					_tmp29_ = TRUE;
				} else {
					MetaWindow* _tmp35_;
					MetaWorkspace* _tmp36_;
					_tmp35_ = win;
					_tmp36_ = meta_window_get_workspace (_tmp35_);
					_tmp29_ = _tmp36_ == NULL;
				}
				if (_tmp29_) {
					_g_object_unref0 (win);
					_g_object_unref0 (actor);
					continue;
				}
				_tmp37_ = empty_workspaces;
				_tmp37__length1 = empty_workspaces_length1;
				_tmp38_ = win;
				_tmp39_ = meta_window_get_workspace (_tmp38_);
				_tmp37_[meta_workspace_index (_tmp39_)] = FALSE;
				_g_object_unref0 (win);
				_g_object_unref0 (actor);
			}
		}
	}
	_tmp40_ = empty_workspaces;
	_tmp40__length1 = empty_workspaces_length1;
	_tmp41_ = empty_workspaces;
	_tmp41__length1 = empty_workspaces_length1;
	_tmp42_ = _tmp40_[_tmp41__length1 - 1];
	if (!_tmp42_) {
		MetaWorkspaceManager* _tmp43_;
		MetaDisplay* _tmp44_;
		_tmp43_ = manager;
		_tmp44_ = display;
		meta_workspace_manager_append_new_workspace (_tmp43_, FALSE, meta_display_get_current_time (_tmp44_));
		_vala_array_add10 (&empty_workspaces, &empty_workspaces_length1, &_empty_workspaces_size_, TRUE);
	}
	_tmp45_ = empty_workspaces;
	_tmp45__length1 = empty_workspaces_length1;
	last_index = _tmp45__length1 - 1;
	last_empty_index = 0;
	{
		gint i = 0;
		i = last_index;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				gboolean* _tmp48_;
				gint _tmp48__length1;
				gboolean _tmp49_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ - 1;
				}
				_tmp46_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp48_ = empty_workspaces;
				_tmp48__length1 = empty_workspaces_length1;
				_tmp49_ = _tmp48_[i];
				if (!_tmp49_) {
					last_empty_index = i + 1;
					break;
				}
			}
		}
	}
	_tmp50_ = self->priv->_wm;
	if (!gala_window_manager_is_modal (_tmp50_)) {
		gint active_index = 0;
		MetaWorkspaceManager* _tmp51_;
		gboolean* _tmp52_;
		gint _tmp52__length1;
		_tmp51_ = manager;
		active_index = meta_workspace_manager_get_active_workspace_index (_tmp51_);
		_tmp52_ = empty_workspaces;
		_tmp52__length1 = empty_workspaces_length1;
		_tmp52_[active_index] = FALSE;
	}
	{
		gint i = 0;
		i = last_index;
		{
			gboolean _tmp53_ = FALSE;
			_tmp53_ = TRUE;
			while (TRUE) {
				gboolean _tmp55_ = FALSE;
				gboolean* _tmp56_;
				gint _tmp56__length1;
				gboolean _tmp57_;
				MetaWorkspace* workspace = NULL;
				MetaWorkspaceManager* _tmp58_;
				MetaWorkspace* _tmp59_;
				MetaWorkspace* _tmp60_;
				MetaWorkspace* _tmp61_;
				MetaWorkspaceManager* _tmp62_;
				MetaWorkspace* _tmp63_;
				MetaWorkspaceManager* _tmp77_;
				MetaWorkspace* _tmp78_;
				MetaDisplay* _tmp79_;
				if (!_tmp53_) {
					gint _tmp54_;
					_tmp54_ = i;
					i = _tmp54_ - 1;
				}
				_tmp53_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp56_ = empty_workspaces;
				_tmp56__length1 = empty_workspaces_length1;
				_tmp57_ = _tmp56_[i];
				if (!_tmp57_) {
					_tmp55_ = TRUE;
				} else {
					_tmp55_ = i == last_empty_index;
				}
				if (_tmp55_) {
					continue;
				}
				_tmp58_ = manager;
				_tmp59_ = meta_workspace_manager_get_workspace_by_index (_tmp58_, i);
				_tmp60_ = _g_object_ref0 (_tmp59_);
				workspace = _tmp60_;
				_tmp61_ = workspace;
				_tmp62_ = manager;
				_tmp63_ = meta_workspace_manager_get_active_workspace (_tmp62_);
				if (_tmp61_ == _tmp63_) {
					MetaWorkspace* next = NULL;
					MetaWorkspace* _tmp64_;
					MetaWorkspace* _tmp65_;
					MetaWorkspace* _tmp66_;
					gboolean _tmp67_ = FALSE;
					MetaWorkspace* _tmp68_;
					MetaWorkspace* _tmp69_;
					MetaWorkspace* _tmp74_;
					next = NULL;
					_tmp64_ = workspace;
					_tmp65_ = meta_workspace_get_neighbor (_tmp64_, META_MOTION_LEFT);
					_tmp66_ = _g_object_ref0 (_tmp65_);
					_g_object_unref0 (next);
					next = _tmp66_;
					_tmp68_ = next;
					_tmp69_ = workspace;
					if (_tmp68_ == _tmp69_) {
						_tmp67_ = TRUE;
					} else {
						MetaWorkspace* _tmp70_;
						_tmp70_ = next;
						_tmp67_ = _tmp70_ == NULL;
					}
					if (_tmp67_) {
						MetaWorkspace* _tmp71_;
						MetaWorkspace* _tmp72_;
						MetaWorkspace* _tmp73_;
						_tmp71_ = workspace;
						_tmp72_ = meta_workspace_get_neighbor (_tmp71_, META_MOTION_RIGHT);
						_tmp73_ = _g_object_ref0 (_tmp72_);
						_g_object_unref0 (next);
						next = _tmp73_;
					}
					_tmp74_ = next;
					if (_tmp74_ != NULL) {
						MetaWorkspace* _tmp75_;
						MetaDisplay* _tmp76_;
						_tmp75_ = next;
						_tmp76_ = display;
						meta_workspace_activate (_tmp75_, meta_display_get_current_time (_tmp76_));
					}
					_g_object_unref0 (next);
				}
				_tmp77_ = manager;
				_tmp78_ = workspace;
				_tmp79_ = display;
				meta_workspace_manager_remove_workspace (_tmp77_, _tmp78_, meta_display_get_current_time (_tmp79_));
				_g_object_unref0 (workspace);
			}
		}
	}
	self->priv->check_workspaces_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	empty_workspaces = (g_free (empty_workspaces), NULL);
	return result;
}

GalaWindowManager*
gala_workspace_manager_get_wm (GalaWorkspaceManager* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_manager_set_wm (GalaWorkspaceManager* self,
                               GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_manager_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_manager_properties[GALA_WORKSPACE_MANAGER_WM_PROPERTY]);
	}
}

static void
_gala_workspace_manager_queue_check_workspaces_meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                                          gint object,
                                                                                          gint p0,
                                                                                          MetaMotionDirection p1,
                                                                                          gpointer self)
{
	gala_workspace_manager_queue_check_workspaces ((GalaWorkspaceManager*) self);
}

static void
_gala_workspace_manager_workspace_added_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                gint object,
                                                                                gpointer self)
{
	gala_workspace_manager_workspace_added ((GalaWorkspaceManager*) self, _sender, object);
}

static void
_gala_workspace_manager_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                    gint object,
                                                                                    MetaWindow* p0,
                                                                                    gpointer self)
{
	gala_workspace_manager_window_entered_monitor ((GalaWorkspaceManager*) self, _sender, object, p0);
}

static void
_gala_workspace_manager_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                              gint object,
                                                                              MetaWindow* p0,
                                                                              gpointer self)
{
	gala_workspace_manager_window_left_monitor ((GalaWorkspaceManager*) self, _sender, object, p0);
}

static GObject *
gala_workspace_manager_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWorkspaceManager * self;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspaceManager* _tmp9_;
	MetaWorkspaceManager* _tmp10_;
	MetaDisplay* _tmp11_;
	MetaDisplay* _tmp12_;
	parent_class = G_OBJECT_CLASS (gala_workspace_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
	manager = _tmp3_;
	_tmp4_ = manager;
	meta_workspace_manager_override_workspace_layout (_tmp4_, META_DISPLAY_TOPLEFT, FALSE, 1, -1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp7_;
				MetaWorkspaceManager* _tmp8_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp7_))) {
					break;
				}
				_tmp8_ = manager;
				gala_workspace_manager_workspace_added (self, _tmp8_, i);
			}
		}
	}
	_tmp9_ = manager;
	g_signal_connect_object (_tmp9_, "workspace-switched", (GCallback) _gala_workspace_manager_queue_check_workspaces_meta_workspace_manager_workspace_switched, self, G_CONNECT_AFTER);
	_tmp10_ = manager;
	g_signal_connect_object (_tmp10_, "workspace-added", (GCallback) _gala_workspace_manager_workspace_added_meta_workspace_manager_workspace_added, self, 0);
	_tmp11_ = display;
	g_signal_connect_object (_tmp11_, "window-entered-monitor", (GCallback) _gala_workspace_manager_window_entered_monitor_meta_display_window_entered_monitor, self, 0);
	_tmp12_ = display;
	g_signal_connect_object (_tmp12_, "window-left-monitor", (GCallback) _gala_workspace_manager_window_left_monitor_meta_display_window_left_monitor, self, 0);
	return obj;
}

static void
gala_workspace_manager_class_init (GalaWorkspaceManagerClass * klass,
                                   gpointer klass_data)
{
	gala_workspace_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWorkspaceManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_workspace_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_workspace_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_workspace_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_workspace_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_MANAGER_WM_PROPERTY, gala_workspace_manager_properties[GALA_WORKSPACE_MANAGER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_workspace_manager_instance_init (GalaWorkspaceManager * self,
                                      gpointer klass)
{
	self->priv = gala_workspace_manager_get_instance_private (self);
	self->priv->remove_freeze_count = 0;
	self->priv->check_workspaces_id = (guint) 0;
}

static void
gala_workspace_manager_finalize (GObject * obj)
{
	GalaWorkspaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager);
	_g_object_unref0 (self->priv->_wm);
	G_OBJECT_CLASS (gala_workspace_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_workspace_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWorkspaceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_workspace_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWorkspaceManager), 0, (GInstanceInitFunc) gala_workspace_manager_instance_init, NULL };
	GType gala_workspace_manager_type_id;
	gala_workspace_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaWorkspaceManager", &g_define_type_info, 0);
	GalaWorkspaceManager_private_offset = g_type_add_instance_private (gala_workspace_manager_type_id, sizeof (GalaWorkspaceManagerPrivate));
	return gala_workspace_manager_type_id;
}

GType
gala_workspace_manager_get_type (void)
{
	static gsize gala_workspace_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_workspace_manager_type_id__once)) {
		GType gala_workspace_manager_type_id;
		gala_workspace_manager_type_id = gala_workspace_manager_get_type_once ();
		g_once_init_leave (&gala_workspace_manager_type_id__once, gala_workspace_manager_type_id);
	}
	return gala_workspace_manager_type_id__once;
}

static void
_vala_gala_workspace_manager_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaWorkspaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager);
	switch (property_id) {
		case GALA_WORKSPACE_MANAGER_WM_PROPERTY:
		g_value_set_object (value, gala_workspace_manager_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_workspace_manager_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaWorkspaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager);
	switch (property_id) {
		case GALA_WORKSPACE_MANAGER_WM_PROPERTY:
		gala_workspace_manager_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

