/* Generated by wayland-scanner 1.24.0 */

#ifndef DPMS_SERVER_PROTOCOL_H
#define DPMS_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_dpms The dpms protocol
 * @section page_ifaces_dpms Interfaces
 * - @subpage page_iface_org_kde_kwin_dpms_manager - Output dpms manager
 * - @subpage page_iface_org_kde_kwin_dpms - Dpms for a wl_output
 * @section page_copyright_dpms Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2015 Martin Gräßlin
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_dpms;
struct org_kde_kwin_dpms_manager;
struct wl_output;

#ifndef ORG_KDE_KWIN_DPMS_MANAGER_INTERFACE
#define ORG_KDE_KWIN_DPMS_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_dpms_manager org_kde_kwin_dpms_manager
 * @section page_iface_org_kde_kwin_dpms_manager_desc Description
 *
 * The Dpms manager allows to get a org_kde_kwin_dpms for a given wl_output.
 * The org_kde_kwin_dpms provides the currently used VESA Display Power Management
 * Signaling state (see https://en.wikipedia.org/wiki/VESA_Display_Power_Management_Signaling ).
 * In addition it allows to request a state change. A compositor is not obliged to honor it
 * and will normally automatically switch back to on state.
 * @section page_iface_org_kde_kwin_dpms_manager_api API
 * See @ref iface_org_kde_kwin_dpms_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_dpms_manager The org_kde_kwin_dpms_manager interface
 *
 * The Dpms manager allows to get a org_kde_kwin_dpms for a given wl_output.
 * The org_kde_kwin_dpms provides the currently used VESA Display Power Management
 * Signaling state (see https://en.wikipedia.org/wiki/VESA_Display_Power_Management_Signaling ).
 * In addition it allows to request a state change. A compositor is not obliged to honor it
 * and will normally automatically switch back to on state.
 */
extern const struct wl_interface org_kde_kwin_dpms_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_DPMS_INTERFACE
#define ORG_KDE_KWIN_DPMS_INTERFACE
/**
 * @page page_iface_org_kde_kwin_dpms org_kde_kwin_dpms
 * @section page_iface_org_kde_kwin_dpms_desc Description
 *
 * This interface provides information about the VESA DPMS state for a wl_output.
 * It gets created through the request get on the org_kde_kwin_dpms_manager interface.
 *
 * On creating the resource the server will push whether DPSM is supported for the output,
 * the currently used DPMS state and notifies the client through the done event once all
 * states are pushed. Whenever a state changes the set of changes is committed with the
 * done event.
 * @section page_iface_org_kde_kwin_dpms_api API
 * See @ref iface_org_kde_kwin_dpms.
 */
/**
 * @defgroup iface_org_kde_kwin_dpms The org_kde_kwin_dpms interface
 *
 * This interface provides information about the VESA DPMS state for a wl_output.
 * It gets created through the request get on the org_kde_kwin_dpms_manager interface.
 *
 * On creating the resource the server will push whether DPSM is supported for the output,
 * the currently used DPMS state and notifies the client through the done event once all
 * states are pushed. Whenever a state changes the set of changes is committed with the
 * done event.
 */
extern const struct wl_interface org_kde_kwin_dpms_interface;
#endif

/**
 * @ingroup iface_org_kde_kwin_dpms_manager
 * @struct org_kde_kwin_dpms_manager_interface
 */
struct org_kde_kwin_dpms_manager_interface {
	/**
	 * Get org_kde_kwin_dpms for wl_output
	 *
	 * Factory request to get the org_kde_kwin_dpms for a given
	 * wl_output.
	 */
	void (*get)(struct wl_client *client,
		    struct wl_resource *resource,
		    uint32_t id,
		    struct wl_resource *output);
};


/**
 * @ingroup iface_org_kde_kwin_dpms_manager
 */
#define ORG_KDE_KWIN_DPMS_MANAGER_GET_SINCE_VERSION 1

#ifndef ORG_KDE_KWIN_DPMS_MODE_ENUM
#define ORG_KDE_KWIN_DPMS_MODE_ENUM
enum org_kde_kwin_dpms_mode {
	ORG_KDE_KWIN_DPMS_MODE_ON = 0,
	ORG_KDE_KWIN_DPMS_MODE_STANDBY = 1,
	ORG_KDE_KWIN_DPMS_MODE_SUSPEND = 2,
	ORG_KDE_KWIN_DPMS_MODE_OFF = 3,
};
#endif /* ORG_KDE_KWIN_DPMS_MODE_ENUM */

#ifndef ORG_KDE_KWIN_DPMS_MODE_ENUM_IS_VALID
#define ORG_KDE_KWIN_DPMS_MODE_ENUM_IS_VALID
/**
 * @ingroup iface_org_kde_kwin_dpms
 * Validate a org_kde_kwin_dpms mode value.
 *
 * @return true on success, false on error.
 * @ref org_kde_kwin_dpms_mode
 */
static inline bool
org_kde_kwin_dpms_mode_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ORG_KDE_KWIN_DPMS_MODE_ON:
		return version >= 1;
	case ORG_KDE_KWIN_DPMS_MODE_STANDBY:
		return version >= 1;
	case ORG_KDE_KWIN_DPMS_MODE_SUSPEND:
		return version >= 1;
	case ORG_KDE_KWIN_DPMS_MODE_OFF:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ORG_KDE_KWIN_DPMS_MODE_ENUM_IS_VALID */

/**
 * @ingroup iface_org_kde_kwin_dpms
 * @struct org_kde_kwin_dpms_interface
 */
struct org_kde_kwin_dpms_interface {
	/**
	 * Request DPMS state change for the wl_output
	 *
	 * Requests that the compositor puts the wl_output into the
	 * passed mode. The compositor is not obliged to change the state.
	 * In addition the compositor might leave the mode whenever it
	 * seems suitable. E.g. the compositor might return to On state on
	 * user input.
	 *
	 * The client should not assume that the mode changed after
	 * requesting a new mode. Instead the client should listen for the
	 * mode event.
	 * @param mode Requested mode
	 */
	void (*set)(struct wl_client *client,
		    struct wl_resource *resource,
		    uint32_t mode);
	/**
	 * release the dpms object
	 *
	 * 
	 */
	void (*release)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ORG_KDE_KWIN_DPMS_SUPPORTED 0
#define ORG_KDE_KWIN_DPMS_MODE 1
#define ORG_KDE_KWIN_DPMS_DONE 2

/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_SUPPORTED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_SET_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_dpms
 */
#define ORG_KDE_KWIN_DPMS_RELEASE_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_dpms
 * Sends an supported event to the client owning the resource.
 * @param resource_ The client's resource
 * @param supported Boolean value whether DPMS is supported (1) for the wl_output or not (0)
 */
static inline void
org_kde_kwin_dpms_send_supported(struct wl_resource *resource_, uint32_t supported)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_DPMS_SUPPORTED, supported);
}

/**
 * @ingroup iface_org_kde_kwin_dpms
 * Sends an mode event to the client owning the resource.
 * @param resource_ The client's resource
 * @param mode The new currently used mode
 */
static inline void
org_kde_kwin_dpms_send_mode(struct wl_resource *resource_, uint32_t mode)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_DPMS_MODE, mode);
}

/**
 * @ingroup iface_org_kde_kwin_dpms
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_kwin_dpms_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_DPMS_DONE);
}

#ifdef  __cplusplus
}
#endif

#endif
