/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import java.util.Arrays;
import korlibs.crypto.Cipher;
import korlibs.crypto.CipherMode;
import korlibs.crypto.CipherPadding;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u001a0\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"decryptSafe", "", "Lkorlibs/crypto/CipherMode;", "data", "cipher", "Lkorlibs/crypto/Cipher;", "padding", "Lkorlibs/crypto/CipherPadding;", "Lkorlibs/crypto/Padding;", "iv", "encryptSafe", "nextMultipleOf", "", "multiple", "krypto"})
public final class CipherModeKt {
    private static final int nextMultipleOf(int $this$nextMultipleOf, int multiple) {
        return $this$nextMultipleOf % multiple == 0 ? $this$nextMultipleOf : ($this$nextMultipleOf / multiple + 1) * multiple;
    }

    @NotNull
    public static final byte[] encryptSafe(@NotNull CipherMode $this$encryptSafe, @NotNull byte[] data, @NotNull Cipher cipher, @NotNull CipherPadding padding, @Nullable byte[] iv) {
        if (Intrinsics.areEqual((Object)padding, (Object)CipherPadding.Companion.getNoPadding())) {
            byte[] byArray = Arrays.copyOf($this$encryptSafe.encrypt(data, cipher, CipherPadding.Companion.getZeroPadding(), iv), data.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
            return byArray;
        }
        return $this$encryptSafe.encrypt(data, cipher, padding, iv);
    }

    @NotNull
    public static final byte[] decryptSafe(@NotNull CipherMode $this$decryptSafe, @NotNull byte[] data, @NotNull Cipher cipher, @NotNull CipherPadding padding, @Nullable byte[] iv) {
        if (Intrinsics.areEqual((Object)padding, (Object)CipherPadding.Companion.getNoPadding())) {
            byte[] byArray = Arrays.copyOf(data, CipherModeKt.nextMultipleOf(data.length, cipher.getBlockSize()));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
            byte[] byArray2 = Arrays.copyOf($this$decryptSafe.decrypt(byArray, cipher, CipherPadding.Companion.getZeroPadding(), iv), data.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
            return byArray2;
        }
        return $this$decryptSafe.decrypt(data, cipher, padding, iv);
    }
}

