/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import groovy.lang.Closure;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiFunction;
import org.gradle.internal.classpath.InstrumentableClosure;
import org.gradle.internal.classpath.InstrumentedClosuresHelper;
import org.gradle.internal.classpath.InstrumentedGroovyMetaClassHelper;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

@NullMarked
public class CallInterceptionClosureInstrumentingClassVisitor
extends ClassVisitor {
    private static final Type BYTECODE_INTERCEPTOR_FILTER_TYPE = Type.getType(BytecodeInterceptorFilter.class);
    private final BytecodeInterceptorFilter interceptorFilter;
    boolean inClosureImplementation = false;
    String className = null;
    EnumSet<MethodInstrumentationStrategy> usedStrategies = EnumSet.noneOf(MethodInstrumentationStrategy.class);
    private static final Type CLOSURE_TYPE = Type.getType(Closure.class);
    private static final String CLOSURE_INTERNAL_NAME = CLOSURE_TYPE.getInternalName();
    private static final String IS_EFFECTIVELY_INSTRUMENTED_FIELD_NAME = "$isEffectivelyInstrumented";

    public CallInterceptionClosureInstrumentingClassVisitor(ClassVisitor delegate, BytecodeInterceptorFilter interceptorFilter) {
        super(589824, delegate);
        this.interceptorFilter = interceptorFilter;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean isClosureImplementation = CLOSURE_INTERNAL_NAME.equals(superName);
        this.enterClass(name, isClosureImplementation);
        String[] modifiedInterfaces = CallInterceptionClosureInstrumentingClassVisitor.interfacesWithInstrumentableClosure(interfaces, isClosureImplementation);
        super.visit(version, access, name, signature, superName, modifiedInterfaces);
    }

    private static @NonNull String[] interfacesWithInstrumentableClosure(String[] interfaces, boolean isClosureImplementation) {
        String[] modifiedInterfaces;
        String[] stringArray = modifiedInterfaces = isClosureImplementation ? Arrays.copyOf(interfaces, interfaces.length + 1) : interfaces;
        if (isClosureImplementation) {
            modifiedInterfaces[modifiedInterfaces.length - 1] = Type.getInternalName(InstrumentableClosure.class);
        }
        return modifiedInterfaces;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        if (!this.inClosureImplementation) {
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        Optional<MethodInstrumentationStrategy> matchingStrategy = Arrays.stream(MethodInstrumentationStrategy.values()).filter(it -> name.equals(it.methodName) && (it.descriptor == null || descriptor.equals(it.descriptor))).findAny();
        matchingStrategy.ifPresent(this.usedStrategies::add);
        MethodInstrumentationStrategy strategy = matchingStrategy.orElse(MethodInstrumentationStrategy.DEFAULT);
        return (MethodVisitor)strategy.methodVisitorFactory.apply(new MethodInstrumentationStrategy.ClassData(this.cv, this.className, this.interceptorFilter), new MethodInstrumentationStrategy.MethodData(access, name, descriptor, signature, exceptions));
    }

    private void enterClass(String className, boolean isClosureSubtype) {
        this.className = className;
        this.inClosureImplementation = isClosureSubtype;
        this.usedStrategies.clear();
    }

    public void visitEnd() {
        if (this.inClosureImplementation) {
            for (MethodInstrumentationStrategy methodInstrumentationStrategy : MethodInstrumentationStrategy.values()) {
                if (!methodInstrumentationStrategy.generateIfNotPresent || this.usedStrategies.contains((Object)methodInstrumentationStrategy)) continue;
                assert (methodInstrumentationStrategy.methodName != null);
                assert (methodInstrumentationStrategy.descriptor != null);
                MethodVisitor visitor = this.visitMethod(1, methodInstrumentationStrategy.methodName, methodInstrumentationStrategy.descriptor, null, null);
                visitor.visitCode();
                visitor.visitInsn(177);
                visitor.visitMaxs(4, 4);
                visitor.visitEnd();
            }
            this.visitField(2, IS_EFFECTIVELY_INSTRUMENTED_FIELD_NAME, "Z", null, null);
        }
        super.visitEnd();
    }

    @NullMarked
    private static enum MethodInstrumentationStrategy {
        SET_DELEGATE("setDelegate", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true, (classData, mv) -> {
            @NullMarked
            class 1MethodVisitorScopeImpl
            extends MethodVisitorScope {
                final /* synthetic */ ClassData val$classData;

                public 1MethodVisitorScopeImpl(MethodVisitor methodVisitor2) {
                    this.val$classData = methodVisitor2;
                    super((MethodVisitor)methodVisitor);
                }

                public void visitCode() {
                    this._ALOAD(1);
                    this._ALOAD(0);
                    this._GETFIELD(this.val$classData.className, CallInterceptionClosureInstrumentingClassVisitor.IS_EFFECTIVELY_INSTRUMENTED_FIELD_NAME, "Z");
                    this._GETSTATIC(BYTECODE_INTERCEPTOR_FILTER_TYPE, this.val$classData.interceptorFilter.name(), BYTECODE_INTERCEPTOR_FILTER_TYPE.getDescriptor());
                    String descriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{InstructionAdapter.OBJECT_TYPE, Type.BOOLEAN_TYPE, BYTECODE_INTERCEPTOR_FILTER_TYPE});
                    this._INVOKESTATIC(Type.getType(InstrumentedGroovyMetaClassHelper.class).getInternalName(), "addInvocationHooksInClosureDispatchObject", descriptor, false);
                    this._ALOAD(0);
                    this._ALOAD(1);
                    this._INVOKESPECIAL(Type.getType(Closure.class).getInternalName(), "setDelegate", "(Ljava/lang/Object;)V", false);
                    this.mv.visitCode();
                }
            }
            return new 1MethodVisitorScopeImpl(classData.visitor.visitMethod(mv.access, mv.name, mv.descriptor, mv.signature, mv.exceptions), classData);
        }),
        RENAME_ORIGINAL_DO_CALL("doCall", null, false, (clazz, methodData) -> {
            boolean isValidDoCallMethod = !methodData.isAbstract() && methodData.name.equals("doCall");
            String methodNameToVisit = isValidDoCallMethod ? "doCall$original" : methodData.name;
            MethodVisitor original = clazz.visitor.visitMethod(methodData.access, methodNameToVisit, methodData.descriptor, methodData.signature, methodData.exceptions);
            if (isValidDoCallMethod) {
                @NullMarked
                class 2MethodVisitorScopeImpl
                extends MethodVisitorScope {
                    final /* synthetic */ MethodData val$methodData;
                    final /* synthetic */ ClassData val$clazz;
                    final /* synthetic */ String val$methodNameToVisit;

                    public 2MethodVisitorScopeImpl(MethodVisitor methodVisitor) {
                        this.val$methodData = methodData;
                        this.val$clazz = classData;
                        this.val$methodNameToVisit = string;
                        super(methodVisitor);
                    }

                    public void visitCode() {
                        this._ALOAD(0);
                        String enterLeaveDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(InstrumentableClosure.class)});
                        this._INVOKESTATIC(Type.getType(InstrumentedClosuresHelper.class).getInternalName(), "enterInstrumentedClosure", enterLeaveDescriptor, false);
                        Label tryBlockStart = new Label();
                        Label tryBlockEnd = new Label();
                        Label catchBlockStart = new Label();
                        this.mv.visitTryCatchBlock(tryBlockStart, tryBlockEnd, catchBlockStart, "java/lang/Throwable");
                        this.mv.visitLabel(tryBlockStart);
                        this._ALOAD(0);
                        Type[] argumentTypes = Type.getArgumentTypes((String)this.val$methodData.descriptor);
                        for (int argIndex = 1; argIndex <= argumentTypes.length; ++argIndex) {
                            this.visitVarInsn(argumentTypes[argIndex - 1].getOpcode(21), argIndex);
                        }
                        this._INVOKESPECIAL(this.val$clazz.className, this.val$methodNameToVisit, this.val$methodData.descriptor, false);
                        this.mv.visitLabel(tryBlockEnd);
                        this._ALOAD(0);
                        this._INVOKESTATIC(Type.getType(InstrumentedClosuresHelper.class).getInternalName(), "leaveInstrumentedClosure", enterLeaveDescriptor, false);
                        this.visitInsn(Type.getReturnType((String)this.val$methodData.descriptor).getOpcode(172));
                        this.mv.visitLabel(catchBlockStart);
                        Object[] locals = new Object[]{this.val$clazz.className.replaceAll("\\.", "/")};
                        this.mv.visitFrame(-1, 1, locals, 1, new Object[]{"java/lang/Throwable"});
                        this._ALOAD(0);
                        this._INVOKESTATIC(Type.getType(InstrumentedClosuresHelper.class).getInternalName(), "leaveInstrumentedClosure", enterLeaveDescriptor, false);
                        this.mv.visitInsn(191);
                        this.visitMaxs(argumentTypes.length * 2 + 1, argumentTypes.length + 1);
                    }
                }
                2MethodVisitorScopeImpl bridge = new 2MethodVisitorScopeImpl(clazz.visitor.visitMethod(methodData.access, methodData.name, methodData.descriptor, methodData.signature, methodData.exceptions));
                bridge.visitCode();
                bridge.visitEnd();
            }
            return original;
        }),
        ADD_MAKE_EFFECTIVELY_INSTRUMENTED_METHOD("makeEffectivelyInstrumented", "()V", true, (classData, methodData) -> {
            @NullMarked
            class 3MethodVisitorScopeImpl
            extends MethodVisitorScope {
                final /* synthetic */ ClassData val$classData;

                public 3MethodVisitorScopeImpl(MethodVisitor methodVisitor2) {
                    this.val$classData = methodVisitor2;
                    super((MethodVisitor)methodVisitor);
                }

                public void visitCode() {
                    this._ALOAD(0);
                    this._DUP();
                    this._ICONST_1();
                    this._PUTFIELD(this.val$classData.className, CallInterceptionClosureInstrumentingClassVisitor.IS_EFFECTIVELY_INSTRUMENTED_FIELD_NAME, "Z");
                    this._GETSTATIC(BYTECODE_INTERCEPTOR_FILTER_TYPE, this.val$classData.interceptorFilter.name(), BYTECODE_INTERCEPTOR_FILTER_TYPE.getDescriptor());
                    String methodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{CLOSURE_TYPE, BYTECODE_INTERCEPTOR_FILTER_TYPE});
                    this._INVOKESTATIC(Type.getType(InstrumentedGroovyMetaClassHelper.class), "addInvocationHooksToEffectivelyInstrumentClosure", methodDescriptor);
                }
            }
            return new 3MethodVisitorScopeImpl(classData.visitor.visitMethod(1, methodData.name, "()V", null, null), classData);
        }),
        DEFAULT(null, null, false, (classData, mv) -> classData.visitor.visitMethod(mv.access, mv.name, mv.descriptor, mv.signature, mv.exceptions));

        public final @Nullable String methodName;
        public final @Nullable String descriptor;
        public final boolean generateIfNotPresent;
        private final BiFunction<ClassData, MethodData, MethodVisitor> methodVisitorFactory;

        private MethodInstrumentationStrategy(String methodName, String descriptor, boolean generateIfNotPresent, BiFunction<ClassData, MethodData, MethodVisitor> methodVisitorFactory) {
            this.methodName = methodName;
            this.descriptor = descriptor;
            this.generateIfNotPresent = generateIfNotPresent;
            this.methodVisitorFactory = methodVisitorFactory;
        }

        @NullMarked
        static final class ClassData {
            public final ClassVisitor visitor;
            public final String className;
            private final BytecodeInterceptorFilter interceptorFilter;

            ClassData(ClassVisitor visitor, String className, BytecodeInterceptorFilter interceptorFilter) {
                this.visitor = visitor;
                this.className = className;
                this.interceptorFilter = interceptorFilter;
            }
        }

        @NullMarked
        static final class MethodData {
            public final int access;
            public final String name;
            public final String descriptor;
            public final @Nullable String signature;
            public final @Nullable String[] exceptions;

            public MethodData(int access, String name, String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
                this.access = access;
                this.name = name;
                this.descriptor = descriptor;
                this.signature = signature;
                this.exceptions = exceptions;
            }

            public boolean isAbstract() {
                return (this.access & 0x400) != 0;
            }
        }
    }
}

