/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __LLCSTAT_BPF_SKEL_H__
#define __LLCSTAT_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct llcstat_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *infos;
		struct bpf_map *rodata;
	} maps;
	struct {
		struct bpf_program *on_cache_miss;
		struct bpf_program *on_cache_ref;
	} progs;
	struct {
		struct bpf_link *on_cache_miss;
		struct bpf_link *on_cache_ref;
	} links;
	struct llcstat_bpf__rodata {
		bool targ_per_thread;
	} *rodata;

#ifdef __cplusplus
	static inline struct llcstat_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct llcstat_bpf *open_and_load();
	static inline int load(struct llcstat_bpf *skel);
	static inline int attach(struct llcstat_bpf *skel);
	static inline void detach(struct llcstat_bpf *skel);
	static inline void destroy(struct llcstat_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
llcstat_bpf__destroy(struct llcstat_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
llcstat_bpf__create_skeleton(struct llcstat_bpf *obj);

static inline struct llcstat_bpf *
llcstat_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct llcstat_bpf *obj;
	int err;

	obj = (struct llcstat_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = llcstat_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	llcstat_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct llcstat_bpf *
llcstat_bpf__open(void)
{
	return llcstat_bpf__open_opts(NULL);
}

static inline int
llcstat_bpf__load(struct llcstat_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct llcstat_bpf *
llcstat_bpf__open_and_load(void)
{
	struct llcstat_bpf *obj;
	int err;

	obj = llcstat_bpf__open();
	if (!obj)
		return NULL;
	err = llcstat_bpf__load(obj);
	if (err) {
		llcstat_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
llcstat_bpf__attach(struct llcstat_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
llcstat_bpf__detach(struct llcstat_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *llcstat_bpf__elf_bytes(size_t *sz);

static inline int
llcstat_bpf__create_skeleton(struct llcstat_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "llcstat_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 2;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "infos";
	map->map = &obj->maps.infos;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "llcstat_.rodata";
	map->map = &obj->maps.rodata;
	map->mmaped = (void **)&obj->rodata;

	/* programs */
	s->prog_cnt = 2;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "on_cache_miss";
	s->progs[0].prog = &obj->progs.on_cache_miss;
	s->progs[0].link = &obj->links.on_cache_miss;

	s->progs[1].name = "on_cache_ref";
	s->progs[1].prog = &obj->progs.on_cache_ref;
	s->progs[1].link = &obj->links.on_cache_ref;

	s->data = llcstat_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *llcstat_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xf0\x14\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x0e\0\
\x01\0\x79\x16\xa8\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\
\x1a\xe0\xff\0\0\0\0\x7b\x1a\xd8\xff\0\0\0\0\x7b\x1a\xd0\xff\0\0\0\0\x85\0\0\0\
\x0e\0\0\0\xbf\x01\0\0\0\0\0\0\xbf\x12\0\0\0\0\0\0\x77\x02\0\0\x20\0\0\0\x7b\
\x1a\xc8\xff\0\0\0\0\x7b\x2a\xc0\xff\0\0\0\0\x85\0\0\0\x08\0\0\0\x79\xa2\xc0\
\xff\0\0\0\0\x79\xa1\xc8\xff\0\0\0\0\x18\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\
\x33\0\0\0\0\0\0\x56\x03\x01\0\0\0\0\0\xbc\x21\0\0\0\0\0\0\x63\x2a\xf8\xff\0\0\
\0\0\x63\x0a\xf4\xff\0\0\0\0\x63\x1a\xfc\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\
\x02\0\0\xf4\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\
\0\x55\0\x10\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf4\xff\xff\xff\xbf\xa3\
\0\0\0\0\0\0\x07\x03\0\0\xd0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xb7\x04\0\0\x01\0\0\0\x85\0\0\0\x02\0\0\0\x16\0\x01\0\0\0\0\0\x56\0\x0d\0\xef\
\xff\xff\xff\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf4\xff\xff\xff\x18\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x07\0\0\0\0\0\x79\x01\x08\0\0\0\0\
\0\x0f\x61\0\0\0\0\0\0\x7b\x10\x08\0\0\0\0\0\x07\0\0\0\x10\0\0\0\xbf\x01\0\0\0\
\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\
\0\0\0\x79\x16\xa8\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\
\x1a\xe0\xff\0\0\0\0\x7b\x1a\xd8\xff\0\0\0\0\x7b\x1a\xd0\xff\0\0\0\0\x85\0\0\0\
\x0e\0\0\0\xbf\x01\0\0\0\0\0\0\xbf\x12\0\0\0\0\0\0\x77\x02\0\0\x20\0\0\0\x7b\
\x1a\xc8\xff\0\0\0\0\x7b\x2a\xc0\xff\0\0\0\0\x85\0\0\0\x08\0\0\0\x79\xa2\xc0\
\xff\0\0\0\0\x79\xa1\xc8\xff\0\0\0\0\x18\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\
\x33\0\0\0\0\0\0\x56\x03\x01\0\0\0\0\0\xbc\x21\0\0\0\0\0\0\x63\x2a\xf8\xff\0\0\
\0\0\x63\x0a\xf4\xff\0\0\0\0\x63\x1a\xfc\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\
\x02\0\0\xf4\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\
\0\x55\0\x10\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf4\xff\xff\xff\xbf\xa3\
\0\0\0\0\0\0\x07\x03\0\0\xd0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xb7\x04\0\0\x01\0\0\0\x85\0\0\0\x02\0\0\0\x16\0\x01\0\0\0\0\0\x56\0\x0d\0\xef\
\xff\xff\xff\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf4\xff\xff\xff\x18\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x07\0\0\0\0\0\x79\x01\0\0\0\0\0\0\
\x0f\x61\0\0\0\0\0\0\x7b\x10\0\0\0\0\0\0\x07\0\0\0\x10\0\0\0\xbf\x01\0\0\0\0\0\
\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\
\0\0\x47\x50\x4c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x28\x05\0\0\x28\x05\0\0\xbc\x04\0\0\
\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\
\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x01\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\
\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\
\0\0\0\0\x28\0\0\0\0\0\0\0\0\0\x02\x08\0\0\0\x19\0\0\0\x03\0\0\x04\x0c\0\0\0\
\x2a\0\0\0\x09\0\0\0\0\0\0\0\x2e\0\0\0\x09\0\0\0\x20\0\0\0\x32\0\0\0\x09\0\0\0\
\x40\0\0\0\x36\0\0\0\0\0\0\x08\x0a\0\0\0\x3c\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\
\0\0\0\0\0\0\0\0\x02\x0c\0\0\0\x49\0\0\0\x03\0\0\x04\x20\0\0\0\x5c\0\0\0\x0d\0\
\0\0\0\0\0\0\x60\0\0\0\x0d\0\0\0\x40\0\0\0\x65\0\0\0\x10\0\0\0\x80\0\0\0\x6a\0\
\0\0\0\0\0\x08\x0e\0\0\0\x70\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\x83\0\0\0\0\0\
\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x0f\0\0\0\x04\0\0\0\x10\
\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x88\0\0\0\x01\0\0\0\0\0\0\0\x8d\0\0\0\x05\
\0\0\0\x40\0\0\0\x99\0\0\0\x07\0\0\0\x80\0\0\0\x9d\0\0\0\x0b\0\0\0\xc0\0\0\0\
\xa3\0\0\0\0\0\0\x0e\x11\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x14\0\0\0\xa9\0\0\0\
\x03\0\0\x04\xb8\0\0\0\xbd\0\0\0\x15\0\0\0\0\0\0\0\xc2\0\0\0\x0d\0\0\0\x40\x05\
\0\0\xd0\0\0\0\x0d\0\0\0\x80\x05\0\0\xd5\0\0\0\0\0\0\x08\x16\0\0\0\xe8\0\0\0\
\x15\0\0\x04\xa8\0\0\0\xf0\0\0\0\x17\0\0\0\0\0\0\0\xf4\0\0\0\x17\0\0\0\x40\0\0\
\0\xf8\0\0\0\x17\0\0\0\x80\0\0\0\xfc\0\0\0\x17\0\0\0\xc0\0\0\0\0\x01\0\0\x17\0\
\0\0\0\x01\0\0\x03\x01\0\0\x17\0\0\0\x40\x01\0\0\x06\x01\0\0\x17\0\0\0\x80\x01\
\0\0\x0a\x01\0\0\x17\0\0\0\xc0\x01\0\0\x0e\x01\0\0\x17\0\0\0\0\x02\0\0\x11\x01\
\0\0\x17\0\0\0\x40\x02\0\0\x14\x01\0\0\x17\0\0\0\x80\x02\0\0\x17\x01\0\0\x17\0\
\0\0\xc0\x02\0\0\x1a\x01\0\0\x17\0\0\0\0\x03\0\0\x1d\x01\0\0\x17\0\0\0\x40\x03\
\0\0\x20\x01\0\0\x17\0\0\0\x80\x03\0\0\x23\x01\0\0\x17\0\0\0\xc0\x03\0\0\x2b\
\x01\0\0\x17\0\0\0\0\x04\0\0\0\0\0\0\x18\0\0\0\x40\x04\0\0\x2e\x01\0\0\x17\0\0\
\0\x80\x04\0\0\x34\x01\0\0\x17\0\0\0\xc0\x04\0\0\0\0\0\0\x1e\0\0\0\0\x05\0\0\
\x37\x01\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x03\0\0\x05\x08\0\0\0\x45\
\x01\0\0\x19\0\0\0\0\0\0\0\x48\x01\0\0\x1c\0\0\0\0\0\0\0\x4c\x01\0\0\x1d\0\0\0\
\0\0\0\0\x54\x01\0\0\0\0\0\x08\x1a\0\0\0\x58\x01\0\0\0\0\0\x08\x1b\0\0\0\x5e\
\x01\0\0\0\0\0\x01\x02\0\0\0\x10\0\0\0\x6d\x01\0\0\0\0\0\x08\x0d\0\0\0\x4c\x01\
\0\0\x03\0\0\x84\x08\0\0\0\x45\x01\0\0\x1c\0\0\0\0\0\0\x10\x71\x01\0\0\x1c\0\0\
\0\x10\0\0\x02\x74\x01\0\0\x1c\0\0\0\x12\0\0\x01\0\0\0\0\x03\0\0\x05\x08\0\0\0\
\x78\x01\0\0\x19\0\0\0\0\0\0\0\x7b\x01\0\0\x1c\0\0\0\0\0\0\0\x7f\x01\0\0\x1f\0\
\0\0\0\0\0\0\x7f\x01\0\0\x0a\0\0\x84\x08\0\0\0\x78\x01\0\0\x1c\0\0\0\0\0\0\x10\
\x87\x01\0\0\x1c\0\0\0\x10\0\0\x01\x8b\x01\0\0\x1c\0\0\0\x11\0\0\x01\x93\x01\0\
\0\x1c\0\0\0\x12\0\0\x01\x97\x01\0\0\x1c\0\0\0\x20\0\0\x08\x88\0\0\0\x1c\0\0\0\
\x30\0\0\x04\x9e\x01\0\0\x1c\0\0\0\x38\0\0\x01\xa6\x01\0\0\x1c\0\0\0\x39\0\0\
\x01\xa9\x01\0\0\x1c\0\0\0\x3a\0\0\x01\xb0\x01\0\0\x1c\0\0\0\x3c\0\0\x04\0\0\0\
\0\x01\0\0\x0d\x02\0\0\0\xb8\x01\0\0\x13\0\0\0\xbc\x01\0\0\x01\0\0\x0c\x20\0\0\
\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xb8\x01\0\0\x13\0\0\0\x27\x04\0\0\x01\0\0\x0c\
\x22\0\0\0\0\0\0\0\0\0\0\x0a\x25\0\0\0\0\0\0\0\0\0\0\x09\x26\0\0\0\x83\x04\0\0\
\0\0\0\x08\x27\0\0\0\x88\x04\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x04\x8e\x04\0\0\0\
\0\0\x0e\x24\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x0f\0\0\0\x04\0\0\0\x04\
\0\0\0\x9e\x04\0\0\0\0\0\x0e\x29\0\0\0\x01\0\0\0\xa6\x04\0\0\x01\0\0\x0f\0\0\0\
\0\x12\0\0\0\0\0\0\0\x20\0\0\0\xac\x04\0\0\x01\0\0\x0f\0\0\0\0\x28\0\0\0\0\0\0\
\0\x01\0\0\0\xb4\x04\0\0\x01\0\0\x0f\0\0\0\0\x2a\0\0\0\0\0\0\0\x04\0\0\0\0\x69\
\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\
\x5f\x5f\0\x6c\x6c\x63\x73\x74\x61\x74\x5f\x6b\x65\x79\x5f\x69\x6e\x66\x6f\0\
\x63\x70\x75\0\x70\x69\x64\0\x74\x69\x64\0\x5f\x5f\x75\x33\x32\0\x75\x6e\x73\
\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x6c\x6c\x63\x73\x74\x61\x74\x5f\x76\x61\
\x6c\x75\x65\x5f\x69\x6e\x66\x6f\0\x72\x65\x66\0\x6d\x69\x73\x73\0\x63\x6f\x6d\
\x6d\0\x5f\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\
\x67\x20\x6c\x6f\x6e\x67\0\x63\x68\x61\x72\0\x74\x79\x70\x65\0\x6d\x61\x78\x5f\
\x65\x6e\x74\x72\x69\x65\x73\0\x6b\x65\x79\0\x76\x61\x6c\x75\x65\0\x69\x6e\x66\
\x6f\x73\0\x62\x70\x66\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\x5f\x64\x61\
\x74\x61\0\x72\x65\x67\x73\0\x73\x61\x6d\x70\x6c\x65\x5f\x70\x65\x72\x69\x6f\
\x64\0\x61\x64\x64\x72\0\x62\x70\x66\x5f\x75\x73\x65\x72\x5f\x70\x74\x5f\x72\
\x65\x67\x73\x5f\x74\0\x70\x74\x5f\x72\x65\x67\x73\0\x72\x31\x35\0\x72\x31\x34\
\0\x72\x31\x33\0\x72\x31\x32\0\x62\x70\0\x62\x78\0\x72\x31\x31\0\x72\x31\x30\0\
\x72\x39\0\x72\x38\0\x61\x78\0\x63\x78\0\x64\x78\0\x73\x69\0\x64\x69\0\x6f\x72\
\x69\x67\x5f\x61\x78\0\x69\x70\0\x66\x6c\x61\x67\x73\0\x73\x70\0\x75\x6e\x73\
\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\0\x63\x73\0\x63\x73\x78\0\x66\x72\x65\
\x64\x5f\x63\x73\0\x75\x31\x36\0\x5f\x5f\x75\x31\x36\0\x75\x6e\x73\x69\x67\x6e\
\x65\x64\x20\x73\x68\x6f\x72\x74\0\x75\x36\x34\0\x73\x6c\0\x77\x66\x65\0\x73\
\x73\0\x73\x73\x78\0\x66\x72\x65\x64\x5f\x73\x73\0\x73\x74\x69\0\x73\x77\x65\
\x76\x65\x6e\x74\0\x6e\x6d\x69\0\x76\x65\x63\x74\x6f\x72\0\x65\x6e\x63\x6c\x61\
\x76\x65\0\x6c\x6d\0\x6e\x65\x73\x74\x65\x64\0\x69\x6e\x73\x6e\x6c\x65\x6e\0\
\x63\x74\x78\0\x6f\x6e\x5f\x63\x61\x63\x68\x65\x5f\x6d\x69\x73\x73\0\x70\x65\
\x72\x66\x5f\x65\x76\x65\x6e\x74\0\x30\x3a\x31\0\x2f\x62\x75\x69\x6c\x64\x2f\
\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\
\x74\x6f\x6f\x6c\x73\x2f\x6c\x6c\x63\x73\x74\x61\x74\x2e\x62\x70\x66\x2e\x63\0\
\x09\x72\x65\x74\x75\x72\x6e\x20\x74\x72\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\
\x28\x63\x74\x78\x2d\x3e\x73\x61\x6d\x70\x6c\x65\x5f\x70\x65\x72\x69\x6f\x64\
\x2c\x20\x74\x72\x75\x65\x29\x3b\0\x09\x73\x74\x72\x75\x63\x74\x20\x6c\x6c\x63\
\x73\x74\x61\x74\x5f\x76\x61\x6c\x75\x65\x5f\x69\x6e\x66\x6f\x20\x2a\x69\x6e\
\x66\x6f\x70\x2c\x20\x7a\x65\x72\x6f\x20\x3d\x20\x7b\x7d\x3b\0\x09\x75\x36\x34\
\x20\x70\x69\x64\x5f\x74\x67\x69\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\
\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x70\x69\x64\x5f\x74\x67\x69\x64\x28\x29\
\x3b\0\x09\x6b\x65\x79\x2e\x70\x69\x64\x20\x3d\x20\x70\x69\x64\x5f\x74\x67\x69\
\x64\x20\x3e\x3e\x20\x33\x32\x3b\0\x09\x6b\x65\x79\x2e\x63\x70\x75\x20\x3d\x20\
\x62\x70\x66\x5f\x67\x65\x74\x5f\x73\x6d\x70\x5f\x70\x72\x6f\x63\x65\x73\x73\
\x6f\x72\x5f\x69\x64\x28\x29\x3b\0\x09\x69\x66\x20\x28\x74\x61\x72\x67\x5f\x70\
\x65\x72\x5f\x74\x68\x72\x65\x61\x64\x29\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\
\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\
\x6f\x6c\x73\x2f\x2e\x2f\x6d\x61\x70\x73\x2e\x62\x70\x66\x2e\x68\0\x09\x76\x61\
\x6c\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\
\x65\x6c\x65\x6d\x28\x6d\x61\x70\x2c\x20\x6b\x65\x79\x29\x3b\0\x09\x69\x66\x20\
\x28\x76\x61\x6c\x29\0\x09\x65\x72\x72\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\
\x5f\x75\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x6d\x61\x70\x2c\x20\x6b\
\x65\x79\x2c\x20\x69\x6e\x69\x74\x2c\x20\x42\x50\x46\x5f\x4e\x4f\x45\x58\x49\
\x53\x54\x29\x3b\0\x09\x69\x66\x20\x28\x65\x72\x72\x20\x26\x26\x20\x65\x72\x72\
\x20\x21\x3d\x20\x2d\x45\x45\x58\x49\x53\x54\x29\0\x09\x72\x65\x74\x75\x72\x6e\
\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\
\x6d\x28\x6d\x61\x70\x2c\x20\x6b\x65\x79\x29\x3b\0\x09\x69\x66\x20\x28\x21\x69\
\x6e\x66\x6f\x70\x29\0\x09\x09\x69\x6e\x66\x6f\x70\x2d\x3e\x6d\x69\x73\x73\x20\
\x2b\x3d\x20\x73\x61\x6d\x70\x6c\x65\x5f\x70\x65\x72\x69\x6f\x64\x3b\0\x09\x62\
\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x63\x6f\x6d\x6d\
\x28\x69\x6e\x66\x6f\x70\x2d\x3e\x63\x6f\x6d\x6d\x2c\x20\x73\x69\x7a\x65\x6f\
\x66\x28\x69\x6e\x66\x6f\x70\x2d\x3e\x63\x6f\x6d\x6d\x29\x29\x3b\0\x6f\x6e\x5f\
\x63\x61\x63\x68\x65\x5f\x72\x65\x66\0\x09\x72\x65\x74\x75\x72\x6e\x20\x74\x72\
\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\x28\x63\x74\x78\x2d\x3e\x73\x61\x6d\x70\
\x6c\x65\x5f\x70\x65\x72\x69\x6f\x64\x2c\x20\x66\x61\x6c\x73\x65\x29\x3b\0\x09\
\x09\x69\x6e\x66\x6f\x70\x2d\x3e\x72\x65\x66\x20\x2b\x3d\x20\x73\x61\x6d\x70\
\x6c\x65\x5f\x70\x65\x72\x69\x6f\x64\x3b\0\x62\x6f\x6f\x6c\0\x5f\x42\x6f\x6f\
\x6c\0\x74\x61\x72\x67\x5f\x70\x65\x72\x5f\x74\x68\x72\x65\x61\x64\0\x4c\x49\
\x43\x45\x4e\x53\x45\0\x2e\x6d\x61\x70\x73\0\x2e\x72\x6f\x64\x61\x74\x61\0\x6c\
\x69\x63\x65\x6e\x73\x65\0\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x1c\0\0\0\x1c\0\0\0\
\x4c\x02\0\0\x68\x02\0\0\x2c\0\0\0\x08\0\0\0\xca\x01\0\0\x02\0\0\0\0\0\0\0\x21\
\0\0\0\xb0\x01\0\0\x23\0\0\0\x10\0\0\0\xca\x01\0\0\x24\0\0\0\0\0\0\0\xd9\x01\0\
\0\x07\x02\0\0\x1a\xc4\0\0\x10\0\0\0\xd9\x01\0\0\x36\x02\0\0\x24\x60\0\0\x30\0\
\0\0\xd9\x01\0\0\x64\x02\0\0\x11\x68\0\0\x40\0\0\0\xd9\x01\0\0\x90\x02\0\0\x15\
\x70\0\0\x50\0\0\0\xd9\x01\0\0\xab\x02\0\0\x0c\x6c\0\0\x78\0\0\0\xd9\x01\0\0\
\xd2\x02\0\0\x06\x74\0\0\xa0\0\0\0\xd9\x01\0\0\x90\x02\0\0\x0a\x70\0\0\xa8\0\0\
\0\xd9\x01\0\0\xab\x02\0\0\x0a\x6c\0\0\xc8\0\0\0\xe8\x02\0\0\x15\x03\0\0\x08\
\x7c\0\0\xe0\0\0\0\xe8\x02\0\0\x3b\x03\0\0\x06\x80\0\0\x08\x01\0\0\xe8\x02\0\0\
\x45\x03\0\0\x08\x8c\0\0\x28\x01\0\0\xe8\x02\0\0\x7e\x03\0\0\x0a\x90\0\0\x48\
\x01\0\0\xe8\x02\0\0\x9a\x03\0\0\x09\x9c\0\0\x60\x01\0\0\xd9\x01\0\0\xc1\x03\0\
\0\x06\x8c\0\0\x68\x01\0\0\xd9\x01\0\0\xce\x03\0\0\x0f\x98\0\0\x80\x01\0\0\xd9\
\x01\0\0\xee\x03\0\0\x1e\xa4\0\0\x88\x01\0\0\xd9\x01\0\0\xee\x03\0\0\x02\xa4\0\
\0\xa0\x01\0\0\xd9\x01\0\0\x07\x02\0\0\x02\xc4\0\0\xb0\x01\0\0\xd9\x01\0\0\x34\
\x04\0\0\x1a\xdc\0\0\xc0\x01\0\0\xd9\x01\0\0\x36\x02\0\0\x24\x60\0\0\xe0\x01\0\
\0\xd9\x01\0\0\x64\x02\0\0\x11\x68\0\0\xf0\x01\0\0\xd9\x01\0\0\x90\x02\0\0\x15\
\x70\0\0\0\x02\0\0\xd9\x01\0\0\xab\x02\0\0\x0c\x6c\0\0\x28\x02\0\0\xd9\x01\0\0\
\xd2\x02\0\0\x06\x74\0\0\x50\x02\0\0\xd9\x01\0\0\x90\x02\0\0\x0a\x70\0\0\x58\
\x02\0\0\xd9\x01\0\0\xab\x02\0\0\x0a\x6c\0\0\x78\x02\0\0\xe8\x02\0\0\x15\x03\0\
\0\x08\x7c\0\0\x90\x02\0\0\xe8\x02\0\0\x3b\x03\0\0\x06\x80\0\0\xb8\x02\0\0\xe8\
\x02\0\0\x45\x03\0\0\x08\x8c\0\0\xd8\x02\0\0\xe8\x02\0\0\x7e\x03\0\0\x0a\x90\0\
\0\xf8\x02\0\0\xe8\x02\0\0\x9a\x03\0\0\x09\x9c\0\0\x10\x03\0\0\xd9\x01\0\0\xc1\
\x03\0\0\x06\x8c\0\0\x18\x03\0\0\xd9\x01\0\0\x64\x04\0\0\x0e\xa0\0\0\x30\x03\0\
\0\xd9\x01\0\0\xee\x03\0\0\x1e\xa4\0\0\x38\x03\0\0\xd9\x01\0\0\xee\x03\0\0\x02\
\xa4\0\0\x50\x03\0\0\xd9\x01\0\0\x34\x04\0\0\x02\xdc\0\0\x10\0\0\0\xca\x01\0\0\
\x02\0\0\0\0\0\0\0\x14\0\0\0\xd5\x01\0\0\0\0\0\0\xb0\x01\0\0\x14\0\0\0\xd5\x01\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x23\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\xb0\
\x01\0\0\0\0\0\0\x60\0\0\0\x11\0\x05\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x37\0\
\0\0\x11\0\x07\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x4b\0\0\0\x12\0\x03\0\xb0\
\x01\0\0\0\0\0\0\xb0\x01\0\0\0\0\0\0\x91\0\0\0\x11\0\x06\0\0\0\0\0\0\0\0\0\x04\
\0\0\0\0\0\0\0\x78\0\0\0\0\0\0\0\x01\0\0\0\x03\0\0\0\xc8\0\0\0\0\0\0\0\x01\0\0\
\0\x04\0\0\0\x08\x01\0\0\0\0\0\0\x01\0\0\0\x04\0\0\0\x48\x01\0\0\0\0\0\0\x01\0\
\0\0\x04\0\0\0\x28\x02\0\0\0\0\0\0\x01\0\0\0\x03\0\0\0\x78\x02\0\0\0\0\0\0\x01\
\0\0\0\x04\0\0\0\xb8\x02\0\0\0\0\0\0\x01\0\0\0\x04\0\0\0\xf8\x02\0\0\0\0\0\0\
\x01\0\0\0\x04\0\0\0\x08\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x20\x05\0\0\0\0\0\
\0\x03\0\0\0\x03\0\0\0\x38\x05\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x2c\0\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x34\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x48\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x58\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x68\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x78\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x88\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x98\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa8\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xb8\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc8\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xd8\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe8\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xf8\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x08\x01\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x18\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x28\x01\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x38\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x48\x01\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\x58\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x68\x01\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\x78\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x88\x01\0\0\
\0\0\0\0\x04\0\0\0\x01\0\0\0\x98\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa8\x01\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb8\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc8\x01\
\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd8\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe8\
\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf8\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x08\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\
\0\x28\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x38\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\
\0\0\x48\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x58\x02\0\0\0\0\0\0\x04\0\0\0\x01\
\0\0\0\x68\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x78\x02\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x94\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa4\x02\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\x0b\x0e\x0c\x0f\x0d\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\
\x42\x54\x46\x2e\x65\x78\x74\0\x2e\x72\x65\x6c\x70\x65\x72\x66\x5f\x65\x76\x65\
\x6e\x74\0\x6f\x6e\x5f\x63\x61\x63\x68\x65\x5f\x6d\x69\x73\x73\0\x2e\x6d\x61\
\x70\x73\0\x69\x6e\x66\x6f\x73\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\
\x69\x67\0\x6f\x6e\x5f\x63\x61\x63\x68\x65\x5f\x72\x65\x66\0\x6c\x69\x63\x65\
\x6e\x73\x65\0\x74\x61\x72\x67\x5f\x70\x65\x72\x5f\x74\x68\x72\x65\x61\x64\0\
\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\x6f\x64\
\x61\x74\x61\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\0\0\0\x03\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x55\x14\0\0\0\0\0\0\x99\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x18\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\
\0\0\0\0\0\0\0\x60\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x14\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x11\0\0\0\0\0\
\0\x80\0\0\0\0\0\0\0\x0d\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x80\0\0\0\x01\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\x03\0\0\0\0\0\0\x01\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x58\0\0\0\x01\
\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa1\x03\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x31\0\0\0\x01\0\0\0\x03\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\xa8\x03\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x8c\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\xc8\x03\0\0\0\0\0\0\xfc\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x88\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xa0\x11\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x0d\0\0\0\x08\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x0b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc4\x0d\
\0\0\0\0\0\0\xb4\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x07\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd0\x11\0\0\0\0\0\0\
\x80\x02\0\0\0\0\0\0\x0d\0\0\0\x0a\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x3d\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\x50\x14\0\0\0\0\0\
\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\0\0\
\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\x10\0\0\0\0\0\0\xa8\0\0\0\0\0\
\0\0\x01\0\0\0\x02\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct llcstat_bpf *llcstat_bpf::open(const struct bpf_object_open_opts *opts) { return llcstat_bpf__open_opts(opts); }
struct llcstat_bpf *llcstat_bpf::open_and_load() { return llcstat_bpf__open_and_load(); }
int llcstat_bpf::load(struct llcstat_bpf *skel) { return llcstat_bpf__load(skel); }
int llcstat_bpf::attach(struct llcstat_bpf *skel) { return llcstat_bpf__attach(skel); }
void llcstat_bpf::detach(struct llcstat_bpf *skel) { llcstat_bpf__detach(skel); }
void llcstat_bpf::destroy(struct llcstat_bpf *skel) { llcstat_bpf__destroy(skel); }
const void *llcstat_bpf::elf_bytes(size_t *sz) { return llcstat_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
llcstat_bpf__assert(struct llcstat_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->rodata->targ_per_thread) == 1, "unexpected size of 'targ_per_thread'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __LLCSTAT_BPF_SKEL_H__ */
