/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __DRSNOOP_BPF_SKEL_H__
#define __DRSNOOP_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct drsnoop_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *start;
		struct bpf_map *events;
		struct bpf_map *rodata;
	} maps;
	struct {
		struct bpf_program *direct_reclaim_begin_btf;
		struct bpf_program *direct_reclaim_end_btf;
		struct bpf_program *direct_reclaim_begin;
		struct bpf_program *direct_reclaim_end;
	} progs;
	struct {
		struct bpf_link *direct_reclaim_begin_btf;
		struct bpf_link *direct_reclaim_end_btf;
		struct bpf_link *direct_reclaim_begin;
		struct bpf_link *direct_reclaim_end;
	} links;
	struct drsnoop_bpf__rodata {
		pid_t targ_pid;
		pid_t targ_tgid;
		__u64 vm_zone_stat_kaddr;
	} *rodata;

#ifdef __cplusplus
	static inline struct drsnoop_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct drsnoop_bpf *open_and_load();
	static inline int load(struct drsnoop_bpf *skel);
	static inline int attach(struct drsnoop_bpf *skel);
	static inline void detach(struct drsnoop_bpf *skel);
	static inline void destroy(struct drsnoop_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
drsnoop_bpf__destroy(struct drsnoop_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
drsnoop_bpf__create_skeleton(struct drsnoop_bpf *obj);

static inline struct drsnoop_bpf *
drsnoop_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct drsnoop_bpf *obj;
	int err;

	obj = (struct drsnoop_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = drsnoop_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	drsnoop_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct drsnoop_bpf *
drsnoop_bpf__open(void)
{
	return drsnoop_bpf__open_opts(NULL);
}

static inline int
drsnoop_bpf__load(struct drsnoop_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct drsnoop_bpf *
drsnoop_bpf__open_and_load(void)
{
	struct drsnoop_bpf *obj;
	int err;

	obj = drsnoop_bpf__open();
	if (!obj)
		return NULL;
	err = drsnoop_bpf__load(obj);
	if (err) {
		drsnoop_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
drsnoop_bpf__attach(struct drsnoop_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
drsnoop_bpf__detach(struct drsnoop_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *drsnoop_bpf__elf_bytes(size_t *sz);

static inline int
drsnoop_bpf__create_skeleton(struct drsnoop_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "drsnoop_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 3;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "start";
	map->map = &obj->maps.start;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "events";
	map->map = &obj->maps.events;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 2 * s->map_skel_sz);
	map->name = "drsnoop_.rodata";
	map->map = &obj->maps.rodata;
	map->mmaped = (void **)&obj->rodata;

	/* programs */
	s->prog_cnt = 4;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "direct_reclaim_begin_btf";
	s->progs[0].prog = &obj->progs.direct_reclaim_begin_btf;
	s->progs[0].link = &obj->links.direct_reclaim_begin_btf;

	s->progs[1].name = "direct_reclaim_end_btf";
	s->progs[1].prog = &obj->progs.direct_reclaim_end_btf;
	s->progs[1].link = &obj->links.direct_reclaim_end_btf;

	s->progs[2].name = "direct_reclaim_begin";
	s->progs[2].prog = &obj->progs.direct_reclaim_begin;
	s->progs[2].link = &obj->links.direct_reclaim_begin;

	s->progs[3].name = "direct_reclaim_end";
	s->progs[3].prog = &obj->progs.direct_reclaim_end;
	s->progs[3].link = &obj->links.direct_reclaim_end;

	s->data = drsnoop_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *drsnoop_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x40\x22\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x14\0\
\x01\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x79\x16\0\0\0\0\0\0\x85\0\0\0\x0e\0\
\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\xbc\x01\0\0\0\0\0\0\x63\x1a\
\xec\xff\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x23\0\0\0\0\0\0\x16\
\x03\x03\0\0\0\0\0\x61\x22\0\0\0\0\0\0\x77\0\0\0\x20\0\0\0\x5e\x02\x16\0\0\0\0\
\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x23\0\0\0\0\0\0\x16\x03\x02\0\0\0\0\
\0\x61\x22\0\0\0\0\0\0\x5e\x12\x10\0\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\xf0\
\xff\0\0\0\0\x15\x06\x05\0\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\xf8\xff\xff\
\xff\xb4\x02\0\0\x08\0\0\0\xbf\x63\0\0\0\0\0\0\x85\0\0\0\x71\0\0\0\xbf\xa2\0\0\
\0\0\0\0\x07\x02\0\0\xec\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\xff\
\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\
\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\0\0\0\0\0\x79\x68\0\0\0\0\
\0\0\x85\0\0\0\x0e\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\0\x7b\x1a\
\xf0\xff\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\x7b\x1a\xd8\
\xff\0\0\0\0\x7b\x1a\xd0\xff\0\0\0\0\xbc\x01\0\0\0\0\0\0\x63\x1a\xcc\xff\0\0\0\
\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x23\0\0\0\0\0\0\x16\x03\x03\0\0\0\0\
\0\x61\x22\0\0\0\0\0\0\x77\0\0\0\x20\0\0\0\x5e\x02\x29\0\0\0\0\0\x18\x02\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x61\x23\0\0\0\0\0\0\x16\x03\x02\0\0\0\0\0\x61\x22\0\0\0\
\0\0\0\x5e\x12\x23\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xcc\xff\xff\xff\
\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\xbf\x07\0\0\0\0\0\0\
\x15\x07\x1c\0\0\0\0\0\x85\0\0\0\x05\0\0\0\x79\x71\0\0\0\0\0\0\x1f\x10\0\0\0\0\
\0\0\xc5\0\x13\0\0\0\0\0\x61\xa1\xcc\xff\0\0\0\0\x63\x1a\xf8\xff\0\0\0\0\x7b\
\x8a\xe8\xff\0\0\0\0\x7b\x0a\xe0\xff\0\0\0\0\x79\x71\x08\0\0\0\0\0\x7b\x1a\xf0\
\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\x07\0\0\xd0\xff\xff\xff\xbf\x71\0\0\0\0\0\
\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xbf\x74\0\0\
\0\0\0\0\xb7\x05\0\0\x30\0\0\0\x85\0\0\0\x19\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\
\0\0\xcc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x03\0\0\0\
\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x79\
\x16\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf8\xff\0\0\0\
\0\xbc\x01\0\0\0\0\0\0\x63\x1a\xec\xff\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x61\x23\0\0\0\0\0\0\x16\x03\x03\0\0\0\0\0\x61\x22\0\0\0\0\0\0\x77\0\0\0\
\x20\0\0\0\x5e\x02\x16\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x23\0\
\0\0\0\0\0\x16\x03\x02\0\0\0\0\0\x61\x22\0\0\0\0\0\0\x5e\x12\x10\0\0\0\0\0\x85\
\0\0\0\x05\0\0\0\x7b\x0a\xf0\xff\0\0\0\0\x15\x06\x05\0\0\0\0\0\xbf\xa1\0\0\0\0\
\0\0\x07\x01\0\0\xf8\xff\xff\xff\xb4\x02\0\0\x08\0\0\0\xbf\x63\0\0\0\0\0\0\x85\
\0\0\0\x71\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xec\xff\xff\xff\xbf\xa3\0\0\0\
\0\0\0\x07\x03\0\0\xf0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\
\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\
\0\0\0\0\0\x79\x68\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\
\xf8\xff\0\0\0\0\x7b\x1a\xf0\xff\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\x1a\xe0\
\xff\0\0\0\0\x7b\x1a\xd8\xff\0\0\0\0\x7b\x1a\xd0\xff\0\0\0\0\xbc\x01\0\0\0\0\0\
\0\x63\x1a\xcc\xff\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x23\0\0\0\0\
\0\0\x16\x03\x03\0\0\0\0\0\x61\x22\0\0\0\0\0\0\x77\0\0\0\x20\0\0\0\x5e\x02\x29\
\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x23\0\0\0\0\0\0\x16\x03\x02\
\0\0\0\0\0\x61\x22\0\0\0\0\0\0\x5e\x12\x23\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\
\x02\0\0\xcc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\
\0\xbf\x07\0\0\0\0\0\0\x15\x07\x1c\0\0\0\0\0\x85\0\0\0\x05\0\0\0\x79\x71\0\0\0\
\0\0\0\x1f\x10\0\0\0\0\0\0\xc5\0\x13\0\0\0\0\0\x61\xa1\xcc\xff\0\0\0\0\x63\x1a\
\xf8\xff\0\0\0\0\x7b\x8a\xe8\xff\0\0\0\0\x7b\x0a\xe0\xff\0\0\0\0\x79\x71\x08\0\
\0\0\0\0\x7b\x1a\xf0\xff\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\x07\0\0\xd0\xff\xff\
\xff\xbf\x71\0\0\0\0\0\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\xbf\x61\0\0\
\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\
\0\0\0\0\0\xbf\x74\0\0\0\0\0\0\xb7\x05\0\0\x30\0\0\0\x85\0\0\0\x19\0\0\0\xbf\
\xa2\0\0\0\0\0\0\x07\x02\0\0\xcc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x85\0\0\0\x03\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x47\x50\x4c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9f\xeb\
\x01\0\x18\0\0\0\0\0\0\0\x4c\x03\0\0\x4c\x03\0\0\x17\x06\0\0\0\0\0\0\0\0\0\x02\
\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\
\x02\0\0\0\x04\0\0\0\x01\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\
\0\0\0\x02\x06\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\0\x20\0\0\0\
\0\0\0\0\0\0\x02\x08\0\0\0\x19\0\0\0\0\0\0\x08\x09\0\0\0\x1d\0\0\0\0\0\0\x08\
\x0a\0\0\0\x23\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x0c\0\0\0\
\x30\0\0\0\x02\0\0\x04\x10\0\0\0\x38\0\0\0\x0d\0\0\0\0\0\0\0\x3b\0\0\0\x0d\0\0\
\0\x40\0\0\0\x49\0\0\0\0\0\0\x08\x0e\0\0\0\x4d\0\0\0\0\0\0\x08\x0f\0\0\0\x53\0\
\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x66\0\0\0\x01\
\0\0\0\0\0\0\0\x6b\0\0\0\x05\0\0\0\x40\0\0\0\x77\0\0\0\x07\0\0\0\x80\0\0\0\x7b\
\0\0\0\x0b\0\0\0\xc0\0\0\0\x81\0\0\0\0\0\0\x0e\x10\0\0\0\x01\0\0\0\0\0\0\0\0\0\
\0\x02\x13\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x04\0\0\0\0\0\0\
\0\x03\0\0\x04\x18\0\0\0\x66\0\0\0\x12\0\0\0\0\0\0\0\x87\0\0\0\x12\0\0\0\x40\0\
\0\0\x90\0\0\0\x12\0\0\0\x80\0\0\0\x9b\0\0\0\0\0\0\x0e\x14\0\0\0\x01\0\0\0\0\0\
\0\0\0\0\0\x02\x0f\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xa2\0\0\0\x16\0\0\0\xa6\
\0\0\0\x01\0\0\x0c\x17\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xa2\0\0\0\x16\0\0\0\
\xbf\x02\0\0\x01\0\0\x0c\x19\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xa2\0\0\0\x16\
\0\0\0\xe7\x04\0\0\x01\0\0\x0c\x1b\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xa2\0\0\
\0\x16\0\0\0\x45\x05\0\0\x01\0\0\x0c\x1d\0\0\0\0\0\0\0\0\0\0\x0a\x20\0\0\0\0\0\
\0\0\0\0\0\x09\x21\0\0\0\xb9\x05\0\0\0\0\0\x08\x22\0\0\0\xbf\x05\0\0\0\0\0\x08\
\x02\0\0\0\xce\x05\0\0\0\0\0\x0e\x1f\0\0\0\x01\0\0\0\xd7\x05\0\0\0\0\0\x0e\x1f\
\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x26\0\0\0\0\0\0\0\0\0\0\x09\x0e\0\0\0\xe1\
\x05\0\0\0\0\0\x0e\x25\0\0\0\x01\0\0\0\xf4\x05\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\
\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x28\0\0\0\x04\0\0\0\x04\0\0\0\xf9\x05\0\0\0\0\0\
\x0e\x29\0\0\0\x01\0\0\0\x01\x06\0\0\x02\0\0\x0f\0\0\0\0\x11\0\0\0\0\0\0\0\x20\
\0\0\0\x15\0\0\0\0\0\0\0\x18\0\0\0\x07\x06\0\0\x03\0\0\x0f\0\0\0\0\x23\0\0\0\0\
\0\0\0\x04\0\0\0\x24\0\0\0\0\0\0\0\x04\0\0\0\x27\0\0\0\0\0\0\0\x08\0\0\0\x0f\
\x06\0\0\x01\0\0\x0f\0\0\0\0\x2a\0\0\0\0\0\0\0\x04\0\0\0\0\x69\x6e\x74\0\x5f\
\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x75\
\x33\x32\0\x5f\x5f\x75\x33\x32\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\
\x74\0\x70\x69\x64\x64\x61\x74\x61\0\x74\x73\0\x6e\x72\x5f\x66\x72\x65\x65\x5f\
\x70\x61\x67\x65\x73\0\x75\x36\x34\0\x5f\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\
\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x74\x79\x70\x65\0\x6d\
\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\x6b\x65\x79\0\x76\x61\x6c\x75\x65\0\
\x73\x74\x61\x72\x74\0\x6b\x65\x79\x5f\x73\x69\x7a\x65\0\x76\x61\x6c\x75\x65\
\x5f\x73\x69\x7a\x65\0\x65\x76\x65\x6e\x74\x73\0\x63\x74\x78\0\x64\x69\x72\x65\
\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x62\x65\x67\x69\x6e\x5f\x62\x74\
\x66\0\x74\x70\x5f\x62\x74\x66\x2f\x6d\x6d\x5f\x76\x6d\x73\x63\x61\x6e\x5f\x64\
\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x62\x65\x67\x69\x6e\0\
\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\
\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x64\x72\x73\x6e\x6f\x6f\
\x70\x2e\x62\x70\x66\x2e\x63\0\x09\x75\x36\x34\x20\x2a\x76\x6d\x5f\x7a\x6f\x6e\
\x65\x5f\x73\x74\x61\x74\x5f\x6b\x61\x64\x64\x72\x70\x20\x3d\x20\x28\x75\x36\
\x34\x2a\x29\x76\x6d\x5f\x7a\x6f\x6e\x65\x5f\x73\x74\x61\x74\x5f\x6b\x61\x64\
\x64\x72\x3b\0\x09\x75\x36\x34\x20\x69\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\
\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x70\x69\x64\x5f\x74\x67\x69\x64\x28\
\x29\x3b\0\x09\x73\x74\x72\x75\x63\x74\x20\x70\x69\x64\x64\x61\x74\x61\x20\x70\
\x69\x64\x64\x61\x74\x61\x20\x3d\x20\x7b\x7d\x3b\0\x09\x75\x33\x32\x20\x70\x69\
\x64\x20\x3d\x20\x69\x64\x3b\0\x09\x69\x66\x20\x28\x74\x61\x72\x67\x5f\x74\x67\
\x69\x64\x20\x26\x26\x20\x74\x61\x72\x67\x5f\x74\x67\x69\x64\x20\x21\x3d\x20\
\x74\x67\x69\x64\x29\0\x09\x75\x33\x32\x20\x74\x67\x69\x64\x20\x3d\x20\x69\x64\
\x20\x3e\x3e\x20\x33\x32\x3b\0\x09\x69\x66\x20\x28\x74\x61\x72\x67\x5f\x70\x69\
\x64\x20\x26\x26\x20\x74\x61\x72\x67\x5f\x70\x69\x64\x20\x21\x3d\x20\x70\x69\
\x64\x29\0\x09\x70\x69\x64\x64\x61\x74\x61\x2e\x74\x73\x20\x3d\x20\x62\x70\x66\
\x5f\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\x73\x28\x29\x3b\0\x09\x69\x66\
\x20\x28\x76\x6d\x5f\x7a\x6f\x6e\x65\x5f\x73\x74\x61\x74\x5f\x6b\x61\x64\x64\
\x72\x70\x29\x20\x7b\0\x09\x09\x62\x70\x66\x5f\x70\x72\x6f\x62\x65\x5f\x72\x65\
\x61\x64\x5f\x6b\x65\x72\x6e\x65\x6c\x28\x26\x70\x69\x64\x64\x61\x74\x61\x2e\
\x6e\x72\x5f\x66\x72\x65\x65\x5f\x70\x61\x67\x65\x73\x2c\0\x09\x62\x70\x66\x5f\
\x6d\x61\x70\x5f\x75\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\
\x61\x72\x74\x2c\x20\x26\x70\x69\x64\x2c\x20\x26\x70\x69\x64\x64\x61\x74\x61\
\x2c\x20\x30\x29\x3b\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x64\
\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x62\x65\x67\x69\x6e\
\x5f\x62\x74\x66\x29\0\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\
\x5f\x65\x6e\x64\x5f\x62\x74\x66\0\x74\x70\x5f\x62\x74\x66\x2f\x6d\x6d\x5f\x76\
\x6d\x73\x63\x61\x6e\x5f\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\
\x6d\x5f\x65\x6e\x64\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x64\
\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x65\x6e\x64\x5f\x62\
\x74\x66\x2c\x20\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6e\
\x72\x5f\x72\x65\x63\x6c\x61\x69\x6d\x65\x64\x29\0\x09\x73\x74\x72\x75\x63\x74\
\x20\x65\x76\x65\x6e\x74\x20\x65\x76\x65\x6e\x74\x20\x3d\x20\x7b\x7d\x3b\0\x09\
\x70\x69\x64\x64\x61\x74\x61\x70\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\
\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x2c\
\x20\x26\x70\x69\x64\x29\x3b\0\x09\x69\x66\x20\x28\x21\x70\x69\x64\x64\x61\x74\
\x61\x70\x29\0\x09\x64\x65\x6c\x74\x61\x5f\x6e\x73\x20\x3d\x20\x62\x70\x66\x5f\
\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\x73\x28\x29\x20\x2d\x20\x70\x69\
\x64\x64\x61\x74\x61\x70\x2d\x3e\x74\x73\x3b\0\x09\x69\x66\x20\x28\x64\x65\x6c\
\x74\x61\x5f\x6e\x73\x20\x3c\x20\x30\x29\0\x09\x65\x76\x65\x6e\x74\x2e\x70\x69\
\x64\x20\x3d\x20\x70\x69\x64\x3b\0\x09\x65\x76\x65\x6e\x74\x2e\x6e\x72\x5f\x72\
\x65\x63\x6c\x61\x69\x6d\x65\x64\x20\x3d\x20\x6e\x72\x5f\x72\x65\x63\x6c\x61\
\x69\x6d\x65\x64\x3b\0\x09\x65\x76\x65\x6e\x74\x2e\x64\x65\x6c\x74\x61\x5f\x6e\
\x73\x20\x3d\x20\x64\x65\x6c\x74\x61\x5f\x6e\x73\x3b\0\x09\x65\x76\x65\x6e\x74\
\x2e\x6e\x72\x5f\x66\x72\x65\x65\x5f\x70\x61\x67\x65\x73\x20\x3d\x20\x70\x69\
\x64\x64\x61\x74\x61\x70\x2d\x3e\x6e\x72\x5f\x66\x72\x65\x65\x5f\x70\x61\x67\
\x65\x73\x3b\0\x09\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\
\x5f\x63\x6f\x6d\x6d\x28\x26\x65\x76\x65\x6e\x74\x2e\x74\x61\x73\x6b\x2c\x20\
\x54\x41\x53\x4b\x5f\x43\x4f\x4d\x4d\x5f\x4c\x45\x4e\x29\x3b\0\x09\x62\x70\x66\
\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\x5f\x6f\x75\x74\x70\x75\x74\x28\
\x63\x74\x78\x2c\x20\x26\x65\x76\x65\x6e\x74\x73\x2c\x20\x42\x50\x46\x5f\x46\
\x5f\x43\x55\x52\x52\x45\x4e\x54\x5f\x43\x50\x55\x2c\0\x09\x62\x70\x66\x5f\x6d\
\x61\x70\x5f\x64\x65\x6c\x65\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\x61\
\x72\x74\x2c\x20\x26\x70\x69\x64\x29\x3b\0\x64\x69\x72\x65\x63\x74\x5f\x72\x65\
\x63\x6c\x61\x69\x6d\x5f\x62\x65\x67\x69\x6e\0\x72\x61\x77\x5f\x74\x70\x2f\x6d\
\x6d\x5f\x76\x6d\x73\x63\x61\x6e\x5f\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\
\x6c\x61\x69\x6d\x5f\x62\x65\x67\x69\x6e\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\
\x52\x4f\x47\x28\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\
\x62\x65\x67\x69\x6e\x29\0\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\
\x6d\x5f\x65\x6e\x64\0\x72\x61\x77\x5f\x74\x70\x2f\x6d\x6d\x5f\x76\x6d\x73\x63\
\x61\x6e\x5f\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x65\
\x6e\x64\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x64\x69\x72\x65\
\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x65\x6e\x64\x2c\x20\x75\x6e\x73\
\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6e\x72\x5f\x72\x65\x63\x6c\x61\
\x69\x6d\x65\x64\x29\0\x70\x69\x64\x5f\x74\0\x5f\x5f\x6b\x65\x72\x6e\x65\x6c\
\x5f\x70\x69\x64\x5f\x74\0\x74\x61\x72\x67\x5f\x70\x69\x64\0\x74\x61\x72\x67\
\x5f\x74\x67\x69\x64\0\x76\x6d\x5f\x7a\x6f\x6e\x65\x5f\x73\x74\x61\x74\x5f\x6b\
\x61\x64\x64\x72\0\x63\x68\x61\x72\0\x4c\x49\x43\x45\x4e\x53\x45\0\x2e\x6d\x61\
\x70\x73\0\x2e\x72\x6f\x64\x61\x74\x61\0\x6c\x69\x63\x65\x6e\x73\x65\0\0\x9f\
\xeb\x01\0\x20\0\0\0\0\0\0\0\x44\0\0\0\x44\0\0\0\x84\x06\0\0\xc8\x06\0\0\0\0\0\
\0\x08\0\0\0\xbf\0\0\0\x01\0\0\0\0\0\0\0\x18\0\0\0\xd6\x02\0\0\x01\0\0\0\0\0\0\
\0\x1a\0\0\0\xfc\x04\0\0\x01\0\0\0\0\0\0\0\x1c\0\0\0\x58\x05\0\0\x01\0\0\0\0\0\
\0\0\x1e\0\0\0\x10\0\0\0\xbf\0\0\0\x14\0\0\0\0\0\0\0\xe5\0\0\0\x13\x01\0\0\x23\
\x80\0\0\x18\0\0\0\xe5\0\0\0\x49\x01\0\0\x0b\x84\0\0\x28\0\0\0\xe5\0\0\0\x6f\
\x01\0\0\x11\x88\0\0\x30\0\0\0\xe5\0\0\0\x8d\x01\0\0\x0c\x90\0\0\x38\0\0\0\xe5\
\0\0\0\x8d\x01\0\0\x06\x90\0\0\x40\0\0\0\xe5\0\0\0\x9c\x01\0\0\x06\x98\0\0\x58\
\0\0\0\xe5\0\0\0\x9c\x01\0\0\x10\x98\0\0\x60\0\0\0\xe5\0\0\0\x9c\x01\0\0\x13\
\x98\0\0\x68\0\0\0\xe5\0\0\0\xc1\x01\0\0\x10\x8c\0\0\x70\0\0\0\xe5\0\0\0\x9c\
\x01\0\0\x10\x98\0\0\x78\0\0\0\xe5\0\0\0\xd7\x01\0\0\x06\xa0\0\0\x90\0\0\0\xe5\
\0\0\0\xd7\x01\0\0\x0f\xa0\0\0\x98\0\0\0\xe5\0\0\0\xd7\x01\0\0\x12\xa0\0\0\xa0\
\0\0\0\xe5\0\0\0\xd7\x01\0\0\x0f\xa0\0\0\xa8\0\0\0\xe5\0\0\0\xf9\x01\0\0\x0f\
\xac\0\0\xb0\0\0\0\xe5\0\0\0\xf9\x01\0\0\x0d\xac\0\0\xb8\0\0\0\xe5\0\0\0\x1b\
\x02\0\0\x06\xb0\0\0\xd0\0\0\0\xe5\0\0\0\x37\x02\0\0\x03\xb4\0\0\x08\x01\0\0\
\xe5\0\0\0\x67\x02\0\0\x02\xc8\0\0\x28\x01\0\0\xe5\0\0\0\x98\x02\0\0\x05\x74\
\x01\0\xd6\x02\0\0\x1f\0\0\0\0\0\0\0\xe5\0\0\0\xfa\x02\0\0\0\x8c\x01\0\x08\0\0\
\0\xe5\0\0\0\xfa\x02\0\0\x05\x8c\x01\0\x10\0\0\0\xe5\0\0\0\x49\x01\0\0\x0b\xe0\
\0\0\x20\0\0\0\xe5\0\0\0\x3b\x03\0\0\x0f\xe8\0\0\x50\0\0\0\xe5\0\0\0\x8d\x01\0\
\0\x0c\xf0\0\0\x58\0\0\0\xe5\0\0\0\x8d\x01\0\0\x06\xf0\0\0\x60\0\0\0\xe5\0\0\0\
\x9c\x01\0\0\x06\xfc\0\0\x78\0\0\0\xe5\0\0\0\x9c\x01\0\0\x10\xfc\0\0\x80\0\0\0\
\xe5\0\0\0\x9c\x01\0\0\x13\xfc\0\0\x88\0\0\0\xe5\0\0\0\xc1\x01\0\0\x10\xec\0\0\
\x90\0\0\0\xe5\0\0\0\x9c\x01\0\0\x10\xfc\0\0\x98\0\0\0\xe5\0\0\0\xd7\x01\0\0\
\x06\x04\x01\0\xb0\0\0\0\xe5\0\0\0\xd7\x01\0\0\x0f\x04\x01\0\xb8\0\0\0\xe5\0\0\
\0\xd7\x01\0\0\x12\x04\x01\0\xc0\0\0\0\xe5\0\0\0\xd7\x01\0\0\x0f\x04\x01\0\xd8\
\0\0\0\xe5\0\0\0\x55\x03\0\0\x0d\x14\x01\0\xf8\0\0\0\xe5\0\0\0\x84\x03\0\0\x06\
\x18\x01\0\0\x01\0\0\xe5\0\0\0\x94\x03\0\0\x0d\x24\x01\0\x08\x01\0\0\xe5\0\0\0\
\x94\x03\0\0\x2c\x24\x01\0\x10\x01\0\0\xe5\0\0\0\x94\x03\0\0\x20\x24\x01\0\x18\
\x01\0\0\xe5\0\0\0\xc3\x03\0\0\x0f\x28\x01\0\x20\x01\0\0\xe5\0\0\0\xd6\x03\0\0\
\x0e\x34\x01\0\x28\x01\0\0\xe5\0\0\0\xd6\x03\0\0\x0c\x34\x01\0\x30\x01\0\0\xe5\
\0\0\0\xe8\x03\0\0\x15\x38\x01\0\x38\x01\0\0\xe5\0\0\0\x0c\x04\0\0\x11\x3c\x01\
\0\x40\x01\0\0\xe5\0\0\0\x28\x04\0\0\x22\x40\x01\0\x48\x01\0\0\xe5\0\0\0\x28\
\x04\0\0\x16\x40\x01\0\x60\x01\0\0\xe5\0\0\0\x58\x04\0\0\x02\x44\x01\0\x78\x01\
\0\0\xe5\0\0\0\x8b\x04\0\0\x02\x50\x01\0\xc8\x01\0\0\xe5\0\0\0\xc3\x04\0\0\x02\
\x60\x01\0\xe0\x01\0\0\xe5\0\0\0\xfa\x02\0\0\x05\x8c\x01\0\xfc\x04\0\0\x14\0\0\
\0\0\0\0\0\xe5\0\0\0\x13\x01\0\0\x23\x80\0\0\x18\0\0\0\xe5\0\0\0\x49\x01\0\0\
\x0b\x84\0\0\x28\0\0\0\xe5\0\0\0\x6f\x01\0\0\x11\x88\0\0\x30\0\0\0\xe5\0\0\0\
\x8d\x01\0\0\x0c\x90\0\0\x38\0\0\0\xe5\0\0\0\x8d\x01\0\0\x06\x90\0\0\x40\0\0\0\
\xe5\0\0\0\x9c\x01\0\0\x06\x98\0\0\x58\0\0\0\xe5\0\0\0\x9c\x01\0\0\x10\x98\0\0\
\x60\0\0\0\xe5\0\0\0\x9c\x01\0\0\x13\x98\0\0\x68\0\0\0\xe5\0\0\0\xc1\x01\0\0\
\x10\x8c\0\0\x70\0\0\0\xe5\0\0\0\x9c\x01\0\0\x10\x98\0\0\x78\0\0\0\xe5\0\0\0\
\xd7\x01\0\0\x06\xa0\0\0\x90\0\0\0\xe5\0\0\0\xd7\x01\0\0\x0f\xa0\0\0\x98\0\0\0\
\xe5\0\0\0\xd7\x01\0\0\x12\xa0\0\0\xa0\0\0\0\xe5\0\0\0\xd7\x01\0\0\x0f\xa0\0\0\
\xa8\0\0\0\xe5\0\0\0\xf9\x01\0\0\x0f\xac\0\0\xb0\0\0\0\xe5\0\0\0\xf9\x01\0\0\
\x0d\xac\0\0\xb8\0\0\0\xe5\0\0\0\x1b\x02\0\0\x06\xb0\0\0\xd0\0\0\0\xe5\0\0\0\
\x37\x02\0\0\x03\xb4\0\0\x08\x01\0\0\xe5\0\0\0\x67\x02\0\0\x02\xc8\0\0\x28\x01\
\0\0\xe5\0\0\0\x22\x05\0\0\x05\xa4\x01\0\x58\x05\0\0\x1f\0\0\0\0\0\0\0\xe5\0\0\
\0\x7c\x05\0\0\0\xbc\x01\0\x08\0\0\0\xe5\0\0\0\x7c\x05\0\0\x05\xbc\x01\0\x10\0\
\0\0\xe5\0\0\0\x49\x01\0\0\x0b\xe0\0\0\x20\0\0\0\xe5\0\0\0\x3b\x03\0\0\x0f\xe8\
\0\0\x50\0\0\0\xe5\0\0\0\x8d\x01\0\0\x0c\xf0\0\0\x58\0\0\0\xe5\0\0\0\x8d\x01\0\
\0\x06\xf0\0\0\x60\0\0\0\xe5\0\0\0\x9c\x01\0\0\x06\xfc\0\0\x78\0\0\0\xe5\0\0\0\
\x9c\x01\0\0\x10\xfc\0\0\x80\0\0\0\xe5\0\0\0\x9c\x01\0\0\x13\xfc\0\0\x88\0\0\0\
\xe5\0\0\0\xc1\x01\0\0\x10\xec\0\0\x90\0\0\0\xe5\0\0\0\x9c\x01\0\0\x10\xfc\0\0\
\x98\0\0\0\xe5\0\0\0\xd7\x01\0\0\x06\x04\x01\0\xb0\0\0\0\xe5\0\0\0\xd7\x01\0\0\
\x0f\x04\x01\0\xb8\0\0\0\xe5\0\0\0\xd7\x01\0\0\x12\x04\x01\0\xc0\0\0\0\xe5\0\0\
\0\xd7\x01\0\0\x0f\x04\x01\0\xd8\0\0\0\xe5\0\0\0\x55\x03\0\0\x0d\x14\x01\0\xf8\
\0\0\0\xe5\0\0\0\x84\x03\0\0\x06\x18\x01\0\0\x01\0\0\xe5\0\0\0\x94\x03\0\0\x0d\
\x24\x01\0\x08\x01\0\0\xe5\0\0\0\x94\x03\0\0\x2c\x24\x01\0\x10\x01\0\0\xe5\0\0\
\0\x94\x03\0\0\x20\x24\x01\0\x18\x01\0\0\xe5\0\0\0\xc3\x03\0\0\x0f\x28\x01\0\
\x20\x01\0\0\xe5\0\0\0\xd6\x03\0\0\x0e\x34\x01\0\x28\x01\0\0\xe5\0\0\0\xd6\x03\
\0\0\x0c\x34\x01\0\x30\x01\0\0\xe5\0\0\0\xe8\x03\0\0\x15\x38\x01\0\x38\x01\0\0\
\xe5\0\0\0\x0c\x04\0\0\x11\x3c\x01\0\x40\x01\0\0\xe5\0\0\0\x28\x04\0\0\x22\x40\
\x01\0\x48\x01\0\0\xe5\0\0\0\x28\x04\0\0\x16\x40\x01\0\x60\x01\0\0\xe5\0\0\0\
\x58\x04\0\0\x02\x44\x01\0\x78\x01\0\0\xe5\0\0\0\x8b\x04\0\0\x02\x50\x01\0\xc8\
\x01\0\0\xe5\0\0\0\xc3\x04\0\0\x02\x60\x01\0\xe0\x01\0\0\xe5\0\0\0\x7c\x05\0\0\
\x05\xbc\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x05\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x07\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x03\0\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9c\0\0\0\x12\0\x03\0\0\0\0\0\0\0\
\0\0\x38\x01\0\0\0\0\0\0\x27\0\0\0\x11\0\x0b\0\x08\0\0\0\0\0\0\0\x08\0\0\0\0\0\
\0\0\x2d\x01\0\0\x11\0\x0b\0\x04\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x24\x01\0\0\
\x11\0\x0b\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x14\0\0\0\x11\0\x0d\0\0\0\0\0\0\
\0\0\0\x20\0\0\0\0\0\0\0\xb5\0\0\0\x12\0\x05\0\0\0\0\0\0\0\0\0\xf0\x01\0\0\0\0\
\0\0\x1a\0\0\0\x11\0\x0d\0\x20\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x79\0\0\0\x12\0\
\x07\0\0\0\0\0\0\0\0\0\x38\x01\0\0\0\0\0\0\x11\x01\0\0\x12\0\x09\0\0\0\0\0\0\0\
\0\0\xf0\x01\0\0\0\0\0\0\x58\x01\0\0\x11\0\x0c\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\x40\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\
\x78\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\x08\x01\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\
\x60\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\x98\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\
\xd8\0\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\x80\x01\0\0\0\0\0\0\x01\0\0\0\x0b\0\0\0\
\xc8\x01\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\
\x40\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\x78\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\
\x08\x01\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\x60\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\
\x98\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\xd8\0\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\
\x80\x01\0\0\0\0\0\0\x01\0\0\0\x0b\0\0\0\xc8\x01\0\0\0\0\0\0\x01\0\0\0\x09\0\0\
\0\x08\x03\0\0\0\0\0\0\x04\0\0\0\x09\0\0\0\x14\x03\0\0\0\0\0\0\x04\0\0\0\x0b\0\
\0\0\x2c\x03\0\0\0\0\0\0\x03\0\0\0\x08\0\0\0\x38\x03\0\0\0\0\0\0\x03\0\0\0\x07\
\0\0\0\x44\x03\0\0\0\0\0\0\x03\0\0\0\x06\0\0\0\x5c\x03\0\0\0\0\0\0\x04\0\0\0\
\x0e\0\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\
\x02\0\0\0\x4c\0\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x5c\0\0\0\0\0\0\0\x04\0\0\0\
\x04\0\0\0\x70\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x90\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xb0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xd0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xf0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x10\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x20\x01\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\x30\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x40\x01\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\x50\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x60\x01\0\0\0\0\0\0\x04\
\0\0\0\x01\0\0\0\x70\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x80\x01\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x90\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa0\x01\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\xb8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc8\x01\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\xd8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe8\x01\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\xf8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x08\x02\0\0\
\0\0\0\0\x04\0\0\0\x02\0\0\0\x18\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x02\0\
\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x38\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x02\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x58\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x68\
\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x78\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x88\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x98\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\xa8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\
\0\0\xc8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd8\x02\0\0\0\0\0\0\x04\0\0\0\x02\
\0\0\0\xe8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xf8\x02\0\0\0\0\0\0\x04\0\0\0\
\x02\0\0\0\x08\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x18\x03\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\x28\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x38\x03\0\0\0\0\0\0\x04\0\
\0\0\x02\0\0\0\x48\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x58\x03\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\x68\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x78\x03\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x88\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x98\x03\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\xb0\x03\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xc0\x03\0\0\0\0\
\0\0\x04\0\0\0\x03\0\0\0\xd0\x03\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xe0\x03\0\0\0\
\0\0\0\x04\0\0\0\x03\0\0\0\xf0\x03\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\0\x04\0\0\0\
\0\0\0\x04\0\0\0\x03\0\0\0\x10\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x20\x04\0\0\
\0\0\0\0\x04\0\0\0\x03\0\0\0\x30\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x40\x04\0\
\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x50\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x60\x04\
\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x70\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x80\
\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x90\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\
\xa0\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xb0\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\
\0\xc0\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xd0\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\
\0\0\xe0\x04\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xf8\x04\0\0\0\0\0\0\x04\0\0\0\x04\
\0\0\0\x08\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x18\x05\0\0\0\0\0\0\x04\0\0\0\
\x04\0\0\0\x28\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x38\x05\0\0\0\0\0\0\x04\0\0\
\0\x04\0\0\0\x48\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x58\x05\0\0\0\0\0\0\x04\0\
\0\0\x04\0\0\0\x68\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x78\x05\0\0\0\0\0\0\x04\
\0\0\0\x04\0\0\0\x88\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x98\x05\0\0\0\0\0\0\
\x04\0\0\0\x04\0\0\0\xa8\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xb8\x05\0\0\0\0\0\
\0\x04\0\0\0\x04\0\0\0\xc8\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xd8\x05\0\0\0\0\
\0\0\x04\0\0\0\x04\0\0\0\xe8\x05\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xf8\x05\0\0\0\
\0\0\0\x04\0\0\0\x04\0\0\0\x08\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x18\x06\0\0\
\0\0\0\0\x04\0\0\0\x04\0\0\0\x28\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x38\x06\0\
\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x48\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x58\x06\
\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x68\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x78\
\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x88\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\
\x98\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xa8\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\
\0\xb8\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xc8\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\
\0\0\xd8\x06\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x0f\x14\x16\x17\x12\x11\x10\x18\
\x13\x15\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\x2e\x65\x78\
\x74\0\x73\x74\x61\x72\x74\0\x65\x76\x65\x6e\x74\x73\0\x2e\x6d\x61\x70\x73\0\
\x76\x6d\x5f\x7a\x6f\x6e\x65\x5f\x73\x74\x61\x74\x5f\x6b\x61\x64\x64\x72\0\x2e\
\x72\x65\x6c\x72\x61\x77\x5f\x74\x70\x2f\x6d\x6d\x5f\x76\x6d\x73\x63\x61\x6e\
\x5f\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x62\x65\x67\
\x69\x6e\0\x2e\x72\x65\x6c\x74\x70\x5f\x62\x74\x66\x2f\x6d\x6d\x5f\x76\x6d\x73\
\x63\x61\x6e\x5f\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\
\x62\x65\x67\x69\x6e\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\
\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x62\x65\x67\x69\
\x6e\x5f\x62\x74\x66\0\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\
\x5f\x65\x6e\x64\x5f\x62\x74\x66\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x72\x65\
\x6c\x72\x61\x77\x5f\x74\x70\x2f\x6d\x6d\x5f\x76\x6d\x73\x63\x61\x6e\x5f\x64\
\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x65\x6e\x64\0\x2e\x72\
\x65\x6c\x74\x70\x5f\x62\x74\x66\x2f\x6d\x6d\x5f\x76\x6d\x73\x63\x61\x6e\x5f\
\x64\x69\x72\x65\x63\x74\x5f\x72\x65\x63\x6c\x61\x69\x6d\x5f\x65\x6e\x64\0\x74\
\x61\x72\x67\x5f\x70\x69\x64\0\x74\x61\x72\x67\x5f\x74\x67\x69\x64\0\x2e\x73\
\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\x6f\x64\x61\x74\
\x61\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x37\x01\0\0\x03\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xda\x20\0\0\0\0\0\0\x60\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x68\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x40\0\0\0\0\0\0\0\x38\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x64\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0\x18\0\0\0\
\0\0\0\x40\0\0\0\0\0\0\0\x13\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\
\0\0\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\x01\0\0\0\0\0\0\
\xf0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xfc\0\0\
\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\x18\0\0\0\0\0\0\x50\0\0\0\0\
\0\0\0\x13\0\0\0\x05\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x3e\0\0\0\x01\0\
\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x68\x03\0\0\0\0\0\0\x38\x01\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x3a\0\0\0\x09\0\0\0\x40\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\x19\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x13\0\0\0\x07\
\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xd8\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\xa0\x04\0\0\0\0\0\0\xf0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd4\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x80\x19\0\0\0\0\0\0\x50\0\0\0\0\0\0\0\x13\0\0\0\x09\0\0\0\x08\0\0\0\0\0\
\0\0\x10\0\0\0\0\0\0\0\x47\x01\0\0\x01\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x90\x06\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\xcc\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\x06\0\0\0\
\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x21\
\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa8\x06\0\0\0\0\0\0\x38\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x53\x01\0\0\x01\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe0\x06\0\0\0\0\0\0\x7b\x09\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x4f\x01\0\0\x09\0\0\0\x40\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\xd0\x19\0\0\0\0\0\0\x60\0\0\0\0\0\0\0\x13\0\0\0\x0e\
\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x0b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x5c\x10\0\0\0\0\0\0\xe8\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x07\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x30\x1a\0\0\0\0\0\0\xa0\x06\0\0\0\0\0\0\x13\0\0\0\x10\0\0\0\x08\0\0\0\0\0\
\0\0\x10\0\0\0\0\0\0\0\x8e\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\
\0\0\xd0\x20\0\0\0\0\0\0\x0a\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x3f\x01\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x48\x17\0\
\0\0\0\0\0\x68\x01\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\
\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct drsnoop_bpf *drsnoop_bpf::open(const struct bpf_object_open_opts *opts) { return drsnoop_bpf__open_opts(opts); }
struct drsnoop_bpf *drsnoop_bpf::open_and_load() { return drsnoop_bpf__open_and_load(); }
int drsnoop_bpf::load(struct drsnoop_bpf *skel) { return drsnoop_bpf__load(skel); }
int drsnoop_bpf::attach(struct drsnoop_bpf *skel) { return drsnoop_bpf__attach(skel); }
void drsnoop_bpf::detach(struct drsnoop_bpf *skel) { drsnoop_bpf__detach(skel); }
void drsnoop_bpf::destroy(struct drsnoop_bpf *skel) { drsnoop_bpf__destroy(skel); }
const void *drsnoop_bpf::elf_bytes(size_t *sz) { return drsnoop_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
drsnoop_bpf__assert(struct drsnoop_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->rodata->targ_pid) == 4, "unexpected size of 'targ_pid'");
	_Static_assert(sizeof(s->rodata->targ_tgid) == 4, "unexpected size of 'targ_tgid'");
	_Static_assert(sizeof(s->rodata->vm_zone_stat_kaddr) == 8, "unexpected size of 'vm_zone_stat_kaddr'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __DRSNOOP_BPF_SKEL_H__ */
