/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __BASHREADLINE_BPF_SKEL_H__
#define __BASHREADLINE_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct bashreadline_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *events;
	} maps;
	struct {
		struct bpf_program *printret;
	} progs;
	struct {
		struct bpf_link *printret;
	} links;

#ifdef __cplusplus
	static inline struct bashreadline_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct bashreadline_bpf *open_and_load();
	static inline int load(struct bashreadline_bpf *skel);
	static inline int attach(struct bashreadline_bpf *skel);
	static inline void detach(struct bashreadline_bpf *skel);
	static inline void destroy(struct bashreadline_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
bashreadline_bpf__destroy(struct bashreadline_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
bashreadline_bpf__create_skeleton(struct bashreadline_bpf *obj);

static inline struct bashreadline_bpf *
bashreadline_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct bashreadline_bpf *obj;
	int err;

	obj = (struct bashreadline_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = bashreadline_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	bashreadline_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct bashreadline_bpf *
bashreadline_bpf__open(void)
{
	return bashreadline_bpf__open_opts(NULL);
}

static inline int
bashreadline_bpf__load(struct bashreadline_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct bashreadline_bpf *
bashreadline_bpf__open_and_load(void)
{
	struct bashreadline_bpf *obj;
	int err;

	obj = bashreadline_bpf__open();
	if (!obj)
		return NULL;
	err = bashreadline_bpf__load(obj);
	if (err) {
		bashreadline_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
bashreadline_bpf__attach(struct bashreadline_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
bashreadline_bpf__detach(struct bashreadline_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *bashreadline_bpf__elf_bytes(size_t *sz);

static inline int
bashreadline_bpf__create_skeleton(struct bashreadline_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "bashreadline_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 1;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "events";
	map->map = &obj->maps.events;

	/* programs */
	s->prog_cnt = 1;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "printret";
	s->progs[0].prog = &obj->progs.printret;
	s->progs[0].link = &obj->links.printret;

	s->data = bashreadline_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *bashreadline_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x90\x0b\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x0d\0\
\x01\0\xbf\x16\0\0\0\0\0\0\x79\x67\x50\0\0\0\0\0\x15\x07\x1f\0\0\0\0\0\xbf\xa1\
\0\0\0\0\0\0\x07\x01\0\0\x9c\xff\xff\xff\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\
\0\0\x71\xa1\x9c\xff\0\0\0\0\x56\x01\x19\0\x62\0\0\0\x71\xa1\x9d\xff\0\0\0\0\
\x56\x01\x17\0\x61\0\0\0\x71\xa1\x9e\xff\0\0\0\0\x56\x01\x15\0\x73\0\0\0\x71\
\xa1\x9f\xff\0\0\0\0\x56\x01\x13\0\x68\0\0\0\x71\xa1\xa0\xff\0\0\0\0\x56\x01\
\x11\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\x77\0\0\0\x20\0\0\0\x63\x0a\xac\xff\0\0\0\0\
\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\xb0\xff\xff\xff\xb4\x02\0\0\x50\0\0\0\xbf\x73\
\0\0\0\0\0\0\x85\0\0\0\x72\0\0\0\xbf\xa4\0\0\0\0\0\0\x07\x04\0\0\xac\xff\xff\
\xff\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\
\xff\xff\xff\0\0\0\0\0\0\0\0\xb7\x05\0\0\x54\0\0\0\x85\0\0\0\x19\0\0\0\xb4\0\0\
\0\0\0\0\0\x95\0\0\0\0\0\0\0\x47\x50\x4c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x94\x03\0\0\x94\x03\0\0\
\x1b\x03\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\
\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x04\0\0\0\x05\0\0\0\0\0\0\
\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\x03\0\0\x04\x18\0\0\0\x19\0\0\0\x01\0\0\0\0\0\
\0\0\x1e\0\0\0\x01\0\0\0\x40\0\0\0\x27\0\0\0\x01\0\0\0\x80\0\0\0\x32\0\0\0\0\0\
\0\x0e\x05\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x08\0\0\0\x39\0\0\0\x15\0\0\x04\
\xa8\0\0\0\x41\0\0\0\x09\0\0\0\0\0\0\0\x45\0\0\0\x09\0\0\0\x40\0\0\0\x49\0\0\0\
\x09\0\0\0\x80\0\0\0\x4d\0\0\0\x09\0\0\0\xc0\0\0\0\x51\0\0\0\x09\0\0\0\0\x01\0\
\0\x54\0\0\0\x09\0\0\0\x40\x01\0\0\x57\0\0\0\x09\0\0\0\x80\x01\0\0\x5b\0\0\0\
\x09\0\0\0\xc0\x01\0\0\x5f\0\0\0\x09\0\0\0\0\x02\0\0\x62\0\0\0\x09\0\0\0\x40\
\x02\0\0\x65\0\0\0\x09\0\0\0\x80\x02\0\0\x68\0\0\0\x09\0\0\0\xc0\x02\0\0\x6b\0\
\0\0\x09\0\0\0\0\x03\0\0\x6e\0\0\0\x09\0\0\0\x40\x03\0\0\x71\0\0\0\x09\0\0\0\
\x80\x03\0\0\x74\0\0\0\x09\0\0\0\xc0\x03\0\0\x7c\0\0\0\x09\0\0\0\0\x04\0\0\0\0\
\0\0\x0a\0\0\0\x40\x04\0\0\x7f\0\0\0\x09\0\0\0\x80\x04\0\0\x85\0\0\0\x09\0\0\0\
\xc0\x04\0\0\0\0\0\0\x12\0\0\0\0\x05\0\0\x88\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\
\0\0\0\0\0\x03\0\0\x05\x08\0\0\0\x96\0\0\0\x0b\0\0\0\0\0\0\0\x99\0\0\0\x0e\0\0\
\0\0\0\0\0\x9d\0\0\0\x11\0\0\0\0\0\0\0\xa5\0\0\0\0\0\0\x08\x0c\0\0\0\xa9\0\0\0\
\0\0\0\x08\x0d\0\0\0\xaf\0\0\0\0\0\0\x01\x02\0\0\0\x10\0\0\0\xbe\0\0\0\0\0\0\
\x08\x0f\0\0\0\xc2\0\0\0\0\0\0\x08\x10\0\0\0\xc8\0\0\0\0\0\0\x01\x08\0\0\0\x40\
\0\0\0\x9d\0\0\0\x03\0\0\x84\x08\0\0\0\x96\0\0\0\x0e\0\0\0\0\0\0\x10\xdb\0\0\0\
\x0e\0\0\0\x10\0\0\x02\xde\0\0\0\x0e\0\0\0\x12\0\0\x01\0\0\0\0\x03\0\0\x05\x08\
\0\0\0\xe2\0\0\0\x0b\0\0\0\0\0\0\0\xe5\0\0\0\x0e\0\0\0\0\0\0\0\xe9\0\0\0\x13\0\
\0\0\0\0\0\0\xe9\0\0\0\x0a\0\0\x84\x08\0\0\0\xe2\0\0\0\x0e\0\0\0\0\0\0\x10\xf1\
\0\0\0\x0e\0\0\0\x10\0\0\x01\xf5\0\0\0\x0e\0\0\0\x11\0\0\x01\xfd\0\0\0\x0e\0\0\
\0\x12\0\0\x01\x01\x01\0\0\x0e\0\0\0\x20\0\0\x08\x19\0\0\0\x0e\0\0\0\x30\0\0\
\x04\x08\x01\0\0\x0e\0\0\0\x38\0\0\x01\x10\x01\0\0\x0e\0\0\0\x39\0\0\x01\x13\
\x01\0\0\x0e\0\0\0\x3a\0\0\x01\x1a\x01\0\0\x0e\0\0\0\x3c\0\0\x04\0\0\0\0\x01\0\
\0\x0d\x02\0\0\0\x22\x01\0\0\x07\0\0\0\x26\x01\0\0\x01\0\0\x0c\x14\0\0\0\0\x03\
\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x16\0\0\0\x04\0\
\0\0\x04\0\0\0\x05\x03\0\0\0\0\0\x0e\x17\0\0\0\x01\0\0\0\x0d\x03\0\0\x01\0\0\
\x0f\0\0\0\0\x06\0\0\0\0\0\0\0\x18\0\0\0\x13\x03\0\0\x01\0\0\x0f\0\0\0\0\x18\0\
\0\0\0\0\0\0\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\
\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x74\x79\x70\x65\0\x6b\x65\x79\x5f\x73\
\x69\x7a\x65\0\x76\x61\x6c\x75\x65\x5f\x73\x69\x7a\x65\0\x65\x76\x65\x6e\x74\
\x73\0\x70\x74\x5f\x72\x65\x67\x73\0\x72\x31\x35\0\x72\x31\x34\0\x72\x31\x33\0\
\x72\x31\x32\0\x62\x70\0\x62\x78\0\x72\x31\x31\0\x72\x31\x30\0\x72\x39\0\x72\
\x38\0\x61\x78\0\x63\x78\0\x64\x78\0\x73\x69\0\x64\x69\0\x6f\x72\x69\x67\x5f\
\x61\x78\0\x69\x70\0\x66\x6c\x61\x67\x73\0\x73\x70\0\x75\x6e\x73\x69\x67\x6e\
\x65\x64\x20\x6c\x6f\x6e\x67\0\x63\x73\0\x63\x73\x78\0\x66\x72\x65\x64\x5f\x63\
\x73\0\x75\x31\x36\0\x5f\x5f\x75\x31\x36\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\
\x73\x68\x6f\x72\x74\0\x75\x36\x34\0\x5f\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\
\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x73\x6c\0\x77\x66\x65\0\
\x73\x73\0\x73\x73\x78\0\x66\x72\x65\x64\x5f\x73\x73\0\x73\x74\x69\0\x73\x77\
\x65\x76\x65\x6e\x74\0\x6e\x6d\x69\0\x76\x65\x63\x74\x6f\x72\0\x65\x6e\x63\x6c\
\x61\x76\x65\0\x6c\x6d\0\x6e\x65\x73\x74\x65\x64\0\x69\x6e\x73\x6e\x6c\x65\x6e\
\0\x63\x74\x78\0\x70\x72\x69\x6e\x74\x72\x65\x74\0\x75\x72\x65\x74\x70\x72\x6f\
\x62\x65\x2f\x72\x65\x61\x64\x6c\x69\x6e\x65\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\
\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\
\x6f\x6f\x6c\x73\x2f\x62\x61\x73\x68\x72\x65\x61\x64\x6c\x69\x6e\x65\x2e\x62\
\x70\x66\x2e\x63\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x55\x52\x45\x54\x50\x52\x4f\
\x42\x45\x28\x70\x72\x69\x6e\x74\x72\x65\x74\x2c\x20\x63\x6f\x6e\x73\x74\x20\
\x76\x6f\x69\x64\x20\x2a\x72\x65\x74\x29\x20\x7b\0\x30\x3a\x31\x30\0\x09\x69\
\x66\x20\x28\x21\x72\x65\x74\x29\0\x09\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\
\x72\x72\x65\x6e\x74\x5f\x63\x6f\x6d\x6d\x28\x26\x63\x6f\x6d\x6d\x2c\x20\x73\
\x69\x7a\x65\x6f\x66\x28\x63\x6f\x6d\x6d\x29\x29\x3b\0\x09\x69\x66\x20\x28\x63\
\x6f\x6d\x6d\x5b\x30\x5d\x20\x21\x3d\x20\x27\x62\x27\x20\x7c\x7c\x20\x63\x6f\
\x6d\x6d\x5b\x31\x5d\x20\x21\x3d\x20\x27\x61\x27\x20\x7c\x7c\x20\x63\x6f\x6d\
\x6d\x5b\x32\x5d\x20\x21\x3d\x20\x27\x73\x27\x20\x7c\x7c\x20\x63\x6f\x6d\x6d\
\x5b\x33\x5d\x20\x21\x3d\x20\x27\x68\x27\x20\x7c\x7c\x20\x63\x6f\x6d\x6d\x5b\
\x34\x5d\x20\x21\x3d\x20\x30\x20\x29\0\x09\x70\x69\x64\x20\x3d\x20\x62\x70\x66\
\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x70\x69\x64\x5f\x74\x67\
\x69\x64\x28\x29\x20\x3e\x3e\x20\x33\x32\x3b\0\x09\x64\x61\x74\x61\x2e\x70\x69\
\x64\x20\x3d\x20\x70\x69\x64\x3b\0\x09\x62\x70\x66\x5f\x70\x72\x6f\x62\x65\x5f\
\x72\x65\x61\x64\x5f\x75\x73\x65\x72\x5f\x73\x74\x72\x28\x26\x64\x61\x74\x61\
\x2e\x73\x74\x72\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x64\x61\x74\x61\x2e\x73\
\x74\x72\x29\x2c\x20\x72\x65\x74\x29\x3b\0\x09\x62\x70\x66\x5f\x70\x65\x72\x66\
\x5f\x65\x76\x65\x6e\x74\x5f\x6f\x75\x74\x70\x75\x74\x28\x63\x74\x78\x2c\x20\
\x26\x65\x76\x65\x6e\x74\x73\x2c\x20\x42\x50\x46\x5f\x46\x5f\x43\x55\x52\x52\
\x45\x4e\x54\x5f\x43\x50\x55\x2c\x20\x26\x64\x61\x74\x61\x2c\x20\x73\x69\x7a\
\x65\x6f\x66\x28\x64\x61\x74\x61\x29\x29\x3b\0\x63\x68\x61\x72\0\x4c\x49\x43\
\x45\x4e\x53\x45\0\x2e\x6d\x61\x70\x73\0\x6c\x69\x63\x65\x6e\x73\x65\0\0\x9f\
\xeb\x01\0\x20\0\0\0\0\0\0\0\x14\0\0\0\x14\0\0\0\xdc\0\0\0\xf0\0\0\0\x1c\0\0\0\
\x08\0\0\0\x2f\x01\0\0\x01\0\0\0\0\0\0\0\x15\0\0\0\x10\0\0\0\x2f\x01\0\0\x0d\0\
\0\0\0\0\0\0\x42\x01\0\0\x75\x01\0\0\0\x44\0\0\x08\0\0\0\x42\x01\0\0\x75\x01\0\
\0\x05\x44\0\0\x10\0\0\0\x42\x01\0\0\xa9\x01\0\0\x06\x58\0\0\x28\0\0\0\x42\x01\
\0\0\xb4\x01\0\0\x02\x64\0\0\x38\0\0\0\x42\x01\0\0\xe0\x01\0\0\x06\x68\0\0\x40\
\0\0\0\x42\x01\0\0\xe0\x01\0\0\x15\x68\0\0\x88\0\0\0\x42\x01\0\0\x3c\x02\0\0\
\x08\x74\0\0\x90\0\0\0\x42\x01\0\0\x3c\x02\0\0\x23\x74\0\0\x98\0\0\0\x42\x01\0\
\0\x65\x02\0\0\x0b\x78\0\0\xa0\0\0\0\x42\x01\0\0\x76\x02\0\0\x20\x7c\0\0\xb0\0\
\0\0\x42\x01\0\0\x76\x02\0\0\x02\x7c\0\0\xd8\0\0\0\x42\x01\0\0\xb2\x02\0\0\x02\
\x84\0\0\x10\x01\0\0\x42\x01\0\0\x75\x01\0\0\x05\x44\0\0\x10\0\0\0\x2f\x01\0\0\
\x01\0\0\0\x08\0\0\0\x08\0\0\0\xa4\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x14\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\x20\x01\0\0\0\0\0\0\x1d\0\0\0\x11\0\
\x06\0\0\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x70\0\0\0\x11\0\x05\0\0\0\0\0\0\0\0\0\
\x04\0\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\x01\0\0\0\x03\0\0\0\x8c\x03\0\0\0\0\0\0\
\x04\0\0\0\x03\0\0\0\xa4\x03\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x2c\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x60\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x1c\x01\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x0b\x0d\x0c\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\
\x42\x54\x46\x2e\x65\x78\x74\0\x70\x72\x69\x6e\x74\x72\x65\x74\0\x65\x76\x65\
\x6e\x74\x73\0\x2e\x6d\x61\x70\x73\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\
\x73\x69\x67\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x72\x65\x6c\x75\x72\x65\x74\
\x70\x72\x6f\x62\x65\x2f\x72\x65\x61\x64\x6c\x69\x6e\x65\0\x2e\x73\x74\x72\x74\
\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\
\x49\x43\x45\x4e\x53\x45\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x57\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x13\x0b\0\0\0\0\0\
\0\x78\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\
\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x44\0\0\0\x01\0\0\0\x06\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x20\x01\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xf0\x09\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x0c\0\0\0\x03\0\0\0\x08\0\
\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x38\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x60\x01\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x24\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x68\x01\
\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x6b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x01\0\0\0\0\0\0\xc7\
\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x67\0\0\0\
\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0a\0\0\0\0\0\0\x20\0\0\0\0\0\0\
\0\x0c\0\0\0\x07\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x0b\0\0\0\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x48\x08\0\0\0\0\0\0\x2c\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x07\0\0\0\x09\0\0\0\x40\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x20\x0a\0\0\0\0\0\0\xf0\0\0\0\0\0\0\0\x0c\0\0\0\x09\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2a\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\
\0\0\0\0\0\0\0\0\0\x10\x0b\0\0\0\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x5f\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x78\x09\0\0\0\0\0\0\x78\0\0\0\0\0\0\0\x01\0\0\0\x02\0\0\0\x08\0\0\0\0\0\0\0\
\x18\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct bashreadline_bpf *bashreadline_bpf::open(const struct bpf_object_open_opts *opts) { return bashreadline_bpf__open_opts(opts); }
struct bashreadline_bpf *bashreadline_bpf::open_and_load() { return bashreadline_bpf__open_and_load(); }
int bashreadline_bpf::load(struct bashreadline_bpf *skel) { return bashreadline_bpf__load(skel); }
int bashreadline_bpf::attach(struct bashreadline_bpf *skel) { return bashreadline_bpf__attach(skel); }
void bashreadline_bpf::detach(struct bashreadline_bpf *skel) { bashreadline_bpf__detach(skel); }
void bashreadline_bpf::destroy(struct bashreadline_bpf *skel) { bashreadline_bpf__destroy(skel); }
const void *bashreadline_bpf::elf_bytes(size_t *sz) { return bashreadline_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
bashreadline_bpf__assert(struct bashreadline_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __BASHREADLINE_BPF_SKEL_H__ */
