/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.nlctdoc;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.nlctdoc.UserGuideSty;
import java.io.IOException;
import java.util.Vector;

public class ExampleTagRef
extends ControlSequence {
    UserGuideSty sty;

    public ExampleTagRef(UserGuideSty userGuideSty) {
        this("exampletagref", userGuideSty);
    }

    public ExampleTagRef(String string, UserGuideSty userGuideSty) {
        super(string);
        this.sty = userGuideSty;
    }

    @Override
    public Object clone() {
        return new ExampleTagRef(this.getName(), this.sty);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        String string = this.popLabelString(teXParser, teXObjectList);
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        Vector<String> vector = this.sty.getTagGroup(string);
        if (vector == null) {
            throw new TeXSyntaxException(teXParser, "nlctdoc.unknown_tag_group", string);
        }
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        int n = vector.size();
        if (n == 1) {
            teXObjectList2.add(teXParserListener.getControlSequence("examplenameref"));
            teXObjectList2.add(teXParserListener.createGroup(vector.firstElement()));
            teXObjectList2.add(teXObject, true);
        } else {
            NumericRegister numericRegister = teXParser.getSettings().getNumericRegister("l_nlctdoc_extag_item_threshold_int");
            int n2 = numericRegister.number(teXParser);
            if (n < n2) {
                teXObjectList2.add(teXParserListener.getControlSequence("examplesrefprefix"));
                teXObjectList2.add(teXParserListener.getControlSequence("@ref@numname"));
                teXObjectList2.add(teXParserListener.createGroup(vector.firstElement()));
                int n3 = n - 1;
                for (int i = 2; i <= n3; ++i) {
                    teXObjectList2.add(teXParserListener.getControlSequence("refslistsep"));
                    teXObjectList2.add(teXParserListener.getControlSequence("@ref@numname"));
                    teXObjectList2.add(teXParserListener.createGroup(vector.get(i - 1)));
                }
                teXObjectList2.add(teXParserListener.getControlSequence("refslistlastsep"));
                teXObjectList2.add(teXParserListener.getControlSequence("@ref@numname"));
                teXObjectList2.add(teXParserListener.createGroup(vector.lastElement()));
                teXObjectList2.add(teXObject, true);
            } else {
                teXObjectList2.add(teXParserListener.getControlSequence("exampletagrefprelist"));
                teXObjectList2.add(teXParserListener.getControlSequence("begin"));
                teXObjectList2.add(teXParserListener.createGroup("itemize"));
                for (int i = 1; i <= n; ++i) {
                    teXObjectList2.add(teXParserListener.getControlSequence("item"));
                    teXObjectList2.add(teXParserListener.getControlSequence("ref"));
                    teXObjectList2.add(teXParserListener.createGroup(vector.get(i - 1)));
                    teXObjectList2.add(teXParserListener.getControlSequence("exampletagreflistpretitle"));
                    teXObjectList2.add(teXParserListener.getControlSequence("nameref"));
                    teXObjectList2.add(teXParserListener.createGroup(vector.get(i - 1)));
                    if (i == n) {
                        teXObjectList2.add(teXObject, true);
                        continue;
                    }
                    teXObjectList2.add(teXParserListener.getControlSequence("exampletagreflistsep"));
                }
                teXObjectList2.add(teXParserListener.getControlSequence("end"));
                teXObjectList2.add(teXParserListener.createGroup("itemize"));
            }
        }
        TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

