/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXFontShape;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import java.io.IOException;

public class FontShapeDeclaration
extends Declaration {
    private String name;
    private TeXFontShape shape;
    private TeXFontShape orgShape;

    public FontShapeDeclaration(String string, int n) {
        super(string);
        this.orgShape = TeXFontShape.INHERIT;
        switch (n) {
            case -1: {
                this.shape = TeXFontShape.INHERIT;
                break;
            }
            case 0: {
                this.shape = TeXFontShape.UP;
                break;
            }
            case 1: {
                this.shape = TeXFontShape.IT;
                break;
            }
            case 4: {
                this.shape = TeXFontShape.SC;
                break;
            }
            case 3: {
                this.shape = TeXFontShape.EM;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid shape ID: " + n);
            }
        }
    }

    public FontShapeDeclaration(String string, TeXFontShape teXFontShape) {
        super(string);
        this.shape = teXFontShape;
        this.orgShape = TeXFontShape.INHERIT;
    }

    @Override
    public Object clone() {
        return new FontShapeDeclaration(this.getName(), this.shape);
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgShape = teXSettings.getCurrentFontShape();
        teXSettings.setFontShape(this.shape);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setFontShape(this.orgShape);
    }

    @Override
    public boolean isModeSwitcher() {
        return false;
    }

    public TeXFontShape getShape() {
        return this.shape;
    }
}

