/*--------------------------------------------------------------------
 * FILE:
 *     probe_exec_pglb.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

uint16_t PGC_Probe_Exec_Pglb(Probe_Header * header, char * packet);

static int set_pglb_2_exec(Exec_Info * exec, Pglb_Info *pglb);
static int16_t get_pglb_status(Pglb_Info * pglb);

uint16_t
PGC_Probe_Exec_Pglb(Probe_Header * header, char * packet)
{
	char * func = "PGC_Probe_Exec_Pglb()";
	Pglb_Info * pglb_key = NULL;
	Pglb_Info * pglb = NULL;
	uint16_t status = DATA_ERR;
	Exec_Info exec;
	char * exec_result = NULL;
	int i = 0;

	if ((header == NULL ) || (packet == NULL) || (PglbTbl == NULL))
	{
		show_error("%s: table is not allocated",func);
		return DATA_ERR;
	}
	if (ntohl(header->body_length) < sizeof(Pglb_Info))
	{
		show_error("%s: there is no packet data ",func);
		return DATA_ERR;
	}
	pglb_key = (Pglb_Info *) packet;
	pglb = PGC_Get_PglbTbl_Rec(pglb_key);
	if (pglb == NULL)
	{
		show_error("%s: there is no such pglb in PglbTbl",func);
		return DATA_ERR;
	}
	set_pglb_2_exec(&exec, pglb);
	switch (ntohs(header->packet_no))
	{
		case START_REQ_PKT:
			show_debug("%s:START_REQ_PKT recv\n",func);
			i = 0;
			strcpy(exec.options[i++],"start");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			if (exec_result != NULL)
				status = DATA_USE;
			break;
		case STOP_REQ_PKT:
			show_debug("%s:STOP_REQ_PKT recv\n",func);
			i = 0;
			strcpy(exec.options[i++],"stop");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			if (exec_result != NULL)
				status = DATA_USE;
			break;
		case RECOVERY_REQ_PKT:
			show_debug("%s:RECOVERY_REQ_PKT recv\n",func);
			i = 0;
			strcpy(exec.options[i++],"stop");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			i = 0;
			strcpy(exec.options[i++],"start");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			if (exec_result != NULL)
				status = DATA_USE;
			break;
		case STATUS_REQ_PKT:
			status = get_pglb_status(pglb);
			break;
		default :
			break;
	}
	return status;
}

static int16_t
get_pglb_status(Pglb_Info * pglb)
{
	char * func = "get_pglb_status()";
	FILE *fd;
	char fname[256];
	char pidbuf[128];
	pid_t pid;
	int16_t status = DATA_INIT;

	if (pglb == NULL)
	{
		return DATA_ERR;
	}
	snprintf(fname, sizeof(fname), "%s/%s", pglb->workPath, PGLB_PID_FILE);
	fd = fopen(fname, "r");
	if (!fd)
	{
		show_error("%s:could not open pid file as %s. reason: %s",
				   func,fname, strerror(errno));
		return DATA_ERR;
	}
	memset(pidbuf,0,sizeof(pidbuf));
	fread(pidbuf, sizeof(pidbuf), 1, fd);
	fclose(fd);
	pid = atoi(pidbuf);

	if (kill (pid,0) == 0)
	{
		status = DATA_USE;
	}
	else
	{
		status = DATA_ERR;
	}
	return status;
}

static int
set_pglb_2_exec(Exec_Info * exec, Pglb_Info *pglb)
{
	char * func ="set_pglb_2_exec()";
	if ((exec == NULL) || (pglb == NULL))
	{
		show_error("%s:execor pglb is null",func);
		return STATUS_ERROR;
	}
	memset(exec, 0, sizeof(Exec_Info));
	exec->portNumber = pglb->receivePortNumber;
	strncpy(exec->workPath, pglb->workPath, sizeof(exec->workPath));
	strncpy(exec->binPath, pglb->binPath, sizeof(exec->binPath));
	strcpy(exec->command,"pglb");
fprintf(stderr,"%s:exec->workPath[%s]\n",func, exec->workPath);

	return STATUS_OK;
}
