/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef FONTS_H
#define FONTS_H

#include <QObject>
#include <QtPlugin>
#include <QPushButton>
#include <QAbstractButton>
#include <QFontDatabase>
#include <QGSettings>
#include <QStyledItemDelegate>
#include <QStandardItemModel>
#include <QtDBus>

#include <kslider.h>

#include "shell/interface.h"
#include "ukcccommon.h"
using namespace ukcc;

using namespace kdk;

/* qt会将glib里的signals成员识别为宏，所以取消该宏
 * 后面如果用到signals时，使用Q_SIGNALS代替即可
 **/
#ifdef signals
#undef signals
#endif

#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>

namespace Ui {
class Fonts;
}

class Fonts : public QObject, CommonInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.ukcc.CommonInterface")
    Q_INTERFACES(CommonInterface)

public:
    Fonts();
    ~Fonts();

public:
    QString plugini18nName() Q_DECL_OVERRIDE;
    int pluginTypes() Q_DECL_OVERRIDE;
    QWidget * pluginUi() Q_DECL_OVERRIDE;
    const QString name() const  Q_DECL_OVERRIDE;
    bool isShowOnHomePage() const Q_DECL_OVERRIDE;
    QIcon icon() const Q_DECL_OVERRIDE;
    bool isEnable() const Q_DECL_OVERRIDE;

public:
    void initSearchText();
    void setupComponent();
    void setupConnect();
    void initFontStatus();
    void initGeneralFontStatus();

    void resetDefault();

    void getCurrentFontInfo();
    QStringList splitFontNameSize(QString value);

    int fontConvertToSlider(float size) const;
    float sliderConvertToSize(int value) const;

    void connectToServer();

private:
    Ui::Fonts *ui;

    QWidget * pluginWidget;

    QString pluginName;
    int pluginType;

    QGSettings *ifsettings;
    QGSettings *stylesettings;
    QGSettings *mUkccSettings;
    QGSettings *mGnomeSettings;

    QStringList gtkfontStrList;
    QStringList docfontStrList;
    QStringList monospacefontStrList;
    QStringList mFontsList;

    QStandardItemModel *mFontModel;
    QStandardItemModel *mMonoModel;

    QDBusInterface *m_cloudInterface;
    QFontDatabase   fontdb;
public Q_SLOTS:
    void keyChangedSlot(const QString &key);
    void updateFontListSlot(const QStringList &fontList);

private:
    void fontKwinSlot();
    void initModel();

private:
    bool mFirstLoad;
    KSlider *mSlider;
};

#endif // FONTS_H
