---
myst:
  html_meta:
    keywords: LaTeX, généralités, bases, saisie, clavier, caractère, Mac, macOS
---

% Pour employer le caractère accent grave avec le rôle {kbd}, la syntaxe
% {kbd}`` ` `` peut être utilisée.

% Pour afficher le caractère accent grave comme du code en ligne, une
% possibilité avec la syntaxe Markdown étendue de MyST-Parser est
% {literal}`` ` ``. (à nouveau sans le point final)
% Il subsistera deux espaces entourant le caractère.


# Comment obtenir ce caractère utile pour le codage TeX et LaTeX sur mon clavier sous macOS ?

Dans ce qui suit :

- {kbd}`⌥` est la touche nommée *option* ;
- {kbd}`⇧` est la touche de majuscule (non verrouillée), aussi nommée par le mot anglais *shift* ;
- {kbd}`⇪` est la touche de majuscule verrouillée (dont l'état activé est matérialisé par l'allumage d'une petite LED) ;
- {kbd}`⌘` est la touche nommée *command* (utilisée uniquement dans la section [](#saisieUnicode)).

% mémo: ā n'est pas disponible dans la police Inconsolata utilisée pour la
% chasse fixe dans le PDF.  Le système de "fall-back" de LuaLaTeX est
% déclenché mais le résultat n'était pas agréable esthétiquement. Solution
% radicale: on n'utilise pas ci-dessous le passage à la police à chasse fixe
% déclenché par les backticks.

:::{tip}
Sur les versions récentes de macOS, appuyer sur une touche de voyelle et laisser la touche
enfoncée fait apparaître à l'écran dans une bulle de nombreuses variantes, notamment accentuées, de la voyelle en 
question (par exemple pour {kbd}`a` : à, â, ª, æ, á, ä, ã, å, ā), accompagnées d'un numéro d'index.
Pour sélectionner le caractère, on peut cliquer sur le caractère en question ou entrer le numéro d'index.
:::


## Clavier français

Le clavier est de type AZERTY. Ce qui suit s'applique à la méthode de saisie "Français".


:::{list-table} Les caractères utiles au code TeX et LaTeX
:widths: 13 29 58
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère
  - Combinaison de touches (clavier français)
  - Commentaire
* - `\`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`:`
  - `/` s'obtient avec {kbd}`⇧` + {kbd}`:`, et `\` peut être vu comme une variante de `/`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `(`
  -  {kbd}`(`
  - Immédiat
* - `)`
  - {kbd}`)`
  -  Immédiat
* - `{`
  - {kbd}`⌥` + {kbd}`(`
  - `{` peut être vu comme une variante de `(`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `}`
  - {kbd}`⌥` + {kbd}`)`
  - `}` peut être vu comme une variante de `)`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `[`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`(`
  - `[` peut être vu comme une variante plus forte de `(`, d'où l'ajout de {kbd}`⌥` + {kbd}`⇧` pour l'obtenir
* - `]`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`)`
  - `]` peut être vu comme une variante plus forte de `)`, d'où l'ajout de {kbd}`⌥` + {kbd}`⇧` pour l'obtenir
* - `_`
  - {kbd}`⇧` + {kbd}`-`
  - Caractère marqué au-dessus de la touche {kbd}`-`. Trait de soulignement, nommé "tiret du 8" dans le monde PC
* - `~`
  - {kbd}`⌥` + {kbd}`n`, puis {kbd}`espace`
  - Caractère nommé *tilde* ; {kbd}`⌥` + {kbd}`n` produit l'accent ` ̃`, surtout utilisé dans ñ (d'où l'association avec `n`), et attend une lettre comme `a`, `n` ou `o` ou encore l'espace pour le tilde tout seul
* - `%`
  - {kbd}`⇧` + {kbd}`ù`
  - Caractère marqué au-dessus de la touche {kbd}`ù`
* - `&`
  - {kbd}`&`
  - Immédiat
* - `#`
  - {kbd}`⇧` + {kbd}`@`
  - Caractère marqué au-dessus de la touche {kbd}`@`
* - `$`
  - {kbd}`$`
  - Immédiat
* - `<`
  - {kbd}`<`
  - Immédiat
* - `>`
  - {kbd}`⇧` + {kbd}`>`
  - Caractère marqué au-dessus de la touche {kbd}`<`
* - `@`
  - {kbd}`@`
  - Immédiat
* - `:`
  - {kbd}`:`
  - Immédiat. Usage courant dans la programmation en LaTeX3
* - `^`
  - {kbd}`^` puis {kbd}`espace`
  -
* - `|`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`l`
  - Caractère nommé *pipe* (tuyau). On peut se souvenir de cette combinaison de touches en se rappelant que le caractère ressemble à un `l`
:::

:::{todo}
Régler problème de rendu de l'accent grave dans le tableau ci-dessous en ce qui concerne les espaces en particulier.
:::

:::{todo}
Le tréma est indiqué ci-dessous par lui-même `¨` et non pas {kbd}`¨`, sans
qu'il y ait une bonne raison.  En réalité la touche du clavier a le tréma en
haut et l'accent circonflexe pourquoi le second serait joliment présenté
{kbd}`^` et pas le premier ?
:::


:::{list-table} Les majuscules accentuées
:widths: 13 36 51
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère
  - Combinaison de touches (clavier français)
  - Commentaire
* - `À`
  - {kbd}`` ` `` puis {kbd}`⇧` + {kbd}`a`
  - Ou via {kbd}`⇪` puis {kbd}`à`
* - `Â`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`a`
  - Ou {kbd}`⇪` puis {kbd}`^` puis {kbd}`a`, ou via {kbd}`⌥` + {kbd}`z`
* - `É`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`&` (= `´`) suivi de {kbd}`⇧` + {kbd}`e`
  - Ou via {kbd}`⇪` puis {kbd}`é`
* - `È`
  - {kbd}`` ` `` puis {kbd}`⇧` + {kbd}`e`
  - Ou via {kbd}`⇪` puis {kbd}`è`, ou {kbd}`⌥` + {kbd}`k`
* - `Ê`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`e`
  - Ou {kbd}`⌥` + {kbd}`⇧` + {kbd}`e`, ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`e`
* - `Ë`
  - {kbd}`⇧` + {kbd}`^` puis {kbd}`⇧` + {kbd}`e`
  - Ou {kbd}`⌥` + {kbd}`⇧` + {kbd}`k`, ou via {kbd}`⇪` puis {kbd}`⇧` + {kbd}`^` (= `¨`) puis {kbd}`e`
* - `Î`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`i`
  - Ou {kbd}`⌥` + {kbd}`⇧` + {kbd}`h`, ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`i`
* - `Ï`
  - {kbd}`⇧` + {kbd}`^` (= `¨`) puis {kbd}`⇧` + {kbd}`i`
  - Ou {kbd}`⌥` + {kbd}`⇧` + {kbd}`j`, ou via {kbd}`⇪` puis {kbd}`⇧` + {kbd}`^` (= `¨`) puis {kbd}`i`
* - `Ô`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`o`
  - Ou {kbd}`⌥` + {kbd}`⇧` + {kbd}`^`, ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`o`
* - `Ù`
  - {kbd}`⌥` + {kbd}`ù`
  - Ou via {kbd}`⇪` puis {kbd}`ù`
* - `Û`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`u`
  - Ou {kbd}`⌥` + {kbd}`⇧` + {kbd}`!`, ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`u`
* - `Ü`
  - {kbd}`⇧` + {kbd}`^` (= `¨`) puis {kbd}`⇧` + {kbd}`u`
  - Ou via {kbd}`⇪` puis {kbd}`⇧` + {kbd}`^` (= `¨`) puis {kbd}`u`
* - `Ÿ`
  - {kbd}`⇧` + {kbd}`^` (= `¨`) puis {kbd}`⇧` + {kbd}`y`
  - Ou via {kbd}`⇪` puis {kbd}`⇧` + {kbd}`^` puis {kbd}`y`, ou {kbd}`⌥` + {kbd}`⇧` + {kbd}`y` ou {kbd}`⌥` + {kbd}`⇧` + {kbd}`@`
:::



:::{List-table} Autres caractères utilisés en langue française ou avec les moteurs UTF-8
:widths: 12 26 61
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère
  - Combinaison de touches (clavier français)
  - Commentaire
* - `æ`
  - {kbd}`⌥` + {kbd}`a`
  - `æ` peut être vu comme une variante de `a`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `œ`
  - {kbd}`⌥` + {kbd}`o`
  - `œ` peut être vu comme une variante de `o`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `Æ`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`a`
  - `Æ` peut être vu comme une variante de `A`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `Œ`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`o`
  - `Œ` peut être vu comme une variante de `O`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `ç`
  - {kbd}`ç`
  - Immédiat
* - `Ç`
  - {kbd}`⌥` + {kbd}`ç`
  - `Ç` peut être vu comme une variante de `ç`, d'où l'ajout de {kbd}`⌥` pour l'obtenir ({kbd}`⇧` + {kbd}`ç` étant déjà pris pour produire `9`)
* - `«`
  - {kbd}`⌥` + {kbd}`è`
  - Guillemet français ouvrant. Voir les précautions à prendre sur la [page consacrée aux guillemets](/3_composition/texte/symboles/caracteres/guillemets)
* - `»`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`è`
  - Guillemet français fermant. Voir les précautions à prendre sur la [page consacrée aux guillemets](/3_composition/texte/symboles/caracteres/guillemets)
* - `…`
  - {kbd}`⌥` + {kbd}`;`
  - *(Pour LuaLaTeX/XeLaTeX)* `…` peut être vu comme une variante de `.`, d'où l'ajout de {kbd}`⌥` sur la touche du point-virgule pour l'obtenir, le point étant obtenu avec {kbd}`⇧` + {kbd}`;`
* - espace insécable
  - {kbd}`⌥` + {kbd}`espace`
  - *(Pour LuaLaTeX/XeLaTeX)* L'espace insécable peut être vu comme une variante de `espace`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `—` (—)
  - {kbd}`⌥` + {kbd}`-`
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret cadratin (ou tiret long). Peut être vu comme une variante de `-`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `–` (–)
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`-`
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret semi-cadratin (ou tiret moyen)
* - `§`
  - {kbd}`§`
  - Immédiat
* - `€`
  - {kbd}`⌥` + {kbd}`$`
  - `€` peut être vu comme une variante (monétaire) de `$`, d'où l'ajout de {kbd}`⌥` pour l'obtenir. Caractère marqué à droite de la touche {kbd}`$`  
:::


:::{attention}
Pour les utilisateurs de LuaLaTeX/XeLaTeX : le clavier Mac français permet d'obtenir le caractère
º (avec {kbd}`⌥` + {kbd}`u`), mais ce n'est pas le caractère `o` en exposant (pour
produire par exemple l'abréviation du mot "numéro"). Cette combinaison produit en fait le
caractère Unicode U+00BA (Indicateur ordinal masculin), qui est différent du caractère
U+1D52 (Lettre modificative minuscule o), lequel est réellement le `o` en exposant.
:::


## Clavier suisse romand

Le clavier est de type QWERTZ. Ce qui suit s'applique à la méthode de saisie "Suisse romand".

:::{list-table} Les caractères utiles au code TeX et LaTeX
:widths: 15 30 55
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère
  - Combinaison de touches (clavier suisse romand)
  - Commentaire
* - `\`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`7`
  - `/` s'obtient avec {kbd}`⇧` + {kbd}`7`, et `\` peut être vu comme une variante, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `(`
  -  {kbd}`⇧` + {kbd}`8`
  - Caractère marqué au-dessus de la touche {kbd}`8`
* - `)`
  - Caractère marqué au-dessus de la touche {kbd}`9`
  - Immédiat
* - `{`
  - {kbd}`⌥` + {kbd}`8`
  - Variante de `(`, obtenue avec {kbd}`⇧` + {kbd}`8`
* - `}`
  - {kbd}`⌥` + {kbd}`9`
  - Variante de `)`, obtenue avec {kbd}`⇧` + {kbd}`9`
* - `[`
  - {kbd}`⌥` + {kbd}`5`
  -
* - `]`
  - {kbd}`⌥` + {kbd}`6`
  -
* - `_`
  - {kbd}`⇧` + {kbd}`-`
  - Caractère marqué au-dessus de la touche {kbd}`-`. Trait de soulignement, nommé "tiret du 8" dans le monde PC
* - `~`
  - {kbd}`⌥` + {kbd}`n`, puis {kbd}`espace`
  - Caractère nommé *tilde* ; {kbd}`⌥` + {kbd}`n` produit l'accent ` ̃`, surtout utilisé dans ñ (d'où l'association avec `n`), et attend une lettre comme `a`, `n` ou `o` ou encore l'espace pour le tilde tout seul
* - `%`
  - {kbd}`⇧` + {kbd}`5`
  - Caractère marqué au-dessus de la touche {kbd}`5`
* - `&`
  - {kbd}`⇧` + {kbd}`6`
  - Caractère marqué au-dessus de la touche {kbd}`6`
* - `#`
  - {kbd}`⌥` + {kbd}`3`
  - Caractère marqué à droite de la touche {kbd}`3`
* - `$`
  - {kbd}`$`
  - Immédiat
* - `<`
  - {kbd}`<`
  - Immédiat
* - `>`
  - {kbd}`⇧` + {kbd}`<`
  - Caractère marqué au-dessus de la touche {kbd}`<`
* - `@`
  - {kbd}`⌥` + {kbd}`g`
  - Caractère marqué à droite de la touche {kbd}`g`
* - `:`
  - {kbd}`⇧` + {kbd}`.`
  - Caractère marqué au-dessus de la touche {kbd}`.`. Usage courant dans la programmation en LaTeX3
* - `^`
  - {kbd}`^` puis {kbd}`espace`
  -
* - `|`
  - {kbd}`⌥` + {kbd}`7`
  - Caractère nommé *pipe* (tuyau)
:::



:::{list-table} Les majuscules accentuées
:widths: 14 30 56
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère
  - Combinaison de touches (clavier suisse romand)
  - Commentaire
* - `À`
  - {kbd}`⇧` + {kbd}`^` puis {kbd}`⇧` + {kbd}`a`
  - Ou via {kbd}`⇪` puis {kbd}`à`
* - `Â`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`a`
  - Ou {kbd}`⇪` + {kbd}`^` + {kbd}`a`
* - `É`
  - {kbd}`⌥` + {kbd}`^` (= `´`) puis {kbd}`⇧` + {kbd}`e`
  - Ou via {kbd}`⇪` puis {kbd}`é`
* - `È`
  - {kbd}`⌥` puis {kbd}`⇧` + {kbd}`r`
  - Ou via {kbd}`⇪` puis {kbd}`è`, ou {kbd}`⇧` + {kbd}`^` (= {kbd}`` ` ``) puis {kbd}`⇧` + {kbd}`e`
* - `Ê`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`e`
  - Ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`e`
* - `Ë`
  - {kbd}`¨` puis {kbd}`⇧` + {kbd}`e`
  - Ou {kbd}`⌥` + {kbd}`⇪` + {kbd}`e`, ou via {kbd}`⇪` puis {kbd}`¨` puis {kbd}`e`
* - `Î`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`i`
  - Ou {kbd}`⌥` + {kbd}`⇪` + {kbd}`t`, ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`i`
* - `Ï`
  - {kbd}`¨` puis {kbd}`⇧` + {kbd}`i`
  - Ou {kbd}`⇪` puis {kbd}`¨` puis {kbd}`i`
* - `Ô`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`o`
  - Ou {kbd}`⌥` + {kbd}`⇪` + {kbd}`9`, ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`o`
* - `Ù`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`u`
  - Ou {kbd}`⇪` puis {kbd}`⇧` + {kbd}`^` (= {kbd}`` ` ``) puis {kbd}`u`, ou via {kbd}`⇧` + {kbd}`^` (= {kbd}`` ` ``) puis {kbd}`⇧` + {kbd}`u`
* - `Û`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`u`
  - Ou  {kbd}`⇪` puis {kbd}`^` puis {kbd}`u`
* - `Ü`
  - {kbd}`¨` puis {kbd}`⇧` + {kbd}`u`
  - Ou  {kbd}`⇪` puis {kbd}`¨` puis {kbd}`u`
* - `Ÿ`
  - {kbd}`⌥` puis {kbd}`⇧` + {kbd}`y`
  - Ou {kbd}`¨` puis {kbd}`⇧` + {kbd}`y`, ou {kbd}`⇪` puis {kbd}`¨` puis {kbd}`y`  
:::




:::{list-table} Autres caractères utilisés en langue française ou avec les moteurs UTF-8
:widths: 13 30 57
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère
  - Combinaison de touches (Clavier suisse romand)
  - Commentaire
* - `æ`
  - {kbd}`⌥` + {kbd}`à`
  -
* - `œ`
  - {kbd}`⌥` + {kbd}`q`
  -
* - `Æ`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`à`
  -
* - `Œ`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`q`
  -
* - `ç`
  - {kbd}`⇧` + {kbd}`4`
  - Caractère marqué au-dessus de la touche {kbd}`4`
* - `Ç`
  - {kbd}`⌥` + {kbd}`4`
  -
* - `«`
  - {kbd}`⌥` + {kbd}`,`
  - Guillemet français ouvrant. Voir les précautions à prendre sur la [page consacrée aux guillemets](/3_composition/texte/symboles/caracteres/guillemets)
* - `»`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`,`
  - Guillemet français fermant. Voir les précautions à prendre sur la [page consacrée aux guillemets](/3_composition/texte/symboles/caracteres/guillemets)
* - `…`
  - {kbd}`⌥` + {kbd}`.`
  - *(Pour LuaLaTeX/XeLaTeX)* `…` peut être vu comme une variante de `.`, d'où l'ajout de {kbd}`⌥` pour l'obtenir 
* - espace insécable
  - {kbd}`⌥` + {kbd}`espace`
  - *(Pour LuaLaTeX/XeLaTeX)* L'espace insécable peut être vu comme une variante de `espace`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `—` (—)
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`-`
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret cadratin (ou tiret long)
* - `–` (–)
  - {kbd}`⌥` + {kbd}`-`
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret semi-cadratin (ou tiret moyen). Peut être vu comme une variante de `-`, d'où l'ajout de {kbd}`⌥`
* - `§`
  - {kbd}`§`
  - Immédiat
* - `€`
  - {kbd}`⌥` + {kbd}`e`
  -  Caractère marqué à droite de la touche {kbd}`e`. `€` peut être vu comme une variante de `e`, d'où l'ajout de {kbd}`⌥` pour l'obtenir.
:::


:::{attention}
Pour les utilisateurs de LuaLaTeX/XeLaTeX : le clavier Mac suisse romand permet d'obtenir le
caractère º (avec {kbd}`⌥` + {kbd}`j`), mais ce n'est pas le caractère `o` en
exposant (pour produire par exemple l'abréviation du mot "numéro"). Cette combinaison
produit en fait le caractère Unicode U+00BA (Indicateur ordinal masculin), qui est
différent du caractère U+1D52 (Lettre modificative minuscule o), lequel est réellement le
`o` en exposant.
:::


## Clavier canadien français

Le clavier est de type QWERTY. Ce qui suit s'applique à la méthode de saisie "Canadien - CSA" (voir la [norme CAN/CSA_Z243.200](wpfr:CAN/CSA_Z243.200)).

:::{list-table} Les caractères utiles au code TeX et LaTeX
:widths: 13 32 55
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère
  - Combinaison de touches (clavier canadien français)
  - Commentaire
* - `\`
  - {kbd}`⇧` + {kbd}`/`
  - Caractère marqué au-dessus de la touche `/`. Aussi disponible via  {kbd}`⌥` + {kbd}`è` et  {kbd}`⌥` + {kbd}`ù`
* - `(`
  -  {kbd}`⇧` + {kbd}`9`
  - Caractère marqué au-dessus de la touche {kbd}`9`
* - `)`
  - {kbd}`⇧` + {kbd}`0`
  -  Caractère marqué au-dessus de la touche {kbd}`0`
* - `{`
  - {kbd}`⌥` + {kbd}`7`
  - Caractère marqué à droite de la touche {kbd}`7`
* - `}`
  - {kbd}`⌥` + {kbd}`8`
  - Caractère marqué à droite de la touche {kbd}`8`
* - `[`
  - {kbd}`⌥` + {kbd}`9`
  - Caractère marqué à droite de la touche {kbd}`9`. Peut être vu comme variante de `(`, obtenu avec {kbd}`⇧` + {kbd}`9`
* - `]`
  - {kbd}`⌥` + {kbd}`0`
  - Caractère marqué à droite de la touche {kbd}`0`. Peut être vu comme variante de `)`, obtenu avec {kbd}`⇧` + {kbd}`0`
* - `_`
  - {kbd}`⇧` + {kbd}`-`
  - Caractère marqué au-dessus de la touche {kbd}`-`. Trait de soulignement, nommé "tiret du 8" dans le monde PC
* - `~`
  - {kbd}`⌥` + {kbd}`ç`
  - Caractère nommé *tilde*, marqué à droite de la touche {kbd}`ç`. Contrairement aux autres types de clavier (français et suisse romand), cette combinaison produit directement le caractère `~`
* - `%`
  - {kbd}`⇧` + {kbd}`5`
  - Caractère marqué au-dessus de la touche {kbd}`5`
* - `&`
  - {kbd}`⇧` + {kbd}`7`
  - Caractère marqué au-dessus de la touche {kbd}`7`
* - `#`
  - {kbd}`⇧` + {kbd}`3`
  - Caractère marqué au-dessus de la touche {kbd}`3`
* - `$`
  - {kbd}`⇧` + {kbd}`4`
  - Caractère marqué au-dessus de la touche {kbd}`4`
* - `<`
  - {kbd}`⌥` + {kbd}`,`
  - Caractère marqué à droite de la touche {kbd}`,`
* - `>`
  - {kbd}`⌥` + {kbd}`.`
  - Caractère marqué à droite de la touche {kbd}`.`
* - `@`
  - {kbd}`⇧` + {kbd}`2`
  - Caractère marqué au-dessus de la touche `2`
* - `:`
  - {kbd}`⇧` + {kbd}`;`
  - Caractère marqué au-dessus de la touche `;`. Usage courant dans la programmation en LaTeX3
* - `^`
  - {kbd}`^` puis {kbd}`espace`
  -
* - `|`
  - {kbd}`⌥` + {kbd}`/`
  - Caractère nommé *pipe* (tuyau), marqué à droite de la touche {kbd}`/`. Aussi disponible via  {kbd}`⌥` + {kbd}`-`
:::



:::{list-table} Les majuscules accentuées
:widths: 13 32 55
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère
  - Combinaison de touches (clavier canadien français)
  - Commentaire
* - `À`
  - {kbd}`⇧` + {kbd}`à`
  - Ou via {kbd}`⇪` puis {kbd}`à`
* - `Â`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`a`
  - Ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`a`
* - `É`
  - {kbd}`⇧` + {kbd}`é`
  - Ou via {kbd}`⇪` puis {kbd}`é`
* - `È`
  - {kbd}`⇧` + {kbd}`è`
  - Ou via {kbd}`⇪` puis {kbd}`è`
* - `Ê`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`e`
  - Ou via {kbd}`⇪` puis  {kbd}`^` puis {kbd}`e`
* - `Ë`
  - {kbd}`⇧` + {kbd}`^` puis {kbd}`⇧` + {kbd}`e`
  - Ou via {kbd}`⇪` puis {kbd}`⇧` + {kbd}`^` puis {kbd}`e`
* - `Î`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`i`
  - Ou via {kbd}`⇪` puis  {kbd}`^` puis {kbd}`i`
* - `Ï`
  - {kbd}`⇧` + {kbd}`^` puis {kbd}`⇧` + {kbd}`i`
  - Ou via {kbd}`⇪` puis {kbd}`⇧` + {kbd}`^` puis {kbd}`i`
* - `Ô`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`o`
  - Ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`o`
* - `Ù`
  - {kbd}`⇧` + {kbd}`ù`
  - Ou via {kbd}`⇪` puis {kbd}`ù`
* - `Û`
  - {kbd}`^` puis {kbd}`⇧` + {kbd}`u`
  - Ou via {kbd}`⇪` puis {kbd}`^` puis {kbd}`u`
* - `Ü`
  - {kbd}`⇧` + {kbd}`^` puis {kbd}`⇧` + {kbd}`u`
  - Ou via {kbd}`⇪` puis {kbd}`⇧` + {kbd}`^` puis {kbd}`u`
* - `Ÿ`
  - {kbd}`⇧` + {kbd}`^` puis {kbd}`⇧` + {kbd}`y`
  - Ou via {kbd}`⇪` puis {kbd}`⇧` + {kbd}`^` puis {kbd}`y`
:::



:::{list-table} Autres caractères utilisés en langue française ou avec les moteurs UTF-8
:widths: 13 31 56
:header-rows: 1
:stub-columns: 1
:align: left
:class: longtable

* - Caractère
  - Combinaison de touches (clavier canadien français)
  - Commentaire
* - `æ`
  - {kbd}`⌥` + {kbd}`a`
  - `æ` peut être vu comme une variante de `a`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `œ`
  - {kbd}`⌥` + {kbd}`q`
  -
* - `Æ`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`a`
  - `Æ` peut être vu comme une variante de `A`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `Œ`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`q`
  -
* - `ç`
  - {kbd}`ç`
  - Immédiat
* - `Ç`
  - {kbd}`⇧` + {kbd}`ç`
  -
* - `«`
  - {kbd}`⌥` + {kbd}`z`
  - Guillemet français ouvrant. Caractère marqué à droite de la touche {kbd}`z`. Voir les précautions à prendre sur la [page consacrée aux guillemets](/3_composition/texte/symboles/caracteres/guillemets)
* - `»`
  - {kbd}`⌥` + {kbd}`x`
  - Guillemet français fermant. Caractère marqué à droite de la touche {kbd}`x`. Voir les précautions à prendre sur la [page consacrée aux guillemets](/3_composition/texte/symboles/caracteres/guillemets)
* - `…`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`l`
  - *(Pour LuaLaTeX/XeLaTeX)*
* - espace insécable
  - {kbd}`⌥` + {kbd}`espace`
  - *(Pour LuaLaTeX/XeLaTeX)* L'espace insécable peut être vu comme une variante de `espace`, d'où l'ajout de {kbd}`⌥` pour l'obtenir
* - `—` (—)
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`0`
  - *(Pour LuaLaTeX/XeLaTeX)* Tiret cadratin (ou tiret long)
* - `–` (–)
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`=`
  - *(Pour LuaLaTeX/XeLaTex)* Tiret semi-cadratin (ou tiret moyen)
* - `§`
  - {kbd}`⌥` + {kbd}`⇧` + {kbd}`s`
  - Pour s'en souvenir, on peut voir le caractère `§` comme deux `S` imbriqués
* - `€`
  - {kbd}`⌥` + {kbd}`4`
  - On peut se souvenir de la combinaison pour obtenir ce caractère en considérant que `€` est une variante de `$`, lequel est obtenu avec {kbd}`⇧` + {kbd}`4`
:::


(saisieUnicode)=
## Méthode de saisie Unicode

Quel que soit le clavier physique lié au Mac, il est possible de sélectionner la méthode
de saisie "Universel (Unicode Hex)" (cherchez "Méthode de saisie" dans l'aide intégrée à
macOS ou sur les pages d'assistance d'Apple ou encore avec Spotlight, accessible via la loupe dans
la barre des menus ou avec le raccourci qui par défaut est {kbd}`⌘` + {kbd}`espace`).

:::{tip}
On peut dans la configuration de « Clavier » dans « Réglages Système »
(anciennement « Préférences Système ») demander l'affichage dans la
[barre des menus](wpfr:Barre_de_menu) d'un « Menu des méthodes de saisie »,
qui est signalé par un drapeau représentant la méthode de saisie active,
et permet de basculer d'une méthode de saisie à une autre. La
liste des méthodes de saisie proposées peut être modifiée dans la
configuration de « Clavier ».
:::

Cette méthode permet d'entrer tout caractère Unicode, pourvu qu'on en connaisse son code
hexadécimal. Le principe consiste, tout en maintenant la touche {kbd}`⌥` enfoncée, à
taper le code hexadécimal du caractère souhaité. Ainsi, pour contribuer à cette FAQ, vous
pourriez avoir besoin de saisir les caractères `⟨` et `⟩` (cf. la page sur la syntaxe des
[éléments de code variables](elements-de-code-variables), qui par ailleurs
décrit une méthode permettant de saisir les caractères `⟨` et `⟩` directement au clavier, par la création d'une nouvelle *disposition de clavier*).
Ces caractères s'obtiennent respectivement
avec  {kbd}`⌥` + {kbd}`2`{kbd}`7`{kbd}`e`{kbd}`8` et {kbd}`⌥` + {kbd}`2`{kbd}`7`{kbd}`e`{kbd}`9`.

:::{todo}
La présentation {kbd}`2`{kbd}`7`{kbd}`e`{kbd}`8` est problématique car il faut
comprendre qu'il s'agit de produire les caractères en question, ce qui sur le
clavier macOS français AZERTY nécessite la touche majuscule {kbd}`⇧` pour les
chiffres.  Dans les mêmes circonstances, d'autres portions de cette page le
précisent explicitement, faisant référence au caractère du clavier présent sur
le bas de la touche, donc {kbd}`⇧` + {kbd}`é` pour obtenir `2` par exemple.
:::


:::{note}
Les lettres du code hexadécimal peuvent être indifféremment tapées en minuscules ou en 
majuscules.
:::

:::{note}
Les éditeurs de texte utiles aux développeurs de code peuvent fournir leurs
propres méthodes de saisie de caractères Unicode, ce qui est utile car
multi-plateforme et évite d'avoir à jongler dans le Système entre plusieurs
méthodes de saisie.  Par exemple {program}`Emacs` permet de rentrer n'importe
quel caractère Unicode en préfixant le code hexadécimal ou le nom Unicode par
`C-x 8 RET`, c'est-à-dire par {kbd}`Ctrl` et {kbd}`x` simultanément puis `8`
et ensuite la touche de retour chariot.
:::

(visualiseur-de-clavier)=
### Le visualiseur de clavier

Pour accéder à un caractère spécifique, une méthode consiste à passer par le «
Visualiseur de clavier » qui s'obtient via le menu de saisie de la
[barre des menus](wpfr:Barre_de_menu), et d'observer sur le clavier ainsi
affiché à l'écran les changements résultant de l'emploi des touches de
modification {kbd}`⌥`, {kbd}`⇧`, {kbd}`Ctrl` et autres, utilisées isolément ou
simultanément.

### Le visualiseur de caractères

Pour retrouver un caractère une autre méthode 
consiste à utiliser le « Visualiseur de caractères », qui s'obtient en 
choisissant "Afficher Emoji et symboles" dans le menu des Méthodes de saisie disponible dans [barre des menus](wpfr:Barre_de_menu).

Par
défaut, cette palette n'affiche que les Emojis, mais en cliquant sur la petite icône en 
haut à droite, on accède à l'interface générale. Par le menu en haut à gauche de la 
palette, on peut choisir ses sections préférées en personnalisant une liste des catégories 
de caractères que l'on souhaite voir affichées (par exemple des caractères cyrilliques, ou 
le tableau Unicode de l'ensemble des caractères). Une fois le caractère trouvé, on 
double-clique dessus pour l'insérer au niveau de l'emplacement actuel du curseur dans l'éditeur de texte.

