; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=thumbv7em-apple-unknown-macho < %s | FileCheck %s

target datalayout = "e-m:o-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64"

declare void @llvm.memcpy.p0.p0.i32(ptr noalias nocapture writeonly, ptr noalias nocapture readonly, i32, i1 immarg) #0
declare void @llvm.memmove.p0.p0.i32(ptr noalias nocapture writeonly, ptr noalias nocapture readonly, i32, i1 immarg) #0
declare void @llvm.memset.p0.i32(ptr noalias nocapture writeonly, i8, i32, i1 immarg) #0

; Check we don't expand memcpy to a loop when the caller
; even if we have no-builtins attached.

; CHECK: bl _memcpy
define arm_aapcs_vfpcc void @test_memcpy(ptr %p1, ptr %p2) #1 {
  call void @llvm.memcpy.p0.p0.i32(ptr %p1, ptr %p2, i32 128, i1 false)
  ret void
}

; CHECK: bl _memmove
define arm_aapcs_vfpcc void @test_memmove(ptr %p1, ptr %p2) #1 {
  call void @llvm.memmove.p0.p0.i32(ptr %p1, ptr %p2, i32 128, i1 false)
  ret void
}

; CHECK: bl _memset
define arm_aapcs_vfpcc void @test_memset(ptr %p1) #1 {
  call void @llvm.memset.p0.i32(ptr %p1, i8 0, i32 128, i1 false)
  ret void
}

attributes #0 = { nocallback nofree nounwind willreturn memory(argmem: readwrite) }
attributes #1 = { "no-builtins" }
