/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __SOC_MEDIATEK_MT8365_MMSYS_H
#define __SOC_MEDIATEK_MT8365_MMSYS_H

#define MT8365_DISP_REG_CONFIG_DISP_OVL0_MOUT_EN	0xf3c
#define MT8365_DISP_REG_CONFIG_DISP_RDMA0_SOUT_SEL	0xf4c
#define MT8365_DISP_REG_CONFIG_DISP_DITHER0_MOUT_EN	0xf50
#define MT8365_DISP_REG_CONFIG_DISP_RDMA0_SEL_IN	0xf54
#define MT8365_DISP_REG_CONFIG_DISP_RDMA0_RSZ0_SEL_IN	0xf60
#define MT8365_DISP_REG_CONFIG_DISP_COLOR0_SEL_IN	0xf64
#define MT8365_DISP_REG_CONFIG_DISP_DSI0_SEL_IN		0xf68
#define MT8365_DISP_REG_CONFIG_DISP_RDMA1_SOUT_SEL	0xfd0
#define MT8365_DISP_REG_CONFIG_DISP_DPI0_SEL_IN		0xfd8
#define MT8365_DISP_REG_CONFIG_DISP_LVDS_SYS_CFG_00	0xfdc

#define MT8365_DISP_MS_IN_OUT_MASK			GENMASK(3, 0)
#define MT8365_RDMA0_SOUT_COLOR0			0x1
#define MT8365_DITHER_MOUT_EN_DSI0			BIT(0)
#define MT8365_DSI0_SEL_IN_DITHER			0x1
#define MT8365_RDMA0_SEL_IN_OVL0			0x0
#define MT8365_RDMA0_RSZ0_SEL_IN_RDMA0			0x0
#define MT8365_DISP_COLOR_SEL_IN_COLOR0			0x0
#define MT8365_OVL0_MOUT_PATH0_SEL			BIT(0)
#define MT8365_RDMA1_SOUT_DPI0				0x1
#define MT8365_DPI0_SEL_IN_RDMA1			0x0
#define MT8365_LVDS_SYS_CFG_00_SEL_LVDS_PXL_CLK		0x1
#define MT8365_DPI0_SEL_IN_RDMA1			0x0

static const struct mtk_mmsys_routes mt8365_mmsys_routing_table[] = {
	MMSYS_ROUTE(OVL0, RDMA0,
		    MT8365_DISP_REG_CONFIG_DISP_OVL0_MOUT_EN,
		    MT8365_DISP_MS_IN_OUT_MASK, MT8365_OVL0_MOUT_PATH0_SEL),
	MMSYS_ROUTE(OVL0, RDMA0,
		    MT8365_DISP_REG_CONFIG_DISP_RDMA0_SEL_IN,
		    MT8365_DISP_MS_IN_OUT_MASK, MT8365_RDMA0_SEL_IN_OVL0),
	MMSYS_ROUTE(RDMA0, COLOR0,
		    MT8365_DISP_REG_CONFIG_DISP_RDMA0_SOUT_SEL,
		    MT8365_DISP_MS_IN_OUT_MASK, MT8365_RDMA0_SOUT_COLOR0),
	MMSYS_ROUTE(COLOR0, CCORR,
		    MT8365_DISP_REG_CONFIG_DISP_COLOR0_SEL_IN,
		    MT8365_DISP_MS_IN_OUT_MASK, MT8365_DISP_COLOR_SEL_IN_COLOR0),
	MMSYS_ROUTE(DITHER0, DSI0,
		    MT8365_DISP_REG_CONFIG_DISP_DITHER0_MOUT_EN,
		    MT8365_DISP_MS_IN_OUT_MASK, MT8365_DITHER_MOUT_EN_DSI0),
	MMSYS_ROUTE(DITHER0, DSI0,
		    MT8365_DISP_REG_CONFIG_DISP_DSI0_SEL_IN,
		    MT8365_DISP_MS_IN_OUT_MASK, MT8365_DSI0_SEL_IN_DITHER),
	MMSYS_ROUTE(RDMA0, COLOR0,
		    MT8365_DISP_REG_CONFIG_DISP_RDMA0_RSZ0_SEL_IN,
		    MT8365_DISP_MS_IN_OUT_MASK, MT8365_RDMA0_RSZ0_SEL_IN_RDMA0),
	MMSYS_ROUTE(RDMA1, DPI0,
		    MT8365_DISP_REG_CONFIG_DISP_LVDS_SYS_CFG_00,
		    MT8365_LVDS_SYS_CFG_00_SEL_LVDS_PXL_CLK,
		    MT8365_LVDS_SYS_CFG_00_SEL_LVDS_PXL_CLK),
	MMSYS_ROUTE(RDMA1, DPI0,
		    MT8365_DISP_REG_CONFIG_DISP_DPI0_SEL_IN,
		    MT8365_DISP_MS_IN_OUT_MASK, MT8365_DPI0_SEL_IN_RDMA1),
	MMSYS_ROUTE(RDMA1, DPI0,
		    MT8365_DISP_REG_CONFIG_DISP_RDMA1_SOUT_SEL,
		    MT8365_DISP_MS_IN_OUT_MASK, MT8365_RDMA1_SOUT_DPI0),
};

#endif /* __SOC_MEDIATEK_MT8365_MMSYS_H */
