/*-
 * Copyright (c) 1994 by David Bagley.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Revision History:
 * 09-Nov-2010: Cubic close packing (-neighbors 14)
 * 28-Jun-2004: LIFE_NAMES compile-time option.
 * 02-Jun-2004: Lots more lifeforms.
 * 16-Apr-2004: S45B5 shower, blob with stabilizers, big pinwheel,
 *	      pulsar 10, pulsar 20
 * 15-Apr-2004: S45B5 linked glider, 123243, dancing beacon, Lq
 *	      B6/S567 sparky, fountain, cruncher, big star, mouth
 *	      B5/S56 double switch
 *	      B5/S678 waving tail, deformed runner
 *	      BS67/S67 pump
 *	      Found with life4d searcher by Lee Earl Meeker.
 * 13-Mar-2004: Updated with minimum points from:
 *	      Lee Earl Meeker's "Four Dimensional Cellular Automata and
 *	      the Game of Life" 1998
 *	      http://home.sc.rr.com/lmeeker/Lee/Home.html
 * 25-Jan-2003: File spawned from life3d.c, life forms from Carter Bays.
 *
 */

#define MAXNEIGHBORS 26
#define NEIGHBORKINDS 11
#define NUMPTS 42

typedef struct {
	int	 birth, survival;
} paramstruct;

static char plots[NEIGHBORKINDS] =
{
	6, 8, 12, 14, -14, 16, 18, -18, 20, 22, 26	/* Neighborhoods */
};

/* https://www.sillycycle.com/life.html */
/* Below generated from java Life3DForms | dos2unix */
static char glider_12B3S3[][3 * NUMPTS + 1] =
{
	{
        2, 0, 0,

        1, 0, 1, 3, 0, 1,

        1, 1, 2, 3, 1, 2,
        2, 2, 2,

        2, 1, 3,
        127
	},
	{
        1, 1, 0,

        1, 0, 1,
        1, 2, 1,

        1, 1, 2,

        0, 3, 3, 2, 3, 3,

        0, 4, 4, 2, 4, 4,
        1, 5, 4,

        1, 4, 5,
        127
	},
	{
        1, 1, 0,

        1, 0, 1,
        0, 3, 1, 2, 3, 1,

        1, 1, 2,
        1, 3, 2,

        1, 2, 3,

        1, 3, 4,

        0, 4, 6, 2, 4, 6,
        1, 5, 6,

        1, 4, 7,
        0, 5, 7, 2, 5, 7,
        127
	},
	{
        0, 0, 0, 6, 0, 0,

        3, 0, 1,
        0, 1, 1, 2, 1, 1, 4, 1, 1, 6, 1, 1,

        0, 2, 2, 2, 2, 2, 4, 2, 2, 6, 2, 2,
        1, 3, 2, 5, 3, 2,

        1, 2, 3, 5, 2, 3,
        127
	},
};

static char glider_12B3S456[][3 * NUMPTS + 1] =
{
	{
        0, 1, 1, 2, 1, 1,

        2, 0, 2,
        1, 1, 2,

        1, 0, 3,
        2, 1, 3,

        0, 0, 4, 2, 0, 4,
        127
	},
};

static char glider_14B4S34[][3 * NUMPTS + 1] =
{
	{
        2, 1, 0,

         1, 1, 1, 2, 1, 1,
         2, 0, 1,

        1, 2, 2, 2, 2, 2,

         0, 0, 3,
         0, 1, 3,

        0, 1, 4,
        0, 2, 4, 1, 2, 4,

         0, 1, 5,
        127
	},
};

static char glider_14B46S34[][3 * NUMPTS + 1] =
{
	{
        2, 1, 0,

         1, 1, 1, 2, 1, 1,
         2, 0, 1,

        1, 2, 2, 2, 2, 2,

         0, 0, 3,
         0, 1, 3,

        0, 1, 4,
        0, 2, 4, 1, 2, 4,

         0, 1, 5,
        127
	},
};

static char glider_18B4S45[][3 * NUMPTS + 1] =
{
	{
        0, 0, 0, 1, 0, 0,
        1, 1, 0,
        1, 2, 0,
        0, 3, 0, 1, 3, 0,

        0, 0, 1, 1, 0, 1,
        1, 1, 1,
        1, 2, 1,
        0, 3, 1, 1, 3, 1,
        127
	},
	{
        0, 0, 0, 1, 0, 0,
        0, 1, 0, 1, 1, 0,

        1, 0, 1,
        1, 1, 1,

        1, 0, 2,
        1, 1, 2,

        0, 0, 3, 1, 0, 3,
        0, 1, 3, 1, 1, 3,
        127
	},
	{
        0, 1, 0, 2, 1, 0,
        1, 2, 0,

        1, 0, 1,
        0, 1, 1, 2, 1, 1,
        0, 2, 1, 1, 2, 1, 2, 2, 1,

        1, 1, 2,
        127
	},
};

static char glider__18B4S36[][3 * NUMPTS + 1] =
{
	{
        2, 3, 1,

        1, 3, 2,
        2, 4, 2,

        0, 3, 3, 2, 3, 3,
        1, 4, 3,
        2, 5, 3,

        2, 0, 4,
        1, 1, 4,
        0, 2, 4, 2, 2, 4,

        2, 1, 5,
        1, 2, 5,

        2, 2, 6,
        127
	},
};

static char glider__18B4S46[][3 * NUMPTS + 1] =
{
	{
        0, 0, 0,
        0, 2, 0,
        1, 1, 0,

        1, 0, 1,
        2, 1, 1,
        1, 2, 1,

        0, 0, 2,
	1, 1, 2,
        0, 2, 2,
        127
	},
};

static char glider_20B4S45[][3 * NUMPTS + 1] =
{
	{
        1, 0, 0,
        2, 1, 0,
        2, 2, 0,
        1, 3, 0,

        1, 0, 1,
        0, 1, 1, 1, 1, 1, 2, 1, 1,
        0, 2, 1, 1, 2, 1, 2, 2, 1,
        1, 3, 1,
        127
	},
	{
        1, 0, 0,
        1, 1, 0,

        2, 0, 1,
        0, 1, 1, 1, 1, 1, 2, 1, 1,

        2, 0, 2,
        0, 1, 2, 1, 1, 2, 2, 1, 2,

        1, 0, 3,
        1, 1, 3,
        127
	},
};

static char glider_22B4S3[][3 * NUMPTS + 1] =
{
	{
        1, 3, 1,
        1, 5, 1,
        1, 1, 3,
        1, 3, 3,
        1, 5, 3,
        1, 7, 3,
        1, 1, 5,
        1, 5, 5,
        1, 7, 5,
        1, 3, 5,
        1, 3, 7,
        1, 5, 7,
        127
	},
	{
        3, 3, 1,
        5, 7, 1,

        7, 1, 3,
        3, 3, 3,
        3, 5, 3,
  
        5, 3, 5,
        5, 5, 5, 7, 5, 5,
        127
	},
	{
        3, 5, 3,

        7, 1, 5,
        9, 3, 5,
        1, 7, 5,
        3, 9, 5, 5, 9, 5,
  
        7, 1, 7,
        9, 3, 7,
        1, 5, 7,
        1, 7, 7,
        3, 9, 7,

        5, 7, 9,
        127
	},
};

static char glider_22B4S4[][3 * NUMPTS + 1] =
{
	{
        1, 1, 1,
        1, 3, 1,

        3, 1, 3,
        3, 3, 3,

        3, 1, 5,
        3, 3, 5,
        127
	},
	{
        1, 1, 3, 3, 1, 3, 7, 1, 3,
        1, 3, 3, 3, 3, 3, 7, 3, 3,

        1, 1, 5, 3, 1, 5, 9, 1, 5,
        1, 3, 5, 3, 3, 5, 9, 3, 5,

        9, 1, 7,
        9, 3, 7,
        127
	},
};

static char glider_26B5S23[][3 * NUMPTS + 1] =
{
	{
        0, 0, 0,
        1, 1, 0,
        1, 2, 0,
        0, 3, 0,

        1, 0, 1,
        1, 3, 1,

        1, 0, 2,
        1, 3, 2,

        0, 0, 3,
        1, 1, 3,
        1, 2, 3,
        0, 3, 3,
        127
	},
};

static char glider_26B5S25[][3 * NUMPTS + 1] =
{
	{
        1, 0, 0,
        1, 1, 0,
        0, 2, 0, 1, 2, 0,
        1, 3, 0,
        0, 4, 0, 1, 4, 0,
        1, 5, 0,
        1, 6, 0,

        1, 0, 1,
        1, 2, 1,
        1, 4, 1,
        1, 6, 1,
        127
	},
};

static char glider_26B5S27[][3 * NUMPTS + 1] =
{
	{
        2, 1, 0,

        2, 0, 1,
        2, 2, 1,

        0, 0, 2, 2, 0, 2,
        0, 2, 2, 2, 2, 2,

        0, 0, 3, 2, 0, 3,
        0, 2, 3, 2, 2, 3,

        2, 0, 4,
        2, 2, 4,

        2, 1, 5,
        127
	},
};

static char glider_26B5S35[][3 * NUMPTS + 1] =
{
	{
        2, 2, 0,
        3, 3, 0,
        3, 4, 0,
        2, 5, 0,

        2, 2, 1,
        2, 5, 1,

        0, 0, 2, 1, 0, 2,
        2, 1, 2,
        3, 2, 2,
        3, 5, 2,
        2, 6, 2,
        0, 7, 2, 1, 7, 2,

        2, 2, 3,
        2, 5, 3,

        2, 2, 4,
        3, 3, 4,
        3, 4, 4,
        2, 5, 4,
        127
	},
};

static char glider_26B5S36[][3 * NUMPTS + 1] =
{
	{
        0, 2, 0,
        0, 3, 0,

        1, 2, 1,
        1, 3, 1,

        0, 0, 2,
        1, 1, 2,
        1, 2, 2,
        1, 3, 2,
        1, 4, 2,
        0, 5, 2,

        0, 0, 3,
        1, 1, 3,
        1, 2, 3,
        1, 3, 3,
        1, 4, 3,
        0, 5, 3,

        1, 2, 4,
        1, 3, 4,

        0, 2, 5,
        0, 3, 5,
        127
	},
};

static char glider_26B5S37[][3 * NUMPTS + 1] =
{
	{
        0, 2, 0,

        0, 1, 1, 1, 1, 1,
        0, 2, 1, 1, 2, 1,
        0, 3, 1, 1, 3, 1,

        0, 0, 2,
        0, 1, 2, 1, 1, 2,
        0, 3, 2, 1, 3, 2,
        0, 4, 2,

        0, 1, 3, 1, 1, 3,
        0, 2, 3, 1, 2, 3,
        0, 3, 3, 1, 3, 3,

        0, 2, 4,
        127
	},
};

static char glider_26B5S38[][3 * NUMPTS + 1] =
{
	{
        1, 0, 2, 2, 0, 2,
        1, 1, 2, 2, 1, 2,
        0, 2, 2, 1, 2, 2, 2, 2, 2, 3, 2, 2,

        1, 1, 3, 2, 1, 3,
        1, 2, 3, 2, 2, 3,
        127
	},
	{
        1, 0, 0, 2, 0, 0,

        0, 0, 1, 3, 0, 1,

        1, 0, 2, 2, 0, 2,
        1, 1, 2, 2, 1, 2,
        0, 2, 2, 1, 2, 2, 2, 2, 2, 3, 2, 2,

        1, 1, 3, 2, 1, 3,
        1, 2, 3, 2, 2, 3,
        127
	},
};

static char glider_26B5S4[][3 * NUMPTS + 1] =
{
	{
        0, 0, 0,
        1, 1, 0,
        1, 2, 0,
        0, 3, 0,

        1, 1, 1,
        1, 2, 1,

        1, 0, 2,
        1, 1, 2,
        1, 2, 2,
        1, 3, 2,

        1, 0, 3,
        1, 1, 3,
        1, 2, 3,
        1, 3, 3,

        1, 1, 4,
        1, 2, 4,

        0, 0, 5,
        1, 1, 5,
        1, 2, 5,
        0, 3, 5,
        127
	},
};

static char glider_26B5S45[][3 * NUMPTS + 1] =
{
	{
        0, 0, 0, 0, 1, 0,
        1, 2, 0,
        2, 2, 0,
        3, 0, 0, 3, 1, 0,

        1, 0, 1, 1, 1, 1,
        2, 0, 1, 2, 1, 1,
        127
	},
};

static char glider_26B5S47[][3 * NUMPTS + 1] =
{
	{
        0, 0, 0,
        0, 2, 0, 1, 2, 0,
        0, 4, 0,

        1, 1, 1,
        1, 2, 1,
        1, 3, 1,

        0, 0, 2, 1, 0, 2,
        1, 1, 2,
        1, 3, 2,
        0, 4, 2, 1, 4, 2,

        1, 1, 3,
        1, 2, 3,
        1, 3, 3,

        0, 0, 4,
        0, 2, 4, 1, 2, 4,
        0, 4, 4,
        127
	},
};

static char glider_26B5S56[][3 * NUMPTS + 1] =
{
	{
        0, 1, 0,
        1, 2, 0,
        0, 3, 0,

        0, 0, 1, 1, 0, 1,
        1, 1, 1,
        1, 3, 1,
        0, 4, 1, 1, 4, 1,

        0, 0, 2, 1, 0, 2,
        1, 1, 2,
        1, 3, 2,
        0, 4, 2, 1, 4, 2,

        0, 1, 3,
        1, 2, 3,
        0, 3, 3,
        127
	},
	{
        0, 1, 0, 1, 1, 0,
        0, 2, 0, 1, 2, 0,

        0, 0, 1,
        1, 1, 1,
        1, 2, 1,
        0, 3, 1,

        1, 0, 2,
        1, 3, 2,

        0, 0, 3,
        0, 3, 3,

        1, 1, 3,
        1, 2, 3,

        0, 1, 4, 1, 1, 4,
        0, 2, 4, 1, 2, 4,
        127
	},
	{
        1, 2, 0,
        0, 3, 0, 2, 3, 0,
        1, 4, 0, 2, 4, 0,

        1, 3, 1,
        1, 4, 1,

        1, 0, 2,

        0, 0, 3, 2, 0, 3,
        1, 1, 3,

        1, 0, 4, 2, 0, 4,
        1, 1, 4,
        127
	},
};

static char glider_26B5S58[][3 * NUMPTS + 1] =
{
	{
        1, 3, 0, 2, 3, 0,

        1, 2, 1, 2, 2, 1,
        1, 3, 1, 2, 3, 1,

        1, 0, 2, 2, 0, 2,
        0, 2, 2, 1, 2, 2, 2, 2, 2, 3, 2, 2,
        1, 3, 2, 2, 3, 2,
        127
	},
	{
        1, 3, 0, 2, 3, 0,
        0, 1, 0, 3, 1, 0,

        1, 2, 1, 2, 2, 1,
        1, 3, 1, 2, 3, 1,

        1, 0, 2, 2, 0, 2,
        0, 2, 2, 1, 2, 2, 2, 2, 2, 3, 2, 2,
        1, 3, 2, 2, 3, 2,
        127
	},
	{
        1, 3, 0, 2, 3, 0,
        0, 1, 0,

        1, 2, 1, 2, 2, 1,
        1, 3, 1, 2, 3, 1,

        1, 0, 2, 2, 0, 2,
        0, 2, 2, 1, 2, 2, 2, 2, 2, 3, 2, 2,
        1, 3, 2, 2, 3, 2,
        127
	},
	{
        1, 1, 0, 2, 1, 0,

        1, 0, 1, 2, 0, 1,
        0, 2, 1, 3, 2, 1,
        1, 3, 1, 2, 3, 1,

        1, 3, 2, 2, 3, 2,
        1, 4, 2, 2, 4, 2,

        0, 3, 3, 1, 3, 3, 2, 3, 3, 3, 3, 3,
        1, 4, 3, 2, 4, 3,
        127
	},
	{
        1, 2, 0,
        1, 3, 0,

        0, 1, 1,
        1, 2, 1,
        1, 3, 1,
        0, 4, 1,

        1, 0, 2,
        1, 1, 2,
        1, 4, 2,
        1, 5, 2,

        1, 0, 3,
        1, 1, 3,
        1, 4, 3,
        1, 5, 3,

        0, 1, 4,
        1, 2, 4,
        1, 3, 4,
        0, 4, 4,

        1, 2, 5,
        1, 3, 5,
        127
	},
};

static char glider_26B5S678[][3 * NUMPTS + 1] =
{
	{
        1, 0, 0, 2, 0, 0,

        1, 0, 1, 2, 0, 1,
        1, 1, 1, 2, 1, 1,

        0, 0, 2, 1, 0, 2, 2, 0, 2, 3, 0, 2,
        1, 1, 2, 2, 1, 2,
        127
	},
	{
        1, 0, 0, 3, 0, 0,

        0, 0, 1, 2, 0, 1, 4, 0, 1,
        1, 1, 1, 3, 1, 1,

        1, 0, 2, 3, 0, 2,

        0, 0, 3, 2, 0, 3, 4, 0, 3,
        1, 1, 3, 3, 1, 3,

        1, 0, 4, 3, 0, 4,
        127
	},
};

static char glider_26B5S8[][3 * NUMPTS + 1] =
{
	{
        1, 0, 0, 2, 0, 0,

        1, 0, 1, 2, 0, 1,
        1, 1, 1, 2, 1, 1,

        0, 0, 2, 1, 0, 2, 2, 0, 2, 3, 0, 2,
        1, 1, 2, 2, 1, 2,
        127
	},
	{
        1, 0, 0,
        1, 2, 0, 2, 2, 0,

        1, 2, 1, 2, 2, 1,
        1, 3, 1, 2, 3, 1,

        0, 2, 2, 1, 2, 2, 2, 2, 2, 3, 2, 2,
        1, 3, 2, 2, 3, 2,
        127
	},
	{
        1, 1, 0, 2, 1, 0,

        1, 0, 1, 2, 0, 1,
        0, 2, 1, 3, 2, 1,
        1, 3, 1, 2, 3, 1,

        1, 3, 2, 2, 3, 2,
        1, 4, 2, 2, 4, 2,

        0, 3, 3, 1, 3, 3, 2, 3, 3, 3, 3, 3,
        1, 4, 3, 2, 4, 3,
        127
	},
};

static char glider_26B58S58[][3 * NUMPTS + 1] =
{
	{
        1, 3, 0, 2, 3, 0,

        1, 2, 1, 2, 2, 1,
        1, 3, 1, 2, 3, 1,

        1, 0, 2, 2, 0, 2,
        0, 2, 2, 1, 2, 2, 2, 2, 2, 3, 2, 2,
        1, 3, 2, 2, 3, 2,
        127
	},
	{
        2, 1, 0,
        2, 2, 0,

        2, 0, 1,
        2, 1, 1,
        2, 2, 1,
        2, 3, 1,

        2, 0, 2,
        2, 1, 2,
        2, 2, 2,
        2, 3, 2,

        2, 1, 3,
        2, 2, 3,
        0, 3, 3,
        127
	},
	{
        0, 0, 0,
        2, 1, 0,
        2, 2, 0,

        2, 0, 1,
        2, 1, 1,
        2, 2, 1,
        2, 3, 1,

        2, 0, 2,
        2, 1, 2,
        2, 2, 2,
        2, 3, 2,

        2, 1, 3,
        2, 2, 3,
        0, 3, 3,
        127
	},
	{
        0, 1, 0, 1, 1, 0,
        0, 2, 0, 1, 2, 0,

        1, 0, 1,
        1, 1, 1,
        1, 2, 1,
        1, 3, 1,

        1, 0, 2,
        1, 1, 2,
        1, 2, 2,
        1, 3, 2,

        0, 1, 3, 1, 1, 3,
        0, 2, 3, 1, 2, 3,
        127
	},
	{
        0, 0, 0,
        0, 1, 0, 2, 1, 0,
        2, 2, 0,
        0, 3, 0,

        2, 0, 1,
        2, 1, 1,
        2, 2, 1,
        0, 3, 1, 2, 3, 1,

        0, 0, 2, 2, 0, 2,
        2, 1, 2,
        2, 2, 2,
        2, 3, 2,

        0, 0, 3,
        2, 1, 3,
        0, 2, 3, 2, 2, 3,
        0, 3, 3,
        127
	},
	{
        0, 0, 0,
        2, 1, 0,
        2, 2, 0,
        0, 3, 0,

        2, 0, 1,
        0, 1, 1, 2, 1, 1,
        0, 2, 1, 2, 2, 1,
        2, 3, 1,

        2, 0, 2,
        0, 1, 2, 2, 1, 2,
        0, 2, 2, 2, 2, 2,
        2, 3, 2,

        0, 0, 3,
        2, 1, 3,
        2, 2, 3,
        0, 3, 3,
        127
	},
	{
        1, 2, 0,
        1, 3, 0,

        0, 1, 1,
        1, 2, 1,
        1, 3, 1,
        0, 4, 1,

        1, 0, 2,
        1, 1, 2,
        1, 4, 2,
        1, 5, 2,

        1, 0, 3,
        1, 1, 3,
        1, 4, 3,
        1, 5, 3,

        0, 1, 4,
        1, 2, 4,
        1, 3, 4,
        0, 4, 4,

        1, 2, 5,
        1, 3, 5,
        127
	},
};

static char glider_26B6S567[][3 * NUMPTS + 1] =
{
	{
        0, 1, 0, 1, 1, 0,
        0, 2, 1, 1, 2, 1,
        0, 0, 2, 1, 0, 2,
        0, 1, 2, 1, 1, 2,
        0, 2, 2, 1, 2, 2,
        127
	},
};

static char glider_26B6S57[][3 * NUMPTS + 1] =
{
	{
        0, 1, 0, 1, 1, 0,

        0, 2, 1, 1, 2, 1,

        0, 0, 2, 1, 0, 2,
        0, 1, 2, 1, 1, 2,
        0, 2, 2, 1, 2, 2,
        127
	},
	{
        0, 0, 0, 4, 0, 0, 5, 0, 0,
        0, 1, 0, 4, 1, 0, 5, 1, 0,

        0, 0, 1, 4, 0, 1,
        0, 1, 1, 4, 1, 1,

        1, 0, 2, 2, 0, 2, 3, 0, 2,
        1, 1, 2, 2, 1, 2, 3, 1, 2,
        127
	},
	{
        0, 0, 0, 4, 0, 0, 5, 0, 0,
        0, 1, 0, 4, 1, 0,
        1, 2, 0, 2, 2, 0, 3, 2, 0,

        0, 0, 1, 4, 0, 1, 5, 0, 1,
        0, 1, 1, 4, 1, 1,
        1, 2, 1, 2, 2, 1, 3, 2, 1,
        127
	},
};

static char glider_26B67S57[][3 * NUMPTS + 1] =
{
	{
        0, 1, 0, 1, 1, 0,

        0, 2, 1, 1, 2, 1,

        0, 0, 2, 1, 0, 2,
        0, 1, 2, 1, 1, 2,
        0, 2, 2, 1, 2, 2,
        127
	},
};

static char patterns_12B3S3[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"antisym linked N gliders (p4, diagonal)"},
#endif
	{
        1, -1, -2,

        -1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        0, 1, -1,

        -3, 1, 0, -1, 1, 0,
        -2, 2, 0,

        0, -1, 1,
        1, 0, 1, 3, 0, 1,
        -2, 1, 1, 2, 1, 1,
        -3, 2, 1, -1, 2, 1,

        2, 0, 2,
        1, 1, 2, 3, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"linked O gliders (p4, diagonal)"},
#endif
	{
        -2, -2, -2, 2, -2, -2,
        -2, 0, -2, 2, 0, -2,

        -2, -1, -1, 0, -1, -1, 2, -1, -1,

        -3, 1, 0, -1, 1, 0, 1, 1, 0, 3, 1, 0,
        -2, 2, 0, 2, 2, 0,

        -2, 1, 1, 2, 1, 1,
        -3, 2, 1, -1, 2, 1, 1, 2, 1, 3, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2-A"},
#endif
	{
        0, 0, 0,
        -1, 1, 0,

        0, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2-B"},
#endif
	{
        -1, -1, 0,
        0, 0, 0,

        0, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2-C"},
#endif
	{
        -1, 0, -1,

        1, -1, 0,
        0, 0, 0,

        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2-E"},
#endif
	{
        0, 0, -2,

        0, -1, -1,
        1, 0, -1,

        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"2-F"},
#endif
	{
        0, 0, -2,

        -2, 1, -1, 0, 1, -1,

        -1, -1, 0, 1, -1, 0,

        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2-G"},
#endif
	{
        -2, -2, 0,
        -1, -1, 0,
        -2, 0, 0, 0, 0, 0,
        -1, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"2-H"},
#endif
	{
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        1, 2, -1,

        -1, -2, 1,
        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2-I"},
#endif
	{
        -1, 0, -1,
        0, 1, -1,

        0, -2, 0,
        -1, -1, 0,
        2, 0, 0,
        1, 1, 0,

        -1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2-J"},
#endif
	{
        -1, -2, -1,
        1, 0, -1,

        -1, -3, 0,
        0, -2, 0,
        -3, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0,
        0, 2, 0,

        -2, -1, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2-K"},
#endif
	{
        0, -1, -3,

        -1, -1, -2,
        0, 0, -2,

        2, -1, -1, -2, -1, -1,
        1, 0, -1,

        -3, -1, 0, 1, -1, 0,
        -2, 0, 0,

        0, -1, 1,
        -1, 0, 1,

        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"2-L"},
#endif
	{
        0, -2, -2,
        2, 0, -2,

        -2, -1, -1,
        -1, 0, -1,
        0, 1, -1,
        1, 2, -1,

        0, -2, 0,
        1, -1, 0,
        2, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"2-L variant"},
#endif
	{
        0, -2, -2,
        0, 2, -2,

        -1, -2, -1,
        -1, 0, -1,
        -1, 2, -1,

        1, -3, 0,
        1, -1, 0,
        1, 1, 0,
        1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"2-M"},
#endif
	{
        -1, -1, -2, 1, -1, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        0, 1, -1,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"3-A"},
#endif
	{
        1, 1, -2,

        1, 0, -1,
        0, 1, -1,

        1, -1, 0,
        -1, 1, 0,

        1, -2, 1,
        0, -1, 1,
        -1, 0, 1,
        -2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"3-B"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 2, 1, -1,

        -1, 1, 0, 1, 1, 0,

        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"3-C"},
#endif
	{
        0, -3, -3,
        -1, -2, -3,
        -2, -1, -3,
        -3, 0, -3,

        0, -2, -2,
        -2, 0, -2,

        2, -3, -1,
        1, -2, -1,
        -2, 1, -1,
        -3, 2, -1,

        2, -2, 0,
        -2, 2, 0,

        2, -1, 1,
        1, 0, 1,
        0, 1, 1,
        -1, 2, 1,

        0, 2, 2,
        2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"3-D"},
#endif
	{
        -2, -4, -2,
        0, -2, -2,
        2, 0, -2,
        4, 2, -2,

        -3, -4, -1,
        -2, -3, -1,
        -1, -2, -1,
        0, -1, -1,
        1, 0, -1,
        2, 1, -1,
        3, 2, -1,
        4, 3, -1,

        -4, -4, 0,
        4, 4, 0,

        -3, -4, 1,
        -2, -3, 1,
        -1, -2, 1,
        0, -1, 1,
        1, 0, 1,
        2, 1, 1,
        3, 2, 1,
        4, 3, 1,

        -2, -4, 2,
        0, -2, 2,
        2, 0, 2,
        4, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"3-BD"},
#endif
	{
        -2, 0, -2,
        0, 2, -2,

        -2, -1, -1,
        -1, 0, -1,
        0, 1, -1,
        1, 2, -1,

        -2, -2, 0,
        2, 2, 0,

        -2, -1, 1,
        -1, 0, 1,
        0, 1, 1,
        1, 2, 1,

        -2, 0, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"3-E"},
#endif
	{
        0, -1, -1,
        1, 0, -1,
        -2, 1, -1,
        -1, 2, -1,

        -1, -3, 0,
        0, -2, 0,
        -3, -1, 0,
        -2, 0, 0, 2, 0, 0,
        3, 1, 0,
        0, 2, 0,
        1, 3, 0,

        1, -2, 1,
        2, -1, 1,
        -1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"3-F"},
#endif
	{
        -2, -1, -1,

        0, -2, 0,
        -1, -1, 0,
        -2, 0, 0, 2, 0, 0,

        1, 0, 1,
        2, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"4-F"},
#endif
	{
        -2, -2, -2,
        1, -1, -2,
        -1, 1, -2,
        2, 2, -2,

        1, -2, -1,
        0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1,
        -1, 2, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,

        -1, -2, 1,
        -2, -1, 1, 0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 2, 1, 1,
        1, 2, 1,

        2, -2, 2,
        -1, -1, 2,
        1, 1, 2,
        -2, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"4-H"},
#endif
	{
        0, 0, -2,
        1, 1, -2,

        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1, 2, 1, -1,
        1, 2, -1,

        1, -1, 0,
        0, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,

        1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"5-A"},
#endif
	{
        1, -1, -2,

        -1, -2, -1,
        0, -1, -1,
        1, 0, -1,
        2, 1, -1,

        -1, -1, 0,
        1, 1, 0,

        -2, -1, 1,
        -1, 0, 1,
        0, 1, 1,
        1, 2, 1,

        -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"5-B"},
#endif
	{
        -2, -1, -3, 0, -1, -3,
        -1, 0, -3, 1, 0, -3,
        0, 1, -3, 1, 2, -3,

        -2, -2, -2, 0, -2, -2,
        1, -1, -2,
        2, 0, -2,
        2, 2, -2,

        -1, -2, -1, 1, -2, -1,
        2, -1, -1,
        -1, 0, -1,
        0, 1, -1, 2, 1, -1,

	0, -2, 0,
        0, 0, 0, 2, 0, 0,

        2, -1, 1,
        1, -2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"6-A"},
#endif
	{
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        0, -4, 0,
        -2, -2, 0, 2, -2, 0,
        -4, 0, 0, 4, 0, 0,
        -2, 2, 0, 2, 2, 0,
        0, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"6-B"},
#endif
	{
        -2, -3, -1, 2, -3, -1,
        -3, -2, -1, -1, -2, -1, 1, -2, -1, 3, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -3, 2, -1, -1, 2, -1, 1, 2, -1, 3, 2, -1,
        -2, 3, -1, 2, 3, -1,

        -1, -3, 0, 1, -3, 0,
        -3, -1, 0, 3, -1, 0,
        -3, 1, 0, 3, 1, 0,
        -1, 3, 0, 1, 3, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 0, -1, 1, 2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"6-C"},
#endif
	{
        0, 0, -2,

        -1, -2, -1,
        0, -1, -1,
        1, 0, -1,
        2, 1, -1,

        -1, -1, 0,
        -2, 0, 0,
        1, 1, 0,
        0, 2, 0,

        -1, 0, 1,
        0, 1, 1,

        -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"6-D"},
#endif
	{
        -2, -1, -1, 0, -1, -1,
        0, 1, -1,

        -1, -3, 0,
        0, 2, 0,

        -1, -2, 1,
        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"6-E"},
#endif
	{
        0, -1, -1,
        -2, 1, -1, 2, 1, -1,

        -1, -1, 0, 1, -1, 0,

        -3, 0, 1, -1, 0, 1, 1, 0, 1, 3, 0, 1,
        -2, 1, 1, 2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"6-E variant"},
#endif
	{
        0, -2, -2,

        -2, -1, -1, 2, -1, -1,

        -1, -3, 0, 1, -3, 0,

        -3, -2, 1, -1, -2, 1, 1, -2, 1, 3, -2, 1,
        -2, -1, 1, 2, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"6-F"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -1, -1, 0, 1, -1, 0,

        -2, -1, 1,
        0, 1, 1, 2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"6-G"},
#endif
	{
        0, -1, -1,

        0, 0, 0,

        -1, -2, 1, 1, -2, 1,
        -2, 1, 1, 0, 1, 1,

        -1, -1, 2,
        -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"6-H"},
#endif
	{
        -1, -3, -2,
        -2, -2, -2, 0, -2, -2,
        -1, -1, -2,
        1, 1, -2,
        0, 2, -2, 2, 2, -2,
        1, 3, -2,

        0, -1, -1,
        0, 1, -1,

        -1, -3, 0,
        -1, -1, 0,
        1, 1, 0,
        1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"6-H variant"},
#endif
	{
        -2, -1, -1, 2, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1, 3, 0, -1,
        -2, 1, -1, 2, 1, -1,

        -1, -1, 0, 1, -1, 0,

        -3, 0, 1, -1, 0, 1, 1, 0, 1, 3, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"7-A"},
#endif
	{
        0, 0, -2,

        0, -2, 0,
        1, -1, 0,
        1, 1, 0,
        0, 2, 0,

        -1, -2, 1,
        -2, -1, 1,
        -2, 1, 1,
        -1, 2, 1,

        -1, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"7-B"},
#endif
	{
        0, -1, -1,

        -1, -1, 0,
        0, 0, 0,
        -1, 1, 0, 1, 1, 0,

        0, -1, 1,
        -1, 0, 1,
        -2, 1, 1, 0, 1, 1,

        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"7-C"},
#endif
	{
        -1, -1, -2,

        -1, -2, -1, 1, -2, -1,
        1, 0, -1,
        -2, 1, -1,

        1, -1, 0,
        -2, 0, 0,
        -2, 2, 0, 0, 2, 0,

        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"7-D"},
#endif
	{
        0, -2, -2, 2, -2, -2,
        -2, 0, -2, 2, 0, -2,
        -2, 2, -2, 0, 2, -2,

        1, -2, -1,
        -2, -1, -1,
        2, 1, -1,
        -1, 2, -1,

        2, -2, 0,
        -2, 0, 0, 2, 0, 0,
        -2, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"7-E"},
#endif
	{
        -2, 1, -1,

        1, -1, 0,
        0, 0, 0,
        0, 2, 0,
        -1, 3, 0,

        0, -3, 1,
        -1, -2, 1,
        -1, 0, 1,
        -2, 1, 1,

        1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"7-F"},
#endif
	{
        0, -2, -4,

        2, -1, -3,
        1, 0, -3,

        0, -2, -2,

        1, 0, -1,

        -1, -1, 0,

        0, 1, 1,

        -1, -1, 2,
        -2, 0, 2,

        0, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"8-B"},
#endif
	{
        0, -2, -2,
        -1, -1, -2,
        0, 0, -2, 2, 0, -2,
        1, 1, -2,

        -1, -1, 0,
        -2, 0, 0, 0, 0, 0,
        1, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"8-C"},
#endif
	{
        0, -1, -1,

        0, -2, 0,
        -1, 1, 0, 1, 1, 0,

        -1, -2, 1, 1, -2, 1,
        0, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"8-D"},
#endif
	{
        0, -2, -2,

        -2, -1, -1,
        -1, 0, -1,
        0, 1, -1,

        0, -2, 0,
        1, -1, 0,
        2, 0, 0,

        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"8-E"},
#endif
	{
        -1, -1, -2,

        0, -3, -1,
        1, -2, -1,
        -2, -1, -1,
        -2, 1, -1,

        2, -2, 0,
        2, 0, 0,
        -1, 1, 0,
        0, 2, 0,

        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"8-F"},
#endif
	{
        -2, -1, -3,
        0, 1, -3,

        -2, 0, -2,
        0, 2, -2, 2, 2, -2,

        -1, -2, -1,
        -2, -1, -1,
        1, 2, -1,

        2, 0, 0,

        1, -2, 1,
        0, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"8-G"},
#endif
	{
        -1, -1, -2,
        0, 0, -2,

        0, 1, -1, 2, 1, -1,

        -2, -2, 0, 0, -2, 0,
        2, 0, 0,
        2, 2, 0,

        -1, -2, 1,
        -1, 0, 1,

        0, 0, 2,
        1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"8-H"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, -2, 0,
        -2, 0, 0,
        1, 1, 0,

        2, -1, 1,
        -1, -2, 1,
        1, -2, 1,

        0, -2, 2,
        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"8-I"},
#endif
	{
        1, -1, -4,

        -1, 0, -3,
        0, 1, -3,

        1, -1, -2,

        -1, 0, -1,

        1, -1, 0,

        -1, 0, 1,

        0, -2, 2,
        1, -1, 2,

        -1, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"9-A"},
#endif
	{
        -2, -1, -3,
        -2, 1, -3,

        -1, 1, -2,
        -1, 3, -2, 1, 3, -2,

        -3, -2, -1,
        -2, -1, -1,
        1, 2, -1, 3, 2, -1,

        -3, -2, 1, -1, -2, 1,
        2, 1, 1,
        3, 2, 1,

        -1, -3, 2, 1, -3, 2,
        1, -1, 2,

        2, -1, 3,
        2, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"9-AB variant 1"},
#endif
	{
        2, 1, -5,

        0, 2, -4,

        3, 0, -3,
        2, 1, -3,
        -1, 2, -3,
        -1, 4, -3,

        2, -2, -2, 4, -2, -2,

        2, -3, -1,
        -2, 3, -1,

        -4, 2, 0, -2, 2, 0,

        1, -4, 1,
        1, -2, 1,
        -2, -1, 1,
        -3, 0, 1,

        0, -2, 2,

        -2, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"9-AB variant 2"},
#endif
	{
        2, 1, -5,

        2, -1, -3,
        2, 1, -3,
        -1, 2, -3, 1, 2, -3,
        -1, 4, -3,

        2, -2, -2, 4, -2, -2,
        -2, 2, -2,

        2, -2, 0,
        -4, 2, 0, -2, 2, 0,

        1, -4, 1,
        -1, -2, 1, 1, -2, 1,
        -2, -1, 1,
        -2, 1, 1,

        -2, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"9-AB variant 3"},
#endif
	{
        2, 1, -5,

        3, -1, -4,
        1, 1, -4,
        1, 3, -4,

        -1, 4, -3,

        4, -2, -2,
        3, -1, -2,
        -3, 3, -2, -1, 3, -2,

        1, -3, 0, 3, -3, 0,
        -3, 1, 0,
        -4, 2, 0,

        1, -4, 1,

        -1, -3, 2,
        -1, -1, 2,
        -3, 1, 2,

        -2, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"9-AB variant 4"},
#endif
	{
        2, 0, -4,
        1, 1, -4,

        0, 1, -3,
        0, 3, -3,

        3, -1, -2,
        2, 0, -2,
        -1, 3, -2,

        1, -2, -1, 3, -2, -1,
        -3, 2, -1, -1, 2, -1,

        1, -3, 0,
        -2, 0, 0,
        -3, 1, 0,

        0, -3, 1,
        0, -1, 1,

        -1, -1, 2,
        -2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"9-B"},
#endif
	{
        2, -2, -4,
        0, 0, -4, 2, 0, -4,

        -1, 2, -3, 1, 2, -3,

        3, -3, -2,
        3, -1, -2,
        -3, 1, -2,

        1, -4, -1,
        -1, 2, -1,

        3, -3, 0,
        -3, -1, 0,
        -3, 1, 0,

        -1, -4, 1, 1, -4, 1,

        -2, -2, 2, 0, -2, 2,
        -2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"9-C"},
#endif
	{
        1, 1, -4, 3, 1, -4,
        1, 3, -4,

        4, -1, -3,
        -1, 2, -3,
        -1, 4, -3,

        3, 1, -2,

        2, -3, -1, 4, -3, -1,
        4, -1, -1,
        -3, 4, -1, -1, 4, -1,

        1, -4, 1, 3, -4, 1,
        -4, 1, 1,
        -4, 3, 1, -2, 3, 1,

        -3, -1, 2,

        1, -4, 3,
        1, -2, 3,
        -4, 1, 3,

        -1, -3, 4,
        -3, -1, 4, -1, -1, 4,
        127
	},
#ifdef LIFE_NAMES
	{"9-D"},
#endif
	{
        2, -1, -3,
        1, 0, -3,
        0, 1, -3, 2, 1, -3,
        -1, 2, -3, 1, 2, -3,

        3, -1, -2,
        3, 1, -2,
        -1, 3, -2, 1, 3, -2,

        2, -3, -1,
        3, -2, -1,
        3, 0, -1,
        -3, 2, -1,
        -2, 3, -1, 0, 3, -1,

        1, -3, 0,
        3, -1, 0,
        -3, 1, 0,
        -1, 3, 0,

        0, -3, 1, 2, -3, 1,
        3, -2, 1,
        -3, 0, 1,
        -3, 2, 1,
        -2, 3, 1,

        -1, -3, 2, 1, -3, 2,
        -3, -1, 2,
        -3, 1, 2,

        -1, -2, 3, 1, -2, 3,
        -2, -1, 3, 0, -1, 3,
        -1, 0, 3,
        -2, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"9-E"},
#endif
	{
        1, -1, -4,
        -1, 1, -4,

        1, 0, -3,
        0, 1, -3, 2, 1, -3,
        1, 2, -3,

        3, -1, -2,
        -1, 3, -2,

        1, -4, -1,
        3, -2, -1,
        3, 0, -1,
        -4, 1, -1, 4, 1, -1,
        -2, 3, -1, 0, 3, -1,
        1, 4, -1,

        1, -3, 0,
        3, -1, 0,
        -3, 1, 0,
        -1, 3, 0,

        -1, -4, 1,
        0, -3, 1, 2, -3, 1,
        -4, -1, 1, 4, -1, 1,
        -3, 0, 1,
        -3, 2, 1,
        -1, 4, 1,

        1, -3, 2,
        -3, 1, 2,

        -1, -2, 3,
        -2, -1, 3, 0, -1, 3,
        -1, 0, 3,

        1, -1, 4,
        -1, 1, 4,
        127
	},
#ifdef LIFE_NAMES
	{"9-E twisted"},
#endif
	{
        -2, 0, -4,
        0, 2, -4,

        -2, -1, -3,
        -1, 0, -3,
        0, 1, -3,
        1, 2, -3,

        -4, 0, -2,
        -3, 1, -2,
        -1, 3, -2,
        0, 4, -2,

        -2, -3, -1,
        -3, 0, -1,
        3, 2, -1,
        0, 3, -1,

        -2, -4, 0,
        -1, -3, 0,
        -4, -2, 0,
        -3, -1, 0,
        3, 1, 0,
        4, 2, 0,
        1, 3, 0,
        2, 4, 0,

        0, -3, 1,
        -3, -2, 1,
        3, 0, 1,
        2, 3, 1,

        0, -4, 2,
        1, -3, 2,
        3, -1, 2,
        4, 0, 2,

        -1, -2, 3,
        0, -1, 3,
        1, 0, 3,
        2, 1, 3,

        0, -2, 4,
        2, 0, 4,
        127
	},
#ifdef LIFE_NAMES
	{"9-F"},
#endif
	{
        -1, -1, -2,
        0, 0, -2,
        -3, 1, -2, 1, 1, -2,
        -2, 2, -2,
        -1, 3, -2,

        0, -1, -1,
        -3, 2, -1, 1, 2, -1,
        0, 3, -1,

        -3, -1, 0, 1, -1, 0,
        -3, 3, 0, 1, 3, 0,

        -2, -1, 1,
        -3, 0, 1, 1, 0, 1,
        -2, 3, 1,

        -1, -1, 2,
        0, 0, 2,
        -3, 1, 2, 1, 1, 2,
        -2, 2, 2,
        -1, 3, 2,
        127
	},
#ifdef LIFE_NAMES
	{"9-G"},
#endif
	{
        0, -2, -2,
        -1, -1, -2, 1, -1, -2,
        -1, 1, -2, 1, 1, -2,
        0, 2, -2,

        0, -2, 0,
        -2, 0, 0, 2, 0, 0,
        0, 2, 0,

        -1, -1, 2, 1, -1, 2,
        -2, 0, 2, 2, 0, 2,
        -1, 1, 2, 1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"9-H"},
#endif
	{
        -2, -1, -1,
        -1, 0, -1,

        -1, -3, 0,
        0, -2, 0,
        -3, -1, 0,
        0, 0, 0,
        -3, 1, 0,
        -2, 2, 0,

        -1, -1, 2, 1, -1, 2,
        2, 0, 2,
        -3, 1, 2,
        -2, 2, 2, 0, 2, 2,

        -1, 0, 3,
        0, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"9-I"},
#endif
	{
        -1, -2, -3,

        -3, -1, -2,
        -2, 0, -2,
        -1, 1, -2,
        0, 2, -2,

        -1, -2, -1,
        0, -1, -1,
        1, 0, -1,
        2, 1, -1,

        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4C"},
#endif
	{
        0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        0, 2, -2,

        -1, -2, -1,
        2, -1, -1,
        -2, 1, -1,
        1, 2, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"bridge"},
#endif
	{
        -2, -3, -1,
        2, 1, -1,

        -3, -3, 0,
        -3, -1, 0,
        0, 2, 0, 2, 2, 0,

        -2, -3, 1,
        -1, -2, 1,
        -1, 0, 1, 1, 0, 1,
        2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"jack"},
#endif
	{
        0, -2, -2,
        0, 2, -2,

        -2, -1, -1, 0, -1, -1,
        -2, 1, -1, 0, 1, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,

        -1, -2, 1,
        -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"octahedron"},
#endif
	{
        1, -1, -2,
        -1, 1, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        -1, -1, 0,
        1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"roll over"},
#endif
	{
        1, 0, -3,

        1, -2, -1,
        2, -1, -1,
        2, 1, -1,
        1, 2, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,

        -1, -2, 1,
        -2, -1, 1,
        -2, 1, 1,
        -1, 2, 1,

        -1, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"star flicker"},
#endif
	{
        2, -1, -3,
        1, 0, -3,
        1, 2, -3,

        1, -1, -2,
        -1, 1, -2, 1, 1, -2,
        -2, 2, -2, 0, 2, -2,

        2, -1, -1,
        -2, 1, -1,

        0, -2, 0, 2, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 1, 0,

        -1, -2, 1,
        -1, 0, 1,
        -2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"internal cube"},
#endif
	{
        0, 2, -4,

        1, -2, -3,
        -1, 0, -3, 1, 0, -3, 3, 0, -3,
        -2, 1, -3,

        0, -2, -2,
        -1, -1, -2,
        0, 2, -2, 2, 2, -2,

        2, -3, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -2, 3, -1,

        -2, -2, 0, 0, -2, 0,
        1, 1, 0,
        0, 2, 0,

        2, -1, 1,
        -3, 0, 1, -1, 0, 1, 1, 0, 1,
        -1, 2, 1,

        0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"square and diagonals"},
#endif
	{
        0, -1, -3,
        0, 1, -3,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"shake hands"},
#endif
	{
        2, -1, -1,
        -2, 1, -1,

        0, -2, 0, 2, -2, 0,
        -2, 2, 0, 0, 2, 0,

        2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"strange toggler"},
#endif
	{
        0, -2, -2,
        -1, -1, -2, 1, -1, -2,

        1, 0, -1,

        0, -2, 0,
        -1, 1, 0, 1, 1, 0,

        0, -1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"throw"},
#endif
	{
        0, 0, -2,

        -1, 0, -1,
        0, 1, -1,

        -2, 0, 0,
        0, 2, 0,

        0, -1, 1,
        1, 0, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"boxers"},
#endif
	{
        -2, 0, -2, 2, 0, -2,

        -1, -2, -1,
        0, -1, -1, 2, -1, -1,
        -2, 1, -1, 0, 1, -1,
        1, 2, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"dancer"},
#endif
	{
        0, -1, -3,
        0, 1, -3,

        -2, 0, -2, 2, 0, -2,

        -1, -2, -1,
        1, 2, -1,

        -1, -1, 0,
        1, 1, 0,

        0, -1, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bird"},
#endif
	{
        0, -2, -2,
        0, 0, -2,

        -2, -1, -1, 2, -1, -1,

        -2, 0, 0, 0, 0, 0, 2, 0, 0,

        -2, -1, 1, 2, -1, 1,
        -2, 1, 1, 2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bat"},
#endif
	{
        -1, -2, -1,
        1, 0, -1,
        -1, 2, -1,

        1, -1, 0,
        1, 1, 0,

        0, -3, 1,
        -1, -2, 1,
        -1, 0, 1,
        -1, 2, 1,
        0, 3, 1,

        1, -1, 2,
        1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"ring (3 * 8-E)"},
#endif
	{
        1, 0, -5,
        1, 2, -5,

        3, -1, -4,
        2, 0, -4,
        0, 2, -4,

        1, 4, -3,

        5, -1, -2,
        4, 0, -2,
        0, 4, -2,

        -4, 3, -1,
        -2, 5, -1, 0, 5, -1,

        2, -4, 0,
        4, -2, 0,
        5, -1, 0,
        -5, 1, 0,
        -4, 2, 0,
        -2, 4, 0,

        0, -5, 1, 2, -5, 1,
        4, -3, 1,

        0, -4, 2,
        -4, 0, 2,
        -5, 1, 2,

        -1, -4, 3,

        0, -2, 4,
        -2, 0, 4,
        -3, 1, 4,

        -1, -2, 5,
        -1, 0, 5,
        127
	},
#ifdef LIFE_NAMES
	{"bowl"},
#endif
	{
        -1, -3, -2, 1, -3, -2,
        -3, -1, -2, 3, -1, -2,
        -3, 1, -2, 3, 1, -2,
        -1, 3, -2, 1, 3, -2,

        -1, -4, -1, 1, -4, -1,
        -4, -1, -1, 0, -1, -1, 4, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -4, 1, -1, 0, 1, -1, 4, 1, -1,
        -1, 4, -1, 1, 4, -1,

        -1, -3, 0, 1, -3, 0,
        -3, -1, 0, 3, -1, 0,
        -3, 1, 0, 3, 1, 0,
        -1, 3, 0, 1, 3, 0,

        -1, -4, 1, 1, -4, 1,
        0, -3, 1,
        -4, -1, 1, 4, -1, 1,
        -3, 0, 1, 3, 0, 1,
        -4, 1, 1, 4, 1, 1,
        0, 3, 1,
        -1, 4, 1, 1, 4, 1,
        127
	},
#ifdef LIFE_NAMES
	{"octahedron capture (p3)"},
#endif
	{
        -2, -2, -4,
        -1, -1, -4,

        0, -1, -3,
        -1, 0, -3,

        -2, -4, -2,
        -4, -2, -2,

        -1, -4, -1,
        0, -3, -1,
        -4, -1, -1,
        -3, 0, -1,
        0, 1, -1,

        -1, -3, 0,
        -3, -1, 0, 1, -1, 0,
        0, 0, 0,
        3, 1, 0,
        1, 3, 0,

        -1, 0, 1, 3, 0, 1,
        4, 1, 1,
        0, 3, 1,
        1, 4, 1,

        4, 2, 2,
        2, 4, 2,

        1, 0, 3,
        0, 1, 3,

        1, 1, 4,
        2, 2, 4,
        127
	},
#ifdef LIFE_NAMES
	{"2-D (p4)"},
#endif
	{
        -1, 0, -1,
        0, 1, -1,

        1, -1, 0,
        -1, 1, 0,
        0, 2, 0,

        -1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"8-A (p4)"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 2, 1, -1,

        -2, 0, 0, 2, 0, 0,

        -2, -1, 1, 2, -1, 1,

        -2, -2, 2, 2, -2, 2,
        -1, -1, 2, 1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"11-A portion opp (p4)"},
#endif
	{
        -4, 0, -2, 4, 0, -2,

        -1, 0, -1, 1, 0, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,

        -3, -1, 0, 3, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -3, 1, 0, 3, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"11-A portion sync (p4)"},
#endif
	{
        0, -2, -2,
        -1, -1, -2,
        1, 1, -2,
        0, 2, -2,

        0, -3, -1,
        -1, -2, -1,
        1, 2, -1,
        0, 3, -1,

        0, -2, 0,
        -1, -1, 0,
        1, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"11-A double (p4)"},
#endif
	{
        -2, -2, -2, 2, -2, -2,
        -1, -1, -2, 1, -1, -2,
        -1, 1, -2, 1, 1, -2,
        -2, 2, -2, 2, 2, -2,

        -3, -2, -1, 3, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -3, 2, -1, 3, 2, -1,

        -2, -2, 0, 2, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        -2, 2, 0, 2, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"cascade (p4)"},
#endif
	{
        -2, 0, -2,
        0, 2, -2,

        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -2, 0, 0,
        0, 2, 0,

        1, -2, 1,
        0, -1, 1, 2, -1, 1,
        1, 0, 1,

        -1, -1, 2,
        1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"3 witches (p4)"},
#endif
	{
        -2, -1, -3, 0, -1, -3,
        -3, 0, -3,

        -3, -1, -2,
        -2, 0, -2,

        0, -3, -1,
        0, -1, -1, 2, -1, -1,
        2, 1, -1,
        1, 2, -1,

        1, 1, 0,
        2, 2, 0,

        0, -3, 1,
        -1, -2, 1,

        -1, -3, 2,
        0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"triangle flip (p4)"},
#endif
	{
        -2, -2, -2, 2, -2, -2,
        -2, 0, -2, 0, 0, -2,
        0, 2, -2, 2, 2, -2,

        -2, -2, 0, 0, -2, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0,
        0, 2, 0, 2, 2, 0,

        -1, 0, 1,
        0, 1, 1,

        0, -2, 2, 2, -2, 2,
        0, 0, 2, 2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"nova (p4)"},
#endif
	{
        -2, -2, -2, 2, -2, -2,
        -4, 0, -2, 4, 0, -2,
        -2, 2, -2, 2, 2, -2,

        -1, -4, -1, 1, -4, -1,
        -4, -1, -1, 4, -1, -1,
        -4, 1, -1, 4, 1, -1,
        -1, 4, -1, 1, 4, -1,

        0, -4, 0,
        -2, -2, 0, 2, -2, 0,
        -2, 2, 0, 2, 2, 0,
        0, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"this that (p4)"},
#endif
	{
        -1, -3, -2, 1, -3, -2,
        -2, -2, -2, 2, -2, -2,
        -2, 2, -2, 2, 2, -2,
        -1, 3, -2, 1, 3, -2,

        -2, -3, -1, 2, -3, -1,
        -1, -2, -1, 1, -2, -1,
        -1, 2, -1, 1, 2, -1,
        -2, 3, -1, 2, 3, -1,

        -1, -3, 0, 1, -3, 0,
        -2, -2, 0, 2, -2, 0,
        -2, 2, 0, 2, 2, 0,
        -1, 3, 0, 1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"7-G Mitosis (p4)"},
#endif
	{
        0, 0, -4,

        -2, 0, -2, 2, 0, -2,
        -1, 1, -2, 1, 1, -2,

        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 2, 1, -1,
        0, 3, -1,

        0, -4, 0,
        -2, -2, 0, 2, -2, 0,
        -1, -1, 0, 1, -1, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,

        0, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"8-J Star (p4)"},
#endif
	{
        0, -1, -3,
        0, 1, -3,

        1, -1, -2,
        -2, 0, -2, 2, 0, -2,

        -1, -2, -1, 1, -2, -1,
        -1, 2, -1, 1, 2, -1,

        -2, 0, 0, 2, 0, 0,
        -1, 1, 0,

        0, -1, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"ratchet (p4)"},
#endif
	{
        2, -1, -3,
        -1, 0, -3,
        2, 1, -3,
        -1, 2, -3, 1, 2, -3,

        0, -2, -2, 2, -2, -2,
        -1, -1, -2,
        -2, 2, -2,

        -2, -1, -1,
        2, 1, -1,

        2, -2, 0,
        1, 1, 0,
        -2, 2, 0, 0, 2, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1,
        1, 0, 1,
        -2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"quadropus (p4)"},
#endif
	{
        0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        0, 2, -2,

        -1, -2, -1,
        2, -1, -1,
        -2, 1, -1,
        1, 2, -1,

        0, -3, 1,
        -1, -2, 1,
        2, -1, 1,
        -3, 0, 1, 3, 0, 1,
        -2, 1, 1,
        1, 2, 1,
        0, 3, 1,

        -1, -2, 3,
        0, -1, 3, 2, -1, 3,
        -1, 0, 3, 1, 0, 3,
        -2, 1, 3, 0, 1, 3,
        1, 2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"rectangle (p4)"},
#endif
	{
        -3, -2, -1, -1, -2, -1, 1, -2, -1, 3, -2, -1,
        -3, 2, -1, -1, 2, -1, 1, 2, -1, 3, 2, -1,

        0, -6, 0,
        -2, -2, 0, 0, -2, 0, 2, -2, 0,
        -3, -1, 0, 3, -1, 0,
        -3, 1, 0, 3, 1, 0,
        -2, 2, 0, 0, 2, 0, 2, 2, 0,
        0, 6, 0,

        -3, -2, 1, 3, -2, 1,
        -3, 0, 1, 3, 0, 1,
        -3, 2, 1, 3, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"octordian (p4)"},
#endif
	{
        -2, -1, -3, 2, -1, -3,
        -2, 1, -3, 2, 1, -3,

        -2, -2, -2, 2, -2, -2,
        -1, -1, -2, 1, -1, -2,
        -1, 1, -2, 1, 1, -2,
        -2, 2, -2, 2, 2, -2,

        -1, -2, -1, 1, -2, -1,
        -1, 2, -1, 1, 2, -1,

        -2, -2, 0, 2, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        -2, 2, 0, 2, 2, 0,

        -2, -1, 1, 2, -1, 1,
        -2, 1, 1, 2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pacman (p4)"},
#endif
	{
        -2, -2, -2, 2, -2, -2,
        -2, 2, -2, 2, 2, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        1, -3, 0,
        -3, -1, 0,
        3, 1, 0,
        -1, 3, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,

        -1, -3, 2,
        -2, -2, 2, 2, -2, 2,
        3, -1, 2,
        -3, 1, 2,
        -2, 2, 2, 2, 2, 2,
        1, 3, 2,
        127
	},
#ifdef LIFE_NAMES
	{"come together (p4)"},
#endif
	{
        4, 1, -5,

        2, 0, -4,
        2, 2, -4,

        3, 0, -3,
        2, 1, -3,
        3, 2, -3,

        3, 1, -2,

        -3, 2, -1,
        -2, 3, -1,

        -2, 2, 0,
        -1, 3, 0,
        -4, 4, 0,

        0, -3, 1, 2, -3, 1,
        1, -2, 1,
        -3, 2, 1,
        -2, 3, 1,

        0, -2, 2, 2, -2, 2,
        1, -1, 2,

        1, -4, 3,
        127
	},
/*too big 48 pts */
/*#ifdef LIFE_NAMES
	{"trading partners (p4)"},
#endif
	{
        -2, -2, -4, 2, -2, -4,
        -3, -1, -4, 3, -1, -4,
        -3, 1, -4, 3, 1, -4,
        -2, 2, -4, 2, 2, -4,

        -3, -2, -3, 3, -2, -3,
        -2, -1, -3, 2, -1, -3,
        -2, 1, -3, 2, 1, -3,
        -3, 2, -3, 3, 2, -3,

        -2, -2, -2, 2, -2, -2,
        -3, -1, -2, 3, -1, -2,
        -3, 1, -2, 3, 1, -2,
        -2, 2, -2, 2, 2, -2,

        -2, -2, 0, 2, -2, 0,
        -3, -1, 0, 3, -1, 0,
        -3, 1, 0, 3, 1, 0,
        -2, 2, 0, 2, 2, 0,

        -3, -2, 1, 3, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -2, 1, 1, 2, 1, 1,
        -3, 2, 1, 3, 2, 1,

        -2, -2, 2, 2, -2, 2,
        -3, -1, 2, 3, -1, 2,
        -3, 1, 2, 3, 1, 2,
        -2, 2, 2, 2, 2, 2,
        127
	},*/
#ifdef LIFE_NAMES
	{"absolute x (p6)"},
#endif
	{
        1, -2, -3,
        1, 0, -3,
        1, 2, -3,

        0, -2, -2,
        0, 2, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        0, -2, 0,
        0, 2, 0,

        -1, -2, 1,
        -1, 0, 1,
        -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"5-C Metamorphosis (p6)"},
#endif
	{
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        0, -2, 0,
        -2, 0, 0, 2, 0, 0,
        0, 2, 0,

        0, -3, 1,
        -3, 0, 1, 3, 0, 1,
        0, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"stretched tetrahedron (p6)"},
#endif
	{
        3, -3, -4,

        1, -2, -3,
        2, -1, -3,

        2, -2, -2,
        -1, -1, -2,
        0, 0, -2,
        1, 1, -2,

        0, -1, -1,
        -3, 0, -1, 1, 0, -1,
        -2, 1, -1,
        -1, 2, -1,
        0, 3, -1,

        1, -1, 0,
        -2, 0, 0,
        -1, 1, 0,
        0, 2, 0,

        -1, 0, 1,
        0, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"triangle (p6)"},
#endif
	{
        -1, 0, -3,
        -1, 2, -3, 1, 2, -3,

        -3, -1, -2,
        1, 3, -2,

        -2, -3, -1,
        -3, -2, -1,
        -2, -1, -1,
        -1, 0, -1,
        1, 2, -1,
        2, 3, -1,

        1, 1, 0, 3, 1, 0,

        -2, -3, 1, 0, -3, 1,
        0, -1, 1,

        1, -1, 2, 3, -1, 2,
        3, 1, 2,

        1, -2, 3,
        2, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"ant (p6)"},
#endif
	{
        0, -3, -3,
        0, -1, -3,
        0, 1, -3,
        0, 3, -3,

        -1, -3, -2, 1, -3, -2,
        -1, 3, -2, 1, 3, -2,

        -1, -2, -1,
        0, -1, -1,
        0, 1, -1,
        1, 2, -1,

        1, -2, 1,
        0, -1, 1,
        0, 1, 1,
        -1, 2, 1,

        -1, -3, 2, 1, -3, 2,
        -1, 3, 2, 1, 3, 2,

        0, -3, 3,
        0, -1, 3,
        0, 1, 3,
        0, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"squid (p6)"},
#endif
	{
        -1, -3, -2,
        -1, -1, -2,
        1, 1, -2, 3, 1, -2,

        -3, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        1, 2, -1,
        2, 3, -1,

        -2, -2, 0,
        2, 2, 0,

        0, -3, 1,
        -1, -2, 1, 1, -2, 1,
        0, -1, 1, 2, -1, 1,
        1, 0, 1, 3, 0, 1,
        2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"waltzing tetra (p6)"},
#endif
	{
        2, 1, -3,
        1, 2, -3,

        3, -1, -2,
        1, 1, -2, 3, 1, -2,

        0, 1, -1,
        -2, 3, -1, 0, 3, -1,

        1, -1, 0, 3, -1, 0,

        2, -3, 1,
        1, -2, 1,
        -1, 0, 1,
        -2, 1, 1,
        -3, 2, 1,
        -2, 3, 1, 2, 3, 1,

        1, -3, 2,
        -3, 1, 2, 3, 1, 2,
        2, 2, 2,

        -1, -2, 3, 1, -2, 3,
        -1, 0, 3,
        1, 2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"gremlin (p6)"},
#endif
	{
        0, -1, -3,
        2, 1, -3,

        -2, -2, -2,
        1, -1, -2, 3, -1, -2,
        -1, 1, -2,

        1, -2, -1,
        -3, 0, -1,
        -2, 1, -1, 2, 1, -1,
        1, 2, -1,
        -2, 3, -1,

        -1, -3, 0,
        3, 1, 0,

        -1, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -3, 2, 1, -1, 2, 1,
        0, 3, 1,

        1, -3, 2,
        1, -1, 2,
        -1, 1, 2,
        2, 2, 2,

        -1, -2, 3,
        1, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"cats cradle (p8)"},
#endif
	{
        -3, -5, -2,
        -5, -3, -2,
        5, 3, -2,
        3, 5, -2,

        -2, -5, -1,
        -3, -4, -1,
        -4, -3, -1, -2, -3, -1,
        -5, -2, -1, -3, -2, -1, 1, -2, -1,
        0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1,
        -1, 2, -1, 3, 2, -1, 5, 2, -1,
        2, 3, -1, 4, 3, -1,
        3, 4, -1,
        2, 5, -1,

        -2, -4, 0,
        1, -3, 0,
        -4, -2, 0,
        3, -1, 0,
        -3, 1, 0,
        4, 2, 0,
        -1, 3, 0,
        2, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"spiral galaxy (p8)"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -2, -2, 0, 2, -2, 0,
        -2, 2, 0, 2, 2, 0,

        -1, -4, 1, 1, -4, 1,
        0, -3, 1,
        -4, -1, 1, 4, -1, 1,
        -3, 0, 1, 3, 0, 1,
        -4, 1, 1, 4, 1, 1,
        0, 3, 1,
        -1, 4, 1, 1, 4, 1,

        0, -4, 2, 2, -4, 2,
        -1, -3, 2,
        -4, -2, 2,
        -1, -1, 2, 1, -1, 2, 3, -1, 2,
        -4, 0, 2, 4, 0, 2,
        -3, 1, 2, -1, 1, 2, 1, 1, 2,
        4, 2, 2,
        1, 3, 2,
        -2, 4, 2, 0, 4, 2,
        127
	},
};

static char patterns_12B3S456[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"2-F"},
#endif
	{
        0, 0, -2,

        -2, 1, -1, 0, 1, -1,

        -1, -1, 0, 1, -1, 0,

        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"hex-1"},
#endif
	{
        1, 0, -1,
        0, 1, -1,

        1, -1, 0,
        0, 0, 0,
        -1, 1, 0,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"hex"},
#endif
	{
        1, 0, -1,
        0, 1, -1,

        1, -1, 0,
        0, 0, 0,
        -1, 1, 0,

        0, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"blinker2"},
#endif
	{
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        0, -1, -1,

        1, -1, 0,
        0, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"M"},
#endif
	{
        0, -1, -1,

        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,

        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"parachute"},
#endif
	{
        0, 0, -2,

        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,

        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double blinker2"},
#endif
	{
        -1, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1, 2, 1, -1,
        1, 2, -1,

        -2, -2, 0,
        -1, -1, 0,
        1, 1, 0,
        2, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"stretch"},
#endif
	{
        -1, -1, -2, 1, -1, -2,
        -1, 1, -2, 1, 1, -2,

        0, -1, -1,
        0, 1, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"2-L variant"},
#endif
	{
        0, -2, -2,
        0, 2, -2,

        -1, -2, -1,
        -1, 0, -1,
        -1, 2, -1,

        1, -3, 0,
        1, -1, 0,
        1, 1, 0,
        1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"saucer"},
#endif
	{
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,
        127
	},
#ifdef LIFE_NAMES
	{"saucer variant"},
#endif
	{
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"wobbly saucer"},
#endif
	{
        1, -1, -2,
        -1, 1, -2,

        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,

        -1, -1, 0,
        1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"prop"},
#endif
	{
        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,

        1, -2, 1,
        -2, -1, 1, 0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 2, 1, 1,
        -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"8-E"},
#endif
	{
        -1, -1, -2,

        0, -3, -1,
        1, -2, -1,
        -2, -1, -1,
        -2, 1, -1,

        2, -2, 0,
        2, 0, 0,
        -1, 1, 0,
        0, 2, 0,

        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bat"},
#endif
	{
        -1, -2, -1,
        1, 0, -1,
        -1, 2, -1,

        1, -1, 0,
        1, 1, 0,

        0, -3, 1,
        -1, -2, 1,
        -1, 0, 1,
        -1, 2, 1,
        0, 3, 1,

        1, -1, 2,
        1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"ring (3 * 8-E)"},
#endif
	{
        1, 0, -5,
        1, 2, -5,

        3, -1, -4,
        2, 0, -4,
        0, 2, -4,

        1, 4, -3,

        5, -1, -2,
        4, 0, -2,
        0, 4, -2,

        -4, 3, -1,
        -2, 5, -1, 0, 5, -1,

        2, -4, 0,
        4, -2, 0,
        5, -1, 0,
        -5, 1, 0,
        -4, 2, 0,
        -2, 4, 0,

        0, -5, 1, 2, -5, 1,
        4, -3, 1,

        0, -4, 2,
        -4, 0, 2,
        -5, 1, 2,

        -1, -4, 3,

        0, -2, 4,
        -2, 0, 4,
        -3, 1, 4,

        -1, -2, 5,
        -1, 0, 5,
        127
	},
#ifdef LIFE_NAMES
	{"tetra"},
#endif
	{
        -1, -1, -2,
        0, 0, -2,
        1, 1, -2,

        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        1, -1, 0,
        0, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4C"},
#endif
	{
        0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        0, 2, -2,

        -1, -2, -1,
        2, -1, -1,
        -2, 1, -1,
        1, 2, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"6-A"},
#endif
	{
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        0, -4, 0,
        -2, -2, 0, 2, -2, 0,
        -4, 0, 0, 4, 0, 0,
        -2, 2, 0, 2, 2, 0,
        0, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"square"},
#endif
	{
        0, -2, 0,
        -2, 0, 0, 2, 0, 0,
        0, 2, 0,

        0, -3, 1,
        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -3, 0, 1, 3, 0, 1,
        -2, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        0, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"small poppy"},
#endif
	{
        -1, -1, -2,
        -2, 0, -2, 0, 0, -2,
        -1, 1, -2,

        -2, -1, -1, 0, -1, -1,
        -2, 1, -1, 0, 1, -1,
        1, 2, -1,

        -1, -1, 0,
        -2, 0, 0, 0, 0, 0,
        -1, 1, 0,

        1, 0, 1,
        -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"chair"},
#endif
	{
        -1, -2, -1,
        -3, 0, -1,

        -2, -2, 0,
        -3, -1, 0, -1, -1, 0,
        -2, 0, 0,

        -1, -2, 1,
        0, -1, 1,
        -3, 0, 1,
        -2, 1, 1,

        -2, -2, 2,
        -3, -1, 2, -1, -1, 2, 1, -1, 2,
        -2, 0, 2, 0, 0, 2, 2, 0, 2,
        -1, 1, 2, 1, 1, 2,
        -2, 2, 2, 0, 2, 2, 2, 2, 2,
        -1, 3, 2, 1, 3, 2,
        127
	},
#ifdef LIFE_NAMES
	{"kissing fish (p3)"},
#endif
	{
        -1, 0, -1, 1, 0, -1,

        -2, 0, 0, 2, 0, 0,

        -4, -1, 1, -2, -1, 1, 2, -1, 1, 4, -1, 1,
        -3, 0, 1, -1, 0, 1, 1, 0, 1, 3, 0, 1,
        -4, 1, 1, -2, 1, 1, 2, 1, 1, 4, 1, 1,

        -2, 0, 2, 2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"F (p3)"},
#endif
	{
        -2, -2, -2,
        -3, -1, -2, -1, -1, -2,
        -2, 0, -2,

        -3, -2, -1, -1, -2, -1,
        -3, 0, -1, -1, 0, -1,

        -2, -2, 0,
        -3, -1, 0, -1, -1, 0,
        -2, 0, 0,

        1, 0, 1,
        0, 1, 1, 2, 1, 1,
        1, 2, 1,

        0, 0, 2, 2, 0, 2,
        0, 2, 2, 2, 2, 2,

        1, 0, 3,
        0, 1, 3, 2, 1, 3,
        1, 2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"fighters (p3)"},
#endif
	{
        -1, -2, -3, 1, -2, -3,
        0, -1, -3,
        0, 1, -3,
        -1, 2, -3, 1, 2, -3,

        0, -2, -2,
        0, 2, -2,

        -1, -2, -1, 1, -2, -1,
        0, -1, -1,
        0, 1, -1,
        -1, 2, -1, 1, 2, -1,

        0, -4, 0,
        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,
        0, 4, 0,

        0, -3, 1,
        0, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spore (p3)"},
#endif
	{
        -3, -3, -4, -1, -3, -4,
        -2, -2, -4,
        -3, -1, -4,
        0, 0, -4,

        -2, -3, -3,
        -3, -2, -3,

        -3, -3, -2,
        0, 0, -2,

        0, -3, -1,
        0, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1, 3, 0, -1,
        0, 1, -1,
        0, 3, -1,

        0, 0, 0,
        3, 3, 0,

        3, 2, 1,
        2, 3, 1,

        0, 0, 2,
        3, 1, 2,
        2, 2, 2,
        1, 3, 2, 3, 3, 2,
        127
	},
#ifdef LIFE_NAMES
	{"turtle (p3)"},
#endif
	{
        -1, -3, -2,
        -3, -1, -2, -1, -1, -2,
        1, 1, -2, 3, 1, -2,
        1, 3, -2,

        0, -3, -1,
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1, 3, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,
        0, 3, -1,

        0, -2, 0,
        -2, 0, 0, 2, 0, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"6 flies (p3)"},
#endif
	{
        0, -2, -4, 2, -2, -4,
        1, -1, -4,
        2, 0, -4,

        1, -2, -3,
        2, -1, -3,

        2, -2, -2,
        -4, 0, -2,
        -3, 1, -2,
        -4, 2, -2, -2, 2, -2, 2, 2, -2,
        1, 3, -2,
        0, 4, -2, 2, 4, -2,

        -4, 1, -1,
        -3, 2, -1,
        2, 3, -1,
        1, 4, -1,

        -2, -4, 0,
        4, -2, 0,
        -4, 2, 0,
        2, 4, 0,

        -1, -4, 1,
        -2, -3, 1,
        3, -2, 1,
        4, -1, 1,

        -2, -4, 2, 0, -4, 2,
        -1, -3, 2,
        -2, -2, 2, 2, -2, 2, 4, -2, 2,
        3, -1, 2,
        4, 0, 2,
        -2, 2, 2,

        -2, 1, 3,
        -1, 2, 3,

        -2, 0, 4,
        -1, 1, 4,
        -2, 2, 4, 0, 2, 4,
        127
	},
#ifdef LIFE_NAMES
	{"A (p4)"},
#endif
	{
        0, -1, -1,
        1, 0, -1,

        2, -2, 0,
        1, -1, 0,
        0, 0, 0,

        -1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"clock (p4)"},
#endif
	{
        0, 0, -2,

        -1, -2, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        -1, 2, -1, 1, 2, -1,

        1, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"E forger (p4)"},
#endif
	{
        1, -1, -2,
        0, 0, -2,

        -1, -2, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        -1, 2, -1,

        0, 0, 0,
        1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"E (p4)"},
#endif
	{
        0, -1, -1,
        1, 0, -1,
        2, 1, -1,

        2, -2, 0,
        1, -1, 0,
        0, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,

        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"B (p4)"},
#endif
	{
        -1, -1, -2,
        0, 0, -2,
        1, 1, -2,

        1, -2, -1,
        0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1,
        -1, 2, -1,

        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"ball and 5 (p4)"},
#endif
	{
        1, -2, -1,
        -2, -1, -1, 0, -1, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        0, 0, 0,

        -1, -2, 1,
        0, -1, 1, 2, -1, 1,

        1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"isolation (p4)"},
#endif
	{
        1, -2, -1,
        0, -1, -1,
        0, 1, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        0, 0, 0,

        -1, -2, 1,
        0, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"choke (p4)"},
#endif
	{
        -2, -1, -1,
        -1, 0, -1,
        -2, 1, -1, 0, 1, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        0, 0, 0,

        -1, 0, 1,
        -2, 1, 1,

        -1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"pillow (p4)"},
#endif
	{
        -1, 0, -1, 1, 0, -1,

        0, -1, 1, 2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1,

        0, -2, 2,
        -1, -1, 2, 1, -1, 2,
        -1, 1, 2, 1, 1, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"friends (p4)"},
#endif
	{
        1, -3, -2,
        -1, 3, -2,

        0, -3, -1,
        1, -2, -1,
        -1, 2, -1,
        0, 3, -1,

        2, -2, 0,
        1, -1, 0,
        -1, 1, 0,
        -2, 2, 0,

        2, -3, 1,
        2, -1, 1,
        -2, 1, 1,
        -2, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"handshake (p4)"},
#endif
	{
        -3, -2, -1,
        3, 2, -1,

        -2, -2, 0,
        -3, -1, 0,
        -4, 0, 0, -2, 0, 0, 2, 0, 0, 4, 0, 0,
        3, 1, 0,
        2, 2, 0,

        -4, -1, 1, 0, -1, 1,
        0, 1, 1, 4, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"H (p4)"},
#endif
	{
        0, -3, -1,
        -3, -2, -1, -1, -2, -1,
        2, -1, -1,
        1, 0, -1,
        1, 2, -1,

        -1, -3, 0,
        -2, -2, 0, 0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        0, 0, 0, 2, 0, 0,
        1, 1, 0,

        -2, -3, 1,
        -1, -2, 1,
        1, 0, 1,
        2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"M or I (p4)"},
#endif
	{
        0, -2, -2,
        -1, -1, -2, 1, -1, -2,
        0, 0, -2,

        -1, -2, -1,
        -2, -1, -1,
        1, 0, -1,
        0, 1, -1,

        -2, -2, 0, 0, -2, 0,
        1, -1, 0,
        -2, 0, 0,
        -1, 1, 0, 1, 1, 0,

        -2, -1, 1, 0, -1, 1,
        -1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"poppy (p4)"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -2, -2, 0, 2, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        -2, 2, 0, 2, 2, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,

        0, -2, 2,
        -2, 0, 2, 2, 0, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"poppy and friend (p4)"},
#endif
	{
        -1, -1, -4, 1, -1, -4,
        -1, 1, -4, 1, 1, -4,

        -1, -2, -3,
        0, -1, -3, 2, -1, -3,
        -1, 0, -3, 1, 0, -3,
        -2, 1, -3, 0, 1, -3,
        1, 2, -3,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 0, -1, 1, 2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,

        -1, -1, 2, 1, -1, 2,
        -1, 1, 2, 1, 1, 2,

        0, -1, 3,
        -1, 0, 3, 1, 0, 3,
        0, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"threesome (p4)"},
#endif
	{
        2, 0, -4,
        1, 1, -4,
        0, 2, -4,

        1, 0, -3,
        0, 1, -3, 2, 1, -3,
        1, 2, -3,

        3, 1, -2,
        1, 3, -2,

        2, -3, -1,
        1, -2, -1,
        -2, 1, -1,
        -3, 2, -1,

        1, -3, 0,
        0, -2, 0, 2, -2, 0,
        3, -1, 0,
        -2, 0, 0,
        -3, 1, 0,
        -2, 2, 0,
        -1, 3, 0,

        0, -3, 1,
        1, -2, 1,
        -3, 0, 1,
        -2, 1, 1,

        1, -1, 2,
        -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"log (p4)"},
#endif
	{
        -1, -1, -2,
        1, 1, -2,

        0, -3, -1,
        -1, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1, 3, 0, -1,
        0, 1, -1, 2, 1, -1,
        1, 2, -1,
        0, 3, -1,

        -2, -2, 0,
        -1, -1, 0,
        1, 1, 0,
        2, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"log2 (p4)"},
#endif
	{
        1, -2, -3,
        -2, -1, -3,
        1, 0, -3,

        -1, -3, -2, 1, -3, -2,
        0, -2, -2, 2, -2, -2,
        -3, -1, -2, 1, -1, -2,

        1, -2, -1,
        0, -1, -1,
        -1, 0, -1,
        2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        2, -2, 0,
        -3, -1, 0, -1, -1, 0,
        -2, 0, 0, 0, 0, 0,
        -1, 1, 0,

        0, -3, 1,
        -1, 0, 1,

        0, -2, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"swimming hexagon (p4)"},
#endif
	{
        -1, -1, -4, 1, -1, -4,

        -1, -2, -3, 1, -2, -3,
        -2, -1, -3, 0, -1, -3, 2, -1, -3,

        -1, -1, -2, 1, -1, -2,
        -2, 0, -2, 2, 0, -2,

        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -3, 0, -1, 3, 0, -1,

        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 0, -1, 1, 2, -1, 1,

        -1, -1, 2, 1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"swimming square (p4)"},
#endif
	{
        0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        0, 2, -2,

        1, -4, -1,
        0, -3, -1,
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1, 4, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1, 3, 0, -1,
        -4, 1, -1, -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,
        0, 3, -1,
        -1, 4, -1,

        -1, -3, 0,
        0, -2, 0,
        -3, -1, 0,
        -2, 0, 0, 2, 0, 0,
        3, 1, 0,
        0, 2, 0,
        1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"large poppy (p4)"},
#endif
	{
        0, -1, -3,
        -1, 0, -3, 1, 0, -3,
        0, 1, -3,

        -1, -1, -2, 1, -1, -2,
        -1, 1, -2, 1, 1, -2,

        1, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1, 2, 1, -1,
        -1, 2, -1,

        -2, -2, 0, 2, -2, 0,
        -2, 2, 0, 2, 2, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 0, -1, 1, 2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,

        -1, -1, 2, 1, -1, 2,
        -1, 1, 2, 1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"nova (p4)"},
#endif
	{
        3, 0, -5,

        0, 2, -4,
        0, 4, -4,

        2, -1, -3,
        3, 0, -3,
        2, 1, -3,
        -1, 2, -3, 1, 2, -3,

        2, -2, -2,
        0, 0, -2,
        -2, 2, -2,

        2, -3, -1, 4, -3, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        -4, 3, -1, -2, 3, -1,

        2, -2, 0,
        0, 0, 0,
        -2, 2, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1,
        -3, 0, 1,
        -2, 1, 1,

        0, -4, 2,
        0, -2, 2,

        -3, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"huddle (p4)"},
#endif
	{
        -3, -4, -1, 3, -4, -1,
        -4, -3, -1, 4, -3, -1,
        -4, 3, -1, 4, 3, -1,
        -3, 4, -1, 3, 4, -1,

        -3, -3, 0, 3, -3, 0,
        -3, 3, 0, 3, 3, 0,

        -2, -3, 1, 2, -3, 1,
        -3, -2, 1, 3, -2, 1,
        -3, 2, 1, 3, 2, 1,
        -2, 3, 1, 2, 3, 1,

        -4, -4, 2, -2, -4, 2, 2, -4, 2, 4, -4, 2,
        -3, -3, 2, 3, -3, 2,
        -4, -2, 2, -2, -2, 2, 2, -2, 2, 4, -2, 2,
        -4, 2, 2, -2, 2, 2, 2, 2, 2, 4, 2, 2,
        -3, 3, 2, 3, 3, 2,
        -4, 4, 2, -2, 4, 2, 2, 4, 2, 4, 4, 2,
        127
	},
#ifdef LIFE_NAMES
	{"flaming heart (p5)"},
#endif
	{
        -1, -1, -2,
        0, 0, -2,
        1, 1, -2,

        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -2, 1,
        -2, -1, 1, 0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 2, 1, 1,
        1, 2, 1,

        -2, -2, 2,
        -1, -1, 2,
        1, 1, 2,
        2, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"flaming heart2 (p5)"},
#endif
	{
        1, -3, -2, 3, -3, -2,
        2, -2, -2,
        3, -1, -2,
        -3, 1, -2,
        -2, 2, -2,
        -3, 3, -2, -1, 3, -2,

        1, -2, -1,
        0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1,
        -1, 2, -1,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,

        -1, -1, 2,
        0, 0, 2,
        1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"threesome (p5)"},
#endif
	{
        -2, -1, -3, 0, -1, -3,

        2, -2, -2,
        -1, -1, -2,
        -2, 0, -2,
        -3, 1, -2,

        -1, 0, -1, 3, 0, -1,
        -2, 1, -1, 2, 1, -1,
        3, 2, -1,

        1, -3, 0,
        -3, 1, 0, 1, 1, 0,
        2, 2, 0,

        1, -2, 1,
        0, -1, 1,
        1, 2, 1,
        0, 3, 1, 2, 3, 1,

        1, -3, 2,
        0, -2, 2,
        -1, -1, 2,
        -2, 2, 2,

        -1, -2, 3,
        -1, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"chicken and egg (p5)"},
#endif
	{
        2, -3, -3,
        1, -2, -3, 3, -2, -3,
        2, -1, -3,

        1, -3, -2, 3, -3, -2,
        1, -1, -2, 3, -1, -2,
        0, 2, -2,

        2, -3, -1,
        1, -2, -1, 3, -2, -1,
        2, -1, -1,
        -1, 0, -1,
        -2, 1, -1, 0, 1, -1,
        -1, 2, -1,

        -2, -2, 0,
        -1, -1, 0,
        -1, 1, 0, 1, 1, 0,

        -2, -1, 1, 0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        1, 2, 1,

        -1, -1, 2,
        2, 0, 2,
        1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"gremlin (p5)"},
#endif
	{
        -2, -1, -3, 0, -1, -3,
        -2, 1, -3,

        -1, -3, -2, 1, -3, -2,
        0, -2, -2,
        -2, 0, -2,

        -3, -2, -1,
        0, -1, -1,
        -3, 0, -1, -1, 0, -1,
        2, 3, -1,

        -1, -3, 0,
        -2, -2, 0,
        -1, -1, 0,
        1, 1, 0, 3, 1, 0,
        2, 2, 0,

        -3, -2, 1,
        1, 0, 1,
        0, 1, 1,
        0, 3, 1, 2, 3, 1,

        3, -1, 2,
        2, 0, 2,
        3, 1, 2,
        0, 2, 2,

        1, 0, 3,
        -1, 2, 3, 1, 2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"cootie catcher (p5)"},
#endif
	{
        0, -1, -3,
        -1, 0, -3, 1, 0, -3,
        0, 1, -3,

        0, -2, -2,
        -2, 0, -2, 0, 0, -2, 2, 0, -2,
        0, 2, -2,

        0, -3, -1,
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -3, 0, -1, 3, 0, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,
        0, 3, -1,

        -3, -3, 0, 3, -3, 0,
        -2, -2, 0, 2, -2, 0,
        -2, 2, 0, 2, 2, 0,
        -3, 3, 0, 3, 3, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -2, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"turtle (p5)"},
#endif
	{
        0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        0, 2, -2,

        -1, -4, -1,
        0, -3, -1,
        -1, -2, -1, 1, -2, -1,
        -4, -1, -1, -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1, 3, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1, 4, 1, -1,
        -1, 2, -1, 1, 2, -1,
        0, 3, -1,
        1, 4, -1,

        -2, -3, 1,
        -3, -2, 1, -1, -2, 1,
        -2, -1, 1, 0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 2, 1, 1,
        1, 2, 1, 3, 2, 1,
        2, 3, 1,

        -1, -1, 2,
        1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"C (p6)"},
#endif
	{
        0, -1, -1,
        0, 1, -1,

        0, 0, 0,

        -2, -1, 1, 0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"2 balls (p6)"},
#endif
	{
        0, -3, -1,
        0, -1, -1,
        0, 1, -1,
        0, 3, -1,

        0, -4, 0,
        0, -2, 0,
        0, 2, 0,
        0, 4, 0,

        0, -3, 1,
        -1, -2, 1, 1, -2, 1,
        0, -1, 1,
        0, 1, 1,
        -1, 2, 1, 1, 2, 1,
        0, 3, 1,

        0, -4, 2,
        0, -2, 2,
        0, 2, 2,
        0, 4, 2,
        127
	},
#ifdef LIFE_NAMES
	{"K (p6)"},
#endif
	{
        1, -1, -4,
        0, 0, -4,
        0, 2, -4,

        1, 0, -3, 3, 0, -3,
        0, 1, -3,

        1, -1, -2,
        2, 0, -2,
        -3, 1, -2, -1, 1, -2, 1, 1, -2,
        0, 2, -2,
        1, 3, -2,

        0, -3, -1, 2, -3, -1,
        1, -2, -1,
        2, -1, -1,
        -3, 0, -1, 3, 0, -1,
        -2, 1, -1,
        -1, 2, -1,
        -2, 3, -1, 0, 3, -1,

        -1, -3, 0,
        0, -2, 0,
        -1, -1, 0, 1, -1, 0, 3, -1, 0,
        -2, 0, 0,
        -1, 1, 0,

        0, -1, 1,
        -3, 0, 1, -1, 0, 1,

        0, -2, 2,
        0, 0, 2,
        -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"galaxy (p6)"},
#endif
	{
        0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        0, 2, -2,

        1, -4, -1,
        -4, -1, -1,
        4, 1, -1,
        -1, 4, -1,

        0, -4, 0, 2, -4, 0,
        1, -3, 0,
        -4, -2, 0,
        -3, -1, 0,
        -4, 0, 0, 4, 0, 0,
        3, 1, 0,
        4, 2, 0,
        -1, 3, 0,
        -2, 4, 0, 0, 4, 0,

        2, -3, 1,
        -3, -2, 1, -1, -2, 1,
        0, -1, 1, 2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1,
        1, 2, 1, 3, 2, 1,
        -2, 3, 1,

        -1, -1, 2, 1, -1, 2,
        -1, 1, 2, 1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"corner (p6)"},
#endif
	{
        0, -2, -2, 2, -2, -2,
        1, -1, -2,
        -2, 0, -2,
        -1, 1, -2,
        -2, 2, -2,

        0, -3, -1, 2, -3, -1,
        0, -1, -1, 2, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        -3, 2, -1, -1, 2, -1,

        1, -3, 0,
        0, -2, 0, 2, -2, 0,
        -2, 0, 0,
        -3, 1, 0,
        -2, 2, 0,

        -2, -3, 1,
        -3, -2, 1, -1, -2, 1, 1, -2, 1,
        -2, -1, 1,
        -2, 1, 1,

        -1, -3, 2,
        0, -2, 2,
        -3, -1, 2,
        -2, 0, 2,

	-2, -3, 3,
        -3, -2, 3, -1, -2, 3,
        -2, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"ripple (p6)"},
#endif
	{
        0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        0, 2, -2,

        0, -3, -1,
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1, 3, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,
        0, 3, -1,

        0, -2, 0,
        -2, 0, 0, 2, 0, 0,
        0, 2, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -2, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pound (p6)"},
#endif
	{
        -1, -3, 0,
        0, -2, 0,
        -3, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0,
        0, 2, 0,

        -1, -4, 1,
        0, -3, 1,
        -1, -2, 1,
        -4, -1, 1, -2, -1, 1, 2, -1, 1,
        -3, 0, 1, 1, 0, 1, 3, 0, 1,
        0, 1, 1,
        -1, 2, 1,
        0, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"flying carpet (p6)"},
#endif
	{
        -2, -2, -2,
        2, 2, -2,

        -1, -4, -1,
        -2, -3, -1, 0, -3, -1,
        -3, -2, -1, -1, -2, -1, 1, -2, -1,
        -4, -1, -1, -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1, 3, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1, 4, 1, -1,
        -1, 2, -1, 1, 2, -1, 3, 2, -1,
        0, 3, -1, 2, 3, -1,
        1, 4, -1,

        -1, -3, 0,
        -3, -1, 0, 1, -1, 0,
        -1, 1, 0, 3, 1, 0,
        1, 3, 0,

        1, -2, 1,
        2, -1, 1,
        -2, 1, 1,
        -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"cradle (p6)"},
#endif
	{
        2, -3, -1,
        -1, -2, -1, 1, -2, -1, 3, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -3, 2, -1, -1, 2, -1, 1, 2, -1,
        -2, 3, -1,

        1, -3, 0,
        0, -2, 0,
        3, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -3, 1, 0,
        0, 2, 0,
        -1, 3, 0,

        2, -3, 1,
        1, -2, 1, 3, -2, 1,
        2, -1, 1,
        -2, 1, 1,
        -3, 2, 1, -1, 2, 1,
        -2, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"hexagon (p6)"},
#endif
	{
        -3, 1, -4,
        -1, 3, -4,

        -2, 1, -3,
        -3, 2, -3, -1, 2, -3,
        -2, 3, -3,

        -2, 0, -2, 0, 0, -2,
        -3, 1, -2,
        0, 2, -2,
        -1, 3, -2,

        -2, -1, -1, 0, -1, -1,
        1, 0, -1,
        -2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        -3, -3, 0,
        -2, -2, 0,
        -3, -1, 0,
        -2, 0, 0,
        0, 2, 0, 2, 2, 0,
        1, 3, 0, 3, 3, 0,

        -3, -2, 1, -1, -2, 1,
        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 2, 1, 1,
        2, 3, 1,

        -1, -3, 2,
        -2, -2, 2,
        -1, -1, 2,
        1, 1, 2, 3, 1, 2,
        2, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"conveyor (p7)"},
#endif
	{
        2, -2, -2,
        1, -1, -2,

        1, -2, -1,
        0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1,
        -1, 2, -1,

        -1, 1, 0,
        -2, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"G (p8)"},
#endif
	{
        -1, -2, -3,
        2, 1, -3,

        -1, -1, -2,
        1, 1, -2,

        -1, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1, 2, 1, -1,
        1, 2, -1,

        -1, -1, 0,
        1, 1, 0,

        -1, -2, 1,
        -1, 0, 1,
        0, 1, 1, 2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"population (p8)"},
#endif
	{
        -1, -2, -3,
        -2, -1, -3, 0, -1, -3, 2, -1, -3,
        -1, 0, -3, 1, 0, -3,
        0, 1, -3,
        1, 2, -3,

        -2, -2, -2, 0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        -2, 2, -2, 0, 2, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        0, -2, 0, 2, -2, 0,
        -2, 0, 0, 2, 0, 0,
        0, 2, 0, 2, 2, 0,

        -1, -2, 1,
        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1, 2, 1, 1,
        1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"log (p8)"},
#endif
	{
        -2, -3, -5,

        -4, -2, -4, -2, -2, -4,
        -2, 0, -4,
        -1, 1, -4,

        -3, -4, -3,
        -2, -3, -3, 0, -3, -3,
        -3, -2, -3, -1, -2, -3,
        -2, -1, -3,
        -1, 0, -3,

        1, -3, -2,
        -2, -2, -2, 0, -2, -2,
        0, 0, -2,
        3, 1, -2,

        -3, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1, 2, 1, -1,
        3, 2, -1,

        -3, -1, 0,
        0, 0, 0,
        0, 2, 0, 2, 2, 0,
        -1, 3, 0,

        1, 0, 1,
        2, 1, 1,
        1, 2, 1, 3, 2, 1,
        0, 3, 1, 2, 3, 1,
        3, 4, 1,

        1, -1, 2,
        2, 0, 2,
        2, 2, 2, 4, 2, 2,

        2, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"disk (p10)"},
#endif
	{
        -1, -3, -2,
        0, -2, -2, 2, -2, -2,
        -2, 2, -2, 0, 2, -2,
        1, 3, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        2, -2, 0,
        -3, -1, 0,
        -2, 0, 0, 2, 0, 0,
        3, 1, 0,
        -2, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"J (p10)"},
#endif
	{
        1, -1, -4,
        2, 0, -4,
        -1, 1, -4,
        0, 2, -4,

        2, -1, -3,
        3, 0, -3,
        2, 1, -3,
        -1, 2, -3, 1, 2, -3,
        0, 3, -3,

        1, -3, -2,
        2, -2, -2,
        -3, 1, -2, 3, 1, -2,
        -2, 2, -2,
        1, 3, -2,

        2, -3, -1,
        3, -2, -1,
        -3, 2, -1,
        -2, 3, -1,

        -1, -3, 0,
        2, -2, 0,
        -3, -1, 0, 3, -1, 0,
        -2, 2, 0,
        -1, 3, 0,

        0, -3, 1,
        -1, -2, 1, 1, -2, 1,
        -2, -1, 1,
        -3, 0, 1,
        -2, 1, 1,

        0, -2, 2,
        1, -1, 2,
        -2, 0, 2,
        -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"Ottoman (p10)"},
#endif
	{
        1, -3, -2,
        -2, -2, -2, 0, -2, -2, 2, -2, -2,
        -3, -1, -2,
        -2, 0, -2, 2, 0, -2,
        3, 1, -2,
        -2, 2, -2, 0, 2, -2, 2, 2, -2,
        -1, 3, -2,

         -1, -2, -1, 1, -2, -1,
         -2, -1, -1, 0, -1, -1, 2, -1, -1,
         -1, 0, -1, 1, 0, -1,
         -2, 1, -1, 0, 1, -1, 2, 1, -1,
         -1, 2, -1, 1, 2, -1,

        0, -2, 0,
        -2, 0, 0, 2, 0, 0,
        0, 2, 0,

        0, -1, 1,
         -1, 0, 1, 1, 0, 1,
         0, 1, 1,

        0, -2, 2,
        -2, 0, 2, 2, 0, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"D (p12)"},
#endif
	{
        0, -1, -1,

        1, -1, 0,
        0, 0, 0,
        -1, 1, 0,
        0, 2, 0,

        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"small donut (p12)"},
#endif
	{
        0, 1, -3,

        0, 0, -2,
        -1, 1, -2,

        1, -2, -1,
        1, 0, -1, 3, 0, -1,
        0, 1, -1, 2, 1, -1,

        1, -3, 0,
        0, -2, 0,
        1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0,
        0, 2, 0,
        -1, 3, 0,

        -2, -1, 1, 0, -1, 1,
        -3, 0, 1, -1, 0, 1,
        -1, 2, 1,

        1, -1, 2,
        0, 0, 2,

        0, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"P (p30)"},
#endif
	{
        1, -2, -1,
        0, -1, -1,
        -1, 0, -1,
        0, 1, -1,
        -1, 2, -1,

        1, -3, 0,
        0, -2, 0,
        1, -1, 0,
        0, 0, 0,
        -1, 1, 0,
        127
	},
};

static char patterns_14B4S34[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"gear"},
#endif
	{
         -1, -1, -1, 0, -1, -1,
         -1, 0, -1,

        0, 0, 0,

         -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"lift"},
#endif
	{
         0, -1, -1,

        1, -2, 0,
        1, -1, 0,
        -1, 0, 0, 0, 0, 0,

         0, -2, 1,
         -1, -1, 1,

        1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"squeeze"},
#endif
	{
        -1, -1, -2,

         -1, -2, -1,

        0, -2, 0,
        -1, -1, 0,

         -1, -3, 1,
         -2, -2, 1, 0, -2, 1,
         -1, -1, 1,

        -1, -3, 2,
        -1, -2, 2,
        0, -1, 2, 1, -1, 2,

         -1, -2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"dampen"},
#endif
	{
         1, -1, -3,
         0, 0, -3,

        0, -1, -2,
        1, 0, -2,

         -1, -2, -1, 0, -2, -1,
         -1, -1, -1,
         1, 0, -1,

        1, -1, 0,
        0, 0, 0,

         0, -2, 1,
         -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"twinkle"},
#endif
	{
         -1, -2, -3, 0, -2, -3,
         0, -1, -3,

        0, -2, -2, 1, -2, -2,
        -1, -1, -2, 1, -1, -2,
        -1, 0, -2,

         -1, -3, -1,
         -2, -2, -1,
         -2, -1, -1, 0, -1, -1,

        -1, -2, 0,
        1, -1, 0,
        -1, 0, 0, 0, 0, 0,

         -1, -3, 1, 0, -3, 1,
         0, -2, 1,
         -2, -1, 1, -1, -1, 1,

        -1, -2, 2, 0, -2, 2,
        0, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"octahedron"},
#endif
	{
        0, -2, -4,

        0, -3, -2,
        -1, -2, -2, 0, -2, -2, 1, -2, -2,
        0, -1, -2,

        0, -4, 0,
        -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -2, -2, 0, -1, -2, 0, 1, -2, 0, 2, -2, 0,
        -1, -1, 0, 0, -1, 0, 1, -1, 0,
        0, 0, 0,

        0, -3, 2,
        -1, -2, 2, 0, -2, 2, 1, -2, 2,
        0, -1, 2,

        0, -2, 4,
        127
	},
#ifdef LIFE_NAMES
	{"star (p3)"},
#endif
	{
        -1, -1, -2,

         0, -2, -1,
         -1, -1, -1,
         -2, 0, -1,

        0, -1, 0,
        -1, 0, 0,

         0, -1, 1,
         -1, 0, 1,

        1, -1, 2,
        0, 0, 2,
        -1, 1, 2,

         0, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"spark3 (p3)"},
#endif
	{
        0, -1, -4,
        0, 0, -4,

         -1, -1, -3, 0, -1, -3,

         -1, -1, -1,
         0, 0, -1,
         0, 1, -1,

        0, -1, 0,
        1, 1, 0,

         -1, -1, 1,
         0, 0, 1,
         0, 1, 1,

         -1, -1, 3, 0, -1, 3,

        0, -1, 4,
        0, 0, 4,
        127
	},
#ifdef LIFE_NAMES
	{"spark3v2 (p3)"},
#endif
	{
        1, 0, -4, 2, 0, -4,

         0, -2, -3,
         0, -1, -3,
         1, 0, -3,

        0, -1, -2,
        2, 0, -2,

         0, -2, -1,
         1, -1, -1,

        0, -1, 0,
        1, 0, 0,

         0, -2, 1,
         1, -1, 1,

        0, -1, 2,
        2, 0, 2,

         0, -2, 3,
         0, -1, 3,
         1, 0, 3,

        1, 0, 4, 2, 0, 4,
        127
	},
#ifdef LIFE_NAMES
	{"wavy hair (p3)"},
#endif
	{
        -1, -2, -2, 0, -2, -2, 1, -2, -2,
        -1, 0, -2, 0, 0, -2, 1, 0, -2,

         -1, -3, -1, 0, -3, -1,
         -1, 0, -1, 0, 0, -1,

        -1, -2, 0, 1, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,

        -1, -1, 2, 0, -1, 2, 1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"moon lander (p3)"},
#endif
	{
        -1, -2, -4,
        -1, -1, -4,
        0, 0, -4, 1, 0, -4,

         -2, -2, -3,
         0, 0, -3,

        -1, -2, -2,
        1, 0, -2,

         -2, -1, -1,
         -2, 0, -1, -1, 0, -1,

        0, -2, 0, 1, -2, 0,
        1, -1, 0,
        -2, 0, 0,
        -1, 1, 0,

         0, -2, 1,
         -2, -1, 1, -1, -1, 1,
         -1, 0, 1,

        -1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"sandwich (p3)"},
#endif
	{
        0, -1, -4,

         -2, -2, -3, 1, -2, -3,
         -2, -1, -3, 1, -1, -3,

        -1, -2, -2, 0, -2, -2, 1, -2, -2,
        -1, 0, -2, 0, 0, -2, 1, 0, -2,

        -1, -2, 0, 1, -2, 0,
        -2, -1, 0, 2, -1, 0,
        -1, 0, 0, 1, 0, 0,

        -1, -2, 2, 0, -2, 2, 1, -2, 2,
        -1, 0, 2, 0, 0, 2, 1, 0, 2,

         -2, -2, 3, 1, -2, 3,
         -2, -1, 3, 1, -1, 3,

        0, -1, 4,
        127
	},
#ifdef LIFE_NAMES
	{"captured (p3)"},
#endif
	{
        -1, -2, -4,
        -1, -1, -4,

         -1, -3, -3, 0, -3, -3,
         -2, -2, -3,
         -2, -1, -3, -1, -1, -3,

        -1, -3, -2, 0, -3, -2,
        -2, -2, -2,
        0, -1, -2,

         -2, -3, -1, 0, -3, -1,
         1, -1, -1,
         1, 0, -1,

        -2, -2, 0, 0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        0, 0, 0, 2, 0, 0,

         -2, -3, 1,
         -2, -2, 1,
         -1, 0, 1, 1, 0, 1,

        0, -1, 2,
        2, 0, 2,
        0, 1, 2, 1, 1, 2,

         0, -2, 3, 1, -2, 3,
         1, -1, 3,
         -1, 0, 3, 0, 0, 3,

        1, -1, 4,
        1, 0, 4,
        127
	},
#ifdef LIFE_NAMES
	{"jiggle (p4)"},
#endif
	{
         -1, -1, -3,

        0, -1, -2,
        0, 0, -2,

         -1, -1, -1,

        0, -1, 0,

         -1, -1, 1,

        0, -1, 2,
        0, 0, 2,

         -1, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"pass back (p4)"},
#endif
	{
         -2, 0, -1, -1, 0, -1, 1, 0, -1,

        -1, 0, 0, 1, 0, 0,
        -1, 1, 0,

         0, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"hat trick (p4)"},
#endif
	{
         1, -1, -1,
         0, 0, -1, 1, 0, -1,
         0, 1, -1,
         0, 2, -1,

        2, 0, 0,
        0, 1, 0,
        0, 2, 0, 1, 2, 0,

         1, -1, 1,
         1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double hat trick (p4)"},
#endif
	{
         1, -1, -1, 2, -1, -1,
         -1, 1, -1,
         -1, 2, -1,

        2, -1, 0,
        2, 1, 0,
        -1, 2, 0, 1, 2, 0, 2, 2, 0,

         1, -1, 1, 2, -1, 1,
         1, 0, 1,
         -1, 1, 1, 0, 1, 1, 1, 1, 1,
         -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spark4 (p4)"},
#endif
	{
         0, -1, -1, 1, -1, -1,
         -1, 0, -1,
         -1, 1, -1,

        0, -1, 0, 2, -1, 0,
        -1, 0, 0, 2, 0, 0,
        -1, 2, 0, 0, 2, 0,

         0, -1, 1, 1, -1, 1,
         -1, 0, 1,
         -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spark4v2 (p4)"},
#endif
	{
         0, 0, -3, 1, 0, -3,
         0, 1, -3,

        1, 0, -2,
        0, 1, -2,

         0, -1, -1,
         -1, 0, -1, 1, 0, -1,
         0, 1, -1,

        0, -1, 0,
        -1, 0, 0,
        1, 1, 0,

         0, -1, 1,
         -1, 0, 1, 1, 0, 1,
         0, 1, 1,

        1, 0, 2,
        0, 1, 2,

         0, 0, 3, 1, 0, 3,
         0, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"spark5 (p5)"},
#endif
	{
        1, 0, -2,
        0, 1, -2, 1, 1, -2,

         0, -1, -1,
         1, 0, -1,
         0, 1, -1,

        1, -1, 0,
        0, 1, 0,

         0, -1, 1,
         1, 0, 1,
         0, 1, 1,

        1, 0, 2,
        0, 1, 2, 1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"spark7 (p7)"},
#endif
	{
        0, 0, -2,
        0, 1, -2,
        0, 2, -2,
        0, 3, -2,

         -1, 0, -1, 0, 0, -1,

        -1, 1, 0, 1, 1, 0,
        -1, 2, 0, 1, 2, 0,
        0, 3, 0,

         -2, 1, 1, 1, 1, 1,

        -1, 1, 2, 1, 1, 2,
        -1, 2, 2, 1, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"hoola hoop (p8)"},
#endif
	{
         -2, 1, -1, -1, 1, -1,
         -2, 2, -1, -1, 2, -1,

        0, 1, 0,
        0, 2, 0,

         -2, 2, 1, -1, 2, 1,

        -1, 1, 2, 0, 1, 2,
        -1, 2, 2, 0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"spark8 (p8)"},
#endif
	{
        0, -1, -2, 1, -1, -2,
        -1, 0, -2,
        -1, 1, -2,

         -2, -2, -1, -1, -2, -1, 0, -2, -1,
         -2, -1, -1,
         -2, 0, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0,

         -1, -1, 1, 0, -1, 1,
         -1, 0, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"necklace (p8)"},
#endif
	{
         -1, -2, -3,
         -2, -1, -3, -1, -1, -3,

        0, -1, -2,
        -1, 0, -2,

         -1, -2, -1,
         -2, -1, -1,

        0, -1, 0,
        -1, 0, 0,

         -1, -2, 1,
         -2, -1, 1,

        -1, -1, 2,

         -1, -2, 3, 0, -2, 3,
         -2, -1, 3, 0, -1, 3,
         -2, 0, 3, -1, 0, 3,

        0, -1, 4, 1, -1, 4,
        -1, 0, 4,
        -1, 1, 4,
        127
	},
#ifdef LIFE_NAMES
	{"exploding box (p10)"},
#endif
	{
        1, 0, -2,
        0, 1, -2,

         0, -1, -1,
         -1, 0, -1, 1, 0, -1,
         0, 1, -1,

        1, 0, 0,
        0, 1, 0,

         0, -1, 1,
         -1, 0, 1, 1, 0, 1,
         0, 1, 1,

        1, 0, 2,
        0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"dangle (p10)"},
#endif
	{
        0, -1, -5,

        0, 0, -4, 1, 0, -4,

        0, -1, -3,

        1, 0, -2,

        -1, 0, -1, 0, 0, -1,

        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

         -1, 0, 1, 0, 0, 1,

        -1, 0, 2,

        -1, -1, 3,

        -1, 0, 4, 0, 0, 4,

        -1, -1, 5,
        127
	},
#ifdef LIFE_NAMES
	{"Lq (p10)"},
#endif
	{
         0, -1, -3,
         0, 0, -3,

        1, -1, -2,
        1, 0, -2,
        1, 1, -2,

         -1, 0, -1,
         -1, 1, -1,

        1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0,

         0, -2, 1,
         0, -1, 1,

        -1, -1, 2,
        -1, 0, 2,
        -1, 1, 2,

         -1, -1, 3,
         -1, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"small skism (p16)"},
#endif
	{
        1, 0, -2,
        0, 1, -2, 1, 1, -2,
        0, 2, -2, 1, 2, -2,

         1, 0, -1,
         -1, 1, -1, 1, 1, -1,
         -1, 2, -1,

         0, -1, 1,
         -2, 0, 1, 0, 0, 1,
         -2, 1, 1,

        -1, 0, 2, 0, 0, 2,
        -1, 1, 2, 0, 1, 2,
        -1, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"skism (p20)"},
#endif
	{
         -2, 0, -5, -1, 0, -5, 0, 0, -5,

        -1, 0, -4, 0, 0, -4,

         0, -3, -3,
         -1, 0, -3,

        0, -2, -2,
        0, 0, -2,

         0, -3, -1,
         0, -2, -1,
         2, -1, -1,
         1, 0, -1, 2, 0, -1,
         2, 1, -1,
         -1, 2, -1,

        0, -2, 0,
        -2, -1, 0, 0, -1, 0,
        -2, 0, 0, -1, 0, 0, 1, 0, 0, 2, 0, 0,
        0, 1, 0, 2, 1, 0,
        0, 2, 0,

         0, -3, 1,
         -3, -2, 1,
         -3, -1, 1, -2, -1, 1,
         -3, 0, 1,
         -1, 1, 1,
         -1, 2, 1,

        0, 0, 2,
        0, 2, 2,

         0, -1, 3,
         -1, 2, 3,

        0, 0, 4, 1, 0, 4,

         -1, -1, 5, 0, -1, 5, 1, -1, 5,
        127
	},
};

static char patterns_14B45S56[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"ball (p10)"},
#endif
	{
         -1, -2, -3,

        0, -2, -2,
        1, -1, -2,
        -1, 0, -2, 0, 0, -2,

         -2, -2, -1,
         -1, -1, -1, 1, -1, -1,
         0, 0, -1,

        -1, -2, 0, 1, -2, 0,

         0, -3, 1,
         -1, -2, 1,
         -2, -1, 1, 0, -1, 1,
         -1, 0, 1,

        -1, -2, 2,
        1, -1, 2,
        1, 0, 2,

         0, -2, 3,
         -1, -1, 3,
        127
	},
};

static char patterns_14B46S34[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"gear"},
#endif
	{
         -1, -1, -1, 0, -1, -1,
         -1, 0, -1,

        0, 0, 0,

         -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"lift"},
#endif
	{
         0, -1, -1,

        1, -2, 0,
        1, -1, 0,
        -1, 0, 0, 0, 0, 0,

         0, -2, 1,
         -1, -1, 1,

        1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"share"},
#endif
	{
        0, -1, -2,
        1, 0, -2,

         -1, -2, -1, 0, -2, -1,
         -1, -1, -1, 1, -1, -1,
         0, 0, -1, 1, 0, -1,

        1, -1, 0,
        0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"hook"},
#endif
	{
         -1, -1, -3, 0, -1, -3,

        0, -1, -2,
        0, 0, -2, 1, 0, -2,

         1, -1, -1,

        1, -1, 0,

         0, -1, 1, 1, -1, 1,

        1, -1, 2,
        1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"crystal"},
#endif
	{
         0, 0, -3,

        0, 0, -2, 1, 0, -2,
        0, 1, -2, 1, 1, -2,

         0, -1, -1,
         -1, 0, -1, 1, 0, -1,
         0, 1, -1,

         0, -1, 1,
         -1, 0, 1, 1, 0, 1,
         0, 1, 1,

        0, 0, 2, 1, 0, 2,
        0, 1, 2, 1, 1, 2,

         0, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"capacitor (p3)"},
#endif
	{
        -1, 1, -2, 0, 1, -2,

         -1, 0, -1,
         0, 1, -1,

        -1, 1, 0,
        1, 2, 0,

         -1, 1, 1,
         0, 2, 1,

        0, 2, 2, 1, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"jiggle (p4)"},
#endif
	{
         -1, -1, -3,

        0, -1, -2,
        0, 0, -2,

         -1, -1, -1,

        0, -1, 0,

         -1, -1, 1,

        0, -1, 2,
        0, 0, 2,

         -1, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"reel mower (p4)"},
#endif
	{
         0, -1, -1,
         -2, 1, -1, 0, 1, -1,

         0, -1, 1,
         1, 0, 1,
         -2, 1, 1,
         -1, 2, 1,

        0, 0, 2, 1, 0, 2,
        -1, 1, 2, 0, 1, 2, 1, 1, 2,
        -1, 2, 2, 0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"donut (p4)"},
#endif
	{
        0, -1, -2,
        -1, 0, -2, 0, 0, -2,

         -1, 0, -1, 0, 0, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

         -1, -1, 1, 0, -1, 1,

        0, 0, 2, 1, 0, 2,
        0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"kiss (p5)"},
#endif
	{
         -1, -2, -3,

        -1, -2, -2, 0, -2, -2,
        -1, -1, -2,

         -1, -3, -1,
         -2, -2, -1,

        -1, -2, 0,
        1, 0, 0,

         1, -1, 1,
         0, 0, 1,

        1, -1, 2,
        0, 0, 2, 1, 0, 2,

         0, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"exploding crates (p7)"},
#endif
	{
         -2, 0, -5, 0, 0, -5,
         -2, 1, -5, 0, 1, -5,

        -2, 1, -4, 0, 1, -4, 1, 1, -4,

        -2, 0, -3, 0, 0, -3,
         -2, 1, -3,

        -1, -2, -2,

        -2, -3, -1, -1, -3, -1,
         -1, -2, -1,

        -1, -2, 0,

        1, -1, 1, 2, -1, 1,
         1, 1, 1, 2, 1, 1,

        2, -1, 2,
        2, 0, 2,
        2, 2, 2,

         -2, -3, 3, -1, -3, 3,
         -2, -2, 3, -1, -2, 3,
         2, -1, 3,
         1, 1, 3, 2, 1, 3,

        -1, -2, 4,
        127
	},
#ifdef LIFE_NAMES
	{"hoola hoop (p8)"},
#endif
	{
         -2, 1, -1, -1, 1, -1,
         -2, 2, -1, -1, 2, -1,

        0, 1, 0,
        0, 2, 0,

         -2, 2, 1, -1, 2, 1,

        -1, 1, 2, 0, 1, 2,
        -1, 2, 2, 0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"arrow (p8)"},
#endif
	{
        0, 1, -2,

         0, 0, -1,
         -1, 1, -1,

        1, 0, 0,
        -1, 1, 0,
        0, 2, 0,

         0, 0, 1,
         -1, 1, 1,

        0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"fungus (p8)"},
#endif
	{
        1, 0, -2,

         0, -1, -1, 1, -1, -1,
         0, 0, -1,

        1, -1, 0,
        0, 0, 0, 1, 0, 0,
        1, 1, 0,

         1, -1, 1,
         0, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"planet (p8)"},
#endif
	{
        -1, 1, -2, 0, 1, -2,
        0, 2, -2,

         0, 0, -1,

        -1, 0, 0, 0, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,

         -1, 0, 1, 0, 0, 1,
         -1, 1, 1, 0, 1, 1,

        0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"shuttle (p20)"},
#endif
	{
        -1, -2, -2,
        -1, -1, -2,
        -1, 0, -2, 0, 0, -2, 1, 0, -2,

         -1, -1, -1,

        -1, -2, 0,
        1, 0, 0,

         -1, -2, 1,
         0, -1, 1,

        -1, -2, 2, 0, -2, 2, 1, -2, 2,
        1, -1, 2,
        1, 0, 2,
        127
	},
};

static char patterns_18B4S45[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"helicopter"},
#endif
	{
        1, -1, -1,
        1, 1, -1,

        0, 0, 0, 1, 0, 0, 2, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"couch"},
#endif
	{
        -2, 0, -1, 1, 0, -1,
        0, -1, -1, -1, -1, -1,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twisty"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        0, -2, -1,
        1, -1, -1,
        0, 1, -1, -1, 1, -1,

        0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"ball"},
#endif
	{
        1, 1, -1,

        1, 0, 0, 2, 0, 0,
        0, 1, 0, 1, 1, 0,
        0, 2, 0,

        1, -1, 1,
        0, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"death star"},
#endif
	{
        0, 0, -2,

        0, -1, -1,
        -1, 0, -1,
        0, 1, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        1, 1, 0,
        0, 2, 0,

        -1, 0, 1, 1, 0, 1,
        0, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"well (p3)"},
#endif
	{
        -1, -3, -2, 0, -3, -2,
        -2, -2, -2, 1, -2, -2,
        -3, -1, -2, 2, -1, -2,
        -3, 0, -2, 2, 0, -2,
        -2, 1, -2, 1, 1, -2,
        -1, 2, -2, 0, 2, -2,

        -1, -3, -1, 0, -3, -1,
        -3, -1, -1, 2, -1, -1,
        -3, 0, -1, 2, 0, -1,
        -1, 2, -1, 0, 2, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -3, 1, 0, -3, 1,
        -2, -2, 1, 1, -2, 1,
        -3, -1, 1, 2, -1, 1,
        -3, 0, 1, 2, 0, 1,
        -2, 1, 1, 1, 1, 1,
        -1, 2, 1, 0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"karate (p4)"},
#endif
	{
        0, -1, -3,

        0, -1, -2,

        -1, -2, -1, 1, -2, -1,
        1, -1, -1,
        -1, 0, -1, 0, 0, -1,

        1, -1, 0,
        0, 0, 0, 1, 0, 0,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"corner (p4)"},
#endif
	{
        0, 1, -2,

        2, -1, -1,
        1, 0, -1, 2, 0, -1,
        0, 1, -1,
        -1, 2, -1,

        1, -2, 0,
        1, -1, 0,
        -1, 1, 0,
        -1, 2, 0,

        -2, 0, 1, -1, 0, 1,
        0, -1, 1,

        -1, -1, 2, 0, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"s (p6)"},
#endif
	{
        -1, -2, -2,
        0, -1, -2,

        -1, -3, -1, 0, -3, -1, 1, -3, -1,
        -1, -2, -1,
        0, -1, -1,
        -2, 0, -1, -1, 0, -1, 0, 0, -1,

        0, -3, 0,
        -1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"c4x (p6)"},
#endif
	{
        0, -2, -2,

        -1, -4, -1, 1, -4, -1,
        -2, -3, -1, -1, -3, -1, 1, -3, -1, 2, -3, -1,
        0, -2, -1,
        -2, -1, -1, -1, -1, -1, 1, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -1, -4, 0, 0, -4, 0, 1, -4, 0,
        -2, -3, 0, 2, -3, 0,
        -2, -2, 0, 2, -2, 0,
        -2, -1, 0, 2, -1, 0,
        -1, 0, 0, 0, 0, 0, 1, 0, 0,

        0, -2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"Hogwart stairway (p8)"},
#endif
	{
        1, -2, -1,
        0, -1, -1,
        -1, 0, -1,
        -2, 1, -1,

        1, -2, 0,
        0, -1, 0,
        -1, 0, 0,
        -2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"X (p38)"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 0, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,
        127
	},
};

static char patterns__18B4S36[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"toggle"},
#endif
	{
        -1, 0, -1,
        0, 1, -1,

        -1, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"hex"},
#endif
	{
        0, -1, -1,
        -1, 0, -1,

        -1, -1, 0,
        1, 1, 0,

        1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"alternate"},
#endif
	{
        0, -1, -1,
        0, 1, -1,

        -1, -1, 0,
        1, 1, 0,

        0, -1, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"link"},
#endif
	{
        0, -1, -1,
        0, 1, -1,

        -1, -1, 0,
        1, 1, 0,

        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pass through"},
#endif
	{
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -1, -1, 0, 1, -1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"less than greater than"},
#endif
	{
        -1, -2, -1,
        0, -1, -1,
        1, 0, -1,
        0, 1, -1,
        -1, 2, -1,

        1, -2, 1,
        0, -1, 1,
        -1, 0, 1,
        0, 1, 1,
        1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"snowflake"},
#endif
	{
        1, 1, -2,

        2, -1, -1,
        1, 0, -1,
        0, 1, -1,
        -1, 2, -1,

        1, -1, 0,
        -1, 1, 0,

        1, -2, 1,
        0, -1, 1,
        -1, 0, 1,
        -2, 1, 1,

        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"2 triangles"},
#endif
	{
        -1, -2, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        0, 0, 0,

        -1, -2, 1, 1, -2, 1,
        0, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"hula hoop (p4)"},
#endif
	{
        0, -1, -1,
        -1, 0, -1,

        -1, -1, 0,
        -1, 1, 0, 1, 1, 0,

        1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"step through (p4)"},
#endif
	{
        0, -3, -1,
        1, -2, -1,
        0, -1, -1,
        1, 0, -1,
        0, 1, -1,

        -1, -1, 0,

        0, -3, 1,
        -1, -2, 1,
        -1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"toaster (p4)"},
#endif
	{
        -1, -1, -2,
        2, 0, -2,
        0, 2, -2,

        1, -2, -1,
        1, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        1, 2, -1,

        -1, -1, 0,
        2, 0, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"shift (p4)"},
#endif
	{
        -3, -2, -1, 1, -2, -1,
        -1, 0, -1, 3, 0, -1,

        -2, -2, 0, 2, -2, 0,
        -2, 0, 0, 2, 0, 0,

        -1, -2, 1, 3, -2, 1,
        -3, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"stir (p4)"},
#endif
	{
        -2, -2, -2,
        2, 2, -2,

        -2, -3, -1,
        -3, -2, -1, -1, -2, -1,
        -1, 0, -1, 1, 0, -1,
        1, 2, -1, 3, 2, -1,
        2, 3, -1,

        1, -1, 0,
        0, 0, 0,
        -1, 1, 0,

        0, -1, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"toaster2 (p4)"},
#endif
	{
        -2, 0, -2,
        0, 2, -2,

         -3, 0, -1,
         -2, 1, -1,
         -1, 2, -1,
         0, 3, -1,

        -2, -2, 0,
        -1, -1, 0,
        -2, 0, 0,
        1, 1, 0,
        0, 2, 0, 2, 2, 0,

         -2, 1, 1,
         -1, 2, 1,

        0, 0, 2,
        -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"pinwheel (p4)"},
#endif
	{
        0, -2, -2,
        -1, -1, -2, 1, -1, -2,
        -2, 0, -2, 2, 0, -2,
        -1, 1, -2, 1, 1, -2,
        0, 2, -2,

        -1, -2, 1,
        0, -1, 1, 2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1,
        1, 2, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"chain (p4)"},
#endif
	{
        -5, 0, -1, 5, 0, -1,

        0, -2, 0,
        -6, 0, 0, -2, 0, 0, 2, 0, 0, 6, 0, 0,
        -5, 1, 0, 5, 1, 0,

        -2, -1, 1, 2, -1, 1,
        -5, 0, 1, -3, 0, 1, 3, 0, 1, 5, 0, 1,

        -1, -1, 2, 1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"eye (p4)"},
#endif
	{
        0, -3, -3,
        1, -2, -3,
        2, -1, -3,
        -3, 0, -3,
        0, 1, -3,

        -3, 1, -2,
        1, 3, -2,

        1, 0, -1, 3, 0, -1,
        0, 1, -1,
        -3, 2, -1,
        2, 3, -1,

        -3, -3, 0, 1, -3, 0,
        1, -1, 0,
        0, 0, 0,
        -1, 1, 0,
        -1, 3, 0, 3, 3, 0,

        -2, -3, 1,
        3, -2, 1,
        0, -1, 1,
        -3, 0, 1, -1, 0, 1,

        -1, -3, 2,
        3, -1, 2,

        0, -1, 3,
        3, 0, 3,
        -2, 1, 3,
        -1, 2, 3,
        0, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"3 loops (p4)"},
#endif
	{
        4, -1, -5,
        3, 0, -5, 5, 0, -5,

        2, 0, -4,
        5, 1, -4,

        5, 0, -3,
        2, 1, -3,

        1, -1, -2, 3, -1, -2,
        4, 0, -2,

        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -2, 3, -1,
        -5, 4, -1,

        1, -1, 0,
        -4, 2, 0,
        -5, 3, 0,
        -2, 4, 0,
        -5, 5, 0, -3, 5, 0,

        -1, -2, 1,
        -1, 0, 1,
        -3, 2, 1, -1, 2, 1,
        -4, 5, 1,

        0, -4, 2,
        1, -3, 2,
        1, -1, 2,

        0, -5, 3,
        -1, -2, 3,

        -1, -5, 4,
        0, -2, 4,

        0, -5, 5,
        1, -4, 5,
        0, -3, 5,
        127
	},
#ifdef LIFE_NAMES
	{"clock (p6)"},
#endif
	{
        0, -2, -2,
        1, -1, -2,

        1, -2, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"tetrahedron (p6)"},
#endif
	{
        0, 0, -2,
        -1, 1, -2,

        0, -1, -1,
        1, 0, -1,
        -2, 1, -1,
        -1, 2, -1,

        -1, -1, 0,
        -2, 0, 0,
        1, 1, 0,
        0, 2, 0,

        -1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"ring (p8)"},
#endif
	{
        -2, 0, -2, 2, 0, -2,

        -2, -1, -1, 2, -1, -1,
        0, 1, -1,

        0, -2, 0,
        -2, 0, 0, 2, 0, 0,

        -2, -1, 1, 2, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"mint (p8)"},
#endif
	{
        -2, -3, -1,
        -1, -2, -1,
        -2, -1, -1,
        1, 0, -1,
        0, 1, -1, 2, 1, -1,

        -3, -2, 1, -1, -2, 1,
        -2, -1, 1,
        1, 0, 1,
        0, 1, 1,
        1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"vortex (p8)"},
#endif
	{
        -1, -2, -3,
        2, -1, -3,
        -2, 1, -3,
        1, 2, -3,

        0, 0, -2,

        0, -3, -1,
        0, -1, -1,
        -3, 0, -1, -1, 0, -1, 1, 0, -1, 3, 0, -1,
        0, 1, -1,
        0, 3, -1,

        0, 0, 0,

        0, -3, 1,
        0, -1, 1,
        -3, 0, 1, -1, 0, 1, 1, 0, 1, 3, 0, 1,
        0, 1, 1,
        0, 3, 1,

        0, 0, 2,

        -1, -2, 3,
        2, -1, 3,
        -2, 1, 3,
        1, 2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"puffer (p10)"},
#endif
	{
       1, -2, -3,
        -2, -1, -3,
        2, 1, -3,
        -1, 2, -3,

        -1, -3, -2,
        3, -1, -2,
        -3, 1, -2,
        1, 3, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        1, -3, 0,
        -3, -1, 0,
        3, 1, 0,
        -1, 3, 0,

        -1, -2, 1,
        2, -1, 1,
        -2, 1, 1,
        1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spiral (p12)"},
#endif
	{
        3, -4, -1,
        -4, -3, -1,
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,
        4, 3, -1,
        -3, 4, -1,

        0, -4, 0, 2, -4, 0,
        -1, -3, 0,
        -4, -2, 0,
        3, -1, 0,
        -4, 0, 0, 4, 0, 0,
        -3, 1, 0,
        4, 2, 0,
        1, 3, 0,
        -2, 4, 0, 0, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"spider (p12)"},
#endif
	{
        0, 0, -2,

        -1, -4, -1, 1, -4, -1,
        -4, -1, -1, 0, -1, -1, 4, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -4, 1, -1, 0, 1, -1, 4, 1, -1,
        -1, 4, -1, 1, 4, -1,

        0, -2, 0,
        -2, 0, 0, 2, 0, 0,
        0, 2, 0,

        0, -3, 1,
        0, -1, 1,
        -3, 0, 1, -1, 0, 1, 1, 0, 1, 3, 0, 1,
        0, 1, 1,
        0, 3, 1,
        127
	},
};

static char patterns__18B4S45[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"donut"},
#endif
	{
        -1, 0, -1,
        0, 1, -1,

        -1, -1, 0,
        1, 1, 0,

        0, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"snowflake (p4)"},
#endif
	{
        2, 0, -2,
        0, 2, -2,

        1, 0, -1,
        0, 1, -1,

        2, -2, 0,
        1, -1, 0,
        -1, 1, 0,
        -2, 2, 0,

        0, -1, 1,
        -1, 0, 1,

        0, -2, 2,
        -2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"cone (p4)"},
#endif
	{
        0, -1, -3,
        -1, 0, -3, 1, 0, -3,
        0, 1, -3,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,

        -1, -1, 2, 1, -1, 2,
        0, 0, 2,
        -1, 1, 2, 1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"butter (p6)"},
#endif
	{
        -3, -1, -2, 3, -1, -2,
        -2, 0, -2, 0, 0, -2, 2, 0, -2,

        -3, 0, -1, 3, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,

        -3, 1, 0, 3, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"jellyfish (p12)"},
#endif
	{
        0, 1, -3,

        -1, -1, -2, 1, -1, -2,
        -2, 0, -2, 2, 0, -2,

        -1, -2, -1, 1, -2, -1,
        -1, 0, -1, 1, 0, -1,

        -1, -1, 0, 1, -1, 0,
        127
	},
/*too big 48 pts */
/*
#ifdef LIFE_NAMES
	{"16 pieces (p22)"},
#endif
	{
        -1, -5, -6, 1, -5, -6,
        -1, 3, -6, 1, 3, -6,

        -2, -5, -5, 0, -5, -5, 2, -5, -5,
        -2, 3, -5, 0, 3, -5, 2, 3, -5,

        -1, -5, -4, 1, -5, -4,
        -5, -3, -4, 5, -3, -4,
        -6, -2, -4, -4, -2, -4, 4, -2, -4, 6, -2, -4,
        -5, -1, -4, 5, -1, -4,
        -6, 0, -4, -4, 0, -4, 4, 0, -4, 6, 0, -4,
        -5, 1, -4, 5, 1, -4,
        -1, 3, -4, 1, 3, -4,

        -4, -6, -2, 4, -6, -2,
        -4, 4, -2, 4, 4, -2,

        -4, -7, -1, 4, -7, -1,
        -4, -5, -1, 4, -5, -1,
        -4, 3, -1, 4, 3, -1,
        -4, 5, -1, 4, 5, -1,

        -4, -6, 0, 4, -6, 0,
        -4, 4, 0, 4, 4, 0,

        -4, -7, 1, 4, -7, 1,
        -4, -5, 1, 4, -5, 1,
        -4, 3, 1, 4, 3, 1,
        -4, 5, 1, 4, 5, 1,

        -4, -6, 2, 4, -6, 2,
        -4, 4, 2, 4, 4, 2,

        -1, -5, 4, 1, -5, 4,
        -5, -3, 4, 5, -3, 4,
        -6, -2, 4, -4, -2, 4, 4, -2, 4, 6, -2, 4,
        -5, -1, 4, 5, -1, 4,
        -6, 0, 4, -4, 0, 4, 4, 0, 4, 6, 0, 4,
        -5, 1, 4, 5, 1, 4,
        -1, 3, 4, 1, 3, 4,

        -2, -5, 5, 0, -5, 5, 2, -5, 5,
        -2, 3, 5, 0, 3, 5, 2, 3, 5,

        -1, -5, 6, 1, -5, 6,
        -1, 3, 6, 1, 3, 6,
        127
	},*/
#ifdef LIFE_NAMES
	{"fifty (p50)"},
#endif
	{
        -1, -1, 0, 1, -1, 0,
        0, 0, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 2, 1, 1,
        127
	},
};

static char patterns__18B4S456[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"donut"},
#endif
	{
        -1, 0, -1,
        0, 1, -1,

        -1, -1, 0,
        1, 1, 0,

        0, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"collection plate (p5)"},
#endif
	{
        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        -2, -2, 0, 2, -2, 0,
        -3, -1, 0, 3, -1, 0,
        -3, 1, 0, 3, 1, 0,
        -2, 2, 0, 2, 2, 0,

        -3, -2, 1, -1, -2, 1, 1, -2, 1, 3, -2, 1,
        0, -1, 1,
        -3, 0, 1, 3, 0, 1,
        0, 1, 1,
        -3, 2, 1, -1, 2, 1, 1, 2, 1, 3, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"collection plate2 (p5)"},
#endif
	{
        -2, -3, -1, 0, -3, -1, 2, -3, -1,
        -2, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 2, 1, -1,
        -2, 3, -1, 0, 3, -1, 2, 3, -1,

        -1, -3, 0, 1, -3, 0,
        -2, -2, 0, 2, -2, 0,
        -2, 2, 0, 2, 2, 0,
        -1, 3, 0, 1, 3, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -2, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"blossom (p7)"},
#endif
	{
        -3, -3, -2, 3, -3, -2,
        -2, -2, -2, 2, -2, -2,
        -2, 2, -2, 2, 2, -2,
        -3, 3, -2, 3, 3, -2,

         0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,

        -1, -2, 1, 1, -2, 1,
         -2, -1, 1, 0, -1, 1, 2, -1, 1,
         -1, 0, 1, 1, 0, 1,
         -2, 1, 1, 0, 1, 1, 2, 1, 1,
         -1, 2, 1, 1, 2, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"E flipper (p8)"},
#endif
	{
        0, -2, -2,
        -1, -1, -2,
        2, 0, -2,
        -1, 1, -2, 1, 1, -2,

        -1, -2, -1,
         -2, -1, -1,
         2, 1, -1,
         1, 2, -1,

        2, -2, 0,

        -1, -2, 1, 1, -2, 1,
         2, -1, 1,
         2, 1, 1,

        1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"flame thrower (p32)"},
#endif
	{
        0, -1, -1,
        0, 1, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,

        0, -1, 1,
        -3, 0, 1, 3, 0, 1,
        0, 1, 1,
        127
	},
};

static char patterns__18B4S46[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"tri"},
#endif
	{
        -1, 0, -1,

        -1, 1, 0, 1, 1, 0,

        0, -1, 1,
        -1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"prop"},
#endif
	{
        0, -1, -1,
        0, 1, -1,

         1, -1, 0,
         0, 0, 0,
         -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"2 triangles"},
#endif
	{
        -1, -2, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        0, 0, 0,

        -1, -2, 1, 1, -2, 1,
        0, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spiral"},
#endif
	{
        -2, -2, -2, 2, -2, -2,
        0, 0, -2,
        -2, 2, -2, 2, 2, -2,

        0, -3, -1,
        -3, 0, -1, 3, 0, -1,
        0, 3, -1,

        1, -3, 0,
        -3, -1, 0, -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0, 3, 1, 0,
        -1, 3, 0,

        -2, -3, 1,
        3, -2, 1,
        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        -3, 2, 1,
        2, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"locomotive (p4)"},
#endif
	{
        -2, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -2, 0, 0, 0, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"SS (p4)"},
#endif
	{
        0, 0, -2,

        1, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1, 2, 1, -1,
        -1, 2, -1,

        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"volley (p4)"},
#endif
	{
        0, -3, -1,
        0, 3, -1,

        0, -4, 0,
        -1, -3, 0, 1, -3, 0,
        -1, 3, 0, 1, 3, 0,
        0, 4, 0,

        0, -3, 1,
        0, -1, 1,
        0, 1, 1,
        0, 3, 1,

        0, -2, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"volley2 (p4)"},
#endif
	{
        2, -3, -1,
        -2, 3, -1,

        2, -4, 0,
         3, -3, 0,
         0, -2, 0, 2, -2, 0,
         1, -1, 0,
         -1, 1, 0,
         -2, 2, 0, 0, 2, 0,
         -3, 3, 0,
         -2, 4, 0,

        2, -3, 1,
        -2, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"blow up (p4)"},
#endif
	{
        -1, -3, -2, 1, -3, -2,

        -1, -2, -1, 1, -2, -1,
        0, 1, -1,
        -1, 2, -1, 1, 2, -1,

        -1, -3, 0, 1, -3, 0,
        0, -2, 0,
        -1, 1, 0, 1, 1, 0,

        -1, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spiral flip (p4)"},
#endif
	{
        0, 0, -2,

        1, -2, -1,
        -2, -1, -1,
        2, 1, -1,
        -1, 2, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,

        -1, -1, 2, 1, -1, 2,
        0, 0, 2,
        -1, 1, 2, 1, 1, 2,

        0, -1, 3,
        -1, 0, 3, 1, 0, 3,
        0, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"clip (p4)"},
#endif
	{
        -2, -2, -2,
        0, 0, -2,
        2, 2, -2,

        -2, -3, -1,
        -3, -2, -1, 1, -2, -1,
        2, -1, -1,
        -2, 1, -1,
        -1, 2, -1, 3, 2, -1,
        2, 3, -1,

        -1, -3, 0,
        -3, -1, 0,
        3, 1, 0,
        1, 3, 0,

        -1, -2, 1,
        -2, -1, 1, 0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 2, 1, 1,
        1, 2, 1,

        0, 0, 2,
        127
	},
/*too big 48 pts */
/*#ifdef LIFE_NAMES
	{"octahedron (p5)"},
#endif
	{
        0, -2, -4,
        -1, -1, -4, 1, -1, -4,
        0, 0, -4,

        -1, -2, -3, 1, -2, -3,
        -1, 0, -3, 1, 0, -3,

        0, -4, -2,
        -1, -3, -2, 1, -3, -2,
        -2, -2, -2, 2, -2, -2,
        -3, -1, -2, 3, -1, -2,
        -2, 0, -2, 2, 0, -2,
        -1, 1, -2, 1, 1, -2,
        0, 2, -2,

        -1, -4, -1, 1, -4, -1,
        -3, -2, -1, 3, -2, -1,
        -3, 0, -1, 3, 0, -1,
        -1, 2, -1, 1, 2, -1,

        0, -4, 0,
        -1, -3, 0, 1, -3, 0,
        -2, -2, 0, 2, -2, 0,
        -3, -1, 0, 3, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,

        -1, -2, 1, 1, -2, 1,
        -1, 0, 1, 1, 0, 1,

        0, -2, 2,
        -1, -1, 2, 1, -1, 2,
        0, 0, 2,
        127
	},*/
#ifdef LIFE_NAMES
	{"hula hoop (p6)"},
#endif
	{
        0, -2, -2,
        -2, 0, -2, 0, 0, -2,

        1, 0, -1,
        0, 1, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"2 sheets (p6)"},
#endif
	{
        0, -1, -3,
        -1, 0, -3, 1, 0, -3,
        0, 1, -3,

        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,

        0, -1, 3,
        -1, 0, 3, 1, 0, 3,
        0, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"crab (p6)"},
#endif
	{
        0, -1, -3,
        0, 1, -3,

        1, -1, -2,
        -2, 0, -2, 2, 0, -2,
        -1, 1, -2,

        0, -2, 0,
        1, -1, 0,
        -1, 1, 0,
        0, 2, 0,

        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pinch (p6)"},
#endif
	{
        -2, 0, -2, 0, 0, -2, 2, 0, -2,

        -1, -2, -1, 1, -2, -1,
        -1, 2, -1, 1, 2, -1,

        0, -2, 0,
        -2, 0, 0, 2, 0, 0,
        0, 2, 0,

        -2, -1, 1, 2, -1, 1,
        -2, 1, 1, 2, 1, 1,

        0, -2, 2,
        0, 0, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"lamp (p6)"},
#endif
	{
        0, 0, -2,

        -2, -3, -1, 2, -3, -1,
        -3, -2, -1, 3, -2, -1,
        -3, 2, -1, 3, 2, -1,
        -2, 3, -1, 2, 3, -1,

        -2, -2, 0, 2, -2, 0,
        -2, 2, 0, 2, 2, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -2, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"leaky roof (p6)"},
#endif
	{
        2, -2, -2,
        0, 0, -2,
        -2, 2, -2,

        2, -3, -1,
        -1, -2, -1, 1, -2, -1, 3, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, 2, 1, -1,
        -3, 2, -1, -1, 2, -1, 1, 2, -1,
        -2, 3, -1,

        1, -3, 0,
        3, -1, 0,
        -3, 1, 0,
        -1, 3, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,

        2, -2, 2,
        -1, -1, 2,
        1, 1, 2,
        -2, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"ring (p6)"},
#endif
	{
        3, 0, -5, 5, 0, -5,
        1, 2, -5,
        2, 3, -5,
        0, 5, -5,

        4, 0, -4,
        3, 1, -4,
        -1, 3, -4,
        0, 4, -4,

        5, -2, -3,
        4, 1, -3,
        -1, 4, -3,
        0, 5, -3,

        5, -1, -2,
        -3, 5, -2,

        3, -4, -1,
        4, -3, -1,
        -2, 5, -1,

        5, -5, 0,
        4, -4, 0,
        5, -3, 0,
        -5, 3, 0,
        -4, 4, 0,
        -5, 5, 0,

        2, -5, 1,
        -4, 3, 1,
        -3, 4, 1,

        3, -5, 2,
        -5, 1, 2,

        0, -5, 3,
        1, -4, 3,
        -4, -1, 3,
        -5, 2, 3,

        0, -4, 4,
        1, -3, 4,
        -3, -1, 4,
        -4, 0, 4,

        0, -5, 5,
        -2, -3, 5,
        -1, -2, 5,
        -5, 0, 5, -3, 0, 5,
        127
	},
#ifdef LIFE_NAMES
	{"touche (p8)"},
#endif
	{
        2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1,

        1, -3, 0,
        1, -1, 0,
        0, 0, 0,
        -1, 1, 0,
        -1, 3, 0,

        1, -2, 1,
        0, -1, 1,
        0, 1, 1,
        -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"sliced bread (p8)"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -3, -1, 0, -1, -1, 0, 1, -1, 0, 3, -1, 0,
        -3, 1, 0, -1, 1, 0, 1, 1, 0, 3, 1, 0,

        -3, 0, 1, -1, 0, 1, 1, 0, 1, 3, 0, 1,

        -2, 0, 2, 2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"divided square (p8)"},
#endif
	{

        0, -2, -2,
        0, 0, -2,
        0, 2, -2,

        0, -1, -1,
        0, 1, -1,

        -3, -3, -0, 3, -3, 0,
        0, -2, 0,
        0, 2, 0,
        -3, 3, 0, 3, 3, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -3, 0, 1, 3, 0, 1,
        -2, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"mitosis (p8)"},
#endif
	{
        -2, -2, -2, 2, -2, -2,
        -2, 0, -2, 2, 0, -2,
        -2, 2, -2, 2, 2, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -3, 0, -1, 3, 0, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        0, -2, 0,
        0, 2, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -3, 0, 1, 3, 0, 1,
        -2, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,

        -2, -2, 2, 2, -2, 2,
        -2, 0, 2, 2, 0, 2,
        -2, 2, 2, 2, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"stablizers (p10)"},
#endif
	{
        0, -1, -1,
        -5, 0, -1, -1, 0, -1, 1, 0, -1, 5, 0, -1,
        0, 1, -1,

        -5, -1, 0, 5, -1, 0,
        -4, 0, 0, 4, 0, 0,
        -5, 1, 0, 5, 1, 0,

        0, -1, 1,
        -5, 0, 1, -1, 0, 1, 1, 0, 1, 5, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"burr (p10)"},
#endif
	{
        0, -2, -4,
        -2, 0, -4,

        0, -3, -3,
        0, -1, -3,
        -3, 0, -3,

        -2, 0, -2, 0, 0, -2,

        -2, -3, -1,
        -3, -2, -1, -1, -2, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        1, 2, -1, 3, 2, -1,
        2, 3, -1,

        0, 0, 0, 2, 0, 0,

        3, 0, 1,
        0, 1, 1,
        0, 3, 1,

        2, 0, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"cats cradle (p12)"},
#endif
	{
        -2, -2, -2, 2, -2, -2,
        -2, 2, -2, 2, 2, -2,

        -2, -3, -1, 2, -3, -1,
        -1, -2, -1, 1, -2, -1,
        -1, 2, -1, 1, 2, -1,
        -2, 3, -1, 2, 3, -1,

        -2, -2, 0, 0, -2, 0, 2, -2, 0,
        -2, 2, 0, 0, 2, 0, 2, 2, 0,

        -2, -3, 1, 2, -3, 1,
        -1, -2, 1, 1, -2, 1,
        -1, 2, 1, 1, 2, 1,
        -2, 3, 1, 2, 3, 1,

        -2, -2, 2, 2, -2, 2,
        -2, 2, 2, 2, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"X star (p15)"},
#endif
	{
        0, -3, -3,
        -3, 0, -3, 3, 0, -3,
        0, 3, -3,

        -3, -3, -2, 3, -3, -2,
        0, -2, -2,
        -1, -1, -2, 1, -1, -2,
        -2, 0, -2, 0, 0, -2, 2, 0, -2,
        -1, 1, -2, 1, 1, -2,
        0, 2, -2,
        -3, 3, -2, 3, 3, -2,

        -3, -3, 0, 3, -3, 0,
        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 0, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,
        -3, 3, 0, 3, 3, 0,

        0, -3, 1,
        -3, 0, 1, 3, 0, 1,
        0, 3, 1,
        127
	},
};

static char patterns_20B4S45[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"window"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -1, 1, -1, 0, 1, -1,
        -1, -1, 0, 0, -1, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"stargate"},
#endif
	{
        0, 0, -4,

        0, 0, -3,

        -2, 0, -2, 0, 0, -2, 2, 0, -2,

        -4, 0, 0, -3, 0, 0, -2, 0, 0, 2, 0, 0, 3, 0, 0, 4, 0, 0,

        -2, 0, 2, 0, 0, 2, 2, 0, 2,

        0, 0, 3,

        0, 0, 4,
        127
	},
#ifdef LIFE_NAMES
	{"rock and window"},
#endif
	{
        -1, -1, -3, 0, -1, -3,
        -1, 0, -3, 0, 0, -3,

        0, -2, -1,
        1, -1, -1,
        1, 0, -1,

        -1, -2, -1,
        -2, -1, -1,
        -2, 0, -1,
        -1, 1, -1, 0, 1, -1,
        127
	},
#ifdef LIFE_NAMES
	{"crossroads"},
#endif
	{
        0, -6, -1,
        -2, -5, -1, 0, -5, -1, 2, -5, -1,
        -2, -4, -1, 0, -4, -1, 2, -4, -1,
        -4, -3, -1, -3, -3, -1, 3, -3, -1, 4, -3, -1,
        -5, -1, -1, -4, -1, -1, -3, -1, -1, 3, -1, -1, 4, -1, -1, 5, -1, -1,
        -4, 1, -1, -3, 1, -1, 3, 1, -1, 4, 1, -1,
        -2, 2, -1, 0, 2, -1, 2, 2, -1,
        -2, 3, -1, 0, 3, -1, 2, 3, -1,
        0, 4, -1,
        127
	},
#ifdef LIFE_NAMES
	{"alternator"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -1, 1, -2, 0, 1, -2,

        -1, -3, -1, 0, -3, -1,
        -2, -2, -1, 1, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -2, 1, -1, 1, 1, -1,
        -1, 2, -1, 0, 2, -1,

        -1, -3, 0, 0, -3, 0,
        -2, -2, 0, 1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -2, 1, 0, 1, 1, 0,
        -1, 2, 0, 0, 2, 0,

        -1, -2, 1, 0, -2, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"exploding wheel (p3)"},
#endif
	{
        0, 0, -3,

        0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        0, 2, -2,

        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, -2, 1,
        -2, 0, 1, 2, 0, 1,
        0, 2, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"worm mouth (p3)"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -1, -1, -2,

        -1, -3, -1, 0, -3, -1,
        -2, -2, -1,
        -2, -1, -1, 1, -1, -1,
        0, 0, -1,

        -1, -3, 0,
        -2, -2, 0, 1, -2, 0,
        -1, 0, 0, 1, 0, 0,

        0, -2, 1,
        -1, -1, 1, 1, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"flipping triangles (p4)"},
#endif
	{
        -1, -1, -1, 0, -1, -1, 1, -1, -1,
        -1, 0, -1, 0, 0, -1,
        -1, 1, -1,

        -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -1, 0, 1, 0, 0, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"shuttle (p4)"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1,
        -2, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        2, 0, 0,
        -1, 1, 0, 2, 1, 0,
        0, 2, 0, 1, 2, 0,

        0, -1, 1,
        -1, 0, 1, 2, 0, 1,
        2, 1, 1,
        0, 2, 1, 1, 2, 1,

        0, 0, 2, 1, 0, 2,
        0, 1, 2, 1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"eating table (p6)"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -1, -2, -1, 0, -2, -1,
        -3, -1, -1, 2, -1, -1,
        -1, 0, -1, 0, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -3, -1, 0, -2, -1, 0, 1, -1, 0, 2, -1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"ghost (p6)"},
#endif
	{
        -1, -2, -4, 1, -2, -4,

        0, -4, -3,
        1, -3, -3,
        -2, -2, -3, 2, -2, -3,
        -1, -1, -3,
        0, 0, -3,

        0, -5, -2,
        1, -4, -2,
        2, -3, -2,
        -2, -1, -2,
        -1, 0, -2,
        0, 1, -2,

        -2, -4, -1, 2, -4, -1,
        -3, -3, -1, 3, -3, -1,
        -3, -1, -1, 3, -1, -1,
        -2, 0, -1, 2, 0, -1,

        0, -5, 0,
        -1, -4, 0,
        -2, -3, 0,
        2, -1, 0,
        1, 0, 0,
        0, 1, 0,

        0, -4, 1,
        -1, -3, 1,
        -2, -2, 1, 2, -2, 1,
        1, -1, 1,
        0, 0, 1,

        -1, -2, 2, 1, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"pair (p7)"},
#endif
	{
        -2, -3, -4, -1, -3, -4,
        -2, -2, -4,

        -2, -4, -3, -1, -4, -3,
        -3, -3, -3, -1, -3, -3,
        -3, -2, -3, -2, -2, -3,

        -2, -4, -2,
        -3, -3, -2, -2, -3, -2,

        2, 1, 0, 3, 1, 0,
        2, 2, 0,

        2, 0, 1, 3, 0, 1,
        1, 1, 1, 3, 1, 1,
        1, 2, 1, 2, 2, 1,

        2, 0, 2,
        1, 1, 2, 2, 1, 2,
        127
	},
};

static char patterns_22B4S3[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"comet (p3)"},
#endif
	{
        1, -1, -1,
        -1, 1, -1,

        -3, -3, 1,
        -3, -1, 1, 3, -1, 1,
        -3, 1, 1,

        -1, -3, 3,
        1, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"alien chew (p3)"},
#endif
	{
        -1, -1, -5,
        -1, 1, -5, 1, 1, -5,

        -1, 3, -3,

        -1, -5, -1, 1, -5, -1,
        3, -3, -1,
        -5, -1, -1,

        1, -5, 1,
        -5, -1, 1,
        -5, 1, 1,

        -3, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"pump (p4)"},
#endif
	{
        1, -3, -3,
        -3, -1, -3, 1, -1, -3,
        -3, 1, -3,

        -3, -1, -1, 1, -1, -1,

        -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"jumble (p4)"},
#endif
	{
        1, -1, -1,
        1, 1, -1,

        -1, -3, 1,
        -3, -1, 1, 3, -1, 1,

        -1, -3, 3,
        -1, 1, 3, 1, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"blinker interference (p4)"},
#endif
	{
        1, 1, -3,

        1, -1, -1,
        1, 1, -1,

        1, -1, 1,

        -3, -1, 5, -1, -1, 5,
        -1, 1, 5, 1, 1, 5,
        127
	},
#ifdef LIFE_NAMES
	{"u (p4)"},
#endif
	{
        -3, -3, -3, -1, -3, -3,
        1, -1, -3,
        3, 1, -3,
        3, 3, -3,

        -3, -3, -1, -1, -3, -1,
        1, -1, -1,
        3, 1, -1,
        3, 3, -1,
        127
	},
#ifdef LIFE_NAMES
	{"E (p4)"},
#endif
	{
        -1, 1, -5, 1, 1, -5,
        -1, 3, -5, 1, 3, -5,

        1, -1, -3,

        -1, -3, -1, 1, -3, -1,
        -1, 1, -1,

        -1, -3, 1, 1, -3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"lag (p4)"},
#endif
	{
        -3, -3, -3, -1, -3, -3,
        -3, -1, -3,
        -1, 1, -3, 3, 1, -3,
        1, 3, -3, 3, 3, -3,

        -3, -3, -1,
        1, -1, -1,
        3, 3, -1,
        127
	},
#ifdef LIFE_NAMES
	{"invert (p4)"},
#endif
	{
        -1, -1, -3, 1, -1, -3,
        -1, 1, -3, 1, 1, -3,

        -1, -3, -1, 1, -3, -1,
        -3, -1, -1, 3, -1, -1,
        -3, 1, -1, 3, 1, -1,
        -1, 3, -1, 1, 3, -1,
        127
	},
#ifdef LIFE_NAMES
	{"balance (p4)"},
#endif
	{
        1, 1, -7,

        -1, -1, -5,
        -1, 1, -5,
        1, 3, -5,

        -1, -3, -3,
        -1, 3, -3,

        1, -3, -1,
        1, 3, -1,

        -1, -3, 1,
        1, -1, 1,
        1, 1, 1,

        -1, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"big jumble (p4)"},
#endif
	{
        -3, -5, -7,
        -3, -3, -7,

        -1, -7, -5,
        -5, -5, -5,
        -5, -3, -5, -1, -3, -5,

        -3, -5, -3,
        -3, -1, -3,

        1, 1, -1,
        1, 5, -1,

        -1, -1, 1,
        3, 1, 1,
        -1, 3, 1, 3, 3, 1,

        1, 1, 3,
        1, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"ring (p4)"},
#endif
	{
        -1, -5, -3, 3, -5, -3,
        -5, -3, -3,
        5, -1, -3,
        -5, 1, -3,
        5, 3, -3,
        -3, 5, -3, 1, 5, -3,

        -1, -5, -1,
        -1, -3, -1,
        3, -1, -1, 5, -1, -1,
        -5, 1, -1, -3, 1, -1,
        1, 3, -1,
        1, 5, -1,
        127
	},
#ifdef LIFE_NAMES
	{"4L (p4)"},
#endif
	{
        -1, -5, -3,
        -1, -3, -3,
        3, -1, -3, 5, -1, -3,
        -5, 1, -3, -3, 1, -3,
        1, 3, -3,
        1, 5, -3,

        3, -5, -1,
        -5, -3, -1, -3, -3, -1, 3, -3, -1,
        -3, 3, -1, 3, 3, -1, 5, 3, -1,
        -3, 5, -1,
        127
	},
#ifdef LIFE_NAMES
	{"cats cradle (p4)"},
#endif
	{
        -1, -3, -3, 1, -3, -3,
        -1, 3, -3, 1, 3, -3,

        -3, -3, -1, -1, -3, -1, 1, -3, -1, 3, -3, -1,
        -1, -1, -1, 1, -1, -1,
        -1, 1, -1, 1, 1, -1,
        -3, 3, -1, -1, 3, -1, 1, 3, -1, 3, 3, -1,
        127
	},
#ifdef LIFE_NAMES
	{"star with stabilizer (p4)"},
#endif
	{
        1, -5, -7,
        -1, -3, -7, 1, -3, -7,
        -1, -1, -7,

        1, 1, -3,

        -1, -3, -1, 1, -3, -1,
        1, 3, -1,

        -1, -3, 1,
        -1, 3, 1, 1, 3, 1,

        -1, -1, 3,

        1, 1, 7,
        -1, 3, 7, 1, 3, 7,
        -1, 5, 7,
        127
	},
#ifdef LIFE_NAMES
	{"star with stabilizer2 (p4)"},
#endif
	{
        1, -1, -3,

        -1, -7, -1, 1, -7, -1,
        1, -5, -1,
        -3, -1, -1,
        -3, 1, -1, 3, 1, -1,
        -1, 7, -1,

        1, -7, 1,
        -3, -1, 1, 3, -1, 1,
        3, 1, 1,
        -1, 5, 1,
        -1, 7, 1, 1, 7, 1,

        -1, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"star people (p4)"},
#endif
	{
        -1, -1, -7,
        1, 1, -7,

        1, -3, -5,
        3, -1, -5,
        -3, 1, -5,
        -1, 3, -5,

        -1, -3, -1,
        -3, -1, -1,
        3, 1, -1,
        1, 3, -1,

        -1, -3, 1,
        -3, -1, 1,
        3, 1, 1,
        1, 3, 1,

        1, -3, 5,
        3, -1, 5,
        -3, 1, 5,
        -1, 3, 5,

        -1, -1, 7,
        1, 1, 7,
        127
	},
#ifdef LIFE_NAMES
	{"6L (p4)"},
#endif
	{
        3, -1, -7,
        -3, 3, -7, 1, 3, -7, 3, 3, -7,

        3, -5, -5,
        5, -3, -5,
        5, -1, -5,
        5, 3, -5,
        -3, 5, -5, 1, 5, -5,

        -5, 3, -3,
        -3, 5, -3,

        3, -5, -1,
        5, -3, -1,

        -1, -5, 1, 3, -5, 1,
        -5, -3, 1,
        -5, 1, 1,
        -5, 3, 1,
        -3, 5, 1,

        -3, -3, 3, -1, -3, 3, 3, -3, 3,
        -3, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"nova (p4)"},
#endif
	{
        -3, -5, -3,
        5, -3, -3,
        -5, 3, -3,
        3, 5, -3,

        -1, -7, -1,
        3, -5, -1,
        -5, -3, -1,
        7, -1, -1,
        -7, 1, -1,
        5, 3, -1,
        -3, 5, -1,
        1, 7, -1,

        3, -5, 1,
        -5, -3, 1, -1, -3, 1, 1, -3, 1,
        -3, -1, 1, 3, -1, 1,
        -3, 1, 1, 3, 1, 1,
        -1, 3, 1, 1, 3, 1, 5, 3, 1,
        -3, 5, 1,
        127
	},
#ifdef LIFE_NAMES
	{"big ring (p4)"},
#endif
	{
        3, -1, -7, 5, -1, -7,
        -3, 3, -7,
        1, 5, -7,

        3, -5, -5,
        3, -1, -5,
        1, 3, -5, 5, 3, -5,
        1, 5, -5,

        -5, 3, -3, -3, 3, -3,
        -5, 5, -3,

        5, -5, -1,
        3, -3, -1, 5, -3, -1,

        -1, -5, 1,
        -5, -3, 1, -1, -3, 1,
        -3, 1, 1,
        -3, 5, 1,

        -1, -5, 3,
        3, -3, 3,
        -5, 1, 3, -3, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"toaster (p4)"},
#endif
	{
        -1, -5, -3,
        -1, -3, -3, 1, -3, -3, 3, -3, -3,
        -5, -1, -3, -3, -1, -3, 3, -1, -3,
        -3, 1, -3, 3, 1, -3, 5, 1, -3,
        -3, 3, -3, -1, 3, -3, 1, 3, -3,
        1, 5, -3,

        1, -5, -1, 3, -5, -1,
        5, -3, -1,
        5, -1, -1,
        -5, 1, -1,
        -5, 3, -1,
        -3, 5, -1, -1, 5, -1,

        -1, -1, 3,
        1, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"capacitor (p4)"},
#endif
	{
        -1, -1, -7, 1, -1, -7,
        -1, 1, -7, 1, 1, -7,

        -1, -3, -5, 1, -3, -5,
        -3, -1, -5, 3, -1, -5,
        -3, 1, -5, 3, 1, -5,
        -1, 3, -5, 1, 3, -5,

        -1, -3, 1,
        3, -1, 1,
        -3, 1, 1,
        1, 3, 1,

        -1, -1, 5, 1, -1, 5,
        -1, 1, 5, 1, 1, 5,

        -1, -3, 7, 1, -3, 7,
        -3, -1, 7, 3, -1, 7,
        -3, 1, 7, 3, 1, 7,
        -1, 3, 7, 1, 3, 7,
        127
	},
#ifdef LIFE_NAMES
	{"teeth (p6)"},
#endif
	{
        3, -1, -3,
        1, 1, -3,

        3, 1, -1,
        1, 3, -1,

        -1, -3, 1,
        -3, -1, 1,

        -1, -1, 3,
        -3, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"ring (p6)"},
#endif
	{
        5, -1, -9,
        3, 3, -9,
        -1, 5, -9,

        5, -3, -7,
        7, 1, -7,
        3, 3, -7,
        3, 5, -7,
        1, 7, -7,

        5, -3, -5, 7, -3, -5,
        -5, 5, -5, -3, 5, -5,
        -3, 7, -5,

        5, -7, -3,
        -7, 5, -3,

        7, -5, -1,
        -5, 7, -1,

        3, -7, 1,
        3, -5, 1, 5, -5, 1,
        -7, 3, 1, -5, 3, 1,

        -1, -7, 3,
        -3, -5, 3,
        -3, -3, 3,
        -7, -1, 3,
        -5, 3, 3,

        1, -5, 5,
        -3, -3, 5,
        -5, 1, 5,
        127
	},
#ifdef LIFE_NAMES
	{"8 (p8)"},
#endif
	{
        -3, -3, -1, 3, -3, -1,
        -5, -1, -1, -1, -1, -1, 1, -1, -1, 5, -1, -1,
        -3, 1, -1, 3, 1, -1,
        127
	},
#ifdef LIFE_NAMES
	{"cats cradle (p8)"},
#endif
	{
        1, -1, -5,
        -1, 1, -5,

        -1, -5, -1,
        -5, -1, -1,
        5, 1, -1,
        1, 5, -1,

        -1, -5, 1, 1, -5, 1,
        -5, -1, 1, 5, -1, 1,
        -5, 1, 1, 5, 1, 1,
        -1, 5, 1, 1, 5, 1,

        1, -3, 3,
        3, -1, 3,
        -3, 1, 3,
        -1, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"arrowhead (p10)"},
#endif
	{
        -3, -1, -3, 1, -1, -3,

        -1, -3, -1,
        -3, -1, -1, 1, -1, -1,
        -1, 1, -1,

        -1, -3, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"dumbbell (p18)"},
#endif
	{
        -5, -7, -1, 5, -7, -1,
        -1, -5, -1, 1, -5, -1,
        -1, 5, -1, 1, 5, -1,
        -5, 7, -1, 5, 7, -1,

        -5, -7, 1, 5, -7, 1,
        -1, -5, 1, 1, -5, 1,
        -1, 5, 1, 1, 5, 1,
        -5, 7, 1, 5, 7, 1,
        127
	},
};

static char patterns_22B4S4[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"double star tail glider (c/2, p8)"},
#endif
	{
        -1, -1, -5, 1, -1, -5,
        -1, 1, -5, 1, 1, -5,

        -1, -1, -3, 1, -1, -3,
        -1, 1, -3, 1, 1, -3,

        -1, -3, 1, 1, -3, 1,
        -1, 3, 1, 1, 3, 1,

        -1, -7, 3, 1, -7, 3,
        -1, -5, 3, 1, -5, 3,
        -1, 5, 3, 1, 5, 3,
        -1, 7, 3, 1, 7, 3,
        127
	},
#ifdef LIFE_NAMES
	{"jumble (p3)"},
#endif
	{
        -3, -3, -3,
        -3, -1, -3,

        -3, -5, -1,
        -3, -3, -1,
        -1, -1, -1,
        -1, 1, -1,

        1, 1, 1,
        -1, 3, 1, 1, 3, 1,
        -1, 5, 1,
        127
	},
#ifdef LIFE_NAMES
	{"stretch (p3)"},
#endif
	{
        -3, -5, -1,
        -5, -3, -1, -1, -3, -1,
        -3, -1, -1, 1, -1, -1,
        -1, 1, -1, 3, 1, -1,
        1, 3, -1, 5, 3, -1,
        3, 5, -1,

        -3, -3, 1,
        3, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"popup (p3)"},
#endif
	{
       -1, -3, -5,
        -3, -1, -5,
        3, 1, -5,
        1, 3, -5,

        -1, -5, -3, 1, -5, -3,
        3, -3, -3,
        -5, -1, -3, 5, -1, -3,
        -5, 1, -3, 5, 1, -3,
        -3, 3, -3,
        -1, 5, -3, 1, 5, -3,

        -1, -1, 1, 1, -1, 1,
        -1, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"3D (p3)"},
#endif
	{
        -3, -1, -5, 3, -1, -5,
        -3, 1, -5, 3, 1, -5,

        -3, -3, -3, -1, -3, -3, 1, -3, -3, 3, -3, -3,
        -3, 3, -3, -1, 3, -3, 1, 3, -3, 3, 3, -3,

        -3, -3, -1, -1, -3, -1, 1, -3, -1, 3, -3, -1,
        -3, 3, -1, -1, 3, -1, 1, 3, -1, 3, 3, -1,

        -3, -1, 1, 3, -1, 1,
        -3, 1, 1, 3, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spin (p4)"},
#endif
	{
        -3, -1, -1, 3, -1, -1,

        -1, -3, 1, 1, -3, 1,
        -1, -1, 1, 1, -1, 1,
        -1, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"invert (p4)"},
#endif
	{
        -1, -1, -3,
        -3, 1, -3, 1, 1, -3,
        -1, 3, -3,

        -1, -3, -1,
        -5, 1, -1,

        -3, -3, 1, 1, -3, 1,
        -5, -1, 1,
        -5, 3, 1,

        -1, -3, 3,
        -5, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"butterfly (p4)"},
#endif
	{
        -3, -3, -1,
        1, -1, -1,
        -5, 1, -1,
        3, 3, -1,
        -1, 5, -1,

        -3, -1, 1, 1, -1, 1,
        -3, 1, 1,
        -1, 3, 1, 1, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"merry-go-round (p4)"},
#endif
	{
        -5, -3, -3, -3, -3, -3,
        3, -1, -3,
        -3, 1, -3,
        3, 3, -3, 5, 3, -3,

        -1, -5, -1,
        -1, -3, -1,
        3, -1, -1,
        -3, 1, -1,
        1, 3, -1,
        1, 5, -1,
        127
	},
#ifdef LIFE_NAMES
	{"ring (p4)"},
#endif
	{
        -1, -5, -3, 3, -5, -3,
        -5, -3, -3,
        5, -1, -3,
        -5, 1, -3,
        5, 3, -3,
        -3, 5, -3, 1, 5, -3,

        -1, -5, -1,
        -1, -3, -1,
        3, -1, -1, 5, -1, -1,
        -5, 1, -1, -3, 1, -1,
        1, 3, -1,
        1, 5, -1,
        127
	},
#ifdef LIFE_NAMES
	{"4L (p4)"},
#endif
	{
        -1, -5, -3,
        -1, -3, -3,
        3, -1, -3, 5, -1, -3,
        -5, 1, -3, -3, 1, -3,
        1, 3, -3,
        1, 5, -3,

        3, -5, -1,
        -5, -3, -1, -3, -3, -1, 3, -3, -1,
        -3, 3, -1, 3, 3, -1, 5, 3, -1,
        -3, 5, -1,
        127
	},
#ifdef LIFE_NAMES
	{"pillory (p4)"},
#endif
	{
        -1, 5, -7, 1, 5, -7,

         -3, 3, -5, 3, 3, -5,
        -1, 5, -5, 1, 5, -5,

         -1, 5, -3, 1, 5, -3,

         -3, -5, 3, 3, -5, 3,

         -1, -7, 5, 1, -7, 5,
        -1, -5, 5, 1, -5, 5,
        -1, -3, 5, 1, -3, 5,
        127
	},
#ifdef LIFE_NAMES
	{"pillory (p4)"},
#endif
	{
        -3, -3, -1, -1, -3, -1, 3, -3, -1,
        -3, -1, -1,
        3, 1, -1,
        -3, 3, -1, 1, 3, -1, 3, 3, -1,

        -1, -3, 1, 3, -3, 1,
        -3, -1, 1,
        3, 1, 1,
        -3, 3, 1, 1, 3, 1,

        -3, -3, 3,
        3, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"row boat (p4)"},
#endif
	{
        1, -5, -1, 5, -5, -1,
        -3, -3, -1,
        5, -1, -1,
        -5, 1, -1,
        3, 3, -1,
        -5, 5, -1, -1, 5, -1,

        -3, -3, 1, 1, -3, 1, 3, -3, 1,
        3, -1, 1,
        -3, 1, 1,
        -3, 3, 1, -1, 3, 1, 3, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"row boat2 (p4)"},
#endif
	{
        -1, -5, -1, 3, -5, -1,
        1, -3, -1, 5, -3, -1,
        -5, -1, -1, 3, -1, -1,
        -3, 1, -1, 5, 1, -1,
        -5, 3, -1, -1, 3, -1,
        -3, 5, -1, 1, 5, -1,

        -1, -5, 1,
        -5, -1, 1,
        5, 1, 1,
        1, 5, 1,
        127
	},
#ifdef LIFE_NAMES
	{"star with stabilizers (p4)"},
#endif
	{
        1, -1, -3,

        -1, -3, -1,
        7, -1, -1,
        -7, 1, -1, -5, 1, -1, 5, 1, -1,
        -1, 3, -1, 1, 3, -1,

        -1, -3, 1, 1, -3, 1,
        -5, -1, 1, 5, -1, 1, 7, -1, 1,
        -7, 1, 1,
        1, 3, 1,

        -1, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"armadillo (p4)"},
#endif
	{
        -1, -7, -1,
        -5, -5, -1,
        -7, -1, -1,
        7, 1, -1,
        5, 5, -1,
        1, 7, -1,

        -1, -7, 1,
        -5, -5, 1, 3, -5, 1,
        1, -3, 1, 5, -3, 1,
        -7, -1, 1, 3, -1, 1,
        -3, 1, 1, 7, 1, 1,
        -5, 3, 1, -1, 3, 1,
        -3, 5, 1, 5, 5, 1,
        1, 7, 1,
        127
	},
#ifdef LIFE_NAMES
	{"cats cradle (p4)"},
#endif
	{
        -1, -7, -1,
        -5, -5, -1,
        1, -3, -1,
        -7, -1, -1, 3, -1, -1,
        -3, 1, -1, 7, 1, -1,
        -1, 3, -1,
        5, 5, -1,
        1, 7, -1,

        -1, -7, 1,
        -5, -5, 1,
        1, -3, 1,
        -7, -1, 1, 3, -1, 1,
        -3, 1, 1, 7, 1, 1,
        -1, 3, 1,
        5, 5, 1,
        1, 7, 1,
        127
	},
#ifdef LIFE_NAMES
	{"cats cradle2 (p4)"},
#endif
	{
       -1, -5, -1, 3, -5, -1, 5, -5, -1,
        5, -3, -1,
        -5, -1, -1,
        5, 1, -1,
        -5, 3, -1,
        -5, 5, -1, -3, 5, -1, 1, 5, -1,

        -1, -5, 1, 3, -5, 1,
        5, -3, 1,
        -5, -1, 1,
        5, 1, 1,
        -5, 3, 1,
        -3, 5, 1, 1, 5, 1,

        5, -5, 3,
        -5, 5, 3,
        127
	},
#ifdef LIFE_NAMES
	{"popup (p4)"},
#endif
	{
        1, -5, -3,
        -1, -1, -3, 1, -1, -3, 5, -1, -3,
        -5, 1, -3, -1, 1, -3, 1, 1, -3,
        -1, 5, -3,

        5, -9, -1,
        5, -7, -1,
        1, -5, -1, 7, -5, -1, 9, -5, -1,
        5, -1, -1,
        -5, 1, -1,
        -9, 5, -1, -7, 5, -1, -1, 5, -1,
        -5, 7, -1,
        -5, 9, -1,
        127
	},
#ifdef LIFE_NAMES
	{"saddle (p4)"},
#endif
	{
        3, -5, -5,
        1, -3, -5, 5, -3, -5,
        3, -1, -5,
        -3, 1, -5,
        -5, 3, -5, -1, 3, -5,
        -3, 5, -5,

        -1, -7, -3,
        -1, -5, -3,
        -7, -1, -3, -5, -1, -3,
        5, 1, -3, 7, 1, -3,
        1, 5, -3,
        1, 7, -3,

        -5, -5, -1,
        5, 5, -1,

        -5, -5, 1,
        5, 5, 1,
        127
	},
#ifdef LIFE_NAMES
	{"circular saw (p4)"},
#endif
	{
        3, -3, -7,
        3, 1, -7,
        -1, 3, -7, 3, 3, -7,

        5, -3, -5,
        5, 1, -5,
        -5, 3, -5,
        -3, 5, -5, -1, 5, -5, 3, 5, -5,

        3, -5, -3,
        5, -3, -3,

        -5, 3, -1,
        -3, 5, -1,

        -3, -5, 1, 1, -5, 1, 3, -5, 1,
        5, -3, 1,
        -5, -1, 1,
        -5, 3, 1,

        -3, -3, 3, 1, -3, 3,
        -3, -1, 3,
        -3, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"star blinker (p4)"},
#endif
	{
        -1, -1, -9, 1, -1, -9,
        -1, 1, -9, 1, 1, -9,

        -1, -1, -5, 1, -1, -5,
        -1, 1, -5, 1, 1, -5,

        -1, -1, -3, 1, -1, -3,
        -1, 1, -3, 1, 1, -3,

        -3, -3, -1, 3, -3, -1,
        -3, 3, -1, 3, 3, -1,

        -1, -1, 1, 1, -1, 1,
        -1, 1, 1, 1, 1, 1,

        -1, -1, 5, 1, -1, 5,
        -1, 1, 5, 1, 1, 5,
        127
	},
#ifdef LIFE_NAMES
	{"big ring (p4)"},
#endif
	{
        3, -1, -7, 5, -1, -7,
        -3, 3, -7, 1, 3, -7,
        1, 5, -7,

        3, -5, -5,
        5, -1, -5,
        5, 3, -5,
        1, 5, -5,

        -5, 3, -3,
        -5, 5, -3, -3, 5, -3,

        3, -5, -1, 5, -5, -1,
        5, -3, -1,

        -1, -5, 1,
        -5, -3, 1,
        -5, 1, 1,
        -3, 5, 1,

        -1, -5, 3,
        -1, -3, 3, 3, -3, 3,
        -5, 1, 3, -3, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"square (p4)"},
#endif
	{
        -1, -7, -1,
        -3, -5, -1, 1, -5, -1, 3, -5, -1,
        -5, -3, -1, 5, -3, -1,
        -7, -1, -1, 5, -1, -1,
        -5, 1, -1, 7, 1, -1,
        -5, 3, -1, 5, 3, -1,
        -3, 5, -1, -1, 5, -1, 3, 5, -1,
        1, 7, -1,

        -1, -7, 1,
        -3, -5, 1,
        -5, -3, 1,
        -7, -1, 1,
        7, 1, 1,
        5, 3, 1,
        3, 5, 1,
        1, 7, 1,
        127
	},
#ifdef LIFE_NAMES
	{"square2 (p4)"},
#endif
	{
        -1, -7, -1,
        -3, -5, -1, 3, -5, -1,
        -5, -3, -1, 5, -3, -1,
        -7, -1, -1,
        7, 1, -1,
        -5, 3, -1, 5, 3, -1,
        -3, 5, -1, 3, 5, -1,
        1, 7, -1,

        -1, -7, 1,
        -3, -5, 1, 1, -5, 1,
        -5, -3, 1,
        -7, -1, 1, 5, -1, 1,
        -5, 1, 1, 7, 1, 1,
        5, 3, 1,
        -1, 5, 1, 3, 5, 1,
        1, 7, 1,
        127
	},
#ifdef LIFE_NAMES
	{"ant star (p4)"},
#endif
	{
        -5, -9, -1,
        -5, -7, -1, -1, -7, -1,
        -9, -5, -1, -7, -5, -1,
        1, -3, -1,
        -7, -1, -1, 3, -1, -1,
        -3, 1, -1, 7, 1, -1,
        -1, 3, -1,
        7, 5, -1, 9, 5, -1,
        1, 7, -1, 5, 7, -1,
        5, 9, -1,

        -1, -7, 1,
        1, -3, 1,
        -7, -1, 1, 3, -1, 1,
        -3, 1, 1, 7, 1, 1,
        -1, 3, 1,
        1, 7, 1,
        127
	},
#ifdef LIFE_NAMES
	{"popup2 (p4)"},
#endif
	{
        3, -3, -5,
        -3, 3, -5,

        -1, -7, -3, 1, -7, -3,
        3, -3, -3,
        -7, -1, -3, 7, -1, -3,
        -7, 1, -3, 7, 1, -3,
        -3, 3, -3,
        -1, 7, -3, 1, 7, -3,

        -1, -5, 1, 1, -5, 1,
        -5, -1, 1, 5, -1, 1,
        -5, 1, 1, 5, 1, 1,
        -1, 5, 1, 1, 5, 1,

        -1, -1, 3, 1, -1, 3,
        -1, 1, 3, 1, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"trifecta (p4)"},
#endif
	{
        3, -3, -7,
        3, -1, -7,

        3, -1, -5,
        3, 1, -5,

        5, -1, -3,
        5, 1, -3, 7, 1, -3,
        -7, 3, -3, -1, 3, -3, 1, 3, -3, 7, 3, -3,

        3, -3, -1,
        -7, 3, -1, -5, 3, -1,
        -3, 5, -1,

        3, -3, 1,
        -5, 3, 1,
        -3, 5, 1,
        -3, 7, 1,

        -3, -7, 3, -1, -7, 3,
        -1, -5, 3, 1, -5, 3,
        -3, -1, 3,
        -3, 1, 3,
        -3, 7, 3,

        -1, -3, 5, 1, -3, 5,

        1, -3, 7, 3, -3, 7,
        127
	},
#ifdef LIFE_NAMES
	{"big ring2 (p4)"},
#endif
	{
        -5, -5, -7, -3, -5, -7,
        -5, -3, -7, 3, -3, -7,
        3, 1, -7,
        -1, 3, -7, 3, 3, -7,

        -5, -5, -5,
        5, -3, -5,
        5, 1, -5,
        -5, 3, -5,
        -3, 5, -5, -1, 5, -5, 3, 5, -5,

        3, -5, -3,
        5, -3, -3,

        -5, 3, -1,
        -3, 5, -1,

        -3, -5, 1, 1, -5, 1, 3, -5, 1,
        5, -3, 1,
        -5, -1, 1,
        -5, 3, 1,
        5, 5, 1,

        -3, -3, 3, 1, -3, 3,
        -3, -1, 3,
        -3, 3, 3, 5, 3, 3,
        3, 5, 3, 5, 5, 3,
        127
	},
#ifdef LIFE_NAMES
	{"fall through (p4)"},
#endif
	{
        -1, -1, -7, 1, -1, -7,
        -1, 1, -7, 1, 1, -7,

        -1, -5, -5, 1, -5, -5,
        -5, -1, -5, 5, -1, -5,
        -5, 1, -5, 5, 1, -5,
        -1, 5, -5, 1, 5, -5,

        -1, -7, -1, 1, -7, -1,
        -7, -1, -1, 7, -1, -1,
        -7, 1, -1, 7, 1, -1,
        -1, 7, -1, 1, 7, -1,

        -1, -1, 1, 1, -1, 1,
        -1, 1, 1, 1, 1, 1,

        -1, -3, 3, 1, -3, 3,
        -3, -1, 3, 3, -1, 3,
        -3, 1, 3, 3, 1, 3,
        -1, 3, 3, 1, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"log (p6)"},
#endif
	{
        1, 1, -5,
        1, 3, -5,

        -1, 3, -3, 1, 3, -3,

        -1, -3, -1, 1, -3, -1,

        -1, -3, 1,
        -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2 ostriches (p6)"},
#endif
	{
        1, -1, -5, 3, -1, -5,
        1, 1, -5,

        3, 1, -3,

        -3, -1, -1,

        -1, -1, 1,
        -3, 1, 1, -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"arrow (p6)"},
#endif
	{
        3, -3, -3,
        3, -1, -3,
        -3, 1, -3,
        -1, 3, -3,

        1, -3, -1, 3, -3, -1,
        -3, 1, -1,
        -1, 3, -1,
        127
	},
#ifdef LIFE_NAMES
	{"ring (p6)"},
#endif
	{
        -1, 1, -3, 3, 1, -3,
        -1, 3, -3,

        1, -3, -1, 3, -3, -1,
        3, 1, -1,

        -3, -1, 1,
        -3, 3, 1, -1, 3, 1,

        1, -3, 3,
        -3, -1, 3, 1, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"4 toggles (p6)"},
#endif
	{
        1, -5, -1,
        -3, -3, -1, 3, -3, -1,
        5, -1, -1,
        -5, 1, -1,
        -3, 3, -1, 3, 3, -1,
        1, 5, -1,

        1, -5, 1,
        -3, -3, 1, 3, -3, 1,
        -5, -1, 1,
        5, 1, 1,
        -3, 3, 1, 3, 3, 1,
        -1, 5, 1,
        127
	},
#ifdef LIFE_NAMES
	{"toaster (p6)"},
#endif
	{
        -1, -3, -5,
        -3, -1, -5,
        3, 1, -5,
        1, 3, -5,

        -1, -5, -3, 1, -5, -3,
        3, -3, -3,
        -5, -1, -3, 5, -1, -3,
        -5, 1, -3, 5, 1, -3,
        -3, 3, -3,
        -1, 5, -3, 1, 5, -3,

        -1, -1, 1, 1, -1, 1,
        -1, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"fire (p6)"},
#endif
	{
        -3, -1, -7, 1, -1, -7,
        -3, 1, -7,

        -1, -5, -5, 1, -5, -5,
        1, -1, -5,

        -5, -3, -3,
        -5, 1, -3, -3, 1, -3,

        -1, -5, -1,
        -5, -3, -1, -1, -3, -1,
        3, 3, -1, 5, 3, -1,

        3, 1, 1,
        1, 3, 1,
        1, 5, 1,

        3, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"ant (p6)"},
#endif
	{
        -3, -5, -3,
        -5, -3, -3, 3, -3, -3,
        -3, 3, -3, 5, 3, -3,
        3, 5, -3,

        -3, -5, -1,
        -5, -3, -1, 3, -3, -1,
        -3, 3, -1, 5, 3, -1,
        3, 5, -1,

        -1, -3, 1,
        -3, -1, 1, -1, -1, 1, 1, -1, 1,
        -1, 1, 1, 1, 1, 1, 3, 1, 1,
        1, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"closing ring (p6)"},
#endif
	{
        1, -1, -7,
        -1, 3, -7,

        1, -3, -5,
        3, -1, -5,
        -3, 1, -5, 5, 1, -5,
        1, 3, -5,

        3, -5, -3,
        -5, 1, -3,
        -3, 3, -3, 3, 3, -3,
        1, 5, -3,

        -1, -5, -1,
        -3, -3, -1, 3, -3, -1,
        5, -1, -1,
        -3, 5, -1,

        -1, -3, 1,
        -5, -1, 1, 3, -1, 1,
        -3, 1, 1,
        -1, 3, 1,

        1, -3, 3,
        -1, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"big fire (p6)"},
#endif
	{
        -5, -3, -7,

        -3, -7, -5,
        -3, -5, -5,
        -5, -3, -5,

        -7, -5, -3, -5, -5, -3,
        1, -1, -3, 3, -1, -3,
        1, 3, -3,

        -3, 1, -1,
        -3, 3, -1, 1, 3, -1,

        -1, -3, 1, 3, -3, 1,
        3, -1, 1,

        -1, -3, 3,
        -3, 1, 3, -1, 1, 3,
        5, 5, 3, 7, 5, 3,

        5, 3, 5,
        3, 5, 5,
        3, 7, 5,

        5, 3, 7,
        127
	},
#ifdef LIFE_NAMES
	{"big ring (p6)"},
#endif
	{
        3, 1, -5,
        -1, 3, -5, 1, 3, -5, 3, 3, -5,

        5, -3, -3,
        5, -1, -3,
        5, 1, -3,
        -3, 5, -3, -1, 5, -3,

        3, -5, -1,
        5, -3, -1,
        -3, 5, -1,

        3, -5, 1,
        -5, 3, 1,
        -3, 5, 1,

        1, -5, 3, 3, -5, 3,
        -5, -1, 3,
        -5, 1, 3,
        -5, 3, 3,

        -3, -3, 5, -1, -3, 5, 1, -3, 5,
        -3, -1, 5,
        127
	},
#ifdef LIFE_NAMES
	{"3D (p6)"},
#endif
	{
        -3, -3, -5, -1, -3, -5, 1, -3, -5, 3, -3, -5,
        -3, -1, -5, -1, -1, -5, 1, -1, -5, 3, -1, -5,

        -3, -3, -1, -1, -3, -1, 1, -3, -1, 3, -3, -1,
        -3, -1, -1, -1, -1, -1, 1, -1, -1, 3, -1, -1,

        -3, -3, 1, -1, -3, 1, 1, -3, 1, 3, -3, 1,
        -3, -1, 1, -1, -1, 1, 1, -1, 1, 3, -1, 1,

        -3, -3, 5, -1, -3, 5, 1, -3, 5, 3, -3, 5,
        -3, -1, 5, -1, -1, 5, 1, -1, 5, 3, -1, 5,
        127
	},
#ifdef LIFE_NAMES
	{"donut (p8)"},
#endif
	{
        -3, -5, -1,
        -3, -3, -1, 3, -3, -1, 5, -3, -1,
        -5, 3, -1, -3, 3, -1, 3, 3, -1,
        3, 5, -1,

        3, -7, 1,
        1, -5, 1, 3, -5, 1,
        -7, -3, 1, -5, -3, 1, -3, -3, 1, 3, -3, 1,
        -5, -1, 1,
        5, 1, 1,
        -3, 3, 1, 3, 3, 1, 5, 3, 1, 7, 3, 1,
        -3, 5, 1, -1, 5, 1,
        -3, 7, 1,
        127
	},
#ifdef LIFE_NAMES
	{"conjure (p8)"},
#endif
	{
        -1, -11, -1, 1, -11, -1,
        -1, -9, -1, 1, -9, -1,
        -1, -7, -1, 1, -7, -1,
        -11, -1, -1, -9, -1, -1, -7, -1, -1, 7, -1, -1, 9, -1, -1, 11, -1, -1,
        -11, 1, -1, -9, 1, -1, -7, 1, -1, 7, 1, -1, 9, 1, -1, 11, 1, -1,
        -1, 7, -1, 1, 7, -1,
        -1, 9, -1, 1, 9, -1,
        -1, 11, -1, 1, 11, -1,

        -3, -9, 1, 3, -9, 1,
        -9, -3, 1, 9, -3, 1,
        -9, 3, 1, 9, 3, 1,
        -3, 9, 1, 3, 9, 1,

        -1, -1, 3, 1, -1, 3,
        -1, 1, 3, 1, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"catalyst (p13)"},
#endif
	{
        -5, -1, -1,
        -3, 1, -1,
        -1, 3, -1,
        1, 5, -1,

        3, -5, 1,
        5, -3, 1,
        -5, -1, 1,
        -3, 1, 1,
        -1, 3, 1,
        1, 5, 1,

        3, -5, 3, 5, -5, 3,
        5, -3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"shuttle (p34)"},
#endif
	{
        -3, -5, -1, 3, -5, -1,
        -5, -3, -1, -3, -3, -1, 3, -3, -1, 5, -3, -1,
        -5, 3, -1, -3, 3, -1, 3, 3, -1, 5, 3, -1,
        -3, 5, -1, 3, 5, -1,

        -1, -3, 1, 1, -3, 1,
        -3, -1, 1, 3, -1, 1,
        -3, 1, 1, 3, 1, 1,
        -1, 3, 1, 1, 3, 1,
        127
	},
};

static char patterns_22B4S57[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"star pedestal (p38)"},
#endif
	{
        -1, -1, -5, 1, -1, -5,
        -1, 1, -5, 1, 1, -5,

        -1, -1, -3, 1, -1, -3,
        -1, 1, -3, 1, 1, -3,

        -1, -1, 3, 1, -1, 3,
        -1, 1, 3, 1, 1, 3,
        127
	},
};

static char patterns_26B5S23[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"glider pair orthogonal (c/2, p4)"},
#endif
	{
        -2, -2, -3, 1, -2, -3,
        -2, 1, -3, 1, 1, -3,

        -1, -2, -2, 0, -2, -2,
        -2, -1, -2, 1, -1, -2,
        -2, 0, -2, 1, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -2, -2, 0, 1, -2, 0,
        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 0, 0, 0,
        -2, 1, 0, 1, 1, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -2, 0, 1, -1, 0, 1, 0, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"123 (p3)"},
#endif
	{
        -2, -2, -1,
        -1, -1, -1,

        -1, -1, 0,
        1, 1, 0,

        0, 0, 1, 1, 0, 1,
        1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"corner (p3)"},
#endif
	{
        -1, -2, -2, 1, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2,
        -1, 0, -2,
        -2, 1, -2,

        -2, -2, -1, -1, -2, -1, 0, -2, -1,
        -2, -1, -1, -2, 0, -1,

        -1, -2, 0,
        -2, -1, 0,

        -2, -2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"toaster (p4)"},
#endif
	{
        -1, -2, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,

        0, -2, 0,
        -2, -1, 0, 0, -1, 0, 1, -1, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twisty (p4)"},
#endif
	{
        -1, -1, 1, 0, -1, 1,
        0, 1, 1,
        0, 2, 1,

        0, -2, 0,
        0, 1, 0, 1, 1, 0,
        1, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"catch (p4)"},
#endif
	{
        -2, -2, -1, -1, -2, -1,
        -2, -1, -1,
        0, 0, -1,

        0, 0, 0, 1, 0, 0,
        0, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"v drum (p4)"},
#endif
	{
        -3, -3, -1, 1, -3, -1,
        2, -2, -1,
        2, 2, -1,

        -2, -3, 0, -1, -3, 0,
        -2, -2, 0, -1, -2, 0, 0, -2, 0,
        1, -1, 0,
        1, 0, 0, 2, 0, 0,
        1, 1, 0, 2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"change flow (p4)"},
#endif
	{
        1, -2, -2,
        1, -1, -2,
        -2, 0, -2,
        -2, 1, -2,

        1, -2, -1,
        1, -1, -1,
        -2, 0, -1,
        -2, 1, -1,

        -2, -2, 0,
        -1, -1, 0,
        0, 0, 0,
        1, 1, 0,

        -3, -3, 1,
        -2, -2, 1,
        1, 1, 1,
        2, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"cross drum (p4)"},
#endif
	{
        -1, -3, -1, 1, -3, -1,
        -2, -2, -1, 2, -2, -1,
        -2, 0, -1, 2, 0, -1,
        -1, 1, -1, 1, 1, -1,

        0, -2, 0,
        -1, -1, 0, 0, -1, 0, 1, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"invert (p4)"},
#endif
	{
        -1, -4, -1, 1, -4, -1,
        -2, -3, -1, 2, -3, -1,
        -2, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,

        0, -6, 0,
        -1, -5, 0, 1, -5, 0,
        -3, -3, 0, 3, -3, 0,
        -4, -2, 0, 4, -2, 0,
        -3, -1, 0, 3, -1, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"wave (p5)"},
#endif
	{
        -2, -2, -1, -1, -2, -1,
        -2, 1, -1, -1, 1, -1,

        0, -2, 0,
        -3, -1, 0, 1, -1, 0, 2, -1, 0,
        -3, 0, 0, 1, 0, 0, 2, 0, 0,
        0, 1, 0,

        0, -2, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"weld (p5)"},
#endif
	{
        3, -1, -1,
        2, 1, -1,
        0, 2, -1,

        2, -2, 0,
        2, -1, 0,
        2, 0, 0,
        -1, 1, 0, 0, 1, 0, 1, 1, 0,

        -3, -4, 1, -2, -4, 1,
        -3, -3, 1, -1, -3, 1,
        -2, -2, 1, -1, -2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"starfish (p5)"},
#endif
	{
        -3, -4, -4,
        -4, -3, -4,

        -4, -4, -3,
        -2, -2, -3,

        -2, -3, -2,
        -3, -2, -2, -1, -2, -2,
        -2, -1, -2,
        0, 0, -2,

        -2, -2, -1,
        1, -1, -1,
        -1, 1, -1,

        0, -2, 0,
        -2, 0, 0,
        1, 1, 0,

        -1, -1, 1,
        1, 0, 1,
        0, 1, 1, 2, 1, 1,
        1, 2, 1,

        1, 1, 2,
        3, 3, 2,

        3, 2, 3,
        2, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"tied down (p5)"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        2, -5, 0,
        1, -4, 0,
        -5, -3, 0, 0, -3, 0,
        -4, -2, 0,
        -3, -1, 0, -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 0, 0, 0, 2, 0, 0,
        3, 1, 0,
        -1, 2, 0, 4, 2, 0,
        -2, 3, 0,
        -3, 4, 0,

        2, -4, 1,
        -4, -3, 1,
        3, 2, 1,
        -3, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"tied down2 (p5)"},
#endif
	{
        -2, -5, -1,
        -1, -4, -1,
        3, -3, -1,
        -1, -2, -1, 0, -2, -1, 2, -2, -1,
        -3, -1, -1, -1, -1, -1, 0, -1, -1,
        -4, 0, -1,
        0, 1, -1,
        1, 2, -1,

        -3, -6, 0, -2, -6, 0,
        4, -4, 0,
        4, -3, 0,
        -5, 0, 0,
        -5, 1, 0,
        1, 3, 0, 2, 3, 0,

        -1, -2, 1, 0, -2, 1,
        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"lean forward (p6)"},
#endif
	{
        -1, -2, -2,
        -1, 1, -2,

        -1, -2, -1, 0, -2, -1,
        -1, 1, -1, 0, 1, -1,

        1, -2, 0,
        1, 1, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"yy (p6)"},
#endif
	{
        1, -4, -1,
        0, -3, -1, 1, -3, -1,
        -1, 1, -1, 0, 1, -1,
        -1, 2, -1,

        1, -5, 0,
        1, -4, 0,
        0, -3, 0, 1, -3, 0,
        1, -2, 0,
        -1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        -1, 2, 0,
        -1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"bird (p7)"},
#endif
	{
        -1, -2, -1,
        -2, -1, -1,
        -2, 0, -1,
        -2, 1, -1,
        -1, 2, -1,

        -1, -3, 0,
        -3, -1, 0,
        -3, 1, 0,
        -1, 3, 0,

        -1, -2, 1,
        -2, -1, 1,
        -2, 0, 1,
        -2, 1, 1,
        -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bird2 (p7)"},
#endif
	{
        -1, -2, -1, 1, -2, -1,
        -1, 2, -1, 1, 2, -1,

        0, -3, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 3, 0,

        0, -1, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"block mover (p8)"},
#endif
	{
        0, -2, -2,

        -1, -1, -1, 0, -1, -1, 1, -1, -1,

        1, 1, 0,

        0, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"block mover2 (p8)"},
#endif
	{
        1, -1, -1, 2, -1, -1,
        1, 0, -1,

        -2, -4, 0, -1, -4, 0,
        0, -3, 0,
        -1, -2, 0, 0, -2, 0,

        -2, -4, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double dutch (p8)"},
#endif
	{
        -2, -2, -1, -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -2, 0, -1, -1, 0, -1, 0, 0, -1, 1, 0, -1,

        -3, -1, 0, 2, -1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"jump rope (p8)"},
#endif
	{
        0, -2, -2,

        0, -3, 0,
        -2, -1, 0, 2, -1, 0,
        -1, 0, 0, 1, 0, 0,

        -1, -2, 1, 1, -2, 1,
        -1, -1, 1, 1, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"3 change (p8)"},
#endif
	{
        0, -2, -3,

        0, -3, -2,
        -1, -2, -2, 0, -2, -2,
        0, -1, -2,

        3, -4, 0,
        -3, -3, 0, 2, -3, 0,
        -4, -2, 0, -2, -2, 0,
        -3, -1, 0, 2, -1, 0,
        3, 0, 0,

        2, -4, 1,
        2, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"smile (p8)"},
#endif
	{
        1, -2, -1,
        2, -1, -1,
        1, 0, -1,
        -2, 1, -1, 0, 1, -1,
        -1, 2, -1,

        2, -3, 0,
        -3, 2, 0,

        2, -2, 1,
        1, -1, 1,
        1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        -2, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2 sextominoes (p10)"},
#endif
	{
        2, 0, -2,
        2, 1, -2,

        -1, -1, -1,
        1, 1, -1, 2, 1, -1,
        1, 2, -1,

        -1, -2, 0,
        -2, -1, 0, -1, -1, 0,
        1, 1, 0,

        -1, -2, 1, 0, -2, 1,
        127
	},
};

static char patterns_26B5S25[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"ship (c/2, p2)"},
#endif
	{
        -2, -4, -1, 2, -4, -1,
        -2, -3, -1, 2, -3, -1,
        -4, -2, -1, -3, -2, -1, 3, -2, -1, 4, -2, -1,
        -4, 2, -1, -3, 2, -1, 3, 2, -1, 4, 2, -1,
        -2, 3, -1, 2, 3, -1,
        -2, 4, -1, 2, 4, -1,

        -1, -4, 0, 1, -4, 0,
        -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -4, -1, 0, -2, -1, 0, 2, -1, 0, 4, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -4, 1, 0, -2, 1, 0, 2, 1, 0, 4, 1, 0,
        -1, 2, 0, 0, 2, 0, 1, 2, 0,
        -1, 4, 0, 1, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"bubble up (p3)"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -1, -1, -2, 0, -1, -2,

        -3, -4, -1, 2, -4, -1,
        -5, -2, -1, -1, -2, -1, 0, -2, -1, 4, -2, -1,
        -5, -1, -1, -1, -1, -1, 0, -1, -1, 4, -1, -1,
        -3, 1, -1, 2, 1, -1,

        -4, -3, 0, -2, -3, 0, 1, -3, 0, 3, -3, 0,
        -4, 0, 0, -2, 0, 0, 1, 0, 0, 3, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"bubble up2 (p3)"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 0, 0, -1,

        -1, -5, 0, 0, -5, 0,
        -2, -4, 0, 1, -4, 0,
        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 0, 0, 0,
        -2, 3, 0, 1, 3, 0,
        -1, 4, 0, 0, 4, 0,

        -3, -3, 1, 2, -3, 1,
        -2, -2, 1, 1, -2, 1,
        -2, 1, 1, 1, 1, 1,
        -3, 2, 1, 2, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"crate (p3)"},
#endif
	{
        -2, -3, -2, -1, -3, -2, 0, -3, -2, 1, -3, -2,
        -3, -2, -2, 2, -2, -2,
        -3, -1, -2, 2, -1, -2,
        -3, 0, -2, 2, 0, -2,
        -3, 1, -2, 2, 1, -2,
        -2, 2, -2, -1, 2, -2, 0, 2, -2, 1, 2, -2,

        -3, -3, -1, 2, -3, -1,
        -3, 2, -1, 2, 2, -1,

        -3, -3, 0, 2, -3, 0,
        -3, 2, 0, 2, 2, 0,

        -2, -3, 1, -1, -3, 1, 0, -3, 1, 1, -3, 1,
        -3, -2, 1, 2, -2, 1,
        -3, -1, 1, 2, -1, 1,
        -3, 0, 1, 2, 0, 1,
        -3, 1, 1, 2, 1, 1,
        -2, 2, 1, -1, 2, 1, 0, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"toaster (p4)"},
#endif
	{
        -2, 0, -1, 0, 0, -1,
        0, -2, -1,

        -1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"boats (p4)"},
#endif
	{
        -1, 0, -1, 0, 0, -1,
        0, 1, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, -1, 1,
        0, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bench (p4)"},
#endif
	{
        -1, -3, -2,
        -1, -2, -2,
        -1, -1, -2,
        -1, 0, -2,

        -1, -4, -1,
        -1, 1, -1,

        0, -3, 0,
        0, -2, 0,
        0, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"broken glider (p4)"},
#endif
	{
        1, -3, -1, 1, -2, -1,
        -3, 1, -1, -2, 1, -1,

        2, -3, 0,
        1, -2, 0, 2, -2, 0,
        -2, 1, 0,
        -3, 2, 0, -2, 2, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1,
        -2, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"twisty (p4)"},
#endif
	{
        -2, 0, 0, -1, 0, 0, 0, 0, 0, 2, 0, 0,

        1, -1, -1,
        0, 0, -1, 2, 0, -1,
        -1, 1, -1,
        127
	},
#ifdef LIFE_NAMES
	{"catch (p4)"},
#endif
	{
        -2, -2, -1, -1, -2, -1,
        -2, -1, -1,
        0, 0, -1,

        0, 0, 0, 1, 0, 0,
        0, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"leap frog (p4)"},
#endif
	{
        -1, -3, -2,
        -1, 2, -2,

        -1, -2, -1, 0, -2, -1,
        -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 0, 0, -1,
        -1, 1, -1, 0, 1, -1,

        0, -2, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"v drum (p4)"},
#endif
	{
        -3, -3, -1, 1, -3, -1,
        2, -2, -1,
        2, 2, -1,

        -2, -3, 0, -1, -3, 0,
        -2, -2, 0, -1, -2, 0, 0, -2, 0,
        1, -1, 0,
        1, 0, 0, 2, 0, 0,
        1, 1, 0, 2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"hot potato (p4)"},
#endif
	{
        -1, -2, -3, 0, -2, -3, 1, -2, -3,
        -1, -1, -3, 1, -1, -3,
        -1, 0, -3, 0, 0, -3, 1, 0, -3,

        0, -1, -2,

        -1, -2, 0, 1, -2, 0,
        -1, 0, 0, 1, 0, 0,

        0, -2, 1,
        -1, -1, 1, 1, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"invert (p4)"},
#endif
	{
        -1, -4, -1, 1, -4, -1,
        -2, -3, -1, 2, -3, -1,
        -2, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,

        0, -6, 0,
        -1, -5, 0, 1, -5, 0,
        -3, -3, 0, 3, -3, 0,
        -4, -2, 0, 4, -2, 0,
        -3, -1, 0, 3, -1, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"hot plate (p4)"},
#endif
	{
        0, -1, -2,
        -1, 0, -2, 1, 0, -2,
        0, 1, -2,

        -1, -3, 0, 1, -3, 0,
        -3, -1, 0, 3, -1, 0,
        -3, 1, 0, 3, 1, 0,
        -1, 3, 0, 1, 3, 0,

        0, -4, 1,
        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -4, 0, 1, 4, 0, 1,
        -2, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        0, 4, 1,
        127
	},
#ifdef LIFE_NAMES
	{"dining (p5)"},
#endif
	{
        0, -4, -2,
        -1, -2, -2, 1, -2, -2,
        -2, -1, -2, 2, -1, -2,
        -4, 0, -2, 4, 0, -2,
        -2, 1, -2, 2, 1, -2,
        -1, 2, -2, 1, 2, -2,
        0, 4, -2,

        -1, -3, -1, 1, -3, -1,
        -3, -1, -1, 3, -1, -1,
        -3, 1, -1, 3, 1, -1,
        -1, 3, -1, 1, 3, -1,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"yy (p6)"},
#endif
	{
        1, -4, -1,
        0, -3, -1, 1, -3, -1,
        -1, 1, -1, 0, 1, -1,
        -1, 2, -1,

        1, -5, 0,
        1, -4, 0,
        0, -3, 0, 1, -3, 0,
        1, -2, 0,
        -1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        -1, 2, 0,
        -1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4C (p6)"},
#endif
	{
        0, -3, -2, 1, -3, -2,
        2, -2, -2,
        -2, -1, -2, 2, -1, -2,
        -2, 0, -2,
        -1, 1, -2, 0, 1, -2,

        1, -3, -1,
        2, -2, -1,
        -2, 0, -1,
        -1, 1, -1,

        0, -3, 0, 1, -3, 0,
        2, -2, 0,
        -2, -1, 0, 2, -1, 0,
        -2, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"wave (p6)"},
#endif
	{
        -2, -3, -1, -1, -3, -1,
        0, -1, -1,
        2, 0, -1,
        2, 1, -1,

        -2, -2, 0,
        0, -1, 0,
        1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"another wave (p6)"},
#endif
	{
        -1, -1, -3,

        0, -3, -2,
        0, -1, -2,
        0, 0, -2,

        -1, -4, -1, 0, -4, -1,

        -1, -3, 0, 0, -3, 0,

        0, -4, 1,
        127
	},
#ifdef LIFE_NAMES
	{"another wave2 (p6)"},
#endif
	{
        0, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -1, 1, -1,
        -2, 2, -1,

        0, -2, 0, 2, -2, 0,
        1, -1, 0,
        -2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"another wave3 (p6)"},
#endif
	{
        2, -1, -2,
        1, 0, -2,

        1, -1, -1,
        -1, 0, -1,

        -2, -1, 0,
        -2, 0, 0,

        -1, -1, 1,
        -1, 0, 1,

        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"waterfall (p6)"},
#endif
	{
        -1, -3, -1,
        -2, -2, -1,
        -2, -1, -1,
        0, 0, -1,
        2, 2, -1,

        -2, -2, 0,
        -2, -1, 0,
        -1, 0, 0, 0, 0, 0,
        1, 2, 0, 2, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"pushers (p6)"},
#endif
	{
        -3, -2, -2,
        0, 1, -2,

        -3, -5, -1,
        -3, -4, -1, -2, -4, -1,
        -3, -2, -1, -2, -2, -1,
        0, 0, -1, 2, 0, -1,
        0, 1, -1, 2, 1, -1, 3, 1, -1,

        -3, -2, 0, -2, -2, 0,
        0, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"double arrow (p6)"},
#endif
	{
        -1, 0, -2, 1, 0, -2,

        -1, -1, -1, 1, -1, -1,
        -1, 1, -1, 1, 1, -1,

        -1, -2, 0, 1, -2, 0,
        -1, 2, 0, 1, 2, 0,

        -1, -1, 1, 1, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -1, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"square wave (p6)"},
#endif
	{
        0, -6, -1,
        -1, -5, -1, 0, -5, -1,
        1, -3, -1,
        -2, -2, -1, 4, -2, -1,
        -5, -1, -1, -4, -1, -1, 4, -1, -1, 5, -1, -1,
        -4, 0, -1, 2, 0, -1,
        -1, 1, -1,
        0, 3, -1, 1, 3, -1,
        0, 4, -1,

        -1, -3, 0, 0, -3, 0,
        2, -2, 0,
        -2, -1, 0, 2, -1, 0,
        -2, 0, 0,
        0, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"crate (p6)"},
#endif
	{
        -2, -1, -3, 1, -1, -3,
        -2, 0, -3, 1, 0, -3,

        -2, -2, -2, 1, -2, -2,
        -2, 1, -2, 1, 1, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -2, -2, 1, 1, -2, 1,
        -2, 1, 1, 1, 1, 1,

        -2, -1, 2, 1, -1, 2,
        -2, 0, 2, 1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"dangle (p8)"},
#endif
	{
        -2, -1, -3,

        -2, -1, -2,
        -2, 0, -2,

        1, -1, -1,
        1, 0, -1,

        1, -1, 0,

        0, -1, 1,
        0, 0, 1,

        -1, 0, 2, 0, 0, 2,

        -1, -1, 3,
        127
	},
};

static char patterns_26B5S27[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"x"},
#endif
	{
        0, -3, -1,
        0, -2, -1,
        -2, -1, -1, -1, -1, -1, 1, -1, -1, 2, -1, -1,
        0, 0, -1,
        0, 1, -1,

        0, -3, 0,
        -2, -1, 0, 2, -1, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4 bugs (p3)"},
#endif
	{
        -2, -3, -1, 1, -3, -1,
        -3, -2, -1, 2, -2, -1,
        -3, 1, -1, 2, 1, -1,
        -2, 2, -1, 1, 2, -1,

        -1, -5, 0, 0, -5, 0,
        -1, -2, 0, 0, -2, 0,
        -5, -1, 0, -2, -1, 0, 1, -1, 0, 4, -1, 0,
        -5, 0, 0, -2, 0, 0, 1, 0, 0, 4, 0, 0,
        -1, 1, 0, 0, 1, 0,
        -1, 4, 0, 0, 4, 0,

        -2, -4, 1, 1, -4, 1,
        -2, -3, 1, 1, -3, 1,
        -4, -2, 1, -3, -2, 1, 2, -2, 1, 3, -2, 1,
        -4, 1, 1, -3, 1, 1, 2, 1, 1, 3, 1, 1,
        -2, 2, 1, 1, 2, 1,
        -2, 3, 1, 1, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"toaster (p4)"},
#endif
	{
        0, -2, -1,
        -1, -1, -1,
        -2, 0, -1, 0, 0, -1,

        -1, -2, 0,
        -2, -1, 0, -1, -1, 0, 1, -1, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"bird (p4)"},
#endif
	{
        0, -3, -1,
        -1, -2, -1, 0, -2, -1,
        1, -1, -1,
        1, 0, -1,
        -1, 1, -1, 0, 1, -1,
        0, 2, -1,

        0, -2, 0, 1, -2, 0,
        -1, -1, 0,
        -1, 0, 0,
        0, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"shear (p4)"},
#endif
	{
        -1, -2, -1,
        -1, -1, -1,
        -1, 0, -1,
        -1, 1, -1,

        -2, -3, 0,
        -2, 2, 0,

        -2, -2, 1,
        -2, -1, 1,
        -2, 0, 1,
        -2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"twisty (p4)"},
#endif
	{
        0, 1, -2,

        -1, 1, -1,
        -1, 0, -1,

        -1, 0, 0, 0, 0, 0,

        0, -1, 1,

        -1, -1, 2,
        -1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"catch (p4)"},
#endif
	{
        -2, -2, -1, -1, -2, -1,
        -2, -1, -1,
        0, 0, -1,

        0, 0, 0, 1, 0, 0,
        0, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"v drum (p4)"},
#endif
	{
        -3, -3, -1, 1, -3, -1,
        2, -2, -1,
        2, 2, -1,

        -2, -3, 0, -1, -3, 0,
        -2, -2, 0, -1, -2, 0, 0, -2, 0,
        1, -1, 0,
        1, 0, 0, 2, 0, 0,
        1, 1, 0, 2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"invert (p4)"},
#endif
	{
        -1, -4, -1, 1, -4, -1,
        -2, -3, -1, 2, -3, -1,
        -2, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,

        0, -6, 0,
        -1, -5, 0, 1, -5, 0,
        -3, -3, 0, 3, -3, 0,
        -4, -2, 0, 4, -2, 0,
        -3, -1, 0, 3, -1, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"flipping cross (p4)"},
#endif
	{
        -2, -3, -2, 1, -3, -2,
        -2, 0, -2, 1, 0, -2,

        -2, -3, -1, 1, -3, -1,
        -1, -2, -1, 0, -2, -1,
        -1, -1, -1, 0, -1, -1,
        -2, 0, -1, 1, 0, -1,

        -1, -4, 0, 0, -4, 0,
        -3, -2, 0, 2, -2, 0,
        -3, -1, 0, 2, -1, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"ball (p4)"},
#endif
	{
        -1, -3, -3,
        1, -2, -3,
        -2, -1, -3,
        0, 0, -3,

        0, -4, -2,
        -3, -2, -2, -1, -2, -2,
        0, -1, -2, 2, -1, -2,
        -1, 1, -2,

        -2, -4, -1,
        -1, -3, -1, 2, -3, -1,
        -2, -2, -1,
        1, -1, -1,
        -3, 0, -1, 0, 0, -1,
        1, 1, -1,

        1, -4, 0,
        -3, -3, 0, 0, -3, 0,
        1, -2, 0,
        -2, -1, 0,
        -1, 0, 0, 2, 0, 0,
        -2, 1, 0,

        -1, -4, 1,
        0, -2, 1, 2, -2, 1,
        -3, -1, 1, -1, -1, 1,
        0, 1, 1,

        0, -3, 2,
        -2, -2, 2,
        1, -1, 2,
        -1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"xbox (p6)"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, -2, 0,
        -2, 0, 0, 0, 0, 0, 2, 0, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"CC (p6)"},
#endif
	{
        -2, -2, -2, -1, -2, -2,
        1, 0, -2,
        1, 1, -2,

        -2, -2, -1,
        1, 1, -1,

        -2, -2, 0, -1, -2, 0,
        1, 0, 0,
        1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"wave (p6)"},
#endif
	{
        -2, -3, -1, -1, -3, -1,
        0, -1, -1,
        2, 0, -1,
        2, 1, -1,

        -2, -2, 0,
        0, -1, 0,
        1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"another wave (p6)"},
#endif
	{
        -1, -1, -3,

        0, -3, -2,
        0, -1, -2,
        0, 0, -2,

        -1, -4, -1, 0, -4, -1,

        -1, -3, 0, 0, -3, 0,

        0, -4, 1,
        127
	},
#ifdef LIFE_NAMES
	{"another wave2 (p6)"},
#endif
	{
        0, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -1, 1, -1,
        -2, 2, -1,

        0, -2, 0, 2, -2, 0,
        1, -1, 0,
        -2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"another wave3 (p6)"},
#endif
	{
        2, -1, -2,
        1, 0, -2,

        1, -1, -1,
        -1, 0, -1,

        -2, -1, 0,
        -2, 0, 0,

        -1, -1, 1,
        -1, 0, 1,

        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"waterfall (p6)"},
#endif
	{
        -1, -3, -1,
        -2, -2, -1,
        -2, -1, -1,
        0, 0, -1,
        2, 2, -1,

        -2, -2, 0,
        -2, -1, 0,
        -1, 0, 0, 0, 0, 0,
        1, 2, 0, 2, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"pacman (p6)"},
#endif
	{
        0, -3, -2,
        0, 1, -2,

        -1, -2, -1, 1, -2, -1,
        -1, 0, -1, 1, 0, -1,

        -2, -2, 0, 2, -2, 0,
        -2, 0, 0, 2, 0, 0,

        -1, -2, 1, 0, -2, 1, 1, -2, 1,
        -1, 0, 1, 0, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"shredder (p6)"},
#endif
	{
        -2, -1, -2, 0, -1, -2, 2, -1, -2,

        -3, -2, -1, 3, -2, -1,
        -1, -1, -1, 1, -1, -1,

        -3, -1, 0, 3, -1, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 2, -1, 1,

        0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"yy (p6)"},
#endif
	{
        1, -4, -1,
        0, -3, -1, 1, -3, -1,
        -1, 1, -1, 0, 1, -1,
        -1, 2, -1,

        1, -5, 0,
        1, -4, 0,
        0, -3, 0, 1, -3, 0,
        1, -2, 0,
        -1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        -1, 2, 0,
        -1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"checker (p6)"},
#endif
	{
        -2, -5, -1,
        -1, -3, -1, 4, -3, -1,
        2, -2, -1,
        -2, 0, -1,
        -4, 1, -1, 1, 1, -1,
        2, 3, -1,

        -3, -5, 0,
        -3, -4, 0, 3, -4, 0, 4, -4, 0,
        -1, -3, 0,
        0, -2, 0, 2, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 0, 0, 0,
        1, 1, 0,
        -4, 2, 0, -3, 2, 0, 3, 2, 0,
        3, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"tied down ring (p6)"},
#endif
	{
        0, -4, -1, 1, -4, -1,
        -1, -2, -1,
        -2, -1, -1, 4, -1, -1,
        -4, 0, -1, 4, 0, -1,
        -4, 1, -1, 2, 1, -1,
        1, 2, -1,
        -1, 4, -1, 0, 4, -1,

        1, -5, 0,
        0, -2, 0, 1, -2, 0,
        2, -1, 0, 5, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -5, 1, 0, -2, 1, 0,
        -1, 2, 0, 0, 2, 0,
        -1, 5, 0,
        127
	},
#ifdef LIFE_NAMES
	{"dangle (p8)"},
#endif
	{
        -2, -1, -3,

        -2, -1, -2,
        -2, 0, -2,

        1, -1, -1,
        1, 0, -1,

        1, -1, 0,

        0, -1, 1,
        0, 0, 1,

        -1, 0, 2, 0, 0, 2,

        -1, -1, 3,
        127
	},
};

static char patterns_26B5S35[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"tri rotor"},
#endif
	{
        -1, -1, -2, 0, -1, -2,

        -2, -1, -1, 1, -1, -1,

        -1, -2, 0, 0, -2, 0,
        -1, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"flip"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        1, 0, -1,

        -1, -1, 0,
        1, 1, 0,

        0, -1, 1, 1, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"alternate"},
#endif
	{
        -2, -2, -1, -1, -2, -1,
        -2, -1, -1, -1, -1, -1,
        1, 0, -1,
        0, 1, -1, 1, 1, -1,

        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"drop em"},
#endif
	{
        -1, -2, -1,
        1, -1, -1,
        -2, 0, -1,
        0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"alternator"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -1, -2, -1,
        -3, -1, -1, 1, -1, -1, 2, -1, -1,
        -3, 0, -1, -2, 0, -1, 2, 0, -1,
        0, 1, -1,
        -1, 2, -1, 0, 2, -1,

        0, -2, 0,
        -2, -1, 0,
        1, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twist"},
#endif
	{
        1, -3, -1,
        -2, -2, -1,
        2, 0, -1,
        -1, 1, -1,

        0, -4, 0, 1, -4, 0,
        1, -3, 0,
        -3, -2, 0, -2, -2, 0, 0, -2, 0,
        -3, -1, 0, -1, -1, 0, 1, -1, 0, 3, -1, 0,
        0, 0, 0, 2, 0, 0, 3, 0, 0,
        -1, 1, 0,
        -1, 2, 0, 0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twist2"},
#endif
	{
        1, -4, -1,
        -1, -3, -1, 0, -3, -1,
        -3, -2, -1, 2, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 0, -1, 3, 0, -1,
        0, 1, -1, 1, 1, -1,
        -1, 2, -1,

        0, -3, 0, 1, -3, 0,
        -2, -2, 0,
        -2, -1, 0, 2, -1, 0,
        2, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"easy come (p3)"},
#endif
	{
        0, -1, -2,
        -1, 0, -2,

        -1, 0, -1, 0, 0, -1,

        -1, -3, 0,
        -1, -2, 0,

        0, -3, 1,
        0, -2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"fall (p4)"},
#endif
	{
        -1, -1, -1,

        -1, -1, 0, 0, -1, 0,
        0, 0, 0,

        -1, -3, 1, 0, -3, 1,
        -1, -1, 1, 0, -1, 1,

        -1, -2, 2, 0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"swing (p4)"},
#endif
	{
        -1, -2, -1,
        -1, 0, -1, 0, 0, -1, 1, 0, -1,
        1, 1, -1,

        -2, -2, 0,
        -2, -1, 0,
        -1, 0, 0,
        0, 1, 0,

        -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"invert (p4)"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -2, -2, -1, 1, -2, -1,
        -3, -1, -1, 2, -1, -1,
        -3, 0, -1, 2, 0, -1,
        -2, 1, -1, 1, 1, -1,
        -1, 2, -1, 0, 2, -1,

        -1, -2, 0,
        1, -1, 0,
        -2, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"hide (p4)"},
#endif
	{
        0, 0, -2,

        1, -1, -1,
        0, 0, -1,
        -1, 1, -1,

        0, -2, 0, 1, -2, 0,
        -2, 0, 0,
        -2, 1, 0,

        1, -1, 1,
        0, 0, 1,
        -1, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"mirror (p4)"},
#endif
	{
        -1, -1, -2,
        -1, 1, -2,

        -2, -1, -1, -1, -1, -1, 0, -1, -1,
        -2, 1, -1, -1, 1, -1, 0, 1, -1,

        -1, -2, 0,
        -1, -1, 0,
        1, 0, 0,
        -1, 1, 0,
        -1, 2, 0,

        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"mirror2 (p4)"},
#endif
	{
        -2, -2, -2,
        -2, -1, -2, -1, -1, -2,
        1, 1, -2,
        1, 2, -2, 2, 2, -2,

        -1, -1, -1, 0, -1, -1,
        1, 0, -1,
        1, 1, -1,

        0, -1, 1,
        1, 0, 1,

        0, -1, 2,
        1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"mirror3 (p4)"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        -1, -1, -1,
        -1, 1, -1,

        0, -2, 0, 1, -2, 0,
        0, 2, 0, 1, 2, 0,

        0, -3, 1,
        1, -2, 1,
        1, 2, 1,
        0, 3, 1,

        0, -3, 2,
        0, -2, 2,
        0, 2, 2,
        0, 3, 2,
        127
	},
#ifdef LIFE_NAMES
	{"mirror4 (p4)"},
#endif
	{
        0, 0, -2, 1, 0, -2,
        0, 1, -2, 1, 1, -2,

        1, -1, -1, 2, -1, -1,
        -1, 1, -1,
        -1, 2, -1,

        1, -2, 0,
        2, -1, 0,
        -2, 1, 0,
        -1, 2, 0,

        1, -2, 1,
        1, -1, 1,
        -2, 1, 1, -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"mirror5 (p4)"},
#endif
	{
        -2, 0, -2, -1, 0, -2, 1, 0, -2, 2, 0, -2,
        -1, 1, -2, 1, 1, -2,

        -1, 1, -1, 1, 1, -1,

        -3, -1, 0, -2, -1, 0, 2, -1, 0, 3, -1, 0,
        -3, 0, 0, -1, 0, 0, 1, 0, 0, 3, 0, 0,
        -1, 1, 0, 1, 1, 0,

        -2, 0, 1, 2, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"corner (p4)"},
#endif
	{
        2, -1, -2,
        1, 0, -2,
        0, 1, -2,
        -1, 2, -2,

        2, -2, -1,
        2, 0, -1,
        -2, 2, -1, 0, 2, -1,

        1, -2, 0,
        2, -1, 0,
        -2, 1, 0,
        -1, 2, 0,

        0, -2, 1,
        -2, 0, 1,

        -1, -2, 2,
        -2, -1, 2, 0, -1, 2,
        -1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"ratchet (p4)"},
#endif
	{
        0, 0, -3,
        0, 1, -3,

        1, -1, -2, 2, -1, -2,
        0, 1, -2,

        2, -1, -1,
        -2, 1, -1,
        -2, 2, -1, -1, 2, -1,

        0, -3, 0, 1, -3, 0,
        1, -2, 0,
        -3, 0, 0,

        -1, -2, 1,
        -3, 0, 1, -2, 0, 1,

        -1, -2, 2,
        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"saddle (p4)"},
#endif
	{
        -3, -1, -3, 2, -1, -3,
        -3, 0, -3, 2, 0, -3,

        -3, -1, -2, 2, -1, -2,
        -3, 0, -2, 2, 0, -2,

        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,

        -1, -3, 0, 0, -3, 0,
        -1, 2, 0, 0, 2, 0,

        -1, -3, 1, 0, -3, 1,
        -1, 2, 1, 0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"splitter (p4)"},
#endif
	{
        -1, -1, -3,
        -1, 0, -3,

        -2, -1, -2, 0, -1, -2,
        -2, 0, -2, 0, 0, -2,

        1, -3, -1, 2, -3, -1,
        1, 2, -1, 2, 2, -1,

        1, -3, 0, 2, -3, 0,
        1, 2, 0, 2, 2, 0,

        -2, -1, 1, 0, -1, 1,
        -2, 0, 1, 0, 0, 1,

        -1, -1, 2,
        -1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"4 runners (p4)"},
#endif
	{
        -1, -4, -2, 0, -4, -2,
        -1, -3, -2,
        -4, -1, -2, 2, -1, -2, 3, -1, -2,
        -4, 0, -2, -3, 0, -2, 3, 0, -2,
        0, 2, -2,
        -1, 3, -2, 0, 3, -2,

        -1, -4, -1,
        -1, -2, -1,
        1, -1, -1, 3, -1, -1,
        -4, 0, -1, -2, 0, -1,
        0, 1, -1,
        0, 3, -1,

        -1, -3, 0,
        -1, -2, 0,
        1, -1, 0, 2, -1, 0,
        -3, 0, 0, -2, 0, 0,
        0, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4T scramble (p4)"},
#endif
	{
        -3, -3, -1, 3, -3, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        -3, 3, -1, 3, 3, -1,

        -2, -3, 0, 2, -3, 0,
        -3, -2, 0, -2, -2, 0, 1, -2, 0, 2, -2, 0, 3, -2, 0,
        -2, -1, 0,
        2, 1, 0,
        -3, 2, 0, -2, 2, 0, -1, 2, 0, 2, 2, 0, 3, 2, 0,
        -2, 3, 0, 2, 3, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"arena (p4)"},
#endif
	{
        -2, -5, -1, -1, -5, -1, 0, -5, -1, 1, -5, -1,
        -5, -2, -1, 4, -2, -1,
        -5, -1, -1, 4, -1, -1,
        -5, 0, -1, 4, 0, -1,
        -5, 1, -1, 4, 1, -1,
        -2, 4, -1, -1, 4, -1, 0, 4, -1, 1, 4, -1,

        -3, -4, 0, -2, -4, 0, 1, -4, 0, 2, -4, 0,
        -4, -3, 0, -3, -3, 0, 2, -3, 0, 3, -3, 0,
        -4, -2, 0, 3, -2, 0,
        -4, 1, 0, 3, 1, 0,
        -4, 2, 0, -3, 2, 0, 2, 2, 0, 3, 2, 0,
        -3, 3, 0, -2, 3, 0, 1, 3, 0, 2, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"chew (p5)"},
#endif
	{
        1, 0, -4,
        0, 1, -4,

        0, -1, -3, 1, -1, -3,
        -1, 0, -3,
        -1, 1, -3,

        3, -1, -2,
        2, 0, -2,
        0, 2, -2,
        -1, 3, -2,

        0, -3, -1, 1, -3, -1,
        3, -2, -1,
        -3, 0, -1, 2, 0, -1,
        -3, 1, -1,
        0, 2, -1,
        -2, 3, -1,

        1, -4, 0,
        -1, -3, 0,
        2, -2, 0,
        -3, -1, 0, 2, -1, 0,
        -4, 1, 0,
        -2, 2, 0, -1, 2, 0,

        0, -4, 1,
        -1, -3, 1,
        -3, -1, 1,
        -4, 0, 1,

        0, -2, 2,
        0, -1, 2,
        -2, 0, 2, -1, 0, 2,

        -1, -2, 3,
        -2, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"polyomino (p6)"},
#endif
	{
        1, 0, -1,
        -1, -1, 0, 1, -1, 0,
        0, 0, 0, 1, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"gadget (p6)"},
#endif
	{
        0, -2, -2,
        0, -1, -2,

        1, -3, -1,
        -1, -2, -1,
        1, -1, -1,
        -1, 0, -1,

        0, -3, 0,
        0, -2, 0,
        0, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"star (p6)"},
#endif
	{
        -1, -2, -3,
        0, -1, -3,

        -1, -2, -2,
        0, -1, -2,

        -1, -4, -1,
        -1, -3, -1,
        -3, -2, -1, -2, -2, -1,
        1, -1, -1, 2, -1, -1,
        0, 0, -1,
        0, 1, -1,

        0, -4, 0,
        0, -3, 0,
        1, -2, 0, 2, -2, 0,
        -3, -1, 0, -2, -1, 0,
        -1, 0, 0,
        -1, 1, 0,

        0, -2, 1,
        -1, -1, 1,

        0, -2, 2,
        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"X generator (p12)"},
#endif
	{
        -2, -3, -1,
        -3, -2, -1,
        -1, -1, -1,
        1, 1, -1,
        3, 2, -1,
        2, 3, -1,

        -3, -3, 0,
        -1, -2, 0,
        -2, -1, 0, -1, -1, 0,
        1, 1, 0, 2, 1, 0,
        1, 2, 0,
        3, 3, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"HH (p12)"},
#endif
	{
        -2, -2, -1, -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -2, 1, -1, -1, 1, -1, 0, 1, -1, 1, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -1, 1, 0, 0, 1, 0,

        -2, -2, 1, -1, -2, 1, 0, -2, 1, 1, -2, 1,
        -2, 1, 1, -1, 1, 1, 0, 1, 1, 1, 1, 1,
        127
	},
};

static char patterns_26B5S36[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"puffer (c/2, p4)"},
#endif
	{
        -1, -3, -2, 0, -3, -2,
        -2, -2, -2, -1, -2, -2, 0, -2, -2, 1, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2, 1, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -4, -1, 0, -4, -1,
        -3, -2, -1, 2, -2, -1,
        -3, -1, -1, 2, -1, -1,
        -1, 1, -1, 0, 1, -1,

        -2, -4, 1, -1, -4, 1, 0, -4, 1, 1, -4, 1,
        -3, -3, 1, 2, -3, 1,
        -3, -2, 1, 2, -2, 1,
        -3, -1, 1, 2, -1, 1,
        -3, 0, 1, 2, 0, 1,
        -2, 1, 1, -1, 1, 1, 0, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"puffer2 (c/2, p8)"},
#endif
	{
        -1, -2, -3, 0, -2, -3,
        -3, 0, -3, -1, 0, -3, 0, 0, -3, 2, 0, -3,

        -1, -3, -2, 0, -3, -2,

        -2, -3, -1, -1, -3, -1, 0, -3, -1, 1, -3, -1,
        -3, -2, -1, 2, -2, -1,
        -3, 0, -1, 2, 0, -1,

        -2, -3, 0, -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -3, -2, 0, 2, -2, 0,
        -3, 0, 0, 2, 0, 0,

        -1, -3, 1, 0, -3, 1,

        -1, -2, 2, 0, -2, 2,
        -3, 0, 2, -1, 0, 2, 0, 0, 2, 2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"puffer3 (c/2, p20)"},
#endif
	{
        -1, -3, -5, 0, -3, -5,
        -2, -2, -5, 1, -2, -5,
        -3, -1, -5, -1, -1, -5, 0, -1, -5, 2, -1, -5,
        -3, 0, -5, -1, 0, -5, 0, 0, -5, 2, 0, -5,
        -2, 1, -5, 1, 1, -5,
        -1, 2, -5, 0, 2, -5,

        -2, -3, -4, 1, -3, -4,
        -3, -2, -4, 2, -2, -4,
        -3, 1, -4, 2, 1, -4,
        -2, 2, -4, 1, 2, -4,

        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 0, 0, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,

        -1, -1, 3, 0, -1, 3,
        -1, 0, 3, 0, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"flip"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        1, 0, -1,

        -1, -1, 0,
        1, 1, 0,

        0, -1, 1, 1, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"alternate"},
#endif
	{
        -2, -2, -1, -1, -2, -1,
        -2, -1, -1, -1, -1, -1,
        1, 0, -1,
        0, 1, -1, 1, 1, -1,

        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"drop em"},
#endif
	{
        -1, -2, -1,
        1, -1, -1,
        -2, 0, -1,
        0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"alternator"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -1, -2, -1,
        -3, -1, -1, 1, -1, -1, 2, -1, -1,
        -3, 0, -1, -2, 0, -1, 2, 0, -1,
        0, 1, -1,
        -1, 2, -1, 0, 2, -1,

        0, -2, 0,
        -2, -1, 0,
        1, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twist"},
#endif
	{
        1, -3, -1,
        -2, -2, -1,
        2, 0, -1,
        -1, 1, -1,

        0, -4, 0, 1, -4, 0,
        1, -3, 0,
        -3, -2, 0, -2, -2, 0, 0, -2, 0,
        -3, -1, 0, -1, -1, 0, 1, -1, 0, 3, -1, 0,
        0, 0, 0, 2, 0, 0, 3, 0, 0,
        -1, 1, 0,
        -1, 2, 0, 0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twist2"},
#endif
	{
        1, -4, -1,
        -1, -3, -1, 0, -3, -1,
        -3, -2, -1, 2, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 0, -1, 3, 0, -1,
        0, 1, -1, 1, 1, -1,
        -1, 2, -1,

        0, -3, 0, 1, -3, 0,
        -2, -2, 0,
        -2, -1, 0, 2, -1, 0,
        2, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"skew cube (p3)"},
#endif
	{
        2, 0, -3,
        2, 1, -3,

        1, 0, -2,
        1, 1, -2,

        0, 0, -1,
        2, 1, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -2, 1, 0, 0, 1, 0,
        -3, 2, 0,

        0, -2, 1, 1, -2, 1,
        0, 0, 1,
        -2, 1, 1,
        -3, 2, 1, -1, 2, 1,

        0, -3, 2, 1, -3, 2,
        1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"partial frame (p3)"},
#endif
	{
        2, -2, -3,
        -1, 0, -3,

        1, -4, -2,
        1, -3, -2,
        1, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2, 1, -1, -2,

        2, -5, -1,
        1, -4, -1,
        -2, -1, -1,

        1, -4, 0,
        -2, -1, 0,
        -3, 0, 0,

        -2, -4, 1, -1, -4, 1, 0, -4, 1, 1, -4, 1,
        -2, -3, 1,
        -2, -2, 1,
        -2, -1, 1,

        0, -5, 2,
        -3, -3, 2,
        127
	},
#ifdef LIFE_NAMES
	{"TT (p4)"},
#endif
	{
        -1, 0, 1,

        0, -1, -1,
        0, 0, -1,
        0, 1, -1,

        0, -1, 1,
        0, 0, 1,
        0, 1, 1,

        1, 0, -1,
        127
	},
#ifdef LIFE_NAMES
	{"3S (p4)"},
#endif
	{
        0, -1, -2,

        0, -1, -1, 1, -1, -1,
        -2, 0, -1, -1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0,
        -1, -1, 0, 1, -1, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"corner flip (p4)"},
#endif
	{
        0, -2, -2, 1, -2, -2,
        -1, -1, -2, 0, -1, -2,
        -2, 0, -2, -1, 0, -2,
        -2, 1, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1,
        -2, 0, -1,

        -2, -2, 0, -1, -2, 0,
        -2, -1, 0,

        -2, -2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"4T (p4)"},
#endif
	{
        0, -3, -2,
        -2, -2, -2,
        1, -1, -2,
        -1, 0, -2,

        0, -4, -1,
        0, -3, -1,
        -3, -2, -1, -2, -2, -1,
        1, -1, -1, 2, -1, -1,
        -1, 0, -1,
        -1, 1, -1,

        0, -3, 0,
        -2, -2, 0,
        1, -1, 0,
        -1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"flip (p4)"},
#endif
	{
        1, -3, -2,
        1, -2, -2, 2, -2, -2,
        -2, 0, -2, -1, 0, -2,
        -1, 1, -2,

        0, -2, -1, 1, -2, -1,
        -1, -1, -1,
        -1, 0, -1,

        1, -3, 0,
        0, -2, 0,
        -1, -1, 0,
        -2, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"tick tock (p4)"},
#endif
	{
        0, -2, -3,
        -1, -1, -3,

        -2, -2, -2, 1, -2, -2,
        -2, -1, -2, 1, -1, -2,

        -1, -3, -1, 0, -3, -1,
        -1, 0, -1, 0, 0, -1,

        -2, -2, 0, 1, -2, 0,
        -2, -1, 0, 1, -1, 0,

        -1, -2, 1,
        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pieces (p4)"},
#endif
	{
        -2, 0, -3, -1, 0, -3,

        -3, -1, -2,
        0, 0, -2,

        -1, -2, -1,
        -3, -1, -1, -2, -1, -1,
        0, 1, -1,
        0, 2, -1, 1, 2, -1,

        -1, -3, 0,
        1, -1, 0,
        2, 0, 0,
        2, 1, 0,

        -1, -3, 1,
        0, -1, 1,

        0, -2, 2,
        0, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"ratchet (p4)"},
#endif
	{
        0, 0, -3,
        0, 1, -3,

        1, -1, -2, 2, -1, -2,
        0, 1, -2,

        2, -1, -1,
        -2, 1, -1,
        -2, 2, -1, -1, 2, -1,

        0, -3, 0, 1, -3, 0,
        1, -2, 0,
        -3, 0, 0,

        -1, -2, 1,
        -3, 0, 1, -2, 0, 1,

        -1, -2, 2,
        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"burr (p4)"},
#endif
	{
        -2, -1, -3, 0, -1, -3,
        -1, 0, -3,

        -1, -3, -2,
        0, -2, -2,
        -2, 0, -2,

        0, -3, -1,
        -3, -2, -1,
        -3, 0, -1, 2, 0, -1,
        1, 1, -1,
        0, 2, -1,

        -1, -3, 0,
        -2, -2, 0,
        -3, -1, 0, 2, -1, 0,
        2, 1, 0,
        -1, 2, 0,

        1, -1, 1,
        -1, 1, 1,
        0, 2, 1,

        0, -1, 2,
        -1, 0, 2, 1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"4 runners (p4)"},
#endif
	{
        -1, -4, -2, 0, -4, -2,
        -1, -3, -2,
        -4, -1, -2, 2, -1, -2, 3, -1, -2,
        -4, 0, -2, -3, 0, -2, 3, 0, -2,
        0, 2, -2,
        -1, 3, -2, 0, 3, -2,

        -1, -4, -1,
        -1, -2, -1,
        1, -1, -1, 3, -1, -1,
        -4, 0, -1, -2, 0, -1,
        0, 1, -1,
        0, 3, -1,

        -1, -3, 0,
        -1, -2, 0,
        1, -1, 0, 2, -1, 0,
        -3, 0, 0, -2, 0, 0,
        0, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4T scramble (p4)"},
#endif
	{
        -3, -3, -1, 3, -3, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        -3, 3, -1, 3, 3, -1,

        -2, -3, 0, 2, -3, 0,
        -3, -2, 0, -2, -2, 0, 1, -2, 0, 2, -2, 0, 3, -2, 0,
        -2, -1, 0,
        2, 1, 0,
        -3, 2, 0, -2, 2, 0, -1, 2, 0, 2, 2, 0, 3, 2, 0,
        -2, 3, 0, 2, 3, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"arena (p4)"},
#endif
	{
        -2, -5, -1, -1, -5, -1, 0, -5, -1, 1, -5, -1,
        -5, -2, -1, 4, -2, -1,
        -5, -1, -1, 4, -1, -1,
        -5, 0, -1, 4, 0, -1,
        -5, 1, -1, 4, 1, -1,
        -2, 4, -1, -1, 4, -1, 0, 4, -1, 1, 4, -1,

        -3, -4, 0, -2, -4, 0, 1, -4, 0, 2, -4, 0,
        -4, -3, 0, -3, -3, 0, 2, -3, 0, 3, -3, 0,
        -4, -2, 0, 3, -2, 0,
        -4, 1, 0, 3, 1, 0,
        -4, 2, 0, -3, 2, 0, 2, 2, 0, 3, 2, 0,
        -3, 3, 0, -2, 3, 0, 1, 3, 0, 2, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"arena2 (p4)"},
#endif
	{
        -3, -5, -2, 2, -5, -2,
        -4, -4, -2, 3, -4, -2,
        -4, 1, -2, 3, 1, -2,
        -3, 2, -2, 2, 2, -2,

        -3, -5, -1, -1, -5, -1, 0, -5, -1, 2, -5, -1,
        -4, -4, -1, 3, -4, -1,
        -4, -2, -1, 3, -2, -1,
        -4, -1, -1, 3, -1, -1,
        -4, 1, -1, 3, 1, -1,
        -3, 2, -1, -1, 2, -1, 0, 2, -1, 2, 2, -1,

        -2, -6, 0, -1, -6, 0, 0, -6, 0, 1, -6, 0,
        -5, -3, 0, 4, -3, 0,
        -5, -2, 0, 4, -2, 0,
        -5, -1, 0, 4, -1, 0,
        -5, 0, 0, 4, 0, 0,
        -2, 3, 0, -1, 3, 0, 0, 3, 0, 1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"arena3 (p4)"},
#endif
	{
        -3, -4, -1, 2, -4, -1,
        -4, -3, -1, 3, -3, -1,
        -4, 2, -1, 3, 2, -1,
        -3, 3, -1, 2, 3, -1,

        -3, -4, 0, -1, -4, 0, 0, -4, 0, 2, -4, 0,
        -4, -3, 0, 3, -3, 0,
        -4, -1, 0, 3, -1, 0,
        -4, 0, 0, 3, 0, 0,
        -4, 2, 0, 3, 2, 0,
        -3, 3, 0, -1, 3, 0, 0, 3, 0, 2, 3, 0,

        -1, -5, 1, 0, -5, 1,
        -2, -4, 1, 1, -4, 1,
        -4, -2, 1, 3, -2, 1,
        -5, -1, 1, 4, -1, 1,
        -5, 0, 1, 4, 0, 1,
        -4, 1, 1, 3, 1, 1,
        -2, 3, 1, 1, 3, 1,
        -1, 4, 1, 0, 4, 1,
        127
	},
#ifdef LIFE_NAMES
	{"group exercise (p4)"},
#endif
	{
        -1, -4, -2, 0, -4, -2,
        -4, -1, -2, 3, -1, -2,
        -4, 0, -2, 3, 0, -2,
        -1, 3, -2, 0, 3, -2,

        -1, -4, -1, 0, -4, -1,
        -4, -1, -1, 3, -1, -1,
        -4, 0, -1, 3, 0, -1,
        -1, 3, -1, 0, 3, -1,

        -1, -4, 0, 0, -4, 0,
        -2, -3, 0, 1, -3, 0,
        -3, -2, 0, 2, -2, 0,
        -4, -1, 0, 3, -1, 0,
        -4, 0, 0, 3, 0, 0,
        -3, 1, 0, 2, 1, 0,
        -2, 2, 0, 1, 2, 0,
        -1, 3, 0, 0, 3, 0,

        -1, -4, 1, 0, -4, 1,
        -4, -1, 1, 3, -1, 1,
        -4, 0, 1, 3, 0, 1,
        -1, 3, 1, 0, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"deformed ball (p6)"},
#endif
	{
        -1, -2, -2,
        -2, -1, -2, -1, -1, -2,
        1, 0, -2,
        0, 1, -2,

        -2, -2, -1, -1, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -1, 1, -1,

        1, -2, 0,
        1, 0, 0,
        -2, 1, 0, 0, 1, 0,

        0, -2, 1,
        -1, -1, 1,
        -2, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"triangulate (p6)"},
#endif
	{
        -3, 0, -4, -2, 0, -4,
        -3, 1, -4,

        -3, 1, -3,

        -3, 0, -2,
        -4, 1, -2, -3, 1, -2,

        -3, 0, -1,

        -3, 0, 0,
        3, 1, 0,
        -1, 2, 0, 0, 2, 0, 1, 2, 0, 3, 2, 0,

        -1, -4, 1,
        1, 2, 1, 2, 2, 1, 3, 2, 1,
        1, 3, 1,

        -2, -4, 2, -1, -4, 2,
        -2, -3, 2,
        -2, -2, 2, -1, -2, 2,
        -1, -1, 2,
        -1, 0, 2,

        -2, -2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"flu (p6)"},
#endif
	{
        -1, -4, -1, 0, -4, -1,
        1, -3, -1,
        -3, -2, -1, -1, -2, -1,
        -4, -1, -1, 1, -1, -1, 3, -1, -1,
        -4, 0, -1, -2, 0, -1, 3, 0, -1,
        0, 1, -1, 2, 1, -1,
        -2, 2, -1,
        -1, 3, -1, 0, 3, -1,

        0, -4, 0,
        -2, -3, 0,
        2, -2, 0,
        -4, -1, 0,
        3, 0, 0,
        -3, 1, 0,
        1, 2, 0,
        -1, 3, 0,

        1, -4, 1,
        1, -3, 1,
        -4, -2, 1, -3, -2, 1,
        2, 1, 1, 3, 1, 1,
        -2, 2, 1,
        -2, 3, 1,
        127
	},
};

static char patterns_26B5S37[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"tri rotor"},
#endif
	{
        -1, -1, -2, 0, -1, -2,

        -2, -1, -1, 1, -1, -1,

        -1, -2, 0, 0, -2, 0,
        -1, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"flip"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        1, 0, -1,

        -1, -1, 0,
        1, 1, 0,

        0, -1, 1, 1, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"alternate"},
#endif
	{
        -2, -2, -1, -1, -2, -1,
        -2, -1, -1, -1, -1, -1,
        1, 0, -1,
        0, 1, -1, 1, 1, -1,

        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"drop em"},
#endif
	{
        -1, -2, -1,
        1, -1, -1,
        -2, 0, -1,
        0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"alternator"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -1, -2, -1,
        -3, -1, -1, 1, -1, -1, 2, -1, -1,
        -3, 0, -1, -2, 0, -1, 2, 0, -1,
        0, 1, -1,
        -1, 2, -1, 0, 2, -1,

        0, -2, 0,
        -2, -1, 0,
        1, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"prickly"},
#endif
	{
        -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 0, -1, 0, 0, -1, 2, 0, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 0, 2, -1, 1, 2, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twist"},
#endif
	{
        1, -3, -1,
        -2, -2, -1,
        2, 0, -1,
        -1, 1, -1,

        0, -4, 0, 1, -4, 0,
        1, -3, 0,
        -3, -2, 0, -2, -2, 0, 0, -2, 0,
        -3, -1, 0, -1, -1, 0, 1, -1, 0, 3, -1, 0,
        0, 0, 0, 2, 0, 0, 3, 0, 0,
        -1, 1, 0,
        -1, 2, 0, 0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twist2"},
#endif
	{
        1, -4, -1,
        -1, -3, -1, 0, -3, -1,
        -3, -2, -1, 2, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 0, -1, 3, 0, -1,
        0, 1, -1, 1, 1, -1,
        -1, 2, -1,

        0, -3, 0, 1, -3, 0,
        -2, -2, 0,
        -2, -1, 0, 2, -1, 0,
        2, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"stretch"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2, 1, -1, -2,
        -2, 0, -2, -1, 0, -2, 0, 0, -2, 1, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, -1, -1, 0, 0, -1, 0, 1, -1, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"rubber band"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -2, -2, 0, -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -2, 1, 0, -1, 1, 0, 0, 1, 0, 1, 1, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, 1, -1, 1,
        -2, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"twist off (p3)"},
#endif
	{
        0, -1, -2,

        -2, -1, -1, 0, -1, -1, 1, -1, -1,
        1, 0, -1,

        -2, -2, 1,
        -2, -1, 1, -1, -1, 1, 1, -1, 1,

        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"handshake (p3)"},
#endif
	{
        0, -2, -2,
        0, -1, -2,

        0, -2, -1,
        0, -1, -1,

        0, -2, 0,
        1, -1, 0,

        -1, 0, 1,
        0, 1, 1,
        0, 2, 1,

        0, 0, 2,
        0, 1, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"catalyst (p3)"},
#endif
	{
        0, -3, -3,
        0, -2, -3,
        -1, 1, -3,
        -1, 2, -3,

        0, -3, -2,
        1, -2, -2,
        -2, 1, -2,
        -1, 2, -2,

        1, -1, -1,
        -2, 0, -1,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"coat stands (p3)"},
#endif
	{
        -2, -2, -2, -1, -2, -2,
        -2, -1, -2, 0, -1, -2,
        -1, 0, -2,

        -1, -1, -1,

        -1, -1, 0,
        0, 0, 0,

        0, 0, 1,

        0, -1, 2,
        -1, 0, 2, 1, 0, 2,
        0, 1, 2, 1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"spark (p3)"},
#endif
	{
        -1, -1, -3, 0, -1, -3,

        -1, 0, -2, 0, 0, -2,

        -4, -2, -1, 3, -2, -1,
        -4, -1, -1, 3, -1, -1,
        -2, 0, -1, 1, 0, -1,

        -2, -3, 0, 1, -3, 0,
        -4, -2, 0, 3, -2, 0,
        -4, -1, 0, 3, -1, 0,

        -1, -3, 1, 0, -3, 1,

        -1, -2, 2, 0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"rotor cross (p3)"},
#endif
	{
        0, -4, -1,
        1, -3, -1,
        -3, -2, -1,
        -4, -1, -1,
        3, 0, -1,
        2, 1, -1,
        -2, 2, -1,
        -1, 3, -1,

        -1, -4, 0,
        -1, -3, 0,
        -2, -2, 0, 1, -2, 0,
        2, -1, 0, 3, -1, 0,
        -4, 0, 0, -3, 0, 0,
        -2, 1, 0, 1, 1, 0,
        0, 2, 0,
        0, 3, 0,

        0, -4, 1,
        1, -3, 1,
        -3, -2, 1,
        -4, -1, 1,
        3, 0, 1,
        2, 1, 1,
        -2, 2, 1,
        -1, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"arena (p3)"},
#endif
	{
        -3, -4, -1, 2, -4, -1,
        -4, -3, -1, -2, -3, -1, 1, -3, -1, 3, -3, -1,
        -3, -2, -1, -2, -2, -1, 1, -2, -1, 2, -2, -1,
        -3, 1, -1, -2, 1, -1, 1, 1, -1, 2, 1, -1,
        -4, 2, -1, -2, 2, -1, 1, 2, -1, 3, 2, -1,
        -3, 3, -1, 2, 3, -1,

        -2, -4, 0, -1, -4, 0, 0, -4, 0, 1, -4, 0,
        -4, -2, 0, 3, -2, 0,
        -4, -1, 0, 3, -1, 0,
        -4, 0, 0, 3, 0, 0,
        -4, 1, 0, 3, 1, 0,
        -2, 3, 0, -1, 3, 0, 0, 3, 0, 1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"TT (p4)"},
#endif
	{
        -1, 0, 1,

        0, -1, -1,
        0, 0, -1,
        0, 1, -1,

        0, -1, 1,
        0, 0, 1,
        0, 1, 1,

        1, 0, -1,
        127
	},
#ifdef LIFE_NAMES
	{"capture (p4)"},
#endif
	{
        0, -1, -1,
        1, 0, -1,

        1, 0, 0,
        0, -1, 0,

        -1, -2, 1, 0, -2, 1,
        -1, -1, 1,
        2, 0, 1,
        1, 1, 1, 2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"4T (p4)"},
#endif
	{
        0, -3, -2,
        -2, -2, -2,
        1, -1, -2,
        -1, 0, -2,

        0, -4, -1,
        0, -3, -1,
        -3, -2, -1, -2, -2, -1,
        1, -1, -1, 2, -1, -1,
        -1, 0, -1,
        -1, 1, -1,

        0, -3, 0,
        -2, -2, 0,
        1, -1, 0,
        -1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"splitter (p4)"},
#endif
	{
        1, -3, -3, 2, -3, -3,
        -2, 0, -3,
        -2, 1, -3,

        1, -3, -2, 2, -3, -2,
        -2, 0, -2,
        -2, 1, -2,

        0, -2, -1,
        -1, -1, -1,

        -1, -2, 1, 0, -2, 1,
        -1, -1, 1,

        0, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"ratchet (p4)"},
#endif
	{
        0, 0, -3,
        0, 1, -3,

        1, -1, -2, 2, -1, -2,
        0, 1, -2,

        2, -1, -1,
        -2, 1, -1,
        -2, 2, -1, -1, 2, -1,

        0, -3, 0, 1, -3, 0,
        1, -2, 0,
        -3, 0, 0,

        -1, -2, 1,
        -3, 0, 1, -2, 0, 1,

        -1, -2, 2,
        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"4 runners (p4)"},
#endif
	{
        -1, -4, -2, 0, -4, -2,
        -1, -3, -2,
        -4, -1, -2, 2, -1, -2, 3, -1, -2,
        -4, 0, -2, -3, 0, -2, 3, 0, -2,
        0, 2, -2,
        -1, 3, -2, 0, 3, -2,

        -1, -4, -1,
        -1, -2, -1,
        1, -1, -1, 3, -1, -1,
        -4, 0, -1, -2, 0, -1,
        0, 1, -1,
        0, 3, -1,

        -1, -3, 0,
        -1, -2, 0,
        1, -1, 0, 2, -1, 0,
        -3, 0, 0, -2, 0, 0,
        0, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4T scramble (p4)"},
#endif
	{
        -3, -3, -1, 3, -3, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        -3, 3, -1, 3, 3, -1,

        -2, -3, 0, 2, -3, 0,
        -3, -2, 0, -2, -2, 0, 1, -2, 0, 2, -2, 0, 3, -2, 0,
        -2, -1, 0,
        2, 1, 0,
        -3, 2, 0, -2, 2, 0, -1, 2, 0, 2, 2, 0, 3, 2, 0,
        -2, 3, 0, 2, 3, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"arena (p4)"},
#endif
	{
        -2, -5, -1, -1, -5, -1, 0, -5, -1, 1, -5, -1,
        -5, -2, -1, 4, -2, -1,
        -5, -1, -1, 4, -1, -1,
        -5, 0, -1, 4, 0, -1,
        -5, 1, -1, 4, 1, -1,
        -2, 4, -1, -1, 4, -1, 0, 4, -1, 1, 4, -1,

        -3, -4, 0, -2, -4, 0, 1, -4, 0, 2, -4, 0,
        -4, -3, 0, -3, -3, 0, 2, -3, 0, 3, -3, 0,
        -4, -2, 0, 3, -2, 0,
        -4, 1, 0, 3, 1, 0,
        -4, 2, 0, -3, 2, 0, 2, 2, 0, 3, 2, 0,
        -3, 3, 0, -2, 3, 0, 1, 3, 0, 2, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"xbox (p6)"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, -2, 0,
        -2, 0, 0, 0, 0, 0, 2, 0, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"spider (p6)"},
#endif
	{
        -2, -2, -1,
        1, -1, -1,

        -1, -3, 0, 0, -3, 0,
        -2, -2, 0, -1, -2, 0, 0, -2, 0,
        -1, -1, 0, 0, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"spider2 (p6)"},
#endif
	{
        1, -2, -1,
        -2, -1, -1,

        -1, -3, 0,
        -2, -2, 0, -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -2, -1, 0, -1, -1, 0, 0, -1, 0, 1, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"catalyst squared (p6)"},
#endif
	{
        1, -5, -1, 2, -5, -1,
        1, -4, -1, 2, -4, -1,
        -5, -3, -1, -4, -3, -1,
        -5, -2, -1, -4, -2, -1,
        -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 0, 0, -1,
        3, 1, -1, 4, 1, -1,
        3, 2, -1, 4, 2, -1,
        -3, 3, -1, -2, 3, -1,
        -3, 4, -1, -2, 4, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"catalyst squared2 (p6)"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 0, 0, -1,

        -3, -5, 0,
        -2, -4, 0,
        4, -3, 0,
        -1, -2, 0, 0, -2, 0, 3, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -4, 1, 0, -1, 1, 0, 0, 1, 0,
        -5, 2, 0,
        1, 3, 0,
        2, 4, 0,

        -3, -5, 1, -2, -5, 1,
        4, -3, 1,
        4, -2, 1,
        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        -5, 1, 1,
        -5, 2, 1,
        1, 4, 1, 2, 4, 1,
        127
	},
#ifdef LIFE_NAMES
	{"catalyst squared3 (p6)"},
#endif
	{
        1, -6, -1,
        1, -5, -1, 2, -5, -1,
        -4, -4, -1,
        -5, -3, -1, -4, -3, -1,
        -1, -2, -1, 0, -2, -1,
        -1, -1, -1, 0, -1, -1,
        3, 0, -1, 4, 0, -1,
        3, 1, -1,
        -3, 2, -1, -2, 2, -1,
        -2, 3, -1,

        2, -6, 0,
        -5, -4, 0,
        -1, -3, 0, 0, -3, 0,
        -2, -2, 0, 1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0,
        4, 1, 0,
        -3, 3, 0,

        -1, -2, 1, 0, -2, 1,
        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"big T (p8)"},
#endif
	{
        1, -5, -2,
        1, -4, -2,
        1, 3, -2,
        1, 4, -2,

        1, -5, -1,
        1, -4, -1,
        1, 3, -1,
        1, 4, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        -2, -1, 1, 2, -1, 1,
        -2, 0, 1, 2, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"uu (p10)"},
#endif
	{
        -2, -1, -1,
        0, 1, -1,

        -2, -2, 0, -1, -2, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 1, 1, 0,

        -2, -1, 1,
        0, 1, 1,
        127
	},
};

static char patterns_26B5S38[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"double glider (diagonal p4)"},
#endif
	{
        -1, 0, -2, 0, 0, -2,
        -2, 1, -2, -1, 1, -2, 0, 1, -2, 1, 1, -2,

        -1, 0, -1, 0, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -1, -1, 0, 0, -1, 0,
        -1, 1, 0, 0, 1, 0,
        -2, 2, 0, 1, 2, 0,

        -2, -2, 1, -1, -2, 1, 0, -2, 1, 1, -2, 1,
        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,

        -2, 0, 2, 1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"tri rotor"},
#endif
	{
        -1, -1, -2, 0, -1, -2,

        -2, -1, -1, 1, -1, -1,

        -1, -2, 0, 0, -2, 0,
        -1, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"flip"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        1, 0, -1,

        -1, -1, 0,
        1, 1, 0,

        0, -1, 1, 1, -1, 1,
        1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"alternate"},
#endif
	{
        -2, -2, -1, -1, -2, -1,
        -2, -1, -1, -1, -1, -1,
        1, 0, -1,
        0, 1, -1, 1, 1, -1,

        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"drop em"},
#endif
	{
        -1, -2, -1,
        1, -1, -1,
        -2, 0, -1,
        0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"alternator"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -1, -2, -1,
        -3, -1, -1, 1, -1, -1, 2, -1, -1,
        -3, 0, -1, -2, 0, -1, 2, 0, -1,
        0, 1, -1,
        -1, 2, -1, 0, 2, -1,

        0, -2, 0,
        -2, -1, 0,
        1, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twist"},
#endif
	{
        1, -3, -1,
        -2, -2, -1,
        2, 0, -1,
        -1, 1, -1,

        0, -4, 0, 1, -4, 0,
        1, -3, 0,
        -3, -2, 0, -2, -2, 0, 0, -2, 0,
        -3, -1, 0, -1, -1, 0, 1, -1, 0, 3, -1, 0,
        0, 0, 0, 2, 0, 0, 3, 0, 0,
        -1, 1, 0,
        -1, 2, 0, 0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"twist2"},
#endif
	{
        1, -4, -1,
        -1, -3, -1, 0, -3, -1,
        -3, -2, -1, 2, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -2, 0, -1, 3, 0, -1,
        0, 1, -1, 1, 1, -1,
        -1, 2, -1,

        0, -3, 0, 1, -3, 0,
        -2, -2, 0,
        -2, -1, 0, 2, -1, 0,
        2, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"handshake (p3)"},
#endif
	{
        0, -2, -2,
        0, -1, -2,

        0, -2, -1,
        0, -1, -1,

        0, -2, 0,
        1, -1, 0,

        -1, 0, 1,
        0, 1, 1,
        0, 2, 1,

        0, 0, 2,
        0, 1, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"arena (p3)"},
#endif
	{
        -3, -4, -1, 2, -4, -1,
        -4, -3, -1, -2, -3, -1, 1, -3, -1, 3, -3, -1,
        -3, -2, -1, -2, -2, -1, 1, -2, -1, 2, -2, -1,
        -3, 1, -1, -2, 1, -1, 1, 1, -1, 2, 1, -1,
        -4, 2, -1, -2, 2, -1, 1, 2, -1, 3, 2, -1,
        -3, 3, -1, 2, 3, -1,

        -2, -4, 0, -1, -4, 0, 0, -4, 0, 1, -4, 0,
        -4, -2, 0, 3, -2, 0,
        -4, -1, 0, 3, -1, 0,
        -4, 0, 0, 3, 0, 0,
        -4, 1, 0, 3, 1, 0,
        -2, 3, 0, -1, 3, 0, 0, 3, 0, 1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"TT (p4)"},
#endif
	{
        -1, 0, 1,

        0, -1, -1,
        0, 0, -1,
        0, 1, -1,

        0, -1, 1,
        0, 0, 1,
        0, 1, 1,

        1, 0, -1,
        127
	},
#ifdef LIFE_NAMES
	{"tornado (p4)"},
#endif
	{
        -1, -3, -1,
        0, -2, -1, 2, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -2, 0, -1, 0, 0, -1,
        1, 1, -1,

        -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4T (p4)"},
#endif
	{
        0, -3, -2,
        -2, -2, -2,
        1, -1, -2,
        -1, 0, -2,

        0, -4, -1,
        0, -3, -1,
        -3, -2, -1, -2, -2, -1,
        1, -1, -1, 2, -1, -1,
        -1, 0, -1,
        -1, 1, -1,

        0, -3, 0,
        -2, -2, 0,
        1, -1, 0,
        -1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"ratchet (p4)"},
#endif
	{
        0, 0, -3,
        0, 1, -3,

        1, -1, -2, 2, -1, -2,
        0, 1, -2,

        2, -1, -1,
        -2, 1, -1,
        -2, 2, -1, -1, 2, -1,

        0, -3, 0, 1, -3, 0,
        1, -2, 0,
        -3, 0, 0,

        -1, -2, 1,
        -3, 0, 1, -2, 0, 1,

        -1, -2, 2,
        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"invert (p4)"},
#endif
	{
        -2, -2, -2, 1, -2, -2,
        -2, 1, -2, 1, 1, -2,

        -1, -3, 0, 0, -3, 0,
        -3, -1, 0, -1, -1, 0, 0, -1, 0, 2, -1, 0,
        -3, 0, 0, -1, 0, 0, 0, 0, 0, 2, 0, 0,
        -1, 2, 0, 0, 2, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, 1, -1, 1,
        -2, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"4 runners (p4)"},
#endif
	{
        -1, -4, -2, 0, -4, -2,
        -1, -3, -2,
        -4, -1, -2, 2, -1, -2, 3, -1, -2,
        -4, 0, -2, -3, 0, -2, 3, 0, -2,
        0, 2, -2,
        -1, 3, -2, 0, 3, -2,

        -1, -4, -1,
        -1, -2, -1,
        1, -1, -1, 3, -1, -1,
        -4, 0, -1, -2, 0, -1,
        0, 1, -1,
        0, 3, -1,

        -1, -3, 0,
        -1, -2, 0,
        1, -1, 0, 2, -1, 0,
        -3, 0, 0, -2, 0, 0,
        0, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4T scramble (p4)"},
#endif
	{
        -3, -3, -1, 3, -3, -1,
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,
        -3, 3, -1, 3, 3, -1,

        -2, -3, 0, 2, -3, 0,
        -3, -2, 0, -2, -2, 0, 1, -2, 0, 2, -2, 0, 3, -2, 0,
        -2, -1, 0,
        2, 1, 0,
        -3, 2, 0, -2, 2, 0, -1, 2, 0, 2, 2, 0, 3, 2, 0,
        -2, 3, 0, 2, 3, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"arena (p4)"},
#endif
	{
        -2, -5, -1, -1, -5, -1, 0, -5, -1, 1, -5, -1,
        -5, -2, -1, 4, -2, -1,
        -5, -1, -1, 4, -1, -1,
        -5, 0, -1, 4, 0, -1,
        -5, 1, -1, 4, 1, -1,
        -2, 4, -1, -1, 4, -1, 0, 4, -1, 1, 4, -1,

        -3, -4, 0, -2, -4, 0, 1, -4, 0, 2, -4, 0,
        -4, -3, 0, -3, -3, 0, 2, -3, 0, 3, -3, 0,
        -4, -2, 0, 3, -2, 0,
        -4, 1, 0, 3, 1, 0,
        -4, 2, 0, -3, 2, 0, 2, 2, 0, 3, 2, 0,
        -3, 3, 0, -2, 3, 0, 1, 3, 0, 2, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"geyser (p4)"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -2, -1, -2, 1, -1, -2,
        -2, 0, -2, 1, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -2, -3, -1, 1, -3, -1,
        -3, -2, -1, -1, -2, -1, 0, -2, -1, 2, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -3, 1, -1, -1, 1, -1, 0, 1, -1, 2, 1, -1,
        -2, 2, -1, 1, 2, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -3, 1, 0, -3, 1,
        -3, -1, 1, 2, -1, 1,
        -3, 0, 1, 2, 0, 1,
        -1, 2, 1, 0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"goal (p6)"},
#endif
	{
        3, -1, -2,
        -4, 0, -2, 3, 0, -2,
        -4, 1, -2,

        -4, 0, -1, -3, 0, -1, -1, 0, -1, 0, 0, -1, 2, 0, -1, 3, 0, -1,

        0, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0,

        -2, 0, 1, 1, 0, 1,

        -1, 0, 2, 0, 0, 2,
        127
	},
};

static char patterns_26B5S4[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"rotor"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"corner"},
#endif
	{
        0, 0, -2,

        0, -1, -1,
        -1, 0, -1,
        1, 1, -1,

        0, -2, 0,
        -1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        1, 1, 0,
        0, 2, 0,

        1, -1, 1,
        1, 0, 1,
        -1, 1, 1, 0, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"triple blinker 1"},
#endif
	{
        -1, -1, -2,
        -1, 0, -2,

        -2, -1, -1,
        1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, 0, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"triple blinker 2"},
#endif
	{
        -1, -1, -2, 0, -1, -2,

        0, -2, -1,
        1, -1, -1,
        1, 0, -1,
        -1, 1, -1,

        0, -2, 0,
        -2, -1, 0,
        -2, 0, 0,
        -1, 1, 0,

        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"hex L"},
#endif
	{
        1, -1, -4,
        1, 0, -4,
        -1, 1, -4, 0, 1, -4, 1, 1, -4,


        3, -2, -2,
        3, -1, -2,
        3, 0, -2,
        -2, 3, -2, -1, 3, -2, 0, 3, -2,

        1, -4, -1,
        3, -2, -1,
        -4, 1, -1,
        -2, 3, -1,

        1, -4, 0,
        3, -2, 0,
        -4, 1, 0,
        -2, 3, 0,

        -1, -4, 1, 0, -4, 1, 1, -4, 1,
        -4, -1, 1,
        -4, 0, 1,
        -4, 1, 1,


        -2, -2, 3, -1, -2, 3, 0, -2, 3,
        -2, -1, 3,
        -2, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"hex square"},
#endif
	{
        0, 3, -4, 1, 3, -4,

        3, -1, -3, 4, -1, -3,
        3, 0, -3, 4, 0, -3,
        2, 1, -3,
        0, 3, -3, 1, 3, -3,

        -1, 3, -2,

        3, -2, -1,
        -3, 3, -1,
        -3, 4, -1,

        3, -4, 0,
        3, -3, 0,
        -3, 3, 0,
        -3, 4, 0,

        3, -4, 1,
        3, -3, 1,
        -3, 2, 1,

        1, -3, 2,

        -1, -3, 3, 0, -3, 3,
        -2, -1, 3,
        -4, 0, 3, -3, 0, 3,
        -4, 1, 3, -3, 1, 3,

        -1, -3, 4, 0, -3, 4,
        127
	},
#ifdef LIFE_NAMES
	{"pinwheel (p4)"},
#endif
	{
        -1, 1, -1, 0, 1, -1,

        -1, -1, 0, 0, -1, 0,
        -2, 0, 0, 1, 0, 0,

        -1, 0, 1, 0, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bucking bronco (p4)"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"gate (p4)"},
#endif
	{
        0, -2, -2,
        -1, -1, -2, 0, -1, -2,

        0, -3, -1, 1, -3, -1,
        -2, -1, -1,
        -2, 0, -1,

        0, -3, 0, 1, -3, 0,
        -2, -1, 0,
        -2, 0, 0,

        0, -2, 1,
        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"swinging doors (p4)"},
#endif
	{
        0, -2, -2,
        -1, -1, -2,

        -1, -3, -1, 0, -3, -1, 1, -3, -1,
        -2, 0, -1, -1, 0, -1, 0, 0, -1,

        -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0,

        0, -2, 1,
        -1, -1, 1,
        127
	},
};

static char patterns_26B5S45[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"linked glider (diag p4)"},
#endif
	{
        0, 0, -4, 1, 0, -4,

        0, -1, -3, 1, -1, -3,
        -1, 0, -3,

        0, -1, -2, 1, -1, -2,
        -1, 0, -2,

        0, 0, -1,
        1, 1, -1,

        0, 0, 0,
        1, 1, 0,

        0, -1, 1, 1, -1, 1,
        -1, 0, 1,

        0, -1, 2, 1, -1, 2,
        -1, 0, 2,

        0, 0, 3, 1, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"crab glider (diag p7)"},
#endif
	{
        0, 0, -2, 1, 0, -2,
        0, 1, -2,

        1, -2, -1,
        2, -1, -1,
        2, 0, -1,
        -2, 1, -1,
        -1, 2, -1, 0, 2, -1,

        0, -1, 0, 2, -1, 0,
        -1, 0, 0, 0, 0, 0, 2, 0, 0,
        -1, 2, 0, 0, 2, 0,

        1, -1, 1,
        1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"glider 3 (24 cell, c/2, p4)"},
#endif
	{
        0, -1, -2,
        -2, 0, -2,
        0, 1, -2,

        0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -2, 1, -1, 1, 1, -1,
        0, 2, -1,

        1, -1, 0,
        1, 1, 0,

        0, -2, 1,
        -2, -1, 1, 1, -1, 1,
        -2, 0, 1, 1, 0, 1,
        -2, 1, 1, 1, 1, 1,
        0, 2, 1,

        0, -1, 2,
        -2, 0, 2,
        0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"zepplin (antisym 24 cell, c/2, p4)"},
#endif
	{
        -2, -3, -1,
        2, -2, -1,
        -3, 1, -1,
        1, 2, -1,

        1, -3, 0,
        -3, -2, 0,
        2, 1, 0,
        -2, 2, 0,

        -1, -3, 1, 0, -3, 1,
        -2, -2, 1, 0, -2, 1, 1, -2, 1,
        -3, -1, 1, -2, -1, 1, 2, -1, 1,
        -3, 0, 1, 1, 0, 1, 2, 0, 1,
        -2, 1, 1, -1, 1, 1, 1, 1, 1,
        -1, 2, 1, 0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"zepplin II (antisym 28 cell, c/2, p4)"},
#endif
	{
        -1, -3, -1,
        -1, -1, -1, 0, -1, -1, 2, -1, -1,
        -3, 0, -1, -1, 0, -1, 0, 0, -1,
        0, 2, -1,

        -2, -3, 0,
        2, -2, 0,
        -3, 1, 0,
        1, 2, 0,

        -1, -3, 1, 0, -3, 1,
        -2, -2, 1, -1, -2, 1, 1, -2, 1,
        -3, -1, 1, 1, -1, 1, 2, -1, 1,
        -3, 0, 1, -2, 0, 1, 2, 0, 1,
        -2, 1, 1, 0, 1, 1, 1, 1, 1,
        -1, 2, 1, 0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"glider 4 (28 cell, c/2, p2)"},
#endif
	{
        -2, -2, -2,
        -2, -1, -2, 0, -1, -2,
        -2, 1, -2, 0, 1, -2,
        -2, 2, -2,

        -2, -2, -1, 0, -2, -1,
        1, -1, -1,
        1, 0, -1,
        1, 1, -1,
        -2, 2, -1, 0, 2, -1,

        1, -1, 0,
        1, 1, 0,

        -2, -2, 1, 0, -2, 1,
        1, -1, 1,
        1, 0, 1,
        1, 1, 1,
        -2, 2, 1, 0, 2, 1,

        -2, -2, 2,
        -2, -1, 2, 0, -1, 2,
        -2, 1, 2, 0, 1, 2,
        -2, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"quad glider(32 cell, c/3, p3)"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -3, -1, -1,
        -3, 0, -1, 3, 0, -1,
        3, 1, -1,
        0, 3, -1, 1, 3, -1,

        -2, -4, 0, -1, -4, 0,
        -2, -3, 0, 1, -3, 0,
        -4, -2, 0, -3, -2, 0, 0, -2, 0, 1, -2, 0,
        -4, -1, 0, 2, -1, 0, 3, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -3, 1, 0, -2, 1, 0, 4, 1, 0,
        -1, 2, 0, 0, 2, 0, 3, 2, 0, 4, 2, 0,
        -1, 3, 0, 2, 3, 0,
        1, 4, 0, 2, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"quad glider2(32 cell, c/3, p3)"},
#endif
	{
        0, -3, -1, 1, -3, -1,
        -3, -1, -1,
        -3, 0, -1, 3, 0, -1,
        3, 1, -1,
        -1, 3, -1, 0, 3, -1,

        -1, -4, 0, 0, -4, 0,
        -1, -3, 0, 2, -3, 0,
        -3, -2, 0, -2, -2, 0, 1, -2, 0, 2, -2, 0,
        -2, -1, 0, 3, -1, 0, 4, -1, 0,
        -4, 0, 0, 4, 0, 0,
        -4, 1, 0, -3, 1, 0, 2, 1, 0,
        -2, 2, 0, -1, 2, 0, 2, 2, 0, 3, 2, 0,
        -2, 3, 0, 1, 3, 0,
        0, 4, 0, 1, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"blinker"},
#endif
	{
        0, 0, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double blinker"},
#endif
	{
        0, -1, -1,
        0, 1, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"deformed double blinker"},
#endif
	{
        0, 0, -1,
        0, 1, -1,

        0, -1, 0, 1, -1, 0,
        -1, 0, 0,
        1, 1, 0,

        0, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"three halves blinker"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -1, -1, 0,
        1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"rotor"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"gate"},
#endif
	{
        -2, -1, -1, -1, -1, -1, 0, -1, -1,
        -2, 0, -1, -1, 0, -1,

        1, 0, 1, 2, 0, 1,
        0, 1, 1, 1, 1, 1, 2, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"seesaw"},
#endif
	{
        0, 0, -2,

        -2, -1, -1, -1, -1, -1,
        -2, 0, -1,
        0, 1, -1,

        -1, -1, 0,
        1, 0, 0,
        0, 1, 0, 1, 1, 0,

        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"blink junk"},
#endif
	{
        0, -1, -1,
        -2, 0, -1, -1, 0, -1,

        0, -2, 0,
        1, -1, 0,
        -2, 0, 0,
        -1, 1, 0,

        0, -2, 1,
        1, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"beacon"},
#endif
	{
        -1, -2, -1, 0, -2, -1,
        -1, -1, -1,
        0, 0, -1,

        -1, -2, 0, 0, -2, 0,
        0, 1, 0, 1, 1, 0,

        0, -1, 1,
        1, 0, 1,
        0, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"triple blinker 1"},
#endif
	{
        -1, -1, -2,
        -1, 0, -2,

        -2, -1, -1,
        1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, 0, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"triple blinker 2"},
#endif
	{
        -1, -1, -2, 0, -1, -2,

        0, -2, -1,
        1, -1, -1,
        1, 0, -1,
        -1, 1, -1,

        0, -2, 0,
        -2, -1, 0,
        -2, 0, 0,
        -1, 1, 0,

        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"tripump"},
#endif
	{
        0, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2,

        0, -2, -1,
        -2, 0, -1,
        -2, 1, -1, -1, 1, -1,

        1, -2, 0,
        1, -1, 0,
        1, 0, 0,
        -1, 1, 0,

        0, 0, 1, 1, 0, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"windshieldwiper (helicopter)"},
#endif
	{
        -2, -1, -2, -1, -1, -2,
        0, 0, -2,

        -1, -2, -1,
        -2, -1, -1,
        1, 0, -1,
        -1, 1, -1, 0, 1, -1, 1, 1, -1,

        0, -2, 0,
        -2, -1, 0, 1, -1, 0,

        0, -2, 1,
        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"opening box"},
#endif
	{
        0, -1, -2,
        -1, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"ball"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"hex L"},
#endif
	{
        1, -1, -4,
        1, 0, -4,
        -1, 1, -4, 0, 1, -4, 1, 1, -4,


        3, -2, -2,
        3, -1, -2,
        3, 0, -2,
        -2, 3, -2, -1, 3, -2, 0, 3, -2,

        1, -4, -1,
        3, -2, -1,
        -4, 1, -1,
        -2, 3, -1,

        1, -4, 0,
        3, -2, 0,
        -4, 1, 0,
        -2, 3, 0,

        -1, -4, 1, 0, -4, 1, 1, -4, 1,
        -4, -1, 1,
        -4, 0, 1,
        -4, 1, 1,


        -2, -2, 3, -1, -2, 3, 0, -2, 3,
        -2, -1, 3,
        -2, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"hex square"},
#endif
	{
        0, 3, -4, 1, 3, -4,

        3, -1, -3, 4, -1, -3,
        3, 0, -3, 4, 0, -3,
        2, 1, -3,
        0, 3, -3, 1, 3, -3,

        -1, 3, -2,

        3, -2, -1,
        -3, 3, -1,
        -3, 4, -1,

        3, -4, 0,
        3, -3, 0,
        -3, 3, 0,
        -3, 4, 0,

        3, -4, 1,
        3, -3, 1,
        -3, 2, 1,

        1, -3, 2,

        -1, -3, 3, 0, -3, 3,
        -2, -1, 3,
        -4, 0, 3, -3, 0, 3,
        -4, 1, 3, -3, 1, 3,

        -1, -3, 4, 0, -3, 4,
        127
	},
#ifdef LIFE_NAMES
	{"magic snap (p3)"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,

        -2, -1, 0,
        1, 0, 0,

        -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -2, 0, 1, -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"cheshire (p3)"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 2, -1, 0, 2, -1,

        -1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 1, 0, 1, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        -1, 2, 1, 0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"shower (p3)"},
#endif
	{
        -1, -2, -3,
        -2, -1, -3, 0, -1, -3,
        -1, 0, -3,

        -1, -2, -2,
        -2, -1, -2,
        1, 0, -2,
        0, 1, -2,

        1, 0, -1,
        0, 1, -1,

        1, -1, 0,
        -1, 1, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,

        1, 0, 2,
        0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"clap (p3)"},
#endif
	{
        -3, 1, -2, -2, 1, -2, 2, 1, -2, 3, 1, -2,
        -2, 2, -2, 2, 2, -2,

        -4, 0, -1, 4, 0, -1,
        -4, 1, -1, -1, 1, -1, 1, 1, -1, 4, 1, -1,
        -1, 2, -1, 1, 2, -1,

        -3, -1, 0, -2, -1, 0, 2, -1, 0, 3, -1, 0,
        -4, 0, 0, -1, 0, 0, 1, 0, 0, 4, 0, 0,
        -3, 1, 0, -2, 1, 0, 2, 1, 0, 3, 1, 0,

        -2, -1, 1, 2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"blob with stabilizers (p3)"},
#endif
	{
        -1, -1, -3, 3, -1, -3,
        2, 0, -3, 3, 0, -3,

        0, -1, -2, 1, -1, -2, 3, -1, -2,
        -1, 0, -2, 3, 0, -2,

        -1, -3, -1,
        0, -2, -1,
        -3, -1, -1, 1, -1, -1,
        -2, 0, -1,
        -2, 1, -1, -1, 1, -1,
        -3, 3, -1, -2, 3, -1,

        -1, -2, 0,
        -2, -1, 0,
        -3, 2, 0,
        -3, 3, 0, -2, 3, 0,

        -1, -2, 1,
        -1, -1, 1,

        0, -3, 2,

        -1, -3, 3, 0, -3, 3,
        -1, -2, 3, 0, -2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"blob with stabilizers (variant) (p3)"},
#endif
	{
        -1, 2, -3,
        -1, 3, -3, 0, 3, -3,

        0, 0, -2,
        0, 1, -2,
        -1, 3, -2, 0, 3, -2,

        2, -3, -1, 3, -3, -1,
        3, -2, -1,
        1, 0, -1,
        0, 1, -1,

        3, -3, 0,
        0, -2, 0, 1, -2, 0, 3, -2, 0,
        1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0,
        0, 2, 0,

        0, -1, 1,
        -2, 0, 1, -1, 0, 1,

        -3, -1, 2,
        0, 0, 2,

        -3, -1, 3, -2, -1, 3,
        -3, 0, 3, -2, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"ring (p3)"},
#endif
	{
        2, 0, -5,

        3, 0, -4,
        0, 2, -4, 1, 2, -4,
        -1, 3, -4,

        2, -2, -3, 3, -2, -3,
        2, -1, -3, 3, -1, -3,
        1, 1, -3,
        0, 2, -3, 1, 2, -3,
        -1, 4, -3,

        2, -2, -2,
        -3, 2, -2, -2, 2, -2,
        -3, 3, -2,

        3, -4, -1,
        4, -3, -1,
        -3, 2, -1,
        -3, 3, -1,

        2, -4, 0,
        2, -3, 0,
        -5, 2, 0,
        -4, 3, 0,

        2, -4, 1,
        1, -3, 1, 2, -3, 1,
        -3, 1, 1,

        0, -5, 2,
        -2, -3, 2, -1, -3, 2,
        -2, -2, 2,
        -4, 0, 2, -3, 0, 2,
        -4, 1, 2, -3, 1, 2,

        0, -4, 3,
        -2, -3, 3, -1, -3, 3,
        -4, -1, 3,

        -3, -1, 4,
        127
	},
#ifdef LIFE_NAMES
	{"jack (p3)"},
#endif
	{
        -1, -1, -4,
        -1, 0, -4, 0, 0, -4,

        -1, -1, -3,
        0, 0, -3,

        -1, 0, -2,

        -1, -4, -1, 0, -4, -1,
        -1, -3, -1,
        0, -2, -1,
        -4, -1, -1, -3, -1, -1, 0, -1, -1, 2, -1, -1, 3, -1, -1,
        -1, 0, -1, 0, 0, -1, 1, 0, -1, 3, 0, -1,
        -1, 2, -1,
        -1, 3, -1,

        0, -4, 0,
        0, -3, 0,
        -4, -1, 0, -2, -1, 0, -1, -1, 0, 0, -1, 0,
        -4, 0, 0, -3, 0, 0, -1, 0, 0, 2, 0, 0, 3, 0, 0,
        -1, 1, 0,
        0, 2, 0,
        -1, 3, 0, 0, 3, 0,

        0, -1, 1,

        -1, -1, 2,
        0, 0, 2,

        -1, -1, 3, 0, -1, 3,
        0, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"puffer (p4)"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"arrow (p4)"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        1, -1, 0,
        1, 0, 0,
        0, 1, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"heart (p4)"},
#endif
	{
        -1, -1, -1,
        -1, 0, -1, 0, 0, -1,

        0, -1, 0,
        -2, 0, 0, 1, 0, 0,

        -1, -1, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pinwheel (p4)"},
#endif
	{
        -1, 1, -1, 0, 1, -1,

        -1, -1, 0, 0, -1, 0,
        -2, 0, 0, 1, 0, 0,

        -1, 0, 1, 0, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bucking bronco (p4)"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"dancing beacon2 (p4)"},
#endif
	{
        0, -2, -2, 1, -2, -2,
        0, -1, -2, 1, -1, -2,

        1, -2, -1,

        0, -1, 0,
        -2, 0, 0, 0, 0, 0,
        -2, 1, 0,

        -2, 0, 1,
        -2, 1, 1, -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"shift rotate (p4)"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1,
        1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1,

        -1, -2, 0,
        -2, -1, 0,
        0, 0, 0,

        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"swinging doors (p4)"},
#endif
	{
        0, -2, -2,
        -1, -1, -2,

        -1, -3, -1, 0, -3, -1, 1, -3, -1,
        -2, 0, -1, -1, 0, -1, 0, 0, -1,

        -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0,

        0, -2, 1,
        -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"waltzer (p6)"},
#endif
	{
        -1, -1, -1,
        -2, 0, -1,

        -1, -1, 0, 0, -1, 0,
        -2, 0, 0,
        1, 1, 0,

        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"big waltzer (p6)"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        -1, 0, -1, 0, 0, -1,
        -1, 1, -1,

        0, -2, 0, 1, -2, 0,
        -2, 0, 0,
        -2, 1, 0,

        0, -1, 1, 1, -1, 1,
        -1, 0, 1, 0, 0, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"smiley (p6)"},
#endif
	{
        -1, -1, -1, -1, -1, 0,
        -1, 1, -1, -1, 1, 0,

        0, -2, -1, 0, -2, 0,
        0, -1, -2, 0, -1, 1,
        0, 1, -2, 0, 1, 1,
        0, 2, -1, 0, 2, 0,

        1, 0, -1, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"dancing beacon (p6)"},
#endif
	{
        -2, -2, -2, -1, -2, -2,
        -2, -1, -2, -1, -1, -2,

        -2, -2, -1, 0, -1, -1,

        1, 0, 0,
        0, 1, 0, 1, 1, 0,

        1, 0, 1,
        0, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"big pinwheel (p6)"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        0, 1, -2, 1, 1, -2,

        1, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -1, 1, -1,

        1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0,

        -1, -1, 1, 0, -1, 1,
        0, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"diablo (p6)"},
#endif
	{
        0, -2, -3,
        -2, 0, -3,

        0, -3, -2,
        0, -1, -2,
        -3, 0, -2, -1, 0, -2,

        0, -2, -1,
        0, -1, -1,
        -2, 0, -1, -1, 0, -1,

        -2, -3, 0,
        -3, -2, 0, -1, -2, 0,
        -2, -1, 0, -1, -1, 0,
        1, 1, 0, 2, 1, 0,
        1, 2, 0, 3, 2, 0,
        2, 3, 0,

        1, 0, 1, 2, 0, 1,
        0, 1, 1,
        0, 2, 1,

        1, 0, 2, 3, 0, 2,
        0, 1, 2,
        0, 3, 2,

        2, 0, 3,
        0, 2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"dip (p10)"},
#endif
	{
        -1, -2, -1, 0, -2, -1,
        0, 0, -1, 1, 0, -1,

        -2, -2, 0, -1, -2, 0, 0, -2, 0,
        -1, 1, 0, 0, 1, 0, 1, 1, 0,

        -2, -1, 1, -1, -1, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pulsar 10 (p10)"},
#endif
	{
        1, -1, -2,
        -1, 0, -2, 1, 0, -2,
        -1, 1, -2,
        0, 1, -2,

        0, -2, -1, 1, -2, -1,
        -2, 1, -1, 0, 1, -1,

        1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 1, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1,
        -2, 0, 1, -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"Lq (p16)"},
#endif
	{
        -1, 1, -1, 0, 1, -1,
        -1, 2, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 1, 0, 0, 1, 0,
        -1, 2, 0,

        0, -2, 1,
        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"4 cups (p16)"},
#endif
	{
        -1, -2, -4, 0, -2, -4,
        -1, 1, -4, 0, 1, -4,

        -2, -2, -3, 1, -2, -3,
        -3, -1, -3, -2, -1, -3, -1, -1, -3,
        0, -1, -3, 1, -1, -3, 2, -1, -3,
        -3, 0, -3, -2, 0, -3, -1, 0, -3,
        0, 0, -3, 1, 0, -3, 2, 0, -3,
        -2, 1, -3, 1, 1, -3,

        -2, -2, 2, 1, -2, 2,
        -3, -1, 2, -2, -1, 2, -1, -1, 2,
        0, -1, 2, 1, -1, 2, 2, -1, 2,
        -3, 0, 2, -2, 0, 2, -1, 0, 2,
        0, 0, 2, 1, 0, 2, 2, 0, 2,
        -2, 1, 2, 1, 1, 2,

        -1, -2, 3, 0, -2, 3,
        -1, 1, 3, 0, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"pulsar 20 (p20)"},
#endif
	{
        1, 0, -2,

        0, -1, -1, 1, -1, -1,
        0, 0, -1, 2, 0, -1,
        1, 1, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, -2, 1,
        -2, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,

        -1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"collision -> redirection"},
#endif
	{
        -2, 3, -7, -1, 3, -7,
        -3, 4, -7, 0, 4, -7,
        -3, 5, -7, 0, 5, -7,

        -2, 4, -6, -1, 4, -6,
        -2, 5, -6, -1, 5, -6,

        1, -2, 1,

        1, -3, 2,
        0, -2, 2, 2, -2, 2,
        1, -1, 2,

        0, -2, 3, 2, -2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"collision -> seesaw"},
#endif
	{
        -4, -6, -7, -1, -6, -7,
        -4, -5, -7, -1, -5, -7,
        -3, -4, -7, -2, -4, -7,

        -3, -6, -6, -2, -6, -6,
        -3, -5, -6, -2, -5, -6,

        1, 4, 6, 2, 4, 6,
        0, 5, 6, 3, 5, 6,
        0, 6, 6, 3, 6, 6,

        1, 5, 5, 2, 5, 5,
        1, 6, 5, 2, 6, 5,
        127
	},
};

static char patterns_26B5S47[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"glider orthogonal (p8)"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2, 1, -1, -2,
        -2, 0, -2, -1, 0, -2, 0, 0, -2, 1, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -2, -2, 0, 1, -2, 0,
        -2, 1, 0, 1, 1, 0,

        -2, -2, 1, 1, -2, 1,
        -4, -1, 1, 3, -1, 1,
        -4, 0, 1, 3, 0, 1,
        -2, 1, 1, 1, 1, 1,

        -1, -3, 2, 0, -3, 2,
        -2, -2, 2, -1, -2, 2, 0, -2, 2, 1, -2, 2,
        -3, -1, 2, 2, -1, 2,
        -3, 0, 2, 2, 0, 2,
        -2, 1, 2, -1, 1, 2, 0, 1, 2, 1, 1, 2,
        -1, 2, 2, 0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"rotor"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"corner"},
#endif
	{
        0, 0, -2,

        0, -1, -1,
        -1, 0, -1,
        1, 1, -1,

        0, -2, 0,
        -1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        1, 1, 0,
        0, 2, 0,

        1, -1, 1,
        1, 0, 1,
        -1, 1, 1, 0, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"triple blinker 1"},
#endif
	{
        -1, -1, -2,
        -1, 0, -2,

        -2, -1, -1,
        1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, 0, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"triple blinker 2"},
#endif
	{
        -1, -1, -2, 0, -1, -2,

        0, -2, -1,
        1, -1, -1,
        1, 0, -1,
        -1, 1, -1,

        0, -2, 0,
        -2, -1, 0,
        -2, 0, 0,
        -1, 1, 0,

        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"hex L"},
#endif
	{
        1, -1, -4,
        1, 0, -4,
        -1, 1, -4, 0, 1, -4, 1, 1, -4,


        3, -2, -2,
        3, -1, -2,
        3, 0, -2,
        -2, 3, -2, -1, 3, -2, 0, 3, -2,

        1, -4, -1,
        3, -2, -1,
        -4, 1, -1,
        -2, 3, -1,

        1, -4, 0,
        3, -2, 0,
        -4, 1, 0,
        -2, 3, 0,

        -1, -4, 1, 0, -4, 1, 1, -4, 1,
        -4, -1, 1,
        -4, 0, 1,
        -4, 1, 1,


        -2, -2, 3, -1, -2, 3, 0, -2, 3,
        -2, -1, 3,
        -2, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"hex square"},
#endif
	{
        0, 3, -4, 1, 3, -4,

        3, -1, -3, 4, -1, -3,
        3, 0, -3, 4, 0, -3,
        2, 1, -3,
        0, 3, -3, 1, 3, -3,

        -1, 3, -2,

        3, -2, -1,
        -3, 3, -1,
        -3, 4, -1,

        3, -4, 0,
        3, -3, 0,
        -3, 3, 0,
        -3, 4, 0,

        3, -4, 1,
        3, -3, 1,
        -3, 2, 1,

        1, -3, 2,

        -1, -3, 3, 0, -3, 3,
        -2, -1, 3,
        -4, 0, 3, -3, 0, 3,
        -4, 1, 3, -3, 1, 3,

        -1, -3, 4, 0, -3, 4,
        127
	},
#ifdef LIFE_NAMES
	{"bracelet"},
#endif
	{
        1, 0, -3,
        0, 1, -3, 1, 1, -3,

        2, -1, -2,
        2, 1, -2,
        -1, 2, -2, 1, 2, -2,

        2, -2, -1,
        3, -1, -1,
        3, 0, -1,
        -2, 2, -1,
        -1, 3, -1, 0, 3, -1,

        1, -3, 0,
        3, -1, 0,
        -3, 1, 0,
        -1, 3, 0,

        0, -3, 1, 1, -3, 1,
        2, -2, 1,
        -3, 0, 1,
        -3, 1, 1,
        -2, 2, 1,

        -1, -2, 2, 1, -2, 2,
        -2, -1, 2,
        -2, 1, 2,

        -1, -1, 3, 0, -1, 3,
        -1, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"hex blocks"},
#endif
	{
        0, 0, -3, 1, 0, -3,
        0, 1, -3, 1, 1, -3,

        0, 0, -2,

        3, -1, -1,
        3, 0, -1,
        -1, 3, -1, 0, 3, -1,

        0, -3, 0, 1, -3, 0,
        0, -2, 0,
        3, -1, 0,
        -3, 0, 0, -2, 0, 0, 2, 0, 0, 3, 0, 0,
        -3, 1, 0,
        0, 2, 0,
        -1, 3, 0, 0, 3, 0,

        0, -3, 1, 1, -3, 1,
        -3, 0, 1,
        -3, 1, 1,

        0, 0, 2,

        -1, -1, 3, 0, -1, 3,
        -1, 0, 3, 0, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"paddles (p3)"},
#endif
	{
        -1, -1, -2, 2, -1, -2,
        -3, 0, -2, 0, 0, -2,

        2, -2, -1, 0, -2, -1,
        -2, -1, -1,
        1, 0, -1,
        -3, 1, -1, -1, 1, -1,

        0, -2, 0, 2, -2, 0,
        -2, -1, 0,
        1, 0, 0,
        -3, 1, 0, -1, 1, 0,

        2, -1, 1, -1, -1, 1,
        -3, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pinwheel (p4)"},
#endif
	{
        -1, 1, -1, 0, 1, -1,

        -1, -1, 0, 0, -1, 0,
        -2, 0, 0, 1, 0, 0,

        -1, 0, 1, 0, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bucking bronco (p4)"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"gate (p4)"},
#endif
	{
        0, -2, -2,
        -1, -1, -2, 0, -1, -2,

        0, -3, -1, 1, -3, -1,
        -2, -1, -1,
        -2, 0, -1,

        0, -3, 0, 1, -3, 0,
        -2, -1, 0,
        -2, 0, 0,

        0, -2, 1,
        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"dog paddle (p4)"},
#endif
	{
        0, -2, -2,
        0, -1, -2,

        -1, -2, -1,
        0, -1, -1, 1, -1, -1,

        1, -1, 0,
        -1, 0, 0, 1, 0, 0,

        -1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        0, 2, 1,

        1, 1, 2,
        0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"swinging doors (p4)"},
#endif
	{
        0, -2, -2,
        -1, -1, -2,

        -1, -3, -1, 0, -3, -1, 1, -3, -1,
        -2, 0, -1, -1, 0, -1, 0, 0, -1,

        -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0,

        0, -2, 1,
        -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"T-Ball (p4)"},
#endif
	{
        -1, -2, -2, 1, -2, -2,
        -2, -1, -2, 0, -1, -2, 2, -1, -2,
        -2, 1, -2, 0, 1, -2, 2, 1, -2,
        -1, 2, -2, 1, 2, -2,

        -2, -2, -1, 2, -2, -1,
        -2, 0, -1, 2, 0, -1,
        -2, 2, -1, 2, 2, -1,

        -1, -2, 0, 1, -2, 0,
        -1, 2, 0, 1, 2, 0,

        -2, -2, 1, 2, -2, 1,
        -2, 0, 1, 2, 0, 1,
        -2, 2, 1, 2, 2, 1,

        -1, -2, 2, 1, -2, 2,
        -2, -1, 2, 0, -1, 2, 2, -1, 2,
        -2, 1, 2, 0, 1, 2, 2, 1, 2,
        -1, 2, 2, 1, 2, 2,
        127
	},
};

static char patterns_26B5S56[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"glider 2 (32 cell, 3c/4, p4)"},
#endif
	{
        -1, -2, -3,
        1, -1, -3,
        1, 0, -3,
        -1, 1, -3,

        -1, -3, -2,
        -2, -1, -2,
        -2, 0, -2,
        -1, 2, -2,

        1, -3, -1,
        -2, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -2, 1, -1,
        1, 2, -1,

        1, -3, 0,
        -2, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -2, 1, 0,
        1, 2, 0,

        -1, -3, 1,
        -2, -1, 1,
        -2, 0, 1,
        -1, 2, 1,

        -1, -2, 2,
        1, -1, 2,
        1, 0, 2,
        -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"void glider (32 cell, c/3, p3)"},
#endif
	{
        -1, -3, -2, 0, -3, -2,
        -2, -2, -2,
        -2, -1, -2, 2, -1, -2,
        2, 0, -2,
        0, 1, -2, 1, 1, -2,

        0, -4, -1,
        1, -3, -1,
        2, -2, -1,
        -3, -1, -1, 3, -1, -1,
        -2, 0, -1,
        -1, 1, -1,
        0, 2, -1,

        -1, -4, 0, 0, -4, 0,
        -1, -3, 0, 0, -3, 0,
        -3, -2, 0, -2, -2, 0,
        -3, -1, 0, -2, -1, 0, 2, -1, 0, 3, -1, 0,
        2, 0, 0, 3, 0, 0,
        0, 1, 0, 1, 1, 0,
        0, 2, 0, 1, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"mosquito"},
#endif
	{
        0, 0, -1,
        -1, -1, 0,
        -1, 0, 0, 0, 0, 0,
        -1, 1, 0,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"prop"},
#endif
	{
        -1, 0, -1, 0, 0, -1, 1, 0, -1,

        0, -1, 0,
        0, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"seesaw"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 0, 0, -1,

        0, 0, 0, 1, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"arrow"},
#endif
	{
        -1, -1, -1,
        -1, 0, -1,

        1, -1, 0,
        0, 0, 0, 1, 0, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"broken seesaw"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 0, 0, -1,

        1, -1, 0,
        0, 0, 0, 1, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"column"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 0, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, 0, 0,

        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"small rower"},
#endif
	{
        -1, 0, -1, 0, 0, -1, 1, 0, -1,

        -1, -1, 0, 0, -1, 0, 1, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"small rower alternate"},
#endif
	{
        1, -1, -1,
        -1, 0, -1, 0, 0, -1,

        -1, -1, 0, 0, -1, 0,
        0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"runner"},
#endif
	{
        0, -1, -1,
        -1, 0, -1,

        -1, -1, 0, 0, -1, 0,
        -1, 0, 0,

        -1, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"s"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        0, 0, -1, 1, 0, -1,

        -1, -1, 0,
        0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"stinging mosquito"},
#endif
	{
        0, 0, -1,
        0, 1, -1, 1, 1, -1,

        0, -1, 0,
        -1, 0, 0, 0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"double blinker"},
#endif
	{
        0, 0, -1,
        0, 1, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,

        0, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2C"},
#endif
	{
        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,
        1, 1, -1,

        -1, -1, 0, 1, -1, 0,
        1, 1, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2C2"},
#endif
	{
        -2, -1, -1, 0, -1, -1,
        -1, 1, -1, 0, 1, -1, 1, 1, -1,

        -2, -1, 0, -1, -1, 0, 0, -1, 0,
        -1, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"2S"},
#endif
	{
        0, 0, -2,
        0, 1, -2,

        -2, 0, -1, -1, 0, -1,
        0, 1, -1,

        -1, 0, 0,
        0, 1, 0,
        0, 2, 0,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"clock"},
#endif
	{
        -1, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -2, 0, -1, 0, 0, -1,
        0, 1, -1,

        -1, -2, 0,
        1, -1, 0,
        -2, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"clock2"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        0, -1, -1,

        -1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bat"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        -1, 0, -1,
        -1, 1, -1,

        0, -2, 0, 1, -2, 0,
        0, -1, 0,
        -2, 0, 0, -1, 0, 0,
        -2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"deformed stairs"},
#endif
	{
        1, -1, -2,
        1, 0, -2,

        0, -1, -1,
        0, 0, -1, 1, 0, -1,

        -2, -1, 0, -1, -1, 0,
        -2, 0, 0, -1, 0, 0,

        -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"deformed stairs 2"},
#endif
	{
        0, -1, -2, 1, -1, -2,
        0, 0, -2,

        0, -1, -1,
        0, 0, -1,

        -1, -1, 0,
        -1, 0, 0,

        -1, -1, 1,
        -2, 0, 1, -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"runner"},
#endif
	{
        -1, -2, -1, 0, -2, -1,
        0, -1, -1,

        -1, -1, 0, 0, -1, 0,

        -1, 0, 1, 0, 0, 1,
        0, 1, 1,

        -1, 1, 2, 0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"backwards runner"},
#endif
	{
        -1, -2, -1, 0, -2, -1,
        0, -1, -1,

        -1, -1, 0, 0, -1, 0,

        -1, 0, 1, 0, 0, 1,
        -1, 1, 1,

        -1, 0, 2, 0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"pinwheel"},
#endif
	{
        -1, -1, -2,
        -1, -1, -1,
        0, -1, -1,
        -1, 1, -1,
        0, 1, -1,
        -1, -1, 0,
        0, -1, 0,
        -1, 1, 0,
        0, 1, 0,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pinwheel2"},
#endif
	{
        0, -1, -2,
        0, -1, -1,
        1, -1, -1,
        -2, 0, -1,
        -1, 0, -1,
        0, -1, 0,
        1, -1, 0,
        -2, 0, 0,
        -1, 0, 0,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pump"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        0, 0, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,

        -1, -1, 1, 0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"rubber band"},
#endif
	{
        0, -1, -1,
        1, -1, -1,
        -1, 0, -1,
        0, 0, -1,
        1, -1, 0,
        -1, 0, 0,
        0, -1, 1,
        1, -1, 1,
        -1, 0, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"eagle"},
#endif
	{
        0, -2, -1, 1, -2, -1,
        0, -1, -1, 1, -1, -1,
        0, 1, -1, 1, 1, -1,
        0, 2, -1, 1, 2, -1,

        0, -1, 0,
        -1, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"gorilla"},
#endif
	{
        -1, 0, -1, 1, 0, -1,
        -1, 1, -1, 1, 1, -1,

        0, -1, 0,
        -2, 0, 0, -1, 0, 0, 1, 0, 0, 2, 0, 0,
        -2, 1, 0, 2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"variant 1"},
#endif
	{
        1, -1, -2,
        0, 0, -2,

        0, -1, -1,
        0, 0, -1, 1, 0, -1,

        -1, -1, 0,

        0, -1, 1,
        0, 0, 1, 1, 0, 1,

        1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"variant 2"},
#endif
	{
        0, -1, -2,
        1, 0, -2,

        0, -1, -1, 1, -1, -1,
        0, 0, -1,

        -1, 0, 0,

        0, -1, 1,
        0, 0, 1, 1, 0, 1,

        1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"variant 3"},
#endif
	{
        1, -1, -2,
        0, 0, -2,

        0, -1, -1, 1, -1, -1,
        0, 0, -1,

        -1, -1, 0,

        0, -1, 1,
        0, 0, 1, 1, 0, 1,

        1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"variant 4"},
#endif
	{
        1, -1, -2,
        0, 0, -2,

        0, -1, -1, 1, -1, -1,
        0, 0, -1,

        -1, 0, 0,

        0, -1, 1,
        0, 0, 1, 1, 0, 1,

        1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"rower"},
#endif
	{
        0, 1, -2,

        -1, -1, -1, 1, -1, -1,
        -2, 0, -1, -1, 0, -1, 1, 0, -1, 2, 0, -1,

        -1, 0, 0, 1, 0, 0,
        -1, 1, 0, 1, 1, 0,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"rocker"},
#endif
	{
        0, 0, -2,
        0, 1, -2,

        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -1, 0, 0, 1, 0, 0,
        -1, 1, 0, 1, 1, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"switch"},
#endif
	{
        2, -1, -2,
        1, 0, -2, 2, 0, -2,

        1, -1, -1, 2, -1, -1,
        1, 0, -1,

        1, 0, 0,

        -1, -1, 1,
        -2, 0, 1, -1, 0, 1, 0, 0, 1,

        -2, -1, 2, -1, -1, 2,
        -2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"capacitor"},
#endif
	{
        0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        0, 0, -1, 1, 0, -1,
        0, 1, -1, 1, 1, -1,

        0, 0, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1,

        0, -1, 2,
        -1, 0, 2, 0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"ss"},
#endif
	{
        1, -2, -1, 2, -2, -1,
        1, -1, -1, 2, -1, -1,
        -2, 1, -1, -1, 1, -1,
        -2, 2, -1, -1, 2, -1,

        2, -1, 0,
        1, 0, 0, 2, 0, 0,
        0, 1, 0,
        -1, 2, 0, 0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"flip"},
#endif
	{
        -1, -2, -2,
        0, -1, -2,
        0, 0, -2,

        -1, -2, -1,
        -2, -1, -1, 1, -1, -1,
        1, 0, -1,
        1, 1, -1,

        -1, -2, 0,
        -2, -1, 0,
        -1, 1, 0, 0, 1, 0,

        -2, 0, 1, -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"squid"},
#endif
	{
        -2, -1, -2, -1, -1, -2,
        1, 1, -2,
        1, 2, -2,

        -2, -1, -1, -1, -1, -1, 0, -1, -1,
        1, 0, -1,
        1, 1, -1,
        1, 2, -1,

        -1, -1, 0,
        1, 1, 0,

        -1, 0, 1,
        -2, 1, 1, -1, 1, 1, 0, 1, 1,
        -2, 2, 1, -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"3 columns"},
#endif
	{
        0, 0, -6,

        0, 0, -5,

        0, -1, -4,
        -1, 0, -4, 0, 0, -4, 1, 0, -4,
        0, 1, -4,

        0, -1, -1,
        -1, 0, -1, 0, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, 0, 0,

        0, 0, 1,

        0, 0, 2,

        0, 0, 3,

        0, -1, 4,
        -1, 0, 4, 0, 0, 4, 1, 0, 4,
        0, 1, 4,
        127
	},
#ifdef LIFE_NAMES
	{"corner 1"},
#endif
	{
        -1, -3, -3,
        -1, -2, -3, 0, -2, -3,
        1, -1, -3,
        1, 0, -3, 2, 0, -3,

        -1, -3, -2,
        0, -2, -2,
        1, -1, -2,
        2, 0, -2,

        -3, -3, -1, -2, -3, -1,
        -3, -2, -1,
        2, 1, -1,
        1, 2, -1, 2, 2, -1,

        -3, -2, 0, -2, -2, 0,
        1, 1, 0,
        1, 2, 0,

        -3, -1, 1, -2, -1, 1,
        -3, 0, 1,
        0, 1, 1,
        -1, 2, 1, 0, 2, 1,

        -3, 0, 2, -2, 0, 2,
        -1, 1, 2,
        -1, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"corner 2"},
#endif
	{
        -2, -2, -3, -1, -2, -3,
        -2, -1, -3,
        2, 1, -3,
        1, 2, -3, 2, 2, -3,

        -3, -2, -2, -1, -2, -2,
        -3, -1, -2, 0, -1, -2,
        1, 0, -2,
        2, 1, -2,
        1, 3, -2, 2, 3, -2,

        -3, -2, -1, -2, -2, -1,
        0, -1, -1,
        1, 0, -1,
        2, 2, -1,
        2, 3, -1,

        -2, -1, 0, -1, -1, 0,
        1, 1, 0,
        1, 2, 0,

        -2, 0, 1, -1, 0, 1,
        0, 1, 1,
        -3, 2, 1, 0, 2, 1,
        -2, 3, 1,

        -3, 1, 2, -2, 1, 2,
        -3, 2, 2, -1, 2, 2,
        -2, 3, 2, -1, 3, 2,
        127
	},
#ifdef LIFE_NAMES
	{"H (p3)"},
#endif
	{
        -1, -2, 0, 0, -2, 0, 1, -2, 0,
        0, -1, 0,
        -1, 0, 0, 0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"1 leg walker (p4)"},
#endif
	{
        0, 1, -2,
        -1, 2, -2, 0, 2, -2,

        -1, 1, -1, 0, 1, -1,
        -1, 2, -1,

        0, -2, 0,
        0, -1, 0, 1, -1, 0,
        1, 0, 0,

        1, -2, 1,
        1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2 enemies (p4)"},
#endif
	{
        -1, -2, -1, 0, -2, -1,
        0, 2, -1, 1, 2, -1,

        0, -2, 0,
        -1, -1, 0, 0, -1, 0,
        0, 1, 0, 1, 1, 0,
        1, 2, 0,

        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"W (p4)"},
#endif
	{
        -1, -2, -1,
        1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        0, 1, -1, 2, 1, -1,

        -1, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0,
        0, 1, 0, 2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"W2 (p4)"},
#endif
	{
        0, -1, -2,
        0, 0, -2,

        1, -1, -1,
        0, 0, -1, 1, 0, -1,

        -2, -1, 0,
        -2, 0, 0,

        -1, -1, 1, 0, -1, 1,
        0, 0, 1,

        -1, -1, 2,
        -1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"beacon (p4)"},
#endif
	{
        1, -2, -1, 2, -2, -1,
        1, -1, -1, 2, -1, -1,
        2, -2, 0,
        0, -1, 0, 2, -1, 0,
        -1, 0, 0,
        -2, 1, 0, -1, 1, 0,
        -2, 0, 1, -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"beacon2 (p4)"},
#endif
	{
        2, -2, -1,
        1, -1, -1, 2, -1, -1,
        1, -2, 0, 2, -2, 0,
        0, -1, 0, 2, -1, 0,
        -1, 0, 0,
        -2, 1, 0, -1, 1, 0,
        -2, 0, 1, -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"friend with stabilizer (p4)"},
#endif
	{
        -2, 0, -2, -1, 0, -2,

        -2, 0, -1, -1, 0, -1,
        -1, 1, -1,

        1, -1, 0,
        1, 0, 0,
        -1, 1, 0,

        0, -1, 1, 1, -1, 1,
        0, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double switch (p4)"},
#endif
	{
        -2, -3, -1,
        -1, -2, -1,
        -2, -1, -1, -1, -1, -1,

        -1, -3, 0,
        -2, -2, 0, -1, -2, 0,
        -1, 0, 0,

        0, 1, 0, 1, 1, 0,
        0, 2, 0,

        0, 1, 1,
        1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double switch2 (p4)"},
#endif
	{
        -1, 0, -3,
        0, 1, -3,

        -1, 0, -2, 0, 0, -2,
        0, 1, -2,

        -1, 0, -1,
        0, 1, -1,

        0, -1, 0,

        0, -2, 1,
        0, -1, 1, 1, -1, 1,
        1, -2, 2,

        0, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"3 friends (p4)"},
#endif
	{
        2, -1, -3,
        1, 0, -3,

        1, -1, -2,
        0, 0, -2, 1, 0, -2, 2, 0, -2,

        -2, 1, -1,
        -3, 2, -1,

        0, -2, 0,
        -2, 0, 0,
        -3, 1, 0, -2, 1, 0,
        -2, 2, 0,

        0, -3, 1,
        -1, -2, 1, 0, -2, 1,

        -1, -3, 2,
        0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"stuff with 3 stabilizers (p4)"},
#endif
	{
        -2, 2, -3, -1, 2, -3,
        -2, 3, -3, -1, 3, -3,

        2, -3, -2, 3, -3, -2,
        2, -2, -2, 3, -2, -2,
        -2, 2, -2,
        -2, 3, -2,

        2, -3, -1, 3, -3, -1,
        2, -1, -1,
        0, 0, -1,
        0, 1, -1,
        -1, 2, -1,

        0, -1, 0, 1, -1, 0,
        -1, 0, 0,

        -1, 0, 1,

        -3, -2, 2, -2, -2, 2,
        -3, -1, 2, -1, -1, 2,

        -3, -2, 3, -2, -2, 3,
        -3, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"invert (p6)"},
#endif
	{
        -1, -3, -2, 1, -3, -2,
        -2, -2, -2, -1, -2, -2, 1, -2, -2, 2, -2, -2,
        -2, 0, -2, -1, 0, -2, 1, 0, -2, 2, 0, -2,
        -1, 1, -2, 1, 1, -2,

        -1, -3, -1, 1, -3, -1,
        -2, -2, -1, -1, -2, -1, 1, -2, -1, 2, -2, -1,
        -2, 0, -1, -1, 0, -1, 1, 0, -1, 2, 0, -1,
        -1, 1, -1, 1, 1, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"corner (p6)"},
#endif
	{
        1, 1, -3,
        2, 2, -3,

        2, 1, -2,
        1, 2, -2, 2, 2, -2,

        1, 1, -1,
        2, 2, -1,

        2, 1, 0,

        1, -3, 1,
        2, -2, 1,
        1, -1, 1,
        -3, 1, 1, -1, 1, 1,
        -2, 2, 1, 0, 2, 1, 2, 2, 1,

        2, -3, 2,
        1, -2, 2, 2, -2, 2,
        2, -1, 2,
        1, 0, 2,
        -2, 1, 2, 2, 1, 2,
        -3, 2, 2, -2, 2, 2, -1, 2, 2, 1, 2, 2,
        127
	},
};

static char patterns_26B5S58[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"crate"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -1, -1, -2, 0, -1, -2,

        -1, -3, -1, 0, -3, -1,
        -2, -2, -1, 1, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -1, 0, -1, 0, 0, -1,

        -1, -3, 0, 0, -3, 0,
        -2, -2, 0, 1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0,

        -1, -2, 1, 0, -2, 1,
        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"folding cubes (p4)"},
#endif
	{
        -1, -2, -1,
        -1, -1, -1,
        1, 0, -1,
        1, 1, -1,

        -1, -3, 0,
        -1, -2, 0, 0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0, 1, 1, 0,
        1, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"3 runners (p4)"},
#endif
	{
        2, -1, -3,
        1, 0, -3,

        0, 0, -2, 1, 0, -2, 2, 0, -2,
        1, -1, -2,

        -2, 1, -1,
        -3, 2, -1,

        0, -2, 0,
        -2, 0, 0,
        -3, 1, 0, -2, 1, 0,
        -2, 2, 0,

        0, -3, 1,
        -1, -2, 1, 0, -2, 1,

        -1, -3, 2,
        0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"paddle wheel (p4)"},
#endif
	{
        -2, -1, -1, 2, -1, -1,
        -2, 1, -1, -1, 1, -1, 0, 1, -1, 1, 1, -1, 2, 1, -1,

        -3, -1, 0, 3, -1, 0,
        -3, 0, 0, -1, 0, 0, 1, 0, 0, 3, 0, 0,
        -2, 1, 0, -1, 1, 0, 0, 1, 0, 1, 1, 0, 2, 1, 0,

        -2, 0, 1, 2, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"6 runners (p4)"},
#endif
	{
        -1, 1, -4, 0, 1, -4,

        -1, 1, -3, 0, 1, -3,
        0, 2, -3,

        2, 0, -2, 3, 0, -2,
        0, 2, -2,

        1, -4, -1,
        1, -3, -1,
        3, 0, -1, 4, 0, -1,
        3, 1, -1, 4, 1, -1,

        1, -4, 0,
        1, -3, 0, 2, -3, 0,
        2, -2, 0,
        -2, 2, 0,
        -2, 3, 0, -1, 3, 0,
        -1, 4, 0,

        -4, -1, 1, -3, -1, 1,
        -4, 0, 1, -3, 0, 1,
        -1, 3, 1,
        -1, 4, 1,

        0, -2, 2,
        -3, 0, 2, -2, 0, 2,

        0, -2, 3,
        0, -1, 3, 1, -1, 3,

        0, -1, 4, 1, -1, 4,
        127
	},
#ifdef LIFE_NAMES
	{"6 runners2 (p4)"},
#endif
	{
        1, 1, -4, 2, 1, -4,
        1, 2, -4, 2, 2, -4,

        3, -3, -3,
        3, -2, -3,
        1, 0, -3,
        1, 1, -3,
        -3, 3, -3, -2, 3, -3,

        3, -3, -2,
        2, -2, -2, 3, -2, -2,
        -2, 2, -2, -1, 2, -2,
        -3, 3, -2, -2, 3, -2,

        2, -2, -1,

        -3, 1, 0,

        1, -4, 1, 2, -4, 1,
        0, -3, 1, 1, -3, 1,
        -4, 1, 1, -3, 1, 1,
        -4, 2, 1,

        1, -4, 2, 2, -4, 2,
        -2, -2, 2,
        -2, -1, 2,
        -4, 1, 2,
        -4, 2, 2,

        -3, -3, 3, -2, -3, 3,
        -3, -2, 3, -2, -2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"cc (p10)"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -1, -2, -1, 0, -2, -1,
        -1, 2, -1, 0, 2, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -3, 1, 0, -3, 1,
        -1, -2, 1, 0, -2, 1,
        -1, 1, 1, 0, 1, 1,
        -1, 2, 1, 0, 2, 1,
        127
	},
};

static char patterns_26B5S678[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"double glider (24 cell diagonal, p2)"},
#endif
	{
        1, -2, -2,
        2, 0, -2,
        -2, 1, -2,
        0, 2, -2,

        0, -2, -1, 1, -2, -1,
        0, -1, -1, 1, -1, -1,
        -2, 0, -1, -1, 0, -1,
        -2, 1, -1, -1, 1, -1,

        0, -2, 0, 1, -2, 0,
        0, -1, 0, 1, -1, 0,
        -2, 0, 0, -1, 0, 0,
        -2, 1, 0, -1, 1, 0,

        1, -2, 1,
        2, 0, 1,
        -2, 1, 1,
        0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"orthogonal glider (24 cell, c/2, p4)"},
#endif
	{
        0, -3, -1,
        -2, -2, -1,
        1, -1, -1,
        -1, 0, -1,

        -1, -4, 0, 0, -4, 0,
        -2, -3, 0, -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -3, -2, 0, -2, -2, 0, 1, -2, 0, 2, -2, 0,
        -3, -1, 0, -2, -1, 0, 1, -1, 0, 2, -1, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"small arrow"},
#endif
	{
        -1, -1, -1,
        0, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -1, 0,
        1, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"little runner"},
#endif
	{
        0, -1, -1,
        0, 0, -1,
        -1, 1, -1,

        -1, -1, 0,
        -1, 0, 0, 0, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"s"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        0, 0, -1, 1, 0, -1,

        -1, -1, 0,
        0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"rower"},
#endif
	{
        -1, -1, -1,
        -1, 0, -1, 0, 0, -1,
        -1, 1, -1,

        0, -1, 0,
        -1, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"corner"},
#endif
	{
        1, -1, -1,
        0, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        1, 0, 0,
        0, 1, 0, 1, 1, 0,
        1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"arrow"},
#endif
	{
        -1, -1, -1,
        -1, 1, -1,

        0, -1, 0,
        -1, 0, 0, 0, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, -1, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2C"},
#endif
	{
        1, -2, -1,
        -1, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -1, 1, -1,

        1, -2, 0,
        -1, -1, 0, 1, -1, 0,
        1, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"tiny pump"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"deformed runner"},
#endif
	{
        0, -1, -2, 1, -1, -2,

        0, -1, -1,
        0, 0, -1,
        -1, 1, -1,

        0, -2, 0,
        -1, -1, 0,
        -1, 0, 0,

        -2, 0, 1, -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2 friends"},
#endif
	{
        0, -2, -2,
        -1, -1, -2,
        0, -1, -2,
        -1, -1, -1, 0, -1, -1,
        -1, 0, 0, 0, 0, 0,
        -1, 1, 0, 0, 1, 0,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"2 friends2"},
#endif
	{
        -1, -1, -2,

        -2, -1, -1, -1, -1, -1,
        -2, 0, -1, -1, 0, -1,

        0, -1, 0,
        0, 0, 0, 1, 0, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bird"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -2, 0, -1, 0, 0, -1, 1, 0, -1,

        -1, -1, 0, 0, -1, 0,
        -2, 0, 0, -1, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"bat"},
#endif
	{
        -1, -2, -2,
        0, -1, -2,

        -1, -2, -1,
        -1, -1, -1, 0, -1, -1,

        -1, 0, 0, 0, 0, 0,
        0, 1, 0,

        -1, 0, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bug jumping jack"},
#endif
	{
        0, -1, -2, 1, -1, -2,
        0, -1, -1,
        0, 0, -1,
        -1, 1, -1,
        0, -2, 0,
        -1, -1, 0,
        -1, 0, 0,
        -2, 0, 1, -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"dali clock"},
#endif
	{
        0, 0, -2,

        0, -2, -1,
        -2, -1, -1, 0, -1, -1,
        0, 0, -1,

        -1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0,

        -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"deformed walker"},
#endif
	{
        -1, -2, -1,
        -2, -1, -1, -1, -1, -1,
        0, 0, -1, 1, 0, -1,

        -2, -2, 0,
        -1, -1, 0,
        0, 0, 0,
        0, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"flattened snake"},
#endif
	{
        -2, 0, -1, -1, 0, -1, 0, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -1, -1, 0, 0, -1, 0, 1, -1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"open_wide"},
#endif
	{
        -1, -1, -2,

        -1, -1, -1, 0, -1, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -1, 0, 0, -1, 0,
        -1, 1, 0, 0, 1, 0,

        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"peek-a-boo"},
#endif
	{
        0, 0, -2,

        -1, 0, -1, 0, 0, -1,
        -1, 1, -1, 0, 1, -1,

        0, -2, 0,
        -1, -1, 0, 0, -1, 0,

        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"roll over"},
#endif
	{
        -2, -2, -1,
        -1, -1, -1,
        0, 0, -1,
        1, 1, -1,

        -1, -2, 0,
        -2, -1, 0, -1, -1, 0,
        0, 0, 0, 1, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"roll over2"},
#endif
	{
        -1, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"switch"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        0, -1, 0,
        -1, 0, 0,
        0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"tiny star"},
#endif
	{
        -1, 0, -1, 0, 0, -1,
        0, 1, -1,

        1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0,

        0, -1, 1,
        0, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"switch2"},
#endif
	{
        0, -1, -2, 1, -1, -2,

        0, -1, -1,
        0, 0, -1,
        0, 1, -1,

        0, -2, 0,
        -1, -1, 0,
        -1, 0, 0, 1, 0, 0,

        0, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"confused pile driver"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"small pump"},
#endif
	{
        -1, 1, 0, 0, 1, 0,
        -2, 0, 0, 0, 0, 0, 1, 0, 0,
        -2, -1, 0, -1, -1, 0, 1, -1, 0,
        -1, -2, 0, 0, -2, 0,

        0, 0, 1,
        -1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"frilly"},
#endif
	{
        -1, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        0, -2, 0,
        0, -1, 0, 1, -1, 0,
        -2, 0, 0, -1, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"frilly2"},
#endif
	{
        0, -1, -2,
        -1, 0, -2,

        0, -1, -1, 1, -1, -1,
        -2, 0, -1, -1, 0, -1,

        -2, -1, 0, 0, -1, 0,
        -1, 0, 0, 1, 0, 0,

        0, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"thingamajig"},
#endif
	{
        -1, -1, -2,
        0, 0, -2,

        0, -2, -1,
        -1, -1, -1,
        0, 0, -1,
        -1, 1, -1,

        0, -1, 0, 1, -1, 0,
        -2, 0, 0, -1, 0, 0,

        0, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spinning table"},
#endif
	{
        -1, -1, -2,
        -1, 0, -2,
        0, -2, -1,
        -1, -1, -1,
        -1, 0, -1,
        0, 1, -1,
        0, -2, 0,
        -1, -1, 0,
        -1, 0, 0,
        0, 1, 0,
        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"collapsing armchair"},
#endif
	{
        -2, -1, -1, 0, -1, -1, 1, -1, -1,
        -2, 0, -1, 0, 0, -1, 1, 0, -1,

        -1, -2, 0, 0, -2, 0,
        -1, -1, 0,
        -1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"opposing rowers"},
#endif
	{
        0, 2, -1,
        -1, 1, -1, 0, 1, -1, 1, 1, -1,
        -1, -1, -1, 0, -1, -1, 1, -1, -1,
        0, -2, -1,

        0, 2, 0,
        -1, 1, 0, 1, 1, 0,
        -1, -1, 0, 1, -1, 0,
        0, -2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"MW"},
#endif
	{
        -1, 0, -2, 1, 0, -2,
        0, 1, -2, 1, 1, -2,
        0, 2, -2,

        -1, 0, -1, 0, 0, -1,

        -1, -2, 0, 1, -2, 0,
        -1, -1, 0, 0, -1, 0,

        0, -2, 1, 1, -2, 1,

        0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"spinning football"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1,
        -2, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"umbrella"},
#endif
	{
        -1, -2, -2,
        -2, -1, -2, -1, -1, -2,

        -2, -2, -1, -1, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -1, 0, 1, -1, 0,
        1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"beater"},
#endif
	{
        -1, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2,

        -2, -2, -1, -1, -2, -1,
        -2, -1, -1,
        -2, 0, -1, 1, 0, -1,

        -1, -2, 0,
        1, 0, 0,
        -1, 1, 0, 0, 1, 0, 1, 1, 0,

        0, -1, 1,
        0, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"flower"},
#endif
	{
        -1, 1, -1, 0, 1, -1,
        -2, 0, -1, -1, 0, -1, 0, 0, -1, 1, 0, -1,
        -2, -1, -1, -1, -1, -1, 0, -1, -1, 1, -1, -1,
        -1, -2, -1, 0, -2, -1,

        -1, 0, 1, 0, 0, 1,
        -1, -1, 1, 0, -1, 1,

        -1, 0, 2, 0, 0, 2,
        -1, -1, 2, 0, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"pump"},
#endif
	{
        -1, 2, 0, 0, 2, 0, 1, 2, 0,
        -2, 1, 0, 0, 1, 0, 2, 1, 0,
        -2, 0, 0, -1, 0, 0, 1, 0, 0, 2, 0, 0,
        -2, -1, 0, 0, -1, 0, 2, -1, 0,
        -1, -2, 0, 0, -2, 0, 1, -2, 0,

        0, 1, 1,
        -1, 0, 1, 1, 0, 1,
        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spin out"},
#endif
	{
        0, -3, -1,
        -1, -2, -1, 0, -2, -1,
        2, -1, -1,
        -3, 0, -1, -2, 0, -1, 2, 0, -1, 3, 0, -1,
        -2, 1, -1,
        0, 2, -1, 1, 2, -1,
        0, 3, -1,

        -1, -2, 0, 0, -2, 0,
        2, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -2, 1, 0,
        0, 2, 0, 1, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"broken clip"},
#endif
	{
        1, -1, -2,
        1, 0, -2,

        1, -1, -1,
        1, 0, -1, 2, 0, -1,
        -2, 1, -1, -1, 1, -1, 1, 1, -1, 2, 1, -1,

        -2, 1, 0, -1, 1, 0,
        -1, 2, 0,

        -1, -2, 1, 0, -2, 1,
        -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -1, 1, 1,
        -1, 2, 1,

        0, -1, 2, 1, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"suction cups"},
#endif
	{
        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, -1, -1, -1, 0, -1, -1, 1, -1, -1,
        -2, 0, -1, -1, 0, -1, 0, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -2, 0, 1, -1, 0, 1, 0, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"clip"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 1, -2, 0, 1, -2,

        0, -2, -1, 1, -2, -1,
        -1, -1, -1, 0, -1, -1, 1, -1, -1,
        -1, 1, -1, 0, 1, -1, 1, 1, -1,
        0, 2, -1, 1, 2, -1,

        0, -2, 1, 1, -2, 1,
        -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -1, 1, 1, 0, 1, 1, 1, 1, 1,
        0, 2, 1, 1, 2, 1,

        -1, -1, 2, 0, -1, 2,
        -1, 1, 2, 0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"shattered"},
#endif
	{
        1, -1, -3,
        1, 0, -3,
        0, 1, -3, 1, 1, -3,

        1, -2, -2, 2, -2, -2,
        2, -1, -2,
        -2, 1, -2, 1, 1, -2,
        -2, 2, -2, -1, 2, -2, 0, 2, -2,

        2, -2, -1,
        -3, 1, -1,
        -2, 2, -1,

        1, -3, 0,
        2, -2, 0,
        -3, 1, 0,

        -1, -3, 1, 0, -3, 1, 1, -3, 1,
        -2, -2, 1, 1, -2, 1,
        -3, 0, 1,
        -3, 1, 1, -2, 1, 1,

        -2, -2, 2, -1, -2, 2,
        -2, -1, 2,
        -2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"big corner"},
#endif
	{
        -1, -3, -3,
        -2, -2, -3, 0, -2, -3,
        1, -1, -3,
        2, 0, -3,
        1, 1, -3,

        -1, -3, -2,
        -3, -2, -2, -1, -2, -2,
        1, 0, -2, 2, 0, -2,
        1, 2, -2,

        -3, -3, -1, -2, -3, -1,
        -2, -2, -1,
        1, 1, -1, 2, 1, -1,
        2, 2, -1,

        -3, -2, 0,
        1, 2, 0,

        -3, -1, 1,
        -2, 0, 1,
        -3, 1, 1, -1, 1, 1,
        -2, 2, 1, 0, 2, 1,

        -3, 0, 2, -2, 0, 2,
        -1, 1, 2,
        -1, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"compressor"},
#endif
	{
        0, 2, -2,
        0, 1, -2,
        -2, 0, -2, -1, 0, -2, 1, 0, -2, 2, 0, -2,
        0, -1, -2,
        0, -2, -2,

        -1, 1, -1, 0, 1, -1, 1, 1, -1,
        -1, 0, -1, 1, 0, -1,
        -1, -1, -1, 0, -1, -1, 1, -1, -1,

        -1, 1, 1, 0, 1, 1, 1, 1, 1,
        -1, 0, 1, 1, 0, 1,
        -1, -1, 1, 0, -1, 1, 1, -1, 1,

        0, 2, 2,
        0, 1, 2,
        -2, 0, 2, -1, 0, 2, 1, 0, 2, 2, 0, 2,
        0, -1, 2,
        0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"stretched broken clip"},
#endif
	{
        -2, -2, -2, 2, -2, -2,
        -1, -1, -2, 0, -1, -2, 1, -1, -2, 2, -1, -2,
        2, 1, -2,
        2, 2, -2,

        -2, -2, -1, -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -1, -1, -1, 0, -1, -1, 1, -1, -1,
        1, 1, -1, 2, 1, -1,
        1, 2, -1,

        1, 1, 0, 2, 1, 0,
        1, 2, 0,

        -2, -2, 1,
        -2, -1, 1, -1, -1, 1,
        -2, 0, 1, -1, 0, 1,
        -2, 1, 1, -1, 1, 1, 1, 1, 1, 2, 1, 1,
        1, 2, 1,

        -2, -2, 2,
        -1, -1, 2,
        -1, 0, 2,
        -1, 1, 2,
        -2, 2, 2, -1, 2, 2, 1, 2, 2, 2, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"H (p3)"},
#endif
	{
        -1, 0, -1, 1, 0, -1,

        -1, 0, 0, 0, 0, 0, 1, 0, 0,

        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"waving tail (p3)"},
#endif
	{
        -1, -1, -1, 0, -1, -1, 1, -1, -1,

        -1, 0, -1, 0, 0, -1, 1, 0, -1,

        0, -1, 0,
        0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"clasp (p3)"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -3, 0, -1, -2, 0, -1, -1, 0, -1,

        -2, -1, 0, 0, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -2, 1, 0, -1, 1, 0, 1, 1, 0,

        0, 0, 1, 1, 0, 1, 2, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bagel (p3)"},
#endif
	{
        -1, -2, -2, 0, -2, -2, 1, -2, -2,
        -1, -1, -2, 1, -1, -2,
        -1, 0, -2, 0, 0, -2, 1, 0, -2,

        -1, -3, -1, 1, -3, -1,
        -2, -2, -1, -1, -2, -1, 1, -2, -1, 2, -2, -1,
        -2, 0, -1, -1, 0, -1, 1, 0, -1, 2, 0, -1,
        -1, 1, -1, 1, 1, -1,

        -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"big corner (p3)"},
#endif
	{
        1, -1, -2, 2, -1, -2,
        1, -2, -2,

        1, 0, -1, 2, 0, -1,
        0, -1, -1,
        0, -2, -1,

        1, 1, 0, 2, 1, 0,
        -1, -1, 0, 1, -1, 0,
        -1, -2, 0,

        1, 2, 1, 2, 2, 1,
        0, 1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, -1, 1, 0, -1, 1,
        -2, -2, 1,

        1, 2, 2,
        0, 1, 2,
        -1, 0, 2,
        -2, -1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"door swing (p4)"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -2, 0,
        -1, -1, 0, 0, -1, 0,
        0, 0, 0,
        0, 1, 0,

        -1, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"legs (p4)"},
#endif
	{
        -1, -1, -2,
        -1, 0, -2,

        -1, -2, -1,
        -1, -1, -1,
        0, 0, -1,

        0, -1, 0,
        -1, 0, 0,
        -1, 1, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"monroe (p4)"},
#endif
	{
        0, -1, -2,

        0, -2, -1,
        -1, -1, -1,
        0, 0, -1,
        0, 1, -1,

        0, -2, 0,
        0, -1, 0,
        -1, 0, 0,
        0, 1, 0,

        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"4C (p4)"},
#endif
	{
        -3, -3, -1, -2, -3, -1, -1, -3, -1, 0, -3, -1, 1, -3, -1, 2, -3, -1,
        -3, -2, -1, -1, -2, -1, 0, -2, -1, 2, -2, -1,
        -3, 0, -1, -1, 0, -1, 0, 0, -1, 2, 0, -1,
        -3, 1, -1, -2, 1, -1, -1, 1, -1, 0, 1, -1, 1, 1, -1, 2, 1, -1,
        127
	},
#ifdef LIFE_NAMES
	{"swing (p4)"},
#endif
	{
        -2, -2, -2, 1, -2, -2,
        -2, -1, -2, 1, -1, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,

        -2, -2, 0, 1, -2, 0,
        -1, -1, 0, 0, -1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"cross (p4)"},
#endif
	{
        0, -3, -1,
        0, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -3, 0, -1, -2, 0, -1, 2, 0, -1, 3, 0, -1,
        -2, 1, -1, 2, 1, -1,
        0, 2, -1,
        0, 3, -1,

        0, -3, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"glider reflector (p4)"},
#endif
	{
        -1, -1, -2, 1, -1, -2,
        -1, 1, -2, 1, 1, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 1, 2, -1,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, -1, -1, 1, 0, -1, 1, 1, -1, 1, 2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, -1, 1, 1, 0, 1, 1, 1, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"mirror image (p6)"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        0, 1, -1, 1, 1, -1,

        -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -1, -1, 0, 0, -1, 0,
        -1, 1, 0, 0, 1, 0,
        -1, 2, 0, 0, 2, 0, 1, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"stargate (p6)"},
#endif
	{
        2, -3, -1,
        -3, -2, -1,
        3, 2, -1,
        -2, 3, -1,

        -2, -3, 0, -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -2, -2, 0, -1, -2, 0, 0, -2, 0, 1, -2, 0, 2, -2, 0, 3, -2, 0,
        -3, -1, 0, -2, -1, 0, 2, -1, 0, 3, -1, 0,
        -3, 0, 0, -2, 0, 0, 2, 0, 0, 3, 0, 0,
        -3, 1, 0, -2, 1, 0, 2, 1, 0, 3, 1, 0,
        -3, 2, 0, -2, 2, 0, -1, 2, 0, 0, 2, 0, 1, 2, 0, 2, 2, 0,
        -1, 3, 0, 0, 3, 0, 1, 3, 0, 2, 3, 0,

        0, -2, 1,
        -2, 0, 1, 2, 0, 1,
        0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double plus divide (p10)"},
#endif
	{
        -1, 1, -2,

        -2, 0, -1, 1, 0, -1,
        -1, 2, -1,

        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -2, 1, 0, 1, 1, 0,

        0, -2, 1,
        -2, 0, 1, 1, 0, 1,

        0, -1, 2,
        127
	},
};

static char patterns_26B5S8[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"double glider (diagonal, p2)"},
#endif
	{
        -1, -1, -3, 0, -1, -3,

        -1, -2, -2, 0, -2, -2,
        -1, -1, -2, 0, -1, -2,
        -1, 1, -2, 0, 1, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, -1, -1, -1, 0, -1, -1, 1, -1, -1,
        -1, 2, -1, 0, 2, -1,

        -2, 1, 1, -1, 1, 1, 0, 1, 1, 1, 1, 1,
        -1, 2, 1, 0, 2, 1,
        -1, 3, 1, 0, 3, 1,

        -1, 1, 2, 0, 1, 2,
        -1, 2, 2, 0, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"AV"},
#endif
	{
        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,

        1, -2, 0,
        -1, 1, 0,

        -1, -1, 1, 1, -1, 1,
        -1, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pump"},
#endif
	{
        -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -2, 0, -1, -1, 0, -1, 1, 0, -1, 2, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 0, 2, -1, 1, 2, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"box"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
};

static char patterns_26B58S58[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"zepplin II (c, p2)"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -1, -2, -1,
        -3, -1, -1, 1, -1, -1, 2, -1, -1,
        -3, 0, -1, -2, 0, -1, 2, 0, -1,
        0, 1, -1,
        -1, 2, -1, 0, 2, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, -1, -1, 0, 0, -1, 0, 1, -1, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"zepplin III (c, p1)"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -1, -2, -1,
        -3, -1, -1, 1, -1, -1, 2, -1, -1,
        -3, 0, -1, -2, 0, -1, 2, 0, -1,
        0, 1, -1,
        -1, 2, -1, 0, 2, -1,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -2, 0, 1, -1, 0, 1, 0, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double x ship (c, p3)"},
#endif
	{
        -2, -2, -3, 1, -2, -3,
        -1, -1, -3, 0, -1, -3,
        -1, 0, -3, 0, 0, -3,
        -2, 1, -3, 1, 1, -3,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -2, -2, 0, 1, -2, 0,
        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 0, 0, 0,
        -2, 1, 0, 1, 1, 0,

        -1, -2, 2, 0, -2, 2,
        -2, -1, 2, -1, -1, 2, 0, -1, 2, 1, -1, 2,
        -2, 0, 2, -1, 0, 2, 0, 0, 2, 1, 0, 2,
        -1, 1, 2, 0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"x ship with tail (c, p3)"},
#endif
	{
        -2, -1, -2,
        -2, 0, -2,

        -2, -2, -1, -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -2, 1, -1, -1, 1, -1, 0, 1, -1, 1, 1, -1,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -2, 0, 1, -1, 0, 1, 0, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"zepplin IV (c, p4)"},
#endif
	{
        0, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2, 1, 0, -2,
        -1, 1, -2,

        -2, -2, 0, 0, -2, 0, 1, -2, 0,
        -2, -1, 0,
        1, 0, 0,
        -2, 1, 0, -1, 1, 0, 1, 1, 0,

        -1, -2, 2, 0, -2, 2,
        -2, -1, 2, -1, -1, 2, 0, -1, 2, 1, -1, 2,
        -2, 0, 2, -1, 0, 2, 0, 0, 2, 1, 0, 2,
        -1, 1, 2, 0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"puffer (c, p10)"},
#endif
	{
        0, -2, -1,
        -2, 0, -1,

        1, -1, 0,
        1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -2, 0, 1, -1, 0, 1, 0, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"puffer (c, p30)"},
#endif
	{
        -2, -2, -2,
        1, 1, -2,

        -2, -2, -1,
        2, -1, -1,
        1, 1, -1,
        -1, 2, -1,

        0, -2, 0,
        -2, 0, 0,
        1, 1, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -2, 0, 1, -1, 0, 1, 0, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"ship (c, p12)"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -1, 0, -1, 0, 0, -1,

        -2, -2, 0, -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        -3, 2, 0, -2, 2, 0, 1, 2, 0, 2, 2, 0,

        -2, -2, 1, -1, -2, 1, 0, -2, 1, 1, -2, 1,
        -2, -1, 1, 1, -1, 1,

        -1, -2, 2, 0, -2, 2,
        -2, 0, 2, -1, 0, 2, 0, 0, 2, 1, 0, 2,
        -1, 1, 2, 0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"cup"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 0, 0, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"frilly"},
#endif
	{
        -1, -2, -1,
        -1, -1, -1, 0, -1, -1, 1, -1, -1,
        -2, 0, -1, -1, 0, -1, 0, 0, -1,
        0, 1, -1,

        0, -2, 0,
        -2, -1, 0,
        1, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"frilly2"},
#endif
	{
        0, -1, -2,
        -1, 0, -2,

        0, -1, -1, 1, -1, -1,
        -2, 0, -1, -1, 0, -1,

        -2, -1, 0, 0, -1, 0,
        -1, 0, 0, 1, 0, 0,

        0, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bench"},
#endif
	{
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1,  1, 0, -1,

        -2, -1, 0, -1, -1, 0, 0, -1, 0, 1, -1, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"bird"},
#endif
	{
        0, -2, -1, -1, -2, -1,
        -1, 1, -1,  0, 1, -1,

        -2, -1, 0, -1, -1, 0, 0, -1, 0, 1, -1, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"exploding box (p3)"},
#endif
	{
        1, -1, -1,
        0, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1, 1, 1, -1,

        0, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -1, 0, 1, 0, 0, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"duel (p3)"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        1, -2, 0,
        0, -1, 0, 1, -1, 0, 2, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -2, 1, 0, -1, 1, 0, 0, 1, 0,
        -1, 2, 0,

        0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"engine (p4)"},
#endif
	{
        -2, -1, -1,
        -2, 0, -1, -1, 0, -1,

        -2, -1, 0,
        -2, 0, 0, 1, 0, 0,
        0, 1, 0, 1, 1, 0,

        -1, -1, 1, 0, -1, 1,
        1, 0, 1,
        1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"dependent (p4)"},
#endif
	{
        1, -1, -3, 2, -1, -3,

        1, -1, -2, 2, -1, -2,
        0, 0, -2, 1, 0, -2,

        -3, 1, -1, -2, 1, -1,
        -3, 2, -1, -2, 2, -1,

        0, -2, 0,
        -2, 0, 0,
        -2, 1, 0,

        -1, -3, 1,
        -1, -2, 1, 0, -2, 1,

        -1, -3, 2,
        -1, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"quadropus (p4)"},
#endif
	{
        -1, -2, -1,
        1, -1, -1,
        -2, 0, -1,
        0, 1, -1,

        -2, -2, 0, 0, -2, 0, 1, -2, 0,
        -2, -1, 0,
        1, 0, 0,
        -2, 1, 0, -1, 1, 0, 1, 1, 0,

        -2, -2, 1, 0, -2, 1, 1, -2, 1,
        -2, -1, 1,
        1, 0, 1,
        -2, 1, 1, -1, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"X (p4)"},
#endif
	{
        -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -2, -1, -1, 0, -1, -1, 2, -1, -1,
        -2, 0, -1, -1, 0, -1, 1, 0, -1, 2, 0, -1,
        -2, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 2, -1, 0, 2, -1, 1, 2, -1,

        -1, -1, 0, 1, -1, 0,
        0, 0, 0,
        -1, 1, 0, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"waltzer (p6)"},
#endif
	{
        -1, -1, -2,

        -2, -1, -1, -1, -1, -1, 2, -1, -1,

        0, -2, 0,
        0, -1, 0,
        -2, 0, 0, 1, 0, 0, 2, 0, 0,
        1, 1, 0,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"fence (p8)"},
#endif
	{
        0, -2, -1,
        -2, -1, -1,
        1, 0, -1,
        -1, 1, -1,

        -2, -3, 0,
        -2, -2, 0, -1, -2, 0, 0, -2, 0, 1, -2, 0, 2, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -3, 1, 0, -2, 1, 0, -1, 1, 0, 0, 1, 0, 1, 1, 0,
        1, 2, 0,

        -2, -2, 1, 1, -2, 1,
        -2, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"paddle wheel (p8)"},
#endif
	{
        0, 0, -4,

        0, 0, -3,

        0, -2, -2,
        -2, 0, -2, 2, 0, -2,
        0, 2, -2,

        -1, -3, -1, 1, -3, -1,
        -2, -2, -1, 2, -2, -1,
        -3, -1, -1, 3, -1, -1,
        -3, 1, -1, 3, 1, -1,
        -2, 2, -1, 2, 2, -1,
        -1, 3, -1, 1, 3, -1,

        -1, -3, 0, 1, -3, 0,
        -2, -2, 0, 2, -2, 0,
        -3, -1, 0, 3, -1, 0,
        -3, 1, 0, 3, 1, 0,
        -2, 2, 0, 2, 2, 0,
        -1, 3, 0, 1, 3, 0,

        0, -2, 1,
        -2, 0, 1, 2, 0, 1,
        0, 2, 1,

        0, 0, 2,

        0, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"replicator"},
#endif
	{
        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, -1, -1, 0, 0, -1, 0, 1, -1, 0,
        -2, 0, 0, -1, 0, 0, 0, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,
        127
	},
};

static char patterns_26B6S567[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"glider 2 (16 cell, c/4, p8)"},
#endif
	{
        -1, -2, -1, -1, -2, 0,
        -1, -1, -1, -1, -1, 0,
        -1, 1, -1, -1, 1, 0,

        0, -1, -1, 0, -1, 0,
        0, 1, -1, 0, 1, 0,
        0, 2, -1, 0, 2, 0,

        1, 0, -1, 1, 0, 0,
        1, 1, -1, 1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"glider (36 cell, c/4, p8)"},
#endif
	{
        -1, -3, -2, 0, -3, -2, 1, -3, -2,
        -2, -2, -2, -1, -2, -2, 1, -2, -2, 2, -2, -2,
        -2, -1, -2, 2, -1, -2,
        -2, 0, -2, -1, 0, -2, 1, 0, -2, 2, 0, -2,
        -1, 1, -2, 0, 1, -2, 1, 1, -2,

        -1, -4, -1, 0, -4, -1, 1, -4, -1,
        -2, -3, -1, 2, -3, -1,
        -3, -2, -1, 3, -2, -1,
        -3, -1, -1, 3, -1, -1,
        -3, 0, -1, 3, 0, -1,
        -2, 1, -1, 2, 1, -1,
        -1, 2, -1, 0, 2, -1, 1, 2, -1,

        -1, -3, 0,
        2, -2, 0,
        -2, 0, 0,
        1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"glider (40 cell, c/3, p3)"},
#endif
	{
        -2, -3, -1, 1, -3, -1,
        -3, -2, -1, 0, -2, -1, 2, -2, -1,
        -2, -1, -1,
        1, 0, -1,
        -3, 1, -1, -1, 1, -1, 2, 1, -1,
        -2, 2, -1, 1, 2, -1,

        -2, -3, 0, -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -3, -2, 0, 2, -2, 0,
        -3, -1, 0, 2, -1, 0,
        -3, 0, 0, 2, 0, 0,
        -3, 1, 0, 2, 1, 0,
        -2, 2, 0, -1, 2, 0, 0, 2, 0, 1, 2, 0,

        -2, -2, 1, -1, -2, 1, 0, -2, 1, 1, -2, 1,
        -2, -1, 1, 1, -1, 1,
        -2, 0, 1, 1, 0, 1,
        -2, 1, 1, -1, 1, 1, 0, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"knife-switch blinker"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"switch"},
#endif
	{
        -1, 0, -1, 1, 0, -1,

        0, -1, 0,
        -1, 0, 0, 0, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"triknot"},
#endif
	{
        0, 0, -1, 1, 0, -1,

        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double blinker"},
#endif
	{
        0, 0, -1,
        0, 1, -1,

        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, -1, 1,
        1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pile driver"},
#endif
	{
        -1, 0, -1, 0, 0, -1,
        -1, 1, -1,

        -1, -1, 0, 0, -1, 0,
        1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"run around"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0, 1, 1, 0,

        0, -1, 1,
        -1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"single blinker"},
#endif
	{
        0, -1, -1,
        1, 0, -1,
        0, 1, -1,

        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0, 1, 1, 0,

        0, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"beacon"},
#endif
	{
        -2, -1, -2, -1, -1, -2,
        -2, 0, -2, -1, 0, -2,

        -2, -1, -1,
        -2, 0, -1,

        1, -1, 0,
        1, 0, 0,

        0, -1, 1, 1, -1, 1,
        0, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"clock"},
#endif
	{
        0, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -1, 1, -1,

        0, -2, 0,
        -2, -1, 0, 0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"gear"},
#endif
	{
        0, 0, -2,

        0, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"wide gear"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,

        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"s"},
#endif
	{
        -1, -1, -2, 0, -1, -2,

        -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 0, 0, -1,

        -1, -1, 0, 0, -1, 0,
        -1, 0, 0, 0, 0, 0,

        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"3 halves blinker"},
#endif
	{
        -1, -1, -1,
        -1, 0, -1,

        0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        0, -2, 1,
        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"digger"},
#endif
	{
        0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1,
        1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -1, 0, 0, -1, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"deformed digger"},
#endif
	{
        0, -1, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0,
        -2, 0, 0, -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"help"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        -1, -1, -1, 0, -1, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"half blinkers"},
#endif
	{
        0, -1, -2,
        0, 0, -2,

        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -2, -1, 0, 2, -1, 0,
        -2, 0, 0, 2, 0, 0,
        0, 1, 0,

        -1, -1, 1, 1, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,

        0, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"mutant half blinker"},
#endif
	{
        0, -1, -2,
        0, 0, -2,

        0, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -2, 0, 1, -2, 0,
        -2, -1, 0, 2, -1, 0,
        -2, 0, 0, 2, 0, 0,
        0, 1, 0,

        0, -2, 1, 1, -2, 1,
        -1, -1, 1, 2, -1, 1,
        -1, 0, 1, 2, 0, 1,
        0, 1, 1,

        0, -1, 2, 1, -1, 2,
        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"flare"},
#endif
	{
        -2, -1, -3,
        -3, 0, -3, -1, 0, -3,
        -2, 1, -3,

        -2, -1, -2,
        -3, 0, -2, -1, 0, -2,
        -2, 1, -2,

        -2, 0, -1, 0, 0, -1,

        1, 0, 0, 2, 0, 0,

        1, -1, 1, 2, -1, 1,
        0, 0, 1,
        1, 1, 1, 2, 1, 1,

        1, 0, 2, 2, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"triple blinker 1"},
#endif
	{
        0, -1, -2,
        0, 0, -2,

        -1, -1, -1, 1, -1, -1,
        -2, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        1, -1, 0,
        -2, 0, 0, 0, 0, 0,

        -1, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"triple blinker 2"},
#endif
	{
        -1, -1, -2, 0, -1, -2,

        -1, -2, -1,
        -2, -1, -1, -1, -1, -1,
        -2, 0, -1,
        0, 1, -1,

        -1, -2, 0,
        1, -1, 0,
        0, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"searchlight"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"little star"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1, 1, 1, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,

        -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"cruncher"},
#endif
	{
        0, -2, -2,
        0, -1, -2,

        0, -2, -1, 1, -2, -1,
        1, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        0, 0, 1,
        0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"barber pole"},
#endif
	{
        4, -6, -1, 5, -6, -1,
        5, -5, -1,
        2, -4, -1, 4, -4, -1,
        0, -2, -1, 2, -2, -1,
        -2, 0, -1, 0, 0, -1,
        -4, 2, -1, -2, 2, -1,
        -6, 4, -1, -4, 4, -1,
        -6, 5, -1, -5, 5, -1,

        4, -6, 0, 5, -6, 0,
        5, -5, 0,
        2, -4, 0, 4, -4, 0,
        0, -2, 0, 2, -2, 0,
        -2, 0, 0, 0, 0, 0,
        -4, 2, 0, -2, 2, 0,
        -6, 4, 0, -4, 4, 0,
        -6, 5, 0, -5, 5, 0,
        127
	},
#ifdef LIFE_NAMES
	{"fountain (p3)"},
#endif
	{
        1, -2, -3, 2, -2, -3,
        1, 1, -3, 2, 1, -3,

        1, -3, -2, 2, -3, -2,
        0, 0, -2, 3, 0, -2,
        0, 1, -2, 3, 1, -2,
        1, 2, -2, 2, 2, -2,

        1, -2, -1, 2, -2, -1,
        0, 0, -1, 3, 0, -1,
        0, 1, -1, 3, 1, -1,
        1, 2, -1, 2, 2, -1,

        1, 1, 0, 2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"star maker (p3)"},
#endif
	{
        1, -2, -1, 2, -2, -1,
        1, -1, -1, 2, -1, -1,
        -2, 1, -1, -1, 1, -1,
        -2, 2, -1, -1, 2, -1,

        1, -3, 0, 2, -3, 0,
        3, -2, 0, 0, -1, 0,
        3, -1, 0, -1, 0, 0,
        1, 0, 0,
        -3, 1, 0, 0, 1, 0,
        -3, 2, 0,
        -2, 3, 0, -1, 3, 0,

        1, -2, 1, 2, -2, 1,
        1, -1, 1, 2, -1, 1,
        -2, 1, 1, -1, 1, 1,
        -2, 2, 1, -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"v (p3)"},
#endif
	{
        1, 0, -3,
        0, 1, -3, 1, 1, -3,

        -1, -1, -2, 0, -1, -2, 1, -1, -2,
        -1, 0, -2, 2, 0, -2,
        -1, 1, -2, 2, 1, -2,
        0, 2, -2, 1, 2, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1,
        -2, 0, -1, 2, 0, -1,
        2, 1, -1,
        0, 2, -1, 1, 2, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0,
        -1, 1, 0,

        0, -1, 1, 1, -1, 1,
        -1, 0, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"peak-a-boo (p3)"},
#endif
	{
        -1, -2, -3, 0, -2, -3,
        -2, -1, -3, 1, -1, -3,
        -2, 0, -3, 1, 0, -3,

        -1, -3, -2, 0, -3, -2,
        -2, -2, -2, 1, -2, -2,
        -3, -1, -2, 2, -1, -2,
        -3, 0, -2, -1, 0, -2, 0, 0, -2, 2, 0, -2,
        -2, 1, -2, 1, 1, -2,

        -1, -3, -1, 0, -3, -1,
        -2, -2, -1, 1, -2, -1,
        -3, 0, -1, 2, 0, -1,
        -2, 1, -1, 1, 1, -1,

        -2, -2, 0, 1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"jaws (p3)"},
#endif
	{
        0, -1, -2,
        -1, 0, -2, 1, 0, -2,
        0, 1, -2,

        0, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 2, 0, -1,
        0, 1, -1, 1, 1, -1,

        -1, -2, 0, 1, -2, 0,
        -1, -1, 0, 2, -1, 0,
        1, 1, 0, 2, 1, 0,

        0, -2, 1,
        0, -1, 1, 1, -1, 1,
        1, 0, 1, 2, 0, 1,

        -2, 1, 1,
        -2, 2, 1, -1, 2, 1,

        -2, 1, 2, -1, 1, 2,
        -2, 2, 2, -1, 2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"sparky (p4)"},
#endif
	{
        0, -1, -2,
        0, 0, -2,

        0, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, 0, 1, 0, 0, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"star (p4)"},
#endif
	{
        0, 0, -2,

        0, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1, 1, 1, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 1, 0, 1, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,

        0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"big star (p4)"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,

        0, -1, 1, 1, -1, 1,
        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"mouth (p4)"},
#endif
	{
        -1, 1, -2,

        0, -2, -1, 1, -2, -1,
        -1, -1, -1, 2, -1, -1,
        -2, 0, -1, 2, 0, -1,
        -2, 1, -1, 1, 1, -1,
        -1, 2, -1, 0, 2, -1,

        0, -2, 0, 1, -2, 0,
        -1, -1, 0, 2, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -2, 1, 0, 1, 1, 0,
        -1, 2, 0, 0, 2, 0,

        1, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"v2 (p5)"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2,

        0, -2, -1, 1, -2, -1,
        -2, 0, -1, 0, 0, -1,
        -2, 1, -1,

        0, -2, 0, 1, -2, 0,
        -1, -1, 0, 2, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -2, 1, 0, 0, 1, 0,
        -1, 2, 0,

        1, -1, 1,
        1, 0, 1,
        -1, 1, 1, 0, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"m (p5)"},
#endif
	{
        1, -1, -3,
        1, 0, -3,
        -1, 1, -3, 0, 1, -3,

        1, -2, -2,
        0, -1, -2, 2, -1, -2,
        -1, 0, -2, 2, 0, -2,
        -2, 1, -2, 1, 1, -2,
        -1, 2, -2, 0, 2, -2,

        1, -2, -1,
        2, -1, -1,
        2, 0, -1,
        -2, 1, -1,
        -1, 2, -1, 0, 2, -1,

        0, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0,
        -1, 1, 0,

        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"birthday cake (p5)"},
#endif
	{
        -1, 0, -2, 0, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -1, -1, -1,
        -2, 0, -1,
        -2, 1, -1, 1, 1, -1,
        -1, 2, -1, 0, 2, -1,

        0, -2, 0,
        -1, -1, 0, 0, -1, 0,
        2, 0, 0,
        -1, 1, 0, 2, 1, 0,
        -1, 2, 0,

        0, -1, 1, 1, -1, 1,
        2, 0, 1,
        0, 1, 1, 2, 1, 1,
        0, 2, 1, 1, 2, 1,

        1, 0, 2,
        1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"sparky2 (p5)"},
#endif
	{
        0, -1, -2, 1, -1, -2,
        0, 0, -2, 1, 0, -2,

        0, -2, -1,
        -1, -1, -1,
        2, 0, -1,
        1, 1, -1,

        -1, -2, 0, 0, -2, 0,
        0, 0, 0, 2, 0, 0,
        2, 1, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, 1, -1, 1,
        -1, 0, 1, 2, 0, 1,
        0, 1, 1, 2, 1, 1,
        1, 2, 1,

        -1, -1, 2,
        -1, 0, 2,
        0, 1, 2, 1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"sparky3 (p5)"},
#endif
	{
        1, -2, -3,
        1, -1, -3,
        -1, 0, -3, 0, 0, -3,

        0, -3, -2, 1, -3, -2,
        -1, -2, -2, 2, -2, -2,
        -2, -1, -2, 1, -1, -2,
        -2, 0, -2, 0, 0, -2,
        -1, 1, -2,

        0, -3, -1, 1, -3, -1,
        -1, -2, -1, 2, -2, -1,
        -2, -1, -1,
        -2, 0, -1,
        -1, 1, -1,

        0, -2, 0, 1, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0,

        1, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"slap hands (p5)"},
#endif
	{
        -2, -3, -2, -1, -3, -2,
        -2, -2, -2, -1, -2, -2,
        0, 2, -2, 1, 2, -2,
        0, 3, -2, 1, 3, -2,

        -2, -4, -1, -1, -4, -1,
        0, -3, -1,
        -3, -2, -1, 0, -2, -1,
        -3, -1, -1,
        2, 1, -1,
        -1, 2, -1, 2, 2, -1,
        -1, 3, -1,
        0, 4, -1, 1, 4, -1,

        -2, -4, 0, -1, -4, 0,
        -3, -3, 0, 0, -3, 0,
        -3, -2, 0, 0, -2, 0,
        -3, -1, 0,
        2, 1, 0,
        -1, 2, 0, 2, 2, 0,
        -1, 3, 0, 2, 3, 0,
        0, 4, 0, 1, 4, 0,

        -2, -3, 1, -1, -3, 1,
        -2, -2, 1, -1, -2, 1,
        0, 2, 1, 1, 2, 1,
        0, 3, 1, 1, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"trap door (p10)"},
#endif
	{
        -2, -1, -2, -1, -1, -2,
        -2, 0, -2, -1, 0, -2, 1, 0, -2, 2, 0, -2,
        1, 1, -2, 2, 1, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 2, -1, -1,
        -3, 0, -1, 3, 0, -1,
        -2, 1, -1, 2, 1, -1,
        0, 2, -1, 1, 2, -1,

        0, -2, 0, 1, -2, 0,
        -1, -1, 0, 2, -1, 0,
        -2, 1, 0, 1, 1, 0,
        -1, 2, 0, 0, 2, 0,

        1, -1, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"collision -> redirection"},
#endif
	{
        0, -7, -4,
        -2, -6, -4, 0, -6, -4,
        -1, -5, -4, 1, -5, -4,
        -1, -4, -4,

        0, -7, -3,
        -2, -6, -3, 0, -6, -3,
        -1, -5, -3, 1, -5, -3,
        -1, -4, -3,

        0, 3, 1, 1, 3, 1,
        0, 4, 1, 1, 4, 1,

        0, 3, 2, 1, 3, 2,
        0, 5, 2, 1, 5, 2,

        0, 3, 3, 1, 3, 3,
        127
	},
#ifdef LIFE_NAMES
	{"collision -> squashed ball"},
#endif
	{
        0, -7, -4,
        -2, -6, -4, 0, -6, -4,
        -1, -5, -4, 1, -5, -4,
        -1, -4, -4,

        0, -7, -3,
        -2, -6, -3, 0, -6, -3,
        -1, -5, -3, 1, -5, -3,
        -1, -4, -3,

        0, 3, 0, 1, 3, 0,
        0, 4, 0, 1, 4, 0,

        0, 3, 1, 1, 3, 1,
        0, 5, 1, 1, 5, 1,

        0, 3, 2, 1, 3, 2,
        127
	},
#ifdef LIFE_NAMES
	{"fuse2"},
#endif
	{
        0, 0, 4,

        0, 0, 3,

        0, -2, 2,
        -1, -1, 2, 1, -1, 2,
        -2, 0, 2, 2, 0, 2,
        -1, 1, 2, 1, 1, 2,
        0, 2, 2,

        0, -2, 1,
        -1, -1, 1, 1, -1, 1,
        -2, 0, 1, 2, 0, 1,
        -1, 1, 1, 1, 1, 1,
        0, 2, 1,

        0, 0, 0,

        0, 0, -1,

        0, -2, -2,
        -1, -1, -2, 1, -1, -2,
        -2, 0, -2, 2, 0, -2,
        -1, 1, -2, 1, 1, -2,
        0, 2, -2,

        0, -2, -3,
        -1, -1, -3, 1, -1, -3,
        -2, 0, -3, 2, 0, -3,
        -1, 1, -3, 1, 1, -3,
        0, 2, -3,

        -1, 0, -4, 0, 0, -4, 1, 0, -4,
        127
	},
#ifdef LIFE_NAMES
	{"near ship"},
#endif
	{
        -2, -1, -2, -1, -1, -2,
        -2, 0, -2, -1, 0, -2,

        -2, -1, -1, -1, -1, -1,
        -2, 0, -1, -1, 0, -1,

        0, -1, 0,
        0, 0, 0,

        -2, -1, 1, -1, -1, 1,
        -2, 0, 1, -1, 0, 1,

        -2, -1, 2, -1, -1, 2,
        -2, 0, 2, -1, 0, 2,
        127
	},
};

static char patterns_26B6S57[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"gear"},
#endif
	{
        0, 0, -2,

        0, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"wide gear"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,

        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"bumpy ball (p3)"},
#endif
	{
        0, -2, -3,

        0, -3, -2, 1, -3, -2,
        -1, -2, -2, 0, -2, -2, 1, -2, -2,
        -1, -1, -2, 0, -1, -2,

        0, -4, -1, 1, -4, -1,
        1, -3, -1, 2, -3, -1,
        -2, -2, -1, 1, -2, -1,
        -2, -1, -1, -1, -1, -1, 0, -1, -1,
        -1, 0, -1,

        0, -5, 0,
        -1, -4, 0, 0, -4, 0, 1, -4, 0,
        -2, -3, 0, 1, -3, 0,
        -3, -2, 0, -2, -2, 0,
        -2, -1, 0, -1, -1, 0,

        -1, -4, 1, 0, -4, 1,
        -2, -3, 1, -1, -3, 1, 0, -3, 1,
        -2, -2, 1, -1, -2, 1,

        -1, -3, 2,
        127
	},
#ifdef LIFE_NAMES
	{"spider (p6)"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -1, -1, -2, 0, -1, -2,

        -1, -2, -1, 0, -2, -1,
        -1, -1, -1, 0, -1, -1,

        0, -3, 0,
        -2, -2, 0,
        1, -1, 0,
        -1, 0, 0,

        0, -3, 1,
        -2, -2, 1,
        1, -1, 1,
        -1, 0, 1,

        0, -3, 2,
        -2, -2, 2,
        1, -1, 2,
        -1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"transformer (p11)"},
#endif
	{
        -1, -4, -1, 0, -4, -1,
        -3, -2, -1, -1, -2, -1, 0, -2, -1, 2, -2, -1,
        -3, -1, -1, -1, -1, -1, 0, -1, -1, 2, -1, -1,
        -3, 0, -1, -1, 0, -1, 0, 0, -1, 2, 0, -1,
        -3, 1, -1, -1, 1, -1, 0, 1, -1, 2, 1, -1,
        -1, 3, -1, 0, 3, -1,

        -1, -4, 0, 0, -4, 0,
        -3, -2, 0, -1, -2, 0, 0, -2, 0, 2, -2, 0,
        -3, -1, 0, -1, -1, 0, 0, -1, 0, 2, -1, 0,
        -3, 0, 0, -1, 0, 0, 0, 0, 0, 2, 0, 0,
        -3, 1, 0, -1, 1, 0, 0, 1, 0, 2, 1, 0,
        -1, 3, 0, 0, 3, 0,
        127
	},
};

static char patterns_26B67S57[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"glider orthogonal (c/5, p5)"},
#endif
	{
        0, -2, -1,
        -2, 0, -1, 2, 0, -1,
        0, 2, -1,

        -2, -2, 0, -1, -2, 0, 0, -2, 0, 1, -2, 0, 2, -2, 0,
        -2, -1, 0, 2, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -2, 1, 0, 2, 1, 0,
        -2, 2, 0, -1, 2, 0, 0, 2, 0, 1, 2, 0, 2, 2, 0,

        -2, -2, 1, -1, -2, 1, 0, -2, 1, 1, -2, 1, 2, -2, 1,
        -2, -1, 1, 2, -1, 1,
        -2, 0, 1, 2, 0, 1,
        -2, 1, 1, 2, 1, 1,
        -2, 2, 1, -1, 2, 1, 0, 2, 1, 1, 2, 1, 2, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"gear"},
#endif
	{
        0, 0, -2,

        0, -2, -1,
        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -1, -1, 0, 1, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"wide gear"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,

        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"non-gear"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0,
        1, -1, 0,
        -2, 0, 0,
        0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"rotor wheel (p3)"},
#endif
	{
        -1, 0, -3, 0, 0, -3,
        -1, 1, -3, 0, 1, -3,

        -1, 0, -2, 0, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -4, 0, 0, -3, 0, 0, -2, 0, 0, 1, 0, 0, 2, 0, 0, 3, 0, 0,
        -4, 1, 0, -3, 1, 0, -2, 1, 0, 1, 1, 0, 2, 1, 0, 3, 1, 0,

        -1, 0, 2, 0, 0, 2,
        -1, 1, 2, 0, 1, 2,

        -1, 0, 3, 0, 0, 3,
        -1, 1, 3, 0, 1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"smile (p4)"},
#endif
	{
        -1, 0, -3, 0, 0, -3,

        -1, -1, -2, 0, -1, -2,
        -2, 0, -2, 1, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -2, 0, -1, 1, 0, -1,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        -1, 1, 1, 0, 1, 1,

        -1, 0, 2, 0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"large greater than less than (p4)"},
#endif
	{
        1, -3, -1,
        1, -2, -1,
        1, -1, -1, 2, -1, -1, 3, -1, -1,
        -3, 1, -1, -2, 1, -1, -1, 1, -1,
        -1, 2, -1,
        -1, 3, -1,

        1, -3, 0,
        1, -2, 0,
        1, -1, 0, 2, -1, 0, 3, -1, 0,
        -3, 1, 0, -2, 1, 0, -1, 1, 0,
        -1, 2, 0,
        -1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"deformed spider (p4)"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        0, -2, -1,
        -2, -1, -1,
        1, 0, -1,
        -1, 1, -1,

        0, -2, 0,
        -2, -1, 0, 0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        -1, 1, 0,

        -1, -2, 1, 0, -2, 1,
        -1, 1, 1, 0, 1, 1,

        -1, -1, 2, 0, -1, 2,
        -1, 0, 2, 0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"A (p4)"},
#endif
	{
        0, -1, -2,
        -1, 0, -2,

        -1, -2, -1, 1, -2, -1,
        -2, -1, -1, 2, -1, -1,
        2, 0, -1,
        -2, 1, -1, 1, 1, -1,
        -1, 2, -1, 0, 2, -1,

        -1, -2, 0, 1, -2, 0,
        -2, -1, 0, 2, -1, 0,
        2, 0, 0,
        -2, 1, 0, 1, 1, 0,
        -1, 2, 0, 0, 2, 0,

        0, -1, 1,
        -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"twist (p4)"},
#endif
	{
        -1, -1, -3, 0, -1, -3,
        -1, 0, -3, 0, 0, -3,

        -2, -1, -2, 1, -1, -2,
        -2, 0, -2, 1, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, 1, -1, 1,
        -2, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,

        -2, -1, 2, 1, -1, 2,
        -2, 0, 2, 1, 0, 2,

        -1, -1, 3, 0, -1, 3,
        -1, 0, 3, 0, 0, 3,
        127
	},
#ifdef LIFE_NAMES
	{"large spider (p4)"},
#endif
	{
        0, -2, -1,
        -1, -1, -1, 0, -1, -1, 1, -1, -1,
        -2, 0, -1, -1, 0, -1, 1, 0, -1, 2, 0, -1,
        -1, 1, -1, 0, 1, -1, 1, 1, -1,
        0, 2, -1,

        -1, -2, 0, 1, -2, 0,
        -2, -1, 0, -1, -1, 0, 1, -1, 0, 2, -1, 0,
        -2, 1, 0, -1, 1, 0, 1, 1, 0, 2, 1, 0,
        -1, 2, 0, 1, 2, 0,

        0, -2, 1,
        0, -1, 1,
        -2, 0, 1, -1, 0, 1, 1, 0, 1, 2, 0, 1,
        0, 1, 1,
        0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"stretched twist (p4)"},
#endif
	{
        -1, -1, -4, 0, -1, -4,
        -1, 0, -4, 0, 0, -4,

        -2, -1, -3, 1, -1, -3,
        -2, 0, -3, 1, 0, -3,

        -1, -2, -2, 0, -2, -2,
        -2, -1, -2, 1, -1, -2,
        -2, 0, -2, 1, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -2, 2, 0, -2, 2,
        -2, -1, 2, 1, -1, 2,
        -2, 0, 2, 1, 0, 2,
        -1, 1, 2, 0, 1, 2,

        -2, -1, 3, 1, -1, 3,
        -2, 0, 3, 1, 0, 3,

        -1, -1, 4, 0, -1, 4,
        -1, 0, 4, 0, 0, 4,
        127
	},
#ifdef LIFE_NAMES
	{"spinning top (p4)"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1,
        -1, -1, -1, 0, -1, -1, 1, -1, -1,
        -2, 0, -1, -1, 0, -1, 0, 0, -1,
        0, 1, -1,

        -1, -3, 0, 0, -3, 0,
        -2, -2, 0, 1, -2, 0,
        -3, -1, 0, 2, -1, 0,
        -3, 0, 0, 2, 0, 0,
        -2, 1, 0, 1, 1, 0,
        -1, 2, 0, 0, 2, 0,

        -2, -2, 1, -1, -2, 1, 1, -2, 1,
        1, -1, 1,
        -2, 0, 1,
        -2, 1, 1, 0, 1, 1, 1, 1, 1,

        -1, -2, 2, 0, -2, 2,
        -2, -1, 2, 1, -1, 2,
        -2, 0, 2, 1, 0, 2,
        -1, 1, 2, 0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"spider (p6)"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -1, -1, -2, 0, -1, -2,

        -1, -2, -1, 0, -2, -1,
        -1, -1, -1, 0, -1, -1,

        0, -3, 0,
        -2, -2, 0,
        1, -1, 0,
        -1, 0, 0,

        0, -3, 1,
        -2, -2, 1,
        1, -1, 1,
        -1, 0, 1,

        0, -3, 2,
        -2, -2, 2,
        1, -1, 2,
        -1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"corner gear (p6)"},
#endif
	{
        1, 0, -4, 2, 0, -4,
        1, 2, -4,

        2, -2, -3, 3, -2, -3,
        1, 0, -3, 2, 0, -3,
        -1, 2, -3, 1, 2, -3,
        -1, 3, -3,

        -3, 2, -2, -1, 2, -2,
        -3, 3, -2, -1, 3, -2,

        2, -3, -1, 3, -3, -1,
        2, -2, -1, 3, -2, -1,

        -4, 1, 0, -3, 1, 0,
        -4, 2, 0, -3, 2, 0,

        0, -4, 1, 2, -4, 1,
        0, -3, 1, 2, -3, 1,

        0, -4, 2,
        -2, -3, 2, 0, -3, 2,
        -3, -1, 2, -2, -1, 2,
        -4, 1, 2, -3, 1, 2,

        -2, -3, 3,
        -3, -1, 3, -2, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"spider (p8)"},
#endif
	{
        0, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2, 1, 0, -2,
        -1, 1, -2,

        0, -2, -1,
        -2, -1, -1,
        1, 0, -1,
        -1, 1, -1,

        0, -2, 0,
        -2, -1, 0,
        1, 0, 0,
        -1, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"less than greater than (p12)"},
#endif
	{
        2, -1, -1,
        -2, 0, -1, -1, 0, -1, 1, 0, -1, 2, 0, -1,
        -2, 1, -1,

        2, -1, 0,
        -2, 0, 0, -1, 0, 0, 1, 0, 0, 2, 0, 0,
        -2, 1, 0,
        127
	},
};

static char patterns_26B67S67[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"orthogonal glider (40 cell p2)"},
#endif
	{
        -1, -3, -1, 0, -3, -1,
        -2, -2, -1, 1, -2, -1,
        -3, -1, -1, 2, -1, -1,
        -3, 0, -1, 2, 0, -1,
        -2, 1, -1, 1, 1, -1,
        -1, 2, -1, 0, 2, -1,

        -2, -3, 0, -1, -3, 0,
        2, -2, 0,
        2, -1, 0,
        -3, 0, 0,
        -3, 1, 0,
        0, 2, 0, 1, 2, 0,

        -1, -3, 1, 0, -3, 1,
        -2, -2, 1, -1, -2, 1, 0, -2, 1, 1, -2, 1,
        -3, -1, 1, -2, -1, 1, 1, -1, 1, 2, -1, 1,
        -3, 0, 1, -2, 0, 1, 1, 0, 1, 2, 0, 1,
        -2, 1, 1, -1, 1, 1, 0, 1, 1, 1, 1, 1,
        -1, 2, 1, 0, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"S"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        -1, 0, -1, 0, 0, -1,

        0, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"S1"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        0, 0, -1,

        -1, -1, 0, 0, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"S2"},
#endif
	{
        0, -1, -1, 1, -1, -1,
        -1, 0, -1, 0, 0, -1,

        -1, -1, 0, 0, -1, 0, 1, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"T"},
#endif
	{
        1, 0, -1,

        1, -1, 0,
        -1, 0, 0, 0, 0, 0, 1, 0, 0,
        1, 1, 0,

        1, 0, 1,
        1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"arrow"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 0, 0, -1,
        1, 1, -1,

        0, -1, 0,
        -1, 0, 0, 0, 0, 0,
        1, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"runner"},
#endif
	{
        -1, -1, -1, 0, -1, -1,
        -2, 0, -1, -1, 0, -1,

        -2, -1, 0, -1, -1, 0,
        -1, 0, 0, 0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"walker"},
#endif
	{
        0, -1, -1,
        -1, 0, -1, 0, 0, -1, 1, 0, -1,

        -1, -1, 0, 0, -1, 0, 1, -1, 0,
        0, 0, 0,
        127
	},
#ifdef LIFE_NAMES
	{"triknot"},
#endif
	{
        0, -1, -1,
        0, 0, -1,

        0, -1, 0,
        -1, 0, 0, 1, 0, 0,
        0, 1, 0, 1, 1, 0,

        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pile driver"},
#endif
	{
        0, 0, -1, 1, 0, -1,
        1, 1, -1,

        0, -1, 0, 1, -1, 0,
        -1, 0, 0,
        0, 1, 0, 1, 1, 0,

        1, -1, 1,
        0, 0, 1, 1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"clock"},
#endif
	{
        -1, -1, -2,
        -1, 0, -2,

        -1, -1, -1, 1, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -2, -1, 0, 0, -1, 0,
        -2, 0, 0, 0, 0, 0,

        0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"worm sandwich"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        -1, -1, -1, 0, -1, -1,
        -2, 0, -1,
        -2, 1, -1, -1, 1, -1, 0, 1, -1,

        -1, -1, 0, 0, -1, 0, 1, -1, 0,
        1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"worm sandwich2"},
#endif
	{
        -1, -1, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -1, 0, -1, 0, 0, -1, 1, 0, -1,

        -2, -2, 0, -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -1, 0, 0, 0, 0, 0,

        0, -1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"triple switch"},
#endif
	{
        -1, 0, -2,

        0, -2, -1,
        -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,

        -2, -1, 0, -1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        1, 2, 0,

        0, -1, 1,
        1, 0, 1, 2, 0, 1,
        0, 1, 1, 1, 1, 1,

        0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"3 switch"},
#endif
	{
        -1, 0, -2, 0, 0, -2,

        0, -2, -1,
        -1, -1, -1, 1, -1, -1,
        1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"knot switch"},
#endif
	{
        -1, 0, -2,

        0, -2, -1, -1, -1, -1, 0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        -2, -1, 0, -1, -1, 0,
        -1, 1, 0, 1, 1, 0,
        1, 2, 0,

        0, -1, 1,
        1, 0, 1, 2, 0, 1,
        0, 1, 1, 2, 1, 1,
        1, 2, 1,

        0, 1, 2, 1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"2 arrows"},
#endif
	{
        -2, -1, -1, 1, -1, -1,
        -4, 0, -1, -3, 0, -1, -1, 0, -1, 0, 0, -1, 2, 0, -1, 3, 0, -1,
        -3, 1, -1, 2, 1, -1,

        -2, -1, 0, 1, -1, 0,
        -4, 0, 0, -3, 0, 0, -1, 0, 0, 0, 0, 0, 2, 0, 0, 3, 0, 0,
        -3, 1, 0, 2, 1, 0,
        127
	},
#ifdef LIFE_NAMES
	{"fat walker"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1,

        0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"walking box"},
#endif
	{
        -1, -1, -2,
        0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"spinning box"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"double knot"},
#endif
	{
        -1, -1, -2, 0, -1, -2,

        -1, -2, -1,
        -2, -1, -1, 0, -1, -1,
        -2, 0, -1, -1, 0, -1,
        0, 1, -1,

        -1, -2, 0,
        -1, -1, 0, 1, -1, 0,
        1, 1, 0, 2, 1, 0,

        -1, 0, 1, 1, 0, 1,
        0, 1, 1, 2, 1, 1,
        0, 2, 1, 1, 2, 1,

        1, 0, 2,
        1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"planetary war"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        -1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        1, 0, 0,
        -1, 1, 0, 0, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"fat walker2"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -2, 0, 0, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -1, 1, 0,

        -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"pop change"},
#endif
	{
        0, 0, -2,

        0, -1, -1,
        -1, 0, -1, 2, 0, -1,
        0, 1, -1, 1, 1, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 2, 0, 0, 2, 0, 1, 2, 0,

        1, -1, 1,
        -1, 0, 1, 2, 0, 1,
        -1, 1, 1, 1, 1, 1,

        0, -1, 2,
        0, 0, 2,
        0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"large pile driver"},
#endif
	{
        -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -2, -1, -1, -1, -1, -1, 1, -1, -1, 2, -1, -1,
        -2, 0, -1, 2, 0, -1,
        -2, 1, -1, -1, 1, -1, 1, 1, -1, 2, 1, -1,
        -1, 2, -1, 0, 2, -1, 1, 2, -1,

        0, -2, 0,
        -1, -1, 0, 1, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0, 1, 1, 0,
        0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"F"},
#endif
	{
        1, 0, -2, 2, 0, -2,
        -1, 1, -2,
        -1, 2, -2, 1, 2, -2,

        1, -2, -1, 2, -2, -1,
        2, -1, -1,
        2, 0, -1,
        1, 1, -1,
        -1, 2, -1, 1, 2, -1,

        -2, 1, 0,
        -2, 2, 0, -1, 2, 0,

        0, -2, 1, 2, -2, 1,
        -2, -1, 1, 1, -1, 1, 2, -1, 1,
        -1, 1, 1,

        0, -2, 2,
        -2, -1, 2, -1, -1, 2, 0, -1, 2,
        -2, 1, 2, -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"4Y"},
#endif
	{
        0, -2, -1,
        -2, 0, -1, 2, 0, -1,
        0, 2, -1,

        -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -2, -1, 0, 2, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -2, 1, 0, 2, 1, 0,
        -1, 2, 0, 0, 2, 0, 1, 2, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, 0, -1, 1, 2, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1, 2, 1, 1,
        -1, 2, 1, 1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"blob2"},
#endif
	{
        0, 0, -2, 1, 0, -2, 2, 0, -2,
        0, 1, -2, 1, 1, -2,
        1, 2, -2,

        1, -1, -1,
        2, 0, -1,
        -1, 1, -1,
        1, 2, -1,

        0, -2, 0, 1, -2, 0,
        -2, 0, 0,
        -2, 1, 0, 1, 1, 0,
        -2, 2, 0, -1, 2, 0,

        0, -2, 1, 1, -2, 1, 2, -2, 1,
        -1, -1, 1, 2, -1, 1,
        -2, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1,

        0, -2, 2,
        0, -1, 2,
        -2, 1, 2, -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"stuff"},
#endif
	{
        1, 0, -2, 2, 0, -2,
        0, 1, -2, 1, 1, -2,
        1, 2, -2,

        1, -1, -1, 2, -1, -1,
        2, 0, -1,
        -1, 1, -1,
        -1, 2, -1, 0, 2, -1, 1, 2, -1,

        1, -2, 0,
        2, -1, 0,
        -2, 1, 0,
        -2, 2, 0, -1, 2, 0,

        0, -2, 1, 1, -2, 1, 2, -2, 1,
        -1, -1, 1, 2, -1, 1,
        -2, 0, 1,
        -2, 1, 1,

        0, -2, 2,
        -1, -1, 2, 0, -1, 2,
        -1, 0, 2,
        -2, 1, 2, -1, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"3 fins"},
#endif
	{
        0, -2, -2, 1, -2, -2, 2, -2, -2,
        0, -1, -2, 1, -1, -2, 2, -1, -2,
        -2, 0, -2,
        -2, 1, -2,
        -2, 2, -2,
        1, -1, -1,
        -2, 0, -1,
        -2, 1, -1, -1, 1, -1, 0, 1, -1,
        -2, 2, -1,
        -2, -2, 0, -1, -2, 0,
        1, -1, 0,
        1, 0, 0,
        0, 1, 0, 1, 1, 0,
        -2, -2, 1, -1, -2, 1,
        -1, -1, 1,
        -1, 0, 1, 0, 0, 1, 1, 0, 1,
        0, 1, 1, 1, 1, 1,
        -2, -2, 2, -1, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"solitaire"},
#endif
	{
        -1, -3, -1, 0, -3, -1, 1, -3, -1,
        -3, -1, -1, -1, -1, -1, 1, -1, -1, 3, -1, -1,
        -3, 0, -1, 3, 0, -1,
        -3, 1, -1, -1, 1, -1,
        1, 1, -1, 3, 1, -1,
        -1, 3, -1, 0, 3, -1, 1, 3, -1,

        -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -3, -1, 0, -1, -1, 0, 1, -1, 0, 3, -1, 0,
        -3, 0, 0, 3, 0, 0,
        -3, 1, 0, -1, 1, 0,
        1, 1, 0, 3, 1, 0,
        -1, 3, 0, 0, 3, 0, 1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"tic tac toe"},
#endif
	{
        -3, -3, -1, -2, -3, -1, 1, -3, -1, 2, -3, -1,
        -3, -2, -1, 2, -2, -1,
        -3, 1, -1, 2, 1, -1,
        -3, 2, -1, -2, 2, -1, 1, 2, -1, 2, 2, -1,

        -2, -3, 0, 1, -3, 0,
        -3, -2, 0, -2, -2, 0, -1, -2, 0, 0, -2, 0, 1, -2, 0, 2, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -3, 1, 0, -2, 1, 0, -1, 1, 0, 0, 1, 0, 1, 1, 0, 2, 1, 0,
        -2, 2, 0, 1, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"square peg"},
#endif
	{
        -1, -4, -1, 0, -4, -1,
        -1, -3, -1, 0, -3, -1,
        -2, -2, -1, 1, -2, -1,
        -4, -1, -1, -3, -1, -1, -1, -1, -1,
        0, -1, -1, 2, -1, -1, 3, -1, -1,
        -4, 0, -1, -3, 0, -1, -1, 0, -1, 0, 0, -1, 2, 0, -1, 3, 0, -1,
        -2, 1, -1, 1, 1, -1,
        -1, 2, -1, 0, 2, -1,
        -1, 3, -1, 0, 3, -1,

        -1, -3, 0, 0, -3, 0,
        -2, -2, 0, 1, -2, 0,
        -3, -1, 0, 2, -1, 0,
        -3, 0, 0, 2, 0, 0,
        -2, 1, 0, 1, 1, 0,
        -1, 2, 0, 0, 2, 0,
        127
	},
#ifdef LIFE_NAMES
	{"large solitaire"},
#endif
	{
        -1, -5, -1, 0, -5, -1,
        -3, -3, -1, -2, -3, -1, 1, -3, -1, 2, -3, -1,
        -3, -2, -1, 2, -2, -1,
        -5, -1, -1, 4, -1, -1,
        -5, 0, -1, 4, 0, -1,
        -3, 1, -1, 2, 1, -1,
        -3, 2, -1, -2, 2, -1, 1, 2, -1, 2, 2, -1,
        -1, 4, -1, 0, 4, -1,

        -1, -5, 0, 0, -5, 0,
        -3, -3, 0, -2, -3, 0, 1, -3, 0, 2, -3, 0,
        -3, -2, 0, 2, -2, 0,
        -5, -1, 0, 4, -1, 0,
        -5, 0, 0, 4, 0, 0,
        -3, 1, 0, 2, 1, 0,
        -3, 2, 0, -2, 2, 0, 1, 2, 0, 2, 2, 0,
        -1, 4, 0,
        0, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"pancake"},
#endif
	{
        -2, -3, -1, 0, -3, -1, 2, -3, -1,
        -3, -2, -1, 3, -2, -1,
        -3, 0, -1, 3, 0, -1,
        -3, 2, -1, 3, 2, -1,
        -2, 3, -1, 0, 3, -1, 2, 3, -1,

        -2, -3, 0, 0, -3, 0, 2, -3, 0,
        -3, -2, 0, -2, -2, 0, 2, -2, 0, 3, -2, 0,
        -3, 0, 0, 3, 0, 0,
        -3, 2, 0, -2, 2, 0, 2, 2, 0, 3, 2, 0,
        -2, 3, 0, 0, 3, 0, 2, 3, 0,

        -2, -3, 1, 0, -3, 1, 2, -3, 1,
        -3, -2, 1, 3, -2, 1,
        -3, 0, 1, 3, 0, 1,
        -3, 2, 1, 3, 2, 1,
        -2, 3, 1, 0, 3, 1, 2, 3, 1,
        127
	},
#ifdef LIFE_NAMES
	{"arrow beacon (p4)"},
#endif
	{
        1, -2, -2,
        1, -1, -2, 2, -1, -2,
        0, 0, -2,

        1, -2, -1,
        1, -1, -1, 2, -1, -1,
        0, 0, -1,

        -2, 1, 0,
        -2, 2, 0, -1, 2, 0,

        -2, 1, 1, -1, 1, 1,
        -2, 2, 1, -1, 2, 1,
        127
	},
#ifdef LIFE_NAMES
	{"sticks (p4)"},
#endif
	{
        0, 0, -2, 2, 0, -2,
        0, 1, -2,
        0, 2, -2,

        1, -1, -1,
        2, 0, -1,
        -1, 1, -1, 1, 1, -1,

        0, -2, 0, 1, -2, 0, 2, -2, 0,
        -2, 0, 0, 2, 0, 0,
        -2, 2, 0, -1, 2, 0, 0, 2, 0,

        -1, -1, 1, 1, -1, 1,
        -2, 0, 1,
        -1, 1, 1,

        0, -2, 2,
        0, -1, 2,
        -2, 0, 2, 0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"demanding (p4)"},
#endif
	{
        0, -2, -3,

        0, -3, -2,
        -1, -2, -2, 1, -2, -2,
        0, -1, -2,

        1, -4, -1,
        -1, -3, -1, 2, -3, -1,
        -2, -1, -1, 1, -1, -1,
        -1, 0, -1,

        1, -4, 0,
        -1, -3, 0, 2, -3, 0,
        -2, -1, 0, 1, -1, 0,
        -1, 0, 0,

        1, -4, 1,
        0, -3, 1, 2, -3, 1,
        -1, -2, 1, 0, -2, 1, 1, -2, 1,
        -2, -1, 1, 0, -1, 1,
        -1, 0, 1,

        0, -2, 2,
        127
	},
#ifdef LIFE_NAMES
	{"blob (p4)"},
#endif
	{
        -1, -1, -2, 1, -1, -2,
        -1, 0, -2, 1, 0, -2,
        -1, 1, -2,

        -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -2, -1, -1,
        2, 0, -1,
        -2, 1, -1, 1, 1, -1,
        0, 2, -1,

        -2, -1, 0, 2, -1, 0,
        2, 0, 0,
        -2, 1, 0,
        -1, 2, 0, 0, 2, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, 1, -1, 1,
        -1, 1, 1, 1, 1, 1,

        0, -1, 2,
        -1, 0, 2, 0, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"tomato sandwich (p4)"},
#endif
	{
        -1, -1, -2, 0, -1, -2,
        -2, 0, -2, 1, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -1, -2, -1, 0, -2, -1,
        -1, 2, -1, 0, 2, -1,

        -2, -2, 0, 1, -2, 0,
        -2, -1, 0, 1, -1, 0,
        -3, 0, 0, 2, 0, 0,
        -2, 1, 0, 1, 1, 0,
        -2, 2, 0, 1, 2, 0,

        -1, -2, 1, 0, -2, 1,
        -1, 2, 1, 0, 2, 1,

        -1, -1, 2, 0, -1, 2,
        -2, 0, 2, 1, 0, 2,
        -1, 1, 2, 0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"pump (p4)"},
#endif
	{
        -1, -1, -2, 1, -1, -2,
        -1, 1, -2, 1, 1, -2,

        0, -1, -1,
        -1, 0, -1, 1, 0, -1,
        0, 1, -1,

        -1, -2, 0, 0, -2, 0, 1, -2, 0,
        -2, -1, 0, 2, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -2, 1, 0, 2, 1, 0,
        -1, 2, 0, 0, 2, 0, 1, 2, 0,

        -1, -1, 1, 0, -1, 1, 1, -1, 1,
        -1, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1, 1, 1, 1,

        0, -1, 2,
        -1, 0, 2, 1, 0, 2,
        0, 1, 2,
        127
	},
#ifdef LIFE_NAMES
	{"L-gate (p4)"},
#endif
	{
        0, -5, -1,
        0, -4, -1,
        1, -3, -1,
        -2, -2, -1,
        -4, -1, -1, -3, -1, -1, 3, -1, -1, 4, -1, -1,
        2, 0, -1,
        -1, 1, -1,
        0, 2, -1,
        0, 3, -1,

        0, -5, 0,
        0, -4, 0,
        -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -2, -2, 0, 2, -2, 0,
        -4, -1, 0, -3, -1, 0, -2, -1, 0, 2, -1, 0, 3, -1, 0, 4, -1, 0,
        -2, 0, 0, 2, 0, 0,
        -1, 1, 0, 0, 1, 0, 1, 1, 0,
        0, 2, 0,
        0, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4 tripods (p4)"},
#endif
	{
        0, -4, -1,
        -2, -3, -1,
        0, -2, -1, 2, -2, -1,
        -4, -1, -1, -2, -1, -1,
        1, 0, -1, 3, 0, -1,
        -3, 1, -1, -1, 1, -1,
        1, 2, -1,
        -1, 3, -1,

        0, -4, 0,
        -2, -3, 0, -1, -3, 0, 0, -3, 0,
        0, -2, 0, 2, -2, 0,
        -4, -1, 0, -3, -1, 0, -2, -1, 0, 2, -1, 0,
        -3, 0, 0, 1, 0, 0, 2, 0, 0, 3, 0, 0,
        -3, 1, 0, -1, 1, 0,
        -1, 2, 0, 0, 2, 0, 1, 2, 0,
        -1, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4 tripods2 (p4)"},
#endif
	{
        -1, -4, -1,
        1, -3, -1,
        -3, -2, -1, -2, -2, -1, 1, -2, -1,
        3, -1, -1,
        -4, 0, -1,
        -2, 1, -1, 1, 1, -1, 2, 1, -1,
        -2, 2, -1,
        0, 3, -1,

        -1, -4, 0,
        -1, -3, 0, 0, -3, 0, 1, -3, 0,
        -3, -2, 0, -2, -2, 0, 1, -2, 0,
        -3, -1, 0, 2, -1, 0, 3, -1, 0,
        -4, 0, 0, -3, 0, 0, 2, 0, 0,
        -2, 1, 0, 1, 1, 0, 2, 1, 0,
        -2, 2, 0, -1, 2, 0, 0, 2, 0,
        0, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"star (p4)"},
#endif
	{
        0, -2, -2,
        -2, -1, -2, -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2, 1, 0, -2,
        -1, 1, -2,

        -1, -2, -1, 0, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1, 1, 0, -1,
        -1, 1, -1, 0, 1, -1,

        0, -3, 0,
        -1, -2, 0, 0, -2, 0,
        -3, -1, 0, -2, -1, 0, 1, -1, 0,
        -2, 0, 0, 1, 0, 0, 2, 0, 0,
        -1, 1, 0, 0, 1, 0,
        -1, 2, 0,

        0, -2, 1,
        -2, -1, 1, -1, -1, 1, 0, -1, 1,
        -1, 0, 1, 0, 0, 1, 1, 0, 1,
        -1, 1, 1,
        127
	},
#ifdef LIFE_NAMES
	{"corner (p4)"},
#endif
	{
        1, 1, -3,
        1, 2, -3,

        1, 1, -2, 2, 1, -2,
        1, 2, -2, 2, 2, -2,

        1, 1, -1,
        2, 2, -1,

        1, 2, 0, 2, 2, 0,

        1, -3, 1, 2, -3, 1,
        1, -2, 1, 2, -2, 1,
        1, -1, 1,
        2, 0, 1,
        -3, 1, 1, -2, 1, 1, -1, 1, 1, 3, 1, 1,
        -2, 2, 1,
        1, 3, 1, 2, 3, 1,

        1, -2, 2, 2, -2, 2,
        2, -1, 2,
        2, 0, 2,
        -3, 1, 2, -2, 1, 2, 0, 1, 2, 3, 1, 2,
        -2, 2, 2, -1, 2, 2, 0, 2, 2, 2, 2, 2,

        1, 1, 3,
        1, 2, 3,
        127
	},
#ifdef LIFE_NAMES
	{"corner2 (p4)"},
#endif
	{
        -2, -1, -3, -1, -1, -3,

        -1, -3, -2,
        -2, -2, -2, 0, -2, -2, 2, -2, -2, 3, -2, -2,
        1, -1, -2, 2, -1, -2,
        -2, 0, -2, -1, 0, -2,
        -1, 1, -2,
        -2, 2, -2, -1, 2, -2,
        -2, 3, -2, -1, 3, -2,

        -1, -3, -1,
        -3, -2, -1, 0, -2, -1, 1, -2, -1, 2, -2, -1, 3, -2, -1,
        -3, -1, -1, 2, -1, -1,
        -2, 1, -1,
        -2, 2, -1, -1, 2, -1,

        -2, -2, 0,
        -2, -1, 0,

        -1, -2, 1,
        -2, -1, 1,

        -2, -2, 2, -1, -2, 2,
        -2, -1, 2, -1, -1, 2,

        -2, -2, 3,
        -2, -1, 3,
        127
	},
#ifdef LIFE_NAMES
	{"castle walls (p4)"},
#endif
	{
        -1, -4, -1, 0, -4, -1, 1, -4, -1,
        -2, -3, -1,
        -4, -2, -1, -2, -2, -1, 1, -2, -1, 2, -2, -1,
        -4, -1, -1, 3, -1, -1,
        -4, 0, -1, 3, 0, -1,
        -3, 1, -1, -2, 1, -1, 1, 1, -1, 3, 1, -1,
        1, 2, -1,
        -2, 3, -1, -1, 3, -1, 0, 3, -1,

        -1, -4, 0, 0, -4, 0, 1, -4, 0,
        1, -3, 0,
        -4, -2, 0, -3, -2, 0, -2, -2, 0, 1, -2, 0,
        -4, -1, 0, 3, -1, 0,
        -4, 0, 0, 3, 0, 0,
        -2, 1, 0, 1, 1, 0, 2, 1, 0, 3, 1, 0,
        -2, 2, 0,
        -2, 3, 0, -1, 3, 0, 0, 3, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4 tripods3 (p4)"},
#endif
	{
        1, -4, -1,
        -3, -3, -1, 1, -3, -1, 3, -3, -1,
        -1, -2, -1,
        -4, -1, -1, -3, -1, -1, 2, -1, -1,
        -2, 1, -1, 3, 1, -1, 4, 1, -1,
        1, 2, -1,
        -3, 3, -1, -1, 3, -1, 3, 3, -1,
        -1, 4, -1,

        1, -4, 0,
        -3, -3, 0, 2, -3, 0, 3, -3, 0,
        -3, -2, 0, -2, -2, 0, -1, -2, 0, 1, -2, 0, 2, -2, 0,
        -4, -1, 0, -2, -1, 0, 2, -1, 0,
        -2, 1, 0, 2, 1, 0, 4, 1, 0,
        -2, 2, 0, -1, 2, 0, 1, 2, 0, 2, 2, 0, 3, 2, 0,
        -3, 3, 0, -2, 3, 0, 3, 3, 0,
        -1, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"4 tripods4 (p4)"},
#endif
	{
        0, -4, -1,
        -2, -3, -1, 0, -3, -1,
        0, -2, -1, 1, -2, -1, 3, -2, -1,
        -2, -1, -1,
        -4, 0, -1, -3, 0, -1, -2, 0, -1, 2, 0, -1, 3, 0, -1, 4, 0, -1,
        2, 1, -1,
        -3, 2, -1, -1, 2, -1, 0, 2, -1,
        0, 3, -1, 2, 3, -1,
        0, 4, -1,

        0, -4, 0,
        -2, -3, 0, -1, -3, 0,
        -1, -2, 0, 1, -2, 0, 3, -2, 0,
        -2, -1, 0, 2, -1, 0, 3, -1, 0,
        -4, 0, 0, 4, 0, 0,
        -3, 1, 0, -2, 1, 0, 2, 1, 0,
        -3, 2, 0, -1, 2, 0, 1, 2, 0,
        1, 3, 0, 2, 3, 0,
        0, 4, 0,
        127
	},
#ifdef LIFE_NAMES
	{"mouse (p6)"},
#endif
	{
        0, -1, -2, 1, -1, -2,
        -1, 0, -2,
        -1, 1, -2,

        -1, -2, -1, 0, -2, -1, 1, -2, -1,
        -2, -1, -1, 1, -1, -1,
        -2, 0, -1,
        -2, 1, -1, -1, 1, -1,

        0, -2, 0, 1, -2, 0,
        1, -1, 0,
        -2, 0, 0, 1, 0, 0,
        -2, 1, 0, -1, 1, 0, 0, 1, 0,

        0, -2, 1,
        0, -1, 1,
        -2, 0, 1, -1, 0, 1,
        127
	},
#ifdef LIFE_NAMES
	{"shuttlecock (p8)"},
#endif
	{
        -1, -2, -3,
        -2, -1, -3, 0, -1, -3,

        -1, -3, -2,
        -2, -2, -2, 0, -2, -2,
        -3, -1, -2, 1, -1, -2,
        -2, 0, -2,
        -1, 1, -2, 0, 1, -2,
        1, 1, -2,

        -2, -3, -1,
        -3, -2, -1, 1, -2, -1,
        1, -1, -1,
        -3, 0, -1, 1, 0, -1,
        -2, 1, -1, -1, 1, -1,
        0, 2, -1,

        -1, -3, 0,
        -2, -2, 0, 1, -2, 0,
        2, -1, 0,
        -1, 1, 0, 1, 1, 0,

        -1, -2, 1, 1, -2, 1,
        -2, -1, 1, -1, -1, 1,
        0, -1, 1,
        -2, 0, 1, 1, 0, 1,
        -2, 1, 1, 0, 1, 1,

        -1, 0, 2,
        127
	},
#ifdef LIFE_NAMES
	{"transformer (p10)"},
#endif
	{
        -1, -2, -2, 0, -2, -2,
        -1, -1, -2, 0, -1, -2,
        -1, 0, -2, 0, 0, -2,
        -1, 1, -2, 0, 1, -2,

        -2, -2, -1, 1, -2, -1,
        -2, 1, -1, 1, 1, -1,

        -1, -3, 0, 0, -3, 0,
        -1, 2, 0, 0, 2, 0,

        -1, -2, 1, 0, -2, 1,
        -2, -1, 1, 1, -1, 1,
        -2, 0, 1, 1, 0, 1,
        -1, 1, 1, 0, 1, 1,

        -1, -2, 2, 0, -2, 2,
        -1, -1, 2, 0, -1, 2,
        -1, 0, 2, 0, 0, 2,
        -1, 1, 2, 0, 1, 2,
        127
	},
};
/* Above generated from java Life3DForms | dos2unix */
/* https://www.sillycycle.com/life.html */

#ifdef LIFE_NAMES
#define PAT_SPACE 2
#else
#define PAT_SPACE 1
#endif
#define pattern_size(p) (sizeof p / sizeof *p) / PAT_SPACE

static int  patterns_12rules[] =
{
	(sizeof patterns_12B3S3 / sizeof patterns_12B3S3[0]) / PAT_SPACE,
	(sizeof patterns_12B3S456 / sizeof patterns_12B3S456[0]) / PAT_SPACE,
};

static int  patterns_14rules[] =
{
	(sizeof patterns_14B4S34 / sizeof patterns_14B4S34[0]) / PAT_SPACE,
	(sizeof patterns_14B46S34 / sizeof patterns_14B46S34[0]) / PAT_SPACE,
	(sizeof patterns_14B45S56 / sizeof patterns_14B45S56[0]) / PAT_SPACE,
};

static int  patterns_18rules[] =
{
	(sizeof patterns_18B4S45 / sizeof patterns_18B4S45[0]) / PAT_SPACE,
};

static int  patterns__18rules[] =
{
	(sizeof patterns__18B4S36 / sizeof patterns__18B4S36[0]) / PAT_SPACE,
	(sizeof patterns__18B4S46 / sizeof patterns__18B4S46[0]) / PAT_SPACE,
	(sizeof patterns__18B4S45 / sizeof patterns__18B4S45[0]) / PAT_SPACE,
	(sizeof patterns__18B4S456 / sizeof patterns__18B4S456[0]) / PAT_SPACE,
};

static int  patterns_20rules[] =
{
	(sizeof patterns_20B4S45 / sizeof patterns_20B4S45[0]) / PAT_SPACE,
};

static int  patterns_22rules[] =
{
	(sizeof patterns_22B4S3 / sizeof patterns_22B4S3[0]) / PAT_SPACE,
	(sizeof patterns_22B4S4 / sizeof patterns_22B4S4[0]) / PAT_SPACE,
	(sizeof patterns_22B4S57 / sizeof patterns_22B4S57[0]) / PAT_SPACE,
};

static int  patterns_26rules[] =
{
	(sizeof patterns_26B5S23 / sizeof patterns_26B5S23[0]) / PAT_SPACE,
	(sizeof patterns_26B5S25 / sizeof patterns_26B5S25[0]) / PAT_SPACE,
	(sizeof patterns_26B5S27 / sizeof patterns_26B5S27[0]) / PAT_SPACE,
	(sizeof patterns_26B5S35 / sizeof patterns_26B5S35[0]) / PAT_SPACE,
	(sizeof patterns_26B5S36 / sizeof patterns_26B5S36[0]) / PAT_SPACE,
	(sizeof patterns_26B5S37 / sizeof patterns_26B5S37[0]) / PAT_SPACE,
	(sizeof patterns_26B5S38 / sizeof patterns_26B5S38[0]) / PAT_SPACE,
	(sizeof patterns_26B5S4 / sizeof patterns_26B5S4[0]) / PAT_SPACE,
	(sizeof patterns_26B5S45 / sizeof patterns_26B5S45[0]) / PAT_SPACE,
	(sizeof patterns_26B5S47 / sizeof patterns_26B5S47[0]) / PAT_SPACE,
	(sizeof patterns_26B5S56 / sizeof patterns_26B5S56[0]) / PAT_SPACE,
	(sizeof patterns_26B5S58 / sizeof patterns_26B5S58[0]) / PAT_SPACE,
	(sizeof patterns_26B5S678 / sizeof patterns_26B5S678[0]) / PAT_SPACE,
	(sizeof patterns_26B5S8 / sizeof patterns_26B5S8[0]) / PAT_SPACE,
	(sizeof patterns_26B58S58 / sizeof patterns_26B58S58[0]) / PAT_SPACE,
	(sizeof patterns_26B6S567 / sizeof patterns_26B6S567[0]) / PAT_SPACE,
	(sizeof patterns_26B6S57 / sizeof patterns_26B6S57[0]) / PAT_SPACE,
	(sizeof patterns_26B67S57 / sizeof patterns_26B67S57[0]) / PAT_SPACE,
	(sizeof patterns_26B67S67 / sizeof patterns_26B67S67[0]) / PAT_SPACE,
};

/*static paramstruct param_6rules[] =
{
};

static paramstruct param_8rules[] =
{
};*/

static paramstruct param_12rules[] =
{
	{0x8, 0x8}, /* LIFE_12B3S3 */
	{0x8, 0x70}, /* LIFE_12B3S456 */
};

static paramstruct param_14rules[] =
{
	{0x10, 0x18}, /* LIFE_14B4S34 */
	{0x50, 0x18}, /* LIFE_14B46S34 */
	{0x30, 0x60}, /* LIFE_14SB45S56 */
};

/*static paramstruct param__14rules[] =
{
};

static paramstruct param_16rules[] =
{
};*/

static paramstruct param_18rules[] =
{
	{0x10, 0x30}, /* LIFE_18B4S45 */
};

static paramstruct param__18rules[] =
{
	{0x10, 0x48}, /* LIFE_18B4S36 */
	{0x10, 0x50}, /* LIFE_18B4S46 */
	{0x10, 0x30}, /* LIFE_18B4S45 */
	{0x10, 0x70}, /* LIFE_18B4S456 */
};

static paramstruct param_20rules[] =
{
	{0x10, 0x30}, /* LIFE_20B4S45 */
};

static paramstruct param_22rules[] =
{
	{0x10, 0x8}, /* LIFE_22B4S3 */
	{0x10, 0x10}, /* LIFE_22B4S4 */
	{0x10, 0xA0}, /* LIFE_22B4S57 */
};

static paramstruct param_26rules[] =
{
	{0x20, 0xC}, /* LIFE_26B5S23 */
	{0x20, 0x24}, /* LIFE_26B5S25 */
	{0x20, 0x84}, /* LIFE_26B5S27 */
	{0x20, 0x28}, /* LIFE_26B5S35 */
	{0x20, 0x48}, /* LIFE_26B5S36 */
	{0x20, 0x88}, /* LIFE_26B5S37 */
	{0x20, 0x108}, /* LIFE_26B5S38 */
	{0x20, 0x10}, /* LIFE_26B5S4 */
	{0x20, 0x30}, /* LIFE_26B5S45 */
	{0x20, 0x90}, /* LIFE_26B5S47 */
	{0x20, 0x60}, /* LIFE_26B5S56 */
	{0x20, 0x120}, /* LIFE_26B5S58 */
	{0x20, 0x1C0}, /* LIFE_26B5S678 */
	{0x20, 0x100}, /* LIFE_26B5S8 */
	{0x120, 0x120}, /* LIFE_26B58S58 */
	{0x40, 0xE0}, /* LIFE_26B6S567 */
	{0x40, 0xA0}, /* LIFE_26B6S57 */
	{0xC0, 0xA0}, /* LIFE_26B67S57 */
	{0xC0, 0xC0}, /* LIFE_26B67S67 */
};

#define LIFE_12B3S3 0
#define LIFE_12B3S456 1
#define LIFE_12GLIDERS 2
#define LIFE_14B4S34 0
#define LIFE_14B46S34 1
#define LIFE_14GLIDERS 2
#define LIFE_14B45S56 2
#define LIFE_18B4S45 0
#define LIFE_18GLIDERS 1
#define LIFE__18B4S36 0
#define LIFE__18B4S46 1
#define LIFE__18GLIDERS 2
#define LIFE__18B4S45 2
#define LIFE__18B4S456 3
#define LIFE_20B4S45 0
#define LIFE_20GLIDERS 1
#define LIFE_22B4S3 0
#define LIFE_22B4S4 1
#define LIFE_22GLIDERS 2
#define LIFE_22B4S57 2
#define LIFE_26B5S23 0
#define LIFE_26B5S25 1
#define LIFE_26B5S27 2
#define LIFE_26B5S35 3
#define LIFE_26B5S36 4
#define LIFE_26B5S37 5
#define LIFE_26B5S38 6
#define LIFE_26B5S4 7
#define LIFE_26B5S45 8
#define LIFE_26B5S47 9
#define LIFE_26B5S56 10
#define LIFE_26B5S58 11
#define LIFE_26B5S678 12
#define LIFE_26B5S8 13  /* B5/S678 also contains the glider + more osc */
#define LIFE_26B58S58 14
#define LIFE_26B6S567 15 /* B6/S57 also contains the glider */
#define LIFE_26B6S57 16
#define LIFE_26B67S57 17
#define LIFE_26GLIDERS 18	/* GLIDER rules are first in param_26rules */
#define LIFE_26B67S67 18	/* glider exists but at 40 cells, kind of big */ 

#define LIFE_12RULES (sizeof patterns_12rules / sizeof patterns_12rules[0])
#define LIFE_14RULES (sizeof patterns_14rules / sizeof patterns_14rules[0])
#define LIFE_18RULES (sizeof patterns_18rules / sizeof patterns_18rules[0])
#define LIFE__18RULES (sizeof patterns__18rules / sizeof patterns__18rules[0])
#define LIFE_20RULES (sizeof patterns_20rules / sizeof patterns_20rules[0])
#define LIFE_22RULES (sizeof patterns_22rules / sizeof patterns_22rules[0])
#define LIFE_26RULES (sizeof patterns_26rules / sizeof patterns_26rules[0])
