// META: global=worker

// See
// https://web-platform-tests.org/writing-tests/testharness.html#multi-global-tests
// for how to specify in which global scopes to run this tests,
// how to specify additional scripts needed, etc.

// testharness.js is imported (via importScripts()) by generated glue code by
// WPT server.
// See ClassicWorkerHandler in
// https://github.com/web-platform-tests/wpt/blob/master/tools/serve/serve.py.

// ============================================================================

// Test body.
// .any.js tests are always testharness.js-based.
test(() => {
    assert_equals(1, 1, "1 == 1");
  },
  "Test that should pass"
);

test(() => {
    // This file is "general.any.js" but the worker top-level script is
    // "general.any.worker.js", which is generated by the WPT server.
    assert_equals(location.pathname, "/workers/examples/general.any.worker.js");
  },
  "Worker top-level script is a generated script."
);

// done() is NOT needed in .any.js tests, as it is called by generated
// glue code by the WPT server.
// See ClassicWorkerHandler in
// https://github.com/web-platform-tests/wpt/blob/master/tools/serve/serve.py.
