/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef hmac_sha3_384_vectors_h__
#define hmac_sha3_384_vectors_h__

#include "testvectors_base/test-structs.h"

const HmacTestVector kHmacSha3384WycheproofVectors[] = {
    {1, "empty message",
     "ee8df067857df2300fa71a10c30997178bb3796127b5ece5f2ccc170932be0e78ea9b0a59"
     "36c09157e671ce7ec9fc510",
     "",
     "7c87e3bf2a63428c2005a82c1ef0e0152537ce7a6f49344f3a85274724e075f9c833b6b2e"
     "6dd257e60222e7126312426",
     false},

    {2, "short message",
     "976696c0dc97182ca771975c3928ff9168ef89cd740cd2292858fd916068a702bc1df7c6c"
     "d8ee1f0d25e61d4c514cc5d",
     "2b",
     "b9c77f78d4e7928219105b1fa64d24a98a81816ca0c714d5424d0882ce7bb7be04b5bb4ac"
     "2a0092b4f5ce06f04c8654a",
     false},

    {3, "short message",
     "c55ea4c64a0a63e2d14ad42559ba7c816b8824d263c2cc6a015761b53f681e514369f0dfb"
     "a5cde165320ee10a96eb1fc",
     "5abd",
     "d26883d233ad5a26257f5ebb088ede5a9155894fd331a79f89d331fe07d2baabd2f3735b9"
     "59ad48ad290d38664d0f8eb",
     false},

    {4, "short message",
     "2928d465d92fa40072ca9d67761be66e491755e43499003c1057d3bec870f255126c3658d"
     "0d8a0c7d207df8710037ca7",
     "c405ae",
     "1c990f90e90e65bfee62549857bb10455200f425a21ba3f4b12636647c391d56b47e63e0c"
     "111b078eda90324799deb3a",
     false},

    {5, "short message",
     "686a3730085cc944fceb141628419818e662fe21e52bea2748f3b704f80ce801086db1e30"
     "68917b242e62b4d6e6ed685",
     "6601c683",
     "9911d4e5f30167ec382b7f7b394310a7ea5ecd0394eddea94382f05a8af9533b0b7202471"
     "1180add607d290e5f4602dc",
     false},

    {6, "short message",
     "f22d867b972b232e3f444a488dd794d170807c70eb650f952b6177596f76c558a5d860d6f"
     "7be0be9e666f9bd53732f8d",
     "15b29377e0",
     "aec46fb03a28d4fa55a5492930d1cb3731c5e80bb0c91f7c1e948680aa666a10f0bcf5389"
     "27961ef30fa24673e9ffaf8",
     false},

    {7, "short message",
     "3ac9abd53dbd0fbb891f9b5e16dd45df994e5283527832707138fc2712bad9e34761e7d9c"
     "6d05d46f2c8323ddb0efe99",
     "5a34155b1115",
     "ff5391301e105d0f18b8256aa8e5c03f4c57f341e0f61149cb62c0d2366826b8618b4ba28"
     "94de235b723755c1cbc7a45",
     false},

    {8, "short message",
     "ae3aa94fdd35e2bef40472d29bdad3a409840ea441c3d7025cd72f3e81ff56da602161d84"
     "b23d1634061385be30c5bbd",
     "8a140d781e7191",
     "b99181b96e6dadcdbf203c392a3bfad10130555837ee647a320ca2b723747a5f40bc4803e"
     "add9091418041e98ff10658",
     false},

    {9, "short message",
     "44b79852cabcf3fe93d2fff55d2afe6a46c35b7ad1954ce0888de7b459b982722faf8b490"
     "e6b00e7bcabbd36f18443f5",
     "9398cd251deafe8b",
     "8968d5e0f3d170c0d1977c7df67a3ec0bb637b19ee73150f84d35c8da9dd02fdbf563c573"
     "7834edf790765ba2b478ef0",
     false},

    {10, "short message",
     "03fed2f579a3ebdececfb184ebe2984876113399c4a593d98b5f5e606dd330fb394c285d9"
     "ead601748259b493335f8e5",
     "18d879b1f63df3ac7a",
     "c739ac7a0187774cb6ccf81069f75ecdb5e09331281641809e00334dbbc54552c01db07ea"
     "fadfcc23cdb6ca324e2c5db",
     false},

    {11, "short message",
     "f4ef48bf4056d39dbba4154018c63bdf29420b9991ea594ff05e3cc1cb02e176d54ba038a"
     "6b78692519d6788e495bbab",
     "0a5de13cd9ba31c94486",
     "cf21c5c7b56ae0ff5f95ebc2c7c6b9f95420b249121f9a97d901fb6c64969ec9be82fe2e3"
     "36c66fdda3ce306fd422a6e",
     false},

    {12, "short message",
     "fc771f7ccd499a1ed633d86876d707b5f1d53c6bcdf21aa2907766ab3ca7fa6cdd6a9b981"
     "b1a84a528e81444303f1057",
     "03ba11f3f3173b85226b25",
     "73942556ed0f294c5674444800c93eba42006083bccbd7bbd486a5ffd59a2be0d86743cdc"
     "dbf6f763ff763dca193cb0c",
     false},

    {13, "short message",
     "b3999de680b11550e18631c8199f7eb8a74e21bdc9d97f781245c2af19f85497d9f38b250"
     "a564e48650fd00be365f155",
     "9c658cb5e601d85dc3857863",
     "c94c0800814522d1fc042d05c4bf1ef0bd73c61bc847bfdcf3fa48867513815ece4593af5"
     "dd03b256e132f5f79894565",
     false},

    {14, "short message",
     "88005a62864ea699e1509616ec48033e84d2e2a13b8bc2e8a76f2eccbdb207a95ac8e2f5b"
     "5a703b22a0b571e8acc599a",
     "5a94f84541a794bf23d72db16d",
     "10a3839df086546ebfe7d5dba28d15ea4c27c3f4f1ee402d1e0f63443906c5e34a963b569"
     "0093484802c228dd26c1bd6",
     false},

    {15, "short message",
     "b1cbda2c9a12f92315a5101aef311e99d6db002b0e04fb53c50106aa4d28e9a346697ba97"
     "084572eea56ccfc4ad7e572",
     "ce12c0c78e3f6b276ac56ed7435e",
     "a0543a371f019bc19f2fbede34ce4efde43984a0c56f453f923e152abf914c4412f46b64b"
     "f626f22c309db403fcb7753",
     false},

    {16, "short message",
     "08517e8014e00db5c37f2a20f987ea2ec52e7938de018ad6be256ba2236804144ad2a1bcc"
     "242738862b40647007e0a2c",
     "21e2a0a167789a6b722d1737d92f8b",
     "bb74337940cc107f0cbbf1194bf6e784d9acd1d492f112e7f6d656eeca881e09c59fd6dae"
     "88a9daeca6d13c8eb9782d1",
     false},

    {17, "",
     "503d7478a773b694d6e552c9703cc8bc56fd49fafc9a17cab8b0332dca8d49336fa7e9ec2"
     "bcb56253fe5bb504e3e7f7f",
     "d96e6fed893addfd9237c81c4f4e341b",
     "8651de548c5110fe0112d26c7e0a2f244f84aeff6baf5267cfd3afdb544bb0a5c1b29e9b7"
     "8a2e9499e2c4f62c0f16e4a",
     false},

    {18, "",
     "41341bab902e767d4d1964c0acfecf46eff1b02b6455bcb2097de9c154be1f667f21be076"
     "de18cd2c15c005896fca87f",
     "4c43ac7de3631cc86f4da72fe6b6a552f1",
     "3bc4757211532a6c6ae964087ec9985f89d02b3925d91064cd09e6f39e5bea6ae451a1f4a"
     "723abf2c994d63fb5b80772",
     false},

    {19, "",
     "c2f83be1acce7b89a5f9e9ea7e4c4f8b0f4319986fbe479fa3b4a3c298168362393b56ea0"
     "3b5cef77f48e5a72abe6d08",
     "8dd0cd786cd800ffebec098728923d69249d3223c4c595cb",
     "552f35f9431cb7f76fce30c75d1a6d22403859e257f646fe52b2dc9c7cfc7f50670fbf7bb"
     "b62f95515f6aae0b1d45792",
     false},

    {20, "",
     "6bd2aee9dd98d6b6609fce82181b10c20bba861da68a1590586fab08c5e9e90ff584047db"
     "4760828643fea38087160e4",
     "33236a9de603c1e4f5e11164224740627d10f6008eb73ec2642321bf0b82d579",
     "d45174df3241ddb1a0890178fa4aa54523699b23be61a9616633631a4ef5e39bd2d88f42b"
     "d5016aa8bc1148056d8527c",
     false},

    {21, "long message",
     "2f98ba2ceaadc5ba08880a35cb0080dc870a5734a782ebe31c4bab100ff8786dcc3be6de1"
     "8482ea5d1b3bf14aeabb470",
     "2d74a66dacf12edb85ef3073feafd122889cb634add00ff0395d224b4ff8b5d5d67ca6419"
     "b6826abffdb41bab427d5",
     "00dd35f10e7fc7f1646d250abdf437893f52389df761fdf27840aa1374db786a22365be5a"
     "33e09adaaffee19515173d5",
     false},

    {22, "long message",
     "5e5f60e40d84c7ca2608af3bcc6e04abc5f8b7ca730a78af7f6f032e5a1501695bd91f3be"
     "bb28590af1db90d8390ca58",
     "2efe6a14ea8d679e62dbcedf35e61852278c83c54adbe1f1c72cb1a746b11cff8cb4fc3a2"
     "c3acd44255d51c020ca6d47",
     "f03c7331e8c708a257e7550718d964c0f7e1ac7bf52e9db6ab6f0556b3a575fda6f167860"
     "8f6e63ca3f2eb8d371b07de",
     false},

    {23, "long message",
     "bc310bc3913d9fe59e2012a058c9e150534d25611e36206cf07ccaefe153f38eb0eaad994"
     "1b6883dfbce01bcb5196041",
     "9f0747d7396bfbe01cf3e85361e50085e0a91a7490b994031d81851b725065993f45dad0d"
     "60d794aedec7ba5d9d6dbbee4",
     "aafe3d553f033f4de73aac4c6766583d5b2afa65d03758615066308bc5ae26ed93f28dfe6"
     "ded54104eadfcd43c16b284",
     false},

    {24, "long message",
     "dc770c64d00d156e43cb74970e3a1a2ad28b6d9ec6b2b6e5ac3e356a99f879cb620f00340"
     "c044cc1f31bdccfa0dbd177",
     "403fd8e3ef51b6539db658a894be85b58fbc84881e61c5e0cb13ae421a09d31d780603256"
     "d390edd056d190856be00ad20a7048f0c67416fe8e02884086155f4263262e8c1275504d4"
     "f91f2751d3c3dccd4409ff2b45e41de93f7b104d58f6e15bacb62ace9700615ecc1b30a0c"
     "c1b35",
     "34706cd3597860733b5e651f99d350e308f596ddb52b01e185bb38a1813bbd91e6e4c64c4"
     "fa683d4803c878fc5b42052",
     false},

    {25, "long message",
     "cca9299c7bdc26a4b595055c99ca23bec8ed11b5deeda91f83e2365e7340395ceef4e86e5"
     "cd91f2593bcfec498a67fc9",
     "a05b40b8d3a7bc7b75b0e97309c9bd1c9d8755c1ff5245ef6308a6a5cad3ecfbcb6364b41"
     "ca6f3d24bbee844d6204d1026abe345af7bdec114a373b109aa5724b738d50ab7a826c268"
     "e873709f8b35135a870045d5fb9daa82d3c245b5338917354e72b3058c9a4b80711746521"
     "7d7d14f36f8a8d4e97bc3b93587c92641e7",
     "537df9c448ebe5ad42e15687a9fe9fd76c3b8cd854481090118c63e5e6e2bcc1a1f8dc6d7"
     "824eeab4823c3ab4de55edd",
     false},

    {26, "long message",
     "c728e65e08d9296fe3cdf2dedb49c81a30b603a62569eece4ee5d01e9a32ae3bcb4ec163e"
     "455e452582454ceefefc046",
     "e6c6bac87c17e269a471434ca9568401451d78c2444a9d6edcda3cdab51c5bed1c19eaf34"
     "326580fd85ae5236ad51bc5dae386b36101f54695c595eeedcdd0182a4a117f8093f4f481"
     "2e03db396ede9849d193e7722081aeec4be6c4caf6c979d36ead56634a21be21162ea232d"
     "ec9cffdbd2474245878dca369e814fd028303",
     "0d5bcff1b650c2ac70262e1ef6b74dccdc5b31ecfc32e2e3a862dd61e8e636430e623bfd6"
     "20a8e2aaa98c138899560da",
     false},

    {27, "long message",
     "90c4215dc3f237435047fefdd8638d339a3fc66fca06c5063eacbda002ab335e621605f67"
     "2f3da9f641fae110afc3e7b",
     "1ebc22c3031b64615eb6f1a0696e33b7df139a4b891d3e6721cc26c05d55de790dca62366"
     "8c10308485d38e95ec4769fa4430ca3ebc25da9f5d31c972674517d9a2222e6b97d8def65"
     "12af096c6d1480d83a229c84b7f28c80184b6bebf3f4eff5fc4e5c6cfea4f8eba9a957f79"
     "13b20a88ad1734f7c38547e934d1dbf2d73dbd61e31fb1583c7b6577a171e7d02f1904512"
     "6ac2973d855bc18d34d32326d1e216da58366a60033450091128ae26a479069bba7b91b2a"
     "b7f3c5fbcde391de3ca114b951d6852f92795f8023d7a29a7f4ce61e9241b4f235d21e899"
     "087167ab3f3a0e9321c7942b165178788df48d3b106b203ec1e01d29bda41a99ac0d2c00",
     "e14912a4d0a3dd7fee54be8055f78f14a72f1d48beb24226380cefd1efc733aad129e504b"
     "ebad98d1ff7fc303750073a",
     false},

    {28, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d10ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {29, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6654fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {30, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d20ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {31, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6554fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {32, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "500ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {33, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "e754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {34, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00de89d5235b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {35, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6755fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {36, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce81d5235b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {37, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fec4542b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {38, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5335b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {39, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44552b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {40, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5035b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {41, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44562b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {42, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b2aaaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {43, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f9cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {44, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aae49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {45, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd1b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {46, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22a2f49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {47, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1c50b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {48, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aaf69dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {49, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0914728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {50, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aaf49dbe078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {51, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14628e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {52, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aaf49dae079c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {53, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e79bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {54, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aaf49dae07ac0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {55, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e49bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {56, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aaf49dae0f8c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {57, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728669bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {58, "Flipped bit 376 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86f",
     true},

    {59, "Flipped bit 376 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd5",
     true},

    {60, "Flipped bit 377 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86c",
     true},

    {61, "Flipped bit 377 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd6",
     true},

    {62, "Flipped bit 382 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc82e",
     true},

    {63, "Flipped bit 382 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bb94",
     true},

    {64, "Flipped bit 383 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc8ee",
     true},

    {65, "Flipped bit 383 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bb54",
     true},

    {66, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d10ce89d5235b22aae49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {67, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6654fe44542b3f1cd1b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {68, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce81d5235b2aaaf49dae078c0c8c29fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {69, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fec4542b3f9cd0b14728e69bbf6083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {70, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d00ce89d5235b2aaaf49dae078c0c8429fc3ab699d89837e1d1a9b443a70c9a86cfde0a69"
     "0cd4377be0d91acf03fc86e",
     true},

    {71, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f9cd0b14728e69bbfe083f02cafd8ccc416525fe4013f7c7a51a8384d47a"
     "fefa1fdd528d3fb6258bbd4",
     true},

    {72, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "2ff31762adca4dd550b6251f873f373d603c549662767c81e2e564bbc58f365793021f596"
     "f32bc8841f26e530fc03791",
     true},

    {73, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "98ab01bbabd4c0e32f4eb8d71964409f7c0fd35027333be9ada01bfec08385ae57c7b2b85"
     "0105e022ad72c049da7442b",
     true},

    {74, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "0000000000000000000000000000000000000000000000000000000000000000000000000"
     "00000000000000000000000",
     true},

    {75, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "0000000000000000000000000000000000000000000000000000000000000000000000000"
     "00000000000000000000000",
     true},

    {76, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
     "fffffffffffffffffffffff",
     true},

    {77, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
     "fffffffffffffffffffffff",
     true},

    {78, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "508c681dd2b532aa2fc95a60f84048421f432be91d0903fe9d9a1bc4baf04928ec7d60261"
     "04dc3f73e8d112c70bf48ee",
     true},

    {79, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "e7d47ec4d4abbf9c5031c7a8661b3fe00370ac2f584c4496d2df6481bffcfad128b8cdc72"
     "f6f217d55a8537be2d83b54",
     true},

    {80, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "",
     "d10de99c5334b32bae48dbe179c1c9c39ec2aa689c88827f1c1b9a453b71c8a96dfce1a79"
     "1cc4276bf0c90adf13ec96f",
     true},

    {81, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6655ff45552a3e1dd1b04629e79abe6182f12daed9cdc517535ee5003e7d7b50a9394c46a"
     "eeea0fcd429d2fa6359bad5",
     true},

    {82, "empty message",
     "1c678267be13acb464939c2896c9e9ce1deb5b30833bdd9ca00370889b84410782ad52afe"
     "25dc10ab7ec5cf5f34793b7",
     "", "b1bbb62a3d2e33ab8cdc0da03091bb83efbbe2c484b9ee8b", false},

    {83, "short message",
     "00b184c2c0a491d764a26f8b2e56a965222b36213bdd106ae782305c50f89269902476e5d"
     "f3fa58e0ecfae82a9607c8e",
     "9f", "424d7ad3fb7addd09488de8b5e5951853ed915a66209ce02", false},

    {84, "short message",
     "055b67edb659e29c10e3e9cd25aa1cd5abf0880e2026ed8436e39b064b7315760cd7a9294"
     "ee23d4750969cc8b5dbaed7",
     "4047", "deb3604abe3406493230f871adbb10945371c725d77ff001", false},

    {85, "short message",
     "9e3c198e93930f076b035c5fa8f10d9a65e98c66cfb36633e3cb33279cdf57688f10b7472"
     "d1fc9d962ce6954519bfbf6",
     "88cfab", "8952c88be29d5a7ad5c252197a67d3af7512af0f320d5efb", false},

    {86, "short message",
     "f5f5962bda257b38b2a2318929121b2eaef792d5c6a9585e48b80cf5357b29c3951b787ed"
     "3e03e385b05b8ffe6861dc3",
     "d9397753", "3afda5e82a3a0b01f6de056633348bff2c59838fc10476af", false},

    {87, "short message",
     "f62820ed5f9833fd22dee7bd49e2c9b19fc9668897c2c33e6c7c1fa5c277c3b9f581faef3"
     "ddc664ba537975d8afaa707",
     "9b6cc7caa4", "0ebdc562d3b5df13f1370a0a555f30e5d77b92a71c885884", false},

    {88, "short message",
     "f222a1dabf322aff8463acee6444939331212be3e19d31f4b73fdcc97e2925365ea33c985"
     "282805c83dcd8fb42a0e214",
     "c85ad7872b76", "4fc8b44f25d87a32f6e0dbb7d9851482344d4af5bfd77845", false},

    {89, "short message",
     "56e80f3899e945310a9d9bef3d32091f29c157dd46b2d439ad89d63e14b2c24390f74db4d"
     "905f6bd03f75c32e91225fe",
     "80ba25f1c27650", "f1686d7c0a808ae4ee2c4d8912b3f6e5bea141de7b80b586",
     false},

    {90, "short message",
     "6cb6261a56a21b2c3c13453c158364aafa78f58172a9ae3eeb328ac38808b5c68c111197a"
     "303ec36847c9a315ac5eb5b",
     "79430de51d68cf34", "7cf93b400cc52b516f12e42270f2591e2cb9b6f98016fe2c",
     false},

    {91, "short message",
     "44ca1ecb490470a84c7e13e1f1c69da21f48c33b6f050f48f7f244f0fda8b3c855904ed06"
     "12e2dafa5105cbd7f6449eb",
     "870b981c8afd9fae1b", "b51efe22849cac69821f995906f002c53bfb71eadb902e1a",
     false},

    {92, "short message",
     "aaca68882cfa7250988a247b96cfb3232d6567378f8fa7e7aaaca1c386e1ae15e54957d22"
     "bfff1e50ae7f21beea197a5",
     "a6f31b822ec24da1b1e9", "755c630f0038e61b0df635a86990a0efce63be5dfa448c68",
     false},

    {93, "short message",
     "1b32f9b6378934a502dd74d8b74a4606d5b2c9a8587fab1cfa90d75007734d2b8bdfe6348"
     "15243526ebc0f33c04d0d05",
     "55367c657c792610efdcc0",
     "eb16b29740aa41ce9324d6a29befe848109c8be189983b2b", false},

    {94, "short message",
     "09d91b2fa22e68b5335d478235aa4e157435c9acfed772219adfa1e9dd72f33e1a2183a02"
     "03a104f80e643cdf29e5aff",
     "b31e254957db6b1b70a06ce2",
     "ab2b667e1f8a3e5fedc4da62ab85c422280efdd255005491", false},

    {95, "short message",
     "d311a80ac801e3639b9185608af4a85e4122e29b5c23f05234c30d92d59ad13cb80390e5f"
     "a0ea4a54853228b356689f5",
     "e6b443dba0dab35d43ca5d6ce6",
     "ec3e9d2c208d5739d8509ad6e88ea865383d9f034c3f80a5", false},

    {96, "short message",
     "06297e6c46558b9b0fc36c272b4ae7e65dd536cc1d13acbfa831fa5574b34f99e09adfb7f"
     "20321f203075fd26ed2e29d",
     "309b95e5f1ec26f70786e74d806d",
     "8eb37decaaf8376ea94b82767af4c4be78cb607d9930a28f", false},

    {97, "short message",
     "e8b63a25cd85ad4f39e3c0e9584eacb94d6ae33f984da259aa533d4d28aeb341cf3ffe49c"
     "029e4af6a4805f760f35f2c",
     "d225c27795f809454bb2c51d21f3ac",
     "7194c69928ebc338d6c34ab5aa5506d2fc069743d7660c7b", false},

    {98, "",
     "d83a685ace9fa0c0aa47f0c7b4f0f00717619a82e2eeff87f51f67d814d51dd9e4cad7578"
     "a4e49b672b5af83943c2583",
     "abfa7f5978f751e87e8b5a15a6e89f4f",
     "90247d2933f8f4a6564ad7d272721ff6e76fd4c0e3a8fabc", false},

    {99, "",
     "5beaf406a6627eaafcadb6dea4e27ba4fd879fd3e5bfd87ea3c8d5e0acfbbda2c6bf006be"
     "af5a30312e690724c4744a3",
     "bc57d467a9a2af64ad5e14b7bc0898dc63",
     "7cfaae1946e462ece04ec2fde8fef1a6e9e5a5a51657e14e", false},

    {100, "",
     "76b36cc3b8ca975708ee4b32bdbe40ca13f9ce384c52c4b6602b7fd92164f1fd8432706c1"
     "966f648bf4830f4deb34795",
     "b1d022c6536f401d147dfc0d7d4e600bb753ef0e9f243bc3",
     "f41947ef686bb9a4aa3555f72bb320dab577123f8f7b8add", false},

    {101, "",
     "20569a16f453dd3c34df98155286b1ca8a392ea164c919311f0df9d39d976062f4f992b96"
     "def3851886e6295f2615064",
     "5402c4e683d1a431868ad528afbf4128b0b10cef947d063b34d376d344b793b2",
     "ae11f9b8380ffb396aee5a643dcd8d1cc91544ab18201aec", false},

    {102, "long message",
     "9ef6a55f8a9b6b9ef1f8296167319078163706ae5b60897c2dd6e340b67ed5d577fb54c55"
     "47cd5f248f06e7082ffb826",
     "6a0d16276941d8f04eac2ec723fa53b9d6b16da7e30e7f2d9ad898e7cbb71bd3dd234ee22"
     "836ff4ac6011b6f12bd3a",
     "57d58ab4cbc8d53e6c18ce556afa2d9bcf22c1f4486e459c", false},

    {103, "long message",
     "fb56bbbc6d751b744d8c1b57cc27a1d2c2f4e38e3491f54448cfcfb9389b7f63fd0d41920"
     "968ef612510625f2637d28d",
     "cf1791517ef5a61c0db65a668bee26fdbc975d799b2623cc0f3e4560e80c7014fa9c02d56"
     "8c98c86385e000fe6776bb7",
     "c4aa19f4243645fa5731e03768d16d55225ade23ee7f371b", false},

    {104, "long message",
     "d041e24e59b34d7a18128a42d8a7a52dcba5d79e5ed585b55c7c9e4946e5ccaf7e59df0f3"
     "da98c7d0523e4cc8f9d7da4",
     "5279618f1b41534910395a78ded968aee3431085b599c4f55eb5ff8a2e879bc44291d923d"
     "e31009db1b9f7f81095afb3ea",
     "ee3f2946aa04e60b7f4b7f57ee15dec5a7fcf8d114ebc14d", false},

    {105, "long message",
     "e1ce4884fd74a0e197c68ace3b29b552313af8e451e98d9ab8d0e8f8ee74143e8fcb64462"
     "17c0f3123a426b8ab6f62cb",
     "71154b9a657b905f884ba5140d5e7b9243fec3e03fbbdbb360c8194963ae43177b5502cd2"
     "0f559eeeff8638d028c501926ebc7eddd132ccea29ead7ad0c95a30b9d325952cafb0ea5e"
     "c9d9d6fdeb63950d5d69c8bbbea702aed1d444da286807ffd6b36cb49902cba7abf9bda1b"
     "577c6",
     "928ac14f18d87b8e1eee759b4ffee3c17a2913c914d8974d", false},

    {106, "long message",
     "8a242c22d1b54ce216ca03c88455beb128211a9f35af2343709af7c5f43a681451ea53a36"
     "de2e5048eb44a51681c6120",
     "ab5eee6b83869119f00dd3cc66dde75cb5700535a90e9b3e32b31434c297ef53f94659d7d"
     "9b11323161b2e66c6b9c9ad20e313303f81e88e471786c8e936011f78121e39630b2e0804"
     "fc97ce5cb3a34f26949439fe530adcea6e97c78b042e0817253bf75dd54335584122f5edd"
     "210341b6d93f58aa1b4de2aad76fecec44f",
     "20ccf4f222d139d4ab7623b3a38c91543469270056ff8c80", false},

    {107, "long message",
     "311c4bee7cf257b780135a2e4a6413e68a816f5d8462515dcb1c72494b6335581a9b60a21"
     "7b9ff1c75e7768148f8df46",
     "63ccc3849c4c323cb6ce926877969048b849ee4af18e71eef52fe9f274a8678560f9a5d47"
     "510c3c98c8a08ed4c01a01e0a3663ef0cc6c3cdca6276d91e99b0d414263498fb64ad74b8"
     "20ab52b37adeaf27cb44545edb8f09094992837b8d3a0baa2a101a49592eb889dc8bace4c"
     "71e3efcb9d4149bd670ce2f774d73c12f2a45",
     "dae65a8c37c5458f017770fdbfc2023291e021bddf7625c4", false},

    {108, "long message",
     "fb792867c8928f0503aa24477cebf42e0b018346e3619770b9e8f5097945e2e275ad06f0c"
     "12152366ac06e278c94090a",
     "0a63e6d91d7a6a18dbad879fb8e23ae351920391eb40fead6cba846768a2c6797ff347b43"
     "01327b09afc41f7b803af6b61f6d9b818e0ddcc02536d0543dbf1a87f2c5e020f64590943"
     "44b72596d548435c313544e92c254d54a70a1d6f6edd2f82540a1ea2e82125b0715fa0f89"
     "0bb2be4ba0065d2ba0144854682aed041c1035996648e2ed671b7253ba567ffb999d91fd8"
     "e7ffce5c6dc4790732adae443435a454fe6c2a7c6708d9d5b2eb9292d6fbe5e026d65332b"
     "38c7925eff9beb89063cab63fbecb2ac0e1bb61a5b1e511f949c43a34ee26f1156e97793d"
     "a97bcf5b5c67641384f268131b297857d719eeb6cafa3dbe9b8d0da55c98656f20e5b39b",
     "927bfdba4ee11d8f158491764840fd64ff6401401543b539", false},

    {109, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d10ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e", true},

    {110, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6654fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416", true},

    {111, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d20ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e", true},

    {112, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6554fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416", true},

    {113, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "500ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837e", true},

    {114, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "e754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416", true},

    {115, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00de89d5235b22aaf49dae078c0c8c29fc3ab699d89837e", true},

    {116, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6755fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc416", true},

    {117, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce81d5235b22aaf49dae078c0c8c29fc3ab699d89837e", true},

    {118, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fec4542b3f1cd0b14728e69bbf6083f02cafd8ccc416", true},

    {119, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5335b22aaf49dae078c0c8c29fc3ab699d89837e", true},

    {120, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44552b3f1cd0b14728e69bbf6083f02cafd8ccc416", true},

    {121, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5035b22aaf49dae078c0c8c29fc3ab699d89837e", true},

    {122, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44562b3f1cd0b14728e69bbf6083f02cafd8ccc416", true},

    {123, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b2aaaf49dae078c0c8c29fc3ab699d89837e", true},

    {124, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f9cd0b14728e69bbf6083f02cafd8ccc416", true},

    {125, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aae49dae078c0c8c29fc3ab699d89837e", true},

    {126, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd1b14728e69bbf6083f02cafd8ccc416", true},

    {127, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22a2f49dae078c0c8c29fc3ab699d89837e", true},

    {128, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1c50b14728e69bbf6083f02cafd8ccc416", true},

    {129, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aaf69dae078c0c8c29fc3ab699d89837e", true},

    {130, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0914728e69bbf6083f02cafd8ccc416", true},

    {131, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aaf49dbe078c0c8c29fc3ab699d89837e", true},

    {132, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14628e69bbf6083f02cafd8ccc416", true},

    {133, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aaf49dae079c0c8c29fc3ab699d89837e", true},

    {134, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e79bbf6083f02cafd8ccc416", true},

    {135, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aaf49dae07ac0c8c29fc3ab699d89837e", true},

    {136, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e49bbf6083f02cafd8ccc416", true},

    {137, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aaf49dae0f8c0c8c29fc3ab699d89837e", true},

    {138, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728669bbf6083f02cafd8ccc416", true},

    {139, "Flipped bit 184 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837f", true},

    {140, "Flipped bit 184 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc417", true},

    {141, "Flipped bit 185 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aaf49dae078c0c8c29fc3ab699d89837c", true},

    {142, "Flipped bit 185 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc414", true},

    {143, "Flipped bit 190 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aaf49dae078c0c8c29fc3ab699d89833e", true},

    {144, "Flipped bit 190 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc456", true},

    {145, "Flipped bit 191 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b22aaf49dae078c0c8c29fc3ab699d8983fe", true},

    {146, "Flipped bit 191 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f1cd0b14728e69bbf6083f02cafd8ccc496", true},

    {147, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d10ce89d5235b22aae49dae078c0c8c29fc3ab699d89837e", true},

    {148, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6654fe44542b3f1cd1b14728e69bbf6083f02cafd8ccc416", true},

    {149, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce81d5235b2aaaf49dae078c0c8c29fc3ab699d89837e", true},

    {150, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fec4542b3f9cd0b14728e69bbf6083f02cafd8ccc416", true},

    {151, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d00ce89d5235b2aaaf49dae078c0c8429fc3ab699d89837e", true},

    {152, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6754fe44542b3f9cd0b14728e69bbfe083f02cafd8ccc416", true},

    {153, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "2ff31762adca4dd550b6251f873f373d603c549662767c81", true},

    {154, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "98ab01bbabd4c0e32f4eb8d71964409f7c0fd35027333be9", true},

    {155, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "000000000000000000000000000000000000000000000000", true},

    {156, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "000000000000000000000000000000000000000000000000", true},

    {157, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "ffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {158, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "ffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {159, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "508c681dd2b532aa2fc95a60f84048421f432be91d0903fe", true},

    {160, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "e7d47ec4d4abbf9c5031c7a8661b3fe00370ac2f584c4496", true},

    {161, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "", "d10de99c5334b32bae48dbe179c1c9c39ec2aa689c88827f", true},

    {162, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f",
     "000102030405060708090a0b0c0d0e0f",
     "6655ff45552a3e1dd1b04629e79abe6182f12daed9cdc517", true},

    {163, "short key", "08476e9d49499c5f52e37f80ece6f5a45459948806b48241", "",
     "fc5143709d60f6655e009acfea7016386350593622e590560c47e846a3fae8f6edc3e4331"
     "b8305834cae249dba9e269f",
     false},

    {164, "short key", "213b44d8e1fabaff837ef30ee2542f9ab82ed70411dae78f",
     "ee0bf48585c186ff991b4d8607817c9c",
     "b9255a1f98c06ff6048760a1b22d63c0e8a7479c5d453664a60028512d64e13d79f7e39e8"
     "cb5399d859f1c8be4761172",
     false},

    {165, "short key", "b4afa9daaa8c944d73a3881f3221e42b34ef4e35f184e878",
     "cf607f6a0eb44ecbca81b6d1fdb595cee35f2353da02e82e28e133b9decd8fbb",
     "b56641a9d6514b118c70f30a61c08e7e7a650ae2cfb9d73d633c3cc402a0b9ff75c9224a9"
     "4610861322225ba31d9f3ad",
     false},

    {166, "short key", "89e46b66209548c80b0c830662223b49b0e3b895eb30e2fc", "",
     "eeebe1823fb042cc7c56b31748af6a134458eab62fa2e0a7", false},

    {167, "short key", "f2c10ce8cb1cf3b363354473b027c1e53deccef03233be0c",
     "e1fa10b8e301e0348405770bc3fafcb1",
     "9f0e9d9be70c82525f8add7dd15d925b9398d7fdbe1f2110", false},

    {168, "short key", "92e074442cc4c59e72260808d80d8e7b85c6335068917b83",
     "34eae27425ace17771e164cbb634306f352edc9c37bf608be8a755fb94148183",
     "b789a4371f0aa2f667a7ade1c53c98b53a39ff65dfbe7d28", false},

    {169, "long key",
     "db6f9956c3f4ca6e41f1f7f14629d44c79e0353edbf3e310e6858bbc45a7cd57778a9053b"
     "a22a141bf58bfd434ad08648c7041a224b97a0d17e0edf94fd40b410a",
     "",
     "2553a0441bda89fe78a8fef9d334f92224c3fd47b7eb8f18bd6ba3e7c2ddc383ab9264f50"
     "eed7d09f5e40a10e5cf5271",
     false},

    {170, "long key",
     "f03404bdb3e08f530d4c3a5f165d236012a4c45cd063e3e4483da088ec0afdb24e9639fcc"
     "abb91f98a49dc2972e2981426573ecfe69c00c43a2d99a3107cef3a70",
     "73ed9fa2acf49d6c98bfc7d6c5ad9c56",
     "c345a72ff4dc5a62c8fef912c51f7d95814a3b59291df3f38da214a46423af89a40f8e370"
     "47403c9499768b3171a55c2",
     false},

    {171, "long key",
     "ee799e25edb1b18452e5ed174bc6b2185a6754417d6cc05d736d2ba9efc8367e4b05ba0a2"
     "ee525ceeab74f9804a8479130c328d671e34070cf174a003a1dfb5994",
     "ac3e7da7e578b9b4dc2424030446c7f6aebcc471445a9e0e6e65099caeec5b2f",
     "956d33ddc96bacdcb4e0058c161ae812d79d81d9f0f597e203aa6dae0daab27ad93c5171f"
     "564525fb91926dfcfbaa09d",
     false},

    {172, "long key",
     "063d6e12e670098adabe68192023b637bb6d8d713fc8436188c4ec06fdd084ce6d193f26c"
     "86a9560e1abc27d813fce2b3eac0170fd1cb72e1930a2776bc84d6c11",
     "", "24a9852f76ffa1ba3a6043cd348f17be036755162131259a", false},

    {173, "long key",
     "359318e6c6279ba9ebcb1675f5a98195bbf5d895da9c17b8329038be857dc395b12ae91a5"
     "5598876593c1c20bc0172cf15126b7a6bf0a238eda3325d6dd60600ef",
     "7ad0c9098ea10e615bb672b52c96542d",
     "b3de2addd5fce93122f0f2f320c607fafac23b280898068e", false},

    {174, "long key",
     "d01cd898089d8a1eeb0035b0d332da80fbd3571b9192db10fa6f55f665ab192d7050cab64"
     "3996e99254d9573e0cf4eeaa63afccdefd81614fe7b83dfe30e3ba19f",
     "d67c77cdd0af5d10e8cae887e5a609bb76a9e5597653773c303b82b918fdc59f",
     "f692da39c59268288b0f081a7b60de6111cef724a14f893a", false}};

#endif  // hmac_sha3_384_vectors_h__
