/* Generated by re2d */
#line 1 "d/fill/02_fill.re"
// re2d $INPUT -o $OUTPUT
module main;

import core.stdc.string;
import core.stdc.stdio;

#line 10 "d/fill/02_fill.d"
enum YYMaxFill = 1;
#line 7 "d/fill/02_fill.re"

enum BufSize = (4096 - YYMaxFill);

struct Input {
    FILE* file;
    char[BufSize + YYMaxFill] buffer;
    char* yylimit, yycursor, token;
    bool eof;
};

private int fill(ref Input it, size_t need) {
    if (it.eof) return 1;

    const size_t shift = it.token - it.buffer.ptr;
    const size_t used = it.yylimit - it.token;

    // Error: lexeme too long. In real life could reallocate a larger buffer.
    if (shift < need) return 2;

    // Shift buffer contents (discard everything up to the current token).
    memmove(it.buffer.ptr, it.token, used);
    it.yylimit -= shift;
    it.yycursor -= shift;
    it.token -= shift;

    // Fill free space at the end of buffer with new data from file.
    it.yylimit += fread(it.yylimit, 1, BufSize - used, it.file);

    // If read less than expected, this is end of input => add zero padding
    // so that the lexer can access characters at the end of buffer.
    if (it.yylimit < it.buffer.ptr + BufSize) {
        it.eof = true;
        memset(it.yylimit, 0, YYMaxFill);
        it.yylimit += YYMaxFill;
    }

    return 0;
}

private int lex(ref Input yyrecord) {
    int count = 0;
    for (;;) {
        yyrecord.token = yyrecord.yycursor;
    
#line 57 "d/fill/02_fill.d"
{
    char yych;
    if (yyrecord.yylimit <= yyrecord.yycursor) if (fill(yyrecord, 1) != 0) return -1;
    yych = *yyrecord.yycursor;
    switch (yych) {
        case 0x00: goto yy1;
        case ' ': goto yy3;
        case '\'': goto yy5;
        default: goto yy2;
    }
yy1:
    ++yyrecord.yycursor;
#line 57 "d/fill/02_fill.re"
    {
            // Check that it is the sentinel, not some unexpected null.
            return yyrecord.token == yyrecord.yylimit - YYMaxFill ? count : -1;
        }
#line 75 "d/fill/02_fill.d"
yy2:
    ++yyrecord.yycursor;
#line 63 "d/fill/02_fill.re"
    { return -1; }
#line 80 "d/fill/02_fill.d"
yy3:
    ++yyrecord.yycursor;
    if (yyrecord.yylimit <= yyrecord.yycursor) if (fill(yyrecord, 1) != 0) return -1;
    yych = *yyrecord.yycursor;
    switch (yych) {
        case ' ': goto yy3;
        default: goto yy4;
    }
yy4:
#line 62 "d/fill/02_fill.re"
    { continue; }
#line 92 "d/fill/02_fill.d"
yy5:
    ++yyrecord.yycursor;
    if (yyrecord.yylimit <= yyrecord.yycursor) if (fill(yyrecord, 1) != 0) return -1;
    yych = *yyrecord.yycursor;
    switch (yych) {
        case '\'': goto yy6;
        case '\\': goto yy7;
        default: goto yy5;
    }
yy6:
    ++yyrecord.yycursor;
#line 61 "d/fill/02_fill.re"
    { ++count; continue; }
#line 106 "d/fill/02_fill.d"
yy7:
    ++yyrecord.yycursor;
    if (yyrecord.yylimit <= yyrecord.yycursor) if (fill(yyrecord, 1) != 0) return -1;
    goto yy5;
}
#line 64 "d/fill/02_fill.re"

    }
    assert(0);
}

void main() {
    const char[] fname = "input";
    const char[] content = "'qu\0tes' 'are' 'fine: \\'' ";

    // Prepare input file: a few times the size of the buffer, containing
    // strings with zeroes and escaped quotes.
    FILE* f = fopen(fname.ptr, "w");
    for (int i = 0; i < BufSize; ++i) {
        fwrite(content.ptr, 1, content.length - 1, f);
    }
    fclose(f);
    int count = 3 * BufSize; // number of quoted strings written to file

    // Initialize lexer state: all pointers are at the end of buffer.
    // This immediately triggers YYFILL, as the check `it.yycursor < it.yylimit` fails.
    Input it;
    it.file = fopen(fname.ptr, "r");
    it.yycursor = it.token = it.yylimit = it.buffer.ptr + BufSize;
    it.eof = 0;

    // Run the lexer.
    assert(lex(it) == count);

    // Cleanup: remove input file.
    fclose(it.file);
    remove(fname.ptr);
}
