/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class Exclusion
extends DataType {
    private static final String WILDCARD = "*";
    private String groupId;
    private String artifactId;
    private String classifier;
    private String extension;

    protected Exclusion getRef() {
        return (Exclusion)((Object)this.getCheckedRef());
    }

    public void validate(Task task) {
        if (this.isReference()) {
            this.getRef().validate(task);
        } else if (this.groupId == null && this.artifactId == null && this.classifier == null && this.extension == null) {
            throw new BuildException("You must specify at least one of 'groupId', 'artifactId', 'classifier' or 'extension'");
        }
    }

    public void setRefid(Reference ref) {
        if (this.groupId != null || this.artifactId != null || this.extension != null || this.classifier != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(ref);
    }

    public String getGroupId() {
        if (this.isReference()) {
            return this.getRef().getGroupId();
        }
        return this.groupId != null ? this.groupId : WILDCARD;
    }

    public void setGroupId(String groupId) {
        this.checkAttributesAllowed();
        if (this.groupId != null) {
            throw this.ambiguousCoords();
        }
        this.groupId = groupId;
    }

    public String getArtifactId() {
        if (this.isReference()) {
            return this.getRef().getArtifactId();
        }
        return this.artifactId != null ? this.artifactId : WILDCARD;
    }

    public void setArtifactId(String artifactId) {
        this.checkAttributesAllowed();
        if (this.artifactId != null) {
            throw this.ambiguousCoords();
        }
        this.artifactId = artifactId;
    }

    public String getClassifier() {
        if (this.isReference()) {
            return this.getRef().getClassifier();
        }
        return this.classifier != null ? this.classifier : WILDCARD;
    }

    public void setClassifier(String classifier) {
        this.checkAttributesAllowed();
        if (this.classifier != null) {
            throw this.ambiguousCoords();
        }
        this.classifier = classifier;
    }

    public String getExtension() {
        if (this.isReference()) {
            return this.getRef().getExtension();
        }
        return this.extension != null ? this.extension : WILDCARD;
    }

    public void setExtension(String extension) {
        this.checkAttributesAllowed();
        if (this.extension != null) {
            throw this.ambiguousCoords();
        }
        this.extension = extension;
    }

    public void setCoords(String coords) {
        this.checkAttributesAllowed();
        if (this.groupId != null || this.artifactId != null || this.extension != null || this.classifier != null) {
            throw this.ambiguousCoords();
        }
        Pattern p = Pattern.compile("([^: ]+)(:([^: ]+)(:([^: ]+)(:([^: ]*))?)?)?");
        Matcher m = p.matcher(coords);
        if (!m.matches()) {
            throw new BuildException("Bad exclusion coordinates, expected format is <groupId>[:<artifactId>[:<extension>[:<classifier>]]]");
        }
        this.groupId = m.group(1);
        this.artifactId = m.group(3);
        if (this.artifactId == null) {
            this.artifactId = WILDCARD;
        }
        this.extension = m.group(5);
        if (this.extension == null) {
            this.extension = WILDCARD;
        }
        this.classifier = m.group(7);
        if (this.classifier == null) {
            this.classifier = WILDCARD;
        }
    }

    private BuildException ambiguousCoords() {
        return new BuildException("You must not specify both 'coords' and ('groupId', 'artifactId', 'extension', 'classifier')");
    }
}

