/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.resumable;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import org.sonatype.aether.ant.com.ning.http.client.resumable.ResumableAsyncHandler;
import org.sonatype.aether.ant.org.slf4j.Logger;
import org.sonatype.aether.ant.org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBasedResumableProcessor
implements ResumableAsyncHandler.ResumableProcessor {
    private static final Logger log = LoggerFactory.getLogger(PropertiesBasedResumableProcessor.class);
    private static final File TMP = new File(System.getProperty("java.io.tmpdir"), "ahc");
    private static final String storeName = "ResumableAsyncHandler.properties";
    private final ConcurrentHashMap<String, Long> properties = new ConcurrentHashMap();

    @Override
    public void put(String url, long transferredBytes) {
        this.properties.put(url, transferredBytes);
    }

    @Override
    public void remove(String uri) {
        if (uri != null) {
            this.properties.remove(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Map<String, Long> map) {
        log.debug("Saving current download state {}", (Object)this.properties.toString());
        FileOutputStream os = null;
        try {
            TMP.mkdirs();
            File f = new File(TMP, storeName);
            f.createNewFile();
            if (!f.canWrite()) {
                throw new IllegalStateException();
            }
            os = new FileOutputStream(f);
            for (Map.Entry<String, Long> e : this.properties.entrySet()) {
                os.write(PropertiesBasedResumableProcessor.append(e).getBytes("UTF-8"));
            }
            os.flush();
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String append(Map.Entry<String, Long> e) {
        return new StringBuffer(e.getKey()).append("=").append(e.getValue()).append("\n").toString();
    }

    @Override
    public Map<String, Long> load() {
        try {
            Scanner scan = new Scanner(new File(TMP, storeName), "UTF-8");
            scan.useDelimiter("[=\n]");
            while (scan.hasNext()) {
                String key = scan.next().trim();
                String value = scan.next().trim();
                this.properties.put(key, Long.valueOf(value));
            }
            log.debug("Loading previous download state {}", (Object)this.properties.toString());
        }
        catch (FileNotFoundException ex) {
            log.debug("Missing {}", (Object)storeName);
        }
        catch (Throwable ex) {
            log.warn(ex.getMessage(), ex);
        }
        return this.properties;
    }
}

