/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.providers.apache;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.httpclient.HttpMethodBase;
import org.sonatype.aether.ant.com.ning.http.client.AsyncHandler;
import org.sonatype.aether.ant.com.ning.http.client.Request;
import org.sonatype.aether.ant.com.ning.http.client.listenable.AbstractListenableFuture;
import org.sonatype.aether.ant.org.slf4j.Logger;
import org.sonatype.aether.ant.org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheResponseFuture<V>
extends AbstractListenableFuture<V> {
    private static final Logger logger = LoggerFactory.getLogger(ApacheResponseFuture.class);
    private Future<V> innerFuture;
    private final AsyncHandler<V> asyncHandler;
    private final int responseTimeoutInMs;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicBoolean timedOut = new AtomicBoolean(false);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private final AtomicLong touch = new AtomicLong(System.currentTimeMillis());
    private final AtomicBoolean contentProcessed = new AtomicBoolean(false);
    private final Request request;
    private final HttpMethodBase method;
    private Future<?> reaperFuture;
    private boolean writeHeaders;
    private boolean writeBody;

    public ApacheResponseFuture(AsyncHandler<V> asyncHandler, int responseTimeoutInMs, Request request, HttpMethodBase method) {
        this.asyncHandler = asyncHandler;
        this.responseTimeoutInMs = responseTimeoutInMs == -1 ? Integer.MAX_VALUE : responseTimeoutInMs;
        this.request = request;
        this.method = method;
        this.writeHeaders = true;
        this.writeBody = true;
    }

    protected void setInnerFuture(Future<V> innerFuture) {
        this.innerFuture = innerFuture;
    }

    @Override
    public void done(Callable callable) {
        this.isDone.set(true);
        if (this.reaperFuture != null) {
            this.reaperFuture.cancel(true);
        }
        super.done();
    }

    @Override
    public void content(V v) {
    }

    protected void setReaperFuture(Future<?> reaperFuture) {
        if (this.reaperFuture != null) {
            this.reaperFuture.cancel(true);
        }
        this.reaperFuture = reaperFuture;
    }

    public String toString() {
        return "ApacheResponseFuture{innerFuture=" + this.innerFuture + ", asyncHandler=" + this.asyncHandler + ", responseTimeoutInMs=" + this.responseTimeoutInMs + ", cancelled=" + this.cancelled + ", timedOut=" + this.timedOut + ", isDone=" + this.isDone + ", exception=" + this.exception + ", touch=" + this.touch + ", contentProcessed=" + this.contentProcessed + ", request=" + this.request + ", method=" + this.method + ", reaperFuture=" + this.reaperFuture + '}';
    }

    @Override
    public void abort(Throwable t) {
        if (this.innerFuture != null) {
            this.innerFuture.cancel(true);
        }
        if (this.method != null) {
            this.method.abort();
        }
        if (this.reaperFuture != null) {
            this.reaperFuture.cancel(true);
        }
        this.exception.set(t);
        if (!this.timedOut.get() && !this.cancelled.get()) {
            try {
                this.asyncHandler.onThrowable(t);
            }
            catch (Throwable t2) {
                logger.debug("asyncHandler.onThrowable", t2);
            }
        }
        super.done();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.cancelled.get() && this.innerFuture != null) {
            this.method.abort();
            try {
                this.asyncHandler.onThrowable(new CancellationException());
            }
            catch (Throwable t) {
                logger.debug("asyncHandler.onThrowable", t);
            }
            this.cancelled.set(true);
            if (this.reaperFuture != null) {
                this.reaperFuture.cancel(true);
            }
            super.done();
            return this.innerFuture.cancel(mayInterruptIfRunning);
        }
        super.done();
        return false;
    }

    @Override
    public boolean isCancelled() {
        if (this.innerFuture != null) {
            return this.innerFuture.isCancelled();
        }
        return false;
    }

    @Override
    public boolean isDone() {
        this.contentProcessed.set(true);
        return this.innerFuture.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.responseTimeoutInMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        V content = null;
        try {
            if (this.innerFuture != null) {
                content = this.innerFuture.get(timeout, unit);
            }
        }
        catch (TimeoutException t) {
            if (!this.contentProcessed.get() && timeout != -1L && System.currentTimeMillis() - this.touch.get() <= (long)this.responseTimeoutInMs) {
                return this.get(timeout, unit);
            }
            this.timedOut.set(true);
            throw new TimeoutException(String.format("No response received after %s", this.responseTimeoutInMs));
        }
        catch (CancellationException ce) {
            // empty catch block
        }
        if (this.exception.get() != null) {
            throw new ExecutionException(this.exception.get());
        }
        return content;
    }

    public boolean hasExpired() {
        return this.responseTimeoutInMs != -1 && System.currentTimeMillis() - this.touch.get() >= (long)this.responseTimeoutInMs;
    }

    @Override
    public void touch() {
        this.touch.set(System.currentTimeMillis());
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    public boolean getAndSetWriteHeaders(boolean writeHeaders) {
        boolean b = this.writeHeaders;
        this.writeHeaders = writeHeaders;
        return b;
    }

    @Override
    public boolean getAndSetWriteBody(boolean writeBody) {
        boolean b = this.writeBody;
        this.writeBody = writeBody;
        return b;
    }
}

