/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonatype.aether.ant.org.apache.maven.model.Repository;
import org.sonatype.aether.ant.org.apache.maven.model.RepositoryPolicy;
import org.sonatype.aether.ant.org.apache.maven.model.building.FileModelSource;
import org.sonatype.aether.ant.org.apache.maven.model.building.ModelSource;
import org.sonatype.aether.ant.org.apache.maven.model.resolution.InvalidRepositoryException;
import org.sonatype.aether.ant.org.apache.maven.model.resolution.ModelResolver;
import org.sonatype.aether.ant.org.apache.maven.model.resolution.UnresolvableModelException;
import org.sonatype.aether.ant.org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.ant.org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.ant.org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.ant.org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.ant.org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.ant.org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.ant.org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.ant.org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AntModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final String context;
    private List<RemoteRepository> repositories;
    private final RepositorySystem repoSys;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;

    public AntModelResolver(RepositorySystemSession session, String context, RepositorySystem repoSys, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories) {
        this.session = session;
        this.context = context;
        this.repoSys = repoSys;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.repositories = repositories;
        this.repositoryIds = new HashSet<String>();
    }

    private AntModelResolver(AntModelResolver original) {
        this.session = original.session;
        this.context = original.context;
        this.repoSys = original.repoSys;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.repositories = original.repositories;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (!this.repositoryIds.add(repository.getId())) {
            return;
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(AntModelResolver.convert(repository));
        this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
    }

    static RemoteRepository convert(Repository repository) {
        RemoteRepository result = new RemoteRepository(repository.getId(), repository.getLayout(), repository.getUrl());
        result.setPolicy(true, AntModelResolver.convert(repository.getSnapshots()));
        result.setPolicy(false, AntModelResolver.convert(repository.getReleases()));
        return result;
    }

    private static org.sonatype.aether.ant.org.sonatype.aether.repository.RepositoryPolicy convert(RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new org.sonatype.aether.ant.org.sonatype.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }

    @Override
    public ModelResolver newCopy() {
        return new AntModelResolver(this);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest(pomArtifact, this.repositories, this.context);
            pomArtifact = this.repoSys.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException("Failed to resolve POM for " + groupId + ":" + artifactId + ":" + version + " due to " + e.getMessage(), groupId, artifactId, version, e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }
}

