/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * A EISSystemException is used to indicate EIS specific error conditios.
 * Common error conditions are failure of the EIS, communication failure or an
 * EIS specific failure during creation of a new connection.
 */
public class EISSystemException extends ResourceException
{
   /**
	 * Create an exception.
	 */
   public EISSystemException()
   {
      super();
   }

   /**
	 * Create an exception with a reason.
	 */
   public EISSystemException(String reason)
   {
      super(reason);
   }

   /**
	 * Create an exception with a reason and an errorCode.
	 */
   public EISSystemException(String reason, String errorCode)
   {
      super(reason, errorCode);
   }

   /**
	 * Create an exception with a reason and cause.
	 * 
	 * @param reason the reason
	 * @param cause the cause
	 */
   public EISSystemException(String reason, Throwable cause)
   {
      super(reason, cause);
   }

   /**
	 * Create an exception with a cause.
	 * 
	 * @param cause the cause
	 */
   public EISSystemException(Throwable cause)
   {
      super(cause);
   }
}