/*******************************************************************************
 * Copyright (c) 2007 Exadel, Inc. and Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Exadel, Inc. and Red Hat, Inc. - initial API and implementation
 ******************************************************************************/ 
package org.jboss.tools.vpe.editor;

import static org.jboss.tools.vpe.xulrunner.util.XPCOM.queryInterface;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.template.VpePseudoContentCreator;
import org.jboss.tools.vpe.editor.util.HTML;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNSUIEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsISelectionController;
import org.mozilla.interfaces.nsISelectionDisplay;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 *	
 *	@deprecated 
 *
 */
public class VpeSelectionBuilder {
	private static int HUGE_DISTANCE = 999999;
	private VpeDomMapping domMapping;
	private VpeSourceDomBuilder sourceBuilder;
	private VpeVisualDomBuilder visualBuilder;
	// TODO Sergey Vasilyev figure out with press shell and selection controller
//	private nsIPresShell presShell;
	private VpeSelectionController visualSelectionController;

	VpeSelectionBuilder(VpeDomMapping domMapping, VpeSourceDomBuilder sourceBuilder, VpeVisualDomBuilder visualBuilder, VpeSelectionController visualSelectionController) {	
//	VpeSelectionBuilder(VpeDomMapping domMapping, VpeSourceDomBuilder sourceBuilder, VpeVisualDomBuilder visualBuilder, nsIPresShell presShell, nsISelectionController visualSelectionController) {
		this.domMapping = domMapping;
		this.sourceBuilder = sourceBuilder;
		this.visualBuilder = visualBuilder;
		// TODO Sergey Vasilyev figure out with selection controller and press shell
//		this.presShell = presShell;
		this.visualSelectionController = visualSelectionController;
		visualSelectionController.setSelectionFlags(nsISelectionDisplay.DISPLAY_ALL);
	}

	void setVisualSelection(Node sourceNode, int caretPosition) {
		setSelection(sourceNode, caretPosition, false);
	}
	
	public void setSelection(nsISelection selection) {
		
//		VpeTemplate vpeTemplate = SelectionUtil
//				.getTemplateByVisualSelection(visualBuilder.getPageContext(),
//						SelectionUtil.getSelectedNode(selection));
//		if (vpeTemplate instanceof ITemplateSelectionManager) {
//			((ITemplateSelectionManager) vpeTemplate).setSelection(
//					visualBuilder.getPageContext(), selection);
//			return;
//		}
		
		if (selection.getIsCollapsed()) {
			VisualSelectionInfo info = getVisualFocusSelectedInfo(selection);
			if (info != null) {
				nsIDOMNode visualNode = info.node;
				Node node = domMapping.getSourceNode(visualNode);
				Node sourceNode;
				if (node == null) {
					sourceNode = domMapping.getNearSourceNode(visualNode);
				} else {
					sourceNode = node;
				}
				nsIDOMNode visualSelectedNode = domMapping.getVisualNode(sourceNode);
				if (visualSelectedNode == null) {
					visualSelectedNode = visualNode;
				}
				if (VpeDebug.PRINT_VISUAL_SELECTION_EVENT) {
					System.out.println("      visualNode: " + visualSelectedNode.getNodeName() + "(" + visualSelectedNode + ")  sourceNode: " + (sourceNode == null ? null : sourceNode.getNodeName()) + "  node: " + node); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				}
				if (sourceNode != null) {
					switch (visualSelectedNode.getNodeType()) {
					case nsIDOMNode.TEXT_NODE:
						nsIDOMElement visualParentElement = queryInterface(visualSelectedNode.getParentNode(), nsIDOMElement.class);
						visualBuilder.setSelectionRectangle(visualParentElement, false);
//						int pos = DataHelper.textPos(visualSelectedNode.getNodeValue(), selection.getFocusOffset());
						int pos = selection.getFocusOffset();
						
						try{
							IndexedRegion region = (IndexedRegion)sourceNode;
							String text = sourceBuilder.getStructuredTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset()-region.getStartOffset());
							pos = TextUtil.sourcePosition(text, visualSelectedNode.getNodeValue(), selection.getFocusOffset());
						}catch(BadLocationException ex){
							VpePlugin.reportProblem(ex);
						}
						sourceBuilder.setSelection(sourceNode, pos, 0);
						break;
					case nsIDOMNode.ELEMENT_NODE:
						if (VpeVisualDomBuilder.isIncludeElement(queryInterface(visualSelectedNode, nsIDOMElement.class))) {
							visualBuilder.setSelectionRectangle(queryInterface(visualSelectedNode, nsIDOMElement.class), false);
							visualSelectionController.setCaretEnabled(false);
							sourceBuilder.setSelection(sourceNode, 0, 0);
						} else if (sourceNode.getNodeType() == Node.COMMENT_NODE) {
							visualBuilder.setSelectionRectangle(queryInterface(visualSelectedNode, nsIDOMElement.class), false);
//							pos = DataHelper.textPos(visualNode.getNodeValue(), selection.getFocusOffset());
							pos = selection.getFocusOffset();
							try{
								IndexedRegion region = (IndexedRegion)sourceNode;
								String text = sourceBuilder.getStructuredTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset()-region.getStartOffset());
								pos = TextUtil.sourcePosition(text, visualSelectedNode.getNodeValue(), selection.getFocusOffset());
							}catch(BadLocationException ex){
								VpePlugin.reportProblem(ex);
							}
							sourceBuilder.setSelection(sourceNode, pos, 0);
						} else if (visualBuilder.isContentArea(visualSelectedNode) && visualBuilder.isEmptyDocument()) {
							visualBuilder.setSelectionRectangle(queryInterface(visualSelectedNode, nsIDOMElement.class), false);
							sourceBuilder.setSelectionAtDocumentEnd();
						} else {
							nsIDOMNode containerForPseudoContent = VpePseudoContentCreator.getContainerForPseudoContent(visualNode);
							if (containerForPseudoContent != null) {
								sourceNode = domMapping.getNearSourceNode(containerForPseudoContent);
								visualBuilder.setSelectionRectangle(queryInterface(containerForPseudoContent, nsIDOMElement.class), false);
								sourceBuilder.setSelection(sourceNode, 0, 0, true);
								visualSelectionController.setCaretEnabled(false);
							} else {
								boolean border = false;
								if(domMapping.getNodeMapping(visualSelectedNode) instanceof VpeElementMapping){
									VpeElementMapping element = (VpeElementMapping)domMapping.getNodeMapping(visualSelectedNode);
									if(element.isBorder(visualNode)){
										info.startFlag = true;
										border = true;
									}
								}
								
								if (!border && visualNode.getNodeType() == Node.TEXT_NODE && node == null) {
									visualBuilder.setSelectionRectangle(queryInterface(visualSelectedNode, nsIDOMElement.class), false);
									sourceBuilder.setAttributeSelection(visualNode, selection.getFocusOffset(), 0);
									if (!visualBuilder.isTextEditable(visualNode)) {
										visualSelectionController.setCaretEnabled(false);
									}
								} else {
									if (info.startFlag) {
										visualBuilder.setSelectionRectangle(queryInterface(visualSelectedNode, nsIDOMElement.class), false);
									} else {
										visualParentElement = queryInterface(visualSelectedNode.getParentNode(), nsIDOMElement.class);
										visualBuilder.setSelectionRectangle(visualParentElement, false);
									}
									int offset = info.startFlag ? 0 : ((IndexedRegion)sourceNode).getEndOffset() -
											((IndexedRegion)sourceNode).getStartOffset();
									if (info.startFlag && info.isPseudoElement()) {
										sourceBuilder.setSelection(sourceNode, 0, 0, true);
									} else {
										sourceBuilder.setSelection(sourceNode, offset, 0);
									}
								}
							}
						}
						break;
					}
				}
			}
		} else {
			nsIDOMRange range = selection.getRangeAt(0);
			nsIDOMNode visualAncestor = range.getCommonAncestorContainer();
			
			Node sourceAncestor = domMapping.getNearSourceNode(visualAncestor);
			nsIDOMNode visualSelectedAncestor = domMapping.getVisualNode(sourceAncestor);
			
			if (visualSelectedAncestor == null) {
				visualSelectedAncestor = visualAncestor;
			}

			boolean border = false;
			VpeNodeMapping nodeMapping = domMapping.getNodeMapping(visualSelectedAncestor);
			
			if (visualSelectedAncestor.getNodeType() == Node.ELEMENT_NODE){
				if (nodeMapping != null && (nodeMapping instanceof VpeElementMapping)  && ((VpeElementMapping)nodeMapping).isBorder(visualAncestor)){
					visualSelectedAncestor = ((VpeElementMapping)nodeMapping).getBorder();
					border = true;
				}
			}
			
			if (sourceAncestor != null) {
				switch (visualSelectedAncestor.getNodeType()) {
				case Node.TEXT_NODE:
					nsIDOMElement visualParentElement = queryInterface(visualSelectedAncestor.getParentNode(), nsIDOMElement.class);
					visualBuilder.setSelectionRectangle(visualParentElement, false);
					
//					int start = DataHelper.textPos(visualSelectedAncestor.getNodeValue(), selection.getAnchorOffset());
//					int end = DataHelper.textPos(visualSelectedAncestor.getNodeValue(), selection.getFocusOffset());
					int start = selection.getAnchorOffset();
					int end = selection.getFocusOffset();
					try{
						IndexedRegion region = (IndexedRegion)sourceAncestor;
						String text = sourceBuilder.getStructuredTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset()-region.getStartOffset());
						start = TextUtil.sourcePosition(text, visualSelectedAncestor.getNodeValue(), selection.getAnchorOffset());
						end = TextUtil.sourcePosition(text, visualSelectedAncestor.getNodeValue(), selection.getFocusOffset());
					}catch(BadLocationException ex){
						VpePlugin.reportProblem(ex);
					}
					
					sourceBuilder.setSelection(sourceAncestor, start, end - start);
					break;
				case Node.ELEMENT_NODE:
					if (sourceAncestor.getNodeType() == Node.COMMENT_NODE) {
						visualBuilder.setSelectionRectangle(queryInterface(visualSelectedAncestor, nsIDOMElement.class), false);
//						start = DataHelper.textPos(sourceAncestor.getNodeValue(), selection.getAnchorOffset());
//						end = DataHelper.textPos(sourceAncestor.getNodeValue(), selection.getFocusOffset());
						start = selection.getAnchorOffset();
						end = selection.getFocusOffset();
						try{
							IndexedRegion region = (IndexedRegion)sourceAncestor;
							String text = sourceBuilder.getStructuredTextViewer().getDocument().get(region.getStartOffset(), region.getEndOffset()-region.getStartOffset());
							start = TextUtil.sourcePosition(text, sourceAncestor.getNodeValue(), selection.getAnchorOffset());
							end = TextUtil.sourcePosition(text, sourceAncestor.getNodeValue(), selection.getFocusOffset());
						}catch(BadLocationException ex){
							VpePlugin.reportProblem(ex);
						}
						sourceBuilder.setSelection(sourceAncestor, start, end - start);
					} else { 
						nsIDOMNode visualAnchorNode = selection.getAnchorNode();
						int visualAnchorOffset = selection.getAnchorOffset();
						nsIDOMNode visualFocusNode = selection.getFocusNode();
						
						int visualFocusOffset = selection.getFocusOffset();
						if (visualFocusNode.equals(visualAnchorNode) && visualFocusOffset - visualAnchorOffset == 1 && visualFocusNode.getNodeType() == Node.ELEMENT_NODE) {
							VisualSelectionInfo info = getVisualSelectedInfo(visualAnchorNode, visualAnchorOffset);
							if (info != null) {
								nsIDOMNode visualNode = info.node;
								visualBuilder.setSelectionRectangle(queryInterface(visualNode, nsIDOMElement.class), false);
								Node sourceNode = domMapping.getNearSourceNode(visualNode);
								int sourceStartOffset = ((IndexedRegion)sourceNode).getStartOffset();
								int sourceEndOffset = ((IndexedRegion)sourceNode).getEndOffset();
								sourceBuilder.setSelection(sourceNode, 0, sourceEndOffset - sourceStartOffset);
							}
						} else {
							visualBuilder.setSelectionRectangle(queryInterface(visualSelectedAncestor, nsIDOMElement.class), false);
	
							if (!border && visualAncestor.getNodeType() == Node.TEXT_NODE) {
								sourceBuilder.setAttributeSelection(visualAncestor, visualAnchorOffset, visualFocusOffset - visualAnchorOffset);
							} else {
								int sourceAncestorOffset = ((IndexedRegion)sourceAncestor).getStartOffset();
								int sourceAnchorOffset = getSourceOffset(visualAnchorNode, visualAnchorOffset);
								int sourceFocusOffset = getSourceOffset(visualFocusNode, visualFocusOffset);
								sourceBuilder.setSelection(sourceAncestor, sourceAnchorOffset - sourceAncestorOffset, sourceFocusOffset - sourceAnchorOffset);
							}
						}
					}
					break;
				}
			}
		}
	}
	
	private int getSourceOffset(nsIDOMNode visualPrmNode, int visualPrmOffset) {
		VisualSelectionInfo info = getVisualSelectedInfo(visualPrmNode, visualPrmOffset);
		if (info != null) {
			nsIDOMNode visualNode = info.node;
			Node sourceNode = domMapping.getNearSourceNode(visualNode);
			if (sourceNode != null) {
				switch (sourceNode.getNodeType()) {
				case Node.TEXT_NODE:
					try{
						IndexedRegion region = (IndexedRegion)sourceNode;
						int start = region.getStartOffset();
						String sourceText = sourceBuilder.getStructuredTextViewer().getDocument().get(start, region.getEndOffset() - start);
						if (visualPrmNode.getNodeType() == Node.TEXT_NODE) {
							return start + TextUtil.sourcePosition(sourceText, visualNode.getNodeValue(), visualPrmOffset);
						} else if (info.startFlag) {
							return start;
						} else {
							String visualValue = visualNode.getNodeValue();
							return start + TextUtil.sourcePosition(sourceText, visualValue, visualValue.length());
						}
					} catch(BadLocationException ex){
						VpePlugin.reportProblem(ex);
						return 0;
					}
				case Node.ELEMENT_NODE:
					return info.startFlag ? ((IndexedRegion)sourceNode).getStartOffset() : ((IndexedRegion)sourceNode).getEndOffset();
				case Node.COMMENT_NODE:
					return ((IndexedRegion)sourceNode).getStartOffset() + visualPrmOffset + 4;
				}
			}
		}
		return 0;
	}
	
	void setClickSelection(nsIDOMNode visualNode) {
		Node sourceNode = domMapping.getNearSourceNode(visualNode);
		nsIDOMNode visualSelectedNode = domMapping.getVisualNode(sourceNode);
		if (visualSelectedNode == null) {
			visualSelectedNode = visualNode;
		}
		setVisualSelectionAtVisualNode(visualSelectedNode, 0);
		sourceBuilder.setSelection(sourceNode, 0, 0);
	}
	
	void _setClickContentAreaSelection() {
		Node sourceNode = sourceBuilder.getSelectedNode();
		if (sourceNode != null) {
			int caretPosition = sourceBuilder.getCaretPosition();
			setSelection(sourceNode, caretPosition, true);
		}
	}
	
	void setClickContentAreaSelection() {
		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
		setSelection(selection);
	}
	
	void setClickContentAreaSelection(nsIDOMMouseEvent mouseEvent) {
//		Node visualNode = mouseEvent.getTargetNode();
//		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
//		Node anchorNode = selection.getAnchorNode();
//		Node focusNode = selection.getFocusNode();
	}
	
	Node setContextMenuSelection(nsIDOMNode visualNode) {
		if (VpeDebug.PRINT_VISUAL_CONTEXTMENU_EVENT) {
			System.out.println(">>>>>>>>>>>>>> onShowContextMenu  visualNode: " + visualNode.getNodeName() + "(" + visualNode + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		visualSelectionController.setCaretEnabled(false);
		
		nsIDOMNode visualParentNode = visualNode.getParentNode();
		if (visualParentNode.getNodeType() == Node.DOCUMENT_NODE) {
			visualNode = visualBuilder.getContentArea();
		}
		Node selectedText = getSelectedTextOnly(visualNode);
		if (selectedText != null) {
			return selectedText;
		} else {
			return setContextMenuElementSelection(visualNode);
		}
	}
	
	private Node setContextMenuElementSelection(nsIDOMNode visualNode) {
		Node sourceNode = domMapping.getNearSourceNode(visualNode);
		nsIDOMNode visualSelectedNode = domMapping.getVisualNode(sourceNode);
		if (visualSelectedNode == null) {
			visualSelectedNode = visualNode;
		}
		setVisualSelectionAtVisualNode(visualSelectedNode, 0);
		//added by Max Areshkau in scope of JBIDE-1209
		if(sourceNode.getNodeType()!=Node.TEXT_NODE) {
				sourceBuilder.setSelection(sourceNode, 0, 0);
		} else if(sourceNode.getNodeType()==Node.TEXT_NODE) {
			IndexedRegion region = (IndexedRegion)sourceNode;
			sourceBuilder.setSelection(sourceNode, 0, region.getLength());
		}
		return sourceNode;
	}
	
	private Node getSelectedTextOnly(nsIDOMNode element) {
		Node selectedText = null;
		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
		if (!selection.getIsCollapsed()) {
			nsIDOMNode anchorNode = selection.getAnchorNode();
			nsIDOMNode focusNode = selection.getFocusNode();
			if (anchorNode != null && anchorNode.getNodeType() == Node.TEXT_NODE && anchorNode.equals(focusNode)) {
				nsIDOMNode anchorParent = anchorNode.getParentNode();
				if (anchorParent != null) {
					if (anchorParent.equals(element)) {
						selectedText = domMapping.getSourceNode(anchorNode);
					}
				}
			}
		}
		return selectedText;
	}
	
	private void setVisualSelectionAtVisualNode(nsIDOMNode visualNode, int offset) {
		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
		if (visualNode != null) {
			switch (visualNode.getNodeType()) {
			case nsIDOMNode.TEXT_NODE:
				if (offset > visualNode.getNodeValue().length()) {
					offset = visualNode.getNodeValue().length();
				}
				selection.collapse(visualNode, offset);
				nsIDOMElement visualParentElement = queryInterface(visualNode.getParentNode(), nsIDOMElement.class);
				visualBuilder.setSelectionRectangle(visualParentElement);
				break;
			case nsIDOMNode.ELEMENT_NODE:
				Node node = domMapping.getSourceNode(visualNode);
				if (node != null && node.getNodeType() == Node.COMMENT_NODE) {
					nsIDOMNodeList visualNodes = visualNode.getChildNodes();
					long len = visualNodes.getLength();
					if (len > 0) {
						nsIDOMNode visualText = visualNodes.item(0);
						String text = visualText.getNodeValue();
						if (offset >  text.length()) {
							offset = text.length();
						}
						selection.collapse(visualText, offset);
						visualBuilder.setSelectionRectangle(queryInterface(visualNode, nsIDOMElement.class));
					}
				} else {
					if (offset == 0) {
						offset = (int)VisualDomUtil.getOffset(visualNode);
						nsIDOMNode visualParentNode = visualNode.getParentNode();
						if (visualParentNode != null && visualParentNode.getNodeType() == Node.ELEMENT_NODE) {
							selection.collapse(visualParentNode, offset);
							visualBuilder.setSelectionRectangle(queryInterface(visualNode, nsIDOMElement.class));
						} else {
							selection.removeAllRanges();
							visualBuilder.setSelectionRectangle(null);
						}
					} else if (offset == 1) {
						nsIDOMNode appreciableVisualChild = VpeVisualDomBuilder.getLastAppreciableVisualChild(visualNode);
						if (appreciableVisualChild != null) {
							if (appreciableVisualChild.getNodeType() == nsIDOMNode.TEXT_NODE) {
								offset = appreciableVisualChild.getNodeValue().length();
								selection.collapse(appreciableVisualChild, offset);
								visualBuilder.setSelectionRectangle(queryInterface(visualNode, nsIDOMElement.class));
							} else {
								offset = (int)VisualDomUtil.getOffset(appreciableVisualChild) + 1;
								selection.collapse((nsIDOMNode)visualNode, offset);
								visualBuilder.setSelectionRectangle(queryInterface(visualNode, nsIDOMElement.class));
							}
						} else {
							offset = 0;
							selection.collapse(visualNode, offset);
							visualBuilder.setSelectionRectangle(queryInterface(visualNode, nsIDOMElement.class));
						}
					} else {
						offset = (int)VisualDomUtil.getOffset(visualNode);
						nsIDOMNode visualParentNode = visualNode.getParentNode();
						if (visualParentNode.getNodeType() == nsIDOMNode.ELEMENT_NODE) {
							selection.collapse(visualParentNode, offset);
							visualBuilder.setSelectionRectangle(queryInterface(visualParentNode, nsIDOMElement.class));
						} else {
							selection.removeAllRanges();
							visualBuilder.setSelectionRectangle(null);
						}
					}
				}
				break;
			default:
				selection.removeAllRanges();
				visualBuilder.setSelectionRectangle(null);
			}
		} else {
			selection.removeAllRanges();
			visualBuilder.setSelectionRectangle(null);
		}
	}
	
	private VisualSelectionInfo getVisualFocusSelectedInfo(nsISelection selection) {
		nsIDOMNode focusNode = selection.getFocusNode();
		if (focusNode != null && focusNode.getNodeType() == Node.TEXT_NODE) {
			nsIDOMNode parent = focusNode.getParentNode();
			if (parent == null) {
				return null;
			}
		}
		VisualSelectionInfo info = getVisualSelectedInfo(focusNode, selection.getFocusOffset());
		return info;
	}
	
	private VisualSelectionInfo getVisualSelectedInfo(nsIDOMNode visualNode, int visualOffset) {
		if (visualNode != null) {
			switch (visualNode.getNodeType()) {
			case nsIDOMNode.TEXT_NODE:
				return new VisualSelectionInfo(visualNode);
			case nsIDOMNode.ELEMENT_NODE:
				nsIDOMNodeList visualNodes = visualNode.getChildNodes();
				nsIDOMNode visualChild;
				boolean startFlag = true;
				long len = visualNodes.getLength();
				if (visualOffset < len) {
					visualChild = visualNodes.item(visualOffset);
					if (visualOffset > 0 && visualChild != null && visualChild.getNodeType() == Node.TEXT_NODE) {
						nsIDOMNode visualPrevChild = visualNodes.item(visualOffset - 1);
						if (visualPrevChild != null && visualPrevChild.getNodeType() != Node.TEXT_NODE) {
							visualChild = visualPrevChild;
							startFlag = false;
						}
					}
				} else if (len > 0) {
					visualChild = visualNodes.item(len - 1);
					startFlag = false;
				} else {
					visualChild = visualNode;
				}
				return new VisualSelectionInfo(visualChild, startFlag);
			}
		}
		return null;
	}

	private void setSelection(Node sourceNode, int caretPosition, boolean showCaret) {
		nsIDOMNode visualNode = domMapping.getNearVisualNode(sourceNode);
		int startOffset =  ((IndexedRegion)sourceNode).getStartOffset();
		int endOffset =  ((IndexedRegion)sourceNode).getEndOffset();
		if (caretPosition >= startOffset && caretPosition <= endOffset) {
			int offset = caretPosition - ((IndexedRegion)sourceNode).getStartOffset();
			if (sourceNode.getNodeType() == Node.TEXT_NODE && offset > sourceNode.getNodeValue().length()) {
				offset = sourceNode.getNodeValue().length();
			}
			if (!showCaret) {
				visualSelectionController.setCaretEnabled(false);
			}
			setVisualSelectionAtVisualNode(visualNode, offset);
		}
	}

	public void setVisualSelection(Node sourceAnchorNode, int sourceAnchorOffset, Node sourceFocusNode, int sourceFocusOffset, boolean reversionFlag, boolean showCaret) {
		setVisualSelection(sourceAnchorNode, sourceAnchorOffset, sourceFocusNode, sourceFocusOffset, reversionFlag, showCaret, false);
	}

	public void setVisualSelection(Node sourceAnchorNode, int sourceAnchorOffset, Node sourceFocusNode, int sourceFocusOffset, boolean reversionFlag, boolean showCaret, boolean into) {
//		if (sourceAnchorNode.getNodeType() == Node.TEXT_NODE) {
//			sourceAnchorOffset = DataHelper.focusPos(sourceAnchorNode.getNodeValue(), sourceAnchorOffset);
//		}
//		if (sourceFocusNode.getNodeType() == Node.TEXT_NODE) {
//			sourceFocusOffset = DataHelper.focusPos(sourceFocusNode.getNodeValue(), sourceFocusOffset);
//		}
		if (!showCaret) {
			visualSelectionController.setCaretEnabled(false);
		}
		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
		if (sourceAnchorNode == null || sourceFocusNode == null) {
			selection.removeAllRanges();
			visualBuilder.setSelectionRectangle(null);
		} else if (sourceAnchorNode == sourceFocusNode && sourceAnchorOffset == sourceFocusOffset) {
			nsIDOMNode visualNode = domMapping.getNearVisualNode(sourceAnchorNode);
			if (visualNode != null) {
				if (sourceAnchorNode.getNodeType() == Node.TEXT_NODE) {
					if (visualNode.getNodeType() != Node.TEXT_NODE) {
						sourceAnchorOffset = 1;
					} else if (sourceAnchorOffset > sourceAnchorNode.getNodeValue().length()) {
						sourceAnchorOffset = sourceAnchorNode.getNodeValue().length();
					}
				}
				if (into && visualNode != null && visualNode.getChildNodes().getLength() == 1) {
					nsIDOMNode br = VisualDomUtil.getChildNode(visualNode, 0);
					if (HTML.TAG_BR.equalsIgnoreCase(br.getNodeName())) {
						visualNode = VisualDomUtil.getChildNode(visualNode, 0);
						sourceAnchorOffset = 2;
					}
				}
			} else if (sourceAnchorNode.getNodeType() == Node.ATTRIBUTE_NODE) {
				visualNode = visualBuilder.getOutputTextNode((Attr)sourceAnchorNode);
				if (visualNode != null) {
					if (!visualBuilder.isTextEditable(visualNode)) {
						sourceAnchorOffset = 0;
					}
				} else {
					visualNode = domMapping.getNearVisualNode(((Attr)sourceAnchorNode).getOwnerElement());
					sourceAnchorOffset = 0;
				}
			}
			// comment selection was changed
			if(sourceAnchorNode instanceof CommentImpl){
				sourceAnchorOffset=0;
			}
			setVisualSelectionAtVisualNode(visualNode, sourceAnchorOffset);
		} else {
			nsIDOMNode visualAnchorNode = null;
			nsIDOMNode visualFocusNode = null;
			boolean anchorStartFlag = false;
			boolean focusStartFlag = false;
			boolean anchorDirectFlag = true;
			boolean focusDirectFlag = true;

			if (!reversionFlag) {
				VisualSelectionInfo anchorInfo = getStartSelectionInfo(sourceAnchorNode, sourceAnchorOffset == 0);
				if (anchorInfo != null) {
					visualAnchorNode = anchorInfo.node;
					anchorStartFlag = anchorInfo.startFlag;
					anchorDirectFlag = anchorInfo.directFlag;
				}
				VisualSelectionInfo focusInfo = getEndSelectionInfo(sourceFocusNode, sourceFocusOffset == 0);
				if (focusInfo != null) {
					visualFocusNode = focusInfo.node;
					focusStartFlag = focusInfo.startFlag;
					focusDirectFlag = focusInfo.directFlag;
				}
			} else {
				VisualSelectionInfo anchorInfo = getEndSelectionInfo(sourceAnchorNode, sourceAnchorOffset == 0);
				if (anchorInfo != null) {
					visualAnchorNode = anchorInfo.node;
					anchorStartFlag = anchorInfo.startFlag;
					anchorDirectFlag = anchorInfo.directFlag;
				}
				VisualSelectionInfo focusInfo = getStartSelectionInfo(sourceFocusNode, sourceFocusOffset == 0);
				if (focusInfo != null) {
					visualFocusNode = focusInfo.node;
					focusStartFlag = focusInfo.startFlag;
					focusDirectFlag = focusInfo.directFlag;
				}
			}

			if (visualAnchorNode == null || visualFocusNode == null) {
				selection.removeAllRanges();
				visualBuilder.setSelectionRectangle(null);
				return;
			}

			nsIDOMNode visualAnchorContainer = null;
			long visualAnchorOffset = 0;
			if (visualAnchorNode.getNodeType() == Node.TEXT_NODE) {
				visualAnchorContainer = visualAnchorNode;
				if (anchorDirectFlag && sourceAnchorNode.getNodeType() == Node.TEXT_NODE) {
					if (sourceAnchorOffset > sourceAnchorNode.getNodeValue().length()) {
						visualAnchorOffset = sourceAnchorNode.getNodeValue().length();
					} else {
						visualAnchorOffset = sourceAnchorOffset;
					}
					if (visualAnchorOffset > visualAnchorNode.getNodeValue().length()) {
						visualAnchorOffset = visualAnchorNode.getNodeValue().length();
					}
				} else {
					if (anchorStartFlag) {
						visualAnchorOffset = 0;
					} else {
						visualAnchorOffset = visualAnchorNode.getNodeValue().length();
					}
				}
			} else if (sourceAnchorNode.getNodeType() == Node.COMMENT_NODE) {
				nsIDOMNodeList visualNodes = visualAnchorNode.getChildNodes();
				long len = visualNodes.getLength();
				if (len > 0) {
					visualAnchorContainer = visualNodes.item(0); 
					String text = visualAnchorContainer.getNodeValue();
					if (text!=null&& sourceAnchorOffset <= text.length()) {
						visualAnchorOffset = sourceAnchorOffset;
					} else if (text!=null) {
						visualAnchorOffset = text.length();
					}
				}
			} else {
				visualAnchorContainer = visualAnchorNode.getParentNode();
				visualAnchorOffset = VisualDomUtil.getOffset(visualAnchorNode);
				if (!anchorStartFlag) visualAnchorOffset++;
			}
			if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
				System.out.println("setVisualSelection"); //$NON-NLS-1$
				System.out.println("                     visualAnchorNode: " + visualAnchorNode.getNodeName() + "(" + visualAnchorNode + ")  visualAnchorContainer: " + visualAnchorContainer.getNodeName() + "(" + visualAnchorContainer + ")  visualAnchorOffset: " + visualAnchorOffset +  "  anchorStartFlag: " + anchorStartFlag); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			}
			
			nsIDOMNode visualFocusContainer = null;
			long visualFocusOffset = 0;
			if (visualFocusNode.getNodeType() == Node.TEXT_NODE) {
				visualFocusContainer = visualFocusNode;
				if (focusDirectFlag && sourceFocusNode.getNodeType() == Node.TEXT_NODE) {
					if (sourceFocusOffset > sourceFocusNode.getNodeValue().length()) {
						visualFocusOffset = sourceFocusNode.getNodeValue().length();
					} else {
						visualFocusOffset = sourceFocusOffset;
					}
					if (visualFocusOffset > visualFocusNode.getNodeValue().length()) {
						visualFocusOffset = visualFocusNode.getNodeValue().length();
					}
				} else {
					if (focusStartFlag) {
						visualFocusOffset = 0;
					} else {
						visualFocusOffset = visualFocusNode.getNodeValue().length();
					}
				}
			} else if (sourceFocusNode.getNodeType() == Node.COMMENT_NODE) {
				nsIDOMNodeList visualNodes = visualFocusNode.getChildNodes();
				long len = visualNodes.getLength();
				if (len > 0) {
					visualFocusContainer = visualNodes.item(0); 
					String text = visualFocusContainer.getNodeValue();
					if (text!=null&&sourceFocusOffset <= text.length()) {
						visualFocusOffset = sourceFocusOffset;
					} else if(text!=null) {
						visualFocusOffset = text.length();
					}
				}
			} else {
				visualFocusContainer = visualFocusNode.getParentNode();
				visualFocusOffset = VisualDomUtil.getOffset(visualFocusNode);
				if (!focusStartFlag) visualFocusOffset++;
			}
			if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
				System.out.println("                     visualFocusNode: " + //$NON-NLS-1$
						(visualFocusNode != null ? 
								visualFocusNode.getNodeName() + "(" + visualFocusNode + ")" : null) +  //$NON-NLS-1$ //$NON-NLS-2$
						"  visualFocusContainer: " + //$NON-NLS-1$
						(visualFocusContainer != null ?
								visualFocusContainer.getNodeName() + "(" + visualFocusContainer + ") visualFocusOffset: " + visualFocusOffset + "  focusStartFlag: " + focusStartFlag : null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			
// Ed tmp
if (visualAnchorContainer == null || visualFocusContainer == null) {
	return;
}
			
			if (visualAnchorContainer.equals((visualFocusContainer)) && visualAnchorOffset == visualFocusOffset) {
				if (!reversionFlag) {
					setVisualSelectionAtVisualNode(visualFocusNode, 0);
				} else {
					setVisualSelectionAtVisualNode(visualAnchorNode, 0);
				}
			} else {
				selection.collapse(visualAnchorContainer, (int)visualAnchorOffset);
				selection.extend(visualFocusContainer, (int)visualFocusOffset);
				nsIDOMElement commonElement = getVisualCommonElement(visualAnchorNode, visualFocusNode);
				visualBuilder.setSelectionRectangle(commonElement);
				if (commonElement != null && !commonElement.equals(visualAnchorNode) && !commonElement.equals(visualFocusNode) &&
						!commonElement.equals(visualAnchorContainer) && !commonElement.equals(visualFocusContainer)) {
				}
			}
		}
	}
	
	private VisualSelectionInfo getStartSelectionInfo(Node sourceNode, boolean initialStartFlag) {
		boolean startFlag = initialStartFlag;
		nsIDOMNode visualNode = domMapping.getVisualNode(sourceNode);
		boolean directFlag = visualNode != null;
		while (sourceNode != null && visualNode == null) {
			Node sourcePrevNode = sourceNode.getPreviousSibling();
			if (sourcePrevNode != null) {
				sourceNode = sourcePrevNode;
				startFlag = false;
			} else {
				sourceNode = sourceNode.getParentNode();
				startFlag = true;
			}
			visualNode = domMapping.getVisualNode(sourceNode);
		}
		if (visualNode != null) {
			return new VisualSelectionInfo(visualNode, startFlag, directFlag);
		} else {
			return null;
		}
	}
	
	private VisualSelectionInfo getEndSelectionInfo(Node sourceNode, boolean initialStartFlag) {
		boolean startFlag = initialStartFlag;
		nsIDOMNode visualNode = domMapping.getVisualNode(sourceNode);
		boolean directFlag = visualNode != null;
		while (sourceNode != null && visualNode == null) {
			Node sourceNextNode = sourceNode.getNextSibling();
			if (sourceNextNode != null) {
				sourceNode = sourceNextNode;
				startFlag = true;
			} else {
				sourceNode = sourceNode.getParentNode();
				startFlag = false;
			}
			visualNode = domMapping.getVisualNode(sourceNode);
		}
		if (visualNode != null) {
			return new VisualSelectionInfo(visualNode, startFlag, directFlag);
		} else {
			return null;
		}
	}
	
	private nsIDOMElement getVisualCommonElement(nsIDOMNode nodeA, nsIDOMNode nodeB) {
		nsIDOMNode[] nodesA = getVisualPath(nodeA);
		nsIDOMNode[] nodesB = getVisualPath(nodeB);
		int len = Math.min(nodesA.length, nodesB.length);
		int index = len;
		for (int i = 0; i < len; i++) {
			if (!nodesA[i].equals(nodesB[i])) {
				index = i;
				break;
			}
		}
		if (index == -1) {
			index = len;
		}

		if (index > 0) {
			nsIDOMNode commonNode = nodesA[index - 1];
			if (commonNode.getNodeType() == Node.TEXT_NODE) {
				nsIDOMNode parent = commonNode.getParentNode();
				commonNode = parent;
			}
			return queryInterface(commonNode, nsIDOMElement.class);
		} else {
			return null;
		}
	}
	
	private nsIDOMNode[] getVisualPath(nsIDOMNode node) {
		return getVisualPath(node, 0);
	}
	
	private nsIDOMNode[] getVisualPath(nsIDOMNode node, int height) {
		height++;
		nsIDOMNode[] path;
		nsIDOMNode parent = node.getParentNode();
		if (parent != null) {
			path = getVisualPath(parent, height);
		} else {
			path = new nsIDOMNode[height];
		}
		path[path.length - height] = node;
		return path;
	}

	private static class VisualSelectionInfo {
		nsIDOMNode node;
		boolean startFlag;
		boolean directFlag;
		
		private VisualSelectionInfo(nsIDOMNode node) {
			this.node = node;
		}
		
		private VisualSelectionInfo(nsIDOMNode node, boolean startFlag) {
			this(node, startFlag, true);
		}
		
		private VisualSelectionInfo(nsIDOMNode node, boolean startFlag, boolean directFlag) {
			this(node);
			this.startFlag = startFlag;
			this.directFlag = directFlag;
		}
		
		private boolean isPseudoElement() {
			return VpeVisualDomBuilder.isPseudoElement(node);
		}
	}
	
	public VpeVisualCaretInfo getVisualCaretInfo(nsIDOMEvent event) {
		nsIDOMNSUIEvent nsuiEvent = queryInterface(event, nsIDOMNSUIEvent.class);
		
		return new VpeVisualCaretInfo(this, nsuiEvent.getRangeParent(), nsuiEvent.getRangeOffset());
	}
	
//this method is never used
//	void showVisualDragCaret(nsIDOMNode node, int offset) {
//		visualBuilder.showDragCaret(node, offset);
//	}
	
//this method is never used
//	void hideVisualDragCaret() {
//		visualBuilder.hideDragCaret();
//	}
	
	int getSourcePosition(nsIDOMNode visualInitNode, int visualInitOffset) {
		int position = 0;
		VisualSelectionInfo info = getVisualSelectedInfo(visualInitNode, visualInitOffset);
		if (info != null) {
			nsIDOMNode visualNode = info.node;
			Node sourceNode = domMapping.getNearSourceNode(visualNode);
			nsIDOMNode visualSelectedNode = domMapping.getVisualNode(sourceNode);
			if (visualSelectedNode == null) {
				visualSelectedNode = visualNode;
			}
			if (sourceNode != null) {
				switch (visualSelectedNode.getNodeType()) {
				case Node.TEXT_NODE:
					if (visualInitNode.getNodeType() != Node.TEXT_NODE) {
						visualInitOffset = info.startFlag ? 0 : visualSelectedNode.getNodeValue().length(); 
					}
//					int ofset = DataHelper.textPos(visualSelectedNode.getNodeValue(), visualInitOffset);
					int ofset = visualInitOffset;
					position = sourceBuilder.getPosition(sourceNode, ofset, false);

					
					try{
						IndexedRegion region = (IndexedRegion)sourceNode;
						int start = region.getStartOffset();
						String text = sourceBuilder.getStructuredTextViewer().getDocument().get(start, region.getEndOffset() - start);
						position = start + TextUtil.sourcePosition(text, visualSelectedNode.getNodeValue(), visualInitOffset);
					}catch(BadLocationException ex){
						VpePlugin.reportProblem(ex);
					}
					
					
					
					break;
				case Node.ELEMENT_NODE:
					int offset = info.startFlag ? 0 : ((IndexedRegion)sourceNode).getEndOffset() -
							((IndexedRegion)sourceNode).getStartOffset();
					if (info.startFlag && info.isPseudoElement()) {
						position = sourceBuilder.getPosition(sourceNode, 0, true);
					} else {
						position = sourceBuilder.getPosition(sourceNode, offset, false);
					}
					break;
				}
			}
		}
		return position;
	}
	
	private Point getSourceSelectionRangeAtVisualNode(nsIDOMNode visualInitNode, int visualInitOffset) {
		if (visualInitNode.getNodeType() == Node.TEXT_NODE) {
			Node sourceNode = domMapping.getSourceNode(visualInitNode);
			if (sourceNode == null) {
				sourceNode = domMapping.getNearSourceNode(visualInitNode);
				if (sourceNode != null && sourceNode.getNodeType() == Node.ELEMENT_NODE) {
					Point outputAttributesPositions = sourceBuilder.getOutputAttributesPositions((Element)sourceNode);
					if (outputAttributesPositions != null) {
						return new Point(outputAttributesPositions.x, outputAttributesPositions.y - outputAttributesPositions.x);
					}
				}
			}
		}
		Point range = sourceBuilder.getSelectionRange();
		int pos = getSourcePosition(visualInitNode, visualInitOffset);
		if (pos >= range.x && pos <= range.x + range.y) {
			return range;
		} else {
			return new Point(pos, 0);
		}
	}

	
	void setVisualElementSelection(nsIDOMMouseEvent mouseEvent) {
		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
		nsIDOMNode visualNode = visualBuilder.getOriginalTargetNode(mouseEvent);
		if (selection.containsNode(visualNode, false) || VpeVisualDomBuilder.isAnonElement(visualNode)) {
			return;
		}
		if (!selection.containsNode((nsIDOMNode)visualNode, false)) {
			if (visualNode.getNodeType() == Node.ELEMENT_NODE && !VpeVisualDomBuilder.isAnonElement(visualNode)) {
				nsIDOMNode visualParent = visualNode.getParentNode();
				long offset = VisualDomUtil.getOffset(visualNode);
				selection.removeAllRanges();
				selection.collapse(visualParent, (int)offset);
				selection.extend(visualParent, (int)offset + 1);
				setSelection(selection);
			}
		}

	}

//this method is never used
//	nsIDOMElement getDragElement(nsIDOMMouseEvent mouseEvent) {
//		nsIDOMElement dragElement = visualBuilder.getDragElement(mouseEvent);
//		if (dragElement != null) {
//			return dragElement;
//		}
//
//		nsIDOMNode visualNode = VisualDomUtil.getTargetNode(mouseEvent);
//		//FIX FOR JBIDE-1468 added by Sergey Dzmitrovich
//		if (visualNode != null
//				&& visualNode.getNodeType() == Node.ELEMENT_NODE
//				&& (HTML.TAG_INPUT.equalsIgnoreCase(visualNode.getNodeName())
//						|| HTML.TAG_OPTION.equalsIgnoreCase(visualNode
//								.getNodeName())
//						|| HTML.TAG_BUTTON.equalsIgnoreCase(visualNode
//								.getNodeName()) || HTML.TAG_SELECT
//						.equalsIgnoreCase(visualNode.getNodeName()))
//				/*&& !selection.containsNode(visualNode, false)*/
//				&& visualBuilder.canInnerDrag((nsIDOMElement) visualNode
//						.queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID))) {
//			return (nsIDOMElement) visualNode
//					.queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID);
//		}
//		return null;
//	}
	
	nsIDOMElement getAppropriateElementForSelection(nsIDOMEvent event) {
		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
		nsIDOMNode visualNode = VisualDomUtil.getTargetNode(event);
		if (visualNode != null) { 
			if (!HTML.TAG_INPUT.equalsIgnoreCase(visualNode.getNodeName())) {
				visualNode = visualBuilder.getOriginalTargetNode(event);
			}
			if (visualNode != null && visualNode.getNodeType() == Node.ELEMENT_NODE && !selection.containsNode((nsIDOMNode)visualNode, false)) {
				VpeElementMapping elementMapping = domMapping.getNearElementMapping(visualNode);
				if (elementMapping != null) {
					return elementMapping.getVisualElement();
				}
			}
		}
		return null;
	}
	
	void setVisualElementSelection(nsIDOMElement visualElement) {
		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
		visualElement.removeAttribute(XulRunnerEditor.VPE_INVISIBLE_ELEMENT);
		nsIDOMNode visualParent = visualElement.getParentNode();
		int offset = (int) VisualDomUtil.getOffset(visualElement);
		selection.removeAllRanges();
		selection.collapse(visualParent, offset);
		selection.extend(visualParent, offset + 1);
		
		setSelection(selection);
	}
	
	void setMouseUpSelection(nsIDOMMouseEvent mouseEvent) {
	}
	
	void printVisualSelection() {
		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
		boolean collapsed = selection.getIsCollapsed();
		System.out.println("  ## VisualSelection"); //$NON-NLS-1$
		System.out.println("  ## collapsed: " + collapsed); //$NON-NLS-1$
		if (!collapsed) {
			nsIDOMNode anchorNode = selection.getAnchorNode();
			if (anchorNode != null) {
				System.out.println("  ## anchorNode: " + anchorNode.getNodeName() + " (" + anchorNode + ")  offset: " + selection.getAnchorOffset()); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			} else {
				System.out.println("  ## anchorNode: null"); //$NON-NLS-1$
			}
		}
		nsIDOMNode focusNode = selection.getFocusNode();
		if (focusNode != null) {
			System.out.println("  ## focusNode: " + focusNode.getNodeName() + " (" + focusNode + ")  offset: " + selection.getFocusOffset()); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} else {
			System.out.println("  ## focusNode: null"); //$NON-NLS-1$
		}
	}
	
// this method is never used
//	void setCaretAtMouse(nsIDOMMouseEvent mouseEvent) {
//		nsIDOMNode visualNode = VisualDomUtil.getTargetNode(mouseEvent);
//		boolean isAnonElement = VpeVisualDomBuilder.isAnonElement(visualNode);
//		if (isAnonElement) return;
//		VpeVisualInnerDropInfo visualDropInfo = getInnerDropInfo(mouseEvent);
//		nsIDOMNode visuaDropContainer = visualDropInfo.getDropContainer();
//		if (visuaDropContainer.getNodeType() == Node.TEXT_NODE) return;
//		int visualDropOffset = (int)visualDropInfo.getDropOffset();
//		if (visualDropOffset > 0) {
//			nsIDOMNodeList visualChildren = visuaDropContainer.getChildNodes();
//			nsIDOMNode visualChild = visualChildren.item(visualDropOffset - 1);
//			boolean isText = visualChild.getNodeType() == Node.TEXT_NODE;
//			if (isText) return;
//		}
//		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
//		if (!VisualDomUtil.isSelectionContains(selection, visuaDropContainer, visualDropOffset)) {
//			setVisualCaret(visuaDropContainer, visualDropOffset);
//			// TODO Sergey Vasilyev figure out with nsIFrameSelection
////			nsIFrameSelection frameSelection = presShell.getFrameSelection();
////			if (frameSelection != null) {
////				frameSelection.setMouseDownState(true);
////			}
//			
//			// was commented by Max Areshkau (with this  code scrolling doesn't works)
//			// 
////			mouseEvent.preventDefault();
////			mouseEvent.stopPropagation();
//		}
//	}
	
	void setVisualCaret(nsIDOMNode visualNode, int offset) {
		nsISelection selection = visualSelectionController.getSelection(nsISelectionController.SELECTION_NORMAL);
		if (visualNode != null) {
			if (visualNode.getNodeType() == Node.TEXT_NODE && offset > visualNode.getNodeValue().length()) {
				offset = visualNode.getNodeValue().length();
			}
			selection.collapse(visualNode, offset);
		} else {
			selection.removeAllRanges();
		}
		visualSelectionController.setCaretEnabled(true);
		setSelection(selection);
	}
}
