/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.rulesets.vo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.eclipse.core.rulesets.vo.RuleSet;

public class RuleSets {
    private RuleSet defaultRuleSet;
    private List ruleSetsList = new ArrayList();

    public RuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    public void setDefaultRuleSet(RuleSet ruleSet) {
        if (ruleSet == null) {
            throw new IllegalArgumentException("default rule set cannot be null");
        }
        if (!this.ruleSetsList.contains(ruleSet)) {
            throw new IllegalArgumentException("The rule set " + ruleSet.getName() + " must belong to the rule set list to be set as default.");
        }
        this.defaultRuleSet = ruleSet;
    }

    public List getRuleSets() {
        return this.ruleSetsList;
    }

    public void setRuleSets(List list) {
        if (list == null) {
            throw new IllegalArgumentException("ruleSets cannot be null");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("The rule sets list should not be empty");
        }
        this.ruleSetsList = list;
    }

    public String getDefaultRuleSetName() {
        return this.defaultRuleSet.getName();
    }

    public void setDefaultRuleSetName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The default ruleset name must not ne null");
        }
        Iterator iterator = this.ruleSetsList.iterator();
        while (iterator.hasNext()) {
            RuleSet ruleSet = (RuleSet)iterator.next();
            if (!ruleSet.getName().equals(string)) continue;
            this.setDefaultRuleSet(ruleSet);
            break;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RuleSets defaultRuleSet=");
        stringBuffer.append(this.defaultRuleSet.getName());
        stringBuffer.append(" ruleSetsList=");
        Iterator iterator = this.ruleSetsList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }
}

