/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveAction;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveType;
import org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackage;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackages;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;

public class ArchiveImpl
extends ArchiveNodeImpl
implements IArchive {
    private XbPackage packageDelegate;

    public ArchiveImpl() {
        this(new XbPackage());
    }

    public ArchiveImpl(XbPackage delegate) {
        super(delegate);
        this.packageDelegate = delegate;
    }

    public int getNodeType() {
        return 0;
    }

    public boolean isDestinationInWorkspace() {
        return this.packageDelegate.isInWorkspace();
    }

    public String getRawDestinationPath() {
        if (!this.isTopLevel()) {
            return "";
        }
        return this.packageDelegate.getToDir() == null ? "" : this.packageDelegate.getToDir();
    }

    public IPath getArchiveFilePath() {
        IPath p = PathUtils.getGlobalLocation(this);
        return p == null ? null : p.append(this.getName());
    }

    public IArchiveFileSet[] getFileSets() {
        IArchiveNode[] nodes = this.getChildren(2);
        IArchiveFileSet[] filesets = new IArchiveFileSet[nodes.length];
        System.arraycopy(nodes, 0, filesets, 0, nodes.length);
        return filesets;
    }

    public IArchiveFolder[] getFolders() {
        IArchiveNode[] nodes = this.getChildren(3);
        IArchiveFolder[] folders = new IArchiveFolder[nodes.length];
        System.arraycopy(nodes, 0, folders, 0, nodes.length);
        return folders;
    }

    public IArchive[] getArchives() {
        IArchiveNode[] nodes = this.getChildren(0);
        IArchive[] pkgs = new IArchive[nodes.length];
        System.arraycopy(nodes, 0, pkgs, 0, nodes.length);
        return pkgs;
    }

    public IArchiveAction[] getActions() {
        IArchiveNode[] nodes = this.getChildren(4);
        IArchiveAction[] actions = new IArchiveAction[nodes.length];
        System.arraycopy(nodes, 0, actions, 0, nodes.length);
        return actions;
    }

    public IArchiveAction[] getPreActions() {
        return new IArchiveAction[0];
    }

    public IArchiveAction[] getPostActions() {
        return new IArchiveAction[0];
    }

    public String getName() {
        return this.packageDelegate.getName();
    }

    public IArchiveType getArchiveType() {
        return ArchivesCore.getInstance().getExtensionManager().getArchiveType(this.packageDelegate.getPackageType());
    }

    public boolean isExploded() {
        return this.packageDelegate.isExploded();
    }

    public boolean isTopLevel() {
        return this.packageDelegate.getParent() == null || this.packageDelegate.getParent() instanceof XbPackages;
    }

    public void setDestinationPath(IPath path) {
        String destPath = this.getRawDestinationPath();
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackage.destination", destPath == null ? null : destPath.toString(), path == null ? null : path.toString());
        this.packageDelegate.setToDir(path == null ? null : path.toString());
    }

    public void setInWorkspace(boolean inWorkspace) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackage.inWorkspace", new Boolean(this.isDestinationInWorkspace()), new Boolean(inWorkspace));
        this.packageDelegate.setInWorkspace(inWorkspace);
    }

    public void setExploded(boolean exploded) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackage.exploded", new Boolean(this.isExploded()), new Boolean(exploded));
        this.packageDelegate.setExploded(exploded);
    }

    public void setName(String name) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNodename", this.getName(), name);
        this.packageDelegate.setName(name);
    }

    public void setArchiveType(IArchiveType type) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackage.packageType", this.getArchiveTypeId(), type == null ? null : type.getId());
        this.packageDelegate.setPackageType(type.getId());
    }

    public void setArchiveType(String type) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackage.packageType", this.getArchiveTypeId(), type);
        this.packageDelegate.setPackageType(type);
    }

    public String toString() {
        return this.getName();
    }

    public String getArchiveTypeId() {
        return this.packageDelegate.getPackageType();
    }

    public IPath getRootArchiveRelativePath() {
        if (this.getParent() == null || this.getParent().getRootArchiveRelativePath() == null) {
            return new Path(this.getName());
        }
        return this.getParent().getRootArchiveRelativePath().append(this.getName());
    }

    public boolean validateModel() {
        ArrayList<String> list = new ArrayList<String>();
        IArchiveNode[] children = this.getAllChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof INamedContainerArchiveNode) {
                if (list.contains(((INamedContainerArchiveNode)children[i]).getName())) {
                    return false;
                }
                list.add(((INamedContainerArchiveNode)children[i]).getName());
            }
            ++i;
        }
        return super.validateModel();
    }

    public boolean canBuild() {
        return PathUtils.getGlobalLocation(this) != null && super.canBuild();
    }
}

