/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IMemento;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public class Memento
implements IMemento {
    private static final String MEMENTO = "M";
    private static final String DIVIDER = ":";
    private static final String LINE = "|";
    private static final String ARRAY = "A";
    private static final String FLOAT = "F";
    private static final String INTEGER = "I";
    private static final String STRING = "S";
    private String id;
    private HashMap map = new HashMap();
    private final String type;
    private static final String TEXT_DATA = "org.jboss.tools.common.model.ui.forms.Memento.textData.id";

    private Memento() {
        this.type = null;
    }

    public Memento(String type, String id) {
        ModelUIPlugin.getPluginLog().logInfo("new Memento(" + id + ")");
        this.id = id;
        this.type = type;
    }

    public IMemento createChild(String type) {
        return this.createChild(type, type);
    }

    public IMemento createChild(String type, String id) {
        Memento newMemento = new Memento(type, id);
        ArrayList<Memento> list = (ArrayList<Memento>)this.map.get(type);
        if (list == null) {
            list = new ArrayList<Memento>();
            this.map.put(type, list);
        }
        list.add(newMemento);
        return newMemento;
    }

    public IMemento getChild(String type) {
        ArrayList list = (ArrayList)this.map.get(type);
        if (list != null && list.size() > 0) {
            return (IMemento)list.get(0);
        }
        return null;
    }

    public IMemento[] getChildren(String type) {
        ArrayList list = (ArrayList)this.map.get(type);
        if (list != null) {
            return list.toArray(new IMemento[list.size()]);
        }
        return new IMemento[0];
    }

    public Float getFloat(String key) {
        return (Float)this.map.get(key);
    }

    public String getID() {
        return this.id;
    }

    public Integer getInteger(String key) {
        return (Integer)this.map.get(key);
    }

    public String getString(String key) {
        return (String)this.map.get(key);
    }

    public String getTextData() {
        return (String)this.map.get(TEXT_DATA);
    }

    public void putFloat(String key, float value) {
        this.map.put(key, new Float(value));
    }

    public void putInteger(String key, int value) {
        this.map.put(key, value);
    }

    public void putMemento(IMemento memento) {
        if (memento != null) {
            this.map.put(memento.getID(), memento);
        }
    }

    public void putString(String key, String value) {
        this.map.put(key, value);
    }

    public void putTextData(String data) {
        this.map.put(TEXT_DATA, data);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " id=" + this.id;
    }

    public String stringify() {
        StringBuffer sb = new StringBuffer();
        sb.append(MEMENTO);
        sb.append(DIVIDER);
        sb.append(this.id);
        sb.append(LINE);
        Set keys = this.map.keySet();
        for (String key : keys) {
            Object value = this.map.get(key);
            if (value instanceof Integer) {
                sb.append(INTEGER);
                sb.append(DIVIDER);
                sb.append(key);
                sb.append(DIVIDER);
                sb.append((Integer)value);
                continue;
            }
            if (value instanceof String) {
                sb.append(STRING);
                sb.append(DIVIDER);
                sb.append(key);
                sb.append(DIVIDER);
                sb.append((String)value);
                continue;
            }
            if (value instanceof ArrayList) {
                sb.append(ARRAY);
                sb.append(DIVIDER);
                sb.append(key);
                sb.append(DIVIDER);
                ArrayList list = (ArrayList)value;
                for (Memento children : list) {
                    sb.append(children.stringify());
                }
                continue;
            }
            if (!(value instanceof Float)) continue;
            sb.append(FLOAT);
            sb.append(DIVIDER);
            sb.append(key);
            sb.append(DIVIDER);
            sb.append(((Float)value).doubleValue());
        }
        return sb.toString();
    }

    public void load(IResource resource) {
    }

    public void store(IResource resource) {
    }

    public String[] getAttributeKeys() {
        return this.map.keySet().toArray(new String[0]);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.map.get(key);
    }

    public void putBoolean(String key, boolean value) {
        this.map.put(key, value);
    }

    public String getType() {
        return this.type;
    }
}

