/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.reporting.ProblemReporter;
import org.jboss.tools.common.model.ui.reporting.ReportPreference;
import org.jboss.tools.common.reporting.ProblemReportingHelper;

public class ErrorDialog
extends IconAndMessageDialog {
    private Control dropDown;
    private Throwable exception;
    private Button detailsButton;
    private Button getAwayButton;
    private String title;
    protected static final int TEXT_HEIGHT = 200;
    private boolean dropDownCreated = false;
    private String problemText;
    Text text;

    public ErrorDialog(Shell shell, String title, String message, Throwable exception) {
        super(shell);
        this.setShellStyle(67696);
        this.exception = exception;
        this.title = title;
        this.message = message;
    }

    public ErrorDialog(Shell shell, String title, Throwable exception) {
        super(shell);
        this.setShellStyle(67696);
        this.exception = exception;
        this.message = exception.getMessage();
        this.title = title;
    }

    protected static boolean shouldDisplay(IStatus status, int mask) {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Submit", false);
        if (this.exception != null) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
            this.createButton(parent, 1, "Cancel", false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        this.getAwayButton = new Button(parent, 32);
        this.getAwayButton.setSelection(false);
        this.getAwayButton.setText("Do not show this dialog again");
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.getAwayButton.setLayoutData((Object)data);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createLayout());
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    GridLayout createLayout() {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = this.convertVerticalDLUsToPixels(7);
        gl.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gl.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gl.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        return gl;
    }

    protected Control createDropDownControl(Composite parent) {
        this.text = new Text(parent, 2818);
        this.text.setText(this.problemText == null || this.problemText.trim().length() == 0 ? this.createProblemText() : this.problemText);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.horizontalSpan = 2;
        this.text.setLayoutData((Object)data);
        this.text.setFont(parent.getFont());
        this.dropDownCreated = true;
        return this.text;
    }

    private String createProblemText() {
        String problem = this.exception == null ? "" : ProblemReporter.throwableToString(this.message, this.exception);
        return this.wrapProblem(problem);
    }

    private String wrapProblem(String problem) {
        StringBuffer sb = new StringBuffer();
        sb.append("------Type your additional comment here--------\n\n");
        sb.append("-----------------------------------------------\n");
        sb.append(problem);
        return sb.toString();
    }

    private String getEnvironment() {
        return CommonPlugin.getEnvironment();
    }

    protected void buttonPressed(int id) {
        if (this.text == null || this.text.isDisposed()) {
            if (this.problemText == null) {
                this.problemText = this.createProblemText();
            }
        } else {
            this.problemText = this.text.getText();
        }
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void okPressed() {
        if (this.getAwayButton.getSelection()) {
            try {
                ReportPreference.SHOW_ERROR_DIALOG_OPTION.setValue("no");
                ReportPreference.SUBMIT_AUTOMATICALLY_OPTION.setValue("yes");
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        super.okPressed();
        this.submit();
    }

    protected void cancelPressed() {
        if (this.getAwayButton.getSelection()) {
            try {
                ReportPreference.SHOW_ERROR_DIALOG_OPTION.setValue("no");
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        super.cancelPressed();
    }

    protected void submit() {
        String email = ReportPreference.E_MAIL_OPTION.getValue();
        String other = ReportPreference.OTHER_OPTION.getValue();
        String text = this.getEnvironment() + "\n" + this.problemText;
        ProblemReportingHelper.buffer.report(text, email, other, false);
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.dropDownCreated) {
            this.dropDown.dispose();
            this.dropDownCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.dropDown = this.createDropDownControl((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    public static int openError(Shell shell, Throwable exception) {
        ErrorDialog dialog = new ErrorDialog(shell, WizardKeys.getString((String)"ErrorDialog.DefaultWindowTitle"), exception);
        return dialog.open();
    }

    public static int openError(Shell shell, String title, String message, Throwable t) {
        return new ErrorDialog(shell, title, message, t).open();
    }

    public static int openError(Shell shell, String title, String message) {
        ErrorDialog dialog = new ErrorDialog(shell, title, message, null);
        return dialog.open();
    }

    public static int openError(Shell shell, String message) {
        ErrorDialog dialog = new ErrorDialog(shell, WizardKeys.getString((String)"ErrorDialog.DefaultWindowTitle"), message, null);
        return dialog.open();
    }

    protected Image getImage() {
        return Display.getDefault().getSystemImage(1);
    }
}

