/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.outline;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.jboss.ide.eclipse.freemarker.Messages;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.ContextValue;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.model.Interpolation;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.outline.OutlineContentProvider;
import org.jboss.ide.eclipse.freemarker.outline.OutlineLabelProvider;

public class OutlinePage
extends ContentOutlinePage
implements IDoubleClickListener {
    private Editor fEditor;
    private Object fInput;
    private OutlineLabelProvider fLabelProvider;
    private ItemSet selectedItemSet;
    private Item selectedItem;

    public OutlinePage(Editor anEditor) {
        this.fEditor = anEditor;
    }

    public void createControl(Composite aParent) {
        super.createControl(aParent);
        this.fLabelProvider = new OutlineLabelProvider();
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new OutlineContentProvider(this.fEditor));
        viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.addDoubleClickListener((IDoubleClickListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
        this.update(null);
    }

    public void setInput(Object aInput) {
        this.fInput = aInput;
        this.update(null);
    }

    public void update(Item item) {
        if (item == null && this.selectedItem != null || this.selectedItem == null && item != null || item != null && this.selectedItem != null && !item.equals(this.selectedItem)) {
            if (this.selectedItemSet == null || !this.fEditor.getItemSet().equals(this.selectedItemSet)) {
                Control control;
                TreeViewer viewer = this.getTreeViewer();
                if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
                    viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                    control.setRedraw(false);
                    viewer.setInput(this.fInput);
                    control.setRedraw(true);
                    viewer.expandToLevel(3);
                }
                this.selectedItemSet = this.fEditor.getItemSet();
            }
            this.select(item);
        }
        this.selectedItem = item;
        this.selectedItemSet = this.fEditor.getItemSet();
    }

    public void select(Item item) {
        if (item != null && item.isEndItem()) {
            item = item.getStartItem();
        }
        if (this.getTreeViewer() != null) {
            if (item == null) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection(new Object[0]), true);
            } else {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)item), true);
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Item item = (Item)selection.getFirstElement();
        if (item != null) {
            this.fEditor.select(item);
        }
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.getTreeViewer().getTree());
        menuMgr.add((IAction)new SetContextEntryAction(this));
        this.getTreeViewer().getTree().setMenu(menu);
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
    }

    public class SetContextEntryAction
    extends Action {
        private OutlinePage outlinePage;

        public SetContextEntryAction(OutlinePage outlinePage2) {
            this.outlinePage = outlinePage2;
            this.setText(Messages.OutlinePage_SetContextClassEntryAction);
            this.setEnabled(true);
        }

        public void runWithEvent(Event event) {
            Tree tree = OutlinePage.this.getTreeViewer().getTree();
            TreeItem[] items = tree.getSelection();
            Interpolation interpolation = null;
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (item.getData() instanceof Interpolation) {
                    interpolation = (Interpolation)item.getData();
                    try {
                        SelectionDialog sd = JavaUI.createTypeDialog((Shell)new Shell(), null, (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)512, (boolean)false);
                        sd.open();
                        Object[] objects = sd.getResult();
                        if (objects != null && objects.length > 0) {
                            ConfigurationManager configuration = ConfigurationManager.getInstance(interpolation.getResource().getProject());
                            IType type = (IType)objects[0];
                            try {
                                configuration.addContextValue(new ContextValue(interpolation.getFirstToken(), configuration.getClass(type.getFullyQualifiedName()), null), interpolation.getResource());
                            }
                            catch (ClassNotFoundException e) {
                                Plugin.log(e);
                            }
                        }
                    }
                    catch (JavaModelException jme) {
                        Plugin.error(jme);
                    }
                }
                ++i;
            }
        }
    }
}

