/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.model.IReverseEngineeringDefinition;
import org.hibernate.eclipse.console.model.ITableFilter;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchema;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.hibernate.eclipse.mapper.MapperPlugin;
import org.hibernate.eclipse.mapper.editors.ChooseConsoleConfigurationDialog;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngOverviewPage;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngTableFilterPage;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngTablesPage;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngTypeMappingPage;
import org.hibernate.eclipse.mapper.editors.xpl.XMLFormEditorPart;
import org.hibernate.eclipse.mapper.model.DOMReverseEngineeringDefinition;
import org.hibernate.eclipse.nature.HibernateNature;
import org.hibernate.util.StringHelper;
import org.w3c.dom.Document;

public class ReverseEngineeringEditor
extends XMLFormEditorPart {
    private StructuredTextEditor sourcePage;
    private DOMReverseEngineeringDefinition definition;
    private RevEngTableFilterPage tableFilterPage;
    private RevEngTypeMappingPage typeMappingsPage;
    private RevEngOverviewPage overviewsPage;
    private Map pageNameToIndex = new HashMap();
    private RevEngTablesPage tableProperties;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    protected void addPages() {
        try {
            super.addPages();
            this.initSourcePage();
            this.addFormPages();
        }
        catch (PartInitException e) {
            MapperPlugin.getDefault().getLogger().logException(MapperMessages.ReverseEngineeringEditor_could_not_create_graphical_viewer, (Throwable)e);
        }
    }

    private void addFormPages() throws PartInitException {
        int i = 0;
        this.overviewsPage = new RevEngOverviewPage(this);
        this.addPage(i, (IFormPage)this.overviewsPage);
        this.setPageText(i, MapperMessages.ReverseEngineeringEditor_overview);
        this.pageNameToIndex.put("overview", new Integer(i));
        this.typeMappingsPage = new RevEngTypeMappingPage(this);
        this.addPage(++i, (IFormPage)this.typeMappingsPage);
        this.setPageText(i, MapperMessages.ReverseEngineeringEditor_type_mappings);
        this.pageNameToIndex.put("typemappings", new Integer(i));
        this.tableFilterPage = new RevEngTableFilterPage(this);
        this.addPage(++i, (IFormPage)this.tableFilterPage);
        this.setPageText(i, MapperMessages.ReverseEngineeringEditor_table_filters);
        this.pageNameToIndex.put("tablefilter", new Integer(i));
        this.tableProperties = new RevEngTablesPage(this);
        this.addPage(++i, (IFormPage)this.tableProperties);
        this.setPageText(i, MapperMessages.ReverseEngineeringEditor_table_column);
        this.pageNameToIndex.put("tables", new Integer(i));
        ++i;
        int activePageIndex = this.getPreferenceStore().getInt("lastActivePage");
        this.setActivePage(0);
        if (activePageIndex >= 0 && activePageIndex < this.getPageCount()) {
            this.setActivePage(activePageIndex);
        }
    }

    private void initSourcePage() {
        int pageCount = this.getPageCount();
        int i = 0;
        while (i < pageCount) {
            if (this.getEditor(i) instanceof StructuredTextEditor) {
                this.sourcePage = (StructuredTextEditor)this.getEditor(i);
                IDOMDocument document = this.getDocument(this.sourcePage);
                this.definition = new DOMReverseEngineeringDefinition(document);
            }
            ++i;
        }
    }

    private IDOMDocument getDocument(StructuredTextEditor source) {
        IDOMDocument document = (IDOMDocument)source.getAdapter(Document.class);
        return document;
    }

    protected void pageChange(int newPageIndex) {
        IKeyBindingService service;
        if (newPageIndex == 0 && (service = this.getSite().getKeyBindingService()) instanceof INestableKeyBindingService) {
            INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
            nestableService.activateKeyBindingService(null);
        }
        this.saveLastActivePageIndex(newPageIndex);
        super.pageChange(newPageIndex);
    }

    public IReverseEngineeringDefinition getReverseEngineeringDefinition() {
        return this.definition;
    }

    public String getConsoleConfigurationName() {
        return this.overviewsPage.getConsoleConfigName();
    }

    protected void setConsoleConfigurationName(String name) {
        this.overviewsPage.setConsoleConfigName(name);
    }

    public HibernateNature getHibernateNature() throws CoreException {
        if (this.getEditorInput() != null) {
            IJavaProject project = ProjectUtils.findJavaProject((IEditorInput)this.getEditorInput());
            return HibernateNature.getHibernateNature((IJavaProject)project);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LazyDatabaseSchema getLazyDatabaseSchema() {
        try {
            ConsoleConfiguration configuration = KnownConfigurations.getInstance().find(this.getConsoleConfigurationName());
            if (configuration == null) {
                configuration = this.askForConsoleConfiguration();
                if (configuration == null) {
                    return null;
                }
                this.setConsoleConfigurationName(configuration.getName());
            }
            ITableFilter[] tableFilters = this.getReverseEngineeringDefinition().getTableFilters();
            Configuration cfg = configuration.buildWith(null, false);
            configuration.getSettings(cfg);
            OverrideRepository repository = new OverrideRepository();
            int i = 0;
            while (true) {
                if (i >= tableFilters.length) {
                    TableFilter tf = new TableFilter();
                    tf.setExclude(Boolean.FALSE);
                    tf.setMatchCatalog(".*");
                    tf.setMatchSchema(".*");
                    tf.setMatchName(".*");
                    repository.addTableFilter(tf);
                    if (tableFilters.length != 0) return new LazyDatabaseSchema(configuration, repository.getReverseEngineeringStrategy((ReverseEngineeringStrategy)new DefaultReverseEngineeringStrategy()));
                    boolean b = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)MapperMessages.ReverseEngineeringEditor_no_filters_defined, (String)MapperMessages.ReverseEngineeringEditor_no_filters_has_been_defined);
                    if (b) return new LazyDatabaseSchema(configuration, repository.getReverseEngineeringStrategy((ReverseEngineeringStrategy)new DefaultReverseEngineeringStrategy()));
                    return null;
                }
                ITableFilter filter = tableFilters[i];
                TableFilter tf = new TableFilter();
                tf.setExclude(filter.getExclude());
                if (filter.getExclude() == null || !filter.getExclude().booleanValue()) {
                    // empty if block
                }
                tf.setMatchCatalog(filter.getMatchCatalog());
                tf.setMatchName(filter.getMatchName());
                tf.setMatchSchema(filter.getMatchSchema());
                repository.addTableFilter(tf);
                ++i;
            }
        }
        catch (HibernateException he) {
            HibernateConsolePlugin.getDefault().showError(this.getContainer().getShell(), MapperMessages.ReverseEngineeringEditor_error_while_refreshing_databasetree, (Throwable)he);
            return null;
        }
    }

    private ConsoleConfiguration askForConsoleConfiguration() {
        ChooseConsoleConfigurationDialog dialog = new ChooseConsoleConfigurationDialog(this.getContainer().getShell(), "");
        dialog.prompt();
        if (StringHelper.isEmpty((String)dialog.getSelectedConfigurationName())) {
            return null;
        }
        return KnownConfigurations.getInstance().find(dialog.getSelectedConfigurationName());
    }

    private void saveLastActivePageIndex(int newPageIndex) {
        this.getPreferenceStore().setValue("lastActivePage", newPageIndex);
    }

    private IPreferenceStore getPreferenceStore() {
        return MapperPlugin.getDefault().getPreferenceStore();
    }
}

