/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ValueVisitor;

public class TypeNameValueVisitor
implements ValueVisitor {
    final boolean dequalify;

    public TypeNameValueVisitor(boolean dequalify) {
        this.dequalify = dequalify;
    }

    public Object accept(Bag bag) {
        return "Bag <" + bag.getElement().accept((ValueVisitor)this) + ">";
    }

    public Object accept(IdentifierBag bag) {
        return "IdBag <" + bag.getElement().accept((ValueVisitor)this) + ">";
    }

    public Object accept(List list) {
        return "List <" + list.getElement().accept((ValueVisitor)this) + ">";
    }

    public Object accept(PrimitiveArray primitiveArray) {
        return primitiveArray.getElement().accept((ValueVisitor)this) + "[]";
    }

    public Object accept(Array list) {
        return list.getElement().accept((ValueVisitor)this) + "[]";
    }

    public Object accept(Map map) {
        return "Map<" + map.getElement().accept((ValueVisitor)this) + ">";
    }

    public Object accept(OneToMany many) {
        return this.dequalify(many.getReferencedEntityName());
    }

    private String dequalify(String referencedEntityName) {
        if (this.dequalify && referencedEntityName != null && referencedEntityName.indexOf(".") >= 0) {
            return referencedEntityName.substring(referencedEntityName.lastIndexOf(46) + 1);
        }
        return referencedEntityName;
    }

    public Object accept(Set set) {
        return "Set<" + set.getElement().accept((ValueVisitor)this) + ">";
    }

    public Object accept(Any any) {
        return "Any";
    }

    public Object accept(SimpleValue value) {
        return this.dequalify(value.getTypeName());
    }

    public Object accept(DependantValue value) {
        return null;
    }

    public Object accept(Component component) {
        return this.dequalify(component.getComponentClassName());
    }

    public Object accept(ManyToOne mto) {
        return this.dequalify(mto.getReferencedEntityName());
    }

    public Object accept(OneToOne oto) {
        return this.dequalify(oto.getEntityName());
    }
}

