/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Event;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.QueryEditor;
import org.hibernate.eclipse.console.utils.EclipseImages;

public class ExecuteQueryAction
extends Action {
    private QueryEditor editor;

    public ExecuteQueryAction() {
        this.setImageDescriptor(EclipseImages.getImageDescriptor("EXECUTE"));
        this.initTextAndToolTip(HibernateConsoleMessages.ExecuteQueryAction_run_default);
    }

    public ExecuteQueryAction(QueryEditor editor) {
        this();
        this.setHibernateQueryEditor(editor);
    }

    public void run() {
        this.execute(this.editor);
    }

    public void runWithEvent(Event event) {
        super.runWithEvent(event);
    }

    protected void execute(QueryEditor queryEditor) {
        ConsoleConfiguration cfg = queryEditor.getConsoleConfiguration();
        if (cfg != null) {
            if (!cfg.isSessionFactoryCreated()) {
                if (queryEditor.askUserForConfiguration(cfg.getName())) {
                    if (cfg.getConfiguration() == null) {
                        try {
                            cfg.build();
                        }
                        catch (HibernateException he) {
                            HibernateConsolePlugin.getDefault().showError(HibernateConsolePlugin.getShell(), String.valueOf(HibernateConsoleMessages.LoadConsoleCFGCompletionProposal_could_not_load_configuration) + ' ' + cfg.getName(), he);
                        }
                    }
                    if (cfg.getConfiguration() != null) {
                        cfg.buildSessionFactory();
                        queryEditor.executeQuery(cfg);
                    }
                }
            } else {
                queryEditor.executeQuery(cfg);
            }
        }
    }

    public void initTextAndToolTip(String text) {
        this.setText(text);
        this.setToolTipText(text);
    }

    public void run(IAction action) {
        this.run();
    }

    public void setHibernateQueryEditor(QueryEditor editor) {
        this.editor = editor;
    }
}

