/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.HashSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.ConsoleConfigurationListener;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.KnownConfigurationsListener;
import org.hibernate.console.QueryPage;
import org.hibernate.eclipse.console.actions.ConsoleConfigurationBasedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConsoleConfigReadyUseBaseAction
extends ConsoleConfigurationBasedAction
implements ConsoleConfigurationListener,
KnownConfigurationsListener {
    protected StructuredViewer viewer;
    private HashSet<ConsoleConfiguration> vecMonitorConsoleConfigs = new HashSet();

    protected ConsoleConfigReadyUseBaseAction(String text) {
        super(text);
    }

    public void init(StructuredViewer viewer) {
        this.viewer = viewer;
        KnownConfigurations.getInstance().addConsoleConfigurationListener((KnownConfigurationsListener)this);
    }

    private HashSet<ConsoleConfiguration> cloneMonitorConsoleConfigs() {
        return (HashSet)this.vecMonitorConsoleConfigs.clone();
    }

    protected void clearCache() {
        IStructuredSelection selection = this.getStructuredSelection();
        HashSet<ConsoleConfiguration> vecMonitorConsoleConfigsTmp = this.cloneMonitorConsoleConfigs();
        for (ConsoleConfiguration consoleConfig : vecMonitorConsoleConfigsTmp) {
            consoleConfig.removeConsoleConfigurationListener((ConsoleConfigurationListener)this);
        }
        vecMonitorConsoleConfigsTmp.clear();
        for (Object obj : selection) {
            if (!(obj instanceof ConsoleConfiguration)) continue;
            ConsoleConfiguration consoleConfig = (ConsoleConfiguration)obj;
            vecMonitorConsoleConfigsTmp.add(consoleConfig);
            consoleConfig.addConsoleConfigurationListener((ConsoleConfigurationListener)this);
        }
        this.vecMonitorConsoleConfigs = vecMonitorConsoleConfigsTmp;
        super.clearCache();
    }

    @Override
    protected boolean updateState(ConsoleConfiguration ccfg) {
        return ccfg.hasConfiguration();
    }

    public void updateEnableState() {
        this.selectionChanged(this.getStructuredSelection());
    }

    public void queryPageCreated(QueryPage qp) {
    }

    public void sessionFactoryBuilt(ConsoleConfiguration ccfg, SessionFactory builtSessionFactory) {
    }

    public void sessionFactoryClosing(ConsoleConfiguration ccfg, SessionFactory aboutToCloseFactory) {
    }

    public void configurationBuilt(ConsoleConfiguration ccfg) {
        this.updateEnableState();
    }

    public void configurationReset(ConsoleConfiguration ccfg) {
        this.updateEnableState();
    }

    public void configurationAdded(ConsoleConfiguration root) {
    }

    public void configurationRemoved(ConsoleConfiguration ccfg, boolean forUpdate) {
        if (this.vecMonitorConsoleConfigs.remove(ccfg)) {
            ccfg.removeConsoleConfigurationListener((ConsoleConfigurationListener)this);
        }
    }
}

