/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.ZipFileCodeBase;
import edu.umd.cs.findbugs.classfile.impl.ZipInputStreamCodeBase;
import edu.umd.cs.findbugs.log.Profiler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipCodeBaseFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractScannableCodeBase makeZipCodeBase(ICodeBaseLocator codeBaseLocator, File file) throws IOException {
        Profiler profiler = Global.getAnalysisCache().getProfiler();
        profiler.start(ZipCodeBaseFactory.class);
        try {
            AbstractScannableCodeBase abstractScannableCodeBase = ZipCodeBaseFactory.countUsingZipFile(codeBaseLocator, file);
            return abstractScannableCodeBase;
        }
        finally {
            profiler.end(ZipCodeBaseFactory.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractScannableCodeBase countUsingZipInputStream(ICodeBaseLocator codeBaseLocator, File file) throws IOException, FileNotFoundException {
        int zipEntries;
        long size = file.length();
        long estimatedEntries = size / 2000L;
        if (estimatedEntries < 20000L) {
            return new ZipFileCodeBase(codeBaseLocator, file);
        }
        ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            ZipEntry e;
            for (zipEntries = 0; (e = in.getNextEntry()) != null && zipEntries < 30010; ++zipEntries) {
            }
        }
        finally {
            in.close();
        }
        if (zipEntries < 30010) {
            return new ZipFileCodeBase(codeBaseLocator, file);
        }
        return new ZipInputStreamCodeBase(codeBaseLocator, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractScannableCodeBase countUsingZipFile(ICodeBaseLocator codeBaseLocator, File file) throws IOException, ZipException {
        int zipEntries;
        long size = file.length();
        long estimatedEntries = size / 2000L;
        if (estimatedEntries < 20000L) {
            return new ZipFileCodeBase(codeBaseLocator, file);
        }
        ZipFile in = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> e = in.entries();
            for (zipEntries = 0; e.hasMoreElements() && zipEntries < 30010; ++zipEntries) {
                e.nextElement();
            }
        }
        finally {
            in.close();
        }
        if (zipEntries < 30010) {
            return new ZipFileCodeBase(codeBaseLocator, file);
        }
        return new ZipInputStreamCodeBase(codeBaseLocator, file);
    }
}

